/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.layout;

import java.util.WeakHashMap;
import javafx.collections.ListChangeListener;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Priority;
import jfxtras.scene.layout.GenericLayoutConstraints;

public class GridPane
extends javafx.scene.layout.GridPane {
    private WeakHashMap<Node, C> cMap = new WeakHashMap();

    public GridPane() {
        this.construct();
    }

    private void construct() {
        this.getChildren().addListener((ListChangeListener)new ListChangeListener<Node>(){

            public void onChanged(ListChangeListener.Change<? extends Node> changes) {
                while (changes.next()) {
                    for (Node lNode : changes.getAddedSubList()) {
                        C lC = (C)GridPane.this.cMap.get(lNode);
                        if (lC == null) continue;
                        lC.apply(lNode);
                    }
                }
            }
        });
    }

    public GridPane withHGap(double value) {
        super.setHgap(value);
        return this;
    }

    public GridPane withVGap(double value) {
        super.setVgap(value);
        return this;
    }

    public GridPane withPadding(Insets value) {
        super.setPadding(value);
        return this;
    }

    public GridPane withGridLinesVisible(boolean value) {
        super.setGridLinesVisible(value);
        return this;
    }

    public GridPane add(Node node) {
        this.getChildren().add((Object)node);
        return this;
    }

    public GridPane add(Node node, C c) {
        this.cMap.put(node, c);
        c.rememberResetValues(node);
        this.getChildren().add((Object)node);
        return this;
    }

    public GridPane remove(Node node) {
        this.getChildren().remove((Object)node);
        this.cMap.remove(node);
        return this;
    }

    public void setConstraint(Node node, C c) {
        this.cMap.put(node, c);
        c.rememberResetValues(node);
    }

    public void removeConstraintsFor(Node node) {
        this.cMap.remove(node);
    }

    public void removeNode(Node node) {
        this.getChildren().remove((Object)node);
    }

    public static class C
    extends GenericLayoutConstraints.C<C> {
        private int row = -1;
        private int col = -1;
        private int rowSpan = 1;
        private int colSpan = 1;
        private Insets margin = null;
        private Insets marginReset = null;
        private HPos halignment = null;
        private HPos halignmentReset = null;
        private Priority hgrow = null;
        private Priority hgrowReset = null;
        private VPos valignment = null;
        private VPos valignmentReset = null;
        private Priority vgrow = null;
        private Priority vgrowReset = null;

        public C row(int value) {
            this.row = value;
            return this;
        }

        public C col(int value) {
            this.col = value;
            return this;
        }

        public C rowSpan(int value) {
            this.rowSpan = value;
            return this;
        }

        public C colSpan(int value) {
            this.colSpan = value;
            return this;
        }

        public C margin(Insets value) {
            this.margin = value;
            return this;
        }

        public C halignment(HPos value) {
            this.halignment = value;
            return this;
        }

        public C hgrow(Priority value) {
            this.hgrow = value;
            return this;
        }

        public C valignment(VPos value) {
            this.valignment = value;
            return this;
        }

        public C vgrow(Priority value) {
            this.vgrow = value;
            return this;
        }

        @Override
        protected void rememberResetValues(Node node) {
            super.rememberResetValues(node);
            this.marginReset = javafx.scene.layout.GridPane.getMargin((Node)node);
            this.halignmentReset = javafx.scene.layout.GridPane.getHalignment((Node)node);
            this.hgrowReset = javafx.scene.layout.GridPane.getHgrow((Node)node);
            this.valignmentReset = javafx.scene.layout.GridPane.getValignment((Node)node);
            this.vgrowReset = javafx.scene.layout.GridPane.getVgrow((Node)node);
        }

        @Override
        protected void apply(Node node) {
            super.apply(node);
            if (this.row < 0) {
                throw new IllegalArgumentException("You must set the row index");
            }
            javafx.scene.layout.GridPane.setRowIndex((Node)node, (Integer)this.row);
            if (this.col < 0) {
                throw new IllegalArgumentException("You must set the col index");
            }
            javafx.scene.layout.GridPane.setColumnIndex((Node)node, (Integer)this.col);
            javafx.scene.layout.GridPane.setRowSpan((Node)node, (Integer)this.rowSpan);
            javafx.scene.layout.GridPane.setColumnSpan((Node)node, (Integer)this.colSpan);
            javafx.scene.layout.GridPane.setMargin((Node)node, (Insets)(this.margin != null ? this.margin : this.marginReset));
            if (this.hgrow != null) {
                GenericLayoutConstraints.overrideMaxWidth(node, this);
            }
            javafx.scene.layout.GridPane.setHalignment((Node)node, (HPos)(this.halignment != null ? this.halignment : this.halignmentReset));
            javafx.scene.layout.GridPane.setHgrow((Node)node, (Priority)(this.hgrow != null ? this.hgrow : this.hgrowReset));
            javafx.scene.layout.GridPane.setValignment((Node)node, (VPos)(this.valignment != null ? this.valignment : this.valignmentReset));
            if (this.vgrow != null) {
                GenericLayoutConstraints.overrideMaxHeight(node, this);
            }
            javafx.scene.layout.GridPane.setVgrow((Node)node, (Priority)(this.vgrow != null ? this.vgrow : this.vgrowReset));
        }
    }
}

