/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin;

import com.sun.javafx.css.converters.EnumConverter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.Priority;
import javafx.util.Callback;
import jfxtras.css.converters.SimpleDateFormatConverter;
import jfxtras.internal.scene.control.skin.CalendarPickerMonthlySkinAbstract;
import jfxtras.scene.control.CalendarPicker;
import jfxtras.scene.control.CalendarTimePicker;
import jfxtras.scene.control.ListSpinner;
import jfxtras.scene.control.ListSpinnerIntegerList;
import jfxtras.scene.layout.GridPane;

public class CalendarPickerControlSkin
extends CalendarPickerMonthlySkinAbstract<CalendarPickerControlSkin> {
    private ObjectProperty<ShowWeeknumbers> showWeeknumbers = null;
    private static final ShowWeeknumbers SHOW_WEEKNUMBERS_DEFAULT = ShowWeeknumbers.YES;
    private ObjectProperty<DateFormat> labelDateFormat = null;
    private static final SimpleDateFormat LABEL_DATEFORMAT_DEFAULT = new SimpleDateFormat("d");
    private static final SimpleDateFormat ID_DATEFORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private ListSpinner<String> monthListSpinner = null;
    private ListSpinner<Integer> yearListSpinner = null;
    private Label todayLabel = new Label("   ");
    private final List<Label> weekdayLabels = new ArrayList<Label>();
    private final List<Label> weeknumberLabels = new ArrayList<Label>();
    private final List<ToggleButton> dayButtons = new ArrayList<ToggleButton>();
    private final CalendarTimePicker timePicker = new CalendarTimePicker();
    private final Map<BooleanProperty, ToggleButton> booleanPropertyToDayToggleButtonMap = new WeakHashMap<BooleanProperty, ToggleButton>();
    private final ChangeListener<Boolean> toggleButtonSelectedPropertyChangeListener = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> observableValue, Boolean oldValue, Boolean newValue) {
            CalendarPickerControlSkin.this.refreshDayButtonToggleState();
        }
    };
    private final EventHandler<MouseEvent> toggleButtonMouseReleasedPropertyEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            ToggleButton lToggleButton = (ToggleButton)event.getSource();
            CalendarPickerControlSkin.this.toggle(lToggleButton, event.isShiftDown());
        }
    };
    private final EventHandler<KeyEvent> toggleButtonKeyReleasedPropertyEventHandler = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent event) {
            ToggleButton lToggleButton = (ToggleButton)event.getSource();
            if (" ".equals(event.getText())) {
                CalendarPickerControlSkin.this.toggle(lToggleButton, event.isShiftDown());
            }
        }
    };
    private final EventHandler<MouseEvent> weekdayLabelMouseClickedPropertyEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (((CalendarPicker)CalendarPickerControlSkin.this.getSkinnable()).getMode() == CalendarPicker.Mode.SINGLE) {
                return;
            }
            if (((CalendarPicker)CalendarPickerControlSkin.this.getSkinnable()).getMode() == CalendarPicker.Mode.RANGE) {
                return;
            }
            int lColIdx = (Integer)((Label)event.getSource()).getUserData();
            for (int lRowIdx = 0; lRowIdx < 6; ++lRowIdx) {
                int lIdx = lRowIdx * 7 + lColIdx;
                ToggleButton lToggleButton = (ToggleButton)CalendarPickerControlSkin.this.dayButtons.get(lIdx);
                if (!lToggleButton.isVisible()) continue;
                CalendarPickerControlSkin.this.toggle(lToggleButton, false);
            }
        }
    };
    private final EventHandler<MouseEvent> weeknumerLabelMouseClickedPropertyEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (((CalendarPicker)CalendarPickerControlSkin.this.getSkinnable()).getMode() == CalendarPicker.Mode.SINGLE) {
                return;
            }
            if (((CalendarPicker)CalendarPickerControlSkin.this.getSkinnable()).getMode() == CalendarPicker.Mode.RANGE) {
                ((CalendarPicker)CalendarPickerControlSkin.this.getSkinnable()).calendars().clear();
            }
            int lRowIdx = (Integer)((Label)event.getSource()).getUserData();
            for (int i = lRowIdx * 7; i < lRowIdx * 7 + 7; ++i) {
                ToggleButton lToggleButton = (ToggleButton)CalendarPickerControlSkin.this.dayButtons.get(i);
                if (((CalendarPicker)CalendarPickerControlSkin.this.getSkinnable()).getMode() == CalendarPicker.Mode.RANGE) {
                    Calendar lCalendar = CalendarPickerControlSkin.this.calendarForToggleButton(lToggleButton);
                    if (!CalendarPickerControlSkin.this.callValueValidationCallback(lCalendar)) continue;
                    ((CalendarPicker)CalendarPickerControlSkin.this.getSkinnable()).calendars().add((Object)lCalendar);
                    continue;
                }
                CalendarPickerControlSkin.this.toggle(lToggleButton, false);
            }
        }
    };
    private Calendar iLastSelected = null;
    private final AtomicInteger iRefreshingSelection = new AtomicInteger(0);

    public CalendarPickerControlSkin(CalendarPicker control) {
        super(control);
        this.construct();
    }

    private void construct() {
        this.createNodes();
        this.layoutNodes();
        ((CalendarPicker)this.getSkinnable()).calendarProperty().addListener(observable -> {
            if (((CalendarPicker)this.getSkinnable()).getCalendar() != null) {
                ((CalendarPicker)this.getSkinnable()).setDisplayedCalendar(((CalendarPicker)this.getSkinnable()).getCalendar());
            }
        });
        if (((CalendarPicker)this.getSkinnable()).getCalendar() != null) {
            ((CalendarPicker)this.getSkinnable()).setDisplayedCalendar(((CalendarPicker)this.getSkinnable()).getCalendar());
        }
        ((CalendarPicker)this.getSkinnable()).calendars().addListener(observable -> this.refreshDayButtonToggleState());
        ((CalendarPicker)this.getSkinnable()).localeProperty().addListener(observable -> {
            this.monthListSpinner.setItems((ObservableList<String>)FXCollections.observableArrayList(this.getMonthLabels()));
            ((CalendarPicker)this.getSkinnable()).displayedCalendar().set((Object)((Calendar)((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().clone()));
            this.refresh();
        });
        ((CalendarPicker)this.getSkinnable()).showTimeProperty().addListener(observable -> this.layoutNodes());
        ((CalendarPicker)this.getSkinnable()).disabledCalendars().addListener((ListChangeListener)new ListChangeListener<Calendar>(){

            public void onChanged(ListChangeListener.Change<? extends Calendar> change) {
                CalendarPickerControlSkin.this.refreshDayButtonsVisibilityAndLabel();
            }
        });
        ((CalendarPicker)this.getSkinnable()).highlightedCalendars().addListener((ListChangeListener)new ListChangeListener<Calendar>(){

            public void onChanged(ListChangeListener.Change<? extends Calendar> arg0) {
                CalendarPickerControlSkin.this.refreshDayButtonsVisibilityAndLabel();
            }
        });
        ((CalendarPicker)this.getSkinnable()).displayedCalendar().addListener(observable -> this.refresh());
        this.refresh();
    }

    @Override
    protected Calendar deriveDisplayedCalendar(Calendar displayedCalendar) {
        Calendar lCalendar = Calendar.getInstance(((CalendarPicker)this.getSkinnable()).getLocale());
        lCalendar.set(5, 1);
        lCalendar.set(2, displayedCalendar.get(2));
        lCalendar.set(1, displayedCalendar.get(1));
        lCalendar.set(11, 0);
        lCalendar.set(12, 0);
        lCalendar.set(13, 0);
        lCalendar.set(14, 0);
        return lCalendar;
    }

    public final ObjectProperty<ShowWeeknumbers> showWeeknumbersProperty() {
        if (this.showWeeknumbers == null) {
            this.showWeeknumbers = new StyleableObjectProperty<ShowWeeknumbers>(SHOW_WEEKNUMBERS_DEFAULT){

                public void invalidated() {
                    CalendarPickerControlSkin.this.layoutNodes();
                }

                public CssMetaData<CalendarPicker, ShowWeeknumbers> getCssMetaData() {
                    return StyleableProperties.SHOW_WEEKNUMBERS;
                }

                public Object getBean() {
                    return CalendarPickerControlSkin.this;
                }

                public String getName() {
                    return "showWeeknumbers";
                }
            };
        }
        return this.showWeeknumbers;
    }

    public final void setShowWeeknumbers(ShowWeeknumbers value) {
        this.showWeeknumbersProperty().set((Object)value);
    }

    public final ShowWeeknumbers getShowWeeknumbers() {
        return this.showWeeknumbers == null ? SHOW_WEEKNUMBERS_DEFAULT : (ShowWeeknumbers)((Object)this.showWeeknumbers.get());
    }

    public final CalendarPickerControlSkin withShowWeeknumbers(ShowWeeknumbers value) {
        this.setShowWeeknumbers(value);
        return this;
    }

    public final ObjectProperty<DateFormat> labelDateFormatProperty() {
        if (this.labelDateFormat == null) {
            this.labelDateFormat = new StyleableObjectProperty<DateFormat>((DateFormat)LABEL_DATEFORMAT_DEFAULT){

                public void invalidated() {
                    CalendarPickerControlSkin.this.refreshDayButtonsVisibilityAndLabel();
                }

                public CssMetaData<CalendarPicker, DateFormat> getCssMetaData() {
                    return StyleableProperties.LABEL_DATEFORMAT;
                }

                public Object getBean() {
                    return CalendarPickerControlSkin.this;
                }

                public String getName() {
                    return "labelDateFormat";
                }
            };
        }
        return this.labelDateFormat;
    }

    public final void setLabelDateFormat(DateFormat value) {
        this.labelDateFormatProperty().set((Object)value);
    }

    public final DateFormat getLabelDateFormat() {
        return this.labelDateFormat == null ? LABEL_DATEFORMAT_DEFAULT : (DateFormat)this.labelDateFormat.get();
    }

    public final CalendarPickerControlSkin withLabelDateFormat(DateFormat value) {
        this.setLabelDateFormat(value);
        return this;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return CalendarPickerControlSkin.getClassCssMetaData();
    }

    private void createNodes() {
        Label lLabel;
        int i;
        ColumnConstraints lColumnConstraintsAlwaysGrow = new ColumnConstraints();
        lColumnConstraintsAlwaysGrow.setHgrow(Priority.ALWAYS);
        ColumnConstraints lColumnConstraintsNeverGrow = new ColumnConstraints();
        lColumnConstraintsNeverGrow.setHgrow(Priority.NEVER);
        List<String> lMonthLabels = this.getMonthLabels();
        this.monthListSpinner = new ListSpinner<String>(lMonthLabels).withIndex(Calendar.getInstance().get(2)).withCyclic(Boolean.TRUE);
        this.monthListSpinner.setId("monthListSpinner");
        this.monthListSpinner.setOnCycle(new EventHandler<ListSpinner.CycleEvent>(){

            public void handle(ListSpinner.CycleEvent evt) {
                if (evt.cycledDown()) {
                    CalendarPickerControlSkin.this.yearListSpinner.increment();
                } else {
                    CalendarPickerControlSkin.this.yearListSpinner.decrement();
                }
            }
        });
        this.monthListSpinner.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue arg0, String arg1, String arg2) {
                CalendarPickerControlSkin.this.setDisplayedCalendarFromSpinners();
            }
        });
        this.yearListSpinner = new ListSpinner<Integer>(new ListSpinnerIntegerList()).withValue(Calendar.getInstance().get(1));
        this.yearListSpinner.setId("yearListSpinner");
        this.yearListSpinner.valueProperty().addListener((ChangeListener)new ChangeListener<Integer>(){

            public void changed(ObservableValue observableValue, Integer oldValue, Integer newValue) {
                CalendarPickerControlSkin.this.setDisplayedCalendarFromSpinners();
            }
        });
        this.todayLabel = new Label("   ");
        this.todayLabel.onMouseClickedProperty().set((Object)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getClickCount() < 1) {
                    return;
                }
                CalendarPickerControlSkin.this.setDisplayedCalendarToToday();
            }
        });
        for (i = 0; i < 7; ++i) {
            lLabel = new Label("" + i);
            lLabel.getStyleClass().add((Object)"weekday-label");
            lLabel.setMaxWidth(2.147483647E9);
            lLabel.setUserData((Object)i);
            lLabel.onMouseClickedProperty().set(this.weekdayLabelMouseClickedPropertyEventHandler);
            this.weekdayLabels.add(lLabel);
        }
        for (i = 0; i < 6; ++i) {
            lLabel = new Label("" + i);
            lLabel.getStyleClass().add((Object)"weeknumber");
            lLabel.setAlignment(Pos.BASELINE_RIGHT);
            this.weeknumberLabels.add(lLabel);
            lLabel.setUserData((Object)i);
            lLabel.onMouseClickedProperty().set(this.weeknumerLabelMouseClickedPropertyEventHandler);
        }
        for (i = 0; i < 42; ++i) {
            ToggleButton lToggleButton = new ToggleButton("" + i);
            lToggleButton.setId("day" + i);
            lToggleButton.getStyleClass().add((Object)"day-button");
            lToggleButton.selectedProperty().addListener(this.toggleButtonSelectedPropertyChangeListener);
            lToggleButton.onMouseReleasedProperty().set(this.toggleButtonMouseReleasedPropertyEventHandler);
            lToggleButton.onKeyReleasedProperty().set(this.toggleButtonKeyReleasedPropertyEventHandler);
            this.booleanPropertyToDayToggleButtonMap.put(lToggleButton.selectedProperty(), lToggleButton);
            lToggleButton.setMaxWidth(Double.MAX_VALUE);
            lToggleButton.setAlignment(Pos.BASELINE_CENTER);
            this.dayButtons.add(lToggleButton);
        }
        Bindings.bindBidirectional(this.timePicker.calendarProperty(), ((CalendarPicker)this.getSkinnable()).calendarProperty());
        Bindings.bindBidirectional(this.timePicker.valueValidationCallbackProperty(), ((CalendarPicker)this.getSkinnable()).valueValidationCallbackProperty());
        Bindings.bindBidirectional(this.timePicker.localeProperty(), ((CalendarPicker)this.getSkinnable()).localeProperty());
        ((CalendarPicker)this.getSkinnable()).getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
    }

    private void layoutNodes() {
        int i;
        this.getChildren().clear();
        GridPane gridPane = new GridPane();
        gridPane = new GridPane();
        gridPane.setVgap(2.0);
        gridPane.setHgap(2.0);
        this.getChildren().add((Object)gridPane);
        boolean lShowWeeknumbers = ShowWeeknumbers.YES.equals((Object)this.getShowWeeknumbers());
        int lWeeknumbersCols = lShowWeeknumbers ? 1 : 0;
        ColumnConstraints lColumnConstraintsAlwaysGrow = new ColumnConstraints();
        lColumnConstraintsAlwaysGrow.setHgrow(Priority.ALWAYS);
        ColumnConstraints lColumnConstraintsNeverGrow = new ColumnConstraints();
        lColumnConstraintsNeverGrow.setHgrow(Priority.NEVER);
        if (lShowWeeknumbers) {
            gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{lColumnConstraintsNeverGrow});
        }
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{lColumnConstraintsAlwaysGrow, lColumnConstraintsAlwaysGrow, lColumnConstraintsAlwaysGrow, lColumnConstraintsAlwaysGrow, lColumnConstraintsAlwaysGrow, lColumnConstraintsAlwaysGrow, lColumnConstraintsAlwaysGrow});
        gridPane.add(this.monthListSpinner, new GridPane.C().col(lWeeknumbersCols).row(0).colSpan(4).rowSpan(1));
        gridPane.add(this.yearListSpinner, new GridPane.C().col(lWeeknumbersCols + 4).row(0).colSpan(3).rowSpan(1));
        if (lShowWeeknumbers) {
            gridPane.add((Node)this.todayLabel, new GridPane.C().col(0).row(1));
        }
        for (i = 0; i < 7; ++i) {
            gridPane.add((Node)this.weekdayLabels.get(i), new GridPane.C().col(lWeeknumbersCols + i).row(1));
        }
        if (lShowWeeknumbers) {
            for (i = 0; i < 6; ++i) {
                gridPane.add((Node)this.weeknumberLabels.get(i), new GridPane.C().col(0).row(i + 2).margin(new Insets(0.0, 0.0, 0.0, 0.0)));
            }
        }
        for (i = 0; i < 42; ++i) {
            gridPane.add((Node)this.dayButtons.get(i), new GridPane.C().col(lWeeknumbersCols + i % 7).row(i / 7 + 2));
        }
        if (((CalendarPicker)this.getSkinnable()).getMode().equals((Object)CalendarPicker.Mode.SINGLE) && ((Boolean)((CalendarPicker)this.getSkinnable()).showTimeProperty().get()).booleanValue()) {
            gridPane.add((Node)this.timePicker, new GridPane.C().col(lWeeknumbersCols).row(8).colSpan(7).rowSpan(1));
        }
    }

    private Calendar calendarForToggleButton(ToggleButton toggleButton) {
        int lDayToggleButtonIdx = this.dayButtons.indexOf(toggleButton);
        int lFirstOfMonthIdx = this.determineFirstOfMonthDayOfWeek();
        int lDayOfMonth = lDayToggleButtonIdx - lFirstOfMonthIdx + 1;
        Calendar lToggledCalendar = (Calendar)((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().clone();
        lToggledCalendar.set(1, ((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().get(1));
        lToggledCalendar.set(2, ((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().get(2));
        lToggledCalendar.set(5, lDayOfMonth);
        if (this.timePicker.isVisible() && this.timePicker.getCalendar() != null) {
            lToggledCalendar.set(11, this.timePicker.getCalendar().get(11));
            lToggledCalendar.set(12, this.timePicker.getCalendar().get(12));
            lToggledCalendar.set(13, this.timePicker.getCalendar().get(13));
        }
        return lToggledCalendar;
    }

    private void toggle(ToggleButton toggleButton, boolean shiftIsPressed) {
        Calendar lToggledCalendar = this.calendarForToggleButton(toggleButton);
        ObservableList<Calendar> lCalendars = ((CalendarPicker)this.getSkinnable()).calendars();
        Calendar lFoundCalendar = this.find((List<Calendar>)lCalendars, lToggledCalendar);
        if (lFoundCalendar == null) {
            if ((((CalendarPicker)this.getSkinnable()).getMode() == CalendarPicker.Mode.SINGLE || ((CalendarPicker)this.getSkinnable()).getMode() == CalendarPicker.Mode.RANGE && !shiftIsPressed) && this.callValueValidationCallback(lToggledCalendar)) {
                lCalendars.add(lToggledCalendar);
                while (lCalendars.size() > 1) {
                    lCalendars.remove(0);
                }
            }
            if (((CalendarPicker)this.getSkinnable()).getMode() == CalendarPicker.Mode.MULTIPLE && !shiftIsPressed && this.callValueValidationCallback(lToggledCalendar)) {
                lCalendars.add(lToggledCalendar);
            }
            if ((((CalendarPicker)this.getSkinnable()).getMode() == CalendarPicker.Mode.MULTIPLE || ((CalendarPicker)this.getSkinnable()).getMode() == CalendarPicker.Mode.RANGE) && shiftIsPressed && this.iLastSelected != null) {
                Calendar lOtherCalendar = this.iLastSelected;
                int lDirection = lOtherCalendar.after(lToggledCalendar) ? -1 : 1;
                Calendar lWalker = (Calendar)lOtherCalendar.clone();
                lWalker.add(5, lDirection);
                Calendar lTarget = (Calendar)lToggledCalendar.clone();
                lTarget.add(5, lDirection);
                while (!lWalker.equals(lTarget)) {
                    if (this.callValueValidationCallback(lWalker)) {
                        lCalendars.add((Calendar)lWalker.clone());
                    } else if (((CalendarPicker)this.getSkinnable()).getMode() == CalendarPicker.Mode.RANGE) break;
                    lWalker.add(5, lDirection);
                }
            }
            this.iLastSelected = (Calendar)lToggledCalendar.clone();
        } else {
            Calendar lCalendar;
            if (lCalendars.size() == 1 && !((CalendarPicker)this.getSkinnable()).getAllowNull() && this.callValueValidationCallback(lCalendar = (Calendar)lFoundCalendar.clone())) {
                ((CalendarPicker)this.getSkinnable()).setCalendar(lCalendar);
            }
            if (lCalendars.size() > 1 || ((CalendarPicker)this.getSkinnable()).getAllowNull()) {
                lCalendars.remove(lFoundCalendar);
                this.iLastSelected = null;
            }
        }
        this.refreshDayButtonToggleState();
    }

    private void setDisplayedCalendarFromSpinners() {
        int lYear = this.yearListSpinner.getValue();
        int lMonth = this.monthListSpinner.getIndex();
        Calendar lCalendar = (Calendar)((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().clone();
        lCalendar.set(1, lYear);
        lCalendar.set(2, lMonth);
        ((CalendarPicker)this.getSkinnable()).setDisplayedCalendar(lCalendar);
    }

    private void setDisplayedCalendarToToday() {
        Calendar lTodayCalendar = Calendar.getInstance();
        Calendar lCalendar = (Calendar)((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().clone();
        lCalendar.set(1, lTodayCalendar.get(1));
        lCalendar.set(2, lTodayCalendar.get(2));
        ((CalendarPicker)this.getSkinnable()).setDisplayedCalendar(lCalendar);
    }

    @Override
    protected void refresh() {
        this.calendarRangeCallback();
        this.refreshSpinner();
        this.refreshWeekdayLabels();
        this.refreshWeeknumberLabels();
        this.refreshDayButtonsVisibilityAndLabel();
        this.refreshDayButtonToggleState();
    }

    private void refreshSpinner() {
        if (this.calendarRangeCallbackAtomicInteger.get() != 0) {
            return;
        }
        Calendar lCalendar = ((CalendarPicker)this.getSkinnable()).getDisplayedCalendar();
        List<String> lMonthLabels = this.getMonthLabels();
        String lMonthLabel = lMonthLabels.get(lCalendar.get(2));
        this.monthListSpinner.setValue(lMonthLabel);
        this.yearListSpinner.setValue(lCalendar.get(1));
    }

    private void refreshWeekdayLabels() {
        if (this.calendarRangeCallbackAtomicInteger.get() != 0) {
            return;
        }
        List<String> lWeekdayLabels = this.getWeekdayLabels();
        for (int i = 0; i < this.weekdayLabels.size(); ++i) {
            Label lLabel = this.weekdayLabels.get(i);
            lLabel.setText(lWeekdayLabels.get(i));
            lLabel.getStyleClass().removeAll((Object[])new String[]{"weekend", "weekday"});
            lLabel.getStyleClass().add((Object)(this.isWeekdayWeekend(i) ? "weekend" : "weekday"));
        }
    }

    private void refreshWeeknumberLabels() {
        if (this.calendarRangeCallbackAtomicInteger.get() != 0) {
            return;
        }
        List<Integer> lWeeknumbers = this.getWeeknumbers();
        for (int i = 0; i < lWeeknumbers.size(); ++i) {
            Label lLabel = this.weeknumberLabels.get(i);
            lLabel.setText((lWeeknumbers.get(i) < 10 ? "0" : "") + lWeeknumbers.get(i).toString());
        }
    }

    private void refreshDayButtonsVisibilityAndLabel() {
        int i;
        int i2;
        if (this.calendarRangeCallbackAtomicInteger.get() != 0) {
            return;
        }
        ObservableList<Calendar> highlightedCalendars = ((CalendarPicker)this.getSkinnable()).highlightedCalendars();
        ObservableList<Calendar> disabledCalendars = ((CalendarPicker)this.getSkinnable()).disabledCalendars();
        int lFirstOfMonthIdx = this.determineFirstOfMonthDayOfWeek();
        for (i2 = 0; i2 < lFirstOfMonthIdx; ++i2) {
            ToggleButton lToggleButton = this.dayButtons.get(i2);
            lToggleButton.setVisible(false);
            lToggleButton.setId("day" + i2);
        }
        for (i2 = 1; i2 < 6; ++i2) {
            this.weeknumberLabels.get(i2).setVisible(false);
        }
        int lDaysInMonth = this.determineDaysInMonth();
        Calendar lCalendar = (Calendar)((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().clone();
        for (i = 1; i <= lDaysInMonth; ++i) {
            lCalendar.set(5, i);
            int lIdx = lFirstOfMonthIdx + i - 1;
            ToggleButton lToggleButton = this.dayButtons.get(lIdx);
            lToggleButton.setId(ID_DATEFORMAT.format(lCalendar.getTime()));
            lToggleButton.setVisible(true);
            lToggleButton.setText(this.getLabelDateFormat().format(lCalendar.getTime()));
            lToggleButton.setAlignment(Pos.BASELINE_CENTER);
            lToggleButton.getStyleClass().removeAll((Object[])new String[]{"weekend", "weekday"});
            lToggleButton.getStyleClass().add((Object)(this.isWeekdayWeekend(lIdx % 7) ? "weekend" : "weekday"));
            lToggleButton.setDisable(disabledCalendars != null && this.find((List<Calendar>)disabledCalendars, lCalendar) != null);
            this.weeknumberLabels.get(lIdx / 7).setVisible(true);
            lToggleButton.getStyleClass().remove((Object)"today");
            if (this.isToday(lCalendar)) {
                lToggleButton.getStyleClass().add((Object)"today");
            }
            lToggleButton.getStyleClass().remove((Object)"highlight");
            if (highlightedCalendars == null || this.find((List<Calendar>)highlightedCalendars, lCalendar) == null) continue;
            lToggleButton.getStyleClass().add((Object)"highlight");
        }
        for (i = lFirstOfMonthIdx + lDaysInMonth; i < 42; ++i) {
            ToggleButton lToggleButton = this.dayButtons.get(i);
            lToggleButton.setVisible(false);
            lToggleButton.setId("day" + i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshDayButtonToggleState() {
        if (this.calendarRangeCallbackAtomicInteger.get() != 0) {
            return;
        }
        this.iRefreshingSelection.addAndGet(1);
        try {
            int lFirstOfMonthIdx = this.determineFirstOfMonthDayOfWeek();
            ObservableList<Calendar> lCalendars = ((CalendarPicker)this.getSkinnable()).calendars();
            int lDaysInMonth = this.determineDaysInMonth();
            Calendar lCalendar = (Calendar)((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().clone();
            for (int i = 1; i <= lDaysInMonth; ++i) {
                lCalendar.set(5, i);
                int lIdx = lFirstOfMonthIdx + i - 1;
                boolean lSelected = this.find((List<Calendar>)lCalendars, lCalendar) != null;
                this.dayButtons.get(lIdx).setSelected(lSelected);
            }
        }
        finally {
            this.iRefreshingSelection.addAndGet(-1);
        }
    }

    private Calendar find(List<Calendar> calendars, Calendar calendar) {
        for (Calendar c : calendars) {
            if (c.get(1) != calendar.get(1) || c.get(2) != calendar.get(2) || c.get(5) != calendar.get(5)) continue;
            return c;
        }
        return null;
    }

    private boolean callValueValidationCallback(Calendar value) {
        Callback<Calendar, Boolean> lCallback = ((CalendarPicker)this.getSkinnable()).getValueValidationCallback();
        if (lCallback == null) {
            return true;
        }
        return (Boolean)lCallback.call(value == null ? null : (Calendar)value.clone());
    }

    static /* synthetic */ ShowWeeknumbers access$400() {
        return SHOW_WEEKNUMBERS_DEFAULT;
    }

    static /* synthetic */ SimpleDateFormat access$500() {
        return LABEL_DATEFORMAT_DEFAULT;
    }

    private static class StyleableProperties {
        private static final CssMetaData<CalendarPicker, ShowWeeknumbers> SHOW_WEEKNUMBERS = new CssMetaData<CalendarPicker, ShowWeeknumbers>("-fxx-show-weeknumbers", (StyleConverter)new EnumConverter(ShowWeeknumbers.class), CalendarPickerControlSkin.access$400()){

            public boolean isSettable(CalendarPicker n) {
                return !((CalendarPickerControlSkin)n.getSkin()).showWeeknumbersProperty().isBound();
            }

            public StyleableProperty<ShowWeeknumbers> getStyleableProperty(CalendarPicker n) {
                return (StyleableProperty)((CalendarPickerControlSkin)n.getSkin()).showWeeknumbersProperty();
            }
        };
        private static final CssMetaData<CalendarPicker, DateFormat> LABEL_DATEFORMAT = new CssMetaData<CalendarPicker, DateFormat>("-fxx-label-dateformat", (StyleConverter)new SimpleDateFormatConverter(), (DateFormat)CalendarPickerControlSkin.access$500()){

            public boolean isSettable(CalendarPicker n) {
                return !((CalendarPickerControlSkin)n.getSkin()).showWeeknumbersProperty().isBound();
            }

            public StyleableProperty<DateFormat> getStyleableProperty(CalendarPicker n) {
                return (StyleableProperty)((CalendarPickerControlSkin)n.getSkin()).labelDateFormatProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<Object> styleables = new ArrayList<Object>(SkinBase.getClassCssMetaData());
            styleables.add(SHOW_WEEKNUMBERS);
            styleables.add(LABEL_DATEFORMAT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    public static enum ShowWeeknumbers {
        YES,
        NO;

    }
}

