/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.util.Callback;
import jfxtras.scene.control.CalendarPicker;

public abstract class CalendarPickerMonthlySkinAbstract<S>
extends SkinBase<CalendarPicker> {
    private Calendar myDisplayedCalendar = null;
    private SimpleDateFormat simpleDateFormat = null;
    protected final AtomicInteger calendarRangeCallbackAtomicInteger = new AtomicInteger(0);
    private Calendar iToday = Calendar.getInstance();
    private int iTodayYear = this.iToday.get(1);
    private int iTodayMonth = this.iToday.get(2);
    private int iTodayDay = this.iToday.get(5);

    public CalendarPickerMonthlySkinAbstract(CalendarPicker control) {
        super((Control)control);
        this.construct();
    }

    private void construct() {
        ((CalendarPicker)this.getSkinnable()).localeProperty().addListener(observable -> this.refreshLocale());
        this.refreshLocale();
        this.derivedDisplayedCalendar();
        ((CalendarPicker)this.getSkinnable()).displayedCalendar().addListener(observable -> {
            Calendar lDisplayedCalendar = ((CalendarPicker)this.getSkinnable()).getDisplayedCalendar();
            if (this.myDisplayedCalendar == null && lDisplayedCalendar != null || !this.myDisplayedCalendar.equals(lDisplayedCalendar)) {
                this.derivedDisplayedCalendar();
                return;
            }
            this.refresh();
        });
    }

    private void derivedDisplayedCalendar() {
        Calendar lCalendar;
        Calendar lDisplayedCalendar = ((CalendarPicker)this.getSkinnable()).getDisplayedCalendar();
        this.myDisplayedCalendar = lCalendar = this.deriveDisplayedCalendar(lDisplayedCalendar);
        ((CalendarPicker)this.getSkinnable()).displayedCalendar().set((Object)lCalendar);
    }

    private void refreshLocale() {
        this.simpleDateFormat = (SimpleDateFormat)SimpleDateFormat.getDateInstance(1, ((CalendarPicker)this.getSkinnable()).getLocale());
    }

    protected abstract Calendar deriveDisplayedCalendar(Calendar var1);

    protected abstract void refresh();

    protected void calendarRangeCallback() {
        if (((CalendarPicker)this.getSkinnable()).calendarRangeCallbackProperty().get() != null) {
            Calendar lStartCalendar = this.periodStartCalendar();
            Calendar lEndCalendar = this.periodEndCalendar();
            try {
                this.calendarRangeCallbackAtomicInteger.incrementAndGet();
                ((Callback)((CalendarPicker)this.getSkinnable()).calendarRangeCallbackProperty().get()).call((Object)new CalendarPicker.CalendarRange(lStartCalendar, lEndCalendar));
            }
            finally {
                this.calendarRangeCallbackAtomicInteger.decrementAndGet();
            }
        }
    }

    protected Calendar periodStartCalendar() {
        return (Calendar)((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().clone();
    }

    protected Calendar periodEndCalendar() {
        Calendar lEndCalendar = (Calendar)((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().clone();
        lEndCalendar.add(2, 1);
        lEndCalendar.set(5, 1);
        lEndCalendar.add(5, -1);
        return lEndCalendar;
    }

    protected List<String> getWeekdayLabels() {
        ArrayList<String> lWeekdayLabels = new ArrayList<String>();
        this.simpleDateFormat.applyPattern("E");
        GregorianCalendar lCalendar = new GregorianCalendar(2009, 6, 5);
        for (int i = 0; i < 7; ++i) {
            lCalendar.set(5, 4 + ((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().getFirstDayOfWeek() + i);
            lWeekdayLabels.add(this.simpleDateFormat.format(lCalendar.getTime()));
        }
        return lWeekdayLabels;
    }

    protected List<Integer> getWeeknumbers() {
        ArrayList<Integer> lWeekLabels = new ArrayList<Integer>();
        Calendar lCalendar = (Calendar)((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().clone();
        for (int i = 0; i <= 5; ++i) {
            lWeekLabels.add(lCalendar.get(3));
            lCalendar.add(5, 7);
        }
        return lWeekLabels;
    }

    protected List<String> getMonthLabels() {
        ArrayList<String> lMonthLabels = new ArrayList<String>();
        this.simpleDateFormat.applyPattern("MMMM");
        GregorianCalendar lCalendar = new GregorianCalendar(2009, 0, 1);
        for (int i = 0; i < 12; ++i) {
            lCalendar.set(2, i);
            lMonthLabels.add(this.simpleDateFormat.format(lCalendar.getTime()));
        }
        return lMonthLabels;
    }

    protected boolean isWeekday(int idx, int weekdaynr) {
        GregorianCalendar lCalendar = new GregorianCalendar(2009, 6, 4 + ((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().getFirstDayOfWeek());
        ((Calendar)lCalendar).add(5, idx);
        int lDayOfWeek = lCalendar.get(7);
        return lDayOfWeek == weekdaynr;
    }

    protected boolean isWeekdayWeekend(int idx) {
        return this.isWeekday(idx, 7) || this.isWeekday(idx, 1);
    }

    protected int determineFirstOfMonthDayOfWeek() {
        int lFirstDayOfWeek = ((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().getFirstDayOfWeek();
        int lFirstOfMonthIdx = ((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().get(7) - lFirstDayOfWeek;
        if (lFirstOfMonthIdx < 0) {
            lFirstOfMonthIdx += 7;
        }
        return lFirstOfMonthIdx;
    }

    protected int determineDaysInMonth() {
        Calendar lCalendar = (Calendar)((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().clone();
        lCalendar.add(2, 1);
        lCalendar.set(5, 1);
        lCalendar.add(5, -1);
        return lCalendar.get(5);
    }

    protected boolean isToday(Calendar calendar) {
        int lYear = calendar.get(1);
        int lMonth = calendar.get(2);
        int lDay = calendar.get(5);
        return lYear == this.iTodayYear && lMonth == this.iTodayMonth && lDay == this.iTodayDay;
    }
}

