/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin;

import java.text.DateFormat;
import java.text.ParseException;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Popup;
import javafx.util.Callback;
import jfxtras.scene.control.CalendarPicker;
import jfxtras.scene.control.CalendarTextField;
import jfxtras.scene.control.ImageViewButton;
import jfxtras.scene.control.LocalDatePicker;
import jfxtras.scene.control.LocalDateTextField;
import jfxtras.scene.control.LocalDateTimePicker;
import jfxtras.scene.control.LocalDateTimeTextField;
import jfxtras.scene.layout.VBox;
import jfxtras.util.NodeUtil;

public class CalendarTextFieldSkin
extends SkinBase<CalendarTextField> {
    private TextField textField = null;
    private ImageView imageView = null;
    private GridPane gridPane = null;

    public CalendarTextFieldSkin(CalendarTextField control) {
        super((Control)control);
        this.construct();
    }

    private void construct() {
        this.createNodes();
        ((CalendarTextField)this.getSkinnable()).calendarProperty().addListener((observableValue, oldValue, newValue) -> this.refreshValue());
        ((CalendarTextField)this.getSkinnable()).dateFormatProperty().addListener((observableValue, oldValue, newValue) -> this.refreshValue());
        ((CalendarTextField)this.getSkinnable()).textProperty().addListener(observable -> this.parse(((CalendarTextField)this.getSkinnable()).getText()));
        this.refreshValue();
        this.initFocusSimulation();
    }

    private void refreshValue() {
        Calendar c = ((CalendarTextField)this.getSkinnable()).getCalendar();
        String s = c == null ? "" : ((CalendarTextField)this.getSkinnable()).getDateFormat().format(c.getTime());
        this.textField.setText(s);
        if (!s.equals(((CalendarTextField)this.getSkinnable()).getText())) {
            ((CalendarTextField)this.getSkinnable()).setText(s);
        }
    }

    private void initFocusSimulation() {
        ((CalendarTextField)this.getSkinnable()).focusedProperty().addListener((observableValue, wasFocused, isFocused) -> {
            if (isFocused.booleanValue()) {
                Platform.runLater(() -> this.textField.requestFocus());
            }
        });
    }

    private void createNodes() {
        this.textField = new TextField();
        this.textField.setPrefColumnCount(20);
        this.textField.focusedProperty().addListener(observable -> {
            if (!this.textField.isFocused()) {
                this.parse();
            }
        });
        this.textField.setOnAction(actionEvent -> this.parse());
        this.textField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.UP || keyEvent.getCode() == KeyCode.DOWN) {
                this.parse();
                Calendar lCalendar = ((CalendarTextField)this.getSkinnable()).getCalendar();
                if (lCalendar == null) {
                    return;
                }
                lCalendar = (Calendar)lCalendar.clone();
                int lField = 5;
                if (!keyEvent.isShiftDown() && keyEvent.isControlDown()) {
                    lField = 2;
                }
                if (!keyEvent.isShiftDown() && keyEvent.isAltDown()) {
                    lField = 1;
                }
                if (keyEvent.isShiftDown() && keyEvent.isControlDown() && ((CalendarTextField)this.getSkinnable()).getShowTime().booleanValue()) {
                    lField = 11;
                }
                if (keyEvent.isShiftDown() && keyEvent.isAltDown() && ((CalendarTextField)this.getSkinnable()).getShowTime().booleanValue()) {
                    lField = 12;
                }
                lCalendar.add(lField, keyEvent.getCode() == KeyCode.UP ? 1 : -1);
                ((CalendarTextField)this.getSkinnable()).setCalendar(lCalendar);
            }
        });
        this.textField.tooltipProperty().bindBidirectional((Property)((CalendarTextField)this.getSkinnable()).tooltipProperty());
        if (((CalendarTextField)this.getSkinnable()).getTooltip() == null) {
            ((CalendarTextField)this.getSkinnable()).setTooltip(new Tooltip("Type a date or use # for today, or +/-<number>[d|w|m|y] for delta's (for example: -3m for minus 3 months)\nUse cursor up and down plus optional shift (week), ctrl (month) or alt (year) for quick keyboard changes."));
        }
        this.textField.promptTextProperty().bind(((CalendarTextField)this.getSkinnable()).promptTextProperty());
        this.imageView = new ImageViewButton();
        this.imageView.getStyleClass().add((Object)"icon");
        this.imageView.setPickOnBounds(true);
        this.imageView.setOnMouseClicked(evt -> {
            if (this.textField.focusedProperty().get()) {
                this.parse();
            }
            this.showPopup((MouseEvent)evt);
        });
        this.gridPane = new GridPane();
        this.gridPane.setHgap(3.0);
        this.gridPane.add((Node)this.textField, 0, 0);
        this.gridPane.add((Node)this.imageView, 1, 0);
        ColumnConstraints column0 = new ColumnConstraints(100.0, 10.0, Double.MAX_VALUE);
        column0.setHgrow(Priority.ALWAYS);
        this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column0});
        ((CalendarTextField)this.getSkinnable()).getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
        this.getChildren().add((Object)this.gridPane);
    }

    private void parse() {
        this.parse(this.textField.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(String lText) {
        block19: {
            try {
                lText = lText.trim();
                if (lText.length() == 0) {
                    if (!((CalendarTextField)this.getSkinnable()).getAllowNull()) {
                        throw new IllegalArgumentException("Empty string would result in null and that is not allowed");
                    }
                    ((CalendarTextField)this.getSkinnable()).setCalendar(null);
                    return;
                }
                if (lText.startsWith("-") || lText.startsWith("+")) {
                    if (lText.startsWith("+")) {
                        lText = lText.substring(1);
                    }
                    int lUnit = 5;
                    if (lText.toLowerCase().endsWith("d")) {
                        lText = lText.substring(0, lText.length() - 1);
                        lUnit = 5;
                    }
                    if (lText.toLowerCase().endsWith("w")) {
                        lText = lText.substring(0, lText.length() - 1);
                        lUnit = 3;
                    }
                    if (lText.toLowerCase().endsWith("m")) {
                        lText = lText.substring(0, lText.length() - 1);
                        lUnit = 2;
                    }
                    if (lText.toLowerCase().endsWith("y")) {
                        lText = lText.substring(0, lText.length() - 1);
                        lUnit = 1;
                    }
                    int lDelta = Integer.parseInt(lText);
                    Calendar lCalendar = (Calendar)((CalendarTextField)this.getSkinnable()).getCalendar().clone();
                    lCalendar.add(lUnit, lDelta);
                    ((CalendarTextField)this.getSkinnable()).setCalendar(lCalendar);
                    break block19;
                }
                if (lText.equals("#")) {
                    ((CalendarTextField)this.getSkinnable()).setCalendar(Calendar.getInstance(((CalendarTextField)this.getSkinnable()).getLocale()));
                    break block19;
                }
                try {
                    Calendar lCalendar = ((CalendarTextField)this.getSkinnable()).getCalendar();
                    Date lDate = null;
                    for (DateFormat lDateFormat : ((CalendarTextField)this.getSkinnable()).getDateFormats()) {
                        try {
                            lDate = lDateFormat.parse(lText);
                            break;
                        }
                        catch (ParseException | DateTimeParseException e2) {
                        }
                    }
                    if (lDate == null) {
                        lDate = ((CalendarTextField)this.getSkinnable()).getDateFormat().parse(lText);
                    }
                    lCalendar = Calendar.getInstance(((CalendarTextField)this.getSkinnable()).getLocale());
                    lCalendar.setTime(lDate);
                    ((CalendarTextField)this.getSkinnable()).setCalendar(lCalendar);
                }
                finally {
                    this.refreshValue();
                }
            }
            catch (Throwable t) {
                if (((CalendarTextField)this.getSkinnable()).getParseErrorCallback() != null) {
                    ((CalendarTextField)this.getSkinnable()).getParseErrorCallback().call((Object)t);
                }
                t.printStackTrace();
            }
        }
    }

    private void showPopup(MouseEvent evt) {
        CalendarPicker calendarPicker = new CalendarPicker();
        calendarPicker.setMode(CalendarPicker.Mode.SINGLE);
        calendarPicker.localeProperty().set(((CalendarTextField)this.getSkinnable()).localeProperty().get());
        calendarPicker.allowNullProperty().set(((CalendarTextField)this.getSkinnable()).allowNullProperty().get());
        calendarPicker.calendarProperty().set(((CalendarTextField)this.getSkinnable()).calendarProperty().get());
        calendarPicker.disabledCalendars().addAll(((CalendarTextField)this.getSkinnable()).disabledCalendars());
        calendarPicker.highlightedCalendars().addAll(((CalendarTextField)this.getSkinnable()).highlightedCalendars());
        calendarPicker.setCalendarRangeCallback(new Callback<CalendarPicker.CalendarRange, Void>(){

            public Void call(CalendarPicker.CalendarRange calendarRange) {
                Callback<CalendarPicker.CalendarRange, Void> lCallback = ((CalendarTextField)CalendarTextFieldSkin.this.getSkinnable()).getCalendarRangeCallback();
                if (lCallback == null) {
                    return null;
                }
                return (Void)lCallback.call((Object)calendarRange);
            }
        });
        Popup lPopup = new Popup();
        lPopup.setAutoFix(true);
        lPopup.setAutoHide(true);
        lPopup.setHideOnEscape(true);
        BorderPane lBorderPane = new BorderPane();
        lBorderPane.getStyleClass().add((Object)(((Object)((Object)this)).getClass().getSimpleName() + "_popup"));
        lBorderPane.setCenter((Node)calendarPicker);
        calendarPicker.showTimeProperty().set((Object)((CalendarTextField)this.getSkinnable()).getShowTime());
        if (((CalendarTextField)this.getSkinnable()).getStyleClass().contains((Object)LocalDateTextField.class.getSimpleName())) {
            calendarPicker.getStyleClass().addAll((Object[])new String[]{LocalDatePicker.class.getSimpleName()});
        }
        if (((CalendarTextField)this.getSkinnable()).getStyleClass().contains((Object)LocalDateTimeTextField.class.getSimpleName())) {
            calendarPicker.getStyleClass().addAll((Object[])new String[]{LocalDateTimePicker.class.getSimpleName()});
        }
        if (((CalendarTextField)this.getSkinnable()).getShowTime().booleanValue()) {
            VBox lVBox = new VBox();
            lBorderPane.rightProperty().set((Object)lVBox);
            ImageViewButton lAcceptIconImageView = new ImageViewButton();
            lAcceptIconImageView.getStyleClass().addAll((Object[])new String[]{"accept-icon"});
            lAcceptIconImageView.setPickOnBounds(true);
            lAcceptIconImageView.setOnMouseClicked(mouseEvent -> {
                ((CalendarTextField)this.getSkinnable()).calendarProperty().set(calendarPicker.calendarProperty().get());
                lPopup.hide();
            });
            lVBox.add((Node)lAcceptIconImageView);
            ImageViewButton lCloseIconImageView = new ImageViewButton();
            lCloseIconImageView.getStyleClass().addAll((Object[])new String[]{"close-icon"});
            lCloseIconImageView.setPickOnBounds(true);
            lCloseIconImageView.setOnMouseClicked(mouseEvent -> lPopup.hide());
            lVBox.add((Node)lCloseIconImageView);
        }
        calendarPicker.calendarProperty().addListener(observable -> {
            if (lPopup != null && !((CalendarTextField)this.getSkinnable()).getShowTime().booleanValue() && lPopup.isShowing()) {
                lPopup.hide();
            }
        });
        lPopup.setOnHiding(windowEvent -> {
            if (!((CalendarTextField)this.getSkinnable()).getShowTime().booleanValue()) {
                ((CalendarTextField)this.getSkinnable()).calendarProperty().set(calendarPicker.calendarProperty().get());
            }
            this.textField.setDisable(false);
        });
        lPopup.getContent().add((Object)lBorderPane);
        this.textField.setDisable(true);
        lPopup.show((Node)this.textField, NodeUtil.screenX((Node)this.getSkinnable()), NodeUtil.screenY((Node)this.getSkinnable()) + this.textField.getHeight());
        calendarPicker.requestFocus();
    }
}

