/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin;

import com.sun.javafx.css.converters.EnumConverter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Slider;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.util.Callback;
import jfxtras.css.converters.SimpleDateFormatConverter;
import jfxtras.scene.control.CalendarTimePicker;

public class CalendarTimePickerSkin
extends SkinBase<CalendarTimePicker> {
    private ObjectProperty<ShowTickLabels> showTickLabels = null;
    private static final ShowTickLabels SHOW_TICKLABELS_DEFAULT = ShowTickLabels.NO;
    private ObjectProperty<DateFormat> labelFormat = null;
    private final Slider hourScrollSlider = new Slider();
    private final Slider minuteScrollSlider = new Slider();
    private final Slider secondScrollSlider = new Slider();
    private final Text timeText = new Text("XX:XX:XX");
    final Pane hourLabelsPane = new Pane(){
        {
            this.prefWidthProperty().bind((ObservableValue)CalendarTimePickerSkin.this.hourScrollSlider.prefWidthProperty());
            this.layoutChildren();
        }

        protected void layoutChildren() {
            double lX;
            Text lText;
            int i;
            this.getChildren().clear();
            double lLabelWidth = new Text("88").prefWidth(0.0);
            double lWhitespace = lLabelWidth / 2.0;
            double lLabelWidthPlusWhitespace = lLabelWidth + lWhitespace;
            double lScrollSliderOuterPadding = 5.0;
            Text lText2 = new Text("0");
            Rectangle lRectangle = new Rectangle(0.0, 0.0, CalendarTimePickerSkin.this.minuteScrollSlider.getWidth(), lText2.prefHeight(0.0));
            lRectangle.setFill((Paint)Color.TRANSPARENT);
            this.getChildren().add((Object)lRectangle);
            int lNumberOfLabels = (int)(this.getWidth() / lLabelWidthPlusWhitespace) + 2;
            int lStep = 24;
            if (lNumberOfLabels >= 24) {
                lStep = 1;
            } else if (lNumberOfLabels >= 12) {
                lStep = 2;
            } else if (lNumberOfLabels >= 8) {
                lStep = 3;
            } else if (lNumberOfLabels >= 6) {
                lStep = 4;
            } else if (lNumberOfLabels > 4) {
                lStep = 6;
            } else if (lNumberOfLabels > 2) {
                lStep = 12;
            }
            for (i = 0; i < 24; i += lStep) {
                lText = new Text("" + i);
                lText.setY(lText.prefHeight(0.0));
                lX = lScrollSliderOuterPadding + (CalendarTimePickerSkin.this.minuteScrollSlider.getWidth() - 2.0 * lScrollSliderOuterPadding) / 23.0 * (double)i - lText.prefWidth(0.0) / (double)(i == 23 ? 1 : 2) * (double)(i != 0 ? 1 : 0);
                lText.setX(lX);
                this.getChildren().add((Object)lText);
            }
            for (i = 0; i < 24; ++i) {
                lText = new Text("0");
                lX = lScrollSliderOuterPadding + (CalendarTimePickerSkin.this.minuteScrollSlider.getWidth() - 2.0 * lScrollSliderOuterPadding) / 23.0 * (double)i;
                this.getChildren().add((Object)new Line(lX, lText.prefHeight(0.0) + 3.0, lX, lText.prefHeight(0.0) + 3.0 + 3.0));
            }
        }
    };
    final Pane minuteLabelsPane = new Pane(){
        {
            this.layoutChildren();
        }

        protected void layoutChildren() {
            int i;
            this.getChildren().clear();
            double lLabelWidth = new Text("88").prefWidth(0.0);
            double lWhitespace = lLabelWidth / 2.0;
            double lLabelWidthPlusWhitespace = lLabelWidth + lWhitespace;
            double lScrollSliderOuterPadding = 5.0;
            if (CalendarTimePickerSkin.this.getShowTickLabels() == ShowTickLabels.YES) {
                Text lText = new Text("0");
                Rectangle lRectangle = new Rectangle(0.0, 0.0, CalendarTimePickerSkin.this.minuteScrollSlider.getWidth(), lText.prefHeight(0.0));
                lRectangle.setFill((Paint)Color.TRANSPARENT);
                this.getChildren().add((Object)lRectangle);
            }
            int lNumberOfLabels = (int)(this.getWidth() / lLabelWidthPlusWhitespace) + 2;
            int lStep = 60;
            if (lNumberOfLabels >= 60) {
                lStep = 1;
            } else if (lNumberOfLabels >= 30) {
                lStep = 2;
            } else if (lNumberOfLabels >= 20) {
                lStep = 3;
            } else if (lNumberOfLabels >= 15) {
                lStep = 4;
            } else if (lNumberOfLabels >= 12) {
                lStep = 5;
            } else if (lNumberOfLabels >= 6) {
                lStep = 10;
            } else if (lNumberOfLabels >= 4) {
                lStep = 15;
            } else if (lNumberOfLabels >= 2) {
                lStep = 30;
            }
            if (lStep < ((CalendarTimePicker)CalendarTimePickerSkin.this.getSkinnable()).getMinuteStep()) {
                lStep = ((CalendarTimePicker)CalendarTimePickerSkin.this.getSkinnable()).getMinuteStep();
            }
            for (i = 0; i <= 59; i += lStep) {
                Text lText = new Text("" + i);
                lText.setY(lText.prefHeight(0.0));
                double lX = lScrollSliderOuterPadding + (CalendarTimePickerSkin.this.minuteScrollSlider.getWidth() - 2.0 * lScrollSliderOuterPadding) / 59.0 * (double)i - lText.prefWidth(0.0) / (double)(i == 59 ? 1 : 2) * (double)(i != 0 ? 1 : 0);
                lText.setX(lX);
                this.getChildren().add((Object)lText);
            }
            for (i = 0; i <= 59; ++i) {
                double lX = lScrollSliderOuterPadding + (CalendarTimePickerSkin.this.minuteScrollSlider.getWidth() - 2.0 * lScrollSliderOuterPadding) / 59.0 * (double)i;
                this.getChildren().add((Object)new Line(lX, 0.0, lX, 3.0));
            }
        }
    };
    static final Date DATE = new Date(8099, 0, 1, 2, 3, 4);
    private final AtomicInteger refreshingAtomicInteger = new AtomicInteger(0);
    private Calendar changingCalendar = null;

    public CalendarTimePickerSkin(CalendarTimePicker control) {
        super((Control)control);
        this.construct();
    }

    private void construct() {
        this.createNodes();
        ((CalendarTimePicker)this.getSkinnable()).calendarProperty().addListener(observable -> this.refresh());
        ((CalendarTimePicker)this.getSkinnable()).minuteStepProperty().addListener(observable -> this.minuteScrollSlider.setBlockIncrement(((CalendarTimePicker)this.getSkinnable()).getMinuteStep().doubleValue()));
        this.minuteScrollSlider.setBlockIncrement(((CalendarTimePicker)this.getSkinnable()).getMinuteStep().doubleValue());
        ((CalendarTimePicker)this.getSkinnable()).secondStepProperty().addListener(observable -> this.secondScrollSlider.setBlockIncrement(((CalendarTimePicker)this.getSkinnable()).getSecondStep().doubleValue()));
        this.secondScrollSlider.setBlockIncrement(((CalendarTimePicker)this.getSkinnable()).getSecondStep().doubleValue());
        ((CalendarTimePicker)this.getSkinnable()).localeProperty().addListener(observable -> this.refresh());
        this.refresh();
    }

    public final ObjectProperty<ShowTickLabels> showTickLabelsProperty() {
        if (this.showTickLabels == null) {
            this.showTickLabels = new StyleableObjectProperty<ShowTickLabels>(SHOW_TICKLABELS_DEFAULT){

                public void invalidated() {
                    CalendarTimePickerSkin.this.refreshLayout();
                }

                public CssMetaData<CalendarTimePicker, ShowTickLabels> getCssMetaData() {
                    return StyleableProperties.SHOW_TICKLABELS;
                }

                public Object getBean() {
                    return CalendarTimePickerSkin.this;
                }

                public String getName() {
                    return "showTickLabels";
                }
            };
        }
        return this.showTickLabels;
    }

    public final void setShowTickLabels(ShowTickLabels value) {
        this.showTickLabelsProperty().set((Object)value);
    }

    public final ShowTickLabels getShowTickLabels() {
        return this.showTickLabels == null ? SHOW_TICKLABELS_DEFAULT : (ShowTickLabels)((Object)this.showTickLabels.get());
    }

    public final CalendarTimePickerSkin withShowTickLabels(ShowTickLabels value) {
        this.setShowTickLabels(value);
        return this;
    }

    public final ObjectProperty<DateFormat> labelFormatProperty() {
        if (this.labelFormat == null) {
            this.labelFormat = new StyleableObjectProperty<DateFormat>(this.getLABEL_DATEFORMAT_DEFAULT()){

                public void invalidated() {
                    CalendarTimePickerSkin.this.refreshLayout();
                    CalendarTimePickerSkin.this.refresh();
                }

                public CssMetaData<CalendarTimePicker, DateFormat> getCssMetaData() {
                    return StyleableProperties.LABEL_DATEFORMAT;
                }

                public Object getBean() {
                    return CalendarTimePickerSkin.this;
                }

                public String getName() {
                    return "labelFormat";
                }
            };
        }
        return this.labelFormat;
    }

    public final void setLabelDateFormat(DateFormat value) {
        this.labelFormatProperty().set((Object)value);
    }

    public final DateFormat getLabelDateFormat() {
        return this.labelFormat == null ? this.getLABEL_DATEFORMAT_DEFAULT() : (DateFormat)this.labelFormat.get();
    }

    public final CalendarTimePickerSkin withLabelDateFormat(DateFormat value) {
        this.setLabelDateFormat(value);
        return this;
    }

    private DateFormat getLABEL_DATEFORMAT_DEFAULT() {
        return DateFormat.getTimeInstance(3, ((CalendarTimePicker)this.getSkinnable()).getLocale());
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return CalendarTimePickerSkin.getClassCssMetaData();
    }

    private void createNodes() {
        this.hourScrollSlider.setId("hourSlider");
        this.hourScrollSlider.minProperty().set(0.0);
        this.hourScrollSlider.maxProperty().set(23.0);
        this.hourScrollSlider.setMajorTickUnit(12.0);
        this.hourScrollSlider.setMinorTickCount(3);
        this.hourScrollSlider.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (this.refreshingAtomicInteger.get() > 0) {
                return;
            }
            Calendar lCalendar = this.getChangingCalendar();
            lCalendar = lCalendar == null ? Calendar.getInstance() : (Calendar)lCalendar.clone();
            lCalendar.set(11, newValue.intValue());
            this.setChangingCalendar(lCalendar);
        });
        this.hourScrollSlider.valueChangingProperty().addListener((observable, oldValue, newValue) -> {
            if (this.refreshingAtomicInteger.get() > 0) {
                return;
            }
            this.acceptChangingCalendar();
        });
        this.minuteScrollSlider.setId("minuteSlider");
        this.minuteScrollSlider.minProperty().set(0.0);
        this.minuteScrollSlider.maxProperty().set(59.0);
        this.minuteScrollSlider.setMajorTickUnit(10.0);
        this.minuteScrollSlider.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (this.refreshingAtomicInteger.get() > 0) {
                return;
            }
            Calendar lCalendar = this.getChangingCalendar();
            lCalendar = lCalendar == null ? Calendar.getInstance() : (Calendar)lCalendar.clone();
            int lMinutes = newValue.intValue();
            int lMinuteStep = ((CalendarTimePicker)this.getSkinnable()).getMinuteStep();
            if (lMinuteStep > 1 && (lMinutes += ((CalendarTimePicker)this.getSkinnable()).getMinuteStep() / 2) > 59) {
                lMinutes -= lMinuteStep;
            }
            lCalendar.set(12, lMinutes);
            lCalendar = CalendarTimePickerSkin.blockMinutesToStep(lCalendar, ((CalendarTimePicker)this.getSkinnable()).getMinuteStep());
            this.setChangingCalendar(lCalendar);
        });
        this.minuteScrollSlider.valueChangingProperty().addListener((observable, oldValue, newValue) -> {
            if (this.refreshingAtomicInteger.get() > 0) {
                return;
            }
            this.acceptChangingCalendar();
        });
        this.secondScrollSlider.setId("secondSlider");
        this.secondScrollSlider.minProperty().set(0.0);
        this.secondScrollSlider.maxProperty().set(59.0);
        this.secondScrollSlider.setMajorTickUnit(10.0);
        this.secondScrollSlider.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (this.refreshingAtomicInteger.get() > 0) {
                return;
            }
            Calendar lCalendar = this.getChangingCalendar();
            lCalendar = lCalendar == null ? Calendar.getInstance() : (Calendar)lCalendar.clone();
            int lSeconds = newValue.intValue();
            int lSecondStep = ((CalendarTimePicker)this.getSkinnable()).getSecondStep();
            if (lSecondStep > 1 && (lSeconds += ((CalendarTimePicker)this.getSkinnable()).getSecondStep() / 2) > 59) {
                lSeconds -= lSecondStep;
            }
            lCalendar.set(13, lSeconds);
            lCalendar = CalendarTimePickerSkin.blockSecondsToStep(lCalendar, ((CalendarTimePicker)this.getSkinnable()).getMinuteStep());
            this.setChangingCalendar(lCalendar);
        });
        this.secondScrollSlider.valueChangingProperty().addListener((observable, oldValue, newValue) -> {
            if (this.refreshingAtomicInteger.get() > 0) {
                return;
            }
            this.acceptChangingCalendar();
        });
        this.timeText.setDisable(true);
        this.timeText.getStyleClass().add((Object)"timeLabel");
        this.refreshLayout();
        ((CalendarTimePicker)this.getSkinnable()).getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
    }

    private void refreshLayout() {
        this.getChildren().clear();
        StackPane lStackPane = new StackPane();
        VBox lVBox = new VBox(0.0);
        lVBox.alignmentProperty().set((Object)Pos.CENTER);
        if (this.getLabelDateFormat().format(DATE).contains("2")) {
            if (this.getShowTickLabels() == ShowTickLabels.YES) {
                lVBox.getChildren().add((Object)this.hourLabelsPane);
            }
            lVBox.getChildren().add((Object)this.hourScrollSlider);
        }
        if (this.getLabelDateFormat().format(DATE).contains("3")) {
            lVBox.getChildren().add((Object)this.minuteScrollSlider);
            if (this.getShowTickLabels() == ShowTickLabels.YES) {
                lVBox.getChildren().add((Object)this.minuteLabelsPane);
            }
        }
        if (this.getLabelDateFormat().format(DATE).contains("4")) {
            lVBox.getChildren().add((Object)this.secondScrollSlider);
        }
        lStackPane.getChildren().add((Object)lVBox);
        lStackPane.getChildren().add((Object)this.timeText);
        StackPane.setAlignment((Node)this.timeText, (Pos)(this.getShowTickLabels() == ShowTickLabels.YES ? Pos.CENTER : Pos.TOP_CENTER));
        this.getChildren().add((Object)lStackPane);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        try {
            this.refreshingAtomicInteger.addAndGet(1);
            Calendar lCalendar = this.getChangingCalendar();
            int lHour = lCalendar == null ? 0 : lCalendar.get(11);
            int lMinute = lCalendar == null ? 0 : lCalendar.get(12);
            int lSecond = lCalendar == null ? 0 : lCalendar.get(13);
            this.hourScrollSlider.valueProperty().set((double)lHour);
            this.minuteScrollSlider.valueProperty().set((double)lMinute);
            this.secondScrollSlider.valueProperty().set((double)lSecond);
            this.timeText.setText(lCalendar == null ? "" : this.getLabelDateFormat().format(lCalendar.getTime()));
        }
        finally {
            this.refreshingAtomicInteger.addAndGet(-1);
        }
    }

    public static Calendar blockMinutesToStep(Calendar calendar, Integer stepSize) {
        if (stepSize == null || calendar == null) {
            return calendar;
        }
        int lValue = calendar.get(12);
        if (stepSize == 1) {
            return calendar;
        }
        lValue /= stepSize.intValue();
        if (calendar.get(12) != (lValue *= stepSize.intValue())) {
            Calendar lCalendar = (Calendar)calendar.clone();
            lCalendar.set(12, lValue);
            calendar = lCalendar;
        }
        return calendar;
    }

    public static Calendar blockSecondsToStep(Calendar calendar, Integer stepSize) {
        if (stepSize == null || calendar == null) {
            return calendar;
        }
        int lValue = calendar.get(13);
        if (stepSize == 1) {
            return calendar;
        }
        lValue /= stepSize.intValue();
        if (calendar.get(13) != (lValue *= stepSize.intValue())) {
            Calendar lCalendar = (Calendar)calendar.clone();
            lCalendar.set(13, lValue);
            calendar = lCalendar;
        }
        return calendar;
    }

    private Calendar getChangingCalendar() {
        if (this.changingCalendar != null) {
            return this.changingCalendar;
        }
        return ((CalendarTimePicker)this.getSkinnable()).getCalendar();
    }

    public void setChangingCalendar(Calendar lCalendar) {
        if (!lCalendar.equals(this.getChangingCalendar())) {
            this.changingCalendar = lCalendar;
            this.refresh();
        }
    }

    public void acceptChangingCalendar() {
        if (this.changingCalendar != null) {
            if (this.callValueValidationCallback((Calendar)this.changingCalendar.clone())) {
                ((CalendarTimePicker)this.getSkinnable()).setCalendar(this.changingCalendar);
            }
            this.changingCalendar = null;
            this.refresh();
        }
    }

    private boolean callValueValidationCallback(Calendar value) {
        Callback<Calendar, Boolean> lCallback = ((CalendarTimePicker)this.getSkinnable()).getValueValidationCallback();
        if (lCallback == null) {
            return true;
        }
        return (Boolean)lCallback.call((Object)value);
    }

    static /* synthetic */ ShowTickLabels access$400() {
        return SHOW_TICKLABELS_DEFAULT;
    }

    private static class StyleableProperties {
        private static final CssMetaData<CalendarTimePicker, ShowTickLabels> SHOW_TICKLABELS = new CssMetaData<CalendarTimePicker, ShowTickLabels>("-fxx-show-ticklabels", (StyleConverter)new EnumConverter(ShowTickLabels.class), CalendarTimePickerSkin.access$400()){

            public boolean isSettable(CalendarTimePicker n) {
                return !((CalendarTimePickerSkin)n.getSkin()).showTickLabelsProperty().isBound();
            }

            public StyleableProperty<ShowTickLabels> getStyleableProperty(CalendarTimePicker n) {
                return (StyleableProperty)((CalendarTimePickerSkin)n.getSkin()).showTickLabelsProperty();
            }
        };
        private static final CssMetaData<CalendarTimePicker, DateFormat> LABEL_DATEFORMAT = new CssMetaData<CalendarTimePicker, DateFormat>("-fxx-label-dateformat", (StyleConverter)new SimpleDateFormatConverter(), null){

            public boolean isSettable(CalendarTimePicker n) {
                return !((CalendarTimePickerSkin)n.getSkin()).showTickLabelsProperty().isBound();
            }

            public StyleableProperty<DateFormat> getStyleableProperty(CalendarTimePicker n) {
                return (StyleableProperty)((CalendarTimePickerSkin)n.getSkin()).labelFormatProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<Object> styleables = new ArrayList<Object>(SkinBase.getClassCssMetaData());
            styleables.add(SHOW_TICKLABELS);
            styleables.add(LABEL_DATEFORMAT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    public static enum ShowTickLabels {
        YES,
        NO;

    }
}

