/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.WeakHashMap;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ObservableList;

public class DateTimeToCalendarHelper {
    public static Calendar createCalendarFromLocalDate(LocalDate localDate, Locale locale) {
        if (localDate == null) {
            return null;
        }
        Calendar lCalendar = Calendar.getInstance(locale);
        lCalendar.set(1, localDate.getYear());
        lCalendar.set(2, localDate.getMonth().getValue() - 1);
        lCalendar.set(5, localDate.getDayOfMonth());
        lCalendar.set(11, 0);
        lCalendar.set(12, 0);
        lCalendar.set(13, 0);
        lCalendar.set(14, 0);
        return lCalendar;
    }

    public static Calendar createCalendarFromLocalDateTime(LocalDateTime localDateTime, Locale locale) {
        if (localDateTime == null) {
            return null;
        }
        Calendar lCalendar = Calendar.getInstance(locale);
        lCalendar.set(1, localDateTime.getYear());
        lCalendar.set(2, localDateTime.getMonth().getValue() - 1);
        lCalendar.set(5, localDateTime.getDayOfMonth());
        lCalendar.set(11, localDateTime.getHour());
        lCalendar.set(12, localDateTime.getMinute());
        lCalendar.set(13, localDateTime.getSecond());
        lCalendar.set(14, localDateTime.getNano() / 1000000);
        return lCalendar;
    }

    public static Calendar createCalendarFromLocalTime(LocalTime localTime, Locale locale) {
        if (localTime == null) {
            return null;
        }
        Calendar lCalendar = Calendar.getInstance(locale);
        lCalendar.set(11, localTime.getHour());
        lCalendar.set(12, localTime.getMinute());
        lCalendar.set(13, localTime.getSecond());
        lCalendar.set(14, localTime.getNano() / 1000000);
        return lCalendar;
    }

    public static LocalDate createLocalDateFromCalendar(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        LocalDate lLocalDate = LocalDate.of(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
        return lLocalDate;
    }

    public static LocalDateTime createLocalDateTimeFromCalendar(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        LocalDateTime lLocalDateTime = LocalDateTime.of(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14) * 1000000);
        return lLocalDateTime;
    }

    public static LocalTime createLocalTimeFromCalendar(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        LocalTime lLocalTime = LocalTime.of(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14) * 1000000);
        return lLocalTime;
    }

    public static Date createDateFromLocalDate(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        Instant lInstant = localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
        Date lDate = Date.from(lInstant);
        return lDate;
    }

    public static LocalDate createLocaleDateFromDate(Date date) {
        if (date == null) {
            return null;
        }
        LocalDate lLocalDate = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).toLocalDate();
        return lLocalDate;
    }

    public static Date createDateFromLocalDateTime(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        Instant lInstant = localDateTime.atZone(ZoneId.systemDefault()).toInstant();
        Date lDate = Date.from(lInstant);
        return lDate;
    }

    public static LocalDateTime createLocaleDateTimeFromDate(Date date) {
        if (date == null) {
            return null;
        }
        LocalDateTime lLocalDateTime = LocalDateTime.of(1900 + date.getYear(), date.getMonth() + 1, date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds());
        return lLocalDateTime;
    }

    public static LocalTime createLocaleTimeFromDate(Date date) {
        if (date == null) {
            return null;
        }
        LocalTime lLocalTime = LocalTime.of(date.getHours(), date.getMinutes(), date.getSeconds(), 0);
        return lLocalTime;
    }

    public static Date createDateFromLocalTime(LocalTime localTime) {
        if (localTime == null) {
            return null;
        }
        Date lDate = DateTimeToCalendarHelper.createDateFromLocalDateTime(localTime.atDate(LocalDate.now()));
        return lDate;
    }

    public static void syncLocalDate(ObjectProperty<Calendar> calendarProperty, ObjectProperty<LocalDate> localDateProperty, ObjectProperty<Locale> localeProperty) {
        calendarProperty.set(localDateProperty.get() == null ? null : DateTimeToCalendarHelper.createCalendarFromLocalDate((LocalDate)localDateProperty.get(), (Locale)localeProperty.get()));
        calendarProperty.addListener((observableValue, oldValue, newValue) -> localDateProperty.set((Object)DateTimeToCalendarHelper.createLocalDateFromCalendar(newValue)));
        localDateProperty.addListener((observableValue, oldValue, newValue) -> calendarProperty.set(newValue == null ? null : DateTimeToCalendarHelper.createCalendarFromLocalDate(newValue, (Locale)localeProperty.get())));
    }

    public static void syncLocalDateTime(ObjectProperty<Calendar> calendarProperty, ObjectProperty<LocalDateTime> localDateTimeProperty, ObjectProperty<Locale> localeProperty) {
        calendarProperty.set(localDateTimeProperty.get() == null ? null : DateTimeToCalendarHelper.createCalendarFromLocalDateTime((LocalDateTime)localDateTimeProperty.get(), (Locale)localeProperty.get()));
        calendarProperty.addListener((observableValue, oldValue, newValue) -> localDateTimeProperty.set((Object)DateTimeToCalendarHelper.createLocalDateTimeFromCalendar(newValue)));
        localDateTimeProperty.addListener((observableValue, oldValue, newValue) -> calendarProperty.set(newValue == null ? null : DateTimeToCalendarHelper.createCalendarFromLocalDateTime(newValue, (Locale)localeProperty.get())));
    }

    public static void syncLocalTime(ObjectProperty<Calendar> calendarProperty, ObjectProperty<LocalTime> localTimeProperty, ObjectProperty<Locale> localeProperty) {
        calendarProperty.set(localTimeProperty.get() == null ? null : DateTimeToCalendarHelper.createCalendarFromLocalTime((LocalTime)localTimeProperty.get(), (Locale)localeProperty.get()));
        calendarProperty.addListener((observableValue, oldValue, newValue) -> localTimeProperty.set((Object)DateTimeToCalendarHelper.createLocalTimeFromCalendar(newValue)));
        localTimeProperty.addListener((observableValue, oldValue, newValue) -> calendarProperty.set(newValue == null ? null : DateTimeToCalendarHelper.createCalendarFromLocalTime(newValue, (Locale)localeProperty.get())));
    }

    public static void syncLocalDates(ObservableList<Calendar> calendars, ObservableList<LocalDate> localDates, ObjectProperty<Locale> localeProperty) {
        for (LocalDate lLocalDate : localDates) {
            Calendar lCalendar = DateTimeToCalendarHelper.createCalendarFromLocalDate(lLocalDate, (Locale)localeProperty.get());
            calendars.add((Object)lCalendar);
        }
        calendars.addListener(change -> {
            while (change.next()) {
                LocalDate lLocalDate;
                for (Calendar lCalendar : change.getRemoved()) {
                    lLocalDate = DateTimeToCalendarHelper.createLocalDateFromCalendar(lCalendar);
                    if (!localDates.contains((Object)lLocalDate)) continue;
                    localDates.remove((Object)lLocalDate);
                }
                for (Calendar lCalendar : change.getAddedSubList()) {
                    lLocalDate = DateTimeToCalendarHelper.createLocalDateFromCalendar(lCalendar);
                    if (localDates.contains((Object)lLocalDate)) continue;
                    localDates.add((Object)lLocalDate);
                }
            }
        });
        localDates.addListener(change -> {
            while (change.next()) {
                Calendar lCalendar;
                for (LocalDate lLocalDate : change.getRemoved()) {
                    lCalendar = DateTimeToCalendarHelper.createCalendarFromLocalDate(lLocalDate, (Locale)localeProperty.get());
                    if (!calendars.contains((Object)lCalendar)) continue;
                    calendars.remove((Object)lCalendar);
                }
                for (LocalDate lLocalDate : change.getAddedSubList()) {
                    lCalendar = DateTimeToCalendarHelper.createCalendarFromLocalDate(lLocalDate, (Locale)localeProperty.get());
                    if (calendars.contains((Object)lCalendar)) continue;
                    calendars.add((Object)lCalendar);
                }
            }
        });
    }

    public static void syncLocalDateTimes(ObservableList<Calendar> calendars, ObservableList<LocalDateTime> localDateTimes, ObjectProperty<Locale> localeProperty) {
        for (LocalDateTime lLocalDateTime : localDateTimes) {
            Calendar lCalendar = DateTimeToCalendarHelper.createCalendarFromLocalDateTime(lLocalDateTime, (Locale)localeProperty.get());
            calendars.add((Object)lCalendar);
        }
        calendars.addListener(change -> {
            while (change.next()) {
                LocalDateTime lLocalDateTime;
                for (Calendar lCalendar : change.getRemoved()) {
                    lLocalDateTime = DateTimeToCalendarHelper.createLocalDateTimeFromCalendar(lCalendar);
                    if (!localDateTimes.contains((Object)lLocalDateTime)) continue;
                    localDateTimes.remove((Object)lLocalDateTime);
                }
                for (Calendar lCalendar : change.getAddedSubList()) {
                    lLocalDateTime = DateTimeToCalendarHelper.createLocalDateTimeFromCalendar(lCalendar);
                    if (localDateTimes.contains((Object)lLocalDateTime)) continue;
                    localDateTimes.add((Object)lLocalDateTime);
                }
            }
        });
        localDateTimes.addListener(change -> {
            while (change.next()) {
                Calendar lCalendar;
                for (LocalDateTime lLocalDateTime : change.getRemoved()) {
                    lCalendar = DateTimeToCalendarHelper.createCalendarFromLocalDateTime(lLocalDateTime, (Locale)localeProperty.get());
                    if (!calendars.contains((Object)lCalendar)) continue;
                    calendars.remove((Object)lCalendar);
                }
                for (LocalDateTime lLocalDateTime : change.getAddedSubList()) {
                    lCalendar = DateTimeToCalendarHelper.createCalendarFromLocalDateTime(lLocalDateTime, (Locale)localeProperty.get());
                    if (calendars.contains((Object)lCalendar)) continue;
                    calendars.add((Object)lCalendar);
                }
            }
        });
    }

    public static void syncDateTimeFormatterForDate(ObjectProperty<DateFormat> dateFormatProperty, ObjectProperty<DateTimeFormatter> dateTimeFormatterProperty) {
        dateFormatProperty.set((Object)(dateTimeFormatterProperty.get() == null ? null : new DateTimeFormatterToDateFormatWrapper((DateTimeFormatter)dateTimeFormatterProperty.get())));
        dateTimeFormatterProperty.addListener(observable -> dateFormatProperty.set((Object)new DateTimeFormatterToDateFormatWrapper((DateTimeFormatter)dateTimeFormatterProperty.get())));
    }

    public static void syncDateTimeFormattersForDate(ListProperty<DateFormat> dateFormatsProperty, ListProperty<DateTimeFormatter> dateTimeFormattersProperty) {
        WeakHashMap<DateTimeFormatter, DateTimeFormatterToDateFormatWrapper> map = new WeakHashMap<DateTimeFormatter, DateTimeFormatterToDateFormatWrapper>();
        for (DateTimeFormatter lDateTimeFormatter : dateTimeFormattersProperty) {
            DateTimeFormatterToDateFormatWrapper lDateTimeFormatterToDateFormatWrapper = new DateTimeFormatterToDateFormatWrapper(lDateTimeFormatter);
            map.put(lDateTimeFormatter, lDateTimeFormatterToDateFormatWrapper);
            dateFormatsProperty.add((Object)lDateTimeFormatterToDateFormatWrapper);
        }
        dateTimeFormattersProperty.addListener(change -> {
            while (change.next()) {
                DateTimeFormatterToDateFormatWrapper lDateTimeFormatterToDateFormatWrapper;
                for (DateTimeFormatter lDateTimeFormatter : change.getRemoved()) {
                    lDateTimeFormatterToDateFormatWrapper = (DateTimeFormatterToDateFormatWrapper)map.remove(lDateTimeFormatter);
                    dateFormatsProperty.remove((Object)lDateTimeFormatterToDateFormatWrapper);
                }
                for (DateTimeFormatter lDateTimeFormatter : change.getAddedSubList()) {
                    lDateTimeFormatterToDateFormatWrapper = new DateTimeFormatterToDateFormatWrapper(lDateTimeFormatter);
                    map.put(lDateTimeFormatter, lDateTimeFormatterToDateFormatWrapper);
                    dateFormatsProperty.add((Object)lDateTimeFormatterToDateFormatWrapper);
                }
            }
        });
    }

    public static void syncDateTimeFormatterForDateTime(ObjectProperty<DateFormat> dateFormatProperty, ObjectProperty<DateTimeFormatter> dateTimeFormatterProperty) {
        dateFormatProperty.set((Object)(dateTimeFormatterProperty.get() == null ? null : new DateTimeFormatterToDateTimeFormatWrapper((DateTimeFormatter)dateTimeFormatterProperty.get())));
        dateTimeFormatterProperty.addListener(observable -> dateFormatProperty.set((Object)new DateTimeFormatterToDateTimeFormatWrapper((DateTimeFormatter)dateTimeFormatterProperty.get())));
    }

    public static void syncDateTimeFormattersForDateTime(ListProperty<DateFormat> dateFormatsProperty, ListProperty<DateTimeFormatter> dateTimeFormattersProperty) {
        WeakHashMap<DateTimeFormatter, DateTimeFormatterToDateTimeFormatWrapper> map = new WeakHashMap<DateTimeFormatter, DateTimeFormatterToDateTimeFormatWrapper>();
        for (DateTimeFormatter lDateTimeFormatter : dateTimeFormattersProperty) {
            DateTimeFormatterToDateTimeFormatWrapper lDateTimeFormatterToDateTimeFormatWrapper = new DateTimeFormatterToDateTimeFormatWrapper(lDateTimeFormatter);
            map.put(lDateTimeFormatter, lDateTimeFormatterToDateTimeFormatWrapper);
            dateFormatsProperty.add((Object)lDateTimeFormatterToDateTimeFormatWrapper);
        }
        dateTimeFormattersProperty.addListener(change -> {
            while (change.next()) {
                DateTimeFormatterToDateTimeFormatWrapper lDateTimeFormatterToDateTimeFormatWrapper;
                for (DateTimeFormatter lDateTimeFormatter : change.getRemoved()) {
                    lDateTimeFormatterToDateTimeFormatWrapper = (DateTimeFormatterToDateTimeFormatWrapper)map.remove(lDateTimeFormatter);
                    dateFormatsProperty.remove((Object)lDateTimeFormatterToDateTimeFormatWrapper);
                }
                for (DateTimeFormatter lDateTimeFormatter : change.getAddedSubList()) {
                    lDateTimeFormatterToDateTimeFormatWrapper = new DateTimeFormatterToDateTimeFormatWrapper(lDateTimeFormatter);
                    map.put(lDateTimeFormatter, lDateTimeFormatterToDateTimeFormatWrapper);
                    dateFormatsProperty.add((Object)lDateTimeFormatterToDateTimeFormatWrapper);
                }
            }
        });
    }

    public static void syncDateTimeFormatterForTime(ObjectProperty<DateFormat> dateFormatProperty, ObjectProperty<DateTimeFormatter> dateTimeFormatterProperty) {
        dateFormatProperty.set((Object)(dateTimeFormatterProperty.get() == null ? null : new DateTimeFormatterToTimeFormatWrapper((DateTimeFormatter)dateTimeFormatterProperty.get())));
        dateTimeFormatterProperty.addListener(observable -> dateFormatProperty.set((Object)new DateTimeFormatterToTimeFormatWrapper((DateTimeFormatter)dateTimeFormatterProperty.get())));
    }

    public static void syncDateTimeFormattersForTime(ListProperty<DateFormat> dateFormatsProperty, ListProperty<DateTimeFormatter> dateTimeFormattersProperty) {
        WeakHashMap<DateTimeFormatter, DateTimeFormatterToTimeFormatWrapper> map = new WeakHashMap<DateTimeFormatter, DateTimeFormatterToTimeFormatWrapper>();
        for (DateTimeFormatter lDateTimeFormatter : dateTimeFormattersProperty) {
            DateTimeFormatterToTimeFormatWrapper lDateTimeFormatterToTimeFormatWrapper = new DateTimeFormatterToTimeFormatWrapper(lDateTimeFormatter);
            map.put(lDateTimeFormatter, lDateTimeFormatterToTimeFormatWrapper);
            dateFormatsProperty.add((Object)lDateTimeFormatterToTimeFormatWrapper);
        }
        dateTimeFormattersProperty.addListener(change -> {
            while (change.next()) {
                DateTimeFormatterToTimeFormatWrapper lDateTimeFormatterToTimeFormatWrapper;
                for (DateTimeFormatter lDateTimeFormatter : change.getRemoved()) {
                    lDateTimeFormatterToTimeFormatWrapper = (DateTimeFormatterToTimeFormatWrapper)map.remove(lDateTimeFormatter);
                    dateFormatsProperty.remove((Object)lDateTimeFormatterToTimeFormatWrapper);
                }
                for (DateTimeFormatter lDateTimeFormatter : change.getAddedSubList()) {
                    lDateTimeFormatterToTimeFormatWrapper = new DateTimeFormatterToTimeFormatWrapper(lDateTimeFormatter);
                    map.put(lDateTimeFormatter, lDateTimeFormatterToTimeFormatWrapper);
                    dateFormatsProperty.add((Object)lDateTimeFormatterToTimeFormatWrapper);
                }
            }
        });
    }

    public static void sync(ObservableList<Calendar> calendars, ObservableList<Calendar> localDateTimes) {
        for (Calendar lCalendar : localDateTimes) {
            calendars.add((Object)lCalendar);
        }
        calendars.addListener(change -> {
            while (change.next()) {
                for (Calendar lCalendar : change.getRemoved()) {
                    if (!localDateTimes.contains((Object)lCalendar)) continue;
                    localDateTimes.remove((Object)lCalendar);
                }
                for (Calendar lCalendar : change.getAddedSubList()) {
                    if (localDateTimes.contains((Object)lCalendar)) continue;
                    localDateTimes.add((Object)lCalendar);
                }
            }
        });
        localDateTimes.addListener(change -> {
            while (change.next()) {
                for (Calendar lCalendar : change.getRemoved()) {
                    if (!calendars.contains((Object)lCalendar)) continue;
                    calendars.remove((Object)lCalendar);
                }
                for (Calendar lCalendar : change.getAddedSubList()) {
                    if (calendars.contains((Object)lCalendar)) continue;
                    calendars.add((Object)lCalendar);
                }
            }
        });
    }

    static class DateTimeFormatterToTimeFormatWrapper
    extends DateFormat {
        private final DateTimeFormatter dateTimeFormatter;

        public DateTimeFormatterToTimeFormatWrapper(DateTimeFormatter dateTimeFormatter) {
            this.dateTimeFormatter = dateTimeFormatter;
        }

        @Override
        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            LocalTime lLocalTime = DateTimeToCalendarHelper.createLocaleTimeFromDate(date);
            String s = this.dateTimeFormatter.format(lLocalTime);
            toAppendTo.append(s);
            return toAppendTo;
        }

        @Override
        public Date parse(String source, ParsePosition pos) {
            LocalTime lLocalTime = LocalTime.parse(source, this.dateTimeFormatter);
            Date lDate = DateTimeToCalendarHelper.createDateFromLocalTime(lLocalTime);
            pos.setIndex(source.length());
            return lDate;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return this == obj;
        }

        public String toString() {
            return this.dateTimeFormatter.toString();
        }
    }

    static class DateTimeFormatterToDateTimeFormatWrapper
    extends DateFormat {
        private final DateTimeFormatter dateTimeFormatter;

        public DateTimeFormatterToDateTimeFormatWrapper(DateTimeFormatter dateTimeFormatter) {
            this.dateTimeFormatter = dateTimeFormatter;
        }

        @Override
        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            LocalDateTime lLocalDateTime = DateTimeToCalendarHelper.createLocaleDateTimeFromDate(date);
            String s = this.dateTimeFormatter.format(lLocalDateTime);
            toAppendTo.append(s);
            return toAppendTo;
        }

        @Override
        public Date parse(String source, ParsePosition pos) {
            LocalDateTime lLocalDateTime = LocalDateTime.parse(source, this.dateTimeFormatter);
            Date lDate = DateTimeToCalendarHelper.createDateFromLocalDateTime(lLocalDateTime);
            pos.setIndex(source.length());
            return lDate;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return this == obj;
        }

        public String toString() {
            return this.dateTimeFormatter.toString();
        }
    }

    static class DateTimeFormatterToDateFormatWrapper
    extends DateFormat {
        private final DateTimeFormatter dateTimeFormatter;

        public DateTimeFormatterToDateFormatWrapper(DateTimeFormatter dateTimeFormatter) {
            this.dateTimeFormatter = dateTimeFormatter;
        }

        @Override
        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            LocalDate lLocalDate = DateTimeToCalendarHelper.createLocaleDateFromDate(date);
            String s = this.dateTimeFormatter.format(lLocalDate);
            toAppendTo.append(s);
            return toAppendTo;
        }

        @Override
        public Date parse(String source, ParsePosition pos) {
            LocalDate lLocalDate = LocalDate.parse(source, this.dateTimeFormatter);
            Date lDate = DateTimeToCalendarHelper.createDateFromLocalDate(lLocalDate);
            pos.setIndex(source.length());
            return lDate;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return this == obj;
        }

        public String toString() {
            return this.dateTimeFormatter.toString();
        }
    }
}

