/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.control;

import java.util.AbstractList;

public class ListSpinnerIntegerList
extends AbstractList<Integer> {
    private int from;
    private int size;
    private int step;

    public ListSpinnerIntegerList() {
        this(-1073741823, 0x3FFFFFFF, 1);
    }

    public ListSpinnerIntegerList(int from, int to) {
        this(from, to, from > to ? -1 : 1);
    }

    public ListSpinnerIntegerList(int from, int to, int step) {
        this.from = from;
        this.size = (to - from) / step + 1;
        if (this.size < 0) {
            throw new IllegalArgumentException("This results in a negative size: " + from + ", " + to + "," + step);
        }
        this.step = step;
    }

    @Override
    public Integer get(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Index cannot be < 0: " + index);
        }
        int lValue = this.from + index * this.step;
        return lValue;
    }

    @Override
    public int indexOf(Object o) {
        int lValue = (Integer)o;
        int lIndex = (lValue - this.from) / this.step;
        if (lIndex < 0 || lIndex > this.size) {
            return -1;
        }
        Integer lValueAtIndex = this.get(lIndex);
        if (!o.equals(lValueAtIndex)) {
            return -1;
        }
        return lIndex;
    }

    @Override
    public int size() {
        return this.size;
    }
}

