/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.control;

import java.time.LocalDate;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import jfxtras.internal.scene.control.skin.LocalDatePickerSkin;

public class LocalDatePicker
extends Control {
    private final SimpleObjectProperty<Mode> modeObjectProperty = new SimpleObjectProperty<Mode>((Object)this, "mode", Mode.SINGLE){

        public void set(Mode value) {
            if (value == null) {
                throw new NullPointerException("Null not allowed");
            }
            super.set((Object)value);
        }
    };
    private final ObjectProperty<LocalDate> localDateObjectProperty = new SimpleObjectProperty((Object)this, "localDate");
    private final ObservableList<LocalDate> localDates = FXCollections.observableArrayList();
    private volatile ObjectProperty<Locale> localeObjectProperty = new SimpleObjectProperty((Object)this, "locale", (Object)Locale.getDefault());
    private volatile BooleanProperty allowNullProperty = new SimpleBooleanProperty((Object)this, "allowNull", true);
    private final ObservableList<LocalDate> highlightedLocalDates = FXCollections.observableArrayList();
    private final ObservableList<LocalDate> disabledLocalDates = FXCollections.observableArrayList();
    private final ObjectProperty<LocalDate> displayedLocalDateObjectProperty = new SimpleObjectProperty((Object)this, "displayedLocalDate", (Object)LocalDate.now());
    private final ObjectProperty<Callback<LocalDateRange, Void>> localDateRangeCallbackObjectProperty = new SimpleObjectProperty((Object)this, "localDateRangeCallback", null);
    private final ObjectProperty<Callback<LocalDate, Boolean>> valueValidationCallbackObjectProperty = new SimpleObjectProperty((Object)this, "valueValidationCallback", null);

    public LocalDatePicker() {
        this.construct();
    }

    public LocalDatePicker(LocalDate localDateTime) {
        this.construct();
        this.setLocalDate(localDateTime);
    }

    private void construct() {
    }

    public Skin createDefaultSkin() {
        return new LocalDatePickerSkin(this);
    }

    public ObjectProperty<Mode> modeProperty() {
        return this.modeObjectProperty;
    }

    public Mode getMode() {
        return (Mode)((Object)this.modeObjectProperty.getValue());
    }

    public void setMode(Mode value) {
        this.modeObjectProperty.setValue((Object)value);
    }

    public LocalDatePicker withMode(Mode value) {
        this.setMode(value);
        return this;
    }

    public ObjectProperty<LocalDate> localDateProperty() {
        return this.localDateObjectProperty;
    }

    public LocalDate getLocalDate() {
        return (LocalDate)this.localDateObjectProperty.getValue();
    }

    public void setLocalDate(LocalDate value) {
        this.localDateObjectProperty.setValue((Object)value);
    }

    public LocalDatePicker withLocalDate(LocalDate value) {
        this.setLocalDate(value);
        return this;
    }

    public ObservableList<LocalDate> localDates() {
        return this.localDates;
    }

    public ObjectProperty<Locale> localeProperty() {
        return this.localeObjectProperty;
    }

    public Locale getLocale() {
        return (Locale)this.localeObjectProperty.getValue();
    }

    public void setLocale(Locale value) {
        this.localeObjectProperty.setValue((Object)value);
    }

    public LocalDatePicker withLocale(Locale value) {
        this.setLocale(value);
        return this;
    }

    public BooleanProperty allowNullProperty() {
        return this.allowNullProperty;
    }

    public boolean getAllowNull() {
        return this.allowNullProperty.get();
    }

    public void setAllowNull(boolean allowNull) {
        this.allowNullProperty.set(allowNull);
    }

    public LocalDatePicker withAllowNull(boolean value) {
        this.setAllowNull(value);
        return this;
    }

    public ObservableList<LocalDate> highlightedLocalDates() {
        return this.highlightedLocalDates;
    }

    public ObservableList<LocalDate> disabledLocalDates() {
        return this.disabledLocalDates;
    }

    public ObjectProperty<LocalDate> displayedLocalDateProperty() {
        return this.displayedLocalDateObjectProperty;
    }

    public LocalDate getDisplayedLocalDate() {
        return (LocalDate)this.displayedLocalDateObjectProperty.getValue();
    }

    public void setDisplayedLocalDate(LocalDate value) {
        this.displayedLocalDateObjectProperty.setValue((Object)value);
    }

    public LocalDatePicker withDisplayedLocalDate(LocalDate value) {
        this.setDisplayedLocalDate(value);
        return this;
    }

    public ObjectProperty<Callback<LocalDateRange, Void>> LocalDateRangeCallbackProperty() {
        return this.localDateRangeCallbackObjectProperty;
    }

    public Callback<LocalDateRange, Void> getLocalDateRangeCallback() {
        return (Callback)this.localDateRangeCallbackObjectProperty.getValue();
    }

    public void setLocalDateRangeCallback(Callback<LocalDateRange, Void> value) {
        this.localDateRangeCallbackObjectProperty.setValue(value);
    }

    public LocalDatePicker withLocalDateRangeCallback(Callback<LocalDateRange, Void> value) {
        this.setLocalDateRangeCallback(value);
        return this;
    }

    public ObjectProperty<Callback<LocalDate, Boolean>> valueValidationCallbackProperty() {
        return this.valueValidationCallbackObjectProperty;
    }

    public Callback<LocalDate, Boolean> getValueValidationCallback() {
        return (Callback)this.valueValidationCallbackObjectProperty.getValue();
    }

    public void setValueValidationCallback(Callback<LocalDate, Boolean> value) {
        this.valueValidationCallbackObjectProperty.setValue(value);
    }

    public LocalDatePicker withValueValidationCallback(Callback<LocalDate, Boolean> value) {
        this.setValueValidationCallback(value);
        return this;
    }

    public static class LocalDateRange {
        final LocalDate start;
        final LocalDate end;

        public LocalDateRange(LocalDate start, LocalDate end) {
            this.start = start;
            this.end = end;
        }

        public LocalDate getStartLocalDate() {
            return this.start;
        }

        public LocalDate getEndLocalDate() {
            return this.end;
        }
    }

    public static enum Mode {
        SINGLE,
        MULTIPLE,
        RANGE;

    }
}

