/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package vta.util.genericbundle

// taken from https://github.com/vta.roject/rocket-chip

import chisel3._

abstract class GenericParameterizedBundle[+T <: Object](val params: T)
    extends Bundle {
  override def cloneType = {
    try {
      this.getClass.getConstructors.head
        .newInstance(params)
        .asInstanceOf[this.type]
    } catch {
      case e: java.lang.IllegalArgumentException =>
        throw new Exception(
          "Unable to use GenericParameterizedBundle.cloneType on " +
            this.getClass + ", probably because " + this.getClass +
            "() takes more than one argument.  Consider overriding " +
            "cloneType() on " + this.getClass,
          e
        )
    }
  }
}
