import sys
import os
from behave import *
from behave.log_capture import capture

THUG     = os.path.dirname(os.path.abspath(__file__)).split("samples")[0]
EXPLOITS = os.path.join(THUG, 'samples', 'exploits')
sys.path.append(os.path.join(THUG, 'src'))

from thug.ThugAPI.ThugAPI import ThugAPI

class Exploits(ThugAPI):
    def __init__(self, context):
        ThugAPI.__init__(self)

        self.exploits = list()
        for row in context.table:
            self.exploits.append(row)

    def _run_step(self, context, exploit):
        sample = os.path.join(EXPLOITS, exploit[0])

        self.set_events('click')
        self.disable_cert_logging()
        self.set_connect_timeout(3)
        self.log_init(sample)
        self.run_local(sample)

        for assertion in exploit[1].split(","):
            assert assertion in context.log_capture.getvalue()

    def run_step(self, context):
        for exploit in self.exploits:
            self._run_step(context, exploit)

@given('set of exploits')
def step_impl(context):
    global exploits 
    exploits = Exploits(context)

@capture
@then('run exploit')
def step_impl(context):
    exploits.run_step(context)
