#!/usr/bin/env python

#
# Generated Fri Feb 25 15:16:21 2011 by generateDS.py version 1.20c.
#

import sys
import getopt

try:
    from string import lowercase as str_lower
except ImportError:
    str_lower = str.lower

from xml.dom import minidom
from xml.dom import Node

import six

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:

    class GeneratedsSuper(object):
        def format_string(self, input_data, input_name=''):
            return input_data
        def format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def format_boolean(self, input_data, input_name=''):
            return '%s' % input_data


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'

#
# Support/utility functions.
#

def showIndent(outfile, level):
    for idx in range(level):
        outfile.write('    ')

def quote_xml(inStr):
    s1 = (isinstance(inStr, six.string_types) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, six.string_types) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace):
        if self.category == MixedContainer.CategoryText:
            outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace,name)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class BundleType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None, schema_version=None, Analyses=None, Behaviors=None, Actions=None, Pools=None):
        self.id = _cast(None, id)
        self.schema_version = _cast(float, schema_version)
        self.Analyses = Analyses
        self.Behaviors = Behaviors
        self.Actions = Actions
        self.Pools = Pools
    def factory(*args_, **kwargs_):
        if BundleType.subclass:
            return BundleType.subclass(*args_, **kwargs_)
        else:
            return BundleType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Analyses(self): return self.Analyses
    def set_Analyses(self, Analyses): self.Analyses = Analyses
    def get_Behaviors(self): return self.Behaviors
    def set_Behaviors(self, Behaviors): self.Behaviors = Behaviors
    def get_Actions(self): return self.Actions
    def set_Actions(self, Actions): self.Actions = Actions
    def get_Pools(self): return self.Pools
    def set_Pools(self, Pools): self.Pools = Pools
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_schema_version(self): return self.schema_version
    def set_schema_version(self, schema_version): self.schema_version = schema_version
    def export(self, outfile, level, namespace_='maec:', name_='BundleType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='BundleType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='BundleType'):
        outfile.write(' id=%s' % (quote_attrib(self.id), ))
        outfile.write(' schema_version="%s"' % self.format_float(self.schema_version, input_name='schema_version'))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='BundleType'):
        if self.Analyses:
            self.Analyses.export(outfile, level, namespace_, name_='Analyses')
        if self.Behaviors:
            self.Behaviors.export(outfile, level, namespace_, name_='Behaviors')
        if self.Actions:
            self.Actions.export(outfile, level, namespace_, name_='Actions')
        if self.Pools:
            self.Pools.export(outfile, level, namespace_, name_='Pools')
    def hasContent_(self):
        if (
            self.Analyses is not None or
            self.Behaviors is not None or
            self.Actions is not None or
            self.Pools is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='BundleType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
        if self.schema_version is not None:
            showIndent(outfile, level)
            outfile.write('schema_version = %f,\n' % (self.schema_version,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Analyses is not None:
            showIndent(outfile, level)
            outfile.write('Analyses=model_.Analyses(\n')
            self.Analyses.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Behaviors is not None:
            showIndent(outfile, level)
            outfile.write('Behaviors=model_.Behaviors(\n')
            self.Behaviors.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Actions is not None:
            showIndent(outfile, level)
            outfile.write('Actions=model_.Actions(\n')
            self.Actions.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Pools is not None:
            showIndent(outfile, level)
            outfile.write('Pools=model_.Pools(\n')
            self.Pools.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('id'):
            self.id = attrs.get('id').value
        if attrs.get('schema_version'):
            try:
                self.schema_version = float(attrs.get('schema_version').value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (schema_version): %s' % exp)
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Analyses':
            obj_ = Analyses.factory()
            obj_.build(child_)
            self.set_Analyses(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Behaviors':
            obj_ = Behaviors.factory()
            obj_.build(child_)
            self.set_Behaviors(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Actions':
            obj_ = Actions.factory()
            obj_.build(child_)
            self.set_Actions(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Pools':
            obj_ = Pools.factory()
            obj_.build(child_)
            self.set_Pools(obj_)
# end class BundleType


class Analyses(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Analysis=None):
        if Analysis is None:
            self.Analysis = []
        else:
            self.Analysis = Analysis
    def factory(*args_, **kwargs_):
        if Analyses.subclass:
            return Analyses.subclass(*args_, **kwargs_)
        else:
            return Analyses(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Analysis(self): return self.Analysis
    def set_Analysis(self, Analysis): self.Analysis = Analysis
    def add_Analysis(self, value): self.Analysis.append(value)
    def insert_Analysis(self, index, value): self.Analysis[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Analyses', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Analyses')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Analyses'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Analyses'):
        for Analysis_ in self.Analysis:
            Analysis_.export(outfile, level, namespace_, name_='Analysis')
    def hasContent_(self):
        if (
            self.Analysis
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Analyses'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Analysis=[\n')
        level += 1
        for Analysis_ in self.Analysis:
            showIndent(outfile, level)
            outfile.write('model_.AnalysisType(\n')
            Analysis_.exportLiteral(outfile, level, name_='AnalysisType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Analysis':
            obj_ = AnalysisType.factory()
            obj_.build(child_)
            self.Analysis.append(obj_)
# end class Analyses


class Behaviors(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Behavior=None):
        if Behavior is None:
            self.Behavior = []
        else:
            self.Behavior = Behavior
    def factory(*args_, **kwargs_):
        if Behaviors.subclass:
            return Behaviors.subclass(*args_, **kwargs_)
        else:
            return Behaviors(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Behavior(self): return self.Behavior
    def set_Behavior(self, Behavior): self.Behavior = Behavior
    def add_Behavior(self, value): self.Behavior.append(value)
    def insert_Behavior(self, index, value): self.Behavior[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Behaviors', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Behaviors')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Behaviors'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Behaviors'):
        for Behavior_ in self.Behavior:
            Behavior_.export(outfile, level, namespace_, name_='Behavior')
    def hasContent_(self):
        if (
            self.Behavior
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Behaviors'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Behavior=[\n')
        level += 1
        for Behavior_ in self.Behavior:
            showIndent(outfile, level)
            outfile.write('model_.BehaviorType(\n')
            Behavior_.exportLiteral(outfile, level, name_='BehaviorType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Behavior':
            obj_ = BehaviorType.factory()
            obj_.build(child_)
            self.Behavior.append(obj_)
# end class Behaviors


class Actions(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Action=None):
        if Action is None:
            self.Action = []
        else:
            self.Action = Action
    def factory(*args_, **kwargs_):
        if Actions.subclass:
            return Actions.subclass(*args_, **kwargs_)
        else:
            return Actions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Action(self): return self.Action
    def set_Action(self, Action): self.Action = Action
    def add_Action(self, value): self.Action.append(value)
    def insert_Action(self, index, value): self.Action[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Actions', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Actions')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Actions'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Actions'):
        for Action_ in self.Action:
            Action_.export(outfile, level, namespace_, name_='Action')
    def hasContent_(self):
        if (
            self.Action
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Actions'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Action=[\n')
        level += 1
        for Action_ in self.Action:
            showIndent(outfile, level)
            outfile.write('model_.ActionType(\n')
            Action_.exportLiteral(outfile, level, name_='ActionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Action':
            obj_ = ActionType.factory()
            obj_.build(child_)
            self.Action.append(obj_)
# end class Actions


class Pools(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Behavior_Collection_Pool=None, Behavior_Pool=None, Action_Collection_Pool=None, Action_Pool=None, Object_Pool=None, Effect_Pool=None, Object_Collection_Pool=None):
        self.Behavior_Collection_Pool = Behavior_Collection_Pool
        self.Behavior_Pool = Behavior_Pool
        self.Action_Collection_Pool = Action_Collection_Pool
        self.Action_Pool = Action_Pool
        self.Object_Pool = Object_Pool
        self.Effect_Pool = Effect_Pool
        self.Object_Collection_Pool = Object_Collection_Pool
    def factory(*args_, **kwargs_):
        if Pools.subclass:
            return Pools.subclass(*args_, **kwargs_)
        else:
            return Pools(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Behavior_Collection_Pool(self): return self.Behavior_Collection_Pool
    def set_Behavior_Collection_Pool(self, Behavior_Collection_Pool): self.Behavior_Collection_Pool = Behavior_Collection_Pool
    def get_Behavior_Pool(self): return self.Behavior_Pool
    def set_Behavior_Pool(self, Behavior_Pool): self.Behavior_Pool = Behavior_Pool
    def get_Action_Collection_Pool(self): return self.Action_Collection_Pool
    def set_Action_Collection_Pool(self, Action_Collection_Pool): self.Action_Collection_Pool = Action_Collection_Pool
    def get_Action_Pool(self): return self.Action_Pool
    def set_Action_Pool(self, Action_Pool): self.Action_Pool = Action_Pool
    def get_Object_Pool(self): return self.Object_Pool
    def set_Object_Pool(self, Object_Pool): self.Object_Pool = Object_Pool
    def get_Effect_Pool(self): return self.Effect_Pool
    def set_Effect_Pool(self, Effect_Pool): self.Effect_Pool = Effect_Pool
    def get_Object_Collection_Pool(self): return self.Object_Collection_Pool
    def set_Object_Collection_Pool(self, Object_Collection_Pool): self.Object_Collection_Pool = Object_Collection_Pool
    def export(self, outfile, level, namespace_='maec:', name_='Pools', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Pools')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Pools'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Pools'):
        if self.Behavior_Collection_Pool:
            self.Behavior_Collection_Pool.export(outfile, level, namespace_, name_='Behavior_Collection_Pool')
        if self.Behavior_Pool:
            self.Behavior_Pool.export(outfile, level, namespace_, name_='Behavior_Pool')
        if self.Action_Collection_Pool:
            self.Action_Collection_Pool.export(outfile, level, namespace_, name_='Action_Collection_Pool')
        if self.Action_Pool:
            self.Action_Pool.export(outfile, level, namespace_, name_='Action_Pool')
        if self.Object_Pool:
            self.Object_Pool.export(outfile, level, namespace_, name_='Object_Pool')
        if self.Effect_Pool:
            self.Effect_Pool.export(outfile, level, namespace_, name_='Effect_Pool')
        if self.Object_Collection_Pool:
            self.Object_Collection_Pool.export(outfile, level, namespace_, name_='Object_Collection_Pool')
    def hasContent_(self):
        if (
            self.Behavior_Collection_Pool is not None or
            self.Behavior_Pool is not None or
            self.Action_Collection_Pool is not None or
            self.Action_Pool is not None or
            self.Object_Pool is not None or
            self.Effect_Pool is not None or
            self.Object_Collection_Pool is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Pools'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Behavior_Collection_Pool is not None:
            showIndent(outfile, level)
            outfile.write('Behavior_Collection_Pool=model_.Behavior_Collection_Pool(\n')
            self.Behavior_Collection_Pool.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Behavior_Pool is not None:
            showIndent(outfile, level)
            outfile.write('Behavior_Pool=model_.Behavior_Pool(\n')
            self.Behavior_Pool.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Action_Collection_Pool is not None:
            showIndent(outfile, level)
            outfile.write('Action_Collection_Pool=model_.Action_Collection_Pool(\n')
            self.Action_Collection_Pool.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Action_Pool is not None:
            showIndent(outfile, level)
            outfile.write('Action_Pool=model_.Action_Pool(\n')
            self.Action_Pool.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Object_Pool is not None:
            showIndent(outfile, level)
            outfile.write('Object_Pool=model_.Object_Pool(\n')
            self.Object_Pool.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Effect_Pool is not None:
            showIndent(outfile, level)
            outfile.write('Effect_Pool=model_.Effect_Pool(\n')
            self.Effect_Pool.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Object_Collection_Pool is not None:
            showIndent(outfile, level)
            outfile.write('Object_Collection_Pool=model_.Object_Collection_Pool(\n')
            self.Object_Collection_Pool.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Behavior_Collection_Pool':
            obj_ = Behavior_Collection_Pool.factory()
            obj_.build(child_)
            self.set_Behavior_Collection_Pool(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Behavior_Pool':
            obj_ = Behavior_Pool.factory()
            obj_.build(child_)
            self.set_Behavior_Pool(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Action_Collection_Pool':
            obj_ = Action_Collection_Pool.factory()
            obj_.build(child_)
            self.set_Action_Collection_Pool(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Action_Pool':
            obj_ = Action_Pool.factory()
            obj_.build(child_)
            self.set_Action_Pool(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Object_Pool':
            obj_ = Object_Pool.factory()
            obj_.build(child_)
            self.set_Object_Pool(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Effect_Pool':
            obj_ = Effect_Pool.factory()
            obj_.build(child_)
            self.set_Effect_Pool(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Object_Collection_Pool':
            obj_ = Object_Collection_Pool.factory()
            obj_.build(child_)
            self.set_Object_Collection_Pool(obj_)
# end class Pools


class Behavior_Collection_Pool(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Behavior_Collection=None):
        if Behavior_Collection is None:
            self.Behavior_Collection = []
        else:
            self.Behavior_Collection = Behavior_Collection
    def factory(*args_, **kwargs_):
        if Behavior_Collection_Pool.subclass:
            return Behavior_Collection_Pool.subclass(*args_, **kwargs_)
        else:
            return Behavior_Collection_Pool(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Behavior_Collection(self): return self.Behavior_Collection
    def set_Behavior_Collection(self, Behavior_Collection): self.Behavior_Collection = Behavior_Collection
    def add_Behavior_Collection(self, value): self.Behavior_Collection.append(value)
    def insert_Behavior_Collection(self, index, value): self.Behavior_Collection[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Behavior_Collection_Pool', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Behavior_Collection_Pool')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Behavior_Collection_Pool'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Behavior_Collection_Pool'):
        for Behavior_Collection_ in self.Behavior_Collection:
            Behavior_Collection_.export(outfile, level, namespace_, name_='Behavior_Collection')
    def hasContent_(self):
        if (
            self.Behavior_Collection
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Behavior_Collection_Pool'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Behavior_Collection=[\n')
        level += 1
        for Behavior_Collection_ in self.Behavior_Collection:
            showIndent(outfile, level)
            outfile.write('model_.BehaviorCollectionType(\n')
            Behavior_Collection_.exportLiteral(outfile, level, name_='BehaviorCollectionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Behavior_Collection':
            obj_ = BehaviorCollectionType.factory()
            obj_.build(child_)
            self.Behavior_Collection.append(obj_)
# end class Behavior_Collection_Pool


class Behavior_Pool(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Behavior=None):
        if Behavior is None:
            self.Behavior = []
        else:
            self.Behavior = Behavior
    def factory(*args_, **kwargs_):
        if Behavior_Pool.subclass:
            return Behavior_Pool.subclass(*args_, **kwargs_)
        else:
            return Behavior_Pool(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Behavior(self): return self.Behavior
    def set_Behavior(self, Behavior): self.Behavior = Behavior
    def add_Behavior(self, value): self.Behavior.append(value)
    def insert_Behavior(self, index, value): self.Behavior[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Behavior_Pool', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Behavior_Pool')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Behavior_Pool'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Behavior_Pool'):
        for Behavior_ in self.Behavior:
            Behavior_.export(outfile, level, namespace_, name_='Behavior')
    def hasContent_(self):
        if (
            self.Behavior
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Behavior_Pool'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Behavior=[\n')
        level += 1
        for Behavior_ in self.Behavior:
            showIndent(outfile, level)
            outfile.write('model_.BehaviorType(\n')
            Behavior_.exportLiteral(outfile, level, name_='BehaviorType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Behavior':
            obj_ = BehaviorType.factory()
            obj_.build(child_)
            self.Behavior.append(obj_)
# end class Behavior_Pool


class Action_Collection_Pool(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Action_Collection=None):
        if Action_Collection is None:
            self.Action_Collection = []
        else:
            self.Action_Collection = Action_Collection
    def factory(*args_, **kwargs_):
        if Action_Collection_Pool.subclass:
            return Action_Collection_Pool.subclass(*args_, **kwargs_)
        else:
            return Action_Collection_Pool(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Action_Collection(self): return self.Action_Collection
    def set_Action_Collection(self, Action_Collection): self.Action_Collection = Action_Collection
    def add_Action_Collection(self, value): self.Action_Collection.append(value)
    def insert_Action_Collection(self, index, value): self.Action_Collection[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Action_Collection_Pool', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Action_Collection_Pool')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Action_Collection_Pool'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Action_Collection_Pool'):
        for Action_Collection_ in self.Action_Collection:
            Action_Collection_.export(outfile, level, namespace_, name_='Action_Collection')
    def hasContent_(self):
        if (
            self.Action_Collection
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Action_Collection_Pool'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Action_Collection=[\n')
        level += 1
        for Action_Collection_ in self.Action_Collection:
            showIndent(outfile, level)
            outfile.write('model_.ActionCollectionType(\n')
            Action_Collection_.exportLiteral(outfile, level, name_='ActionCollectionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Action_Collection':
            obj_ = ActionCollectionType.factory()
            obj_.build(child_)
            self.Action_Collection.append(obj_)
# end class Action_Collection_Pool


class Action_Pool(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Action=None):
        if Action is None:
            self.Action = []
        else:
            self.Action = Action
    def factory(*args_, **kwargs_):
        if Action_Pool.subclass:
            return Action_Pool.subclass(*args_, **kwargs_)
        else:
            return Action_Pool(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Action(self): return self.Action
    def set_Action(self, Action): self.Action = Action
    def add_Action(self, value): self.Action.append(value)
    def insert_Action(self, index, value): self.Action[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Action_Pool', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Action_Pool')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Action_Pool'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Action_Pool'):
        for Action_ in self.Action:
            Action_.export(outfile, level, namespace_, name_='Action')
    def hasContent_(self):
        if (
            self.Action
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Action_Pool'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Action=[\n')
        level += 1
        for Action_ in self.Action:
            showIndent(outfile, level)
            outfile.write('model_.ActionType(\n')
            Action_.exportLiteral(outfile, level, name_='ActionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Action':
            obj_ = ActionType.factory()
            obj_.build(child_)
            self.Action.append(obj_)
# end class Action_Pool


class Object_Pool(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Object=None):
        if Object is None:
            self.Object = []
        else:
            self.Object = Object
    def factory(*args_, **kwargs_):
        if Object_Pool.subclass:
            return Object_Pool.subclass(*args_, **kwargs_)
        else:
            return Object_Pool(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Object(self): return self.Object
    def set_Object(self, Object): self.Object = Object
    def add_Object(self, value): self.Object.append(value)
    def insert_Object(self, index, value): self.Object[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Object_Pool', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Object_Pool')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Object_Pool'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Object_Pool'):
        for Object_ in self.Object:
            Object_.export(outfile, level, namespace_, name_='Object')
    def hasContent_(self):
        if (
            self.Object
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Object_Pool'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Object=[\n')
        level += 1
        for Object_ in self.Object:
            showIndent(outfile, level)
            outfile.write('model_.ObjectType(\n')
            Object_.exportLiteral(outfile, level, name_='ObjectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Object':
            obj_ = ObjectType.factory()
            obj_.build(child_)
            self.Object.append(obj_)
# end class Object_Pool


class Effect_Pool(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Effect=None):
        if Effect is None:
            self.Effect = []
        else:
            self.Effect = Effect
    def factory(*args_, **kwargs_):
        if Effect_Pool.subclass:
            return Effect_Pool.subclass(*args_, **kwargs_)
        else:
            return Effect_Pool(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Effect(self): return self.Effect
    def set_Effect(self, Effect): self.Effect = Effect
    def add_Effect(self, value): self.Effect.append(value)
    def insert_Effect(self, index, value): self.Effect[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Effect_Pool', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Effect_Pool')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Effect_Pool'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Effect_Pool'):
        for Effect_ in self.Effect:
            Effect_.export(outfile, level, namespace_, name_='Effect')
    def hasContent_(self):
        if (
            self.Effect
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Effect_Pool'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Effect=[\n')
        level += 1
        for Effect_ in self.Effect:
            showIndent(outfile, level)
            outfile.write('model_.EffectType(\n')
            Effect_.exportLiteral(outfile, level, name_='EffectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Effect':
            obj_ = EffectType.factory()
            obj_.build(child_)
            self.Effect.append(obj_)
# end class Effect_Pool


class Object_Collection_Pool(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Object_Collection=None):
        if Object_Collection is None:
            self.Object_Collection = []
        else:
            self.Object_Collection = Object_Collection
    def factory(*args_, **kwargs_):
        if Object_Collection_Pool.subclass:
            return Object_Collection_Pool.subclass(*args_, **kwargs_)
        else:
            return Object_Collection_Pool(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Object_Collection(self): return self.Object_Collection
    def set_Object_Collection(self, Object_Collection): self.Object_Collection = Object_Collection
    def add_Object_Collection(self, value): self.Object_Collection.append(value)
    def insert_Object_Collection(self, index, value): self.Object_Collection[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Object_Collection_Pool', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Object_Collection_Pool')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Object_Collection_Pool'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Object_Collection_Pool'):
        for Object_Collection_ in self.Object_Collection:
            Object_Collection_.export(outfile, level, namespace_, name_='Object_Collection')
    def hasContent_(self):
        if (
            self.Object_Collection
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Object_Collection_Pool'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Object_Collection=[\n')
        level += 1
        for Object_Collection_ in self.Object_Collection:
            showIndent(outfile, level)
            outfile.write('model_.ObjectCollectionType(\n')
            Object_Collection_.exportLiteral(outfile, level, name_='ObjectCollectionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Object_Collection':
            obj_ = ObjectCollectionType.factory()
            obj_.build(child_)
            self.Object_Collection.append(obj_)
# end class Object_Collection_Pool


class BehaviorCollectionType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None, name=None, Affinity_Type=None, Affinity_Degree=None, Purpose=None, Description=None, Effects=None, Behavior_Sub_Collection=None, Behavior=None, Behavior_Reference=None):
        self.id = _cast(None, id)
        self.name = _cast(None, name)
        self.Affinity_Type = Affinity_Type
        self.Affinity_Degree = Affinity_Degree
        self.Purpose = Purpose
        self.Description = Description
        self.Effects = Effects
        if Behavior_Sub_Collection is None:
            self.Behavior_Sub_Collection = []
        else:
            self.Behavior_Sub_Collection = Behavior_Sub_Collection
        if Behavior is None:
            self.Behavior = []
        else:
            self.Behavior = Behavior
        if Behavior_Reference is None:
            self.Behavior_Reference = []
        else:
            self.Behavior_Reference = Behavior_Reference
    def factory(*args_, **kwargs_):
        if BehaviorCollectionType.subclass:
            return BehaviorCollectionType.subclass(*args_, **kwargs_)
        else:
            return BehaviorCollectionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Affinity_Type(self): return self.Affinity_Type
    def set_Affinity_Type(self, Affinity_Type): self.Affinity_Type = Affinity_Type
    def get_Affinity_Degree(self): return self.Affinity_Degree
    def set_Affinity_Degree(self, Affinity_Degree): self.Affinity_Degree = Affinity_Degree
    def get_Purpose(self): return self.Purpose
    def set_Purpose(self, Purpose): self.Purpose = Purpose
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Effects(self): return self.Effects
    def set_Effects(self, Effects): self.Effects = Effects
    def get_Behavior_Sub_Collection(self): return self.Behavior_Sub_Collection
    def set_Behavior_Sub_Collection(self, Behavior_Sub_Collection): self.Behavior_Sub_Collection = Behavior_Sub_Collection
    def add_Behavior_Sub_Collection(self, value): self.Behavior_Sub_Collection.append(value)
    def insert_Behavior_Sub_Collection(self, index, value): self.Behavior_Sub_Collection[index] = value
    def get_Behavior(self): return self.Behavior
    def set_Behavior(self, Behavior): self.Behavior = Behavior
    def add_Behavior(self, value): self.Behavior.append(value)
    def insert_Behavior(self, index, value): self.Behavior[index] = value
    def get_Behavior_Reference(self): return self.Behavior_Reference
    def set_Behavior_Reference(self, Behavior_Reference): self.Behavior_Reference = Behavior_Reference
    def add_Behavior_Reference(self, value): self.Behavior_Reference.append(value)
    def insert_Behavior_Reference(self, index, value): self.Behavior_Reference[index] = value
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def export(self, outfile, level, namespace_='maec:', name_='BehaviorCollectionType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='BehaviorCollectionType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='BehaviorCollectionType'):
        outfile.write(' id=%s' % (quote_attrib(self.id), ))
        if self.name is not None:
            outfile.write(' name=%s' % (self.format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='BehaviorCollectionType'):
        if self.Affinity_Type is not None:
            showIndent(outfile, level)
            outfile.write('<%sAffinity_Type>%s</%sAffinity_Type>\n' % (namespace_, self.format_string(quote_xml(self.Affinity_Type).encode(ExternalEncoding), input_name='Affinity_Type'), namespace_))
        if self.Affinity_Degree is not None:
            showIndent(outfile, level)
            outfile.write('<%sAffinity_Degree>%s</%sAffinity_Degree>\n' % (namespace_, self.format_string(quote_xml(self.Affinity_Degree).encode(ExternalEncoding), input_name='Affinity_Degree'), namespace_))
        if self.Purpose is not None:
            showIndent(outfile, level)
            outfile.write('<%sPurpose>%s</%sPurpose>\n' % (namespace_, self.format_string(quote_xml(self.Purpose).encode(ExternalEncoding), input_name='Purpose'), namespace_))
        if self.Description:
            self.Description.export(outfile, level, namespace_, name_='Description')
        if self.Effects:
            self.Effects.export(outfile, level, namespace_, name_='Effects')
        for Behavior_Sub_Collection_ in self.Behavior_Sub_Collection:
            Behavior_Sub_Collection_.export(outfile, level, namespace_, name_='Behavior_Sub_Collection')
        for Behavior_ in self.Behavior:
            Behavior_.export(outfile, level, namespace_, name_='Behavior')
        for Behavior_Reference_ in self.Behavior_Reference:
            Behavior_Reference_.export(outfile, level, namespace_, name_='Behavior_Reference')
    def hasContent_(self):
        if (
            self.Affinity_Type is not None or
            self.Affinity_Degree is not None or
            self.Purpose is not None or
            self.Description is not None or
            self.Effects is not None or
            self.Behavior_Sub_Collection or
            self.Behavior or
            self.Behavior_Reference
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='BehaviorCollectionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name = "%s",\n' % (self.name,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Affinity_Type is not None:
            showIndent(outfile, level)
            outfile.write('Affinity_Type=%s,\n' % quote_python(self.Affinity_Type).encode(ExternalEncoding))
        if self.Affinity_Degree is not None:
            showIndent(outfile, level)
            outfile.write('Affinity_Degree=%s,\n' % quote_python(self.Affinity_Degree).encode(ExternalEncoding))
        if self.Purpose is not None:
            showIndent(outfile, level)
            outfile.write('Purpose=model_.xs_string(\n')
            self.Purpose.exportLiteral(outfile, level, name_='Purpose')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=model_.StructuredTextType(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Effects is not None:
            showIndent(outfile, level)
            outfile.write('Effects=model_.Effects(\n')
            self.Effects.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Behavior_Sub_Collection=[\n')
        level += 1
        for Behavior_Sub_Collection_ in self.Behavior_Sub_Collection:
            showIndent(outfile, level)
            outfile.write('model_.BehaviorCollectionType(\n')
            Behavior_Sub_Collection_.exportLiteral(outfile, level, name_='BehaviorCollectionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Behavior=[\n')
        level += 1
        for Behavior_ in self.Behavior:
            showIndent(outfile, level)
            outfile.write('model_.BehaviorType(\n')
            Behavior_.exportLiteral(outfile, level, name_='BehaviorType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Behavior_Reference=[\n')
        level += 1
        for Behavior_Reference_ in self.Behavior_Reference:
            showIndent(outfile, level)
            outfile.write('model_.BehaviorReferenceType(\n')
            Behavior_Reference_.exportLiteral(outfile, level, name_='BehaviorReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('id'):
            self.id = attrs.get('id').value
        if attrs.get('name'):
            self.name = attrs.get('name').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Affinity_Type':
            Affinity_Type_ = ''
            for text__content_ in child_.childNodes:
                Affinity_Type_ += text__content_.nodeValue
            self.Affinity_Type = Affinity_Type_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Affinity_Degree':
            Affinity_Degree_ = ''
            for text__content_ in child_.childNodes:
                Affinity_Degree_ += text__content_.nodeValue
            self.Affinity_Degree = Affinity_Degree_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Purpose':
            Purpose_ = ''
            for text__content_ in child_.childNodes:
                Purpose_ += text__content_.nodeValue
            self.Purpose = Purpose_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Description':
            obj_ = StructuredTextType.factory()
            obj_.build(child_)
            self.set_Description(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Effects':
            obj_ = Effects.factory()
            obj_.build(child_)
            self.set_Effects(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Behavior_Sub_Collection':
            obj_ = BehaviorCollectionType.factory()
            obj_.build(child_)
            self.Behavior_Sub_Collection.append(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Behavior':
            obj_ = BehaviorType.factory()
            obj_.build(child_)
            self.Behavior.append(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Behavior_Reference':
            obj_ = BehaviorReferenceType.factory()
            obj_.build(child_)
            self.Behavior_Reference.append(obj_)
# end class BehaviorCollectionType


class Effects(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Effect=None):
        if Effect is None:
            self.Effect = []
        else:
            self.Effect = Effect
    def factory(*args_, **kwargs_):
        if Effects.subclass:
            return Effects.subclass(*args_, **kwargs_)
        else:
            return Effects(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Effect(self): return self.Effect
    def set_Effect(self, Effect): self.Effect = Effect
    def add_Effect(self, value): self.Effect.append(value)
    def insert_Effect(self, index, value): self.Effect[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Effects', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Effects')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Effects'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Effects'):
        for Effect_ in self.Effect:
            Effect_.export(outfile, level, namespace_, name_='Effect')
    def hasContent_(self):
        if (
            self.Effect
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Effects'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Effect=[\n')
        level += 1
        for Effect_ in self.Effect:
            showIndent(outfile, level)
            outfile.write('model_.EffectType(\n')
            Effect_.exportLiteral(outfile, level, name_='EffectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Effect':
            obj_ = EffectType.factory()
            obj_.build(child_)
            self.Effect.append(obj_)
# end class Effects


class BehaviorType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, successful=None, duration=None, ordinal_position=None, id=None, Purpose=None, Description=None, Discovery_Method=None, Actions=None, Objects=None, Effects=None, Related_Behaviors=None):
        self.successful = _cast(bool, successful)
        self.duration = _cast(None, duration)
        self.ordinal_position = _cast(int, ordinal_position)
        self.id = _cast(None, id)
        self.Purpose = Purpose
        self.Description = Description
        self.Discovery_Method = Discovery_Method
        self.Actions = Actions
        self.Objects = Objects
        self.Effects = Effects
        self.Related_Behaviors = Related_Behaviors
    def factory(*args_, **kwargs_):
        if BehaviorType.subclass:
            return BehaviorType.subclass(*args_, **kwargs_)
        else:
            return BehaviorType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Purpose(self): return self.Purpose
    def set_Purpose(self, Purpose): self.Purpose = Purpose
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Discovery_Method(self): return self.Discovery_Method
    def set_Discovery_Method(self, Discovery_Method): self.Discovery_Method = Discovery_Method
    def get_Actions(self): return self.Actions
    def set_Actions(self, Actions): self.Actions = Actions
    def get_Objects(self): return self.Objects
    def set_Objects(self, Objects): self.Objects = Objects
    def get_Effects(self): return self.Effects
    def set_Effects(self, Effects): self.Effects = Effects
    def get_Related_Behaviors(self): return self.Related_Behaviors
    def set_Related_Behaviors(self, Related_Behaviors): self.Related_Behaviors = Related_Behaviors
    def get_successful(self): return self.successful
    def set_successful(self, successful): self.successful = successful
    def get_duration(self): return self.duration
    def set_duration(self, duration): self.duration = duration
    def get_ordinal_position(self): return self.ordinal_position
    def set_ordinal_position(self, ordinal_position): self.ordinal_position = ordinal_position
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='maec:', name_='BehaviorType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='BehaviorType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='BehaviorType'):
        if self.successful is not None:
            outfile.write(' successful="%s"' % self.format_boolean(str_lower(str(self.successful)), input_name='successful'))
        if self.duration is not None:
            outfile.write(' duration=%s' % (self.format_string(quote_attrib(self.duration).encode(ExternalEncoding), input_name='duration'), ))
        if self.ordinal_position is not None:
            outfile.write(' ordinal_position="%s"' % self.format_integer(self.ordinal_position, input_name='ordinal_position'))
        outfile.write(' id=%s' % (quote_attrib(self.id), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='BehaviorType'):
        if self.Purpose:
            self.Purpose.export(outfile, level, namespace_, name_='Purpose')
        if self.Description:
            self.Description.export(outfile, level, namespace_, name_='Description')
        if self.Discovery_Method:
            self.Discovery_Method.export(outfile, level, namespace_, name_='Discovery_Method')
        if self.Actions:
            self.Actions.export(outfile, level, namespace_, name_='Actions')
        if self.Objects:
            self.Objects.export(outfile, level, namespace_, name_='Objects')
        if self.Effects:
            self.Effects.export(outfile, level, namespace_, name_='Effects')
        if self.Related_Behaviors:
            self.Related_Behaviors.export(outfile, level, namespace_, name_='Related_Behaviors')
    def hasContent_(self):
        if (
            self.Purpose is not None or
            self.Description is not None or
            self.Discovery_Method is not None or
            self.Actions is not None or
            self.Objects is not None or
            self.Effects is not None or
            self.Related_Behaviors is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='BehaviorType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.successful is not None:
            showIndent(outfile, level)
            outfile.write('successful = %s,\n' % (self.successful,))
        if self.duration is not None:
            showIndent(outfile, level)
            outfile.write('duration = "%s",\n' % (self.duration,))
        if self.ordinal_position is not None:
            showIndent(outfile, level)
            outfile.write('ordinal_position = %d,\n' % (self.ordinal_position,))
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Purpose is not None:
            showIndent(outfile, level)
            outfile.write('Purpose=model_.Purpose(\n')
            self.Purpose.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=model_.StructuredTextType(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Discovery_Method is not None:
            showIndent(outfile, level)
            outfile.write('Discovery_Method=model_.DiscoveryMethod(\n')
            self.Discovery_Method.exportLiteral(outfile, level, name_='Discovery_Method')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Actions is not None:
            showIndent(outfile, level)
            outfile.write('Actions=model_.Actions(\n')
            self.Actions.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Objects is not None:
            showIndent(outfile, level)
            outfile.write('Objects=model_.Objects(\n')
            self.Objects.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Effects is not None:
            showIndent(outfile, level)
            outfile.write('Effects=model_.Effects(\n')
            self.Effects.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Related_Behaviors is not None:
            showIndent(outfile, level)
            outfile.write('Related_Behaviors=model_.Related_Behaviors(\n')
            self.Related_Behaviors.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('successful'):
            if attrs.get('successful').value in ('true', '1'):
                self.successful = True
            elif attrs.get('successful').value in ('false', '0'):
                self.successful = False
            else:
                raise ValueError('Bad boolean attribute (successful)')
        if attrs.get('duration'):
            self.duration = attrs.get('duration').value
        if attrs.get('ordinal_position'):
            try:
                self.ordinal_position = int(attrs.get('ordinal_position').value)
            except ValueError as exp:
                raise ValueError('Bad integer attribute (ordinal_position): %s' % exp)
            if self.ordinal_position <= 0:
                raise ValueError('Invalid PositiveInteger (ordinal_position)')
        if attrs.get('id'):
            self.id = attrs.get('id').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Purpose':
            obj_ = Purpose.factory()
            obj_.build(child_)
            self.set_Purpose(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Description':
            obj_ = StructuredTextType.factory()
            obj_.build(child_)
            self.set_Description(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Discovery_Method':
            obj_ = DiscoveryMethod.factory()
            obj_.build(child_)
            self.set_Discovery_Method(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Actions':
            obj_ = Actions.factory()
            obj_.build(child_)
            self.set_Actions(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Objects':
            obj_ = Objects.factory()
            obj_.build(child_)
            self.set_Objects(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Effects':
            obj_ = Effects.factory()
            obj_.build(child_)
            self.set_Effects(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Related_Behaviors':
            obj_ = Related_Behaviors.factory()
            obj_.build(child_)
            self.set_Related_Behaviors(obj_)
# end class BehaviorType


class Purpose(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Description=None, Attempted_Vulnerability_Exploit=None):
        self.Description = Description
        self.Attempted_Vulnerability_Exploit = Attempted_Vulnerability_Exploit
    def factory(*args_, **kwargs_):
        if Purpose.subclass:
            return Purpose.subclass(*args_, **kwargs_)
        else:
            return Purpose(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Attempted_Vulnerability_Exploit(self): return self.Attempted_Vulnerability_Exploit
    def set_Attempted_Vulnerability_Exploit(self, Attempted_Vulnerability_Exploit): self.Attempted_Vulnerability_Exploit = Attempted_Vulnerability_Exploit
    def export(self, outfile, level, namespace_='maec:', name_='Purpose', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Purpose')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Purpose'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Purpose'):
        if self.Description:
            self.Description.export(outfile, level, namespace_, name_='Description')
        if self.Attempted_Vulnerability_Exploit:
            self.Attempted_Vulnerability_Exploit.export(outfile, level, namespace_, name_='Attempted_Vulnerability_Exploit')
    def hasContent_(self):
        if (
            self.Description is not None or
            self.Attempted_Vulnerability_Exploit is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Purpose'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=model_.StructuredTextType(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Attempted_Vulnerability_Exploit is not None:
            showIndent(outfile, level)
            outfile.write('Attempted_Vulnerability_Exploit=model_.Attempted_Vulnerability_Exploit(\n')
            self.Attempted_Vulnerability_Exploit.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Description':
            obj_ = StructuredTextType.factory()
            obj_.build(child_)
            self.set_Description(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Attempted_Vulnerability_Exploit':
            obj_ = Attempted_Vulnerability_Exploit.factory()
            obj_.build(child_)
            self.set_Attempted_Vulnerability_Exploit(obj_)
# end class Purpose


class Attempted_Vulnerability_Exploit(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, vulnerability_type=None, Known_Exploit=None):
        self.vulnerability_type = _cast(None, vulnerability_type)
        self.Known_Exploit = Known_Exploit
    def factory(*args_, **kwargs_):
        if Attempted_Vulnerability_Exploit.subclass:
            return Attempted_Vulnerability_Exploit.subclass(*args_, **kwargs_)
        else:
            return Attempted_Vulnerability_Exploit(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Known_Exploit(self): return self.Known_Exploit
    def set_Known_Exploit(self, Known_Exploit): self.Known_Exploit = Known_Exploit
    def get_vulnerability_type(self): return self.vulnerability_type
    def set_vulnerability_type(self, vulnerability_type): self.vulnerability_type = vulnerability_type
    def export(self, outfile, level, namespace_='maec:', name_='Attempted_Vulnerability_Exploit', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Attempted_Vulnerability_Exploit')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Attempted_Vulnerability_Exploit'):
        if self.vulnerability_type is not None:
            outfile.write(' vulnerability_type=%s' % (self.format_string(quote_attrib(self.vulnerability_type).encode(ExternalEncoding), input_name='vulnerability_type'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Attempted_Vulnerability_Exploit'):
        if self.Known_Exploit:
            self.Known_Exploit.export(outfile, level, namespace_, name_='Known_Exploit', )
    def hasContent_(self):
        if (
            self.Known_Exploit is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Attempted_Vulnerability_Exploit'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.vulnerability_type is not None:
            showIndent(outfile, level)
            outfile.write('vulnerability_type = "%s",\n' % (self.vulnerability_type,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Known_Exploit is not None:
            showIndent(outfile, level)
            outfile.write('Known_Exploit=model_.CVEVulnerabilityType(\n')
            self.Known_Exploit.exportLiteral(outfile, level, name_='Known_Exploit')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('vulnerability_type'):
            self.vulnerability_type = attrs.get('vulnerability_type').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Known_Exploit':
            obj_ = CVEVulnerabilityType.factory()
            obj_.build(child_)
            self.set_Known_Exploit(obj_)
# end class Attempted_Vulnerability_Exploit


class Objects(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Object_Reference=None, Object=None):
        if Object_Reference is None:
            self.Object_Reference = []
        else:
            self.Object_Reference = Object_Reference
        if Object is None:
            self.Object = []
        else:
            self.Object = Object
    def factory(*args_, **kwargs_):
        if Objects.subclass:
            return Objects.subclass(*args_, **kwargs_)
        else:
            return Objects(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Object_Reference(self): return self.Object_Reference
    def set_Object_Reference(self, Object_Reference): self.Object_Reference = Object_Reference
    def add_Object_Reference(self, value): self.Object_Reference.append(value)
    def insert_Object_Reference(self, index, value): self.Object_Reference[index] = value
    def get_Object(self): return self.Object
    def set_Object(self, Object): self.Object = Object
    def add_Object(self, value): self.Object.append(value)
    def insert_Object(self, index, value): self.Object[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Objects', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Objects')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Objects'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Objects'):
        for Object_Reference_ in self.Object_Reference:
            Object_Reference_.export(outfile, level, namespace_, name_='Object_Reference')
        for Object_ in self.Object:
            Object_.export(outfile, level, namespace_, name_='Object')
    def hasContent_(self):
        if (
            self.Object_Reference or
            self.Object
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Objects'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Object_Reference=[\n')
        level += 1
        for Object_Reference_ in self.Object_Reference:
            showIndent(outfile, level)
            outfile.write('model_.ObjectReferenceType(\n')
            Object_Reference_.exportLiteral(outfile, level, name_='ObjectReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Object=[\n')
        level += 1
        for Object_ in self.Object:
            showIndent(outfile, level)
            outfile.write('model_.ObjectType(\n')
            Object_.exportLiteral(outfile, level, name_='ObjectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Object_Reference':
            obj_ = ObjectReferenceType.factory()
            obj_.build(child_)
            self.Object_Reference.append(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Object':
            obj_ = ObjectType.factory()
            obj_.build(child_)
            self.Object.append(obj_)
# end class Objects


class Related_Behaviors(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Related_Behavior=None):
        if Related_Behavior is None:
            self.Related_Behavior = []
        else:
            self.Related_Behavior = Related_Behavior
    def factory(*args_, **kwargs_):
        if Related_Behaviors.subclass:
            return Related_Behaviors.subclass(*args_, **kwargs_)
        else:
            return Related_Behaviors(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Related_Behavior(self): return self.Related_Behavior
    def set_Related_Behavior(self, Related_Behavior): self.Related_Behavior = Related_Behavior
    def add_Related_Behavior(self, value): self.Related_Behavior.append(value)
    def insert_Related_Behavior(self, index, value): self.Related_Behavior[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Related_Behaviors', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Related_Behaviors')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Related_Behaviors'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Related_Behaviors'):
        for Related_Behavior_ in self.Related_Behavior:
            Related_Behavior_.export(outfile, level, namespace_, name_='Related_Behavior')
    def hasContent_(self):
        if (
            self.Related_Behavior
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Related_Behaviors'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Related_Behavior=[\n')
        level += 1
        for Related_Behavior_ in self.Related_Behavior:
            showIndent(outfile, level)
            outfile.write('model_.Related_Behavior(\n')
            Related_Behavior_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Related_Behavior':
            obj_ = Related_Behavior.factory()
            obj_.build(child_)
            self.Related_Behavior.append(obj_)
# end class Related_Behaviors


class Related_Behavior(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Behavior_Reference=None, Nature_of_Relationship=None):
        self.Behavior_Reference = Behavior_Reference
        self.Nature_of_Relationship = Nature_of_Relationship
    def factory(*args_, **kwargs_):
        if Related_Behavior.subclass:
            return Related_Behavior.subclass(*args_, **kwargs_)
        else:
            return Related_Behavior(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Behavior_Reference(self): return self.Behavior_Reference
    def set_Behavior_Reference(self, Behavior_Reference): self.Behavior_Reference = Behavior_Reference
    def get_Nature_of_Relationship(self): return self.Nature_of_Relationship
    def set_Nature_of_Relationship(self, Nature_of_Relationship): self.Nature_of_Relationship = Nature_of_Relationship
    def validate_Nature_of_Relationship(self, value):
        # Validate type Nature_of_Relationship, a restriction on xs:string.
        pass
    def export(self, outfile, level, namespace_='maec:', name_='Related_Behavior', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Related_Behavior')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Related_Behavior'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Related_Behavior'):
        if self.Behavior_Reference:
            self.Behavior_Reference.export(outfile, level, namespace_, name_='Behavior_Reference', )
        if self.Nature_of_Relationship is not None:
            showIndent(outfile, level)
            outfile.write('<%sNature_of_Relationship>%s</%sNature_of_Relationship>\n' % (namespace_, self.format_string(quote_xml(self.Nature_of_Relationship).encode(ExternalEncoding), input_name='Nature_of_Relationship'), namespace_))
    def hasContent_(self):
        if (
            self.Behavior_Reference is not None or
            self.Nature_of_Relationship is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Related_Behavior'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Behavior_Reference is not None:
            showIndent(outfile, level)
            outfile.write('Behavior_Reference=model_.BehaviorReferenceType(\n')
            self.Behavior_Reference.exportLiteral(outfile, level, name_='Behavior_Reference')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Nature_of_Relationship is not None:
            showIndent(outfile, level)
            outfile.write('Nature_of_Relationship=%s,\n' % quote_python(self.Nature_of_Relationship).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Behavior_Reference':
            obj_ = BehaviorReferenceType.factory()
            obj_.build(child_)
            self.set_Behavior_Reference(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Nature_of_Relationship':
            Nature_of_Relationship_ = ''
            for text__content_ in child_.childNodes:
                Nature_of_Relationship_ += text__content_.nodeValue
            self.Nature_of_Relationship = Nature_of_Relationship_
            self.validate_Nature_of_Relationship(self.Nature_of_Relationship)    # validate type Nature_of_Relationship
# end class Related_Behavior


class Nature_of_Relationship(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=''):
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Nature_of_Relationship.subclass:
            return Nature_of_Relationship.subclass(*args_, **kwargs_)
        else:
            return Nature_of_Relationship(*args_, **kwargs_)
    factory = staticmethod(factory)
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='maec:', name_='Nature_of_Relationship', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Nature_of_Relationship')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Nature_of_Relationship'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Nature_of_Relationship'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value)
        else:
            outfile.write(quote_xml('%s' % self.valueOf_))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Nature_of_Relationship'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class Nature_of_Relationship


class BehaviorReferenceType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, behavior_id=None, valueOf_=''):
        self.type_ = _cast(None, type_)
        self.behavior_id = _cast(None, behavior_id)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if BehaviorReferenceType.subclass:
            return BehaviorReferenceType.subclass(*args_, **kwargs_)
        else:
            return BehaviorReferenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_behavior_id(self): return self.behavior_id
    def set_behavior_id(self, behavior_id): self.behavior_id = behavior_id
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='maec:', name_='BehaviorReferenceType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='BehaviorReferenceType')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='BehaviorReferenceType'):
        if self.type_ is not None:
            outfile.write(' type=%s' % (self.format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        outfile.write(' behavior_id=%s' % (quote_attrib(self.behavior_id), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='BehaviorReferenceType'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value)
        else:
            outfile.write(quote_xml('%s' % self.valueOf_))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='BehaviorReferenceType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
        if self.behavior_id is not None:
            showIndent(outfile, level)
            outfile.write('behavior_id = %s,\n' % (self.behavior_id,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('type'):
            self.type_ = attrs.get('type').value
        if attrs.get('behavior_id'):
            self.behavior_id = attrs.get('behavior_id').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class BehaviorReferenceType


class ActionCollectionType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None, name=None, Affinity_Type=None, Affinity_Degree=None, Description=None, Action_Sub_Collection=None, Action=None, Action_Reference=None, Effects=None):
        self.id = _cast(None, id)
        self.name = _cast(None, name)
        self.Affinity_Type = Affinity_Type
        self.Affinity_Degree = Affinity_Degree
        self.Description = Description
        if Action_Sub_Collection is None:
            self.Action_Sub_Collection = []
        else:
            self.Action_Sub_Collection = Action_Sub_Collection
        if Action is None:
            self.Action = []
        else:
            self.Action = Action
        if Action_Reference is None:
            self.Action_Reference = []
        else:
            self.Action_Reference = Action_Reference
        self.Effects = Effects
    def factory(*args_, **kwargs_):
        if ActionCollectionType.subclass:
            return ActionCollectionType.subclass(*args_, **kwargs_)
        else:
            return ActionCollectionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Affinity_Type(self): return self.Affinity_Type
    def set_Affinity_Type(self, Affinity_Type): self.Affinity_Type = Affinity_Type
    def get_Affinity_Degree(self): return self.Affinity_Degree
    def set_Affinity_Degree(self, Affinity_Degree): self.Affinity_Degree = Affinity_Degree
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Action_Sub_Collection(self): return self.Action_Sub_Collection
    def set_Action_Sub_Collection(self, Action_Sub_Collection): self.Action_Sub_Collection = Action_Sub_Collection
    def add_Action_Sub_Collection(self, value): self.Action_Sub_Collection.append(value)
    def insert_Action_Sub_Collection(self, index, value): self.Action_Sub_Collection[index] = value
    def get_Action(self): return self.Action
    def set_Action(self, Action): self.Action = Action
    def add_Action(self, value): self.Action.append(value)
    def insert_Action(self, index, value): self.Action[index] = value
    def get_Action_Reference(self): return self.Action_Reference
    def set_Action_Reference(self, Action_Reference): self.Action_Reference = Action_Reference
    def add_Action_Reference(self, value): self.Action_Reference.append(value)
    def insert_Action_Reference(self, index, value): self.Action_Reference[index] = value
    def get_Effects(self): return self.Effects
    def set_Effects(self, Effects): self.Effects = Effects
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def export(self, outfile, level, namespace_='maec:', name_='ActionCollectionType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='ActionCollectionType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='ActionCollectionType'):
        outfile.write(' id=%s' % (quote_attrib(self.id), ))
        if self.name is not None:
            outfile.write(' name=%s' % (self.format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ActionCollectionType'):
        if self.Affinity_Type is not None:
            showIndent(outfile, level)
            outfile.write('<%sAffinity_Type>%s</%sAffinity_Type>\n' % (namespace_, self.format_string(quote_xml(self.Affinity_Type).encode(ExternalEncoding), input_name='Affinity_Type'), namespace_))
        if self.Affinity_Degree is not None:
            showIndent(outfile, level)
            outfile.write('<%sAffinity_Degree>%s</%sAffinity_Degree>\n' % (namespace_, self.format_string(quote_xml(self.Affinity_Degree).encode(ExternalEncoding), input_name='Affinity_Degree'), namespace_))
        if self.Description:
            self.Description.export(outfile, level, namespace_, name_='Description')
        for Action_Sub_Collection_ in self.Action_Sub_Collection:
            Action_Sub_Collection_.export(outfile, level, namespace_, name_='Action_Sub_Collection')
        for Action_ in self.Action:
            Action_.export(outfile, level, namespace_, name_='Action')
        for Action_Reference_ in self.Action_Reference:
            Action_Reference_.export(outfile, level, namespace_, name_='Action_Reference')
        if self.Effects:
            self.Effects.export(outfile, level, namespace_, name_='Effects')
    def hasContent_(self):
        if (
            self.Affinity_Type is not None or
            self.Affinity_Degree is not None or
            self.Description is not None or
            self.Action_Sub_Collection or
            self.Action or
            self.Action_Reference or
            self.Effects is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ActionCollectionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name = "%s",\n' % (self.name,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Affinity_Type is not None:
            showIndent(outfile, level)
            outfile.write('Affinity_Type=%s,\n' % quote_python(self.Affinity_Type).encode(ExternalEncoding))
        if self.Affinity_Degree is not None:
            showIndent(outfile, level)
            outfile.write('Affinity_Degree=%s,\n' % quote_python(self.Affinity_Degree).encode(ExternalEncoding))
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=model_.StructuredTextType(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Action_Sub_Collection=[\n')
        level += 1
        for Action_Sub_Collection_ in self.Action_Sub_Collection:
            showIndent(outfile, level)
            outfile.write('model_.ActionCollectionType(\n')
            Action_Sub_Collection_.exportLiteral(outfile, level, name_='ActionCollectionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Action=[\n')
        level += 1
        for Action_ in self.Action:
            showIndent(outfile, level)
            outfile.write('model_.ActionType(\n')
            Action_.exportLiteral(outfile, level, name_='ActionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Action_Reference=[\n')
        level += 1
        for Action_Reference_ in self.Action_Reference:
            showIndent(outfile, level)
            outfile.write('model_.ActionReferenceType(\n')
            Action_Reference_.exportLiteral(outfile, level, name_='ActionReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Effects is not None:
            showIndent(outfile, level)
            outfile.write('Effects=model_.Effects(\n')
            self.Effects.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('id'):
            self.id = attrs.get('id').value
        if attrs.get('name'):
            self.name = attrs.get('name').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Affinity_Type':
            Affinity_Type_ = ''
            for text__content_ in child_.childNodes:
                Affinity_Type_ += text__content_.nodeValue
            self.Affinity_Type = Affinity_Type_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Affinity_Degree':
            Affinity_Degree_ = ''
            for text__content_ in child_.childNodes:
                Affinity_Degree_ += text__content_.nodeValue
            self.Affinity_Degree = Affinity_Degree_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Description':
            obj_ = StructuredTextType.factory()
            obj_.build(child_)
            self.set_Description(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Action_Sub-Collection':
            obj_ = ActionCollectionType.factory()
            obj_.build(child_)
            self.Action_Sub_Collection.append(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Action':
            obj_ = ActionType.factory()
            obj_.build(child_)
            self.Action.append(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Action_Reference':
            obj_ = ActionReferenceType.factory()
            obj_.build(child_)
            self.Action_Reference.append(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Effects':
            obj_ = Effects.factory()
            obj_.build(child_)
            self.set_Effects(obj_)
# end class ActionCollectionType


class ActionType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, successful=None, timestamp=None, action_name=None, ordinal_position=None, type_=None, id=None, Description=None, Discovery_Method=None, Action_Initiator=None, Action_Implementation=None, Objects=None, Effects=None, Related_Actions=None):
        self.successful = _cast(bool, successful)
        self.timestamp = _cast(None, timestamp)
        self.action_name = _cast(None, action_name)
        self.ordinal_position = _cast(int, ordinal_position)
        self.type_ = _cast(None, type_)
        self.id = _cast(None, id)
        self.Description = Description
        self.Discovery_Method = Discovery_Method
        self.Action_Initiator = Action_Initiator
        self.Action_Implementation = Action_Implementation
        self.Objects = Objects
        self.Effects = Effects
        self.Related_Actions = Related_Actions
    def factory(*args_, **kwargs_):
        if ActionType.subclass:
            return ActionType.subclass(*args_, **kwargs_)
        else:
            return ActionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Discovery_Method(self): return self.Discovery_Method
    def set_Discovery_Method(self, Discovery_Method): self.Discovery_Method = Discovery_Method
    def get_Action_Initiator(self): return self.Action_Initiator
    def set_Action_Initiator(self, Action_Initiator): self.Action_Initiator = Action_Initiator
    def get_Action_Implementation(self): return self.Action_Implementation
    def set_Action_Implementation(self, Action_Implementation): self.Action_Implementation = Action_Implementation
    def get_Objects(self): return self.Objects
    def set_Objects(self, Objects): self.Objects = Objects
    def get_Effects(self): return self.Effects
    def set_Effects(self, Effects): self.Effects = Effects
    def get_Related_Actions(self): return self.Related_Actions
    def set_Related_Actions(self, Related_Actions): self.Related_Actions = Related_Actions
    def get_successful(self): return self.successful
    def set_successful(self, successful): self.successful = successful
    def get_timestamp(self): return self.timestamp
    def set_timestamp(self, timestamp): self.timestamp = timestamp
    def get_action_name(self): return self.action_name
    def set_action_name(self, action_name): self.action_name = action_name
    def get_ordinal_position(self): return self.ordinal_position
    def set_ordinal_position(self, ordinal_position): self.ordinal_position = ordinal_position
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='maec:', name_='ActionType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='ActionType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='ActionType'):
        if self.successful is not None:
            outfile.write(' successful="%s"' % self.format_boolean(str_lower(str(self.successful)), input_name='successful'))
        if self.timestamp is not None:
            outfile.write(' timestamp=%s' % (quote_attrib(self.timestamp), ))
        if self.action_name is not None:
            outfile.write(' action_name=%s' % (self.format_string(quote_attrib(self.action_name).encode(ExternalEncoding), input_name='action_name'), ))
        if self.ordinal_position is not None:
            outfile.write(' ordinal_position="%s"' % self.format_integer(self.ordinal_position, input_name='ordinal_position'))
        if self.type_ is not None:
            outfile.write(' type=%s' % (quote_attrib(self.type_), ))
        outfile.write(' id=%s' % (quote_attrib(self.id), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ActionType'):
        if self.Description:
            self.Description.export(outfile, level, namespace_, name_='Description')
        if self.Discovery_Method:
            self.Discovery_Method.export(outfile, level, namespace_, name_='Discovery_Method')
        if self.Action_Initiator:
            self.Action_Initiator.export(outfile, level, namespace_, name_='Action_Initiator')
        if self.Action_Implementation:
            self.Action_Implementation.export(outfile, level, namespace_, name_='Action_Implementation')
        if self.Objects:
            self.Objects.export(outfile, level, namespace_, name_='Objects')
        if self.Effects:
            self.Effects.export(outfile, level, namespace_, name_='Effects')
        if self.Related_Actions:
            self.Related_Actions.export(outfile, level, namespace_, name_='Related_Actions')
    def hasContent_(self):
        if (
            self.Description is not None or
            self.Discovery_Method is not None or
            self.Action_Initiator is not None or
            self.Action_Implementation is not None or
            self.Objects is not None or
            self.Effects is not None or
            self.Related_Actions is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ActionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.successful is not None:
            showIndent(outfile, level)
            outfile.write('successful = %s,\n' % (self.successful,))
        if self.timestamp is not None:
            showIndent(outfile, level)
            outfile.write('timestamp = %s,\n' % (self.timestamp,))
        if self.action_name is not None:
            showIndent(outfile, level)
            outfile.write('action_name = "%s",\n' % (self.action_name,))
        if self.ordinal_position is not None:
            showIndent(outfile, level)
            outfile.write('ordinal_position = %d,\n' % (self.ordinal_position,))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_ = %s,\n' % (self.type_,))
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=model_.StructuredTextType(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Discovery_Method is not None:
            showIndent(outfile, level)
            outfile.write('Discovery_Method=model_.DiscoveryMethod(\n')
            self.Discovery_Method.exportLiteral(outfile, level, name_='Discovery_Method')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Action_Initiator is not None:
            showIndent(outfile, level)
            outfile.write('Action_Initiator=model_.Action_Initiator(\n')
            self.Action_Initiator.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Action_Implementation is not None:
            showIndent(outfile, level)
            outfile.write('Action_Implementation=model_.ActionImplementationType(\n')
            self.Action_Implementation.exportLiteral(outfile, level, name_='Action_Implementation')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Objects is not None:
            showIndent(outfile, level)
            outfile.write('Objects=model_.Objects(\n')
            self.Objects.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Effects is not None:
            showIndent(outfile, level)
            outfile.write('Effects=model_.Effects(\n')
            self.Effects.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Related_Actions is not None:
            showIndent(outfile, level)
            outfile.write('Related_Actions=model_.Related_Actions(\n')
            self.Related_Actions.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('successful'):
            if attrs.get('successful').value in ('true', '1'):
                self.successful = True
            elif attrs.get('successful').value in ('false', '0'):
                self.successful = False
            else:
                raise ValueError('Bad boolean attribute (successful)')
        if attrs.get('timestamp'):
            self.timestamp = attrs.get('timestamp').value
        if attrs.get('action_name'):
            self.action_name = attrs.get('action_name').value
        if attrs.get('ordinal_position'):
            try:
                self.ordinal_position = int(attrs.get('ordinal_position').value)
            except ValueError as exp:
                raise ValueError('Bad integer attribute (ordinal_position): %s' % exp)
            if self.ordinal_position <= 0:
                raise ValueError('Invalid PositiveInteger (ordinal_position)')
        if attrs.get('type'):
            self.type_ = attrs.get('type').value
        if attrs.get('id'):
            self.id = attrs.get('id').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Description':
            obj_ = StructuredTextType.factory()
            obj_.build(child_)
            self.set_Description(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Discovery_Method':
            obj_ = DiscoveryMethod.factory()
            obj_.build(child_)
            self.set_Discovery_Method(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Action_Initiator':
            obj_ = Action_Initiator.factory()
            obj_.build(child_)
            self.set_Action_Initiator(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Action_Implementation':
            obj_ = ActionImplementationType.factory()
            obj_.build(child_)
            self.set_Action_Implementation(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Objects':
            obj_ = Objects.factory()
            obj_.build(child_)
            self.set_Objects(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Effects':
            obj_ = Effects.factory()
            obj_.build(child_)
            self.set_Effects(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Related_Actions':
            obj_ = Related_Actions.factory()
            obj_.build(child_)
            self.set_Related_Actions(obj_)
# end class ActionType


class Action_Initiator(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, Initiator_Object=None):
        self.type_ = _cast(None, type_)
        self.Initiator_Object = Initiator_Object
    def factory(*args_, **kwargs_):
        if Action_Initiator.subclass:
            return Action_Initiator.subclass(*args_, **kwargs_)
        else:
            return Action_Initiator(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Initiator_Object(self): return self.Initiator_Object
    def set_Initiator_Object(self, Initiator_Object): self.Initiator_Object = Initiator_Object
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def export(self, outfile, level, namespace_='maec:', name_='Action_Initiator', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Action_Initiator')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Action_Initiator'):
        if self.type_ is not None:
            outfile.write(' type=%s' % (self.format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Action_Initiator'):
        if self.Initiator_Object:
            self.Initiator_Object.export(outfile, level, namespace_, name_='Initiator_Object')
    def hasContent_(self):
        if (
            self.Initiator_Object is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Action_Initiator'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Initiator_Object is not None:
            showIndent(outfile, level)
            outfile.write('Initiator_Object=model_.ObjectReferenceType(\n')
            self.Initiator_Object.exportLiteral(outfile, level, name_='Initiator_Object')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('type'):
            self.type_ = attrs.get('type').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Initiator_Object':
            obj_ = ObjectReferenceType.factory()
            obj_.build(child_)
            self.set_Initiator_Object(obj_)
# end class Action_Initiator


class Related_Actions(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Related_Action=None):
        if Related_Action is None:
            self.Related_Action = []
        else:
            self.Related_Action = Related_Action
    def factory(*args_, **kwargs_):
        if Related_Actions.subclass:
            return Related_Actions.subclass(*args_, **kwargs_)
        else:
            return Related_Actions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Related_Action(self): return self.Related_Action
    def set_Related_Action(self, Related_Action): self.Related_Action = Related_Action
    def add_Related_Action(self, value): self.Related_Action.append(value)
    def insert_Related_Action(self, index, value): self.Related_Action[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Related_Actions', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Related_Actions')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Related_Actions'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Related_Actions'):
        for Related_Action_ in self.Related_Action:
            Related_Action_.export(outfile, level, namespace_, name_='Related_Action')
    def hasContent_(self):
        if (
            self.Related_Action
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Related_Actions'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Related_Action=[\n')
        level += 1
        for Related_Action_ in self.Related_Action:
            showIndent(outfile, level)
            outfile.write('model_.Related_Action(\n')
            Related_Action_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Related_Action':
            obj_ = Related_Action.factory()
            obj_.build(child_)
            self.Related_Action.append(obj_)
# end class Related_Actions


class Related_Action(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Action_Reference=None, Nature_of_Relationship=None):
        self.Action_Reference = Action_Reference
        self.Nature_of_Relationship = Nature_of_Relationship
    def factory(*args_, **kwargs_):
        if Related_Action.subclass:
            return Related_Action.subclass(*args_, **kwargs_)
        else:
            return Related_Action(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Action_Reference(self): return self.Action_Reference
    def set_Action_Reference(self, Action_Reference): self.Action_Reference = Action_Reference
    def get_Nature_of_Relationship(self): return self.Nature_of_Relationship
    def set_Nature_of_Relationship(self, Nature_of_Relationship): self.Nature_of_Relationship = Nature_of_Relationship
    def validate_Nature_of_Relationship(self, value):
        # Validate type Nature_of_Relationship, a restriction on xs:string.
        pass
    def export(self, outfile, level, namespace_='maec:', name_='Related_Action', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Related_Action')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Related_Action'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Related_Action'):
        if self.Action_Reference:
            self.Action_Reference.export(outfile, level, namespace_, name_='Action_Reference', )
        if self.Nature_of_Relationship is not None:
            showIndent(outfile, level)
            outfile.write('<%sNature_of_Relationship>%s</%sNature_of_Relationship>\n' % (namespace_, self.format_string(quote_xml(self.Nature_of_Relationship).encode(ExternalEncoding), input_name='Nature_of_Relationship'), namespace_))
    def hasContent_(self):
        if (
            self.Action_Reference is not None or
            self.Nature_of_Relationship is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Related_Action'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Action_Reference is not None:
            showIndent(outfile, level)
            outfile.write('Action_Reference=model_.ActionReferenceType(\n')
            self.Action_Reference.exportLiteral(outfile, level, name_='Action_Reference')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Nature_of_Relationship is not None:
            showIndent(outfile, level)
            outfile.write('Nature_of_Relationship=%s,\n' % quote_python(self.Nature_of_Relationship).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Action_Reference':
            obj_ = ActionReferenceType.factory()
            obj_.build(child_)
            self.set_Action_Reference(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Nature_of_Relationship':
            Nature_of_Relationship_ = ''
            for text__content_ in child_.childNodes:
                Nature_of_Relationship_ += text__content_.nodeValue
            self.Nature_of_Relationship = Nature_of_Relationship_
            self.validate_Nature_of_Relationship(self.Nature_of_Relationship)    # validate type Nature_of_Relationship
# end class Related_Action


class ActionReferenceType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, action_id=None, valueOf_=''):
        self.type_ = _cast(None, type_)
        self.action_id = _cast(None, action_id)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if ActionReferenceType.subclass:
            return ActionReferenceType.subclass(*args_, **kwargs_)
        else:
            return ActionReferenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_action_id(self): return self.action_id
    def set_action_id(self, action_id): self.action_id = action_id
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='maec:', name_='ActionReferenceType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='ActionReferenceType')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='ActionReferenceType'):
        if self.type_ is not None:
            outfile.write(' type=%s' % (self.format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        outfile.write(' action_id=%s' % (quote_attrib(self.action_id), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ActionReferenceType'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value)
        else:
            outfile.write(quote_xml('%s' % self.valueOf_))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ActionReferenceType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
        if self.action_id is not None:
            showIndent(outfile, level)
            outfile.write('action_id = %s,\n' % (self.action_id,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('type'):
            self.type_ = attrs.get('type').value
        if attrs.get('action_id'):
            self.action_id = attrs.get('action_id').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class ActionReferenceType


class ObjectType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, object_name=None, permanent=None, type_=None, id=None, Object_Size=None, Classifications=None, Associated_Code=None, Related_Objects=None, File_System_Object_Attributes=None, GUI_Object_Attributes=None, IPC_Object_Attributes=None, Internet_Object_Attributes=None, Module_Object_Attributes=None, Registry_Object_Attributes=None, Process_Object_Attributes=None, Memory_Object_Attributes=None, Network_Object_Attributes=None, Daemon_Object_Attributes=None, Custom_Object_Attributes=None):
        self.object_name = _cast(None, object_name)
        self.permanent = _cast(bool, permanent)
        self.type_ = _cast(None, type_)
        self.id = _cast(None, id)
        self.Object_Size = Object_Size
        self.Classifications = Classifications
        self.Associated_Code = Associated_Code
        self.Related_Objects = Related_Objects
        self.File_System_Object_Attributes = File_System_Object_Attributes
        self.GUI_Object_Attributes = GUI_Object_Attributes
        self.IPC_Object_Attributes = IPC_Object_Attributes
        self.Internet_Object_Attributes = Internet_Object_Attributes
        self.Module_Object_Attributes = Module_Object_Attributes
        self.Registry_Object_Attributes = Registry_Object_Attributes
        self.Process_Object_Attributes = Process_Object_Attributes
        self.Memory_Object_Attributes = Memory_Object_Attributes
        self.Network_Object_Attributes = Network_Object_Attributes
        self.Daemon_Object_Attributes = Daemon_Object_Attributes
        self.Custom_Object_Attributes = Custom_Object_Attributes
    def factory(*args_, **kwargs_):
        if ObjectType.subclass:
            return ObjectType.subclass(*args_, **kwargs_)
        else:
            return ObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Object_Size(self): return self.Object_Size
    def set_Object_Size(self, Object_Size): self.Object_Size = Object_Size
    def get_Classifications(self): return self.Classifications
    def set_Classifications(self, Classifications): self.Classifications = Classifications
    def get_Associated_Code(self): return self.Associated_Code
    def set_Associated_Code(self, Associated_Code): self.Associated_Code = Associated_Code
    def get_Related_Objects(self): return self.Related_Objects
    def set_Related_Objects(self, Related_Objects): self.Related_Objects = Related_Objects
    def get_File_System_Object_Attributes(self): return self.File_System_Object_Attributes
    def set_File_System_Object_Attributes(self, File_System_Object_Attributes): self.File_System_Object_Attributes = File_System_Object_Attributes
    def get_GUI_Object_Attributes(self): return self.GUI_Object_Attributes
    def set_GUI_Object_Attributes(self, GUI_Object_Attributes): self.GUI_Object_Attributes = GUI_Object_Attributes
    def get_IPC_Object_Attributes(self): return self.IPC_Object_Attributes
    def set_IPC_Object_Attributes(self, IPC_Object_Attributes): self.IPC_Object_Attributes = IPC_Object_Attributes
    def get_Internet_Object_Attributes(self): return self.Internet_Object_Attributes
    def set_Internet_Object_Attributes(self, Internet_Object_Attributes): self.Internet_Object_Attributes = Internet_Object_Attributes
    def get_Module_Object_Attributes(self): return self.Module_Object_Attributes
    def set_Module_Object_Attributes(self, Module_Object_Attributes): self.Module_Object_Attributes = Module_Object_Attributes
    def get_Registry_Object_Attributes(self): return self.Registry_Object_Attributes
    def set_Registry_Object_Attributes(self, Registry_Object_Attributes): self.Registry_Object_Attributes = Registry_Object_Attributes
    def get_Process_Object_Attributes(self): return self.Process_Object_Attributes
    def set_Process_Object_Attributes(self, Process_Object_Attributes): self.Process_Object_Attributes = Process_Object_Attributes
    def get_Memory_Object_Attributes(self): return self.Memory_Object_Attributes
    def set_Memory_Object_Attributes(self, Memory_Object_Attributes): self.Memory_Object_Attributes = Memory_Object_Attributes
    def get_Network_Object_Attributes(self): return self.Network_Object_Attributes
    def set_Network_Object_Attributes(self, Network_Object_Attributes): self.Network_Object_Attributes = Network_Object_Attributes
    def get_Daemon_Object_Attributes(self): return self.Daemon_Object_Attributes
    def set_Daemon_Object_Attributes(self, Daemon_Object_Attributes): self.Daemon_Object_Attributes = Daemon_Object_Attributes
    def get_Custom_Object_Attributes(self): return self.Custom_Object_Attributes
    def set_Custom_Object_Attributes(self, Custom_Object_Attributes): self.Custom_Object_Attributes = Custom_Object_Attributes
    def get_object_name(self): return self.object_name
    def set_object_name(self, object_name): self.object_name = object_name
    def get_permanent(self): return self.permanent
    def set_permanent(self, permanent): self.permanent = permanent
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='maec:', name_='ObjectType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='ObjectType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='ObjectType'):
        if self.object_name is not None:
            outfile.write(' object_name=%s' % (self.format_string(quote_attrib(self.object_name).encode(ExternalEncoding), input_name='object_name'), ))
        if self.permanent is not None:
            outfile.write(' permanent="%s"' % self.format_boolean(str_lower(str(self.permanent)), input_name='permanent'))
        if self.type_ is not None:
            outfile.write(' type=%s' % (quote_attrib(self.type_), ))
        outfile.write(' id=%s' % (quote_attrib(self.id), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ObjectType'):
        if self.Object_Size:
            self.Object_Size.export(outfile, level, namespace_, name_='Object_Size')
        if self.Classifications:
            self.Classifications.export(outfile, level, namespace_, name_='Classifications')
        if self.Associated_Code:
            self.Associated_Code.export(outfile, level, namespace_, name_='Associated_Code')
        if self.Related_Objects:
            self.Related_Objects.export(outfile, level, namespace_, name_='Related_Objects')
        if self.File_System_Object_Attributes:
            self.File_System_Object_Attributes.export(outfile, level, namespace_, name_='File_System_Object_Attributes')
        if self.GUI_Object_Attributes:
            self.GUI_Object_Attributes.export(outfile, level, namespace_, name_='GUI_Object_Attributes')
        if self.IPC_Object_Attributes:
            self.IPC_Object_Attributes.export(outfile, level, namespace_, name_='IPC_Object_Attributes')
        if self.Internet_Object_Attributes:
            self.Internet_Object_Attributes.export(outfile, level, namespace_, name_='Internet_Object_Attributes')
        if self.Module_Object_Attributes:
            self.Module_Object_Attributes.export(outfile, level, namespace_, name_='Module_Object_Attributes')
        if self.Registry_Object_Attributes:
            self.Registry_Object_Attributes.export(outfile, level, namespace_, name_='Registry_Object_Attributes')
        if self.Process_Object_Attributes:
            self.Process_Object_Attributes.export(outfile, level, namespace_, name_='Process_Object_Attributes')
        if self.Memory_Object_Attributes:
            self.Memory_Object_Attributes.export(outfile, level, namespace_, name_='Memory_Object_Attributes')
        if self.Network_Object_Attributes:
            self.Network_Object_Attributes.export(outfile, level, namespace_, name_='Network_Object_Attributes')
        if self.Daemon_Object_Attributes:
            self.Daemon_Object_Attributes.export(outfile, level, namespace_, name_='Daemon_Object_Attributes')
        if self.Custom_Object_Attributes:
            self.Custom_Object_Attributes.export(outfile, level, namespace_, name_='Custom_Object_Attributes')
    def hasContent_(self):
        if (
            self.Object_Size is not None or
            self.Classifications is not None or
            self.Associated_Code is not None or
            self.Related_Objects is not None or
            self.File_System_Object_Attributes is not None or
            self.GUI_Object_Attributes is not None or
            self.IPC_Object_Attributes is not None or
            self.Internet_Object_Attributes is not None or
            self.Module_Object_Attributes is not None or
            self.Registry_Object_Attributes is not None or
            self.Process_Object_Attributes is not None or
            self.Memory_Object_Attributes is not None or
            self.Network_Object_Attributes is not None or
            self.Daemon_Object_Attributes is not None or
            self.Custom_Object_Attributes is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ObjectType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.object_name is not None:
            showIndent(outfile, level)
            outfile.write('object_name = "%s",\n' % (self.object_name,))
        if self.permanent is not None:
            showIndent(outfile, level)
            outfile.write('permanent = %s,\n' % (self.permanent,))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_ = %s,\n' % (self.type_,))
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Object_Size is not None:
            showIndent(outfile, level)
            outfile.write('Object_Size=model_.Object_Size(\n')
            self.Object_Size.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Classifications is not None:
            showIndent(outfile, level)
            outfile.write('Classifications=model_.Classifications(\n')
            self.Classifications.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Associated_Code is not None:
            showIndent(outfile, level)
            outfile.write('Associated_Code=model_.Associated_Code(\n')
            self.Associated_Code.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Related_Objects is not None:
            showIndent(outfile, level)
            outfile.write('Related_Objects=model_.Related_Objects(\n')
            self.Related_Objects.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.File_System_Object_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('File_System_Object_Attributes=model_.File_System_Object_Attributes(\n')
            self.File_System_Object_Attributes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.GUI_Object_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('GUI_Object_Attributes=model_.GUI_Object_Attributes(\n')
            self.GUI_Object_Attributes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IPC_Object_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('IPC_Object_Attributes=model_.IPC_Object_Attributes(\n')
            self.IPC_Object_Attributes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Internet_Object_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Internet_Object_Attributes=model_.Internet_Object_Attributes(\n')
            self.Internet_Object_Attributes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Module_Object_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Module_Object_Attributes=model_.Module_Object_Attributes(\n')
            self.Module_Object_Attributes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Registry_Object_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Registry_Object_Attributes=model_.Registry_Object_Attributes(\n')
            self.Registry_Object_Attributes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Process_Object_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Process_Object_Attributes=model_.Process_Object_Attributes(\n')
            self.Process_Object_Attributes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Memory_Object_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Memory_Object_Attributes=model_.Memory_Object_Attributes(\n')
            self.Memory_Object_Attributes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Network_Object_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Network_Object_Attributes=model_.Network_Object_Attributes(\n')
            self.Network_Object_Attributes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Daemon_Object_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Daemon_Object_Attributes=model_.Daemon_Object_Attributes(\n')
            self.Daemon_Object_Attributes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Custom_Object_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Custom_Object_Attributes=model_.Custom_Object_Attributes(\n')
            self.Custom_Object_Attributes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('object_name'):
            self.object_name = attrs.get('object_name').value
        if attrs.get('permanent'):
            if attrs.get('permanent').value in ('true', '1'):
                self.permanent = True
            elif attrs.get('permanent').value in ('false', '0'):
                self.permanent = False
            else:
                raise ValueError('Bad boolean attribute (permanent)')
        if attrs.get('type'):
            self.type_ = attrs.get('type').value
        if attrs.get('id'):
            self.id = attrs.get('id').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Object_Size':
            obj_ = Object_Size.factory()
            obj_.build(child_)
            self.set_Object_Size(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Classifications':
            obj_ = Classifications.factory()
            obj_.build(child_)
            self.set_Classifications(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Associated_Code':
            obj_ = Associated_Code.factory()
            obj_.build(child_)
            self.set_Associated_Code(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Related_Objects':
            obj_ = Related_Objects.factory()
            obj_.build(child_)
            self.set_Related_Objects(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'File_System_Object_Attributes':
            obj_ = File_System_Object_Attributes.factory()
            obj_.build(child_)
            self.set_File_System_Object_Attributes(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'GUI_Object_Attributes':
            obj_ = GUI_Object_Attributes.factory()
            obj_.build(child_)
            self.set_GUI_Object_Attributes(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'IPC_Object_Attributes':
            obj_ = IPC_Object_Attributes.factory()
            obj_.build(child_)
            self.set_IPC_Object_Attributes(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Internet_Object_Attributes':
            obj_ = Internet_Object_Attributes.factory()
            obj_.build(child_)
            self.set_Internet_Object_Attributes(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Module_Object_Attributes':
            obj_ = Module_Object_Attributes.factory()
            obj_.build(child_)
            self.set_Module_Object_Attributes(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Registry_Object_Attributes':
            obj_ = Registry_Object_Attributes.factory()
            obj_.build(child_)
            self.set_Registry_Object_Attributes(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Process_Object_Attributes':
            obj_ = Process_Object_Attributes.factory()
            obj_.build(child_)
            self.set_Process_Object_Attributes(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Memory_Object_Attributes':
            obj_ = Memory_Object_Attributes.factory()
            obj_.build(child_)
            self.set_Memory_Object_Attributes(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Network_Object_Attributes':
            obj_ = Network_Object_Attributes.factory()
            obj_.build(child_)
            self.set_Network_Object_Attributes(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Daemon_Object_Attributes':
            obj_ = Daemon_Object_Attributes.factory()
            obj_.build(child_)
            self.set_Daemon_Object_Attributes(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Custom_Object_Attributes':
            obj_ = Custom_Object_Attributes.factory()
            obj_.build(child_)
            self.set_Custom_Object_Attributes(obj_)
# end class ObjectType


class Object_Size(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=''):
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Object_Size.subclass:
            return Object_Size.subclass(*args_, **kwargs_)
        else:
            return Object_Size(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='maec:', name_='Object_Size', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Object_Size')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Object_Size'):
        outfile.write(' units=%s' % (self.format_string(quote_attrib(self.units).encode(ExternalEncoding), input_name='units'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Object_Size'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value)
        else:
            outfile.write(quote_xml('%s' % self.valueOf_))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Object_Size'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.units is not None:
            showIndent(outfile, level)
            outfile.write('units = "%s",\n' % (self.units,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('units'):
            self.units = attrs.get('units').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class Object_Size


class Classifications(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Classification=None):
        if Classification is None:
            self.Classification = []
        else:
            self.Classification = Classification
    def factory(*args_, **kwargs_):
        if Classifications.subclass:
            return Classifications.subclass(*args_, **kwargs_)
        else:
            return Classifications(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Classification(self): return self.Classification
    def set_Classification(self, Classification): self.Classification = Classification
    def add_Classification(self, value): self.Classification.append(value)
    def insert_Classification(self, index, value): self.Classification[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Classifications', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Classifications')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Classifications'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Classifications'):
        for Classification_ in self.Classification:
            showIndent(outfile, level)
            outfile.write('<%sClassification>%s</%sClassification>\n' % (namespace_, self.format_string(quote_xml(Classification_).encode(ExternalEncoding), input_name='Classification'), namespace_))
    def hasContent_(self):
        if (
            self.Classification
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Classifications'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Classification=[\n')
        level += 1
        for Classification_ in self.Classification:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Classification_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Classification':
            Classification_ = ''
            for text__content_ in child_.childNodes:
                Classification_ += text__content_.nodeValue
            self.Classification.append(Classification_)
# end class Classifications


class Associated_Code(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Associated_Code_Snippet=None):
        if Associated_Code_Snippet is None:
            self.Associated_Code_Snippet = []
        else:
            self.Associated_Code_Snippet = Associated_Code_Snippet
    def factory(*args_, **kwargs_):
        if Associated_Code.subclass:
            return Associated_Code.subclass(*args_, **kwargs_)
        else:
            return Associated_Code(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Associated_Code_Snippet(self): return self.Associated_Code_Snippet
    def set_Associated_Code_Snippet(self, Associated_Code_Snippet): self.Associated_Code_Snippet = Associated_Code_Snippet
    def add_Associated_Code_Snippet(self, value): self.Associated_Code_Snippet.append(value)
    def insert_Associated_Code_Snippet(self, index, value): self.Associated_Code_Snippet[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Associated_Code', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Associated_Code')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Associated_Code'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Associated_Code'):
        for Associated_Code_Snippet_ in self.Associated_Code_Snippet:
            Associated_Code_Snippet_.export(outfile, level, namespace_, name_='Associated_Code_Snippet')
    def hasContent_(self):
        if (
            self.Associated_Code_Snippet
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Associated_Code'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Associated_Code_Snippet=[\n')
        level += 1
        for Associated_Code_Snippet_ in self.Associated_Code_Snippet:
            showIndent(outfile, level)
            outfile.write('model_.Associated_Code_Snippet(\n')
            Associated_Code_Snippet_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Associated_Code_Snippet':
            obj_ = Associated_Code_Snippet.factory()
            obj_.build(child_)
            self.Associated_Code_Snippet.append(obj_)
# end class Associated_Code


class Associated_Code_Snippet(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Code_Snippet=None, Nature_Of_Relationship=None):
        self.Code_Snippet = Code_Snippet
        self.Nature_Of_Relationship = Nature_Of_Relationship
    def factory(*args_, **kwargs_):
        if Associated_Code_Snippet.subclass:
            return Associated_Code_Snippet.subclass(*args_, **kwargs_)
        else:
            return Associated_Code_Snippet(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Code_Snippet(self): return self.Code_Snippet
    def set_Code_Snippet(self, Code_Snippet): self.Code_Snippet = Code_Snippet
    def get_Nature_Of_Relationship(self): return self.Nature_Of_Relationship
    def set_Nature_Of_Relationship(self, Nature_Of_Relationship): self.Nature_Of_Relationship = Nature_Of_Relationship
    def validate_Nature_Of_Relationship(self, value):
        # Validate type Nature_Of_Relationship, a restriction on xs:string.
        pass
    def export(self, outfile, level, namespace_='maec:', name_='Associated_Code_Snippet', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Associated_Code_Snippet')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Associated_Code_Snippet'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Associated_Code_Snippet'):
        if self.Code_Snippet:
            self.Code_Snippet.export(outfile, level, namespace_, name_='Code_Snippet', )
        if self.Nature_Of_Relationship is not None:
            showIndent(outfile, level)
            outfile.write('<%sNature_Of_Relationship>%s</%sNature_Of_Relationship>\n' % (namespace_, self.format_string(quote_xml(self.Nature_Of_Relationship).encode(ExternalEncoding), input_name='Nature_Of_Relationship'), namespace_))
    def hasContent_(self):
        if (
            self.Code_Snippet is not None or
            self.Nature_Of_Relationship is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Associated_Code_Snippet'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Code_Snippet is not None:
            showIndent(outfile, level)
            outfile.write('Code_Snippet=model_.CodeType(\n')
            self.Code_Snippet.exportLiteral(outfile, level, name_='Code_Snippet')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Nature_Of_Relationship is not None:
            showIndent(outfile, level)
            outfile.write('Nature_Of_Relationship=%s,\n' % quote_python(self.Nature_Of_Relationship).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Code_Snippet':
            obj_ = CodeType.factory()
            obj_.build(child_)
            self.set_Code_Snippet(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Nature_Of_Relationship':
            Nature_Of_Relationship_ = ''
            for text__content_ in child_.childNodes:
                Nature_Of_Relationship_ += text__content_.nodeValue
            self.Nature_Of_Relationship = Nature_Of_Relationship_
            self.validate_Nature_Of_Relationship(self.Nature_Of_Relationship)    # validate type Nature_Of_Relationship
# end class Associated_Code_Snippet


class Nature_Of_Relationship(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=''):
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Nature_Of_Relationship.subclass:
            return Nature_Of_Relationship.subclass(*args_, **kwargs_)
        else:
            return Nature_Of_Relationship(*args_, **kwargs_)
    factory = staticmethod(factory)
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='maec:', name_='Nature_Of_Relationship', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Nature_Of_Relationship')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Nature_Of_Relationship'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Nature_Of_Relationship'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value)
        else:
            outfile.write(quote_xml('%s' % self.valueOf_))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Nature_Of_Relationship'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class Nature_Of_Relationship


class Related_Objects(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Related_Object=None):
        if Related_Object is None:
            self.Related_Object = []
        else:
            self.Related_Object = Related_Object
    def factory(*args_, **kwargs_):
        if Related_Objects.subclass:
            return Related_Objects.subclass(*args_, **kwargs_)
        else:
            return Related_Objects(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Related_Object(self): return self.Related_Object
    def set_Related_Object(self, Related_Object): self.Related_Object = Related_Object
    def add_Related_Object(self, value): self.Related_Object.append(value)
    def insert_Related_Object(self, index, value): self.Related_Object[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Related_Objects', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Related_Objects')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Related_Objects'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Related_Objects'):
        for Related_Object_ in self.Related_Object:
            Related_Object_.export(outfile, level, namespace_, name_='Related_Object')
    def hasContent_(self):
        if (
            self.Related_Object
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Related_Objects'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Related_Object=[\n')
        level += 1
        for Related_Object_ in self.Related_Object:
            showIndent(outfile, level)
            outfile.write('model_.Related_Object(\n')
            Related_Object_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Related_Object':
            obj_ = Related_Object.factory()
            obj_.build(child_)
            self.Related_Object.append(obj_)
# end class Related_Objects


class Related_Object(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Object_Reference=None, Nature_Of_Relationship=None):
        self.Object_Reference = Object_Reference
        self.Nature_Of_Relationship = Nature_Of_Relationship
    def factory(*args_, **kwargs_):
        if Related_Object.subclass:
            return Related_Object.subclass(*args_, **kwargs_)
        else:
            return Related_Object(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Object_Reference(self): return self.Object_Reference
    def set_Object_Reference(self, Object_Reference): self.Object_Reference = Object_Reference
    def get_Nature_Of_Relationship(self): return self.Nature_Of_Relationship
    def set_Nature_Of_Relationship(self, Nature_Of_Relationship): self.Nature_Of_Relationship = Nature_Of_Relationship
    def validate_Nature_Of_Relationship(self, value):
        # Validate type Nature_Of_Relationship, a restriction on xs:string.
        pass
    def export(self, outfile, level, namespace_='maec:', name_='Related_Object', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Related_Object')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Related_Object'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Related_Object'):
        if self.Object_Reference:
            self.Object_Reference.export(outfile, level, namespace_, name_='Object_Reference', )
        if self.Nature_Of_Relationship is not None:
            showIndent(outfile, level)
            outfile.write('<%sNature_Of_Relationship>%s</%sNature_Of_Relationship>\n' % (namespace_, self.format_string(quote_xml(self.Nature_Of_Relationship).encode(ExternalEncoding), input_name='Nature_Of_Relationship'), namespace_))
    def hasContent_(self):
        if (
            self.Object_Reference is not None or
            self.Nature_Of_Relationship is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Related_Object'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Object_Reference is not None:
            showIndent(outfile, level)
            outfile.write('Object_Reference=model_.ObjectReferenceType(\n')
            self.Object_Reference.exportLiteral(outfile, level, name_='Object_Reference')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Nature_Of_Relationship is not None:
            showIndent(outfile, level)
            outfile.write('Nature_Of_Relationship=%s,\n' % quote_python(self.Nature_Of_Relationship).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Object_Reference':
            obj_ = ObjectReferenceType.factory()
            obj_.build(child_)
            self.set_Object_Reference(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Nature_Of_Relationship':
            Nature_Of_Relationship_ = ''
            for text__content_ in child_.childNodes:
                Nature_Of_Relationship_ += text__content_.nodeValue
            self.Nature_Of_Relationship = Nature_Of_Relationship_
            self.validate_Nature_Of_Relationship(self.Nature_Of_Relationship)    # validate type Nature_Of_Relationship
# end class Related_Object


class File_System_Object_Attributes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, DateTime_Created=None, DateTime_Modified=None, Path=None, Hashes=None, Permissions=None, File_Type=None, Packing=None, Pipe_Mode=None, Maximum_Instances=None, Security_Attributes=None, Origin=None, File_Type_Attributes=None):
        self.DateTime_Created = DateTime_Created
        self.DateTime_Modified = DateTime_Modified
        self.Path = Path
        self.Hashes = Hashes
        self.Permissions = Permissions
        self.File_Type = File_Type
        self.Packing = Packing
        self.Pipe_Mode = Pipe_Mode
        self.Maximum_Instances = Maximum_Instances
        self.Security_Attributes = Security_Attributes
        self.Origin = Origin
        self.File_Type_Attributes = File_Type_Attributes
    def factory(*args_, **kwargs_):
        if File_System_Object_Attributes.subclass:
            return File_System_Object_Attributes.subclass(*args_, **kwargs_)
        else:
            return File_System_Object_Attributes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DateTime_Created(self): return self.DateTime_Created
    def set_DateTime_Created(self, DateTime_Created): self.DateTime_Created = DateTime_Created
    def get_DateTime_Modified(self): return self.DateTime_Modified
    def set_DateTime_Modified(self, DateTime_Modified): self.DateTime_Modified = DateTime_Modified
    def get_Path(self): return self.Path
    def set_Path(self, Path): self.Path = Path
    def get_Hashes(self): return self.Hashes
    def set_Hashes(self, Hashes): self.Hashes = Hashes
    def get_Permissions(self): return self.Permissions
    def set_Permissions(self, Permissions): self.Permissions = Permissions
    def get_File_Type(self): return self.File_Type
    def set_File_Type(self, File_Type): self.File_Type = File_Type
    def get_Packing(self): return self.Packing
    def set_Packing(self, Packing): self.Packing = Packing
    def get_Pipe_Mode(self): return self.Pipe_Mode
    def set_Pipe_Mode(self, Pipe_Mode): self.Pipe_Mode = Pipe_Mode
    def get_Maximum_Instances(self): return self.Maximum_Instances
    def set_Maximum_Instances(self, Maximum_Instances): self.Maximum_Instances = Maximum_Instances
    def get_Security_Attributes(self): return self.Security_Attributes
    def set_Security_Attributes(self, Security_Attributes): self.Security_Attributes = Security_Attributes
    def get_Origin(self): return self.Origin
    def set_Origin(self, Origin): self.Origin = Origin
    def get_File_Type_Attributes(self): return self.File_Type_Attributes
    def set_File_Type_Attributes(self, File_Type_Attributes): self.File_Type_Attributes = File_Type_Attributes
    def export(self, outfile, level, namespace_='maec:', name_='File_System_Object_Attributes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='File_System_Object_Attributes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='File_System_Object_Attributes'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='File_System_Object_Attributes'):
        if self.DateTime_Created is not None:
            showIndent(outfile, level)
            outfile.write('<%sDateTime_Created>%s</%sDateTime_Created>\n' % (namespace_, self.format_string(quote_xml(self.DateTime_Created).encode(ExternalEncoding), input_name='DateTime_Created'), namespace_))
        if self.DateTime_Modified is not None:
            showIndent(outfile, level)
            outfile.write('<%sDateTime_Modified>%s</%sDateTime_Modified>\n' % (namespace_, self.format_string(quote_xml(self.DateTime_Modified).encode(ExternalEncoding), input_name='DateTime_Modified'), namespace_))
        if self.Path:
            self.Path.export(outfile, level, namespace_, name_='Path')
        if self.Hashes:
            self.Hashes.export(outfile, level, namespace_, name_='Hashes')
        if self.Permissions is not None:
            showIndent(outfile, level)
            outfile.write('<%sPermissions>%s</%sPermissions>\n' % (namespace_, self.format_string(quote_xml(self.Permissions).encode(ExternalEncoding), input_name='Permissions'), namespace_))
        if self.File_Type:
            self.File_Type.export(outfile, level, namespace_, name_='File_Type')
        if self.Packing:
            self.Packing.export(outfile, level, namespace_, name_='Packing')
        if self.Pipe_Mode is not None:
            showIndent(outfile, level)
            outfile.write('<%sPipe_Mode>%s</%sPipe_Mode>\n' % (namespace_, self.format_string(quote_xml(self.Pipe_Mode).encode(ExternalEncoding), input_name='Pipe_Mode'), namespace_))
        if self.Maximum_Instances is not None:
            showIndent(outfile, level)
            outfile.write('<%sMaximum_Instances>%s</%sMaximum_Instances>\n' % (namespace_, self.format_integer(self.Maximum_Instances, input_name='Maximum_Instances'), namespace_))
        if self.Security_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('<%sSecurity_Attributes>%s</%sSecurity_Attributes>\n' % (namespace_, self.format_string(quote_xml(self.Security_Attributes).encode(ExternalEncoding), input_name='Security_Attributes'), namespace_))
        if self.Origin is not None:
            showIndent(outfile, level)
            outfile.write('<%sOrigin>%s</%sOrigin>\n' % (namespace_, self.format_string(quote_xml(self.Origin).encode(ExternalEncoding), input_name='Origin'), namespace_))
        if self.File_Type_Attributes:
            self.File_Type_Attributes.export(outfile, level, namespace_, name_='File_Type_Attributes')
    def hasContent_(self):
        if (
            self.DateTime_Created is not None or
            self.DateTime_Modified is not None or
            self.Path is not None or
            self.Hashes is not None or
            self.Permissions is not None or
            self.File_Type is not None or
            self.Packing is not None or
            self.Pipe_Mode is not None or
            self.Maximum_Instances is not None or
            self.Security_Attributes is not None or
            self.Origin is not None or
            self.File_Type_Attributes is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='File_System_Object_Attributes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.DateTime_Created is not None:
            showIndent(outfile, level)
            outfile.write('DateTime_Created=%s,\n' % quote_python(self.DateTime_Created).encode(ExternalEncoding))
        if self.DateTime_Modified is not None:
            showIndent(outfile, level)
            outfile.write('DateTime_Modified=%s,\n' % quote_python(self.DateTime_Modified).encode(ExternalEncoding))
        if self.Path is not None:
            showIndent(outfile, level)
            outfile.write('Path=model_.Path(\n')
            self.Path.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Hashes=model_.Hashes(\n')
            self.Hashes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Permissions is not None:
            showIndent(outfile, level)
            outfile.write('Permissions=%s,\n' % quote_python(self.Permissions).encode(ExternalEncoding))
        if self.File_Type is not None:
            showIndent(outfile, level)
            outfile.write('File_Type=model_.File_Type(\n')
            self.File_Type.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Packing is not None:
            showIndent(outfile, level)
            outfile.write('Packing=model_.Packing(\n')
            self.Packing.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Pipe_Mode is not None:
            showIndent(outfile, level)
            outfile.write('Pipe_Mode=%s,\n' % quote_python(self.Pipe_Mode).encode(ExternalEncoding))
        if self.Maximum_Instances is not None:
            showIndent(outfile, level)
            outfile.write('Maximum_Instances=%d,\n' % self.Maximum_Instances)
        if self.Security_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Security_Attributes=%s,\n' % quote_python(self.Security_Attributes).encode(ExternalEncoding))
        if self.Origin is not None:
            showIndent(outfile, level)
            outfile.write('Origin=%s,\n' % quote_python(self.Origin).encode(ExternalEncoding))
        if self.File_Type_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('File_Type_Attributes=model_.File_Type_Attributes(\n')
            self.File_Type_Attributes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'DateTime_Created':
            DateTime_Created_ = ''
            for text__content_ in child_.childNodes:
                DateTime_Created_ += text__content_.nodeValue
            self.DateTime_Created = DateTime_Created_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'DateTime_Modified':
            DateTime_Modified_ = ''
            for text__content_ in child_.childNodes:
                DateTime_Modified_ += text__content_.nodeValue
            self.DateTime_Modified = DateTime_Modified_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Path':
            obj_ = Path.factory()
            obj_.build(child_)
            self.set_Path(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Hashes':
            obj_ = Hashes.factory()
            obj_.build(child_)
            self.set_Hashes(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Permissions':
            Permissions_ = ''
            for text__content_ in child_.childNodes:
                Permissions_ += text__content_.nodeValue
            self.Permissions = Permissions_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'File_Type':
            obj_ = File_Type.factory()
            obj_.build(child_)
            self.set_File_Type(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Packing':
            obj_ = Packing.factory()
            obj_.build(child_)
            self.set_Packing(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Pipe_Mode':
            Pipe_Mode_ = ''
            for text__content_ in child_.childNodes:
                Pipe_Mode_ += text__content_.nodeValue
            self.Pipe_Mode = Pipe_Mode_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Maximum_Instances':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError as exp:
                    raise ValueError('requires integer (Maximum_Instances): %s' % exp)
                self.Maximum_Instances = ival_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Security_Attributes':
            Security_Attributes_ = ''
            for text__content_ in child_.childNodes:
                Security_Attributes_ += text__content_.nodeValue
            self.Security_Attributes = Security_Attributes_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Origin':
            Origin_ = ''
            for text__content_ in child_.childNodes:
                Origin_ += text__content_.nodeValue
            self.Origin = Origin_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'File_Type_Attributes':
            obj_ = File_Type_Attributes.factory()
            obj_.build(child_)
            self.set_File_Type_Attributes(obj_)
# end class File_System_Object_Attributes


class Path(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, valueOf_=''):
        self.type_ = _cast(None, type_)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Path.subclass:
            return Path.subclass(*args_, **kwargs_)
        else:
            return Path(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='maec:', name_='Path', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Path')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Path'):
        if self.type_ is not None:
            outfile.write(' type=%s' % (self.format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Path'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value)
        else:
            outfile.write(quote_xml('%s' % self.valueOf_))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Path'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('type'):
            self.type_ = attrs.get('type').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class Path


class Hashes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Hash=None):
        if Hash is None:
            self.Hash = []
        else:
            self.Hash = Hash
    def factory(*args_, **kwargs_):
        if Hashes.subclass:
            return Hashes.subclass(*args_, **kwargs_)
        else:
            return Hashes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hash(self): return self.Hash
    def set_Hash(self, Hash): self.Hash = Hash
    def add_Hash(self, value): self.Hash.append(value)
    def insert_Hash(self, index, value): self.Hash[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Hashes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Hashes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Hashes'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Hashes'):
        for Hash_ in self.Hash:
            Hash_.export(outfile, level, namespace_, name_='Hash')
    def hasContent_(self):
        if (
            self.Hash
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Hashes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Hash=[\n')
        level += 1
        for Hash_ in self.Hash:
            showIndent(outfile, level)
            outfile.write('model_.HashType(\n')
            Hash_.exportLiteral(outfile, level, name_='HashType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Hash':
            obj_ = HashType.factory()
            obj_.build(child_)
            self.Hash.append(obj_)
# end class Hashes


class File_Type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, TrID_Type=None, Discovery_Method=None):
        self.type_ = _cast(None, type_)
        self.TrID_Type = TrID_Type
        self.Discovery_Method = Discovery_Method
    def factory(*args_, **kwargs_):
        if File_Type.subclass:
            return File_Type.subclass(*args_, **kwargs_)
        else:
            return File_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_TrID_Type(self): return self.TrID_Type
    def set_TrID_Type(self, TrID_Type): self.TrID_Type = TrID_Type
    def get_Discovery_Method(self): return self.Discovery_Method
    def set_Discovery_Method(self, Discovery_Method): self.Discovery_Method = Discovery_Method
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def export(self, outfile, level, namespace_='maec:', name_='File_Type', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='File_Type')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='File_Type'):
        if self.type_ is not None:
            outfile.write(' type=%s' % (quote_attrib(self.type_), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='File_Type'):
        if self.TrID_Type:
            self.TrID_Type.export(outfile, level, namespace_, name_='TrID_Type')
        if self.Discovery_Method:
            self.Discovery_Method.export(outfile, level, namespace_, name_='Discovery_Method')
    def hasContent_(self):
        if (
            self.TrID_Type is not None or
            self.Discovery_Method is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='File_Type'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_ = %s,\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.TrID_Type is not None:
            showIndent(outfile, level)
            outfile.write('TrID_Type=model_.TrID_Type(\n')
            self.TrID_Type.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Discovery_Method is not None:
            showIndent(outfile, level)
            outfile.write('Discovery_Method=model_.DiscoveryMethod(\n')
            self.Discovery_Method.exportLiteral(outfile, level, name_='Discovery_Method')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('type'):
            self.type_ = attrs.get('type').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'TrID_Type':
            obj_ = TrID_Type.factory()
            obj_.build(child_)
            self.set_TrID_Type(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Discovery_Method':
            obj_ = DiscoveryMethod.factory()
            obj_.build(child_)
            self.set_Discovery_Method(obj_)
# end class File_Type


class TrID_Type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, TriD_ID=None, TRID_Confidence=None):
        self.TriD_ID = TriD_ID
        self.TRID_Confidence = TRID_Confidence
    def factory(*args_, **kwargs_):
        if TrID_Type.subclass:
            return TrID_Type.subclass(*args_, **kwargs_)
        else:
            return TrID_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_TriD_ID(self): return self.TriD_ID
    def set_TriD_ID(self, TriD_ID): self.TriD_ID = TriD_ID
    def get_TRID_Confidence(self): return self.TRID_Confidence
    def set_TRID_Confidence(self, TRID_Confidence): self.TRID_Confidence = TRID_Confidence
    def export(self, outfile, level, namespace_='maec:', name_='TrID_Type', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='TrID_Type')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='TrID_Type'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='TrID_Type'):
        if self.TriD_ID is not None:
            showIndent(outfile, level)
            outfile.write('<%sTriD_ID>%s</%sTriD_ID>\n' % (namespace_, self.format_string(quote_xml(self.TriD_ID).encode(ExternalEncoding), input_name='TriD_ID'), namespace_))
        if self.TRID_Confidence is not None:
            showIndent(outfile, level)
            outfile.write('<%sTRID_Confidence>%s</%sTRID_Confidence>\n' % (namespace_, self.format_float(self.TRID_Confidence, input_name='TRID_Confidence'), namespace_))
    def hasContent_(self):
        if (
            self.TriD_ID is not None or
            self.TRID_Confidence is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TrID_Type'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.TriD_ID is not None:
            showIndent(outfile, level)
            outfile.write('TriD_ID=%s,\n' % quote_python(self.TriD_ID).encode(ExternalEncoding))
        if self.TRID_Confidence is not None:
            showIndent(outfile, level)
            outfile.write('TRID_Confidence=%f,\n' % self.TRID_Confidence)
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'TriD_ID':
            TriD_ID_ = ''
            for text__content_ in child_.childNodes:
                TriD_ID_ += text__content_.nodeValue
            self.TriD_ID = TriD_ID_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'TRID_Confidence':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    fval_ = float(sval_)
                except ValueError as exp:
                    raise ValueError('requires float or double (TRID_Confidence): %s' %exp)
                self.TRID_Confidence = fval_
# end class TrID_Type


class Packing(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, is_packed=None, Packer_Type=None):
        self.is_packed = _cast(bool, is_packed)
        if Packer_Type is None:
            self.Packer_Type = []
        else:
            self.Packer_Type = Packer_Type
    def factory(*args_, **kwargs_):
        if Packing.subclass:
            return Packing.subclass(*args_, **kwargs_)
        else:
            return Packing(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Packer_Type(self): return self.Packer_Type
    def set_Packer_Type(self, Packer_Type): self.Packer_Type = Packer_Type
    def add_Packer_Type(self, value): self.Packer_Type.append(value)
    def insert_Packer_Type(self, index, value): self.Packer_Type[index] = value
    def get_is_packed(self): return self.is_packed
    def set_is_packed(self, is_packed): self.is_packed = is_packed
    def export(self, outfile, level, namespace_='maec:', name_='Packing', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Packing')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Packing'):
        if self.is_packed is not None:
            outfile.write(' is_packed="%s"' % self.format_boolean(str_lower(str(self.is_packed)), input_name='is_packed'))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Packing'):
        for Packer_Type_ in self.Packer_Type:
            Packer_Type_.export(outfile, level, namespace_, name_='Packer_Type')
    def hasContent_(self):
        if (
            self.Packer_Type
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Packing'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.is_packed is not None:
            showIndent(outfile, level)
            outfile.write('is_packed = %s,\n' % (self.is_packed,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Packer_Type=[\n')
        level += 1
        for Packer_Type_ in self.Packer_Type:
            showIndent(outfile, level)
            outfile.write('model_.Packer_Type(\n')
            Packer_Type_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('is_packed'):
            if attrs.get('is_packed').value in ('true', '1'):
                self.is_packed = True
            elif attrs.get('is_packed').value in ('false', '0'):
                self.is_packed = False
            else:
                raise ValueError('Bad boolean attribute (is_packed)')
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Packer_Type':
            obj_ = Packer_Type.factory()
            obj_.build(child_)
            self.Packer_Type.append(obj_)
# end class Packing


class Packer_Type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, id=None, Name=None, Version=None, Discovery_Method=None):
        self.type_ = _cast(None, type_)
        self.id = _cast(None, id)
        self.Name = Name
        self.Version = Version
        self.Discovery_Method = Discovery_Method
    def factory(*args_, **kwargs_):
        if Packer_Type.subclass:
            return Packer_Type.subclass(*args_, **kwargs_)
        else:
            return Packer_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Version(self): return self.Version
    def set_Version(self, Version): self.Version = Version
    def get_Discovery_Method(self): return self.Discovery_Method
    def set_Discovery_Method(self, Discovery_Method): self.Discovery_Method = Discovery_Method
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='maec:', name_='Packer_Type', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Packer_Type')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Packer_Type'):
        if self.type_ is not None:
            outfile.write(' type=%s' % (quote_attrib(self.type_), ))
        if self.id is not None:
            outfile.write(' id=%s' % (self.format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Packer_Type'):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sName>%s</%sName>\n' % (namespace_, self.format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), namespace_))
        if self.Version is not None:
            showIndent(outfile, level)
            outfile.write('<%sVersion>%s</%sVersion>\n' % (namespace_, self.format_string(quote_xml(self.Version).encode(ExternalEncoding), input_name='Version'), namespace_))
        if self.Discovery_Method:
            self.Discovery_Method.export(outfile, level, namespace_, name_='Discovery_Method')
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Version is not None or
            self.Discovery_Method is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Packer_Type'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_ = %s,\n' % (self.type_,))
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('id = "%s",\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
        if self.Version is not None:
            showIndent(outfile, level)
            outfile.write('Version=%s,\n' % quote_python(self.Version).encode(ExternalEncoding))
        if self.Discovery_Method is not None:
            showIndent(outfile, level)
            outfile.write('Discovery_Method=model_.DiscoveryMethod(\n')
            self.Discovery_Method.exportLiteral(outfile, level, name_='Discovery_Method')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('type'):
            self.type_ = attrs.get('type').value
        if attrs.get('id'):
            self.id = attrs.get('id').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Name':
            Name_ = ''
            for text__content_ in child_.childNodes:
                Name_ += text__content_.nodeValue
            self.Name = Name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Version':
            Version_ = ''
            for text__content_ in child_.childNodes:
                Version_ += text__content_.nodeValue
            self.Version = Version_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Discovery_Method':
            obj_ = DiscoveryMethod.factory()
            obj_.build(child_)
            self.set_Discovery_Method(obj_)
# end class Packer_Type


class File_Type_Attributes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, PE_Binary_Attributes=None):
        self.PE_Binary_Attributes = PE_Binary_Attributes
    def factory(*args_, **kwargs_):
        if File_Type_Attributes.subclass:
            return File_Type_Attributes.subclass(*args_, **kwargs_)
        else:
            return File_Type_Attributes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_PE_Binary_Attributes(self): return self.PE_Binary_Attributes
    def set_PE_Binary_Attributes(self, PE_Binary_Attributes): self.PE_Binary_Attributes = PE_Binary_Attributes
    def export(self, outfile, level, namespace_='maec:', name_='File_Type_Attributes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='File_Type_Attributes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='File_Type_Attributes'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='File_Type_Attributes'):
        if self.PE_Binary_Attributes:
            self.PE_Binary_Attributes.export(outfile, level, namespace_, name_='PE_Binary_Attributes')
    def hasContent_(self):
        if (
            self.PE_Binary_Attributes is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='File_Type_Attributes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.PE_Binary_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('PE_Binary_Attributes=model_.PE_Binary_Attributes(\n')
            self.PE_Binary_Attributes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'PE_Binary_Attributes':
            obj_ = PE_Binary_Attributes.factory()
            obj_.build(child_)
            self.set_PE_Binary_Attributes(obj_)
# end class File_Type_Attributes


class PE_Binary_Attributes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, dll_count=None, type_=None, Version_Block=None, Headers=None, Strings=None, Imports=None, Exports=None, Resources=None, Sections=None, Digital_Certificates=None):
        self.dll_count = _cast(int, dll_count)
        self.type_ = _cast(None, type_)
        self.Version_Block = Version_Block
        self.Headers = Headers
        self.Strings = Strings
        self.Imports = Imports
        self.Exports = Exports
        self.Resources = Resources
        self.Sections = Sections
        self.Digital_Certificates = Digital_Certificates
    def factory(*args_, **kwargs_):
        if PE_Binary_Attributes.subclass:
            return PE_Binary_Attributes.subclass(*args_, **kwargs_)
        else:
            return PE_Binary_Attributes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Version_Block(self): return self.Version_Block
    def set_Version_Block(self, Version_Block): self.Version_Block = Version_Block
    def get_Headers(self): return self.Headers
    def set_Headers(self, Headers): self.Headers = Headers
    def get_Strings(self): return self.Strings
    def set_Strings(self, Strings): self.Strings = Strings
    def get_Imports(self): return self.Imports
    def set_Imports(self, Imports): self.Imports = Imports
    def get_Exports(self): return self.Exports
    def set_Exports(self, Exports): self.Exports = Exports
    def get_Resources(self): return self.Resources
    def set_Resources(self, Resources): self.Resources = Resources
    def get_Sections(self): return self.Sections
    def set_Sections(self, Sections): self.Sections = Sections
    def get_Digital_Certificates(self): return self.Digital_Certificates
    def set_Digital_Certificates(self, Digital_Certificates): self.Digital_Certificates = Digital_Certificates
    def get_dll_count(self): return self.dll_count
    def set_dll_count(self, dll_count): self.dll_count = dll_count
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def export(self, outfile, level, namespace_='maec:', name_='PE_Binary_Attributes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='PE_Binary_Attributes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='PE_Binary_Attributes'):
        if self.dll_count is not None:
            outfile.write(' dll_count="%s"' % self.format_integer(self.dll_count, input_name='dll_count'))
        outfile.write(' type=%s' % (self.format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='PE_Binary_Attributes'):
        if self.Version_Block:
            self.Version_Block.export(outfile, level, namespace_, name_='Version_Block')
        if self.Headers:
            self.Headers.export(outfile, level, namespace_, name_='Headers')
        if self.Strings:
            self.Strings.export(outfile, level, namespace_, name_='Strings')
        if self.Imports:
            self.Imports.export(outfile, level, namespace_, name_='Imports')
        if self.Exports:
            self.Exports.export(outfile, level, namespace_, name_='Exports')
        if self.Resources:
            self.Resources.export(outfile, level, namespace_, name_='Resources')
        if self.Sections:
            self.Sections.export(outfile, level, namespace_, name_='Sections')
        if self.Digital_Certificates:
            self.Digital_Certificates.export(outfile, level, namespace_, name_='Digital_Certificates')
    def hasContent_(self):
        if (
            self.Version_Block is not None or
            self.Headers is not None or
            self.Strings is not None or
            self.Imports is not None or
            self.Exports is not None or
            self.Resources is not None or
            self.Sections is not None or
            self.Digital_Certificates is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PE_Binary_Attributes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.dll_count is not None:
            showIndent(outfile, level)
            outfile.write('dll_count = %d,\n' % (self.dll_count,))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Version_Block is not None:
            showIndent(outfile, level)
            outfile.write('Version_Block=model_.Version_Block(\n')
            self.Version_Block.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Headers is not None:
            showIndent(outfile, level)
            outfile.write('Headers=model_.Headers(\n')
            self.Headers.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Strings is not None:
            showIndent(outfile, level)
            outfile.write('Strings=model_.Strings(\n')
            self.Strings.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Imports is not None:
            showIndent(outfile, level)
            outfile.write('Imports=model_.Imports(\n')
            self.Imports.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Exports is not None:
            showIndent(outfile, level)
            outfile.write('Exports=model_.Exports(\n')
            self.Exports.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Resources is not None:
            showIndent(outfile, level)
            outfile.write('Resources=model_.Resources(\n')
            self.Resources.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Sections is not None:
            showIndent(outfile, level)
            outfile.write('Sections=model_.Sections(\n')
            self.Sections.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Digital_Certificates is not None:
            showIndent(outfile, level)
            outfile.write('Digital_Certificates=model_.Digital_Certificates(\n')
            self.Digital_Certificates.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('dll_count'):
            try:
                self.dll_count = int(attrs.get('dll_count').value)
            except ValueError as exp:
                raise ValueError('Bad integer attribute (dll_count): %s' % exp)
        if attrs.get('type'):
            self.type_ = attrs.get('type').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Version_Block':
            obj_ = Version_Block.factory()
            obj_.build(child_)
            self.set_Version_Block(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Headers':
            obj_ = Headers.factory()
            obj_.build(child_)
            self.set_Headers(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Strings':
            obj_ = Strings.factory()
            obj_.build(child_)
            self.set_Strings(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Imports':
            obj_ = Imports.factory()
            obj_.build(child_)
            self.set_Imports(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Exports':
            obj_ = Exports.factory()
            obj_.build(child_)
            self.set_Exports(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Resources':
            obj_ = Resources.factory()
            obj_.build(child_)
            self.set_Resources(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Sections':
            obj_ = Sections.factory()
            obj_.build(child_)
            self.set_Sections(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Digital_Certificates':
            obj_ = Digital_Certificates.factory()
            obj_.build(child_)
            self.set_Digital_Certificates(obj_)
# end class PE_Binary_Attributes


class Version_Block(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Internal_Name=None, Product_Name=None, Company_Name=None, Legal_Copyright=None, Product_Version_Text=None, File_Description=None, File_Version_Text=None, Original_File_Name=None):
        self.Internal_Name = Internal_Name
        self.Product_Name = Product_Name
        self.Company_Name = Company_Name
        self.Legal_Copyright = Legal_Copyright
        self.Product_Version_Text = Product_Version_Text
        self.File_Description = File_Description
        self.File_Version_Text = File_Version_Text
        self.Original_File_Name = Original_File_Name
    def factory(*args_, **kwargs_):
        if Version_Block.subclass:
            return Version_Block.subclass(*args_, **kwargs_)
        else:
            return Version_Block(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Internal_Name(self): return self.Internal_Name
    def set_Internal_Name(self, Internal_Name): self.Internal_Name = Internal_Name
    def get_Product_Name(self): return self.Product_Name
    def set_Product_Name(self, Product_Name): self.Product_Name = Product_Name
    def get_Company_Name(self): return self.Company_Name
    def set_Company_Name(self, Company_Name): self.Company_Name = Company_Name
    def get_Legal_Copyright(self): return self.Legal_Copyright
    def set_Legal_Copyright(self, Legal_Copyright): self.Legal_Copyright = Legal_Copyright
    def get_Product_Version_Text(self): return self.Product_Version_Text
    def set_Product_Version_Text(self, Product_Version_Text): self.Product_Version_Text = Product_Version_Text
    def get_File_Description(self): return self.File_Description
    def set_File_Description(self, File_Description): self.File_Description = File_Description
    def get_File_Version_Text(self): return self.File_Version_Text
    def set_File_Version_Text(self, File_Version_Text): self.File_Version_Text = File_Version_Text
    def get_Original_File_Name(self): return self.Original_File_Name
    def set_Original_File_Name(self, Original_File_Name): self.Original_File_Name = Original_File_Name
    def export(self, outfile, level, namespace_='maec:', name_='Version_Block', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Version_Block')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Version_Block'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Version_Block'):
        if self.Internal_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sInternal_Name>%s</%sInternal_Name>\n' % (namespace_, self.format_string(quote_xml(self.Internal_Name).encode(ExternalEncoding), input_name='Internal_Name'), namespace_))
        if self.Product_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sProduct_Name>%s</%sProduct_Name>\n' % (namespace_, self.format_string(quote_xml(self.Product_Name).encode(ExternalEncoding), input_name='Product_Name'), namespace_))
        if self.Company_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sCompany_Name>%s</%sCompany_Name>\n' % (namespace_, self.format_string(quote_xml(self.Company_Name).encode(ExternalEncoding), input_name='Company_Name'), namespace_))
        if self.Legal_Copyright is not None:
            showIndent(outfile, level)
            outfile.write('<%sLegal_Copyright>%s</%sLegal_Copyright>\n' % (namespace_, self.format_string(quote_xml(self.Legal_Copyright).encode(ExternalEncoding), input_name='Legal_Copyright'), namespace_))
        if self.Product_Version_Text is not None:
            showIndent(outfile, level)
            outfile.write('<%sProduct_Version_Text>%s</%sProduct_Version_Text>\n' % (namespace_, self.format_string(quote_xml(self.Product_Version_Text).encode(ExternalEncoding), input_name='Product_Version_Text'), namespace_))
        if self.File_Description is not None:
            showIndent(outfile, level)
            outfile.write('<%sFile_Description>%s</%sFile_Description>\n' % (namespace_, self.format_string(quote_xml(self.File_Description).encode(ExternalEncoding), input_name='File_Description'), namespace_))
        if self.File_Version_Text is not None:
            showIndent(outfile, level)
            outfile.write('<%sFile_Version_Text>%s</%sFile_Version_Text>\n' % (namespace_, self.format_string(quote_xml(self.File_Version_Text).encode(ExternalEncoding), input_name='File_Version_Text'), namespace_))
        if self.Original_File_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sOriginal_File_Name>%s</%sOriginal_File_Name>\n' % (namespace_, self.format_string(quote_xml(self.Original_File_Name).encode(ExternalEncoding), input_name='Original_File_Name'), namespace_))
    def hasContent_(self):
        if (
            self.Internal_Name is not None or
            self.Product_Name is not None or
            self.Company_Name is not None or
            self.Legal_Copyright is not None or
            self.Product_Version_Text is not None or
            self.File_Description is not None or
            self.File_Version_Text is not None or
            self.Original_File_Name is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Version_Block'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Internal_Name is not None:
            showIndent(outfile, level)
            outfile.write('Internal_Name=%s,\n' % quote_python(self.Internal_Name).encode(ExternalEncoding))
        if self.Product_Name is not None:
            showIndent(outfile, level)
            outfile.write('Product_Name=%s,\n' % quote_python(self.Product_Name).encode(ExternalEncoding))
        if self.Company_Name is not None:
            showIndent(outfile, level)
            outfile.write('Company_Name=%s,\n' % quote_python(self.Company_Name).encode(ExternalEncoding))
        if self.Legal_Copyright is not None:
            showIndent(outfile, level)
            outfile.write('Legal_Copyright=%s,\n' % quote_python(self.Legal_Copyright).encode(ExternalEncoding))
        if self.Product_Version_Text is not None:
            showIndent(outfile, level)
            outfile.write('Product_Version_Text=%s,\n' % quote_python(self.Product_Version_Text).encode(ExternalEncoding))
        if self.File_Description is not None:
            showIndent(outfile, level)
            outfile.write('File_Description=%s,\n' % quote_python(self.File_Description).encode(ExternalEncoding))
        if self.File_Version_Text is not None:
            showIndent(outfile, level)
            outfile.write('File_Version_Text=%s,\n' % quote_python(self.File_Version_Text).encode(ExternalEncoding))
        if self.Original_File_Name is not None:
            showIndent(outfile, level)
            outfile.write('Original_File_Name=%s,\n' % quote_python(self.Original_File_Name).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Internal_Name':
            Internal_Name_ = ''
            for text__content_ in child_.childNodes:
                Internal_Name_ += text__content_.nodeValue
            self.Internal_Name = Internal_Name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Product_Name':
            Product_Name_ = ''
            for text__content_ in child_.childNodes:
                Product_Name_ += text__content_.nodeValue
            self.Product_Name = Product_Name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Company_Name':
            Company_Name_ = ''
            for text__content_ in child_.childNodes:
                Company_Name_ += text__content_.nodeValue
            self.Company_Name = Company_Name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Legal_Copyright':
            Legal_Copyright_ = ''
            for text__content_ in child_.childNodes:
                Legal_Copyright_ += text__content_.nodeValue
            self.Legal_Copyright = Legal_Copyright_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Product_Version_Text':
            Product_Version_Text_ = ''
            for text__content_ in child_.childNodes:
                Product_Version_Text_ += text__content_.nodeValue
            self.Product_Version_Text = Product_Version_Text_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'File_Description':
            File_Description_ = ''
            for text__content_ in child_.childNodes:
                File_Description_ += text__content_.nodeValue
            self.File_Description = File_Description_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'File_Version_Text':
            File_Version_Text_ = ''
            for text__content_ in child_.childNodes:
                File_Version_Text_ += text__content_.nodeValue
            self.File_Version_Text = File_Version_Text_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Original_File_Name':
            Original_File_Name_ = ''
            for text__content_ in child_.childNodes:
                Original_File_Name_ += text__content_.nodeValue
            self.Original_File_Name = Original_File_Name_
# end class Version_Block


class Headers(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, DOS_Header=None, PE_Header=None, Section_Table=None):
        self.DOS_Header = DOS_Header
        self.PE_Header = PE_Header
        self.Section_Table = Section_Table
    def factory(*args_, **kwargs_):
        if Headers.subclass:
            return Headers.subclass(*args_, **kwargs_)
        else:
            return Headers(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DOS_Header(self): return self.DOS_Header
    def set_DOS_Header(self, DOS_Header): self.DOS_Header = DOS_Header
    def get_PE_Header(self): return self.PE_Header
    def set_PE_Header(self, PE_Header): self.PE_Header = PE_Header
    def get_Section_Table(self): return self.Section_Table
    def set_Section_Table(self, Section_Table): self.Section_Table = Section_Table
    def export(self, outfile, level, namespace_='maec:', name_='Headers', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Headers')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Headers'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Headers'):
        if self.DOS_Header:
            self.DOS_Header.export(outfile, level, namespace_, name_='DOS_Header')
        if self.PE_Header:
            self.PE_Header.export(outfile, level, namespace_, name_='PE_Header')
        if self.Section_Table:
            self.Section_Table.export(outfile, level, namespace_, name_='Section_Table')
    def hasContent_(self):
        if (
            self.DOS_Header is not None or
            self.PE_Header is not None or
            self.Section_Table is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Headers'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.DOS_Header is not None:
            showIndent(outfile, level)
            outfile.write('DOS_Header=model_.DOS_Header(\n')
            self.DOS_Header.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.PE_Header is not None:
            showIndent(outfile, level)
            outfile.write('PE_Header=model_.PE_Header(\n')
            self.PE_Header.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Section_Table is not None:
            showIndent(outfile, level)
            outfile.write('Section_Table=model_.Section_Table(\n')
            self.Section_Table.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'DOS_Header':
            obj_ = DOS_Header.factory()
            obj_.build(child_)
            self.set_DOS_Header(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'PE_Header':
            obj_ = PE_Header.factory()
            obj_.build(child_)
            self.set_PE_Header(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Section_Table':
            obj_ = Section_Table.factory()
            obj_.build(child_)
            self.set_Section_Table(obj_)
# end class Headers


class DOS_Header(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Hashes=None, signature=None, lastsize=None, nblocks=None, nreloc=None, hdrsize=None, minalloc=None, maxalloc=None, checksum=None, relocpos=None, noverlay=None, reserved1=None, oem_id=None, oem_info=None, reserved2=None, e_lfanew=None):
        self.Hashes = Hashes
        self.signature = signature
        self.lastsize = lastsize
        self.nblocks = nblocks
        self.nreloc = nreloc
        self.hdrsize = hdrsize
        self.minalloc = minalloc
        self.maxalloc = maxalloc
        self.checksum = checksum
        self.relocpos = relocpos
        self.noverlay = noverlay
        self.reserved1 = reserved1
        self.oem_id = oem_id
        self.oem_info = oem_info
        self.reserved2 = reserved2
        self.e_lfanew = e_lfanew
    def factory(*args_, **kwargs_):
        if DOS_Header.subclass:
            return DOS_Header.subclass(*args_, **kwargs_)
        else:
            return DOS_Header(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hashes(self): return self.Hashes
    def set_Hashes(self, Hashes): self.Hashes = Hashes
    def get_signature(self): return self.signature
    def set_signature(self, signature): self.signature = signature
    def get_lastsize(self): return self.lastsize
    def set_lastsize(self, lastsize): self.lastsize = lastsize
    def get_nblocks(self): return self.nblocks
    def set_nblocks(self, nblocks): self.nblocks = nblocks
    def get_nreloc(self): return self.nreloc
    def set_nreloc(self, nreloc): self.nreloc = nreloc
    def get_hdrsize(self): return self.hdrsize
    def set_hdrsize(self, hdrsize): self.hdrsize = hdrsize
    def get_minalloc(self): return self.minalloc
    def set_minalloc(self, minalloc): self.minalloc = minalloc
    def get_maxalloc(self): return self.maxalloc
    def set_maxalloc(self, maxalloc): self.maxalloc = maxalloc
    def get_checksum(self): return self.checksum
    def set_checksum(self, checksum): self.checksum = checksum
    def get_relocpos(self): return self.relocpos
    def set_relocpos(self, relocpos): self.relocpos = relocpos
    def get_noverlay(self): return self.noverlay
    def set_noverlay(self, noverlay): self.noverlay = noverlay
    def get_reserved1(self): return self.reserved1
    def set_reserved1(self, reserved1): self.reserved1 = reserved1
    def get_oem_id(self): return self.oem_id
    def set_oem_id(self, oem_id): self.oem_id = oem_id
    def get_oem_info(self): return self.oem_info
    def set_oem_info(self, oem_info): self.oem_info = oem_info
    def get_reserved2(self): return self.reserved2
    def set_reserved2(self, reserved2): self.reserved2 = reserved2
    def get_e_lfanew(self): return self.e_lfanew
    def set_e_lfanew(self, e_lfanew): self.e_lfanew = e_lfanew
    def export(self, outfile, level, namespace_='maec:', name_='DOS_Header', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='DOS_Header')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='DOS_Header'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='DOS_Header'):
        if self.Hashes:
            self.Hashes.export(outfile, level, namespace_, name_='Hashes')
        if self.signature is not None:
            showIndent(outfile, level)
            outfile.write('<%ssignature>%s</%ssignature>\n' % (namespace_, self.format_string(quote_xml(self.signature).encode(ExternalEncoding), input_name='signature'), namespace_))
        if self.lastsize is not None:
            showIndent(outfile, level)
            outfile.write('<%slastsize>%s</%slastsize>\n' % (namespace_, self.format_string(quote_xml(self.lastsize).encode(ExternalEncoding), input_name='lastsize'), namespace_))
        if self.nblocks is not None:
            showIndent(outfile, level)
            outfile.write('<%snblocks>%s</%snblocks>\n' % (namespace_, self.format_string(quote_xml(self.nblocks).encode(ExternalEncoding), input_name='nblocks'), namespace_))
        if self.nreloc is not None:
            showIndent(outfile, level)
            outfile.write('<%snreloc>%s</%snreloc>\n' % (namespace_, self.format_string(quote_xml(self.nreloc).encode(ExternalEncoding), input_name='nreloc'), namespace_))
        if self.hdrsize is not None:
            showIndent(outfile, level)
            outfile.write('<%shdrsize>%s</%shdrsize>\n' % (namespace_, self.format_string(quote_xml(self.hdrsize).encode(ExternalEncoding), input_name='hdrsize'), namespace_))
        if self.minalloc is not None:
            showIndent(outfile, level)
            outfile.write('<%sminalloc>%s</%sminalloc>\n' % (namespace_, self.format_string(quote_xml(self.minalloc).encode(ExternalEncoding), input_name='minalloc'), namespace_))
        if self.maxalloc is not None:
            showIndent(outfile, level)
            outfile.write('<%smaxalloc>%s</%smaxalloc>\n' % (namespace_, self.format_string(quote_xml(self.maxalloc).encode(ExternalEncoding), input_name='maxalloc'), namespace_))
        if self.checksum is not None:
            showIndent(outfile, level)
            outfile.write('<%schecksum>%s</%schecksum>\n' % (namespace_, self.format_string(quote_xml(self.checksum).encode(ExternalEncoding), input_name='checksum'), namespace_))
        if self.relocpos is not None:
            showIndent(outfile, level)
            outfile.write('<%srelocpos>%s</%srelocpos>\n' % (namespace_, self.format_string(quote_xml(self.relocpos).encode(ExternalEncoding), input_name='relocpos'), namespace_))
        if self.noverlay is not None:
            showIndent(outfile, level)
            outfile.write('<%snoverlay>%s</%snoverlay>\n' % (namespace_, self.format_string(quote_xml(self.noverlay).encode(ExternalEncoding), input_name='noverlay'), namespace_))
        if self.reserved1 is not None:
            showIndent(outfile, level)
            outfile.write('<%sreserved1>%s</%sreserved1>\n' % (namespace_, self.format_string(quote_xml(self.reserved1).encode(ExternalEncoding), input_name='reserved1'), namespace_))
        if self.oem_id is not None:
            showIndent(outfile, level)
            outfile.write('<%soem_id>%s</%soem_id>\n' % (namespace_, self.format_string(quote_xml(self.oem_id).encode(ExternalEncoding), input_name='oem_id'), namespace_))
        if self.oem_info is not None:
            showIndent(outfile, level)
            outfile.write('<%soem_info>%s</%soem_info>\n' % (namespace_, self.format_string(quote_xml(self.oem_info).encode(ExternalEncoding), input_name='oem_info'), namespace_))
        if self.reserved2 is not None:
            showIndent(outfile, level)
            outfile.write('<%sreserved2>%s</%sreserved2>\n' % (namespace_, self.format_string(quote_xml(self.reserved2).encode(ExternalEncoding), input_name='reserved2'), namespace_))
        if self.e_lfanew is not None:
            showIndent(outfile, level)
            outfile.write('<%se_lfanew>%s</%se_lfanew>\n' % (namespace_, self.format_string(quote_xml(self.e_lfanew).encode(ExternalEncoding), input_name='e_lfanew'), namespace_))
    def hasContent_(self):
        if (
            self.Hashes is not None or
            self.signature is not None or
            self.lastsize is not None or
            self.nblocks is not None or
            self.nreloc is not None or
            self.hdrsize is not None or
            self.minalloc is not None or
            self.maxalloc is not None or
            self.checksum is not None or
            self.relocpos is not None or
            self.noverlay is not None or
            self.reserved1 is not None or
            self.oem_id is not None or
            self.oem_info is not None or
            self.reserved2 is not None or
            self.e_lfanew is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DOS_Header'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Hashes=model_.Hashes(\n')
            self.Hashes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.signature is not None:
            showIndent(outfile, level)
            outfile.write('signature=%s,\n' % quote_python(self.signature).encode(ExternalEncoding))
        if self.lastsize is not None:
            showIndent(outfile, level)
            outfile.write('lastsize=%s,\n' % quote_python(self.lastsize).encode(ExternalEncoding))
        if self.nblocks is not None:
            showIndent(outfile, level)
            outfile.write('nblocks=%s,\n' % quote_python(self.nblocks).encode(ExternalEncoding))
        if self.nreloc is not None:
            showIndent(outfile, level)
            outfile.write('nreloc=%s,\n' % quote_python(self.nreloc).encode(ExternalEncoding))
        if self.hdrsize is not None:
            showIndent(outfile, level)
            outfile.write('hdrsize=%s,\n' % quote_python(self.hdrsize).encode(ExternalEncoding))
        if self.minalloc is not None:
            showIndent(outfile, level)
            outfile.write('minalloc=%s,\n' % quote_python(self.minalloc).encode(ExternalEncoding))
        if self.maxalloc is not None:
            showIndent(outfile, level)
            outfile.write('maxalloc=%s,\n' % quote_python(self.maxalloc).encode(ExternalEncoding))
        if self.checksum is not None:
            showIndent(outfile, level)
            outfile.write('checksum=%s,\n' % quote_python(self.checksum).encode(ExternalEncoding))
        if self.relocpos is not None:
            showIndent(outfile, level)
            outfile.write('relocpos=%s,\n' % quote_python(self.relocpos).encode(ExternalEncoding))
        if self.noverlay is not None:
            showIndent(outfile, level)
            outfile.write('noverlay=%s,\n' % quote_python(self.noverlay).encode(ExternalEncoding))
        if self.reserved1 is not None:
            showIndent(outfile, level)
            outfile.write('reserved1=%s,\n' % quote_python(self.reserved1).encode(ExternalEncoding))
        if self.oem_id is not None:
            showIndent(outfile, level)
            outfile.write('oem_id=%s,\n' % quote_python(self.oem_id).encode(ExternalEncoding))
        if self.oem_info is not None:
            showIndent(outfile, level)
            outfile.write('oem_info=%s,\n' % quote_python(self.oem_info).encode(ExternalEncoding))
        if self.reserved2 is not None:
            showIndent(outfile, level)
            outfile.write('reserved2=%s,\n' % quote_python(self.reserved2).encode(ExternalEncoding))
        if self.e_lfanew is not None:
            showIndent(outfile, level)
            outfile.write('e_lfanew=%s,\n' % quote_python(self.e_lfanew).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Hashes':
            obj_ = Hashes.factory()
            obj_.build(child_)
            self.set_Hashes(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'signature':
            signature_ = ''
            for text__content_ in child_.childNodes:
                signature_ += text__content_.nodeValue
            self.signature = signature_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'lastsize':
            lastsize_ = ''
            for text__content_ in child_.childNodes:
                lastsize_ += text__content_.nodeValue
            self.lastsize = lastsize_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'nblocks':
            nblocks_ = ''
            for text__content_ in child_.childNodes:
                nblocks_ += text__content_.nodeValue
            self.nblocks = nblocks_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'nreloc':
            nreloc_ = ''
            for text__content_ in child_.childNodes:
                nreloc_ += text__content_.nodeValue
            self.nreloc = nreloc_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'hdrsize':
            hdrsize_ = ''
            for text__content_ in child_.childNodes:
                hdrsize_ += text__content_.nodeValue
            self.hdrsize = hdrsize_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'minalloc':
            minalloc_ = ''
            for text__content_ in child_.childNodes:
                minalloc_ += text__content_.nodeValue
            self.minalloc = minalloc_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'maxalloc':
            maxalloc_ = ''
            for text__content_ in child_.childNodes:
                maxalloc_ += text__content_.nodeValue
            self.maxalloc = maxalloc_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'checksum':
            checksum_ = ''
            for text__content_ in child_.childNodes:
                checksum_ += text__content_.nodeValue
            self.checksum = checksum_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'relocpos':
            relocpos_ = ''
            for text__content_ in child_.childNodes:
                relocpos_ += text__content_.nodeValue
            self.relocpos = relocpos_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'noverlay':
            noverlay_ = ''
            for text__content_ in child_.childNodes:
                noverlay_ += text__content_.nodeValue
            self.noverlay = noverlay_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'reserved1':
            reserved1_ = ''
            for text__content_ in child_.childNodes:
                reserved1_ += text__content_.nodeValue
            self.reserved1 = reserved1_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'oem_id':
            oem_id_ = ''
            for text__content_ in child_.childNodes:
                oem_id_ += text__content_.nodeValue
            self.oem_id = oem_id_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'oem_info':
            oem_info_ = ''
            for text__content_ in child_.childNodes:
                oem_info_ += text__content_.nodeValue
            self.oem_info = oem_info_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'reserved2':
            reserved2_ = ''
            for text__content_ in child_.childNodes:
                reserved2_ += text__content_.nodeValue
            self.reserved2 = reserved2_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'e_lfanew':
            e_lfanew_ = ''
            for text__content_ in child_.childNodes:
                e_lfanew_ += text__content_.nodeValue
            self.e_lfanew = e_lfanew_
# end class DOS_Header


class PE_Header(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Hashes=None, Entropy=None, Signature=None, File_Header=None, Optional_Header=None):
        self.Hashes = Hashes
        self.Entropy = Entropy
        self.Signature = Signature
        self.File_Header = File_Header
        self.Optional_Header = Optional_Header
    def factory(*args_, **kwargs_):
        if PE_Header.subclass:
            return PE_Header.subclass(*args_, **kwargs_)
        else:
            return PE_Header(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hashes(self): return self.Hashes
    def set_Hashes(self, Hashes): self.Hashes = Hashes
    def get_Entropy(self): return self.Entropy
    def set_Entropy(self, Entropy): self.Entropy = Entropy
    def get_Signature(self): return self.Signature
    def set_Signature(self, Signature): self.Signature = Signature
    def get_File_Header(self): return self.File_Header
    def set_File_Header(self, File_Header): self.File_Header = File_Header
    def get_Optional_Header(self): return self.Optional_Header
    def set_Optional_Header(self, Optional_Header): self.Optional_Header = Optional_Header
    def export(self, outfile, level, namespace_='maec:', name_='PE_Header', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='PE_Header')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='PE_Header'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='PE_Header'):
        if self.Hashes:
            self.Hashes.export(outfile, level, namespace_, name_='Hashes')
        if self.Entropy is not None:
            showIndent(outfile, level)
            outfile.write('<%sEntropy>%s</%sEntropy>\n' % (namespace_, self.format_float(self.Entropy, input_name='Entropy'), namespace_))
        if self.Signature is not None:
            showIndent(outfile, level)
            outfile.write('<%sSignature>%s</%sSignature>\n' % (namespace_, self.format_string(quote_xml(self.Signature).encode(ExternalEncoding), input_name='Signature'), namespace_))
        if self.File_Header:
            self.File_Header.export(outfile, level, namespace_, name_='File_Header')
        if self.Optional_Header:
            self.Optional_Header.export(outfile, level, namespace_, name_='Optional_Header')
    def hasContent_(self):
        if (
            self.Hashes is not None or
            self.Entropy is not None or
            self.Signature is not None or
            self.File_Header is not None or
            self.Optional_Header is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PE_Header'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Hashes=model_.Hashes(\n')
            self.Hashes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Entropy is not None:
            showIndent(outfile, level)
            outfile.write('Entropy=%f,\n' % self.Entropy)
        if self.Signature is not None:
            showIndent(outfile, level)
            outfile.write('Signature=%s,\n' % quote_python(self.Signature).encode(ExternalEncoding))
        if self.File_Header is not None:
            showIndent(outfile, level)
            outfile.write('File_Header=model_.File_Header(\n')
            self.File_Header.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Optional_Header is not None:
            showIndent(outfile, level)
            outfile.write('Optional_Header=model_.Optional_Header(\n')
            self.Optional_Header.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Hashes':
            obj_ = Hashes.factory()
            obj_.build(child_)
            self.set_Hashes(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Entropy':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    fval_ = float(sval_)
                except ValueError as exp:
                    raise ValueError('requires float or double (Entropy): %s' %exp)
                self.Entropy = fval_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Signature':
            Signature_ = ''
            for text__content_ in child_.childNodes:
                Signature_ += text__content_.nodeValue
            self.Signature = Signature_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'File_Header':
            obj_ = File_Header.factory()
            obj_.build(child_)
            self.set_File_Header(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Optional_Header':
            obj_ = Optional_Header.factory()
            obj_.build(child_)
            self.set_Optional_Header(obj_)
# end class PE_Header


class File_Header(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Hashes=None, Machine=None, Number_Of_Sections=None, Time_Date_Stamp=None, Pointer_To_Symbol_Table=None, Number_Of_Symbols=None, Size_Of_Optional_Header=None, Characteristics=None):
        self.Hashes = Hashes
        self.Machine = Machine
        self.Number_Of_Sections = Number_Of_Sections
        self.Time_Date_Stamp = Time_Date_Stamp
        self.Pointer_To_Symbol_Table = Pointer_To_Symbol_Table
        self.Number_Of_Symbols = Number_Of_Symbols
        self.Size_Of_Optional_Header = Size_Of_Optional_Header
        self.Characteristics = Characteristics
    def factory(*args_, **kwargs_):
        if File_Header.subclass:
            return File_Header.subclass(*args_, **kwargs_)
        else:
            return File_Header(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hashes(self): return self.Hashes
    def set_Hashes(self, Hashes): self.Hashes = Hashes
    def get_Machine(self): return self.Machine
    def set_Machine(self, Machine): self.Machine = Machine
    def get_Number_Of_Sections(self): return self.Number_Of_Sections
    def set_Number_Of_Sections(self, Number_Of_Sections): self.Number_Of_Sections = Number_Of_Sections
    def get_Time_Date_Stamp(self): return self.Time_Date_Stamp
    def set_Time_Date_Stamp(self, Time_Date_Stamp): self.Time_Date_Stamp = Time_Date_Stamp
    def get_Pointer_To_Symbol_Table(self): return self.Pointer_To_Symbol_Table
    def set_Pointer_To_Symbol_Table(self, Pointer_To_Symbol_Table): self.Pointer_To_Symbol_Table = Pointer_To_Symbol_Table
    def get_Number_Of_Symbols(self): return self.Number_Of_Symbols
    def set_Number_Of_Symbols(self, Number_Of_Symbols): self.Number_Of_Symbols = Number_Of_Symbols
    def get_Size_Of_Optional_Header(self): return self.Size_Of_Optional_Header
    def set_Size_Of_Optional_Header(self, Size_Of_Optional_Header): self.Size_Of_Optional_Header = Size_Of_Optional_Header
    def get_Characteristics(self): return self.Characteristics
    def set_Characteristics(self, Characteristics): self.Characteristics = Characteristics
    def export(self, outfile, level, namespace_='maec:', name_='File_Header', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='File_Header')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='File_Header'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='File_Header'):
        if self.Hashes:
            self.Hashes.export(outfile, level, namespace_, name_='Hashes')
        if self.Machine is not None:
            showIndent(outfile, level)
            outfile.write('<%sMachine>%s</%sMachine>\n' % (namespace_, self.format_string(quote_xml(self.Machine).encode(ExternalEncoding), input_name='Machine'), namespace_))
        if self.Number_Of_Sections is not None:
            showIndent(outfile, level)
            outfile.write('<%sNumber_Of_Sections>%s</%sNumber_Of_Sections>\n' % (namespace_, self.format_integer(self.Number_Of_Sections, input_name='Number_Of_Sections'), namespace_))
        if self.Time_Date_Stamp is not None:
            showIndent(outfile, level)
            outfile.write('<%sTime_Date_Stamp>%s</%sTime_Date_Stamp>\n' % (namespace_, self.format_string(quote_xml(self.Time_Date_Stamp).encode(ExternalEncoding), input_name='Time_Date_Stamp'), namespace_))
        if self.Pointer_To_Symbol_Table is not None:
            showIndent(outfile, level)
            outfile.write('<%sPointer_To_Symbol_Table>%s</%sPointer_To_Symbol_Table>\n' % (namespace_, self.format_string(quote_xml(self.Pointer_To_Symbol_Table).encode(ExternalEncoding), input_name='Pointer_To_Symbol_Table'), namespace_))
        if self.Number_Of_Symbols is not None:
            showIndent(outfile, level)
            outfile.write('<%sNumber_Of_Symbols>%s</%sNumber_Of_Symbols>\n' % (namespace_, self.format_integer(self.Number_Of_Symbols, input_name='Number_Of_Symbols'), namespace_))
        if self.Size_Of_Optional_Header is not None:
            showIndent(outfile, level)
            outfile.write('<%sSize_Of_Optional_Header>%s</%sSize_Of_Optional_Header>\n' % (namespace_, self.format_string(quote_xml(self.Size_Of_Optional_Header).encode(ExternalEncoding), input_name='Size_Of_Optional_Header'), namespace_))
        if self.Characteristics is not None:
            showIndent(outfile, level)
            outfile.write('<%sCharacteristics>%s</%sCharacteristics>\n' % (namespace_, self.format_string(quote_xml(self.Characteristics).encode(ExternalEncoding), input_name='Characteristics'), namespace_))
    def hasContent_(self):
        if (
            self.Hashes is not None or
            self.Machine is not None or
            self.Number_Of_Sections is not None or
            self.Time_Date_Stamp is not None or
            self.Pointer_To_Symbol_Table is not None or
            self.Number_Of_Symbols is not None or
            self.Size_Of_Optional_Header is not None or
            self.Characteristics is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='File_Header'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Hashes=model_.Hashes(\n')
            self.Hashes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Machine is not None:
            showIndent(outfile, level)
            outfile.write('Machine=%s,\n' % quote_python(self.Machine).encode(ExternalEncoding))
        if self.Number_Of_Sections is not None:
            showIndent(outfile, level)
            outfile.write('Number_Of_Sections=%d,\n' % self.Number_Of_Sections)
        if self.Time_Date_Stamp is not None:
            showIndent(outfile, level)
            outfile.write('Time_Date_Stamp=%s,\n' % quote_python(self.Time_Date_Stamp).encode(ExternalEncoding))
        if self.Pointer_To_Symbol_Table is not None:
            showIndent(outfile, level)
            outfile.write('Pointer_To_Symbol_Table=%s,\n' % quote_python(self.Pointer_To_Symbol_Table).encode(ExternalEncoding))
        if self.Number_Of_Symbols is not None:
            showIndent(outfile, level)
            outfile.write('Number_Of_Symbols=%d,\n' % self.Number_Of_Symbols)
        if self.Size_Of_Optional_Header is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Optional_Header=%s,\n' % quote_python(self.Size_Of_Optional_Header).encode(ExternalEncoding))
        if self.Characteristics is not None:
            showIndent(outfile, level)
            outfile.write('Characteristics=%s,\n' % quote_python(self.Characteristics).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Hashes':
            obj_ = Hashes.factory()
            obj_.build(child_)
            self.set_Hashes(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Machine':
            Machine_ = ''
            for text__content_ in child_.childNodes:
                Machine_ += text__content_.nodeValue
            self.Machine = Machine_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Number_Of_Sections':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError as exp:
                    raise ValueError('requires integer (Number_Of_Sections): %s' % exp)
                self.Number_Of_Sections = ival_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Time_Date_Stamp':
            Time_Date_Stamp_ = ''
            for text__content_ in child_.childNodes:
                Time_Date_Stamp_ += text__content_.nodeValue
            self.Time_Date_Stamp = Time_Date_Stamp_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Pointer_To_Symbol_Table':
            Pointer_To_Symbol_Table_ = ''
            for text__content_ in child_.childNodes:
                Pointer_To_Symbol_Table_ += text__content_.nodeValue
            self.Pointer_To_Symbol_Table = Pointer_To_Symbol_Table_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Number_Of_Symbols':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError as exp:
                    raise ValueError('requires integer (Number_Of_Symbols): %s' % exp)
                self.Number_Of_Symbols = ival_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Size_Of_Optional_Header':
            Size_Of_Optional_Header_ = ''
            for text__content_ in child_.childNodes:
                Size_Of_Optional_Header_ += text__content_.nodeValue
            self.Size_Of_Optional_Header = Size_Of_Optional_Header_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Characteristics':
            Characteristics_ = ''
            for text__content_ in child_.childNodes:
                Characteristics_ += text__content_.nodeValue
            self.Characteristics = Characteristics_
# end class File_Header


class Optional_Header(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Hashes=None, Major_Linker_Version=None, Minor_Linker_Version=None, Size_Of_Code=None, Size_Of_Initialized_Data=None, Size_Of_Uninitialized_Data=None, Address_Of_Entry_Point=None, Base_Of_Code=None, Base_Of_Data=None, Image_Base=None, Section_Alignment=None, File_Alignment=None, Major_OS_Version=None, Minor_OS_Version=None, Major_Image_Version=None, Minor_Image_Version=None, Major_Subsystem_Version=None, Minor_Subsystem_Version=None, Reserved=None, Size_Of_Image=None, Size_Of_Headers=None, Checksum=None, Subsystem=None, DLL_Characteristics=None, Size_Of_Stack_Reserve=None, Size_Of_Stack_Commit=None, Size_Of_Heap_Reserve=None, Size_Of_Heap_Commit=None, Loader_Flags=None, Number_Of_Rva_And_Sizes=None, Data_Directory=None):
        self.Hashes = Hashes
        self.Major_Linker_Version = Major_Linker_Version
        self.Minor_Linker_Version = Minor_Linker_Version
        self.Size_Of_Code = Size_Of_Code
        self.Size_Of_Initialized_Data = Size_Of_Initialized_Data
        self.Size_Of_Uninitialized_Data = Size_Of_Uninitialized_Data
        self.Address_Of_Entry_Point = Address_Of_Entry_Point
        self.Base_Of_Code = Base_Of_Code
        self.Base_Of_Data = Base_Of_Data
        self.Image_Base = Image_Base
        self.Section_Alignment = Section_Alignment
        self.File_Alignment = File_Alignment
        self.Major_OS_Version = Major_OS_Version
        self.Minor_OS_Version = Minor_OS_Version
        self.Major_Image_Version = Major_Image_Version
        self.Minor_Image_Version = Minor_Image_Version
        self.Major_Subsystem_Version = Major_Subsystem_Version
        self.Minor_Subsystem_Version = Minor_Subsystem_Version
        self.Reserved = Reserved
        self.Size_Of_Image = Size_Of_Image
        self.Size_Of_Headers = Size_Of_Headers
        self.Checksum = Checksum
        self.Subsystem = Subsystem
        self.DLL_Characteristics = DLL_Characteristics
        self.Size_Of_Stack_Reserve = Size_Of_Stack_Reserve
        self.Size_Of_Stack_Commit = Size_Of_Stack_Commit
        self.Size_Of_Heap_Reserve = Size_Of_Heap_Reserve
        self.Size_Of_Heap_Commit = Size_Of_Heap_Commit
        self.Loader_Flags = Loader_Flags
        self.Number_Of_Rva_And_Sizes = Number_Of_Rva_And_Sizes
        self.Data_Directory = Data_Directory
    def factory(*args_, **kwargs_):
        if Optional_Header.subclass:
            return Optional_Header.subclass(*args_, **kwargs_)
        else:
            return Optional_Header(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hashes(self): return self.Hashes
    def set_Hashes(self, Hashes): self.Hashes = Hashes
    def get_Major_Linker_Version(self): return self.Major_Linker_Version
    def set_Major_Linker_Version(self, Major_Linker_Version): self.Major_Linker_Version = Major_Linker_Version
    def get_Minor_Linker_Version(self): return self.Minor_Linker_Version
    def set_Minor_Linker_Version(self, Minor_Linker_Version): self.Minor_Linker_Version = Minor_Linker_Version
    def get_Size_Of_Code(self): return self.Size_Of_Code
    def set_Size_Of_Code(self, Size_Of_Code): self.Size_Of_Code = Size_Of_Code
    def get_Size_Of_Initialized_Data(self): return self.Size_Of_Initialized_Data
    def set_Size_Of_Initialized_Data(self, Size_Of_Initialized_Data): self.Size_Of_Initialized_Data = Size_Of_Initialized_Data
    def get_Size_Of_Uninitialized_Data(self): return self.Size_Of_Uninitialized_Data
    def set_Size_Of_Uninitialized_Data(self, Size_Of_Uninitialized_Data): self.Size_Of_Uninitialized_Data = Size_Of_Uninitialized_Data
    def get_Address_Of_Entry_Point(self): return self.Address_Of_Entry_Point
    def set_Address_Of_Entry_Point(self, Address_Of_Entry_Point): self.Address_Of_Entry_Point = Address_Of_Entry_Point
    def get_Base_Of_Code(self): return self.Base_Of_Code
    def set_Base_Of_Code(self, Base_Of_Code): self.Base_Of_Code = Base_Of_Code
    def get_Base_Of_Data(self): return self.Base_Of_Data
    def set_Base_Of_Data(self, Base_Of_Data): self.Base_Of_Data = Base_Of_Data
    def get_Image_Base(self): return self.Image_Base
    def set_Image_Base(self, Image_Base): self.Image_Base = Image_Base
    def get_Section_Alignment(self): return self.Section_Alignment
    def set_Section_Alignment(self, Section_Alignment): self.Section_Alignment = Section_Alignment
    def get_File_Alignment(self): return self.File_Alignment
    def set_File_Alignment(self, File_Alignment): self.File_Alignment = File_Alignment
    def get_Major_OS_Version(self): return self.Major_OS_Version
    def set_Major_OS_Version(self, Major_OS_Version): self.Major_OS_Version = Major_OS_Version
    def get_Minor_OS_Version(self): return self.Minor_OS_Version
    def set_Minor_OS_Version(self, Minor_OS_Version): self.Minor_OS_Version = Minor_OS_Version
    def get_Major_Image_Version(self): return self.Major_Image_Version
    def set_Major_Image_Version(self, Major_Image_Version): self.Major_Image_Version = Major_Image_Version
    def get_Minor_Image_Version(self): return self.Minor_Image_Version
    def set_Minor_Image_Version(self, Minor_Image_Version): self.Minor_Image_Version = Minor_Image_Version
    def get_Major_Subsystem_Version(self): return self.Major_Subsystem_Version
    def set_Major_Subsystem_Version(self, Major_Subsystem_Version): self.Major_Subsystem_Version = Major_Subsystem_Version
    def get_Minor_Subsystem_Version(self): return self.Minor_Subsystem_Version
    def set_Minor_Subsystem_Version(self, Minor_Subsystem_Version): self.Minor_Subsystem_Version = Minor_Subsystem_Version
    def get_Reserved(self): return self.Reserved
    def set_Reserved(self, Reserved): self.Reserved = Reserved
    def get_Size_Of_Image(self): return self.Size_Of_Image
    def set_Size_Of_Image(self, Size_Of_Image): self.Size_Of_Image = Size_Of_Image
    def get_Size_Of_Headers(self): return self.Size_Of_Headers
    def set_Size_Of_Headers(self, Size_Of_Headers): self.Size_Of_Headers = Size_Of_Headers
    def get_Checksum(self): return self.Checksum
    def set_Checksum(self, Checksum): self.Checksum = Checksum
    def get_Subsystem(self): return self.Subsystem
    def set_Subsystem(self, Subsystem): self.Subsystem = Subsystem
    def get_DLL_Characteristics(self): return self.DLL_Characteristics
    def set_DLL_Characteristics(self, DLL_Characteristics): self.DLL_Characteristics = DLL_Characteristics
    def get_Size_Of_Stack_Reserve(self): return self.Size_Of_Stack_Reserve
    def set_Size_Of_Stack_Reserve(self, Size_Of_Stack_Reserve): self.Size_Of_Stack_Reserve = Size_Of_Stack_Reserve
    def get_Size_Of_Stack_Commit(self): return self.Size_Of_Stack_Commit
    def set_Size_Of_Stack_Commit(self, Size_Of_Stack_Commit): self.Size_Of_Stack_Commit = Size_Of_Stack_Commit
    def get_Size_Of_Heap_Reserve(self): return self.Size_Of_Heap_Reserve
    def set_Size_Of_Heap_Reserve(self, Size_Of_Heap_Reserve): self.Size_Of_Heap_Reserve = Size_Of_Heap_Reserve
    def get_Size_Of_Heap_Commit(self): return self.Size_Of_Heap_Commit
    def set_Size_Of_Heap_Commit(self, Size_Of_Heap_Commit): self.Size_Of_Heap_Commit = Size_Of_Heap_Commit
    def get_Loader_Flags(self): return self.Loader_Flags
    def set_Loader_Flags(self, Loader_Flags): self.Loader_Flags = Loader_Flags
    def get_Number_Of_Rva_And_Sizes(self): return self.Number_Of_Rva_And_Sizes
    def set_Number_Of_Rva_And_Sizes(self, Number_Of_Rva_And_Sizes): self.Number_Of_Rva_And_Sizes = Number_Of_Rva_And_Sizes
    def get_Data_Directory(self): return self.Data_Directory
    def set_Data_Directory(self, Data_Directory): self.Data_Directory = Data_Directory
    def export(self, outfile, level, namespace_='maec:', name_='Optional_Header', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Optional_Header')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Optional_Header'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Optional_Header'):
        if self.Hashes:
            self.Hashes.export(outfile, level, namespace_, name_='Hashes')
        if self.Major_Linker_Version is not None:
            showIndent(outfile, level)
            outfile.write('<%sMajor_Linker_Version>%s</%sMajor_Linker_Version>\n' % (namespace_, self.format_string(quote_xml(self.Major_Linker_Version).encode(ExternalEncoding), input_name='Major_Linker_Version'), namespace_))
        if self.Minor_Linker_Version is not None:
            showIndent(outfile, level)
            outfile.write('<%sMinor_Linker_Version>%s</%sMinor_Linker_Version>\n' % (namespace_, self.format_string(quote_xml(self.Minor_Linker_Version).encode(ExternalEncoding), input_name='Minor_Linker_Version'), namespace_))
        if self.Size_Of_Code is not None:
            showIndent(outfile, level)
            outfile.write('<%sSize_Of_Code>%s</%sSize_Of_Code>\n' % (namespace_, self.format_string(quote_xml(self.Size_Of_Code).encode(ExternalEncoding), input_name='Size_Of_Code'), namespace_))
        if self.Size_Of_Initialized_Data is not None:
            showIndent(outfile, level)
            outfile.write('<%sSize_Of_Initialized_Data>%s</%sSize_Of_Initialized_Data>\n' % (namespace_, self.format_string(quote_xml(self.Size_Of_Initialized_Data).encode(ExternalEncoding), input_name='Size_Of_Initialized_Data'), namespace_))
        if self.Size_Of_Uninitialized_Data is not None:
            showIndent(outfile, level)
            outfile.write('<%sSize_Of_Uninitialized_Data>%s</%sSize_Of_Uninitialized_Data>\n' % (namespace_, self.format_string(quote_xml(self.Size_Of_Uninitialized_Data).encode(ExternalEncoding), input_name='Size_Of_Uninitialized_Data'), namespace_))
        if self.Address_Of_Entry_Point is not None:
            showIndent(outfile, level)
            outfile.write('<%sAddress_Of_Entry_Point>%s</%sAddress_Of_Entry_Point>\n' % (namespace_, self.format_string(quote_xml(self.Address_Of_Entry_Point).encode(ExternalEncoding), input_name='Address_Of_Entry_Point'), namespace_))
        if self.Base_Of_Code is not None:
            showIndent(outfile, level)
            outfile.write('<%sBase_Of_Code>%s</%sBase_Of_Code>\n' % (namespace_, self.format_string(quote_xml(self.Base_Of_Code).encode(ExternalEncoding), input_name='Base_Of_Code'), namespace_))
        if self.Base_Of_Data is not None:
            showIndent(outfile, level)
            outfile.write('<%sBase_Of_Data>%s</%sBase_Of_Data>\n' % (namespace_, self.format_string(quote_xml(self.Base_Of_Data).encode(ExternalEncoding), input_name='Base_Of_Data'), namespace_))
        if self.Image_Base is not None:
            showIndent(outfile, level)
            outfile.write('<%sImage_Base>%s</%sImage_Base>\n' % (namespace_, self.format_string(quote_xml(self.Image_Base).encode(ExternalEncoding), input_name='Image_Base'), namespace_))
        if self.Section_Alignment is not None:
            showIndent(outfile, level)
            outfile.write('<%sSection_Alignment>%s</%sSection_Alignment>\n' % (namespace_, self.format_string(quote_xml(self.Section_Alignment).encode(ExternalEncoding), input_name='Section_Alignment'), namespace_))
        if self.File_Alignment is not None:
            showIndent(outfile, level)
            outfile.write('<%sFile_Alignment>%s</%sFile_Alignment>\n' % (namespace_, self.format_string(quote_xml(self.File_Alignment).encode(ExternalEncoding), input_name='File_Alignment'), namespace_))
        if self.Major_OS_Version is not None:
            showIndent(outfile, level)
            outfile.write('<%sMajor_OS_Version>%s</%sMajor_OS_Version>\n' % (namespace_, self.format_string(quote_xml(self.Major_OS_Version).encode(ExternalEncoding), input_name='Major_OS_Version'), namespace_))
        if self.Minor_OS_Version is not None:
            showIndent(outfile, level)
            outfile.write('<%sMinor_OS_Version>%s</%sMinor_OS_Version>\n' % (namespace_, self.format_string(quote_xml(self.Minor_OS_Version).encode(ExternalEncoding), input_name='Minor_OS_Version'), namespace_))
        if self.Major_Image_Version is not None:
            showIndent(outfile, level)
            outfile.write('<%sMajor_Image_Version>%s</%sMajor_Image_Version>\n' % (namespace_, self.format_string(quote_xml(self.Major_Image_Version).encode(ExternalEncoding), input_name='Major_Image_Version'), namespace_))
        if self.Minor_Image_Version is not None:
            showIndent(outfile, level)
            outfile.write('<%sMinor_Image_Version>%s</%sMinor_Image_Version>\n' % (namespace_, self.format_string(quote_xml(self.Minor_Image_Version).encode(ExternalEncoding), input_name='Minor_Image_Version'), namespace_))
        if self.Major_Subsystem_Version is not None:
            showIndent(outfile, level)
            outfile.write('<%sMajor_Subsystem_Version>%s</%sMajor_Subsystem_Version>\n' % (namespace_, self.format_string(quote_xml(self.Major_Subsystem_Version).encode(ExternalEncoding), input_name='Major_Subsystem_Version'), namespace_))
        if self.Minor_Subsystem_Version is not None:
            showIndent(outfile, level)
            outfile.write('<%sMinor_Subsystem_Version>%s</%sMinor_Subsystem_Version>\n' % (namespace_, self.format_string(quote_xml(self.Minor_Subsystem_Version).encode(ExternalEncoding), input_name='Minor_Subsystem_Version'), namespace_))
        if self.Reserved is not None:
            showIndent(outfile, level)
            outfile.write('<%sReserved>%s</%sReserved>\n' % (namespace_, self.format_string(quote_xml(self.Reserved).encode(ExternalEncoding), input_name='Reserved'), namespace_))
        if self.Size_Of_Image is not None:
            showIndent(outfile, level)
            outfile.write('<%sSize_Of_Image>%s</%sSize_Of_Image>\n' % (namespace_, self.format_string(quote_xml(self.Size_Of_Image).encode(ExternalEncoding), input_name='Size_Of_Image'), namespace_))
        if self.Size_Of_Headers is not None:
            showIndent(outfile, level)
            outfile.write('<%sSize_Of_Headers>%s</%sSize_Of_Headers>\n' % (namespace_, self.format_string(quote_xml(self.Size_Of_Headers).encode(ExternalEncoding), input_name='Size_Of_Headers'), namespace_))
        if self.Checksum is not None:
            showIndent(outfile, level)
            outfile.write('<%sChecksum>%s</%sChecksum>\n' % (namespace_, self.format_string(quote_xml(self.Checksum).encode(ExternalEncoding), input_name='Checksum'), namespace_))
        if self.Subsystem is not None:
            showIndent(outfile, level)
            outfile.write('<%sSubsystem>%s</%sSubsystem>\n' % (namespace_, self.format_string(quote_xml(self.Subsystem).encode(ExternalEncoding), input_name='Subsystem'), namespace_))
        if self.DLL_Characteristics is not None:
            showIndent(outfile, level)
            outfile.write('<%sDLL_Characteristics>%s</%sDLL_Characteristics>\n' % (namespace_, self.format_string(quote_xml(self.DLL_Characteristics).encode(ExternalEncoding), input_name='DLL_Characteristics'), namespace_))
        if self.Size_Of_Stack_Reserve is not None:
            showIndent(outfile, level)
            outfile.write('<%sSize_Of_Stack_Reserve>%s</%sSize_Of_Stack_Reserve>\n' % (namespace_, self.format_string(quote_xml(self.Size_Of_Stack_Reserve).encode(ExternalEncoding), input_name='Size_Of_Stack_Reserve'), namespace_))
        if self.Size_Of_Stack_Commit is not None:
            showIndent(outfile, level)
            outfile.write('<%sSize_Of_Stack_Commit>%s</%sSize_Of_Stack_Commit>\n' % (namespace_, self.format_string(quote_xml(self.Size_Of_Stack_Commit).encode(ExternalEncoding), input_name='Size_Of_Stack_Commit'), namespace_))
        if self.Size_Of_Heap_Reserve is not None:
            showIndent(outfile, level)
            outfile.write('<%sSize_Of_Heap_Reserve>%s</%sSize_Of_Heap_Reserve>\n' % (namespace_, self.format_string(quote_xml(self.Size_Of_Heap_Reserve).encode(ExternalEncoding), input_name='Size_Of_Heap_Reserve'), namespace_))
        if self.Size_Of_Heap_Commit is not None:
            showIndent(outfile, level)
            outfile.write('<%sSize_Of_Heap_Commit>%s</%sSize_Of_Heap_Commit>\n' % (namespace_, self.format_string(quote_xml(self.Size_Of_Heap_Commit).encode(ExternalEncoding), input_name='Size_Of_Heap_Commit'), namespace_))
        if self.Loader_Flags is not None:
            showIndent(outfile, level)
            outfile.write('<%sLoader_Flags>%s</%sLoader_Flags>\n' % (namespace_, self.format_string(quote_xml(self.Loader_Flags).encode(ExternalEncoding), input_name='Loader_Flags'), namespace_))
        if self.Number_Of_Rva_And_Sizes is not None:
            showIndent(outfile, level)
            outfile.write('<%sNumber_Of_Rva_And_Sizes>%s</%sNumber_Of_Rva_And_Sizes>\n' % (namespace_, self.format_string(quote_xml(self.Number_Of_Rva_And_Sizes).encode(ExternalEncoding), input_name='Number_Of_Rva_And_Sizes'), namespace_))
        if self.Data_Directory:
            self.Data_Directory.export(outfile, level, namespace_, name_='Data_Directory')
    def hasContent_(self):
        if (
            self.Hashes is not None or
            self.Major_Linker_Version is not None or
            self.Minor_Linker_Version is not None or
            self.Size_Of_Code is not None or
            self.Size_Of_Initialized_Data is not None or
            self.Size_Of_Uninitialized_Data is not None or
            self.Address_Of_Entry_Point is not None or
            self.Base_Of_Code is not None or
            self.Base_Of_Data is not None or
            self.Image_Base is not None or
            self.Section_Alignment is not None or
            self.File_Alignment is not None or
            self.Major_OS_Version is not None or
            self.Minor_OS_Version is not None or
            self.Major_Image_Version is not None or
            self.Minor_Image_Version is not None or
            self.Major_Subsystem_Version is not None or
            self.Minor_Subsystem_Version is not None or
            self.Reserved is not None or
            self.Size_Of_Image is not None or
            self.Size_Of_Headers is not None or
            self.Checksum is not None or
            self.Subsystem is not None or
            self.DLL_Characteristics is not None or
            self.Size_Of_Stack_Reserve is not None or
            self.Size_Of_Stack_Commit is not None or
            self.Size_Of_Heap_Reserve is not None or
            self.Size_Of_Heap_Commit is not None or
            self.Loader_Flags is not None or
            self.Number_Of_Rva_And_Sizes is not None or
            self.Data_Directory is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Optional_Header'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Hashes=model_.Hashes(\n')
            self.Hashes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Major_Linker_Version is not None:
            showIndent(outfile, level)
            outfile.write('Major_Linker_Version=%s,\n' % quote_python(self.Major_Linker_Version).encode(ExternalEncoding))
        if self.Minor_Linker_Version is not None:
            showIndent(outfile, level)
            outfile.write('Minor_Linker_Version=%s,\n' % quote_python(self.Minor_Linker_Version).encode(ExternalEncoding))
        if self.Size_Of_Code is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Code=%s,\n' % quote_python(self.Size_Of_Code).encode(ExternalEncoding))
        if self.Size_Of_Initialized_Data is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Initialized_Data=%s,\n' % quote_python(self.Size_Of_Initialized_Data).encode(ExternalEncoding))
        if self.Size_Of_Uninitialized_Data is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Uninitialized_Data=%s,\n' % quote_python(self.Size_Of_Uninitialized_Data).encode(ExternalEncoding))
        if self.Address_Of_Entry_Point is not None:
            showIndent(outfile, level)
            outfile.write('Address_Of_Entry_Point=%s,\n' % quote_python(self.Address_Of_Entry_Point).encode(ExternalEncoding))
        if self.Base_Of_Code is not None:
            showIndent(outfile, level)
            outfile.write('Base_Of_Code=%s,\n' % quote_python(self.Base_Of_Code).encode(ExternalEncoding))
        if self.Base_Of_Data is not None:
            showIndent(outfile, level)
            outfile.write('Base_Of_Data=%s,\n' % quote_python(self.Base_Of_Data).encode(ExternalEncoding))
        if self.Image_Base is not None:
            showIndent(outfile, level)
            outfile.write('Image_Base=%s,\n' % quote_python(self.Image_Base).encode(ExternalEncoding))
        if self.Section_Alignment is not None:
            showIndent(outfile, level)
            outfile.write('Section_Alignment=%s,\n' % quote_python(self.Section_Alignment).encode(ExternalEncoding))
        if self.File_Alignment is not None:
            showIndent(outfile, level)
            outfile.write('File_Alignment=%s,\n' % quote_python(self.File_Alignment).encode(ExternalEncoding))
        if self.Major_OS_Version is not None:
            showIndent(outfile, level)
            outfile.write('Major_OS_Version=%s,\n' % quote_python(self.Major_OS_Version).encode(ExternalEncoding))
        if self.Minor_OS_Version is not None:
            showIndent(outfile, level)
            outfile.write('Minor_OS_Version=%s,\n' % quote_python(self.Minor_OS_Version).encode(ExternalEncoding))
        if self.Major_Image_Version is not None:
            showIndent(outfile, level)
            outfile.write('Major_Image_Version=%s,\n' % quote_python(self.Major_Image_Version).encode(ExternalEncoding))
        if self.Minor_Image_Version is not None:
            showIndent(outfile, level)
            outfile.write('Minor_Image_Version=%s,\n' % quote_python(self.Minor_Image_Version).encode(ExternalEncoding))
        if self.Major_Subsystem_Version is not None:
            showIndent(outfile, level)
            outfile.write('Major_Subsystem_Version=%s,\n' % quote_python(self.Major_Subsystem_Version).encode(ExternalEncoding))
        if self.Minor_Subsystem_Version is not None:
            showIndent(outfile, level)
            outfile.write('Minor_Subsystem_Version=%s,\n' % quote_python(self.Minor_Subsystem_Version).encode(ExternalEncoding))
        if self.Reserved is not None:
            showIndent(outfile, level)
            outfile.write('Reserved=%s,\n' % quote_python(self.Reserved).encode(ExternalEncoding))
        if self.Size_Of_Image is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Image=%s,\n' % quote_python(self.Size_Of_Image).encode(ExternalEncoding))
        if self.Size_Of_Headers is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Headers=%s,\n' % quote_python(self.Size_Of_Headers).encode(ExternalEncoding))
        if self.Checksum is not None:
            showIndent(outfile, level)
            outfile.write('Checksum=%s,\n' % quote_python(self.Checksum).encode(ExternalEncoding))
        if self.Subsystem is not None:
            showIndent(outfile, level)
            outfile.write('Subsystem=%s,\n' % quote_python(self.Subsystem).encode(ExternalEncoding))
        if self.DLL_Characteristics is not None:
            showIndent(outfile, level)
            outfile.write('DLL_Characteristics=%s,\n' % quote_python(self.DLL_Characteristics).encode(ExternalEncoding))
        if self.Size_Of_Stack_Reserve is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Stack_Reserve=%s,\n' % quote_python(self.Size_Of_Stack_Reserve).encode(ExternalEncoding))
        if self.Size_Of_Stack_Commit is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Stack_Commit=%s,\n' % quote_python(self.Size_Of_Stack_Commit).encode(ExternalEncoding))
        if self.Size_Of_Heap_Reserve is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Heap_Reserve=%s,\n' % quote_python(self.Size_Of_Heap_Reserve).encode(ExternalEncoding))
        if self.Size_Of_Heap_Commit is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Heap_Commit=%s,\n' % quote_python(self.Size_Of_Heap_Commit).encode(ExternalEncoding))
        if self.Loader_Flags is not None:
            showIndent(outfile, level)
            outfile.write('Loader_Flags=%s,\n' % quote_python(self.Loader_Flags).encode(ExternalEncoding))
        if self.Number_Of_Rva_And_Sizes is not None:
            showIndent(outfile, level)
            outfile.write('Number_Of_Rva_And_Sizes=%s,\n' % quote_python(self.Number_Of_Rva_And_Sizes).encode(ExternalEncoding))
        if self.Data_Directory is not None:
            showIndent(outfile, level)
            outfile.write('Data_Directory=model_.Data_Directory(\n')
            self.Data_Directory.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Hashes':
            obj_ = Hashes.factory()
            obj_.build(child_)
            self.set_Hashes(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Major_Linker_Version':
            Major_Linker_Version_ = ''
            for text__content_ in child_.childNodes:
                Major_Linker_Version_ += text__content_.nodeValue
            self.Major_Linker_Version = Major_Linker_Version_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Minor_Linker_Version':
            Minor_Linker_Version_ = ''
            for text__content_ in child_.childNodes:
                Minor_Linker_Version_ += text__content_.nodeValue
            self.Minor_Linker_Version = Minor_Linker_Version_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Size_Of_Code':
            Size_Of_Code_ = ''
            for text__content_ in child_.childNodes:
                Size_Of_Code_ += text__content_.nodeValue
            self.Size_Of_Code = Size_Of_Code_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Size_Of_Initialized_Data':
            Size_Of_Initialized_Data_ = ''
            for text__content_ in child_.childNodes:
                Size_Of_Initialized_Data_ += text__content_.nodeValue
            self.Size_Of_Initialized_Data = Size_Of_Initialized_Data_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Size_Of_Uninitialized_Data':
            Size_Of_Uninitialized_Data_ = ''
            for text__content_ in child_.childNodes:
                Size_Of_Uninitialized_Data_ += text__content_.nodeValue
            self.Size_Of_Uninitialized_Data = Size_Of_Uninitialized_Data_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Address_Of_Entry_Point':
            Address_Of_Entry_Point_ = ''
            for text__content_ in child_.childNodes:
                Address_Of_Entry_Point_ += text__content_.nodeValue
            self.Address_Of_Entry_Point = Address_Of_Entry_Point_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Base_Of_Code':
            Base_Of_Code_ = ''
            for text__content_ in child_.childNodes:
                Base_Of_Code_ += text__content_.nodeValue
            self.Base_Of_Code = Base_Of_Code_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Base_Of_Data':
            Base_Of_Data_ = ''
            for text__content_ in child_.childNodes:
                Base_Of_Data_ += text__content_.nodeValue
            self.Base_Of_Data = Base_Of_Data_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Image_Base':
            Image_Base_ = ''
            for text__content_ in child_.childNodes:
                Image_Base_ += text__content_.nodeValue
            self.Image_Base = Image_Base_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Section_Alignment':
            Section_Alignment_ = ''
            for text__content_ in child_.childNodes:
                Section_Alignment_ += text__content_.nodeValue
            self.Section_Alignment = Section_Alignment_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'File_Alignment':
            File_Alignment_ = ''
            for text__content_ in child_.childNodes:
                File_Alignment_ += text__content_.nodeValue
            self.File_Alignment = File_Alignment_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Major_OS_Version':
            Major_OS_Version_ = ''
            for text__content_ in child_.childNodes:
                Major_OS_Version_ += text__content_.nodeValue
            self.Major_OS_Version = Major_OS_Version_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Minor_OS_Version':
            Minor_OS_Version_ = ''
            for text__content_ in child_.childNodes:
                Minor_OS_Version_ += text__content_.nodeValue
            self.Minor_OS_Version = Minor_OS_Version_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Major_Image_Version':
            Major_Image_Version_ = ''
            for text__content_ in child_.childNodes:
                Major_Image_Version_ += text__content_.nodeValue
            self.Major_Image_Version = Major_Image_Version_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Minor_Image_Version':
            Minor_Image_Version_ = ''
            for text__content_ in child_.childNodes:
                Minor_Image_Version_ += text__content_.nodeValue
            self.Minor_Image_Version = Minor_Image_Version_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Major_Subsystem_Version':
            Major_Subsystem_Version_ = ''
            for text__content_ in child_.childNodes:
                Major_Subsystem_Version_ += text__content_.nodeValue
            self.Major_Subsystem_Version = Major_Subsystem_Version_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Minor_Subsystem_Version':
            Minor_Subsystem_Version_ = ''
            for text__content_ in child_.childNodes:
                Minor_Subsystem_Version_ += text__content_.nodeValue
            self.Minor_Subsystem_Version = Minor_Subsystem_Version_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Reserved':
            Reserved_ = ''
            for text__content_ in child_.childNodes:
                Reserved_ += text__content_.nodeValue
            self.Reserved = Reserved_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Size_Of_Image':
            Size_Of_Image_ = ''
            for text__content_ in child_.childNodes:
                Size_Of_Image_ += text__content_.nodeValue
            self.Size_Of_Image = Size_Of_Image_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Size_Of_Headers':
            Size_Of_Headers_ = ''
            for text__content_ in child_.childNodes:
                Size_Of_Headers_ += text__content_.nodeValue
            self.Size_Of_Headers = Size_Of_Headers_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Checksum':
            Checksum_ = ''
            for text__content_ in child_.childNodes:
                Checksum_ += text__content_.nodeValue
            self.Checksum = Checksum_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Subsystem':
            Subsystem_ = ''
            for text__content_ in child_.childNodes:
                Subsystem_ += text__content_.nodeValue
            self.Subsystem = Subsystem_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'DLL_Characteristics':
            DLL_Characteristics_ = ''
            for text__content_ in child_.childNodes:
                DLL_Characteristics_ += text__content_.nodeValue
            self.DLL_Characteristics = DLL_Characteristics_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Size_Of_Stack_Reserve':
            Size_Of_Stack_Reserve_ = ''
            for text__content_ in child_.childNodes:
                Size_Of_Stack_Reserve_ += text__content_.nodeValue
            self.Size_Of_Stack_Reserve = Size_Of_Stack_Reserve_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Size_Of_Stack_Commit':
            Size_Of_Stack_Commit_ = ''
            for text__content_ in child_.childNodes:
                Size_Of_Stack_Commit_ += text__content_.nodeValue
            self.Size_Of_Stack_Commit = Size_Of_Stack_Commit_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Size_Of_Heap_Reserve':
            Size_Of_Heap_Reserve_ = ''
            for text__content_ in child_.childNodes:
                Size_Of_Heap_Reserve_ += text__content_.nodeValue
            self.Size_Of_Heap_Reserve = Size_Of_Heap_Reserve_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Size_Of_Heap_Commit':
            Size_Of_Heap_Commit_ = ''
            for text__content_ in child_.childNodes:
                Size_Of_Heap_Commit_ += text__content_.nodeValue
            self.Size_Of_Heap_Commit = Size_Of_Heap_Commit_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Loader_Flags':
            Loader_Flags_ = ''
            for text__content_ in child_.childNodes:
                Loader_Flags_ += text__content_.nodeValue
            self.Loader_Flags = Loader_Flags_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Number_Of_Rva_And_Sizes':
            Number_Of_Rva_And_Sizes_ = ''
            for text__content_ in child_.childNodes:
                Number_Of_Rva_And_Sizes_ += text__content_.nodeValue
            self.Number_Of_Rva_And_Sizes = Number_Of_Rva_And_Sizes_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Data_Directory':
            obj_ = Data_Directory.factory()
            obj_.build(child_)
            self.set_Data_Directory(obj_)
# end class Optional_Header


class Data_Directory(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Export_Symbols=None, Import_Symbols=None, Resources=None, Exception=None, Security=None, Base_Relocation=None, Debug=None, Architecture=None, Copyright_String=None, Unknown=None, Thread_Local_Storage=None, Load_Configuration=None, Bound_Import=None, Import_Address_Table=None, Delay_Import=None, COM_Descriptor=None):
        self.Export_Symbols = Export_Symbols
        self.Import_Symbols = Import_Symbols
        self.Resources = Resources
        self.Exception = Exception
        self.Security = Security
        self.Base_Relocation = Base_Relocation
        self.Debug = Debug
        self.Architecture = Architecture
        self.Copyright_String = Copyright_String
        self.Unknown = Unknown
        self.Thread_Local_Storage = Thread_Local_Storage
        self.Load_Configuration = Load_Configuration
        self.Bound_Import = Bound_Import
        self.Import_Address_Table = Import_Address_Table
        self.Delay_Import = Delay_Import
        self.COM_Descriptor = COM_Descriptor
    def factory(*args_, **kwargs_):
        if Data_Directory.subclass:
            return Data_Directory.subclass(*args_, **kwargs_)
        else:
            return Data_Directory(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Export_Symbols(self): return self.Export_Symbols
    def set_Export_Symbols(self, Export_Symbols): self.Export_Symbols = Export_Symbols
    def get_Import_Symbols(self): return self.Import_Symbols
    def set_Import_Symbols(self, Import_Symbols): self.Import_Symbols = Import_Symbols
    def get_Resources(self): return self.Resources
    def set_Resources(self, Resources): self.Resources = Resources
    def get_Exception(self): return self.Exception
    def set_Exception(self, Exception): self.Exception = Exception
    def get_Security(self): return self.Security
    def set_Security(self, Security): self.Security = Security
    def get_Base_Relocation(self): return self.Base_Relocation
    def set_Base_Relocation(self, Base_Relocation): self.Base_Relocation = Base_Relocation
    def get_Debug(self): return self.Debug
    def set_Debug(self, Debug): self.Debug = Debug
    def get_Architecture(self): return self.Architecture
    def set_Architecture(self, Architecture): self.Architecture = Architecture
    def get_Copyright_String(self): return self.Copyright_String
    def set_Copyright_String(self, Copyright_String): self.Copyright_String = Copyright_String
    def get_Unknown(self): return self.Unknown
    def set_Unknown(self, Unknown): self.Unknown = Unknown
    def get_Thread_Local_Storage(self): return self.Thread_Local_Storage
    def set_Thread_Local_Storage(self, Thread_Local_Storage): self.Thread_Local_Storage = Thread_Local_Storage
    def get_Load_Configuration(self): return self.Load_Configuration
    def set_Load_Configuration(self, Load_Configuration): self.Load_Configuration = Load_Configuration
    def get_Bound_Import(self): return self.Bound_Import
    def set_Bound_Import(self, Bound_Import): self.Bound_Import = Bound_Import
    def get_Import_Address_Table(self): return self.Import_Address_Table
    def set_Import_Address_Table(self, Import_Address_Table): self.Import_Address_Table = Import_Address_Table
    def get_Delay_Import(self): return self.Delay_Import
    def set_Delay_Import(self, Delay_Import): self.Delay_Import = Delay_Import
    def get_COM_Descriptor(self): return self.COM_Descriptor
    def set_COM_Descriptor(self, COM_Descriptor): self.COM_Descriptor = COM_Descriptor
    def export(self, outfile, level, namespace_='maec:', name_='Data_Directory', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Data_Directory')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Data_Directory'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Data_Directory'):
        if self.Export_Symbols:
            self.Export_Symbols.export(outfile, level, namespace_, name_='Export_Symbols')
        if self.Import_Symbols:
            self.Import_Symbols.export(outfile, level, namespace_, name_='Import_Symbols')
        if self.Resources:
            self.Resources.export(outfile, level, namespace_, name_='Resources')
        if self.Exception:
            self.Exception.export(outfile, level, namespace_, name_='Exception')
        if self.Security:
            self.Security.export(outfile, level, namespace_, name_='Security')
        if self.Base_Relocation:
            self.Base_Relocation.export(outfile, level, namespace_, name_='Base_Relocation')
        if self.Debug:
            self.Debug.export(outfile, level, namespace_, name_='Debug')
        if self.Architecture:
            self.Architecture.export(outfile, level, namespace_, name_='Architecture')
        if self.Copyright_String:
            self.Copyright_String.export(outfile, level, namespace_, name_='Copyright_String')
        if self.Unknown:
            self.Unknown.export(outfile, level, namespace_, name_='Unknown')
        if self.Thread_Local_Storage:
            self.Thread_Local_Storage.export(outfile, level, namespace_, name_='Thread_Local_Storage')
        if self.Load_Configuration:
            self.Load_Configuration.export(outfile, level, namespace_, name_='Load_Configuration')
        if self.Bound_Import:
            self.Bound_Import.export(outfile, level, namespace_, name_='Bound_Import')
        if self.Import_Address_Table:
            self.Import_Address_Table.export(outfile, level, namespace_, name_='Import_Address_Table')
        if self.Delay_Import:
            self.Delay_Import.export(outfile, level, namespace_, name_='Delay_Import')
        if self.COM_Descriptor:
            self.COM_Descriptor.export(outfile, level, namespace_, name_='COM_Descriptor')
    def hasContent_(self):
        if (
            self.Export_Symbols is not None or
            self.Import_Symbols is not None or
            self.Resources is not None or
            self.Exception is not None or
            self.Security is not None or
            self.Base_Relocation is not None or
            self.Debug is not None or
            self.Architecture is not None or
            self.Copyright_String is not None or
            self.Unknown is not None or
            self.Thread_Local_Storage is not None or
            self.Load_Configuration is not None or
            self.Bound_Import is not None or
            self.Import_Address_Table is not None or
            self.Delay_Import is not None or
            self.COM_Descriptor is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Data_Directory'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Export_Symbols is not None:
            showIndent(outfile, level)
            outfile.write('Export_Symbols=model_.PEDataDirectoryStruct(\n')
            self.Export_Symbols.exportLiteral(outfile, level, name_='Export_Symbols')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Import_Symbols is not None:
            showIndent(outfile, level)
            outfile.write('Import_Symbols=model_.PEDataDirectoryStruct(\n')
            self.Import_Symbols.exportLiteral(outfile, level, name_='Import_Symbols')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Resources is not None:
            showIndent(outfile, level)
            outfile.write('Resources=model_.PEDataDirectoryStruct(\n')
            self.Resources.exportLiteral(outfile, level, name_='Resources')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Exception is not None:
            showIndent(outfile, level)
            outfile.write('Exception=model_.PEDataDirectoryStruct(\n')
            self.Exception.exportLiteral(outfile, level, name_='Exception')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Security is not None:
            showIndent(outfile, level)
            outfile.write('Security=model_.PEDataDirectoryStruct(\n')
            self.Security.exportLiteral(outfile, level, name_='Security')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Base_Relocation is not None:
            showIndent(outfile, level)
            outfile.write('Base_Relocation=model_.PEDataDirectoryStruct(\n')
            self.Base_Relocation.exportLiteral(outfile, level, name_='Base_Relocation')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Debug is not None:
            showIndent(outfile, level)
            outfile.write('Debug=model_.PEDataDirectoryStruct(\n')
            self.Debug.exportLiteral(outfile, level, name_='Debug')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Architecture is not None:
            showIndent(outfile, level)
            outfile.write('Architecture=model_.PEDataDirectoryStruct(\n')
            self.Architecture.exportLiteral(outfile, level, name_='Architecture')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Copyright_String is not None:
            showIndent(outfile, level)
            outfile.write('Copyright_String=model_.PEDataDirectoryStruct(\n')
            self.Copyright_String.exportLiteral(outfile, level, name_='Copyright_String')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Unknown is not None:
            showIndent(outfile, level)
            outfile.write('Unknown=model_.PEDataDirectoryStruct(\n')
            self.Unknown.exportLiteral(outfile, level, name_='Unknown')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Thread_Local_Storage is not None:
            showIndent(outfile, level)
            outfile.write('Thread_Local_Storage=model_.PEDataDirectoryStruct(\n')
            self.Thread_Local_Storage.exportLiteral(outfile, level, name_='Thread_Local_Storage')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Load_Configuration is not None:
            showIndent(outfile, level)
            outfile.write('Load_Configuration=model_.PEDataDirectoryStruct(\n')
            self.Load_Configuration.exportLiteral(outfile, level, name_='Load_Configuration')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Bound_Import is not None:
            showIndent(outfile, level)
            outfile.write('Bound_Import=model_.PEDataDirectoryStruct(\n')
            self.Bound_Import.exportLiteral(outfile, level, name_='Bound_Import')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Import_Address_Table is not None:
            showIndent(outfile, level)
            outfile.write('Import_Address_Table=model_.PEDataDirectoryStruct(\n')
            self.Import_Address_Table.exportLiteral(outfile, level, name_='Import_Address_Table')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Delay_Import is not None:
            showIndent(outfile, level)
            outfile.write('Delay_Import=model_.PEDataDirectoryStruct(\n')
            self.Delay_Import.exportLiteral(outfile, level, name_='Delay_Import')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.COM_Descriptor is not None:
            showIndent(outfile, level)
            outfile.write('COM_Descriptor=model_.PEDataDirectoryStruct(\n')
            self.COM_Descriptor.exportLiteral(outfile, level, name_='COM_Descriptor')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Export_Symbols':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Export_Symbols(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Import_Symbols':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Import_Symbols(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Resources':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Resources(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Exception':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Exception(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Security':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Security(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Base_Relocation':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Base_Relocation(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Debug':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Debug(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Architecture':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Architecture(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Copyright_String':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Copyright_String(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Unknown':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Unknown(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Thread_Local_Storage':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Thread_Local_Storage(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Load_Configuration':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Load_Configuration(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Bound_Import':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Bound_Import(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Import_Address_Table':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Import_Address_Table(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Delay_Import':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_Delay_Import(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'COM_Descriptor':
            obj_ = PEDataDirectoryStruct.factory()
            obj_.build(child_)
            self.set_COM_Descriptor(obj_)
# end class Data_Directory


class Section_Table(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Section_Header=None):
        if Section_Header is None:
            self.Section_Header = []
        else:
            self.Section_Header = Section_Header
    def factory(*args_, **kwargs_):
        if Section_Table.subclass:
            return Section_Table.subclass(*args_, **kwargs_)
        else:
            return Section_Table(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Section_Header(self): return self.Section_Header
    def set_Section_Header(self, Section_Header): self.Section_Header = Section_Header
    def add_Section_Header(self, value): self.Section_Header.append(value)
    def insert_Section_Header(self, index, value): self.Section_Header[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Section_Table', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Section_Table')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Section_Table'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Section_Table'):
        for Section_Header_ in self.Section_Header:
            Section_Header_.export(outfile, level, namespace_, name_='Section_Header')
    def hasContent_(self):
        if (
            self.Section_Header
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Section_Table'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Section_Header=[\n')
        level += 1
        for Section_Header_ in self.Section_Header:
            showIndent(outfile, level)
            outfile.write('model_.PESectionHeaderStruct(\n')
            Section_Header_.exportLiteral(outfile, level, name_='PESectionHeaderStruct')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Section_Header':
            obj_ = PESectionHeaderStruct.factory()
            obj_.build(child_)
            self.Section_Header.append(obj_)
# end class Section_Table


class Strings(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, String=None):
        if String is None:
            self.String = []
        else:
            self.String = String
    def factory(*args_, **kwargs_):
        if Strings.subclass:
            return Strings.subclass(*args_, **kwargs_)
        else:
            return Strings(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_String(self): return self.String
    def set_String(self, String): self.String = String
    def add_String(self, value): self.String.append(value)
    def insert_String(self, index, value): self.String[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Strings', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Strings')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Strings'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Strings'):
        for String_ in self.String:
            String_.export(outfile, level, namespace_, name_='String')
    def hasContent_(self):
        if (
            self.String
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Strings'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('String=[\n')
        level += 1
        for String_ in self.String:
            showIndent(outfile, level)
            outfile.write('model_.PEStringType(\n')
            String_.exportLiteral(outfile, level, name_='PEStringType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'String':
            obj_ = PEStringType.factory()
            obj_.build(child_)
            self.String.append(obj_)
# end class Strings


class Imports(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Import=None):
        if Import is None:
            self.Import = []
        else:
            self.Import = Import
    def factory(*args_, **kwargs_):
        if Imports.subclass:
            return Imports.subclass(*args_, **kwargs_)
        else:
            return Imports(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Import(self): return self.Import
    def set_Import(self, Import): self.Import = Import
    def add_Import(self, value): self.Import.append(value)
    def insert_Import(self, index, value): self.Import[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Imports', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Imports')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Imports'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Imports'):
        for Import_ in self.Import:
            Import_.export(outfile, level, namespace_, name_='Import')
    def hasContent_(self):
        if (
            self.Import
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Imports'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Import=[\n')
        level += 1
        for Import_ in self.Import:
            showIndent(outfile, level)
            outfile.write('model_.PEImportType(\n')
            Import_.exportLiteral(outfile, level, name_='PEImportType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Import':
            obj_ = PEImportType.factory()
            obj_.build(child_)
            self.Import.append(obj_)
# end class Imports


class Exports(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Export=None):
        if Export is None:
            self.Export = []
        else:
            self.Export = Export
    def factory(*args_, **kwargs_):
        if Exports.subclass:
            return Exports.subclass(*args_, **kwargs_)
        else:
            return Exports(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Export(self): return self.Export
    def set_Export(self, Export): self.Export = Export
    def add_Export(self, value): self.Export.append(value)
    def insert_Export(self, index, value): self.Export[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Exports', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Exports')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Exports'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Exports'):
        for Export_ in self.Export:
            Export_.export(outfile, level, namespace_, name_='Export')
    def hasContent_(self):
        if (
            self.Export
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Exports'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Export=[\n')
        level += 1
        for Export_ in self.Export:
            showIndent(outfile, level)
            outfile.write('model_.PEExportType(\n')
            Export_.exportLiteral(outfile, level, name_='PEExportType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Export':
            obj_ = PEExportType.factory()
            obj_.build(child_)
            self.Export.append(obj_)
# end class Exports


class Resources(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Resource=None):
        if Resource is None:
            self.Resource = []
        else:
            self.Resource = Resource
    def factory(*args_, **kwargs_):
        if Resources.subclass:
            return Resources.subclass(*args_, **kwargs_)
        else:
            return Resources(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Resource(self): return self.Resource
    def set_Resource(self, Resource): self.Resource = Resource
    def add_Resource(self, value): self.Resource.append(value)
    def insert_Resource(self, index, value): self.Resource[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Resources', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Resources')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Resources'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Resources'):
        for Resource_ in self.Resource:
            Resource_.export(outfile, level, namespace_, name_='Resource')
    def hasContent_(self):
        if (
            self.Resource
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Resources'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Resource=[\n')
        level += 1
        for Resource_ in self.Resource:
            showIndent(outfile, level)
            outfile.write('model_.PEResourceType(\n')
            Resource_.exportLiteral(outfile, level, name_='PEResourceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Resource':
            obj_ = PEResourceType.factory()
            obj_.build(child_)
            self.Resource.append(obj_)
# end class Resources


class Sections(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Section=None):
        if Section is None:
            self.Section = []
        else:
            self.Section = Section
    def factory(*args_, **kwargs_):
        if Sections.subclass:
            return Sections.subclass(*args_, **kwargs_)
        else:
            return Sections(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Section(self): return self.Section
    def set_Section(self, Section): self.Section = Section
    def add_Section(self, value): self.Section.append(value)
    def insert_Section(self, index, value): self.Section[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Sections', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Sections')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Sections'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Sections'):
        for Section_ in self.Section:
            Section_.export(outfile, level, namespace_, name_='Section')
    def hasContent_(self):
        if (
            self.Section
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Sections'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Section=[\n')
        level += 1
        for Section_ in self.Section:
            showIndent(outfile, level)
            outfile.write('model_.PESectionType(\n')
            Section_.exportLiteral(outfile, level, name_='PESectionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Section':
            obj_ = PESectionType.factory()
            obj_.build(child_)
            self.Section.append(obj_)
# end class Sections


class Digital_Certificates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Certificate=None):
        if Certificate is None:
            self.Certificate = []
        else:
            self.Certificate = Certificate
    def factory(*args_, **kwargs_):
        if Digital_Certificates.subclass:
            return Digital_Certificates.subclass(*args_, **kwargs_)
        else:
            return Digital_Certificates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Certificate(self): return self.Certificate
    def set_Certificate(self, Certificate): self.Certificate = Certificate
    def add_Certificate(self, value): self.Certificate.append(value)
    def insert_Certificate(self, index, value): self.Certificate[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Digital_Certificates', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Digital_Certificates')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Digital_Certificates'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Digital_Certificates'):
        for Certificate_ in self.Certificate:
            Certificate_.export(outfile, level, namespace_, name_='Certificate')
    def hasContent_(self):
        if (
            self.Certificate
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Digital_Certificates'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Certificate=[\n')
        level += 1
        for Certificate_ in self.Certificate:
            showIndent(outfile, level)
            outfile.write('model_.Certificate(\n')
            Certificate_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Certificate':
            obj_ = Certificate.factory()
            obj_.build(child_)
            self.Certificate.append(obj_)
# end class Digital_Certificates


class Certificate(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, validity=None, Issuer=None):
        self.validity = _cast(bool, validity)
        self.Issuer = Issuer
    def factory(*args_, **kwargs_):
        if Certificate.subclass:
            return Certificate.subclass(*args_, **kwargs_)
        else:
            return Certificate(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Issuer(self): return self.Issuer
    def set_Issuer(self, Issuer): self.Issuer = Issuer
    def get_validity(self): return self.validity
    def set_validity(self, validity): self.validity = validity
    def export(self, outfile, level, namespace_='maec:', name_='Certificate', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Certificate')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Certificate'):
        if self.validity is not None:
            outfile.write(' validity="%s"' % self.format_boolean(str_lower(str(self.validity)), input_name='validity'))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Certificate'):
        if self.Issuer is not None:
            showIndent(outfile, level)
            outfile.write('<%sIssuer>%s</%sIssuer>\n' % (namespace_, self.format_string(quote_xml(self.Issuer).encode(ExternalEncoding), input_name='Issuer'), namespace_))
    def hasContent_(self):
        if (
            self.Issuer is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Certificate'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.validity is not None:
            showIndent(outfile, level)
            outfile.write('validity = %s,\n' % (self.validity,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Issuer is not None:
            showIndent(outfile, level)
            outfile.write('Issuer=%s,\n' % quote_python(self.Issuer).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('validity'):
            if attrs.get('validity').value in ('true', '1'):
                self.validity = True
            elif attrs.get('validity').value in ('false', '0'):
                self.validity = False
            else:
                raise ValueError('Bad boolean attribute (validity)')
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Issuer':
            Issuer_ = ''
            for text__content_ in child_.childNodes:
                Issuer_ += text__content_.nodeValue
            self.Issuer = Issuer_
# end class Certificate


class GUI_Object_Attributes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Width=None, Height=None, Window_Display_Name=None, Parent_Window=None, Owner_Window=None, Box_Text=None, Box_Caption=None):
        self.Width = Width
        self.Height = Height
        self.Window_Display_Name = Window_Display_Name
        self.Parent_Window = Parent_Window
        self.Owner_Window = Owner_Window
        self.Box_Text = Box_Text
        self.Box_Caption = Box_Caption
    def factory(*args_, **kwargs_):
        if GUI_Object_Attributes.subclass:
            return GUI_Object_Attributes.subclass(*args_, **kwargs_)
        else:
            return GUI_Object_Attributes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Width(self): return self.Width
    def set_Width(self, Width): self.Width = Width
    def get_Height(self): return self.Height
    def set_Height(self, Height): self.Height = Height
    def get_Window_Display_Name(self): return self.Window_Display_Name
    def set_Window_Display_Name(self, Window_Display_Name): self.Window_Display_Name = Window_Display_Name
    def get_Parent_Window(self): return self.Parent_Window
    def set_Parent_Window(self, Parent_Window): self.Parent_Window = Parent_Window
    def get_Owner_Window(self): return self.Owner_Window
    def set_Owner_Window(self, Owner_Window): self.Owner_Window = Owner_Window
    def get_Box_Text(self): return self.Box_Text
    def set_Box_Text(self, Box_Text): self.Box_Text = Box_Text
    def get_Box_Caption(self): return self.Box_Caption
    def set_Box_Caption(self, Box_Caption): self.Box_Caption = Box_Caption
    def export(self, outfile, level, namespace_='maec:', name_='GUI_Object_Attributes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='GUI_Object_Attributes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='GUI_Object_Attributes'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='GUI_Object_Attributes'):
        if self.Width is not None:
            showIndent(outfile, level)
            outfile.write('<%sWidth>%s</%sWidth>\n' % (namespace_, self.format_integer(self.Width, input_name='Width'), namespace_))
        if self.Height is not None:
            showIndent(outfile, level)
            outfile.write('<%sHeight>%s</%sHeight>\n' % (namespace_, self.format_integer(self.Height, input_name='Height'), namespace_))
        if self.Window_Display_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sWindow_Display_Name>%s</%sWindow_Display_Name>\n' % (namespace_, self.format_string(quote_xml(self.Window_Display_Name).encode(ExternalEncoding), input_name='Window_Display_Name'), namespace_))
        if self.Parent_Window is not None:
            showIndent(outfile, level)
            outfile.write('<%sParent_Window>%s</%sParent_Window>\n' % (namespace_, self.format_string(quote_xml(self.Parent_Window).encode(ExternalEncoding), input_name='Parent_Window'), namespace_))
        if self.Owner_Window is not None:
            showIndent(outfile, level)
            outfile.write('<%sOwner_Window>%s</%sOwner_Window>\n' % (namespace_, self.format_string(quote_xml(self.Owner_Window).encode(ExternalEncoding), input_name='Owner_Window'), namespace_))
        if self.Box_Text is not None:
            showIndent(outfile, level)
            outfile.write('<%sBox_Text>%s</%sBox_Text>\n' % (namespace_, self.format_string(quote_xml(self.Box_Text).encode(ExternalEncoding), input_name='Box_Text'), namespace_))
        if self.Box_Caption is not None:
            showIndent(outfile, level)
            outfile.write('<%sBox_Caption>%s</%sBox_Caption>\n' % (namespace_, self.format_string(quote_xml(self.Box_Caption).encode(ExternalEncoding), input_name='Box_Caption'), namespace_))
    def hasContent_(self):
        if (
            self.Width is not None or
            self.Height is not None or
            self.Window_Display_Name is not None or
            self.Parent_Window is not None or
            self.Owner_Window is not None or
            self.Box_Text is not None or
            self.Box_Caption is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='GUI_Object_Attributes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Width is not None:
            showIndent(outfile, level)
            outfile.write('Width=%d,\n' % self.Width)
        if self.Height is not None:
            showIndent(outfile, level)
            outfile.write('Height=%d,\n' % self.Height)
        if self.Window_Display_Name is not None:
            showIndent(outfile, level)
            outfile.write('Window_Display_Name=%s,\n' % quote_python(self.Window_Display_Name).encode(ExternalEncoding))
        if self.Parent_Window is not None:
            showIndent(outfile, level)
            outfile.write('Parent_Window=%s,\n' % quote_python(self.Parent_Window).encode(ExternalEncoding))
        if self.Owner_Window is not None:
            showIndent(outfile, level)
            outfile.write('Owner_Window=%s,\n' % quote_python(self.Owner_Window).encode(ExternalEncoding))
        if self.Box_Text is not None:
            showIndent(outfile, level)
            outfile.write('Box_Text=%s,\n' % quote_python(self.Box_Text).encode(ExternalEncoding))
        if self.Box_Caption is not None:
            showIndent(outfile, level)
            outfile.write('Box_Caption=%s,\n' % quote_python(self.Box_Caption).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Width':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError as exp:
                    raise ValueError('requires integer (Width): %s' % exp)
                self.Width = ival_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Height':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError as exp:
                    raise ValueError('requires integer (Height): %s' % exp)
                self.Height = ival_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Window_Display_Name':
            Window_Display_Name_ = ''
            for text__content_ in child_.childNodes:
                Window_Display_Name_ += text__content_.nodeValue
            self.Window_Display_Name = Window_Display_Name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Parent_Window':
            Parent_Window_ = ''
            for text__content_ in child_.childNodes:
                Parent_Window_ += text__content_.nodeValue
            self.Parent_Window = Parent_Window_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Owner_Window':
            Owner_Window_ = ''
            for text__content_ in child_.childNodes:
                Owner_Window_ += text__content_.nodeValue
            self.Owner_Window = Owner_Window_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Box_Text':
            Box_Text_ = ''
            for text__content_ in child_.childNodes:
                Box_Text_ += text__content_.nodeValue
            self.Box_Text = Box_Text_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Box_Caption':
            Box_Caption_ = ''
            for text__content_ in child_.childNodes:
                Box_Caption_ += text__content_.nodeValue
            self.Box_Caption = Box_Caption_
# end class GUI_Object_Attributes


class IPC_Object_Attributes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Security_Attributes=None, Event_Type=None, Thread_ID=None, Start_Address=None):
        self.Security_Attributes = Security_Attributes
        self.Event_Type = Event_Type
        self.Thread_ID = Thread_ID
        self.Start_Address = Start_Address
    def factory(*args_, **kwargs_):
        if IPC_Object_Attributes.subclass:
            return IPC_Object_Attributes.subclass(*args_, **kwargs_)
        else:
            return IPC_Object_Attributes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Security_Attributes(self): return self.Security_Attributes
    def set_Security_Attributes(self, Security_Attributes): self.Security_Attributes = Security_Attributes
    def get_Event_Type(self): return self.Event_Type
    def set_Event_Type(self, Event_Type): self.Event_Type = Event_Type
    def validate_Event_Type(self, value):
        # Validate type Event_Type, a restriction on xs:string.
        pass
    def get_Thread_ID(self): return self.Thread_ID
    def set_Thread_ID(self, Thread_ID): self.Thread_ID = Thread_ID
    def get_Start_Address(self): return self.Start_Address
    def set_Start_Address(self, Start_Address): self.Start_Address = Start_Address
    def export(self, outfile, level, namespace_='maec:', name_='IPC_Object_Attributes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='IPC_Object_Attributes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='IPC_Object_Attributes'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='IPC_Object_Attributes'):
        if self.Security_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('<%sSecurity_Attributes>%s</%sSecurity_Attributes>\n' % (namespace_, self.format_string(quote_xml(self.Security_Attributes).encode(ExternalEncoding), input_name='Security_Attributes'), namespace_))
        if self.Event_Type is not None:
            showIndent(outfile, level)
            outfile.write('<%sEvent_Type>%s</%sEvent_Type>\n' % (namespace_, self.format_string(quote_xml(self.Event_Type).encode(ExternalEncoding), input_name='Event_Type'), namespace_))
        if self.Thread_ID is not None:
            showIndent(outfile, level)
            outfile.write('<%sThread_ID>%s</%sThread_ID>\n' % (namespace_, self.format_integer(self.Thread_ID, input_name='Thread_ID'), namespace_))
        if self.Start_Address is not None:
            showIndent(outfile, level)
            outfile.write('<%sStart_Address>%s</%sStart_Address>\n' % (namespace_, self.format_string(quote_xml(self.Start_Address).encode(ExternalEncoding), input_name='Start_Address'), namespace_))
    def hasContent_(self):
        if (
            self.Security_Attributes is not None or
            self.Event_Type is not None or
            self.Thread_ID is not None or
            self.Start_Address is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='IPC_Object_Attributes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Security_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Security_Attributes=%s,\n' % quote_python(self.Security_Attributes).encode(ExternalEncoding))
        if self.Event_Type is not None:
            showIndent(outfile, level)
            outfile.write('Event_Type=%s,\n' % quote_python(self.Event_Type).encode(ExternalEncoding))
        if self.Thread_ID is not None:
            showIndent(outfile, level)
            outfile.write('Thread_ID=%d,\n' % self.Thread_ID)
        if self.Start_Address is not None:
            showIndent(outfile, level)
            outfile.write('Start_Address=%s,\n' % quote_python(self.Start_Address).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Security_Attributes':
            Security_Attributes_ = ''
            for text__content_ in child_.childNodes:
                Security_Attributes_ += text__content_.nodeValue
            self.Security_Attributes = Security_Attributes_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Event_Type':
            Event_Type_ = ''
            for text__content_ in child_.childNodes:
                Event_Type_ += text__content_.nodeValue
            self.Event_Type = Event_Type_
            self.validate_Event_Type(self.Event_Type)    # validate type Event_Type
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Thread_ID':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError as exp:
                    raise ValueError('requires integer (Thread_ID): %s' % exp)
                self.Thread_ID = ival_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Start_Address':
            Start_Address_ = ''
            for text__content_ in child_.childNodes:
                Start_Address_ += text__content_.nodeValue
            self.Start_Address = Start_Address_
# end class IPC_Object_Attributes


class Event_Type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=''):
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Event_Type.subclass:
            return Event_Type.subclass(*args_, **kwargs_)
        else:
            return Event_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='maec:', name_='Event_Type', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Event_Type')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Event_Type'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Event_Type'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value)
        else:
            outfile.write(quote_xml('%s' % self.valueOf_))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Event_Type'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class Event_Type


class Internet_Object_Attributes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, URI=None, AS_Number=None):
        self.URI = URI
        self.AS_Number = AS_Number
    def factory(*args_, **kwargs_):
        if Internet_Object_Attributes.subclass:
            return Internet_Object_Attributes.subclass(*args_, **kwargs_)
        else:
            return Internet_Object_Attributes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_URI(self): return self.URI
    def set_URI(self, URI): self.URI = URI
    def get_AS_Number(self): return self.AS_Number
    def set_AS_Number(self, AS_Number): self.AS_Number = AS_Number
    def export(self, outfile, level, namespace_='maec:', name_='Internet_Object_Attributes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Internet_Object_Attributes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Internet_Object_Attributes'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Internet_Object_Attributes'):
        if self.URI is not None:
            showIndent(outfile, level)
            outfile.write('<%sURI>%s</%sURI>\n' % (namespace_, self.format_string(quote_xml(self.URI).encode(ExternalEncoding), input_name='URI'), namespace_))
        if self.AS_Number is not None:
            showIndent(outfile, level)
            outfile.write('<%sAS_Number>%s</%sAS_Number>\n' % (namespace_, self.format_integer(self.AS_Number, input_name='AS_Number'), namespace_))
    def hasContent_(self):
        if (
            self.URI is not None or
            self.AS_Number is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Internet_Object_Attributes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.URI is not None:
            showIndent(outfile, level)
            outfile.write('URI=%s,\n' % quote_python(self.URI).encode(ExternalEncoding))
        if self.AS_Number is not None:
            showIndent(outfile, level)
            outfile.write('AS_Number=%d,\n' % self.AS_Number)
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'URI':
            URI_ = ''
            for text__content_ in child_.childNodes:
                URI_ += text__content_.nodeValue
            self.URI = URI_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'AS_Number':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError as exp:
                    raise ValueError('requires integer (AS_Number): %s' % exp)
                self.AS_Number = ival_
# end class Internet_Object_Attributes


class Module_Object_Attributes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Library_Type=None, Library_File_Name=None, Version=None):
        self.Library_Type = Library_Type
        self.Library_File_Name = Library_File_Name
        self.Version = Version
    def factory(*args_, **kwargs_):
        if Module_Object_Attributes.subclass:
            return Module_Object_Attributes.subclass(*args_, **kwargs_)
        else:
            return Module_Object_Attributes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Library_Type(self): return self.Library_Type
    def set_Library_Type(self, Library_Type): self.Library_Type = Library_Type
    def validate_Library_Type(self, value):
        # Validate type Library_Type, a restriction on xs:string.
        pass
    def get_Library_File_Name(self): return self.Library_File_Name
    def set_Library_File_Name(self, Library_File_Name): self.Library_File_Name = Library_File_Name
    def get_Version(self): return self.Version
    def set_Version(self, Version): self.Version = Version
    def export(self, outfile, level, namespace_='maec:', name_='Module_Object_Attributes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Module_Object_Attributes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Module_Object_Attributes'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Module_Object_Attributes'):
        if self.Library_Type is not None:
            showIndent(outfile, level)
            outfile.write('<%sLibrary_Type>%s</%sLibrary_Type>\n' % (namespace_, self.format_string(quote_xml(self.Library_Type).encode(ExternalEncoding), input_name='Library_Type'), namespace_))
        if self.Library_File_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sLibrary_File_Name>%s</%sLibrary_File_Name>\n' % (namespace_, self.format_string(quote_xml(self.Library_File_Name).encode(ExternalEncoding), input_name='Library_File_Name'), namespace_))
        if self.Version is not None:
            showIndent(outfile, level)
            outfile.write('<%sVersion>%s</%sVersion>\n' % (namespace_, self.format_string(quote_xml(self.Version).encode(ExternalEncoding), input_name='Version'), namespace_))
    def hasContent_(self):
        if (
            self.Library_Type is not None or
            self.Library_File_Name is not None or
            self.Version is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Module_Object_Attributes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Library_Type is not None:
            showIndent(outfile, level)
            outfile.write('Library_Type=%s,\n' % quote_python(self.Library_Type).encode(ExternalEncoding))
        if self.Library_File_Name is not None:
            showIndent(outfile, level)
            outfile.write('Library_File_Name=%s,\n' % quote_python(self.Library_File_Name).encode(ExternalEncoding))
        if self.Version is not None:
            showIndent(outfile, level)
            outfile.write('Version=%s,\n' % quote_python(self.Version).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Library_Type':
            Library_Type_ = ''
            for text__content_ in child_.childNodes:
                Library_Type_ += text__content_.nodeValue
            self.Library_Type = Library_Type_
            self.validate_Library_Type(self.Library_Type)    # validate type Library_Type
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Library_File_Name':
            Library_File_Name_ = ''
            for text__content_ in child_.childNodes:
                Library_File_Name_ += text__content_.nodeValue
            self.Library_File_Name = Library_File_Name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Version':
            Version_ = ''
            for text__content_ in child_.childNodes:
                Version_ += text__content_.nodeValue
            self.Version = Version_
# end class Module_Object_Attributes


class Library_Type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=''):
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Library_Type.subclass:
            return Library_Type.subclass(*args_, **kwargs_)
        else:
            return Library_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='maec:', name_='Library_Type', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Library_Type')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Library_Type'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Library_Type'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value)
        else:
            outfile.write(quote_xml('%s' % self.valueOf_))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Library_Type'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class Library_Type


class Registry_Object_Attributes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Hive=None, Key=None, Value=None):
        self.Hive = Hive
        self.Key = Key
        self.Value = Value
    def factory(*args_, **kwargs_):
        if Registry_Object_Attributes.subclass:
            return Registry_Object_Attributes.subclass(*args_, **kwargs_)
        else:
            return Registry_Object_Attributes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hive(self): return self.Hive
    def set_Hive(self, Hive): self.Hive = Hive
    def get_Key(self): return self.Key
    def set_Key(self, Key): self.Key = Key
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def export(self, outfile, level, namespace_='maec:', name_='Registry_Object_Attributes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Registry_Object_Attributes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Registry_Object_Attributes'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Registry_Object_Attributes'):
        if self.Hive is not None:
            showIndent(outfile, level)
            outfile.write('<%sHive>%s</%sHive>\n' % (namespace_, self.format_string(quote_xml(self.Hive).encode(ExternalEncoding), input_name='Hive'), namespace_))
        if self.Key is not None:
            showIndent(outfile, level)
            outfile.write('<%sKey>%s</%sKey>\n' % (namespace_, self.format_string(quote_xml(self.Key).encode(ExternalEncoding), input_name='Key'), namespace_))
        if self.Value:
            self.Value.export(outfile, level, namespace_, name_='Value')
    def hasContent_(self):
        if (
            self.Hive is not None or
            self.Key is not None or
            self.Value is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Registry_Object_Attributes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Hive is not None:
            showIndent(outfile, level)
            outfile.write('Hive=%s,\n' % quote_python(self.Hive).encode(ExternalEncoding))
        if self.Key is not None:
            showIndent(outfile, level)
            outfile.write('Key=%s,\n' % quote_python(self.Key).encode(ExternalEncoding))
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=model_.Value(\n')
            self.Value.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Hive':
            Hive_ = ''
            for text__content_ in child_.childNodes:
                Hive_ += text__content_.nodeValue
            self.Hive = Hive_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Key':
            Key_ = ''
            for text__content_ in child_.childNodes:
                Key_ += text__content_.nodeValue
            self.Key = Key_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Value':
            obj_ = Value.factory()
            obj_.build(child_)
            self.set_Value(obj_)
# end class Registry_Object_Attributes


class Value(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, Value_Name=None, Value_Data=None):
        self.type_ = _cast(None, type_)
        self.Value_Name = Value_Name
        self.Value_Data = Value_Data
    def factory(*args_, **kwargs_):
        if Value.subclass:
            return Value.subclass(*args_, **kwargs_)
        else:
            return Value(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Value_Name(self): return self.Value_Name
    def set_Value_Name(self, Value_Name): self.Value_Name = Value_Name
    def get_Value_Data(self): return self.Value_Data
    def set_Value_Data(self, Value_Data): self.Value_Data = Value_Data
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def export(self, outfile, level, namespace_='maec:', name_='Value', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Value')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Value'):
        if self.type_ is not None:
            outfile.write(' type=%s' % (self.format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Value'):
        if self.Value_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sValue_Name>%s</%sValue_Name>\n' % (namespace_, self.format_string(quote_xml(self.Value_Name).encode(ExternalEncoding), input_name='Value_Name'), namespace_))
        if self.Value_Data is not None:
            showIndent(outfile, level)
            outfile.write('<%sValue_Data>%s</%sValue_Data>\n' % (namespace_, self.format_string(quote_xml(self.Value_Data).encode(ExternalEncoding), input_name='Value_Data'), namespace_))
    def hasContent_(self):
        if (
            self.Value_Name is not None or
            self.Value_Data is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Value'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Value_Name is not None:
            showIndent(outfile, level)
            outfile.write('Value_Name=%s,\n' % quote_python(self.Value_Name).encode(ExternalEncoding))
        if self.Value_Data is not None:
            showIndent(outfile, level)
            outfile.write('Value_Data=%s,\n' % quote_python(self.Value_Data).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('type'):
            self.type_ = attrs.get('type').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Value_Name':
            Value_Name_ = ''
            for text__content_ in child_.childNodes:
                Value_Name_ += text__content_.nodeValue
            self.Value_Name = Value_Name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Value_Data':
            Value_Data_ = ''
            for text__content_ in child_.childNodes:
                Value_Data_ += text__content_.nodeValue
            self.Value_Data = Value_Data_
# end class Value


class Process_Object_Attributes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Image_Name=None, Start_Username=None, Current_Directory=None, Command_Line=None, Security_Attributes=None, Process_ID=None, Start_Address=None, Parent_Process=None, Start_DateTime=None, Child_Processes=None, Handles=None):
        self.Image_Name = Image_Name
        self.Start_Username = Start_Username
        self.Current_Directory = Current_Directory
        self.Command_Line = Command_Line
        self.Security_Attributes = Security_Attributes
        self.Process_ID = Process_ID
        self.Start_Address = Start_Address
        self.Parent_Process = Parent_Process
        self.Start_DateTime = Start_DateTime
        self.Child_Processes = Child_Processes
        self.Handles = Handles
    def factory(*args_, **kwargs_):
        if Process_Object_Attributes.subclass:
            return Process_Object_Attributes.subclass(*args_, **kwargs_)
        else:
            return Process_Object_Attributes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Image_Name(self): return self.Image_Name
    def set_Image_Name(self, Image_Name): self.Image_Name = Image_Name
    def get_Start_Username(self): return self.Start_Username
    def set_Start_Username(self, Start_Username): self.Start_Username = Start_Username
    def get_Current_Directory(self): return self.Current_Directory
    def set_Current_Directory(self, Current_Directory): self.Current_Directory = Current_Directory
    def get_Command_Line(self): return self.Command_Line
    def set_Command_Line(self, Command_Line): self.Command_Line = Command_Line
    def get_Security_Attributes(self): return self.Security_Attributes
    def set_Security_Attributes(self, Security_Attributes): self.Security_Attributes = Security_Attributes
    def get_Process_ID(self): return self.Process_ID
    def set_Process_ID(self, Process_ID): self.Process_ID = Process_ID
    def get_Start_Address(self): return self.Start_Address
    def set_Start_Address(self, Start_Address): self.Start_Address = Start_Address
    def get_Parent_Process(self): return self.Parent_Process
    def set_Parent_Process(self, Parent_Process): self.Parent_Process = Parent_Process
    def get_Start_DateTime(self): return self.Start_DateTime
    def set_Start_DateTime(self, Start_DateTime): self.Start_DateTime = Start_DateTime
    def get_Child_Processes(self): return self.Child_Processes
    def set_Child_Processes(self, Child_Processes): self.Child_Processes = Child_Processes
    def get_Handles(self): return self.Handles
    def set_Handles(self, Handles): self.Handles = Handles
    def export(self, outfile, level, namespace_='maec:', name_='Process_Object_Attributes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Process_Object_Attributes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Process_Object_Attributes'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Process_Object_Attributes'):
        if self.Image_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sImage_Name>%s</%sImage_Name>\n' % (namespace_, self.format_string(quote_xml(self.Image_Name).encode(ExternalEncoding), input_name='Image_Name'), namespace_))
        if self.Start_Username is not None:
            showIndent(outfile, level)
            outfile.write('<%sStart_Username>%s</%sStart_Username>\n' % (namespace_, self.format_string(quote_xml(self.Start_Username).encode(ExternalEncoding), input_name='Start_Username'), namespace_))
        if self.Current_Directory is not None:
            showIndent(outfile, level)
            outfile.write('<%sCurrent_Directory>%s</%sCurrent_Directory>\n' % (namespace_, self.format_string(quote_xml(self.Current_Directory).encode(ExternalEncoding), input_name='Current_Directory'), namespace_))
        if self.Command_Line is not None:
            showIndent(outfile, level)
            outfile.write('<%sCommand_Line>%s</%sCommand_Line>\n' % (namespace_, self.format_string(quote_xml(self.Command_Line).encode(ExternalEncoding), input_name='Command_Line'), namespace_))
        if self.Security_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('<%sSecurity_Attributes>%s</%sSecurity_Attributes>\n' % (namespace_, self.format_string(quote_xml(self.Security_Attributes).encode(ExternalEncoding), input_name='Security_Attributes'), namespace_))
        if self.Process_ID is not None:
            showIndent(outfile, level)
            outfile.write('<%sProcess_ID>%s</%sProcess_ID>\n' % (namespace_, self.format_string(quote_xml(self.Process_ID).encode(ExternalEncoding), input_name='Process_ID'), namespace_))
        if self.Start_Address is not None:
            showIndent(outfile, level)
            outfile.write('<%sStart_Address>%s</%sStart_Address>\n' % (namespace_, self.format_string(quote_xml(self.Start_Address).encode(ExternalEncoding), input_name='Start_Address'), namespace_))
        if self.Parent_Process:
            self.Parent_Process.export(outfile, level, namespace_, name_='Parent_Process')
        if self.Start_DateTime is not None:
            showIndent(outfile, level)
            outfile.write('<%sStart_DateTime>%s</%sStart_DateTime>\n' % (namespace_, self.format_string(quote_xml(self.Start_DateTime).encode(ExternalEncoding), input_name='Start_DateTime'), namespace_))
        if self.Child_Processes:
            self.Child_Processes.export(outfile, level, namespace_, name_='Child_Processes')
        if self.Handles:
            self.Handles.export(outfile, level, namespace_, name_='Handles')
    def hasContent_(self):
        if (
            self.Image_Name is not None or
            self.Start_Username is not None or
            self.Current_Directory is not None or
            self.Command_Line is not None or
            self.Security_Attributes is not None or
            self.Process_ID is not None or
            self.Start_Address is not None or
            self.Parent_Process is not None or
            self.Start_DateTime is not None or
            self.Child_Processes is not None or
            self.Handles is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Process_Object_Attributes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Image_Name is not None:
            showIndent(outfile, level)
            outfile.write('Image_Name=%s,\n' % quote_python(self.Image_Name).encode(ExternalEncoding))
        if self.Start_Username is not None:
            showIndent(outfile, level)
            outfile.write('Start_Username=%s,\n' % quote_python(self.Start_Username).encode(ExternalEncoding))
        if self.Current_Directory is not None:
            showIndent(outfile, level)
            outfile.write('Current_Directory=%s,\n' % quote_python(self.Current_Directory).encode(ExternalEncoding))
        if self.Command_Line is not None:
            showIndent(outfile, level)
            outfile.write('Command_Line=%s,\n' % quote_python(self.Command_Line).encode(ExternalEncoding))
        if self.Security_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Security_Attributes=%s,\n' % quote_python(self.Security_Attributes).encode(ExternalEncoding))
        if self.Process_ID is not None:
            showIndent(outfile, level)
            outfile.write('Process_ID=%s,\n' % quote_python(self.Process_ID).encode(ExternalEncoding))
        if self.Start_Address is not None:
            showIndent(outfile, level)
            outfile.write('Start_Address=%s,\n' % quote_python(self.Start_Address).encode(ExternalEncoding))
        if self.Parent_Process is not None:
            showIndent(outfile, level)
            outfile.write('Parent_Process=model_.ObjectReferenceType(\n')
            self.Parent_Process.exportLiteral(outfile, level, name_='Parent_Process')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Start_DateTime is not None:
            showIndent(outfile, level)
            outfile.write('Start_DateTime=%s,\n' % quote_python(self.Start_DateTime).encode(ExternalEncoding))
        if self.Child_Processes is not None:
            showIndent(outfile, level)
            outfile.write('Child_Processes=model_.Child_Processes(\n')
            self.Child_Processes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Handles is not None:
            showIndent(outfile, level)
            outfile.write('Handles=model_.Handles(\n')
            self.Handles.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Image_Name':
            Image_Name_ = ''
            for text__content_ in child_.childNodes:
                Image_Name_ += text__content_.nodeValue
            self.Image_Name = Image_Name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Start_Username':
            Start_Username_ = ''
            for text__content_ in child_.childNodes:
                Start_Username_ += text__content_.nodeValue
            self.Start_Username = Start_Username_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Current_Directory':
            Current_Directory_ = ''
            for text__content_ in child_.childNodes:
                Current_Directory_ += text__content_.nodeValue
            self.Current_Directory = Current_Directory_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Command_Line':
            Command_Line_ = ''
            for text__content_ in child_.childNodes:
                Command_Line_ += text__content_.nodeValue
            self.Command_Line = Command_Line_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Security_Attributes':
            Security_Attributes_ = ''
            for text__content_ in child_.childNodes:
                Security_Attributes_ += text__content_.nodeValue
            self.Security_Attributes = Security_Attributes_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Process_ID':
            Process_ID_ = ''
            for text__content_ in child_.childNodes:
                Process_ID_ += text__content_.nodeValue
            self.Process_ID = Process_ID_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Start_Address':
            Start_Address_ = ''
            for text__content_ in child_.childNodes:
                Start_Address_ += text__content_.nodeValue
            self.Start_Address = Start_Address_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Parent_Process':
            obj_ = ObjectReferenceType.factory()
            obj_.build(child_)
            self.set_Parent_Process(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Start_DateTime':
            Start_DateTime_ = ''
            for text__content_ in child_.childNodes:
                Start_DateTime_ += text__content_.nodeValue
            self.Start_DateTime = Start_DateTime_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Child_Processes':
            obj_ = Child_Processes.factory()
            obj_.build(child_)
            self.set_Child_Processes(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Handles':
            obj_ = Handles.factory()
            obj_.build(child_)
            self.set_Handles(obj_)
# end class Process_Object_Attributes


class Child_Processes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Child_Process=None):
        if Child_Process is None:
            self.Child_Process = []
        else:
            self.Child_Process = Child_Process
    def factory(*args_, **kwargs_):
        if Child_Processes.subclass:
            return Child_Processes.subclass(*args_, **kwargs_)
        else:
            return Child_Processes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Child_Process(self): return self.Child_Process
    def set_Child_Process(self, Child_Process): self.Child_Process = Child_Process
    def add_Child_Process(self, value): self.Child_Process.append(value)
    def insert_Child_Process(self, index, value): self.Child_Process[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Child_Processes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Child_Processes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Child_Processes'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Child_Processes'):
        for Child_Process_ in self.Child_Process:
            Child_Process_.export(outfile, level, namespace_, name_='Child_Process')
    def hasContent_(self):
        if (
            self.Child_Process
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Child_Processes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Child_Process=[\n')
        level += 1
        for Child_Process_ in self.Child_Process:
            showIndent(outfile, level)
            outfile.write('model_.ObjectReferenceType(\n')
            Child_Process_.exportLiteral(outfile, level, name_='ObjectReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Child_Process':
            obj_ = ObjectReferenceType.factory()
            obj_.build(child_)
            self.Child_Process.append(obj_)
# end class Child_Processes


class Handles(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Handle=None):
        if Handle is None:
            self.Handle = []
        else:
            self.Handle = Handle
    def factory(*args_, **kwargs_):
        if Handles.subclass:
            return Handles.subclass(*args_, **kwargs_)
        else:
            return Handles(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Handle(self): return self.Handle
    def set_Handle(self, Handle): self.Handle = Handle
    def add_Handle(self, value): self.Handle.append(value)
    def insert_Handle(self, index, value): self.Handle[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Handles', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Handles')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Handles'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Handles'):
        for Handle_ in self.Handle:
            Handle_.export(outfile, level, namespace_, name_='Handle')
    def hasContent_(self):
        if (
            self.Handle
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Handles'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Handle=[\n')
        level += 1
        for Handle_ in self.Handle:
            showIndent(outfile, level)
            outfile.write('model_.Handle(\n')
            Handle_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Handle':
            obj_ = Handle.factory()
            obj_.build(child_)
            self.Handle.append(obj_)
# end class Handles


class Handle(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Name=None):
        self.Name = Name
    def factory(*args_, **kwargs_):
        if Handle.subclass:
            return Handle.subclass(*args_, **kwargs_)
        else:
            return Handle(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def export(self, outfile, level, namespace_='maec:', name_='Handle', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Handle')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Handle'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Handle'):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sName>%s</%sName>\n' % (namespace_, self.format_integer(self.Name, input_name='Name'), namespace_))
    def hasContent_(self):
        if (
            self.Name is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Handle'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%d,\n' % self.Name)
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Name':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError as exp:
                    raise ValueError('requires integer (Name): %s' % exp)
                self.Name = ival_
# end class Handle


class Memory_Object_Attributes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Memory_Block_ID=None, Start_Address=None):
        self.Memory_Block_ID = Memory_Block_ID
        self.Start_Address = Start_Address
    def factory(*args_, **kwargs_):
        if Memory_Object_Attributes.subclass:
            return Memory_Object_Attributes.subclass(*args_, **kwargs_)
        else:
            return Memory_Object_Attributes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Memory_Block_ID(self): return self.Memory_Block_ID
    def set_Memory_Block_ID(self, Memory_Block_ID): self.Memory_Block_ID = Memory_Block_ID
    def get_Start_Address(self): return self.Start_Address
    def set_Start_Address(self, Start_Address): self.Start_Address = Start_Address
    def export(self, outfile, level, namespace_='maec:', name_='Memory_Object_Attributes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Memory_Object_Attributes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Memory_Object_Attributes'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Memory_Object_Attributes'):
        if self.Memory_Block_ID is not None:
            showIndent(outfile, level)
            outfile.write('<%sMemory_Block_ID>%s</%sMemory_Block_ID>\n' % (namespace_, self.format_string(quote_xml(self.Memory_Block_ID).encode(ExternalEncoding), input_name='Memory_Block_ID'), namespace_))
        if self.Start_Address is not None:
            showIndent(outfile, level)
            outfile.write('<%sStart_Address>%s</%sStart_Address>\n' % (namespace_, self.format_string(quote_xml(self.Start_Address).encode(ExternalEncoding), input_name='Start_Address'), namespace_))
    def hasContent_(self):
        if (
            self.Memory_Block_ID is not None or
            self.Start_Address is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Memory_Object_Attributes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Memory_Block_ID is not None:
            showIndent(outfile, level)
            outfile.write('Memory_Block_ID=%s,\n' % quote_python(self.Memory_Block_ID).encode(ExternalEncoding))
        if self.Start_Address is not None:
            showIndent(outfile, level)
            outfile.write('Start_Address=%s,\n' % quote_python(self.Start_Address).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Memory_Block_ID':
            Memory_Block_ID_ = ''
            for text__content_ in child_.childNodes:
                Memory_Block_ID_ += text__content_.nodeValue
            self.Memory_Block_ID = Memory_Block_ID_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Start_Address':
            Start_Address_ = ''
            for text__content_ in child_.childNodes:
                Start_Address_ += text__content_.nodeValue
            self.Start_Address = Start_Address_
# end class Memory_Object_Attributes


class Network_Object_Attributes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Internal_Port=None, External_Port=None, Socket_Type=None, Socket_ID=None, Internal_IP_Address=None, External_IP_Address=None, IP_Protocol=None, Application_Layer_Protocol=None):
        self.Internal_Port = Internal_Port
        self.External_Port = External_Port
        self.Socket_Type = Socket_Type
        self.Socket_ID = Socket_ID
        self.Internal_IP_Address = Internal_IP_Address
        self.External_IP_Address = External_IP_Address
        self.IP_Protocol = IP_Protocol
        self.Application_Layer_Protocol = Application_Layer_Protocol
    def factory(*args_, **kwargs_):
        if Network_Object_Attributes.subclass:
            return Network_Object_Attributes.subclass(*args_, **kwargs_)
        else:
            return Network_Object_Attributes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Internal_Port(self): return self.Internal_Port
    def set_Internal_Port(self, Internal_Port): self.Internal_Port = Internal_Port
    def get_External_Port(self): return self.External_Port
    def set_External_Port(self, External_Port): self.External_Port = External_Port
    def get_Socket_Type(self): return self.Socket_Type
    def set_Socket_Type(self, Socket_Type): self.Socket_Type = Socket_Type
    def validate_Socket_Type(self, value):
        # Validate type Socket_Type, a restriction on xs:string.
        pass
    def get_Socket_ID(self): return self.Socket_ID
    def set_Socket_ID(self, Socket_ID): self.Socket_ID = Socket_ID
    def get_Internal_IP_Address(self): return self.Internal_IP_Address
    def set_Internal_IP_Address(self, Internal_IP_Address): self.Internal_IP_Address = Internal_IP_Address
    def get_External_IP_Address(self): return self.External_IP_Address
    def set_External_IP_Address(self, External_IP_Address): self.External_IP_Address = External_IP_Address
    def get_IP_Protocol(self): return self.IP_Protocol
    def set_IP_Protocol(self, IP_Protocol): self.IP_Protocol = IP_Protocol
    def get_Application_Layer_Protocol(self): return self.Application_Layer_Protocol
    def set_Application_Layer_Protocol(self, Application_Layer_Protocol): self.Application_Layer_Protocol = Application_Layer_Protocol
    def validate_Application_Layer_Protocol(self, value):
        # validate type Application_Layer_Protocol
        pass
    def export(self, outfile, level, namespace_='maec:', name_='Network_Object_Attributes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Network_Object_Attributes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Network_Object_Attributes'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Network_Object_Attributes'):
        if self.Internal_Port is not None:
            showIndent(outfile, level)
            outfile.write('<%sInternal_Port>%s</%sInternal_Port>\n' % (namespace_, self.format_integer(self.Internal_Port, input_name='Internal_Port'), namespace_))
        if self.External_Port is not None:
            showIndent(outfile, level)
            outfile.write('<%sExternal_Port>%s</%sExternal_Port>\n' % (namespace_, self.format_integer(self.External_Port, input_name='External_Port'), namespace_))
        if self.Socket_Type is not None:
            showIndent(outfile, level)
            outfile.write('<%sSocket_Type>%s</%sSocket_Type>\n' % (namespace_, self.format_string(quote_xml(self.Socket_Type).encode(ExternalEncoding), input_name='Socket_Type'), namespace_))
        if self.Socket_ID is not None:
            showIndent(outfile, level)
            outfile.write('<%sSocket_ID>%s</%sSocket_ID>\n' % (namespace_, self.format_integer(self.Socket_ID, input_name='Socket_ID'), namespace_))
        if self.Internal_IP_Address is not None:
            showIndent(outfile, level)
            outfile.write('<%sInternal_IP_Address>%s</%sInternal_IP_Address>\n' % (namespace_, self.format_string(quote_xml(self.Internal_IP_Address).encode(ExternalEncoding), input_name='Internal_IP_Address'), namespace_))
        if self.External_IP_Address is not None:
            showIndent(outfile, level)
            outfile.write('<%sExternal_IP_Address>%s</%sExternal_IP_Address>\n' % (namespace_, self.format_string(quote_xml(self.External_IP_Address).encode(ExternalEncoding), input_name='External_IP_Address'), namespace_))
        if self.IP_Protocol is not None:
            showIndent(outfile, level)
            outfile.write('<%sIP_Protocol>%s</%sIP_Protocol>\n' % (namespace_, self.format_string(quote_xml(self.IP_Protocol).encode(ExternalEncoding), input_name='IP_Protocol'), namespace_))
        if self.Application_Layer_Protocol is not None:
            showIndent(outfile, level)
            outfile.write('<%sApplication_Layer_Protocol>%s</%sApplication_Layer_Protocol>\n' % (namespace_, self.format_string(quote_xml(self.Application_Layer_Protocol).encode(ExternalEncoding), input_name='Application_Layer_Protocol'), namespace_))
    def hasContent_(self):
        if (
            self.Internal_Port is not None or
            self.External_Port is not None or
            self.Socket_Type is not None or
            self.Socket_ID is not None or
            self.Internal_IP_Address is not None or
            self.External_IP_Address is not None or
            self.IP_Protocol is not None or
            self.Application_Layer_Protocol is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Network_Object_Attributes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Internal_Port is not None:
            showIndent(outfile, level)
            outfile.write('Internal_Port=%d,\n' % self.Internal_Port)
        if self.External_Port is not None:
            showIndent(outfile, level)
            outfile.write('External_Port=%d,\n' % self.External_Port)
        if self.Socket_Type is not None:
            showIndent(outfile, level)
            outfile.write('Socket_Type=%s,\n' % quote_python(self.Socket_Type).encode(ExternalEncoding))
        if self.Socket_ID is not None:
            showIndent(outfile, level)
            outfile.write('Socket_ID=%d,\n' % self.Socket_ID)
        if self.Internal_IP_Address is not None:
            showIndent(outfile, level)
            outfile.write('Internal_IP_Address=%s,\n' % quote_python(self.Internal_IP_Address).encode(ExternalEncoding))
        if self.External_IP_Address is not None:
            showIndent(outfile, level)
            outfile.write('External_IP_Address=%s,\n' % quote_python(self.External_IP_Address).encode(ExternalEncoding))
        if self.IP_Protocol is not None:
            showIndent(outfile, level)
            outfile.write('IP_Protocol=%s,\n' % quote_python(self.IP_Protocol).encode(ExternalEncoding))
        if self.Application_Layer_Protocol is not None:
            showIndent(outfile, level)
            outfile.write('Application_Layer_Protocol=%s,\n' % quote_python(self.Application_Layer_Protocol).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Internal_Port':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError as exp:
                    raise ValueError('requires integer (Internal_Port): %s' % exp)
                self.Internal_Port = ival_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'External_Port':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError as exp:
                    raise ValueError('requires integer (External_Port): %s' % exp)
                self.External_Port = ival_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Socket_Type':
            Socket_Type_ = ''
            for text__content_ in child_.childNodes:
                Socket_Type_ += text__content_.nodeValue
            self.Socket_Type = Socket_Type_
            self.validate_Socket_Type(self.Socket_Type)    # validate type Socket_Type
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Socket_ID':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError as exp:
                    raise ValueError('requires integer (Socket_ID): %s' % exp)
                self.Socket_ID = ival_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Internal_IP_Address':
            Internal_IP_Address_ = ''
            for text__content_ in child_.childNodes:
                Internal_IP_Address_ += text__content_.nodeValue
            self.Internal_IP_Address = Internal_IP_Address_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'External_IP_Address':
            External_IP_Address_ = ''
            for text__content_ in child_.childNodes:
                External_IP_Address_ += text__content_.nodeValue
            self.External_IP_Address = External_IP_Address_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'IP_Protocol':
            IP_Protocol_ = ''
            for text__content_ in child_.childNodes:
                IP_Protocol_ += text__content_.nodeValue
            self.IP_Protocol = IP_Protocol_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Application_Layer_Protocol':
            Application_Layer_Protocol_ = ''
            for text__content_ in child_.childNodes:
                Application_Layer_Protocol_ += text__content_.nodeValue
            self.Application_Layer_Protocol = Application_Layer_Protocol_
            self.validate_Application_Layer_Protocol(self.Application_Layer_Protocol)    # validate type Application_Layer_Protocol
# end class Network_Object_Attributes


class Socket_Type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=''):
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Socket_Type.subclass:
            return Socket_Type.subclass(*args_, **kwargs_)
        else:
            return Socket_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='maec:', name_='Socket_Type', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Socket_Type')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Socket_Type'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Socket_Type'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value)
        else:
            outfile.write(quote_xml('%s' % self.valueOf_))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Socket_Type'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class Socket_Type


class Daemon_Object_Attributes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Service_Type=None, Start_Type=None, Display_Name=None, Daemon_Binary_Object=None, Load_Order_Group=None):
        self.Service_Type = Service_Type
        self.Start_Type = Start_Type
        self.Display_Name = Display_Name
        self.Daemon_Binary_Object = Daemon_Binary_Object
        self.Load_Order_Group = Load_Order_Group
    def factory(*args_, **kwargs_):
        if Daemon_Object_Attributes.subclass:
            return Daemon_Object_Attributes.subclass(*args_, **kwargs_)
        else:
            return Daemon_Object_Attributes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Service_Type(self): return self.Service_Type
    def set_Service_Type(self, Service_Type): self.Service_Type = Service_Type
    def validate_Service_Type(self, value):
        # Validate type Service_Type, a restriction on xs:string.
        pass
    def get_Start_Type(self): return self.Start_Type
    def set_Start_Type(self, Start_Type): self.Start_Type = Start_Type
    def get_Display_Name(self): return self.Display_Name
    def set_Display_Name(self, Display_Name): self.Display_Name = Display_Name
    def get_Daemon_Binary_Object(self): return self.Daemon_Binary_Object
    def set_Daemon_Binary_Object(self, Daemon_Binary_Object): self.Daemon_Binary_Object = Daemon_Binary_Object
    def get_Load_Order_Group(self): return self.Load_Order_Group
    def set_Load_Order_Group(self, Load_Order_Group): self.Load_Order_Group = Load_Order_Group
    def export(self, outfile, level, namespace_='maec:', name_='Daemon_Object_Attributes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Daemon_Object_Attributes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Daemon_Object_Attributes'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Daemon_Object_Attributes'):
        if self.Service_Type is not None:
            showIndent(outfile, level)
            outfile.write('<%sService_Type>%s</%sService_Type>\n' % (namespace_, self.format_string(quote_xml(self.Service_Type).encode(ExternalEncoding), input_name='Service_Type'), namespace_))
        if self.Start_Type is not None:
            showIndent(outfile, level)
            outfile.write('<%sStart_Type>%s</%sStart_Type>\n' % (namespace_, self.format_string(quote_xml(self.Start_Type).encode(ExternalEncoding), input_name='Start_Type'), namespace_))
        if self.Display_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sDisplay_Name>%s</%sDisplay_Name>\n' % (namespace_, self.format_string(quote_xml(self.Display_Name).encode(ExternalEncoding), input_name='Display_Name'), namespace_))
        if self.Daemon_Binary_Object:
            self.Daemon_Binary_Object.export(outfile, level, namespace_, name_='Daemon_Binary_Object')
        if self.Load_Order_Group is not None:
            showIndent(outfile, level)
            outfile.write('<%sLoad_Order_Group>%s</%sLoad_Order_Group>\n' % (namespace_, self.format_string(quote_xml(self.Load_Order_Group).encode(ExternalEncoding), input_name='Load_Order_Group'), namespace_))
    def hasContent_(self):
        if (
            self.Service_Type is not None or
            self.Start_Type is not None or
            self.Display_Name is not None or
            self.Daemon_Binary_Object is not None or
            self.Load_Order_Group is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Daemon_Object_Attributes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Service_Type is not None:
            showIndent(outfile, level)
            outfile.write('Service_Type=%s,\n' % quote_python(self.Service_Type).encode(ExternalEncoding))
        if self.Start_Type is not None:
            showIndent(outfile, level)
            outfile.write('Start_Type=%s,\n' % quote_python(self.Start_Type).encode(ExternalEncoding))
        if self.Display_Name is not None:
            showIndent(outfile, level)
            outfile.write('Display_Name=%s,\n' % quote_python(self.Display_Name).encode(ExternalEncoding))
        if self.Daemon_Binary_Object is not None:
            showIndent(outfile, level)
            outfile.write('Daemon_Binary_Object=model_.ObjectType(\n')
            self.Daemon_Binary_Object.exportLiteral(outfile, level, name_='Daemon_Binary_Object')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Load_Order_Group is not None:
            showIndent(outfile, level)
            outfile.write('Load_Order_Group=%s,\n' % quote_python(self.Load_Order_Group).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Service_Type':
            Service_Type_ = ''
            for text__content_ in child_.childNodes:
                Service_Type_ += text__content_.nodeValue
            self.Service_Type = Service_Type_
            self.validate_Service_Type(self.Service_Type)    # validate type Service_Type
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Start_Type':
            Start_Type_ = ''
            for text__content_ in child_.childNodes:
                Start_Type_ += text__content_.nodeValue
            self.Start_Type = Start_Type_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Display_Name':
            Display_Name_ = ''
            for text__content_ in child_.childNodes:
                Display_Name_ += text__content_.nodeValue
            self.Display_Name = Display_Name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Daemon_Binary_Object':
            obj_ = ObjectType.factory()
            obj_.build(child_)
            self.set_Daemon_Binary_Object(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Load_Order_Group':
            Load_Order_Group_ = ''
            for text__content_ in child_.childNodes:
                Load_Order_Group_ += text__content_.nodeValue
            self.Load_Order_Group = Load_Order_Group_
# end class Daemon_Object_Attributes


class Service_Type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=''):
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Service_Type.subclass:
            return Service_Type.subclass(*args_, **kwargs_)
        else:
            return Service_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='maec:', name_='Service_Type', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Service_Type')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Service_Type'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Service_Type'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value)
        else:
            outfile.write(quote_xml('%s' % self.valueOf_))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Service_Type'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class Service_Type


class Custom_Object_Attributes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Custom_Attribute=None):
        if Custom_Attribute is None:
            self.Custom_Attribute = []
        else:
            self.Custom_Attribute = Custom_Attribute
    def factory(*args_, **kwargs_):
        if Custom_Object_Attributes.subclass:
            return Custom_Object_Attributes.subclass(*args_, **kwargs_)
        else:
            return Custom_Object_Attributes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Custom_Attribute(self): return self.Custom_Attribute
    def set_Custom_Attribute(self, Custom_Attribute): self.Custom_Attribute = Custom_Attribute
    def add_Custom_Attribute(self, value): self.Custom_Attribute.append(value)
    def insert_Custom_Attribute(self, index, value): self.Custom_Attribute[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Custom_Object_Attributes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Custom_Object_Attributes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Custom_Object_Attributes'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Custom_Object_Attributes'):
        for Custom_Attribute_ in self.Custom_Attribute:
            Custom_Attribute_.export(outfile, level, namespace_, name_='Custom_Attribute')
    def hasContent_(self):
        if (
            self.Custom_Attribute
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Custom_Object_Attributes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Custom_Attribute=[\n')
        level += 1
        for Custom_Attribute_ in self.Custom_Attribute:
            showIndent(outfile, level)
            outfile.write('model_.Custom_Attribute(\n')
            Custom_Attribute_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Custom_Attribute':
            obj_ = Custom_Attribute.factory()
            obj_.build(child_)
            self.Custom_Attribute.append(obj_)
# end class Custom_Object_Attributes


class Custom_Attribute(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, custom_attribute_name=None, valueOf_=''):
        self.custom_attribute_name = _cast(None, custom_attribute_name)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Custom_Attribute.subclass:
            return Custom_Attribute.subclass(*args_, **kwargs_)
        else:
            return Custom_Attribute(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_custom_attribute_name(self): return self.custom_attribute_name
    def set_custom_attribute_name(self, custom_attribute_name): self.custom_attribute_name = custom_attribute_name
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='maec:', name_='Custom_Attribute', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Custom_Attribute')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Custom_Attribute'):
        if self.custom_attribute_name is not None:
            outfile.write(' custom_attribute_name=%s' % (self.format_string(quote_attrib(self.custom_attribute_name).encode(ExternalEncoding), input_name='custom_attribute_name'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Custom_Attribute'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value)
        else:
            outfile.write(quote_xml('%s' % self.valueOf_))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Custom_Attribute'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.custom_attribute_name is not None:
            showIndent(outfile, level)
            outfile.write('custom_attribute_name = "%s",\n' % (self.custom_attribute_name,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('custom_attribute_name'):
            self.custom_attribute_name = attrs.get('custom_attribute_name').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class Custom_Attribute


class EffectType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None, Description=None, Affected_Objects=None, Constituent_Effects=None, Vulnerability_Exploit=None):
        self.id = _cast(None, id)
        self.Description = Description
        self.Affected_Objects = Affected_Objects
        self.Constituent_Effects = Constituent_Effects
        self.Vulnerability_Exploit = Vulnerability_Exploit
    def factory(*args_, **kwargs_):
        if EffectType.subclass:
            return EffectType.subclass(*args_, **kwargs_)
        else:
            return EffectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Affected_Objects(self): return self.Affected_Objects
    def set_Affected_Objects(self, Affected_Objects): self.Affected_Objects = Affected_Objects
    def get_Constituent_Effects(self): return self.Constituent_Effects
    def set_Constituent_Effects(self, Constituent_Effects): self.Constituent_Effects = Constituent_Effects
    def get_Vulnerability_Exploit(self): return self.Vulnerability_Exploit
    def set_Vulnerability_Exploit(self, Vulnerability_Exploit): self.Vulnerability_Exploit = Vulnerability_Exploit
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='maec:', name_='EffectType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='EffectType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='EffectType'):
        outfile.write(' id=%s' % (quote_attrib(self.id), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='EffectType'):
        if self.Description:
            self.Description.export(outfile, level, namespace_, name_='Description')
        if self.Affected_Objects:
            self.Affected_Objects.export(outfile, level, namespace_, name_='Affected_Objects')
        if self.Constituent_Effects:
            self.Constituent_Effects.export(outfile, level, namespace_, name_='Constituent_Effects')
        if self.Vulnerability_Exploit:
            self.Vulnerability_Exploit.export(outfile, level, namespace_, name_='Vulnerability_Exploit')
    def hasContent_(self):
        if (
            self.Description is not None or
            self.Affected_Objects is not None or
            self.Constituent_Effects is not None or
            self.Vulnerability_Exploit is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='EffectType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=model_.StructuredTextType(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Affected_Objects is not None:
            showIndent(outfile, level)
            outfile.write('Affected_Objects=model_.Affected_Objects(\n')
            self.Affected_Objects.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Constituent_Effects is not None:
            showIndent(outfile, level)
            outfile.write('Constituent_Effects=model_.Constituent_Effects(\n')
            self.Constituent_Effects.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Vulnerability_Exploit is not None:
            showIndent(outfile, level)
            outfile.write('Vulnerability_Exploit=model_.Vulnerability_Exploit(\n')
            self.Vulnerability_Exploit.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('id'):
            self.id = attrs.get('id').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Description':
            obj_ = StructuredTextType.factory()
            obj_.build(child_)
            self.set_Description(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Affected_Objects':
            obj_ = Affected_Objects.factory()
            obj_.build(child_)
            self.set_Affected_Objects(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Constituent_Effects':
            obj_ = Constituent_Effects.factory()
            obj_.build(child_)
            self.set_Constituent_Effects(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Vulnerability_Exploit':
            obj_ = Vulnerability_Exploit.factory()
            obj_.build(child_)
            self.set_Vulnerability_Exploit(obj_)
# end class EffectType


class Affected_Objects(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Affected_Object=None):
        if Affected_Object is None:
            self.Affected_Object = []
        else:
            self.Affected_Object = Affected_Object
    def factory(*args_, **kwargs_):
        if Affected_Objects.subclass:
            return Affected_Objects.subclass(*args_, **kwargs_)
        else:
            return Affected_Objects(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Affected_Object(self): return self.Affected_Object
    def set_Affected_Object(self, Affected_Object): self.Affected_Object = Affected_Object
    def add_Affected_Object(self, value): self.Affected_Object.append(value)
    def insert_Affected_Object(self, index, value): self.Affected_Object[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Affected_Objects', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Affected_Objects')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Affected_Objects'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Affected_Objects'):
        for Affected_Object_ in self.Affected_Object:
            Affected_Object_.export(outfile, level, namespace_, name_='Affected_Object')
    def hasContent_(self):
        if (
            self.Affected_Object
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Affected_Objects'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Affected_Object=[\n')
        level += 1
        for Affected_Object_ in self.Affected_Object:
            showIndent(outfile, level)
            outfile.write('model_.Affected_Object(\n')
            Affected_Object_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Affected_Object':
            obj_ = Affected_Object.factory()
            obj_.build(child_)
            self.Affected_Object.append(obj_)
# end class Affected_Objects


class Affected_Object(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, effect_type=None, Object_Reference=None):
        self.effect_type = _cast(None, effect_type)
        self.Object_Reference = Object_Reference
    def factory(*args_, **kwargs_):
        if Affected_Object.subclass:
            return Affected_Object.subclass(*args_, **kwargs_)
        else:
            return Affected_Object(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Object_Reference(self): return self.Object_Reference
    def set_Object_Reference(self, Object_Reference): self.Object_Reference = Object_Reference
    def get_effect_type(self): return self.effect_type
    def set_effect_type(self, effect_type): self.effect_type = effect_type
    def export(self, outfile, level, namespace_='maec:', name_='Affected_Object', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Affected_Object')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Affected_Object'):
        if self.effect_type is not None:
            outfile.write(' effect_type=%s' % (quote_attrib(self.effect_type), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Affected_Object'):
        if self.Object_Reference:
            self.Object_Reference.export(outfile, level, namespace_, name_='Object_Reference', )
    def hasContent_(self):
        if (
            self.Object_Reference is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Affected_Object'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.effect_type is not None:
            showIndent(outfile, level)
            outfile.write('effect_type = %s,\n' % (self.effect_type,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Object_Reference is not None:
            showIndent(outfile, level)
            outfile.write('Object_Reference=model_.ObjectReferenceType(\n')
            self.Object_Reference.exportLiteral(outfile, level, name_='Object_Reference')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('effect_type'):
            self.effect_type = attrs.get('effect_type').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Object_Reference':
            obj_ = ObjectReferenceType.factory()
            obj_.build(child_)
            self.set_Object_Reference(obj_)
# end class Affected_Object


class Constituent_Effects(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Effect_Reference=None):
        if Effect_Reference is None:
            self.Effect_Reference = []
        else:
            self.Effect_Reference = Effect_Reference
    def factory(*args_, **kwargs_):
        if Constituent_Effects.subclass:
            return Constituent_Effects.subclass(*args_, **kwargs_)
        else:
            return Constituent_Effects(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Effect_Reference(self): return self.Effect_Reference
    def set_Effect_Reference(self, Effect_Reference): self.Effect_Reference = Effect_Reference
    def add_Effect_Reference(self, value): self.Effect_Reference.append(value)
    def insert_Effect_Reference(self, index, value): self.Effect_Reference[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Constituent_Effects', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Constituent_Effects')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Constituent_Effects'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Constituent_Effects'):
        for Effect_Reference_ in self.Effect_Reference:
            Effect_Reference_.export(outfile, level, namespace_, name_='Effect_Reference')
    def hasContent_(self):
        if (
            self.Effect_Reference
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Constituent_Effects'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Effect_Reference=[\n')
        level += 1
        for Effect_Reference_ in self.Effect_Reference:
            showIndent(outfile, level)
            outfile.write('model_.EffectReferenceType(\n')
            Effect_Reference_.exportLiteral(outfile, level, name_='EffectReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Effect_Reference':
            obj_ = EffectReferenceType.factory()
            obj_.build(child_)
            self.Effect_Reference.append(obj_)
# end class Constituent_Effects


class Vulnerability_Exploit(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, vulnerability_type=None, Known_Exploit=None):
        self.vulnerability_type = _cast(None, vulnerability_type)
        self.Known_Exploit = Known_Exploit
    def factory(*args_, **kwargs_):
        if Vulnerability_Exploit.subclass:
            return Vulnerability_Exploit.subclass(*args_, **kwargs_)
        else:
            return Vulnerability_Exploit(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Known_Exploit(self): return self.Known_Exploit
    def set_Known_Exploit(self, Known_Exploit): self.Known_Exploit = Known_Exploit
    def get_vulnerability_type(self): return self.vulnerability_type
    def set_vulnerability_type(self, vulnerability_type): self.vulnerability_type = vulnerability_type
    def export(self, outfile, level, namespace_='maec:', name_='Vulnerability_Exploit', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Vulnerability_Exploit')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Vulnerability_Exploit'):
        if self.vulnerability_type is not None:
            outfile.write(' vulnerability_type=%s' % (self.format_string(quote_attrib(self.vulnerability_type).encode(ExternalEncoding), input_name='vulnerability_type'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Vulnerability_Exploit'):
        if self.Known_Exploit:
            self.Known_Exploit.export(outfile, level, namespace_, name_='Known_Exploit', )
    def hasContent_(self):
        if (
            self.Known_Exploit is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Vulnerability_Exploit'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.vulnerability_type is not None:
            showIndent(outfile, level)
            outfile.write('vulnerability_type = "%s",\n' % (self.vulnerability_type,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Known_Exploit is not None:
            showIndent(outfile, level)
            outfile.write('Known_Exploit=model_.CVEVulnerabilityType(\n')
            self.Known_Exploit.exportLiteral(outfile, level, name_='Known_Exploit')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('vulnerability_type'):
            self.vulnerability_type = attrs.get('vulnerability_type').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Known_Exploit':
            obj_ = CVEVulnerabilityType.factory()
            obj_.build(child_)
            self.set_Known_Exploit(obj_)
# end class Vulnerability_Exploit


class EffectCollectionType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None, name=None, Affinity_Type=None, Affinity_Degree=None, Description=None, Effect_Sub_Collection=None, Effect=None, Effect_Reference=None):
        self.id = _cast(None, id)
        self.name = _cast(None, name)
        self.Affinity_Type = Affinity_Type
        self.Affinity_Degree = Affinity_Degree
        self.Description = Description
        if Effect_Sub_Collection is None:
            self.Effect_Sub_Collection = []
        else:
            self.Effect_Sub_Collection = Effect_Sub_Collection
        if Effect is None:
            self.Effect = []
        else:
            self.Effect = Effect
        if Effect_Reference is None:
            self.Effect_Reference = []
        else:
            self.Effect_Reference = Effect_Reference
    def factory(*args_, **kwargs_):
        if EffectCollectionType.subclass:
            return EffectCollectionType.subclass(*args_, **kwargs_)
        else:
            return EffectCollectionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Affinity_Type(self): return self.Affinity_Type
    def set_Affinity_Type(self, Affinity_Type): self.Affinity_Type = Affinity_Type
    def get_Affinity_Degree(self): return self.Affinity_Degree
    def set_Affinity_Degree(self, Affinity_Degree): self.Affinity_Degree = Affinity_Degree
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Effect_Sub_Collection(self): return self.Effect_Sub_Collection
    def set_Effect_Sub_Collection(self, Effect_Sub_Collection): self.Effect_Sub_Collection = Effect_Sub_Collection
    def add_Effect_Sub_Collection(self, value): self.Effect_Sub_Collection.append(value)
    def insert_Effect_Sub_Collection(self, index, value): self.Effect_Sub_Collection[index] = value
    def get_Effect(self): return self.Effect
    def set_Effect(self, Effect): self.Effect = Effect
    def add_Effect(self, value): self.Effect.append(value)
    def insert_Effect(self, index, value): self.Effect[index] = value
    def get_Effect_Reference(self): return self.Effect_Reference
    def set_Effect_Reference(self, Effect_Reference): self.Effect_Reference = Effect_Reference
    def add_Effect_Reference(self, value): self.Effect_Reference.append(value)
    def insert_Effect_Reference(self, index, value): self.Effect_Reference[index] = value
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def export(self, outfile, level, namespace_='maec:', name_='EffectCollectionType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='EffectCollectionType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='EffectCollectionType'):
        outfile.write(' id=%s' % (quote_attrib(self.id), ))
        if self.name is not None:
            outfile.write(' name=%s' % (self.format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='EffectCollectionType'):
        if self.Affinity_Type is not None:
            showIndent(outfile, level)
            outfile.write('<%sAffinity_Type>%s</%sAffinity_Type>\n' % (namespace_, self.format_string(quote_xml(self.Affinity_Type).encode(ExternalEncoding), input_name='Affinity_Type'), namespace_))
        if self.Affinity_Degree is not None:
            showIndent(outfile, level)
            outfile.write('<%sAffinity_Degree>%s</%sAffinity_Degree>\n' % (namespace_, self.format_string(quote_xml(self.Affinity_Degree).encode(ExternalEncoding), input_name='Affinity_Degree'), namespace_))
        if self.Description:
            self.Description.export(outfile, level, namespace_, name_='Description')
        for Effect_Sub_Collection_ in self.Effect_Sub_Collection:
            Effect_Sub_Collection_.export(outfile, level, namespace_, name_='Effect_Sub_Collection')
        for Effect_ in self.Effect:
            Effect_.export(outfile, level, namespace_, name_='Effect')
        for Effect_Reference_ in self.Effect_Reference:
            Effect_Reference_.export(outfile, level, namespace_, name_='Effect_Reference')
    def hasContent_(self):
        if (
            self.Affinity_Type is not None or
            self.Affinity_Degree is not None or
            self.Description is not None or
            self.Effect_Sub_Collection or
            self.Effect or
            self.Effect_Reference
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='EffectCollectionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name = "%s",\n' % (self.name,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Affinity_Type is not None:
            showIndent(outfile, level)
            outfile.write('Affinity_Type=%s,\n' % quote_python(self.Affinity_Type).encode(ExternalEncoding))
        if self.Affinity_Degree is not None:
            showIndent(outfile, level)
            outfile.write('Affinity_Degree=%s,\n' % quote_python(self.Affinity_Degree).encode(ExternalEncoding))
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=model_.StructuredTextType(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Effect_Sub_Collection=[\n')
        level += 1
        for Effect_Sub_Collection_ in self.Effect_Sub_Collection:
            showIndent(outfile, level)
            outfile.write('model_.EffectCollectionType(\n')
            Effect_Sub_Collection_.exportLiteral(outfile, level, name_='EffectCollectionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Effect=[\n')
        level += 1
        for Effect_ in self.Effect:
            showIndent(outfile, level)
            outfile.write('model_.EffectType(\n')
            Effect_.exportLiteral(outfile, level, name_='EffectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Effect_Reference=[\n')
        level += 1
        for Effect_Reference_ in self.Effect_Reference:
            showIndent(outfile, level)
            outfile.write('model_.EffectReferenceType(\n')
            Effect_Reference_.exportLiteral(outfile, level, name_='EffectReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('id'):
            self.id = attrs.get('id').value
        if attrs.get('name'):
            self.name = attrs.get('name').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Affinity_Type':
            Affinity_Type_ = ''
            for text__content_ in child_.childNodes:
                Affinity_Type_ += text__content_.nodeValue
            self.Affinity_Type = Affinity_Type_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Affinity_Degree':
            Affinity_Degree_ = ''
            for text__content_ in child_.childNodes:
                Affinity_Degree_ += text__content_.nodeValue
            self.Affinity_Degree = Affinity_Degree_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Description':
            obj_ = StructuredTextType.factory()
            obj_.build(child_)
            self.set_Description(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Effect_Sub_Collection':
            obj_ = EffectCollectionType.factory()
            obj_.build(child_)
            self.Effect_Sub_Collection.append(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Effect':
            obj_ = EffectType.factory()
            obj_.build(child_)
            self.Effect.append(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Effect_Reference':
            obj_ = EffectReferenceType.factory()
            obj_.build(child_)
            self.Effect_Reference.append(obj_)
# end class EffectCollectionType


class EffectReferenceType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, effect_id=None, valueOf_=''):
        self.type_ = _cast(None, type_)
        self.effect_id = _cast(None, effect_id)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if EffectReferenceType.subclass:
            return EffectReferenceType.subclass(*args_, **kwargs_)
        else:
            return EffectReferenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_effect_id(self): return self.effect_id
    def set_effect_id(self, effect_id): self.effect_id = effect_id
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='maec:', name_='EffectReferenceType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='EffectReferenceType')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='EffectReferenceType'):
        if self.type_ is not None:
            outfile.write(' type=%s' % (self.format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        outfile.write(' effect_id=%s' % (quote_attrib(self.effect_id), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='EffectReferenceType'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value)
        else:
            outfile.write(quote_xml('%s' % self.valueOf_))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='EffectReferenceType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
        if self.effect_id is not None:
            showIndent(outfile, level)
            outfile.write('effect_id = %s,\n' % (self.effect_id,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('type'):
            self.type_ = attrs.get('type').value
        if attrs.get('effect_id'):
            self.effect_id = attrs.get('effect_id').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class EffectReferenceType


class StructuredTextType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Text_Title=None, Text=None, Code_Example_Language=None, Code=None, Images=None, Block=None):
        if Text_Title is None:
            self.Text_Title = []
        else:
            self.Text_Title = Text_Title
        if Text is None:
            self.Text = []
        else:
            self.Text = Text
        if Code_Example_Language is None:
            self.Code_Example_Language = []
        else:
            self.Code_Example_Language = Code_Example_Language
        if Code is None:
            self.Code = []
        else:
            self.Code = Code
        self.Images = Images
        if Block is None:
            self.Block = []
        else:
            self.Block = Block
    def factory(*args_, **kwargs_):
        if StructuredTextType.subclass:
            return StructuredTextType.subclass(*args_, **kwargs_)
        else:
            return StructuredTextType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Text_Title(self): return self.Text_Title
    def set_Text_Title(self, Text_Title): self.Text_Title = Text_Title
    def add_Text_Title(self, value): self.Text_Title.append(value)
    def insert_Text_Title(self, index, value): self.Text_Title[index] = value
    def get_Text(self): return self.Text
    def set_Text(self, Text): self.Text = Text
    def add_Text(self, value): self.Text.append(value)
    def insert_Text(self, index, value): self.Text[index] = value
    def get_Code_Example_Language(self): return self.Code_Example_Language
    def set_Code_Example_Language(self, Code_Example_Language): self.Code_Example_Language = Code_Example_Language
    def add_Code_Example_Language(self, value): self.Code_Example_Language.append(value)
    def insert_Code_Example_Language(self, index, value): self.Code_Example_Language[index] = value
    def validate_Code_Example_Language(self, value):
        # validate type Code_Example_Language
        pass
    def get_Code(self): return self.Code
    def set_Code(self, Code): self.Code = Code
    def add_Code(self, value): self.Code.append(value)
    def insert_Code(self, index, value): self.Code[index] = value
    def get_Images(self): return self.Images
    def set_Images(self, Images): self.Images = Images
    def get_Block(self): return self.Block
    def set_Block(self, Block): self.Block = Block
    def add_Block(self, value): self.Block.append(value)
    def insert_Block(self, index, value): self.Block[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='StructuredTextType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='StructuredTextType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='StructuredTextType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='StructuredTextType'):
        for Text_Title_ in self.Text_Title:
            showIndent(outfile, level)
            outfile.write('<%sText_Title>%s</%sText_Title>\n' % (namespace_, self.format_string(quote_xml(Text_Title_).encode(ExternalEncoding), input_name='Text_Title'), namespace_))
        for Text_ in self.Text:
            showIndent(outfile, level)
            outfile.write('<%sText>%s</%sText>\n' % (namespace_, self.format_string(quote_xml(Text_).encode(ExternalEncoding), input_name='Text'), namespace_))
        for Code_Example_Language_ in self.Code_Example_Language:
            showIndent(outfile, level)
            outfile.write('<%sCode_Example_Language>%s</%sCode_Example_Language>\n' % (namespace_, self.format_string(quote_xml(Code_Example_Language_).encode(ExternalEncoding), input_name='Code_Example_Language'), namespace_))
        for Code_ in self.Code:
            showIndent(outfile, level)
            outfile.write('<%sCode>%s</%sCode>\n' % (namespace_, self.format_string(quote_xml(Code_).encode(ExternalEncoding), input_name='Code'), namespace_))
        if self.Images:
            self.Images.export(outfile, level, namespace_, name_='Images')
        for Block_ in self.Block:
            Block_.export(outfile, level, namespace_, name_='Block')
    def hasContent_(self):
        if (
            self.Text_Title or
            self.Text or
            self.Code_Example_Language or
            self.Code or
            self.Images is not None or
            self.Block
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StructuredTextType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Text_Title=[\n')
        level += 1
        for Text_Title_ in self.Text_Title:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Text_Title_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Text=[\n')
        level += 1
        for Text_ in self.Text:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Text_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Code_Example_Language=[\n')
        level += 1
        for Code_Example_Language_ in self.Code_Example_Language:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Code_Example_Language_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Code=[\n')
        level += 1
        for Code_ in self.Code:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Code_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Images is not None:
            showIndent(outfile, level)
            outfile.write('Images=model_.Images(\n')
            self.Images.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Block=[\n')
        level += 1
        for Block_ in self.Block:
            showIndent(outfile, level)
            outfile.write('model_.Block(\n')
            Block_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Text_Title':
            Text_Title_ = ''
            for text__content_ in child_.childNodes:
                Text_Title_ += text__content_.nodeValue
            self.Text_Title.append(Text_Title_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Text':
            Text_ = ''
            for text__content_ in child_.childNodes:
                Text_ += text__content_.nodeValue
            self.Text.append(Text_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Code_Example_Language':
            Code_Example_Language_ = ''
            for text__content_ in child_.childNodes:
                Code_Example_Language_ += text__content_.nodeValue
            self.Code_Example_Language.append(Code_Example_Language_)
            self.validate_Code_Example_Language(self.Code_Example_Language)    # validate type Code_Example_Language
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Code':
            Code_ = ''
            for text__content_ in child_.childNodes:
                Code_ += text__content_.nodeValue
            self.Code.append(Code_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Images':
            obj_ = Images.factory()
            obj_.build(child_)
            self.set_Images(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Block':
            obj_ = Block.factory()
            obj_.build(child_)
            self.Block.append(obj_)
# end class StructuredTextType


class Images(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Image=None):
        if Image is None:
            self.Image = []
        else:
            self.Image = Image
    def factory(*args_, **kwargs_):
        if Images.subclass:
            return Images.subclass(*args_, **kwargs_)
        else:
            return Images(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Image(self): return self.Image
    def set_Image(self, Image): self.Image = Image
    def add_Image(self, value): self.Image.append(value)
    def insert_Image(self, index, value): self.Image[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Images', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Images')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Images'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Images'):
        for Image_ in self.Image:
            Image_.export(outfile, level, namespace_, name_='Image')
    def hasContent_(self):
        if (
            self.Image
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Images'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Image=[\n')
        level += 1
        for Image_ in self.Image:
            showIndent(outfile, level)
            outfile.write('model_.Image(\n')
            Image_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Image':
            obj_ = Image.factory()
            obj_.build(child_)
            self.Image.append(obj_)
# end class Images


class Image(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Image_Location=None, Image_Title=None):
        self.Image_Location = Image_Location
        self.Image_Title = Image_Title
    def factory(*args_, **kwargs_):
        if Image.subclass:
            return Image.subclass(*args_, **kwargs_)
        else:
            return Image(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Image_Location(self): return self.Image_Location
    def set_Image_Location(self, Image_Location): self.Image_Location = Image_Location
    def get_Image_Title(self): return self.Image_Title
    def set_Image_Title(self, Image_Title): self.Image_Title = Image_Title
    def export(self, outfile, level, namespace_='maec:', name_='Image', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Image')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Image'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Image'):
        if self.Image_Location is not None:
            showIndent(outfile, level)
            outfile.write('<%sImage_Location>%s</%sImage_Location>\n' % (namespace_, self.format_string(quote_xml(self.Image_Location).encode(ExternalEncoding), input_name='Image_Location'), namespace_))
        if self.Image_Title is not None:
            showIndent(outfile, level)
            outfile.write('<%sImage_Title>%s</%sImage_Title>\n' % (namespace_, self.format_string(quote_xml(self.Image_Title).encode(ExternalEncoding), input_name='Image_Title'), namespace_))
    def hasContent_(self):
        if (
            self.Image_Location is not None or
            self.Image_Title is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Image'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Image_Location is not None:
            showIndent(outfile, level)
            outfile.write('Image_Location=%s,\n' % quote_python(self.Image_Location).encode(ExternalEncoding))
        if self.Image_Title is not None:
            showIndent(outfile, level)
            outfile.write('Image_Title=%s,\n' % quote_python(self.Image_Title).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Image_Location':
            Image_Location_ = ''
            for text__content_ in child_.childNodes:
                Image_Location_ += text__content_.nodeValue
            self.Image_Location = Image_Location_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Image_Title':
            Image_Title_ = ''
            for text__content_ in child_.childNodes:
                Image_Title_ += text__content_.nodeValue
            self.Image_Title = Image_Title_
# end class Image


class Block(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Block_Nature=None, Structured_Text_Group=None, Block=None):
        self.Block_Nature = _cast(None, Block_Nature)
        self.Structured_Text_Group = Structured_Text_Group
        if Block is None:
            self.Block = []
        else:
            self.Block = Block
    def factory(*args_, **kwargs_):
        if Block.subclass:
            return Block.subclass(*args_, **kwargs_)
        else:
            return Block(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Structured_Text_Group(self): return self.Structured_Text_Group
    def set_Structured_Text_Group(self, Structured_Text_Group): self.Structured_Text_Group = Structured_Text_Group
    def get_Block(self): return self.Block
    def set_Block(self, Block): self.Block = Block
    def add_Block(self, value): self.Block.append(value)
    def insert_Block(self, index, value): self.Block[index] = value
    def get_Block_Nature(self): return self.Block_Nature
    def set_Block_Nature(self, Block_Nature): self.Block_Nature = Block_Nature
    def export(self, outfile, level, namespace_='maec:', name_='Block', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Block')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Block'):
        if self.Block_Nature is not None:
            outfile.write(' Block_Nature=%s' % (self.format_string(quote_attrib(self.Block_Nature).encode(ExternalEncoding), input_name='Block_Nature'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Block'):
        if self.Structured_Text_Group is not None:
            showIndent(outfile, level)
            outfile.write('<%sStructured_Text_Group>%s</%sStructured_Text_Group>\n' % (namespace_, self.format_string(quote_xml(self.Structured_Text_Group).encode(ExternalEncoding), input_name='Structured_Text_Group'), namespace_))
        for Block_ in self.Block:
            Block_.export(outfile, level, namespace_, name_='Block')
    def hasContent_(self):
        if (
            self.Structured_Text_Group is not None or
            self.Block
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Block'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.Block_Nature is not None:
            showIndent(outfile, level)
            outfile.write('Block_Nature = "%s",\n' % (self.Block_Nature,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Structured_Text_Group is not None:
            showIndent(outfile, level)
            outfile.write('Structured_Text_Group=%s,\n' % quote_python(self.Structured_Text_Group).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('Block=[\n')
        level += 1
        for Block_ in self.Block:
            showIndent(outfile, level)
            outfile.write('model_.Block(\n')
            Block_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('Block_Nature'):
            self.Block_Nature = attrs.get('Block_Nature').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Structured_Text_Group':
            Structured_Text_Group_ = ''
            for text__content_ in child_.childNodes:
                Structured_Text_Group_ += text__content_.nodeValue
            self.Structured_Text_Group = Structured_Text_Group_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Block':
            obj_ = Block.factory()
            obj_.build(child_)
            self.Block.append(obj_)
# end class Block


class ActionImplementationType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, id=None, API_Call=None, Code=None, Platform=None, Data_Read=None, Data_Written=None, File_System_Action_Attributes=None, IPC_Action_Attributes=None, Process_Action_Attributes=None, Memory_Action_Attributes=None, Registry_Action_Attributes=None, Network_Action_Attributes=None, Module_Action_Attributes=None, Daemon_Action_Attributes=None, System_Action_Attributes=None, Internet_Action_Attributes=None):
        self.type_ = _cast(None, type_)
        self.id = _cast(None, id)
        self.API_Call = API_Call
        if Code is None:
            self.Code = []
        else:
            self.Code = Code
        self.Platform = Platform
        self.Data_Read = Data_Read
        self.Data_Written = Data_Written
        self.File_System_Action_Attributes = File_System_Action_Attributes
        self.IPC_Action_Attributes = IPC_Action_Attributes
        self.Process_Action_Attributes = Process_Action_Attributes
        self.Memory_Action_Attributes = Memory_Action_Attributes
        self.Registry_Action_Attributes = Registry_Action_Attributes
        self.Network_Action_Attributes = Network_Action_Attributes
        self.Module_Action_Attributes = Module_Action_Attributes
        self.Daemon_Action_Attributes = Daemon_Action_Attributes
        self.System_Action_Attributes = System_Action_Attributes
        self.Internet_Action_Attributes = Internet_Action_Attributes
    def factory(*args_, **kwargs_):
        if ActionImplementationType.subclass:
            return ActionImplementationType.subclass(*args_, **kwargs_)
        else:
            return ActionImplementationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_API_Call(self): return self.API_Call
    def set_API_Call(self, API_Call): self.API_Call = API_Call
    def get_Code(self): return self.Code
    def set_Code(self, Code): self.Code = Code
    def add_Code(self, value): self.Code.append(value)
    def insert_Code(self, index, value): self.Code[index] = value
    def get_Platform(self): return self.Platform
    def set_Platform(self, Platform): self.Platform = Platform
    def get_Data_Read(self): return self.Data_Read
    def set_Data_Read(self, Data_Read): self.Data_Read = Data_Read
    def get_Data_Written(self): return self.Data_Written
    def set_Data_Written(self, Data_Written): self.Data_Written = Data_Written
    def get_File_System_Action_Attributes(self): return self.File_System_Action_Attributes
    def set_File_System_Action_Attributes(self, File_System_Action_Attributes): self.File_System_Action_Attributes = File_System_Action_Attributes
    def get_IPC_Action_Attributes(self): return self.IPC_Action_Attributes
    def set_IPC_Action_Attributes(self, IPC_Action_Attributes): self.IPC_Action_Attributes = IPC_Action_Attributes
    def get_Process_Action_Attributes(self): return self.Process_Action_Attributes
    def set_Process_Action_Attributes(self, Process_Action_Attributes): self.Process_Action_Attributes = Process_Action_Attributes
    def get_Memory_Action_Attributes(self): return self.Memory_Action_Attributes
    def set_Memory_Action_Attributes(self, Memory_Action_Attributes): self.Memory_Action_Attributes = Memory_Action_Attributes
    def get_Registry_Action_Attributes(self): return self.Registry_Action_Attributes
    def set_Registry_Action_Attributes(self, Registry_Action_Attributes): self.Registry_Action_Attributes = Registry_Action_Attributes
    def get_Network_Action_Attributes(self): return self.Network_Action_Attributes
    def set_Network_Action_Attributes(self, Network_Action_Attributes): self.Network_Action_Attributes = Network_Action_Attributes
    def get_Module_Action_Attributes(self): return self.Module_Action_Attributes
    def set_Module_Action_Attributes(self, Module_Action_Attributes): self.Module_Action_Attributes = Module_Action_Attributes
    def get_Daemon_Action_Attributes(self): return self.Daemon_Action_Attributes
    def set_Daemon_Action_Attributes(self, Daemon_Action_Attributes): self.Daemon_Action_Attributes = Daemon_Action_Attributes
    def get_System_Action_Attributes(self): return self.System_Action_Attributes
    def set_System_Action_Attributes(self, System_Action_Attributes): self.System_Action_Attributes = System_Action_Attributes
    def get_Internet_Action_Attributes(self): return self.Internet_Action_Attributes
    def set_Internet_Action_Attributes(self, Internet_Action_Attributes): self.Internet_Action_Attributes = Internet_Action_Attributes
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='maec:', name_='ActionImplementationType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='ActionImplementationType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='ActionImplementationType'):
        if self.type_ is not None:
            outfile.write(' type=%s' % (self.format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        outfile.write(' id=%s' % (quote_attrib(self.id), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ActionImplementationType'):
        if self.API_Call:
            self.API_Call.export(outfile, level, namespace_, name_='API_Call')
        for Code_ in self.Code:
            Code_.export(outfile, level, namespace_, name_='Code')
        if self.Platform:
            self.Platform.export(outfile, level, namespace_, name_='Platform')
        if self.Data_Read:
            self.Data_Read.export(outfile, level, namespace_, name_='Data_Read')
        if self.Data_Written:
            self.Data_Written.export(outfile, level, namespace_, name_='Data_Written')
        if self.File_System_Action_Attributes:
            self.File_System_Action_Attributes.export(outfile, level, namespace_, name_='File_System_Action_Attributes')
        if self.IPC_Action_Attributes:
            self.IPC_Action_Attributes.export(outfile, level, namespace_, name_='IPC_Action_Attributes')
        if self.Process_Action_Attributes:
            self.Process_Action_Attributes.export(outfile, level, namespace_, name_='Process_Action_Attributes')
        if self.Memory_Action_Attributes:
            self.Memory_Action_Attributes.export(outfile, level, namespace_, name_='Memory_Action_Attributes')
        if self.Registry_Action_Attributes:
            self.Registry_Action_Attributes.export(outfile, level, namespace_, name_='Registry_Action_Attributes')
        if self.Network_Action_Attributes:
            self.Network_Action_Attributes.export(outfile, level, namespace_, name_='Network_Action_Attributes')
        if self.Module_Action_Attributes:
            self.Module_Action_Attributes.export(outfile, level, namespace_, name_='Module_Action_Attributes')
        if self.Daemon_Action_Attributes:
            self.Daemon_Action_Attributes.export(outfile, level, namespace_, name_='Daemon_Action_Attributes')
        if self.System_Action_Attributes:
            self.System_Action_Attributes.export(outfile, level, namespace_, name_='System_Action_Attributes')
        if self.Internet_Action_Attributes:
            self.Internet_Action_Attributes.export(outfile, level, namespace_, name_='Internet_Action_Attributes')
    def hasContent_(self):
        if (
            self.API_Call is not None or
            self.Code or
            self.Platform is not None or
            self.Data_Read is not None or
            self.Data_Written is not None or
            self.File_System_Action_Attributes is not None or
            self.IPC_Action_Attributes is not None or
            self.Process_Action_Attributes is not None or
            self.Memory_Action_Attributes is not None or
            self.Registry_Action_Attributes is not None or
            self.Network_Action_Attributes is not None or
            self.Module_Action_Attributes is not None or
            self.Daemon_Action_Attributes is not None or
            self.System_Action_Attributes is not None or
            self.Internet_Action_Attributes is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ActionImplementationType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.API_Call is not None:
            showIndent(outfile, level)
            outfile.write('API_Call=model_.APICallType(\n')
            self.API_Call.exportLiteral(outfile, level, name_='API_Call')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Code=[\n')
        level += 1
        for Code_ in self.Code:
            showIndent(outfile, level)
            outfile.write('model_.CodeType(\n')
            Code_.exportLiteral(outfile, level, name_='CodeType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Platform is not None:
            showIndent(outfile, level)
            outfile.write('Platform=model_.CPESpecificationType(\n')
            self.Platform.exportLiteral(outfile, level, name_='Platform')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Data_Read is not None:
            showIndent(outfile, level)
            outfile.write('Data_Read=model_.DataType(\n')
            self.Data_Read.exportLiteral(outfile, level, name_='Data_Read')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Data_Written is not None:
            showIndent(outfile, level)
            outfile.write('Data_Written=model_.DataType(\n')
            self.Data_Written.exportLiteral(outfile, level, name_='Data_Written')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.File_System_Action_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('File_System_Action_Attributes=model_.File_System_Action_Attributes(\n')
            self.File_System_Action_Attributes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IPC_Action_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('IPC_Action_Attributes=model_.IPC_Action_Attributes(\n')
            self.IPC_Action_Attributes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Process_Action_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Process_Action_Attributes=model_.Process_Action_Attributes(\n')
            self.Process_Action_Attributes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Memory_Action_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Memory_Action_Attributes=model_.Memory_Action_Attributes(\n')
            self.Memory_Action_Attributes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Registry_Action_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Registry_Action_Attributes=model_.Registry_Action_Attributes(\n')
            self.Registry_Action_Attributes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Network_Action_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Network_Action_Attributes=model_.Network_Action_Attributes(\n')
            self.Network_Action_Attributes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Module_Action_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Module_Action_Attributes=model_.Module_Action_Attributes(\n')
            self.Module_Action_Attributes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Daemon_Action_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Daemon_Action_Attributes=model_.Daemon_Action_Attributes(\n')
            self.Daemon_Action_Attributes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.System_Action_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('System_Action_Attributes=model_.System_Action_Attributes(\n')
            self.System_Action_Attributes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Internet_Action_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('Internet_Action_Attributes=model_.Internet_Action_Attributes(\n')
            self.Internet_Action_Attributes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('type'):
            self.type_ = attrs.get('type').value
        if attrs.get('id'):
            self.id = attrs.get('id').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'API_Call':
            obj_ = APICallType.factory()
            obj_.build(child_)
            self.set_API_Call(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Code':
            obj_ = CodeType.factory()
            obj_.build(child_)
            self.Code.append(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Platform':
            obj_ = CPESpecificationType.factory()
            obj_.build(child_)
            self.set_Platform(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Data_Read':
            obj_ = DataType.factory()
            obj_.build(child_)
            self.set_Data_Read(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Data_Written':
            obj_ = DataType.factory()
            obj_.build(child_)
            self.set_Data_Written(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'File_System_Action_Attributes':
            obj_ = File_System_Action_Attributes.factory()
            obj_.build(child_)
            self.set_File_System_Action_Attributes(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'IPC_Action_Attributes':
            obj_ = IPC_Action_Attributes.factory()
            obj_.build(child_)
            self.set_IPC_Action_Attributes(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Process_Action_Attributes':
            obj_ = Process_Action_Attributes.factory()
            obj_.build(child_)
            self.set_Process_Action_Attributes(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Memory_Action_Attributes':
            obj_ = Memory_Action_Attributes.factory()
            obj_.build(child_)
            self.set_Memory_Action_Attributes(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Registry_Action_Attributes':
            obj_ = Registry_Action_Attributes.factory()
            obj_.build(child_)
            self.set_Registry_Action_Attributes(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Network_Action_Attributes':
            obj_ = Network_Action_Attributes.factory()
            obj_.build(child_)
            self.set_Network_Action_Attributes(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Module_Action_Attributes':
            obj_ = Module_Action_Attributes.factory()
            obj_.build(child_)
            self.set_Module_Action_Attributes(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Daemon_Action_Attributes':
            obj_ = Daemon_Action_Attributes.factory()
            obj_.build(child_)
            self.set_Daemon_Action_Attributes(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'System_Action_Attributes':
            obj_ = System_Action_Attributes.factory()
            obj_.build(child_)
            self.set_System_Action_Attributes(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Internet_Action_Attributes':
            obj_ = Internet_Action_Attributes.factory()
            obj_.build(child_)
            self.set_Internet_Action_Attributes(obj_)
# end class ActionImplementationType


class File_System_Action_Attributes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Existing_File_Name=None, Destination_File_Name=None, Access_Mode=None, Flags=None, Open_Mode=None, File_Attributes=None):
        self.Existing_File_Name = Existing_File_Name
        self.Destination_File_Name = Destination_File_Name
        self.Access_Mode = Access_Mode
        self.Flags = Flags
        self.Open_Mode = Open_Mode
        self.File_Attributes = File_Attributes
    def factory(*args_, **kwargs_):
        if File_System_Action_Attributes.subclass:
            return File_System_Action_Attributes.subclass(*args_, **kwargs_)
        else:
            return File_System_Action_Attributes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Existing_File_Name(self): return self.Existing_File_Name
    def set_Existing_File_Name(self, Existing_File_Name): self.Existing_File_Name = Existing_File_Name
    def get_Destination_File_Name(self): return self.Destination_File_Name
    def set_Destination_File_Name(self, Destination_File_Name): self.Destination_File_Name = Destination_File_Name
    def get_Access_Mode(self): return self.Access_Mode
    def set_Access_Mode(self, Access_Mode): self.Access_Mode = Access_Mode
    def get_Flags(self): return self.Flags
    def set_Flags(self, Flags): self.Flags = Flags
    def get_Open_Mode(self): return self.Open_Mode
    def set_Open_Mode(self, Open_Mode): self.Open_Mode = Open_Mode
    def get_File_Attributes(self): return self.File_Attributes
    def set_File_Attributes(self, File_Attributes): self.File_Attributes = File_Attributes
    def export(self, outfile, level, namespace_='maec:', name_='File_System_Action_Attributes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='File_System_Action_Attributes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='File_System_Action_Attributes'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='File_System_Action_Attributes'):
        if self.Existing_File_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sExisting_File_Name>%s</%sExisting_File_Name>\n' % (namespace_, self.format_string(quote_xml(self.Existing_File_Name).encode(ExternalEncoding), input_name='Existing_File_Name'), namespace_))
        if self.Destination_File_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sDestination_File_Name>%s</%sDestination_File_Name>\n' % (namespace_, self.format_string(quote_xml(self.Destination_File_Name).encode(ExternalEncoding), input_name='Destination_File_Name'), namespace_))
        if self.Access_Mode is not None:
            showIndent(outfile, level)
            outfile.write('<%sAccess_Mode>%s</%sAccess_Mode>\n' % (namespace_, self.format_string(quote_xml(self.Access_Mode).encode(ExternalEncoding), input_name='Access_Mode'), namespace_))
        if self.Flags is not None:
            showIndent(outfile, level)
            outfile.write('<%sFlags>%s</%sFlags>\n' % (namespace_, self.format_string(quote_xml(self.Flags).encode(ExternalEncoding), input_name='Flags'), namespace_))
        if self.Open_Mode is not None:
            showIndent(outfile, level)
            outfile.write('<%sOpen_Mode>%s</%sOpen_Mode>\n' % (namespace_, self.format_string(quote_xml(self.Open_Mode).encode(ExternalEncoding), input_name='Open_Mode'), namespace_))
        if self.File_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('<%sFile_Attributes>%s</%sFile_Attributes>\n' % (namespace_, self.format_string(quote_xml(self.File_Attributes).encode(ExternalEncoding), input_name='File_Attributes'), namespace_))
    def hasContent_(self):
        if (
            self.Existing_File_Name is not None or
            self.Destination_File_Name is not None or
            self.Access_Mode is not None or
            self.Flags is not None or
            self.Open_Mode is not None or
            self.File_Attributes is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='File_System_Action_Attributes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Existing_File_Name is not None:
            showIndent(outfile, level)
            outfile.write('Existing_File_Name=%s,\n' % quote_python(self.Existing_File_Name).encode(ExternalEncoding))
        if self.Destination_File_Name is not None:
            showIndent(outfile, level)
            outfile.write('Destination_File_Name=%s,\n' % quote_python(self.Destination_File_Name).encode(ExternalEncoding))
        if self.Access_Mode is not None:
            showIndent(outfile, level)
            outfile.write('Access_Mode=%s,\n' % quote_python(self.Access_Mode).encode(ExternalEncoding))
        if self.Flags is not None:
            showIndent(outfile, level)
            outfile.write('Flags=%s,\n' % quote_python(self.Flags).encode(ExternalEncoding))
        if self.Open_Mode is not None:
            showIndent(outfile, level)
            outfile.write('Open_Mode=%s,\n' % quote_python(self.Open_Mode).encode(ExternalEncoding))
        if self.File_Attributes is not None:
            showIndent(outfile, level)
            outfile.write('File_Attributes=%s,\n' % quote_python(self.File_Attributes).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Existing_File_Name':
            Existing_File_Name_ = ''
            for text__content_ in child_.childNodes:
                Existing_File_Name_ += text__content_.nodeValue
            self.Existing_File_Name = Existing_File_Name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Destination_File_Name':
            Destination_File_Name_ = ''
            for text__content_ in child_.childNodes:
                Destination_File_Name_ += text__content_.nodeValue
            self.Destination_File_Name = Destination_File_Name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Access_Mode':
            Access_Mode_ = ''
            for text__content_ in child_.childNodes:
                Access_Mode_ += text__content_.nodeValue
            self.Access_Mode = Access_Mode_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Flags':
            Flags_ = ''
            for text__content_ in child_.childNodes:
                Flags_ += text__content_.nodeValue
            self.Flags = Flags_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Open_Mode':
            Open_Mode_ = ''
            for text__content_ in child_.childNodes:
                Open_Mode_ += text__content_.nodeValue
            self.Open_Mode = Open_Mode_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'File_Attributes':
            File_Attributes_ = ''
            for text__content_ in child_.childNodes:
                File_Attributes_ += text__content_.nodeValue
            self.File_Attributes = File_Attributes_
# end class File_System_Action_Attributes


class IPC_Action_Attributes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Initial_Owner=None, Thread_ID=None, Target_PID=None, Start_Address=None):
        self.Initial_Owner = Initial_Owner
        self.Thread_ID = Thread_ID
        self.Target_PID = Target_PID
        self.Start_Address = Start_Address
    def factory(*args_, **kwargs_):
        if IPC_Action_Attributes.subclass:
            return IPC_Action_Attributes.subclass(*args_, **kwargs_)
        else:
            return IPC_Action_Attributes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Initial_Owner(self): return self.Initial_Owner
    def set_Initial_Owner(self, Initial_Owner): self.Initial_Owner = Initial_Owner
    def get_Thread_ID(self): return self.Thread_ID
    def set_Thread_ID(self, Thread_ID): self.Thread_ID = Thread_ID
    def get_Target_PID(self): return self.Target_PID
    def set_Target_PID(self, Target_PID): self.Target_PID = Target_PID
    def get_Start_Address(self): return self.Start_Address
    def set_Start_Address(self, Start_Address): self.Start_Address = Start_Address
    def export(self, outfile, level, namespace_='maec:', name_='IPC_Action_Attributes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='IPC_Action_Attributes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='IPC_Action_Attributes'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='IPC_Action_Attributes'):
        if self.Initial_Owner is not None:
            showIndent(outfile, level)
            outfile.write('<%sInitial_Owner>%s</%sInitial_Owner>\n' % (namespace_, self.format_string(quote_xml(self.Initial_Owner).encode(ExternalEncoding), input_name='Initial_Owner'), namespace_))
        if self.Thread_ID is not None:
            showIndent(outfile, level)
            outfile.write('<%sThread_ID>%s</%sThread_ID>\n' % (namespace_, self.format_integer(self.Thread_ID, input_name='Thread_ID'), namespace_))
        if self.Target_PID is not None:
            showIndent(outfile, level)
            outfile.write('<%sTarget_PID>%s</%sTarget_PID>\n' % (namespace_, self.format_integer(self.Target_PID, input_name='Target_PID'), namespace_))
        if self.Start_Address is not None:
            showIndent(outfile, level)
            outfile.write('<%sStart_Address>%s</%sStart_Address>\n' % (namespace_, self.format_string(quote_xml(self.Start_Address).encode(ExternalEncoding), input_name='Start_Address'), namespace_))
    def hasContent_(self):
        if (
            self.Initial_Owner is not None or
            self.Thread_ID is not None or
            self.Target_PID is not None or
            self.Start_Address is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='IPC_Action_Attributes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Initial_Owner is not None:
            showIndent(outfile, level)
            outfile.write('Initial_Owner=%s,\n' % quote_python(self.Initial_Owner).encode(ExternalEncoding))
        if self.Thread_ID is not None:
            showIndent(outfile, level)
            outfile.write('Thread_ID=%d,\n' % self.Thread_ID)
        if self.Target_PID is not None:
            showIndent(outfile, level)
            outfile.write('Target_PID=%d,\n' % self.Target_PID)
        if self.Start_Address is not None:
            showIndent(outfile, level)
            outfile.write('Start_Address=%s,\n' % quote_python(self.Start_Address).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Initial_Owner':
            Initial_Owner_ = ''
            for text__content_ in child_.childNodes:
                Initial_Owner_ += text__content_.nodeValue
            self.Initial_Owner = Initial_Owner_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Thread_ID':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError as exp:
                    raise ValueError('requires integer (Thread_ID): %s' % exp)
                self.Thread_ID = ival_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Target_PID':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError as exp:
                    raise ValueError('requires integer (Target_PID): %s' % exp)
                self.Target_PID = ival_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Start_Address':
            Start_Address_ = ''
            for text__content_ in child_.childNodes:
                Start_Address_ += text__content_.nodeValue
            self.Start_Address = Start_Address_
# end class IPC_Action_Attributes


class Process_Action_Attributes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Process_Base_Address=None, Thread_ID=None, Start_Address=None, Creation_Flags=None, User_Name=None, Target_PID=None):
        self.Process_Base_Address = Process_Base_Address
        self.Thread_ID = Thread_ID
        self.Start_Address = Start_Address
        self.Creation_Flags = Creation_Flags
        self.User_Name = User_Name
        self.Target_PID = Target_PID
    def factory(*args_, **kwargs_):
        if Process_Action_Attributes.subclass:
            return Process_Action_Attributes.subclass(*args_, **kwargs_)
        else:
            return Process_Action_Attributes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Process_Base_Address(self): return self.Process_Base_Address
    def set_Process_Base_Address(self, Process_Base_Address): self.Process_Base_Address = Process_Base_Address
    def get_Thread_ID(self): return self.Thread_ID
    def set_Thread_ID(self, Thread_ID): self.Thread_ID = Thread_ID
    def get_Start_Address(self): return self.Start_Address
    def set_Start_Address(self, Start_Address): self.Start_Address = Start_Address
    def get_Creation_Flags(self): return self.Creation_Flags
    def set_Creation_Flags(self, Creation_Flags): self.Creation_Flags = Creation_Flags
    def get_User_Name(self): return self.User_Name
    def set_User_Name(self, User_Name): self.User_Name = User_Name
    def get_Target_PID(self): return self.Target_PID
    def set_Target_PID(self, Target_PID): self.Target_PID = Target_PID
    def export(self, outfile, level, namespace_='maec:', name_='Process_Action_Attributes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Process_Action_Attributes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Process_Action_Attributes'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Process_Action_Attributes'):
        if self.Process_Base_Address is not None:
            showIndent(outfile, level)
            outfile.write('<%sProcess_Base_Address>%s</%sProcess_Base_Address>\n' % (namespace_, self.format_string(quote_xml(self.Process_Base_Address).encode(ExternalEncoding), input_name='Process_Base_Address'), namespace_))
        if self.Thread_ID is not None:
            showIndent(outfile, level)
            outfile.write('<%sThread_ID>%s</%sThread_ID>\n' % (namespace_, self.format_string(quote_xml(self.Thread_ID).encode(ExternalEncoding), input_name='Thread_ID'), namespace_))
        if self.Start_Address is not None:
            showIndent(outfile, level)
            outfile.write('<%sStart_Address>%s</%sStart_Address>\n' % (namespace_, self.format_string(quote_xml(self.Start_Address).encode(ExternalEncoding), input_name='Start_Address'), namespace_))
        if self.Creation_Flags is not None:
            showIndent(outfile, level)
            outfile.write('<%sCreation_Flags>%s</%sCreation_Flags>\n' % (namespace_, self.format_string(quote_xml(self.Creation_Flags).encode(ExternalEncoding), input_name='Creation_Flags'), namespace_))
        if self.User_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sUser_Name>%s</%sUser_Name>\n' % (namespace_, self.format_string(quote_xml(self.User_Name).encode(ExternalEncoding), input_name='User_Name'), namespace_))
        if self.Target_PID is not None:
            showIndent(outfile, level)
            outfile.write('<%sTarget_PID>%s</%sTarget_PID>\n' % (namespace_, self.format_integer(self.Target_PID, input_name='Target_PID'), namespace_))
    def hasContent_(self):
        if (
            self.Process_Base_Address is not None or
            self.Thread_ID is not None or
            self.Start_Address is not None or
            self.Creation_Flags is not None or
            self.User_Name is not None or
            self.Target_PID is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Process_Action_Attributes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Process_Base_Address is not None:
            showIndent(outfile, level)
            outfile.write('Process_Base_Address=%s,\n' % quote_python(self.Process_Base_Address).encode(ExternalEncoding))
        if self.Thread_ID is not None:
            showIndent(outfile, level)
            outfile.write('Thread_ID=%s,\n' % quote_python(self.Thread_ID).encode(ExternalEncoding))
        if self.Start_Address is not None:
            showIndent(outfile, level)
            outfile.write('Start_Address=%s,\n' % quote_python(self.Start_Address).encode(ExternalEncoding))
        if self.Creation_Flags is not None:
            showIndent(outfile, level)
            outfile.write('Creation_Flags=%s,\n' % quote_python(self.Creation_Flags).encode(ExternalEncoding))
        if self.User_Name is not None:
            showIndent(outfile, level)
            outfile.write('User_Name=%s,\n' % quote_python(self.User_Name).encode(ExternalEncoding))
        if self.Target_PID is not None:
            showIndent(outfile, level)
            outfile.write('Target_PID=%d,\n' % self.Target_PID)
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Process_Base_Address':
            Process_Base_Address_ = ''
            for text__content_ in child_.childNodes:
                Process_Base_Address_ += text__content_.nodeValue
            self.Process_Base_Address = Process_Base_Address_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Thread_ID':
            Thread_ID_ = ''
            for text__content_ in child_.childNodes:
                Thread_ID_ += text__content_.nodeValue
            self.Thread_ID = Thread_ID_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Start_Address':
            Start_Address_ = ''
            for text__content_ in child_.childNodes:
                Start_Address_ += text__content_.nodeValue
            self.Start_Address = Start_Address_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Creation_Flags':
            Creation_Flags_ = ''
            for text__content_ in child_.childNodes:
                Creation_Flags_ += text__content_.nodeValue
            self.Creation_Flags = Creation_Flags_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'User_Name':
            User_Name_ = ''
            for text__content_ in child_.childNodes:
                User_Name_ += text__content_.nodeValue
            self.User_Name = User_Name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Target_PID':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError as exp:
                    raise ValueError('requires integer (Target_PID): %s' % exp)
                self.Target_PID = ival_
# end class Process_Action_Attributes


class Memory_Action_Attributes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Start_Address=None, Source_Address=None, Destination_Address=None, Page_Base_Address=None, Target_PID=None, Requested_Address=None):
        self.Start_Address = Start_Address
        self.Source_Address = Source_Address
        self.Destination_Address = Destination_Address
        self.Page_Base_Address = Page_Base_Address
        self.Target_PID = Target_PID
        self.Requested_Address = Requested_Address
    def factory(*args_, **kwargs_):
        if Memory_Action_Attributes.subclass:
            return Memory_Action_Attributes.subclass(*args_, **kwargs_)
        else:
            return Memory_Action_Attributes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Start_Address(self): return self.Start_Address
    def set_Start_Address(self, Start_Address): self.Start_Address = Start_Address
    def get_Source_Address(self): return self.Source_Address
    def set_Source_Address(self, Source_Address): self.Source_Address = Source_Address
    def get_Destination_Address(self): return self.Destination_Address
    def set_Destination_Address(self, Destination_Address): self.Destination_Address = Destination_Address
    def get_Page_Base_Address(self): return self.Page_Base_Address
    def set_Page_Base_Address(self, Page_Base_Address): self.Page_Base_Address = Page_Base_Address
    def get_Target_PID(self): return self.Target_PID
    def set_Target_PID(self, Target_PID): self.Target_PID = Target_PID
    def get_Requested_Address(self): return self.Requested_Address
    def set_Requested_Address(self, Requested_Address): self.Requested_Address = Requested_Address
    def export(self, outfile, level, namespace_='maec:', name_='Memory_Action_Attributes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Memory_Action_Attributes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Memory_Action_Attributes'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Memory_Action_Attributes'):
        if self.Start_Address is not None:
            showIndent(outfile, level)
            outfile.write('<%sStart_Address>%s</%sStart_Address>\n' % (namespace_, self.format_string(quote_xml(self.Start_Address).encode(ExternalEncoding), input_name='Start_Address'), namespace_))
        if self.Source_Address is not None:
            showIndent(outfile, level)
            outfile.write('<%sSource_Address>%s</%sSource_Address>\n' % (namespace_, self.format_string(quote_xml(self.Source_Address).encode(ExternalEncoding), input_name='Source_Address'), namespace_))
        if self.Destination_Address is not None:
            showIndent(outfile, level)
            outfile.write('<%sDestination_Address>%s</%sDestination_Address>\n' % (namespace_, self.format_string(quote_xml(self.Destination_Address).encode(ExternalEncoding), input_name='Destination_Address'), namespace_))
        if self.Page_Base_Address is not None:
            showIndent(outfile, level)
            outfile.write('<%sPage_Base_Address>%s</%sPage_Base_Address>\n' % (namespace_, self.format_string(quote_xml(self.Page_Base_Address).encode(ExternalEncoding), input_name='Page_Base_Address'), namespace_))
        if self.Target_PID is not None:
            showIndent(outfile, level)
            outfile.write('<%sTarget_PID>%s</%sTarget_PID>\n' % (namespace_, self.format_integer(self.Target_PID, input_name='Target_PID'), namespace_))
        if self.Requested_Address is not None:
            showIndent(outfile, level)
            outfile.write('<%sRequested_Address>%s</%sRequested_Address>\n' % (namespace_, self.format_string(quote_xml(self.Requested_Address).encode(ExternalEncoding), input_name='Requested_Address'), namespace_))
    def hasContent_(self):
        if (
            self.Start_Address is not None or
            self.Source_Address is not None or
            self.Destination_Address is not None or
            self.Page_Base_Address is not None or
            self.Target_PID is not None or
            self.Requested_Address is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Memory_Action_Attributes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Start_Address is not None:
            showIndent(outfile, level)
            outfile.write('Start_Address=%s,\n' % quote_python(self.Start_Address).encode(ExternalEncoding))
        if self.Source_Address is not None:
            showIndent(outfile, level)
            outfile.write('Source_Address=%s,\n' % quote_python(self.Source_Address).encode(ExternalEncoding))
        if self.Destination_Address is not None:
            showIndent(outfile, level)
            outfile.write('Destination_Address=%s,\n' % quote_python(self.Destination_Address).encode(ExternalEncoding))
        if self.Page_Base_Address is not None:
            showIndent(outfile, level)
            outfile.write('Page_Base_Address=%s,\n' % quote_python(self.Page_Base_Address).encode(ExternalEncoding))
        if self.Target_PID is not None:
            showIndent(outfile, level)
            outfile.write('Target_PID=%d,\n' % self.Target_PID)
        if self.Requested_Address is not None:
            showIndent(outfile, level)
            outfile.write('Requested_Address=%s,\n' % quote_python(self.Requested_Address).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Start_Address':
            Start_Address_ = ''
            for text__content_ in child_.childNodes:
                Start_Address_ += text__content_.nodeValue
            self.Start_Address = Start_Address_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Source_Address':
            Source_Address_ = ''
            for text__content_ in child_.childNodes:
                Source_Address_ += text__content_.nodeValue
            self.Source_Address = Source_Address_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Destination_Address':
            Destination_Address_ = ''
            for text__content_ in child_.childNodes:
                Destination_Address_ += text__content_.nodeValue
            self.Destination_Address = Destination_Address_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Page_Base_Address':
            Page_Base_Address_ = ''
            for text__content_ in child_.childNodes:
                Page_Base_Address_ += text__content_.nodeValue
            self.Page_Base_Address = Page_Base_Address_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Target_PID':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError as exp:
                    raise ValueError('requires integer (Target_PID): %s' % exp)
                self.Target_PID = ival_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Requested_Address':
            Requested_Address_ = ''
            for text__content_ in child_.childNodes:
                Requested_Address_ += text__content_.nodeValue
            self.Requested_Address = Requested_Address_
# end class Memory_Action_Attributes


class Registry_Action_Attributes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Enumerated_Subkeys=None, Enumerated_Values=None):
        self.Enumerated_Subkeys = Enumerated_Subkeys
        self.Enumerated_Values = Enumerated_Values
    def factory(*args_, **kwargs_):
        if Registry_Action_Attributes.subclass:
            return Registry_Action_Attributes.subclass(*args_, **kwargs_)
        else:
            return Registry_Action_Attributes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Enumerated_Subkeys(self): return self.Enumerated_Subkeys
    def set_Enumerated_Subkeys(self, Enumerated_Subkeys): self.Enumerated_Subkeys = Enumerated_Subkeys
    def get_Enumerated_Values(self): return self.Enumerated_Values
    def set_Enumerated_Values(self, Enumerated_Values): self.Enumerated_Values = Enumerated_Values
    def export(self, outfile, level, namespace_='maec:', name_='Registry_Action_Attributes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Registry_Action_Attributes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Registry_Action_Attributes'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Registry_Action_Attributes'):
        if self.Enumerated_Subkeys is not None:
            showIndent(outfile, level)
            outfile.write('<%sEnumerated_Subkeys>%s</%sEnumerated_Subkeys>\n' % (namespace_, self.format_string(quote_xml(self.Enumerated_Subkeys).encode(ExternalEncoding), input_name='Enumerated_Subkeys'), namespace_))
        if self.Enumerated_Values is not None:
            showIndent(outfile, level)
            outfile.write('<%sEnumerated_Values>%s</%sEnumerated_Values>\n' % (namespace_, self.format_string(quote_xml(self.Enumerated_Values).encode(ExternalEncoding), input_name='Enumerated_Values'), namespace_))
    def hasContent_(self):
        if (
            self.Enumerated_Subkeys is not None or
            self.Enumerated_Values is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Registry_Action_Attributes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Enumerated_Subkeys is not None:
            showIndent(outfile, level)
            outfile.write('Enumerated_Subkeys=%s,\n' % quote_python(self.Enumerated_Subkeys).encode(ExternalEncoding))
        if self.Enumerated_Values is not None:
            showIndent(outfile, level)
            outfile.write('Enumerated_Values=%s,\n' % quote_python(self.Enumerated_Values).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Enumerated_Subkeys':
            Enumerated_Subkeys_ = ''
            for text__content_ in child_.childNodes:
                Enumerated_Subkeys_ += text__content_.nodeValue
            self.Enumerated_Subkeys = Enumerated_Subkeys_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Enumerated_Values':
            Enumerated_Values_ = ''
            for text__content_ in child_.childNodes:
                Enumerated_Values_ += text__content_.nodeValue
            self.Enumerated_Values = Enumerated_Values_
# end class Registry_Action_Attributes


class Network_Action_Attributes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Internal_Port=None, External_Port=None, Internal_IP_Address=None, External_IP_Address=None, Host_Name=None, Data_Sent=None, Data_Received=None, Buffer_Length=None):
        self.Internal_Port = Internal_Port
        self.External_Port = External_Port
        self.Internal_IP_Address = Internal_IP_Address
        self.External_IP_Address = External_IP_Address
        self.Host_Name = Host_Name
        self.Data_Sent = Data_Sent
        self.Data_Received = Data_Received
        self.Buffer_Length = Buffer_Length
    def factory(*args_, **kwargs_):
        if Network_Action_Attributes.subclass:
            return Network_Action_Attributes.subclass(*args_, **kwargs_)
        else:
            return Network_Action_Attributes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Internal_Port(self): return self.Internal_Port
    def set_Internal_Port(self, Internal_Port): self.Internal_Port = Internal_Port
    def get_External_Port(self): return self.External_Port
    def set_External_Port(self, External_Port): self.External_Port = External_Port
    def get_Internal_IP_Address(self): return self.Internal_IP_Address
    def set_Internal_IP_Address(self, Internal_IP_Address): self.Internal_IP_Address = Internal_IP_Address
    def get_External_IP_Address(self): return self.External_IP_Address
    def set_External_IP_Address(self, External_IP_Address): self.External_IP_Address = External_IP_Address
    def get_Host_Name(self): return self.Host_Name
    def set_Host_Name(self, Host_Name): self.Host_Name = Host_Name
    def get_Data_Sent(self): return self.Data_Sent
    def set_Data_Sent(self, Data_Sent): self.Data_Sent = Data_Sent
    def get_Data_Received(self): return self.Data_Received
    def set_Data_Received(self, Data_Received): self.Data_Received = Data_Received
    def get_Buffer_Length(self): return self.Buffer_Length
    def set_Buffer_Length(self, Buffer_Length): self.Buffer_Length = Buffer_Length
    def export(self, outfile, level, namespace_='maec:', name_='Network_Action_Attributes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Network_Action_Attributes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Network_Action_Attributes'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Network_Action_Attributes'):
        if self.Internal_Port is not None:
            showIndent(outfile, level)
            outfile.write('<%sInternal_Port>%s</%sInternal_Port>\n' % (namespace_, self.format_integer(self.Internal_Port, input_name='Internal_Port'), namespace_))
        if self.External_Port is not None:
            showIndent(outfile, level)
            outfile.write('<%sExternal_Port>%s</%sExternal_Port>\n' % (namespace_, self.format_integer(self.External_Port, input_name='External_Port'), namespace_))
        if self.Internal_IP_Address is not None:
            showIndent(outfile, level)
            outfile.write('<%sInternal_IP_Address>%s</%sInternal_IP_Address>\n' % (namespace_, self.format_string(quote_xml(self.Internal_IP_Address).encode(ExternalEncoding), input_name='Internal_IP_Address'), namespace_))
        if self.External_IP_Address is not None:
            showIndent(outfile, level)
            outfile.write('<%sExternal_IP_Address>%s</%sExternal_IP_Address>\n' % (namespace_, self.format_string(quote_xml(self.External_IP_Address).encode(ExternalEncoding), input_name='External_IP_Address'), namespace_))
        if self.Host_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sHost_Name>%s</%sHost_Name>\n' % (namespace_, self.format_string(quote_xml(self.Host_Name).encode(ExternalEncoding), input_name='Host_Name'), namespace_))
        if self.Data_Sent:
            self.Data_Sent.export(outfile, level, namespace_, name_='Data_Sent')
        if self.Data_Received:
            self.Data_Received.export(outfile, level, namespace_, name_='Data_Received')
        if self.Buffer_Length is not None:
            showIndent(outfile, level)
            outfile.write('<%sBuffer_Length>%s</%sBuffer_Length>\n' % (namespace_, self.format_integer(self.Buffer_Length, input_name='Buffer_Length'), namespace_))
    def hasContent_(self):
        if (
            self.Internal_Port is not None or
            self.External_Port is not None or
            self.Internal_IP_Address is not None or
            self.External_IP_Address is not None or
            self.Host_Name is not None or
            self.Data_Sent is not None or
            self.Data_Received is not None or
            self.Buffer_Length is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Network_Action_Attributes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Internal_Port is not None:
            showIndent(outfile, level)
            outfile.write('Internal_Port=%d,\n' % self.Internal_Port)
        if self.External_Port is not None:
            showIndent(outfile, level)
            outfile.write('External_Port=%d,\n' % self.External_Port)
        if self.Internal_IP_Address is not None:
            showIndent(outfile, level)
            outfile.write('Internal_IP_Address=%s,\n' % quote_python(self.Internal_IP_Address).encode(ExternalEncoding))
        if self.External_IP_Address is not None:
            showIndent(outfile, level)
            outfile.write('External_IP_Address=%s,\n' % quote_python(self.External_IP_Address).encode(ExternalEncoding))
        if self.Host_Name is not None:
            showIndent(outfile, level)
            outfile.write('Host_Name=%s,\n' % quote_python(self.Host_Name).encode(ExternalEncoding))
        if self.Data_Sent is not None:
            showIndent(outfile, level)
            outfile.write('Data_Sent=model_.DataType(\n')
            self.Data_Sent.exportLiteral(outfile, level, name_='Data_Sent')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Data_Received is not None:
            showIndent(outfile, level)
            outfile.write('Data_Received=model_.DataType(\n')
            self.Data_Received.exportLiteral(outfile, level, name_='Data_Received')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Buffer_Length is not None:
            showIndent(outfile, level)
            outfile.write('Buffer_Length=%d,\n' % self.Buffer_Length)
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Internal_Port':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError as exp:
                    raise ValueError('requires integer (Internal_Port): %s' % exp)
                self.Internal_Port = ival_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'External_Port':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError as exp:
                    raise ValueError('requires integer (External_Port): %s' % exp)
                self.External_Port = ival_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Internal_IP_Address':
            Internal_IP_Address_ = ''
            for text__content_ in child_.childNodes:
                Internal_IP_Address_ += text__content_.nodeValue
            self.Internal_IP_Address = Internal_IP_Address_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'External_IP_Address':
            External_IP_Address_ = ''
            for text__content_ in child_.childNodes:
                External_IP_Address_ += text__content_.nodeValue
            self.External_IP_Address = External_IP_Address_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Host_Name':
            Host_Name_ = ''
            for text__content_ in child_.childNodes:
                Host_Name_ += text__content_.nodeValue
            self.Host_Name = Host_Name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Data_Sent':
            obj_ = DataType.factory()
            obj_.build(child_)
            self.set_Data_Sent(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Data_Received':
            obj_ = DataType.factory()
            obj_.build(child_)
            self.set_Data_Received(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Buffer_Length':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError as exp:
                    raise ValueError('requires integer (Buffer_Length): %s' % exp)
                self.Buffer_Length = ival_
# end class Network_Action_Attributes


class Module_Action_Attributes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Function_Name=None, Flags=None):
        self.Function_Name = Function_Name
        self.Flags = Flags
    def factory(*args_, **kwargs_):
        if Module_Action_Attributes.subclass:
            return Module_Action_Attributes.subclass(*args_, **kwargs_)
        else:
            return Module_Action_Attributes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Function_Name(self): return self.Function_Name
    def set_Function_Name(self, Function_Name): self.Function_Name = Function_Name
    def get_Flags(self): return self.Flags
    def set_Flags(self, Flags): self.Flags = Flags
    def export(self, outfile, level, namespace_='maec:', name_='Module_Action_Attributes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Module_Action_Attributes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Module_Action_Attributes'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Module_Action_Attributes'):
        if self.Function_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sFunction_Name>%s</%sFunction_Name>\n' % (namespace_, self.format_string(quote_xml(self.Function_Name).encode(ExternalEncoding), input_name='Function_Name'), namespace_))
        if self.Flags is not None:
            showIndent(outfile, level)
            outfile.write('<%sFlags>%s</%sFlags>\n' % (namespace_, self.format_string(quote_xml(self.Flags).encode(ExternalEncoding), input_name='Flags'), namespace_))
    def hasContent_(self):
        if (
            self.Function_Name is not None or
            self.Flags is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Module_Action_Attributes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Function_Name is not None:
            showIndent(outfile, level)
            outfile.write('Function_Name=%s,\n' % quote_python(self.Function_Name).encode(ExternalEncoding))
        if self.Flags is not None:
            showIndent(outfile, level)
            outfile.write('Flags=%s,\n' % quote_python(self.Flags).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Function_Name':
            Function_Name_ = ''
            for text__content_ in child_.childNodes:
                Function_Name_ += text__content_.nodeValue
            self.Function_Name = Function_Name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Flags':
            Flags_ = ''
            for text__content_ in child_.childNodes:
                Flags_ += text__content_.nodeValue
            self.Flags = Flags_
# end class Module_Action_Attributes


class Daemon_Action_Attributes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Options=None, Start_Type=None, Desired_Access_Type=None, Enumerated_Daemons=None):
        self.Options = Options
        self.Start_Type = Start_Type
        self.Desired_Access_Type = Desired_Access_Type
        self.Enumerated_Daemons = Enumerated_Daemons
    def factory(*args_, **kwargs_):
        if Daemon_Action_Attributes.subclass:
            return Daemon_Action_Attributes.subclass(*args_, **kwargs_)
        else:
            return Daemon_Action_Attributes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Options(self): return self.Options
    def set_Options(self, Options): self.Options = Options
    def get_Start_Type(self): return self.Start_Type
    def set_Start_Type(self, Start_Type): self.Start_Type = Start_Type
    def get_Desired_Access_Type(self): return self.Desired_Access_Type
    def set_Desired_Access_Type(self, Desired_Access_Type): self.Desired_Access_Type = Desired_Access_Type
    def get_Enumerated_Daemons(self): return self.Enumerated_Daemons
    def set_Enumerated_Daemons(self, Enumerated_Daemons): self.Enumerated_Daemons = Enumerated_Daemons
    def export(self, outfile, level, namespace_='maec:', name_='Daemon_Action_Attributes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Daemon_Action_Attributes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Daemon_Action_Attributes'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Daemon_Action_Attributes'):
        if self.Options is not None:
            showIndent(outfile, level)
            outfile.write('<%sOptions>%s</%sOptions>\n' % (namespace_, self.format_string(quote_xml(self.Options).encode(ExternalEncoding), input_name='Options'), namespace_))
        if self.Start_Type is not None:
            showIndent(outfile, level)
            outfile.write('<%sStart_Type>%s</%sStart_Type>\n' % (namespace_, self.format_string(quote_xml(self.Start_Type).encode(ExternalEncoding), input_name='Start_Type'), namespace_))
        if self.Desired_Access_Type is not None:
            showIndent(outfile, level)
            outfile.write('<%sDesired_Access_Type>%s</%sDesired_Access_Type>\n' % (namespace_, self.format_string(quote_xml(self.Desired_Access_Type).encode(ExternalEncoding), input_name='Desired_Access_Type'), namespace_))
        if self.Enumerated_Daemons:
            self.Enumerated_Daemons.export(outfile, level, namespace_, name_='Enumerated_Daemons')
    def hasContent_(self):
        if (
            self.Options is not None or
            self.Start_Type is not None or
            self.Desired_Access_Type is not None or
            self.Enumerated_Daemons is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Daemon_Action_Attributes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Options is not None:
            showIndent(outfile, level)
            outfile.write('Options=%s,\n' % quote_python(self.Options).encode(ExternalEncoding))
        if self.Start_Type is not None:
            showIndent(outfile, level)
            outfile.write('Start_Type=%s,\n' % quote_python(self.Start_Type).encode(ExternalEncoding))
        if self.Desired_Access_Type is not None:
            showIndent(outfile, level)
            outfile.write('Desired_Access_Type=%s,\n' % quote_python(self.Desired_Access_Type).encode(ExternalEncoding))
        if self.Enumerated_Daemons is not None:
            showIndent(outfile, level)
            outfile.write('Enumerated_Daemons=model_.Enumerated_Daemons(\n')
            self.Enumerated_Daemons.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Options':
            Options_ = ''
            for text__content_ in child_.childNodes:
                Options_ += text__content_.nodeValue
            self.Options = Options_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Start_Type':
            Start_Type_ = ''
            for text__content_ in child_.childNodes:
                Start_Type_ += text__content_.nodeValue
            self.Start_Type = Start_Type_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Desired_Access_Type':
            Desired_Access_Type_ = ''
            for text__content_ in child_.childNodes:
                Desired_Access_Type_ += text__content_.nodeValue
            self.Desired_Access_Type = Desired_Access_Type_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Enumerated_Daemons':
            obj_ = Enumerated_Daemons.factory()
            obj_.build(child_)
            self.set_Enumerated_Daemons(obj_)
# end class Daemon_Action_Attributes


class Enumerated_Daemons(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Daemon_Reference=None):
        if Daemon_Reference is None:
            self.Daemon_Reference = []
        else:
            self.Daemon_Reference = Daemon_Reference
    def factory(*args_, **kwargs_):
        if Enumerated_Daemons.subclass:
            return Enumerated_Daemons.subclass(*args_, **kwargs_)
        else:
            return Enumerated_Daemons(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Daemon_Reference(self): return self.Daemon_Reference
    def set_Daemon_Reference(self, Daemon_Reference): self.Daemon_Reference = Daemon_Reference
    def add_Daemon_Reference(self, value): self.Daemon_Reference.append(value)
    def insert_Daemon_Reference(self, index, value): self.Daemon_Reference[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Enumerated_Daemons', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Enumerated_Daemons')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Enumerated_Daemons'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Enumerated_Daemons'):
        for Daemon_Reference_ in self.Daemon_Reference:
            Daemon_Reference_.export(outfile, level, namespace_, name_='Daemon_Reference')
    def hasContent_(self):
        if (
            self.Daemon_Reference
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Enumerated_Daemons'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Daemon_Reference=[\n')
        level += 1
        for Daemon_Reference_ in self.Daemon_Reference:
            showIndent(outfile, level)
            outfile.write('model_.ObjectReferenceType(\n')
            Daemon_Reference_.exportLiteral(outfile, level, name_='ObjectReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Daemon_Reference':
            obj_ = ObjectReferenceType.factory()
            obj_.build(child_)
            self.Daemon_Reference.append(obj_)
# end class Enumerated_Daemons


class System_Action_Attributes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Computer_Name=None, Local_Time=None):
        self.Computer_Name = Computer_Name
        self.Local_Time = Local_Time
    def factory(*args_, **kwargs_):
        if System_Action_Attributes.subclass:
            return System_Action_Attributes.subclass(*args_, **kwargs_)
        else:
            return System_Action_Attributes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Computer_Name(self): return self.Computer_Name
    def set_Computer_Name(self, Computer_Name): self.Computer_Name = Computer_Name
    def get_Local_Time(self): return self.Local_Time
    def set_Local_Time(self, Local_Time): self.Local_Time = Local_Time
    def export(self, outfile, level, namespace_='maec:', name_='System_Action_Attributes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='System_Action_Attributes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='System_Action_Attributes'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='System_Action_Attributes'):
        if self.Computer_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sComputer_Name>%s</%sComputer_Name>\n' % (namespace_, self.format_string(quote_xml(self.Computer_Name).encode(ExternalEncoding), input_name='Computer_Name'), namespace_))
        if self.Local_Time is not None:
            showIndent(outfile, level)
            outfile.write('<%sLocal_Time>%s</%sLocal_Time>\n' % (namespace_, self.format_string(quote_xml(self.Local_Time).encode(ExternalEncoding), input_name='Local_Time'), namespace_))
    def hasContent_(self):
        if (
            self.Computer_Name is not None or
            self.Local_Time is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='System_Action_Attributes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Computer_Name is not None:
            showIndent(outfile, level)
            outfile.write('Computer_Name=%s,\n' % quote_python(self.Computer_Name).encode(ExternalEncoding))
        if self.Local_Time is not None:
            showIndent(outfile, level)
            outfile.write('Local_Time=%s,\n' % quote_python(self.Local_Time).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Computer_Name':
            Computer_Name_ = ''
            for text__content_ in child_.childNodes:
                Computer_Name_ += text__content_.nodeValue
            self.Computer_Name = Computer_Name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Local_Time':
            Local_Time_ = ''
            for text__content_ in child_.childNodes:
                Local_Time_ += text__content_.nodeValue
            self.Local_Time = Local_Time_
# end class System_Action_Attributes


class Internet_Action_Attributes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, URL_Connected=None):
        self.URL_Connected = URL_Connected
    def factory(*args_, **kwargs_):
        if Internet_Action_Attributes.subclass:
            return Internet_Action_Attributes.subclass(*args_, **kwargs_)
        else:
            return Internet_Action_Attributes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_URL_Connected(self): return self.URL_Connected
    def set_URL_Connected(self, URL_Connected): self.URL_Connected = URL_Connected
    def export(self, outfile, level, namespace_='maec:', name_='Internet_Action_Attributes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Internet_Action_Attributes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Internet_Action_Attributes'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Internet_Action_Attributes'):
        if self.URL_Connected is not None:
            showIndent(outfile, level)
            outfile.write('<%sURL_Connected>%s</%sURL_Connected>\n' % (namespace_, self.format_string(quote_xml(self.URL_Connected).encode(ExternalEncoding), input_name='URL_Connected'), namespace_))
    def hasContent_(self):
        if (
            self.URL_Connected is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Internet_Action_Attributes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.URL_Connected is not None:
            showIndent(outfile, level)
            outfile.write('URL_Connected=%s,\n' % quote_python(self.URL_Connected).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'URL_Connected':
            URL_Connected_ = ''
            for text__content_ in child_.childNodes:
                URL_Connected_ += text__content_.nodeValue
            self.URL_Connected = URL_Connected_
# end class Internet_Action_Attributes


class CPESpecificationType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, cpe_name=None, xmlns_value=None, Title=None, meta_item_metadata=None):
        self.cpe_name = _cast(None, cpe_name)
        self.xmlns_value = _cast(None, xmlns_value)
        self.Title = Title
        self.meta_item_metadata = meta_item_metadata
    def factory(*args_, **kwargs_):
        if CPESpecificationType.subclass:
            return CPESpecificationType.subclass(*args_, **kwargs_)
        else:
            return CPESpecificationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Title(self): return self.Title
    def set_Title(self, Title): self.Title = Title
    def get_meta_item_metadata(self): return self.meta_item_metadata
    def set_meta_item_metadata(self, meta_item_metadata): self.meta_item_metadata = meta_item_metadata
    def get_cpe_name(self): return self.cpe_name
    def set_cpe_name(self, cpe_name): self.cpe_name = cpe_name
    def get_xmlns_value(self): return self.xmlns_value
    def set_xmlns_value(self, xmlns_value): self.xmlns_value = xmlns_value
    def export(self, outfile, level, namespace_='maec:', name_='CPESpecificationType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='CPESpecificationType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='CPESpecificationType'):
        outfile.write(' cpe_name=%s' % (self.format_string(quote_attrib(self.cpe_name).encode(ExternalEncoding), input_name='cpe_name'), ))
        outfile.write(' xmlns_value=%s' % (self.format_string(quote_attrib(self.xmlns_value).encode(ExternalEncoding), input_name='xmlns_value'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='CPESpecificationType'):
        if self.Title:
            self.Title.export(outfile, level, namespace_, name_='Title')
        if self.meta_item_metadata:
            self.meta_item_metadata.export(outfile, level, namespace_, name_='meta_item_metadata')
    def hasContent_(self):
        if (
            self.Title is not None or
            self.meta_item_metadata is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='CPESpecificationType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.cpe_name is not None:
            showIndent(outfile, level)
            outfile.write('cpe_name = "%s",\n' % (self.cpe_name,))
        if self.xmlns_value is not None:
            showIndent(outfile, level)
            outfile.write('xmlns_value = "%s",\n' % (self.xmlns_value,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Title is not None:
            showIndent(outfile, level)
            outfile.write('Title=model_.Title(\n')
            self.Title.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.meta_item_metadata is not None:
            showIndent(outfile, level)
            outfile.write('meta_item_metadata=model_.meta_item_metadata(\n')
            self.meta_item_metadata.exportLiteral(outfile, level, name_='meta_item_metadata')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('cpe_name'):
            self.cpe_name = attrs.get('cpe_name').value
        if attrs.get('xmlns_value'):
            self.xmlns_value = attrs.get('xmlns_value').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Title':
            obj_ = Title.factory()
            obj_.build(child_)
            self.set_Title(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'meta-item-metadata':
            obj_ = meta_item_metadata.factory()
            obj_.build(child_)
            self.set_meta_item_metadata(obj_)
# end class CPESpecificationType


class Title(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, lang=None, valueOf_=''):
        self.lang = _cast(None, lang)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Title.subclass:
            return Title.subclass(*args_, **kwargs_)
        else:
            return Title(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_lang(self): return self.lang
    def set_lang(self, lang): self.lang = lang
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='maec:', name_='Title', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Title')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Title'):
        if self.lang is not None:
            outfile.write(' lang=%s' % (self.format_string(quote_attrib(self.lang).encode(ExternalEncoding), input_name='lang'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Title'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value)
        else:
            outfile.write(quote_xml('%s' % self.valueOf_))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Title'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.lang is not None:
            showIndent(outfile, level)
            outfile.write('lang = "%s",\n' % (self.lang,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('lang'):
            self.lang = attrs.get('lang').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class Title


class meta_item_metadata(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, status=None, nvd_id=None, xmlns_meta=None, modification_date=None, valueOf_=''):
        self.status = _cast(None, status)
        self.nvd_id = _cast(int, nvd_id)
        self.xmlns_meta = _cast(None, xmlns_meta)
        self.modification_date = _cast(None, modification_date)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if meta_item_metadata.subclass:
            return meta_item_metadata.subclass(*args_, **kwargs_)
        else:
            return meta_item_metadata(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_nvd_id(self): return self.nvd_id
    def set_nvd_id(self, nvd_id): self.nvd_id = nvd_id
    def get_xmlns_meta(self): return self.xmlns_meta
    def set_xmlns_meta(self, xmlns_meta): self.xmlns_meta = xmlns_meta
    def get_modification_date(self): return self.modification_date
    def set_modification_date(self, modification_date): self.modification_date = modification_date
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='maec:', name_='meta-item-metadata', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='meta-item-metadata')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='meta-item-metadata'):
        if self.status is not None:
            outfile.write(' status=%s' % (self.format_string(quote_attrib(self.status).encode(ExternalEncoding), input_name='status'), ))
        if self.nvd_id is not None:
            outfile.write(' nvd-id="%s"' % self.format_integer(self.nvd_id, input_name='nvd-id'))
        if self.xmlns_meta is not None:
            outfile.write(' xmlns-meta=%s' % (self.format_string(quote_attrib(self.xmlns_meta).encode(ExternalEncoding), input_name='xmlns-meta'), ))
        if self.modification_date is not None:
            outfile.write(' modification-date=%s' % (self.format_string(quote_attrib(self.modification_date).encode(ExternalEncoding), input_name='modification-date'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='meta-item-metadata'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value)
        else:
            outfile.write(quote_xml('%s' % self.valueOf_))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='meta-item-metadata'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status = "%s",\n' % (self.status,))
        if self.nvd_id is not None:
            showIndent(outfile, level)
            outfile.write('nvd_id = %d,\n' % (self.nvd_id,))
        if self.xmlns_meta is not None:
            showIndent(outfile, level)
            outfile.write('xmlns_meta = "%s",\n' % (self.xmlns_meta,))
        if self.modification_date is not None:
            showIndent(outfile, level)
            outfile.write('modification_date = "%s",\n' % (self.modification_date,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('status'):
            self.status = attrs.get('status').value
        if attrs.get('nvd-id'):
            try:
                self.nvd_id = int(attrs.get('nvd-id').value)
            except ValueError as exp:
                raise ValueError('Bad integer attribute (nvd-id): %s' % exp)
        if attrs.get('xmlns-meta'):
            self.xmlns_meta = attrs.get('xmlns-meta').value
        if attrs.get('modification-date'):
            self.modification_date = attrs.get('modification-date').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class meta_item_metadata


class APICallType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, apifunction_name=None, id=None, Address=None, ReturnValue=None, APICall_Parameter=None):
        self.apifunction_name = _cast(None, apifunction_name)
        self.id = _cast(None, id)
        self.Address = Address
        self.ReturnValue = ReturnValue
        if APICall_Parameter is None:
            self.APICall_Parameter = []
        else:
            self.APICall_Parameter = APICall_Parameter
    def factory(*args_, **kwargs_):
        if APICallType.subclass:
            return APICallType.subclass(*args_, **kwargs_)
        else:
            return APICallType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Address(self): return self.Address
    def set_Address(self, Address): self.Address = Address
    def get_ReturnValue(self): return self.ReturnValue
    def set_ReturnValue(self, ReturnValue): self.ReturnValue = ReturnValue
    def get_APICall_Parameter(self): return self.APICall_Parameter
    def set_APICall_Parameter(self, APICall_Parameter): self.APICall_Parameter = APICall_Parameter
    def add_APICall_Parameter(self, value): self.APICall_Parameter.append(value)
    def insert_APICall_Parameter(self, index, value): self.APICall_Parameter[index] = value
    def get_apifunction_name(self): return self.apifunction_name
    def set_apifunction_name(self, apifunction_name): self.apifunction_name = apifunction_name
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='maec:', name_='APICallType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='APICallType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='APICallType'):
        if self.apifunction_name is not None:
            outfile.write(' apifunction_name=%s' % (self.format_string(quote_attrib(self.apifunction_name).encode(ExternalEncoding), input_name='apifunction_name'), ))
        outfile.write(' id=%s' % (quote_attrib(self.id), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='APICallType'):
        if self.Address is not None:
            showIndent(outfile, level)
            outfile.write('<%sAddress>%s</%sAddress>\n' % (namespace_, self.format_string(quote_xml(self.Address).encode(ExternalEncoding), input_name='Address'), namespace_))
        if self.ReturnValue is not None:
            showIndent(outfile, level)
            outfile.write('<%sReturnValue>%s</%sReturnValue>\n' % (namespace_, self.format_string(quote_xml(self.ReturnValue).encode(ExternalEncoding), input_name='ReturnValue'), namespace_))
        for APICall_Parameter_ in self.APICall_Parameter:
            APICall_Parameter_.export(outfile, level, namespace_, name_='APICall_Parameter')
    def hasContent_(self):
        if (
            self.Address is not None or
            self.ReturnValue is not None or
            self.APICall_Parameter
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='APICallType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.apifunction_name is not None:
            showIndent(outfile, level)
            outfile.write('apifunction_name = "%s",\n' % (self.apifunction_name,))
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Address is not None:
            showIndent(outfile, level)
            outfile.write('Address=%s,\n' % quote_python(self.Address).encode(ExternalEncoding))
        if self.ReturnValue is not None:
            showIndent(outfile, level)
            outfile.write('ReturnValue=%s,\n' % quote_python(self.ReturnValue).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('APICall_Parameter=[\n')
        level += 1
        for APICall_Parameter_ in self.APICall_Parameter:
            showIndent(outfile, level)
            outfile.write('model_.APICall_Parameter(\n')
            APICall_Parameter_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('apifunction_name'):
            self.apifunction_name = attrs.get('apifunction_name').value
        if attrs.get('id'):
            self.id = attrs.get('id').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Address':
            Address_ = ''
            for text__content_ in child_.childNodes:
                Address_ += text__content_.nodeValue
            self.Address = Address_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'ReturnValue':
            ReturnValue_ = ''
            for text__content_ in child_.childNodes:
                ReturnValue_ += text__content_.nodeValue
            self.ReturnValue = ReturnValue_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'APICall_Parameter':
            obj_ = APICall_Parameter.factory()
            obj_.build(child_)
            self.APICall_Parameter.append(obj_)
# end class APICallType


class APICall_Parameter(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ordinal_position=None, Name=None, Value=None):
        self.ordinal_position = _cast(int, ordinal_position)
        self.Name = Name
        self.Value = Value
    def factory(*args_, **kwargs_):
        if APICall_Parameter.subclass:
            return APICall_Parameter.subclass(*args_, **kwargs_)
        else:
            return APICall_Parameter(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def get_ordinal_position(self): return self.ordinal_position
    def set_ordinal_position(self, ordinal_position): self.ordinal_position = ordinal_position
    def export(self, outfile, level, namespace_='maec:', name_='APICall_Parameter', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='APICall_Parameter')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='APICall_Parameter'):
        if self.ordinal_position is not None:
            outfile.write(' ordinal_position="%s"' % self.format_integer(self.ordinal_position, input_name='ordinal_position'))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='APICall_Parameter'):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sName>%s</%sName>\n' % (namespace_, self.format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), namespace_))
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('<%sValue>%s</%sValue>\n' % (namespace_, self.format_string(quote_xml(self.Value).encode(ExternalEncoding), input_name='Value'), namespace_))
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Value is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='APICall_Parameter'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.ordinal_position is not None:
            showIndent(outfile, level)
            outfile.write('ordinal_position = %d,\n' % (self.ordinal_position,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=model_.xs_string(\n')
            self.Value.exportLiteral(outfile, level, name_='Value')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('ordinal_position'):
            try:
                self.ordinal_position = int(attrs.get('ordinal_position').value)
            except ValueError as exp:
                raise ValueError('Bad integer attribute (ordinal_position): %s' % exp)
            if self.ordinal_position <= 0:
                raise ValueError('Invalid PositiveInteger (ordinal_position)')
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Name':
            Name_ = ''
            for text__content_ in child_.childNodes:
                Name_ += text__content_.nodeValue
            self.Name = Name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Value':
            Value_ = ''
            for text__content_ in child_.childNodes:
                Value_ += text__content_.nodeValue
            self.Value = Value_
# end class APICall_Parameter


class ToolType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None, Name=None, Version=None, Vendor=None, Organization=None):
        self.id = _cast(None, id)
        self.Name = Name
        self.Version = Version
        self.Vendor = Vendor
        self.Organization = Organization
    def factory(*args_, **kwargs_):
        if ToolType.subclass:
            return ToolType.subclass(*args_, **kwargs_)
        else:
            return ToolType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Version(self): return self.Version
    def set_Version(self, Version): self.Version = Version
    def get_Vendor(self): return self.Vendor
    def set_Vendor(self, Vendor): self.Vendor = Vendor
    def get_Organization(self): return self.Organization
    def set_Organization(self, Organization): self.Organization = Organization
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='maec:', name_='ToolType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='ToolType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='ToolType'):
        outfile.write(' id=%s' % (quote_attrib(self.id), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ToolType'):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sName>%s</%sName>\n' % (namespace_, self.format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), namespace_))
        if self.Version is not None:
            showIndent(outfile, level)
            outfile.write('<%sVersion>%s</%sVersion>\n' % (namespace_, self.format_string(quote_xml(self.Version).encode(ExternalEncoding), input_name='Version'), namespace_))
        if self.Vendor is not None:
            showIndent(outfile, level)
            outfile.write('<%sVendor>%s</%sVendor>\n' % (namespace_, self.format_string(quote_xml(self.Vendor).encode(ExternalEncoding), input_name='Vendor'), namespace_))
        if self.Organization is not None:
            showIndent(outfile, level)
            outfile.write('<%sOrganization>%s</%sOrganization>\n' % (namespace_, self.format_string(quote_xml(self.Organization).encode(ExternalEncoding), input_name='Organization'), namespace_))
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Version is not None or
            self.Vendor is not None or
            self.Organization is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ToolType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
        if self.Version is not None:
            showIndent(outfile, level)
            outfile.write('Version=%s,\n' % quote_python(self.Version).encode(ExternalEncoding))
        if self.Vendor is not None:
            showIndent(outfile, level)
            outfile.write('Vendor=%s,\n' % quote_python(self.Vendor).encode(ExternalEncoding))
        if self.Organization is not None:
            showIndent(outfile, level)
            outfile.write('Organization=%s,\n' % quote_python(self.Organization).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('id'):
            self.id = attrs.get('id').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Name':
            Name_ = ''
            for text__content_ in child_.childNodes:
                Name_ += text__content_.nodeValue
            self.Name = Name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Version':
            Version_ = ''
            for text__content_ in child_.childNodes:
                Version_ += text__content_.nodeValue
            self.Version = Version_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Vendor':
            Vendor_ = ''
            for text__content_ in child_.childNodes:
                Vendor_ += text__content_.nodeValue
            self.Vendor = Vendor_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Organization':
            Organization_ = ''
            for text__content_ in child_.childNodes:
                Organization_ += text__content_.nodeValue
            self.Organization = Organization_
# end class ToolType


class AnalysisType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, start_datetime=None, lastupdate_datetime=None, id=None, complete_datetime=None, analysis_method=None, Subject=None, Description=None, Analysts=None, Source=None, Analysis_Environment=None, Tools_Used=None, Notes=None):
        self.start_datetime = _cast(None, start_datetime)
        self.lastupdate_datetime = _cast(None, lastupdate_datetime)
        self.id = _cast(None, id)
        self.complete_datetime = _cast(None, complete_datetime)
        self.analysis_method = _cast(None, analysis_method)
        if Subject is None:
            self.Subject = []
        else:
            self.Subject = Subject
        self.Description = Description
        self.Analysts = Analysts
        self.Source = Source
        self.Analysis_Environment = Analysis_Environment
        self.Tools_Used = Tools_Used
        self.Notes = Notes
    def factory(*args_, **kwargs_):
        if AnalysisType.subclass:
            return AnalysisType.subclass(*args_, **kwargs_)
        else:
            return AnalysisType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Subject(self): return self.Subject
    def set_Subject(self, Subject): self.Subject = Subject
    def add_Subject(self, value): self.Subject.append(value)
    def insert_Subject(self, index, value): self.Subject[index] = value
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Analysts(self): return self.Analysts
    def set_Analysts(self, Analysts): self.Analysts = Analysts
    def get_Source(self): return self.Source
    def set_Source(self, Source): self.Source = Source
    def get_Analysis_Environment(self): return self.Analysis_Environment
    def set_Analysis_Environment(self, Analysis_Environment): self.Analysis_Environment = Analysis_Environment
    def get_Tools_Used(self): return self.Tools_Used
    def set_Tools_Used(self, Tools_Used): self.Tools_Used = Tools_Used
    def get_Notes(self): return self.Notes
    def set_Notes(self, Notes): self.Notes = Notes
    def get_start_datetime(self): return self.start_datetime
    def set_start_datetime(self, start_datetime): self.start_datetime = start_datetime
    def get_lastupdate_datetime(self): return self.lastupdate_datetime
    def set_lastupdate_datetime(self, lastupdate_datetime): self.lastupdate_datetime = lastupdate_datetime
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_complete_datetime(self): return self.complete_datetime
    def set_complete_datetime(self, complete_datetime): self.complete_datetime = complete_datetime
    def get_analysis_method(self): return self.analysis_method
    def set_analysis_method(self, analysis_method): self.analysis_method = analysis_method
    def export(self, outfile, level, namespace_='maec:', name_='AnalysisType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='AnalysisType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='AnalysisType'):
        if self.start_datetime is not None:
            outfile.write(' start_datetime=%s' % (self.format_string(quote_attrib(self.start_datetime).encode(ExternalEncoding), input_name='start_datetime'), ))
        if self.lastupdate_datetime is not None:
            outfile.write(' lastupdate_datetime=%s' % (self.format_string(quote_attrib(self.lastupdate_datetime).encode(ExternalEncoding), input_name='lastupdate_datetime'), ))
        outfile.write(' id=%s' % (quote_attrib(self.id), ))
        if self.complete_datetime is not None:
            outfile.write(' complete_datetime=%s' % (self.format_string(quote_attrib(self.complete_datetime).encode(ExternalEncoding), input_name='complete_datetime'), ))
        if self.analysis_method is not None:
            outfile.write(' analysis_method=%s' % (self.format_string(quote_attrib(self.analysis_method).encode(ExternalEncoding), input_name='analysis_method'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='AnalysisType'):
        for Subject_ in self.Subject:
            Subject_.export(outfile, level, namespace_, name_='Subject')
        if self.Description:
            self.Description.export(outfile, level, namespace_, name_='Description')
        if self.Analysts:
            self.Analysts.export(outfile, level, namespace_, name_='Analysts')
        if self.Source:
            self.Source.export(outfile, level, namespace_, name_='Source')
        if self.Analysis_Environment:
            self.Analysis_Environment.export(outfile, level, namespace_, name_='Analysis_Environment')
        if self.Tools_Used:
            self.Tools_Used.export(outfile, level, namespace_, name_='Tools_Used')
        if self.Notes:
            self.Notes.export(outfile, level, namespace_, name_='Notes')
    def hasContent_(self):
        if (
            self.Subject or
            self.Description is not None or
            self.Analysts is not None or
            self.Source is not None or
            self.Analysis_Environment is not None or
            self.Tools_Used is not None or
            self.Notes is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AnalysisType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.start_datetime is not None:
            showIndent(outfile, level)
            outfile.write('start_datetime = "%s",\n' % (self.start_datetime,))
        if self.lastupdate_datetime is not None:
            showIndent(outfile, level)
            outfile.write('lastupdate_datetime = "%s",\n' % (self.lastupdate_datetime,))
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
        if self.complete_datetime is not None:
            showIndent(outfile, level)
            outfile.write('complete_datetime = "%s",\n' % (self.complete_datetime,))
        if self.analysis_method is not None:
            showIndent(outfile, level)
            outfile.write('analysis_method = "%s",\n' % (self.analysis_method,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Subject=[\n')
        level += 1
        for Subject_ in self.Subject:
            showIndent(outfile, level)
            outfile.write('model_.Subject(\n')
            Subject_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=model_.StructuredTextType(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Analysts is not None:
            showIndent(outfile, level)
            outfile.write('Analysts=model_.Analysts(\n')
            self.Analysts.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Source is not None:
            showIndent(outfile, level)
            outfile.write('Source=model_.Source(\n')
            self.Source.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Analysis_Environment is not None:
            showIndent(outfile, level)
            outfile.write('Analysis_Environment=model_.Analysis_Environment(\n')
            self.Analysis_Environment.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Tools_Used is not None:
            showIndent(outfile, level)
            outfile.write('Tools_Used=model_.Tools_Used(\n')
            self.Tools_Used.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Notes is not None:
            showIndent(outfile, level)
            outfile.write('Notes=model_.Notes(\n')
            self.Notes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('start_datetime'):
            self.start_datetime = attrs.get('start_datetime').value
        if attrs.get('lastupdate_datetime'):
            self.lastupdate_datetime = attrs.get('lastupdate_datetime').value
        if attrs.get('id'):
            self.id = attrs.get('id').value
        if attrs.get('complete_datetime'):
            self.complete_datetime = attrs.get('complete_datetime').value
        if attrs.get('analysis_method'):
            self.analysis_method = attrs.get('analysis_method').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Subject':
            obj_ = Subject.factory()
            obj_.build(child_)
            self.Subject.append(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Description':
            obj_ = StructuredTextType.factory()
            obj_.build(child_)
            self.set_Description(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Analysts':
            obj_ = Analysts.factory()
            obj_.build(child_)
            self.set_Analysts(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Source':
            obj_ = Source.factory()
            obj_.build(child_)
            self.set_Source(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Analysis_Environment':
            obj_ = Analysis_Environment.factory()
            obj_.build(child_)
            self.set_Analysis_Environment(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Tools_Used':
            obj_ = Tools_Used.factory()
            obj_.build(child_)
            self.set_Tools_Used(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Notes':
            obj_ = Notes.factory()
            obj_.build(child_)
            self.set_Notes(obj_)
# end class AnalysisType


class Subject(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, URI=None, Object_Reference=None, Object=None, Subject_Field_Data=None):
        self.URI = URI
        self.Object_Reference = Object_Reference
        self.Object = Object
        self.Subject_Field_Data = Subject_Field_Data
    def factory(*args_, **kwargs_):
        if Subject.subclass:
            return Subject.subclass(*args_, **kwargs_)
        else:
            return Subject(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_URI(self): return self.URI
    def set_URI(self, URI): self.URI = URI
    def get_Object_Reference(self): return self.Object_Reference
    def set_Object_Reference(self, Object_Reference): self.Object_Reference = Object_Reference
    def get_Object(self): return self.Object
    def set_Object(self, Object): self.Object = Object
    def get_Subject_Field_Data(self): return self.Subject_Field_Data
    def set_Subject_Field_Data(self, Subject_Field_Data): self.Subject_Field_Data = Subject_Field_Data
    def export(self, outfile, level, namespace_='maec:', name_='Subject', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Subject')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Subject'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Subject'):
        if self.URI is not None:
            showIndent(outfile, level)
            outfile.write('<%sURI>%s</%sURI>\n' % (namespace_, self.format_string(quote_xml(self.URI).encode(ExternalEncoding), input_name='URI'), namespace_))
        if self.Object_Reference:
            self.Object_Reference.export(outfile, level, namespace_, name_='Object_Reference')
        if self.Object:
            self.Object.export(outfile, level, namespace_, name_='Object')
        if self.Subject_Field_Data is not None:
            showIndent(outfile, level)
            outfile.write('<%sSubject_Field_Data>%s</%sSubject_Field_Data>\n' % (namespace_, self.format_string(quote_xml(self.Subject_Field_Data).encode(ExternalEncoding), input_name='Subject_Field_Data'), namespace_))
    def hasContent_(self):
        if (
            self.URI is not None or
            self.Object_Reference is not None or
            self.Object is not None or
            self.Subject_Field_Data is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Subject'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.URI is not None:
            showIndent(outfile, level)
            outfile.write('URI=%s,\n' % quote_python(self.URI).encode(ExternalEncoding))
        if self.Object_Reference is not None:
            showIndent(outfile, level)
            outfile.write('Object_Reference=model_.ObjectReferenceType(\n')
            self.Object_Reference.exportLiteral(outfile, level, name_='Object_Reference')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Object is not None:
            showIndent(outfile, level)
            outfile.write('Object=model_.ObjectType(\n')
            self.Object.exportLiteral(outfile, level, name_='Object')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Subject_Field_Data is not None:
            showIndent(outfile, level)
            outfile.write('Subject_Field_Data=%s,\n' % quote_python(self.Subject_Field_Data).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'URI':
            URI_ = ''
            for text__content_ in child_.childNodes:
                URI_ += text__content_.nodeValue
            self.URI = URI_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Object_Reference':
            obj_ = ObjectReferenceType.factory()
            obj_.build(child_)
            self.set_Object_Reference(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Object':
            obj_ = ObjectType.factory()
            obj_.build(child_)
            self.set_Object(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Subject_Field_Data':
            Subject_Field_Data_ = ''
            for text__content_ in child_.childNodes:
                Subject_Field_Data_ += text__content_.nodeValue
            self.Subject_Field_Data = Subject_Field_Data_
# end class Subject


class Analysts(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Analyst=None):
        if Analyst is None:
            self.Analyst = []
        else:
            self.Analyst = Analyst
    def factory(*args_, **kwargs_):
        if Analysts.subclass:
            return Analysts.subclass(*args_, **kwargs_)
        else:
            return Analysts(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Analyst(self): return self.Analyst
    def set_Analyst(self, Analyst): self.Analyst = Analyst
    def add_Analyst(self, value): self.Analyst.append(value)
    def insert_Analyst(self, index, value): self.Analyst[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Analysts', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Analysts')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Analysts'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Analysts'):
        for Analyst_ in self.Analyst:
            showIndent(outfile, level)
            outfile.write('<%sAnalyst>%s</%sAnalyst>\n' % (namespace_, self.format_string(quote_xml(Analyst_).encode(ExternalEncoding), input_name='Analyst'), namespace_))
    def hasContent_(self):
        if (
            self.Analyst
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Analysts'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Analyst=[\n')
        level += 1
        for Analyst_ in self.Analyst:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Analyst_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Analyst':
            Analyst_ = ''
            for text__content_ in child_.childNodes:
                Analyst_ += text__content_.nodeValue
            self.Analyst.append(Analyst_)
# end class Analysts


class Source(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Organization_Name=None, POC=None, URI=None):
        self.Organization_Name = Organization_Name
        self.POC = POC
        self.URI = URI
    def factory(*args_, **kwargs_):
        if Source.subclass:
            return Source.subclass(*args_, **kwargs_)
        else:
            return Source(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Organization_Name(self): return self.Organization_Name
    def set_Organization_Name(self, Organization_Name): self.Organization_Name = Organization_Name
    def get_POC(self): return self.POC
    def set_POC(self, POC): self.POC = POC
    def get_URI(self): return self.URI
    def set_URI(self, URI): self.URI = URI
    def export(self, outfile, level, namespace_='maec:', name_='Source', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Source')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Source'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Source'):
        if self.Organization_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sOrganization_Name>%s</%sOrganization_Name>\n' % (namespace_, self.format_string(quote_xml(self.Organization_Name).encode(ExternalEncoding), input_name='Organization_Name'), namespace_))
        if self.POC is not None:
            showIndent(outfile, level)
            outfile.write('<%sPOC>%s</%sPOC>\n' % (namespace_, self.format_string(quote_xml(self.POC).encode(ExternalEncoding), input_name='POC'), namespace_))
        if self.URI is not None:
            showIndent(outfile, level)
            outfile.write('<%sURI>%s</%sURI>\n' % (namespace_, self.format_string(quote_xml(self.URI).encode(ExternalEncoding), input_name='URI'), namespace_))
    def hasContent_(self):
        if (
            self.Organization_Name is not None or
            self.POC is not None or
            self.URI is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Source'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Organization_Name is not None:
            showIndent(outfile, level)
            outfile.write('Organization_Name=%s,\n' % quote_python(self.Organization_Name).encode(ExternalEncoding))
        if self.POC is not None:
            showIndent(outfile, level)
            outfile.write('POC=%s,\n' % quote_python(self.POC).encode(ExternalEncoding))
        if self.URI is not None:
            showIndent(outfile, level)
            outfile.write('URI=%s,\n' % quote_python(self.URI).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Organization_Name':
            Organization_Name_ = ''
            for text__content_ in child_.childNodes:
                Organization_Name_ += text__content_.nodeValue
            self.Organization_Name = Organization_Name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'POC':
            POC_ = ''
            for text__content_ in child_.childNodes:
                POC_ += text__content_.nodeValue
            self.POC = POC_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'URI':
            URI_ = ''
            for text__content_ in child_.childNodes:
                URI_ += text__content_.nodeValue
            self.URI = URI_
# end class Source


class Analysis_Environment(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, OS=None, Enivironment_Variables=None):
        self.OS = OS
        self.Enivironment_Variables = Enivironment_Variables
    def factory(*args_, **kwargs_):
        if Analysis_Environment.subclass:
            return Analysis_Environment.subclass(*args_, **kwargs_)
        else:
            return Analysis_Environment(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_OS(self): return self.OS
    def set_OS(self, OS): self.OS = OS
    def get_Enivironment_Variables(self): return self.Enivironment_Variables
    def set_Enivironment_Variables(self, Enivironment_Variables): self.Enivironment_Variables = Enivironment_Variables
    def export(self, outfile, level, namespace_='maec:', name_='Analysis_Environment', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Analysis_Environment')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Analysis_Environment'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Analysis_Environment'):
        if self.OS:
            self.OS.export(outfile, level, namespace_, name_='OS')
        if self.Enivironment_Variables:
            self.Enivironment_Variables.export(outfile, level, namespace_, name_='Enivironment_Variables')
    def hasContent_(self):
        if (
            self.OS is not None or
            self.Enivironment_Variables is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Analysis_Environment'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.OS is not None:
            showIndent(outfile, level)
            outfile.write('OS=model_.CPESpecificationType(\n')
            self.OS.exportLiteral(outfile, level, name_='OS')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Enivironment_Variables is not None:
            showIndent(outfile, level)
            outfile.write('Enivironment_Variables=model_.Enivironment_Variables(\n')
            self.Enivironment_Variables.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'OS':
            obj_ = CPESpecificationType.factory()
            obj_.build(child_)
            self.set_OS(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Enivironment_Variables':
            obj_ = Enivironment_Variables.factory()
            obj_.build(child_)
            self.set_Enivironment_Variables(obj_)
# end class Analysis_Environment


class Enivironment_Variables(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Environment_Variable=None):
        if Environment_Variable is None:
            self.Environment_Variable = []
        else:
            self.Environment_Variable = Environment_Variable
    def factory(*args_, **kwargs_):
        if Enivironment_Variables.subclass:
            return Enivironment_Variables.subclass(*args_, **kwargs_)
        else:
            return Enivironment_Variables(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Environment_Variable(self): return self.Environment_Variable
    def set_Environment_Variable(self, Environment_Variable): self.Environment_Variable = Environment_Variable
    def add_Environment_Variable(self, value): self.Environment_Variable.append(value)
    def insert_Environment_Variable(self, index, value): self.Environment_Variable[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Enivironment_Variables', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Enivironment_Variables')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Enivironment_Variables'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Enivironment_Variables'):
        for Environment_Variable_ in self.Environment_Variable:
            Environment_Variable_.export(outfile, level, namespace_, name_='Environment_Variable')
    def hasContent_(self):
        if (
            self.Environment_Variable
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Enivironment_Variables'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Environment_Variable=[\n')
        level += 1
        for Environment_Variable_ in self.Environment_Variable:
            showIndent(outfile, level)
            outfile.write('model_.Environment_Variable(\n')
            Environment_Variable_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Environment_Variable':
            obj_ = Environment_Variable.factory()
            obj_.build(child_)
            self.Environment_Variable.append(obj_)
# end class Enivironment_Variables


class Environment_Variable(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Name=None, Value=None):
        self.Name = Name
        self.Value = Value
    def factory(*args_, **kwargs_):
        if Environment_Variable.subclass:
            return Environment_Variable.subclass(*args_, **kwargs_)
        else:
            return Environment_Variable(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def export(self, outfile, level, namespace_='maec:', name_='Environment_Variable', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Environment_Variable')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Environment_Variable'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Environment_Variable'):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sName>%s</%sName>\n' % (namespace_, self.format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), namespace_))
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('<%sValue>%s</%sValue>\n' % (namespace_, self.format_string(quote_xml(self.Value).encode(ExternalEncoding), input_name='Value'), namespace_))
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Value is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Environment_Variable'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=model_.xs_string(\n')
            self.Value.exportLiteral(outfile, level, name_='Value')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Name':
            Name_ = ''
            for text__content_ in child_.childNodes:
                Name_ += text__content_.nodeValue
            self.Name = Name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Value':
            Value_ = ''
            for text__content_ in child_.childNodes:
                Value_ += text__content_.nodeValue
            self.Value = Value_
# end class Environment_Variable


class Tools_Used(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Tool=None):
        if Tool is None:
            self.Tool = []
        else:
            self.Tool = Tool
    def factory(*args_, **kwargs_):
        if Tools_Used.subclass:
            return Tools_Used.subclass(*args_, **kwargs_)
        else:
            return Tools_Used(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Tool(self): return self.Tool
    def set_Tool(self, Tool): self.Tool = Tool
    def add_Tool(self, value): self.Tool.append(value)
    def insert_Tool(self, index, value): self.Tool[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Tools_Used', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Tools_Used')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Tools_Used'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Tools_Used'):
        for Tool_ in self.Tool:
            Tool_.export(outfile, level, namespace_, name_='Tool')
    def hasContent_(self):
        if (
            self.Tool
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Tools_Used'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Tool=[\n')
        level += 1
        for Tool_ in self.Tool:
            showIndent(outfile, level)
            outfile.write('model_.ToolType(\n')
            Tool_.exportLiteral(outfile, level, name_='ToolType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Tool':
            obj_ = ToolType.factory()
            obj_.build(child_)
            self.Tool.append(obj_)
# end class Tools_Used


class Notes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Note=None):
        if Note is None:
            self.Note = []
        else:
            self.Note = Note
    def factory(*args_, **kwargs_):
        if Notes.subclass:
            return Notes.subclass(*args_, **kwargs_)
        else:
            return Notes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Note(self): return self.Note
    def set_Note(self, Note): self.Note = Note
    def add_Note(self, value): self.Note.append(value)
    def insert_Note(self, index, value): self.Note[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Notes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Notes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Notes'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Notes'):
        for Note_ in self.Note:
            showIndent(outfile, level)
            outfile.write('<%sNote>%s</%sNote>\n' % (namespace_, self.format_string(quote_xml(Note_).encode(ExternalEncoding), input_name='Note'), namespace_))
    def hasContent_(self):
        if (
            self.Note
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Notes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Note=[\n')
        level += 1
        for Note_ in self.Note:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Note_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Note':
            Note_ = ''
            for text__content_ in child_.childNodes:
                Note_ += text__content_.nodeValue
            self.Note.append(Note_)
# end class Notes


class ObjectReferenceType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, object_id=None, valueOf_=''):
        self.type_ = _cast(None, type_)
        self.object_id = _cast(None, object_id)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if ObjectReferenceType.subclass:
            return ObjectReferenceType.subclass(*args_, **kwargs_)
        else:
            return ObjectReferenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_object_id(self): return self.object_id
    def set_object_id(self, object_id): self.object_id = object_id
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='maec:', name_='ObjectReferenceType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='ObjectReferenceType')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='ObjectReferenceType'):
        if self.type_ is not None:
            outfile.write(' type=%s' % (self.format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        outfile.write(' object_id=%s' % (quote_attrib(self.object_id), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ObjectReferenceType'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value)
        else:
            outfile.write(quote_xml('%s' % self.valueOf_))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ObjectReferenceType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
        if self.object_id is not None:
            showIndent(outfile, level)
            outfile.write('object_id = %s,\n' % (self.object_id,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('type'):
            self.type_ = attrs.get('type').value
        if attrs.get('object_id'):
            self.object_id = attrs.get('object_id').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class ObjectReferenceType


class CVEVulnerabilityType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, cve_id=None, CVE_Description=None):
        self.cve_id = _cast(None, cve_id)
        self.CVE_Description = CVE_Description
    def factory(*args_, **kwargs_):
        if CVEVulnerabilityType.subclass:
            return CVEVulnerabilityType.subclass(*args_, **kwargs_)
        else:
            return CVEVulnerabilityType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_CVE_Description(self): return self.CVE_Description
    def set_CVE_Description(self, CVE_Description): self.CVE_Description = CVE_Description
    def get_cve_id(self): return self.cve_id
    def set_cve_id(self, cve_id): self.cve_id = cve_id
    def export(self, outfile, level, namespace_='maec:', name_='CVEVulnerabilityType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='CVEVulnerabilityType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='CVEVulnerabilityType'):
        outfile.write(' cve_id=%s' % (self.format_string(quote_attrib(self.cve_id).encode(ExternalEncoding), input_name='cve_id'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='CVEVulnerabilityType'):
        if self.CVE_Description is not None:
            showIndent(outfile, level)
            outfile.write('<%sCVE_Description>%s</%sCVE_Description>\n' % (namespace_, self.format_string(quote_xml(self.CVE_Description).encode(ExternalEncoding), input_name='CVE_Description'), namespace_))
    def hasContent_(self):
        if (
            self.CVE_Description is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='CVEVulnerabilityType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.cve_id is not None:
            showIndent(outfile, level)
            outfile.write('cve_id = "%s",\n' % (self.cve_id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.CVE_Description is not None:
            showIndent(outfile, level)
            outfile.write('CVE_Description=%s,\n' % quote_python(self.CVE_Description).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('cve_id'):
            self.cve_id = attrs.get('cve_id').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'CVE_Description':
            CVE_Description_ = ''
            for text__content_ in child_.childNodes:
                CVE_Description_ += text__content_.nodeValue
            self.CVE_Description = CVE_Description_
# end class CVEVulnerabilityType


class ObjectCollectionType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None, name=None, Affinity_Type=None, Affinity_Degree=None, Object_Sub_Collection=None, Object=None, Object_Reference=None):
        self.id = _cast(None, id)
        self.name = _cast(None, name)
        self.Affinity_Type = Affinity_Type
        self.Affinity_Degree = Affinity_Degree
        if Object_Sub_Collection is None:
            self.Object_Sub_Collection = []
        else:
            self.Object_Sub_Collection = Object_Sub_Collection
        if Object is None:
            self.Object = []
        else:
            self.Object = Object
        if Object_Reference is None:
            self.Object_Reference = []
        else:
            self.Object_Reference = Object_Reference
    def factory(*args_, **kwargs_):
        if ObjectCollectionType.subclass:
            return ObjectCollectionType.subclass(*args_, **kwargs_)
        else:
            return ObjectCollectionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Affinity_Type(self): return self.Affinity_Type
    def set_Affinity_Type(self, Affinity_Type): self.Affinity_Type = Affinity_Type
    def get_Affinity_Degree(self): return self.Affinity_Degree
    def set_Affinity_Degree(self, Affinity_Degree): self.Affinity_Degree = Affinity_Degree
    def get_Object_Sub_Collection(self): return self.Object_Sub_Collection
    def set_Object_Sub_Collection(self, Object_Sub_Collection): self.Object_Sub_Collection = Object_Sub_Collection
    def add_Object_Sub_Collection(self, value): self.Object_Sub_Collection.append(value)
    def insert_Object_Sub_Collection(self, index, value): self.Object_Sub_Collection[index] = value
    def get_Object(self): return self.Object
    def set_Object(self, Object): self.Object = Object
    def add_Object(self, value): self.Object.append(value)
    def insert_Object(self, index, value): self.Object[index] = value
    def get_Object_Reference(self): return self.Object_Reference
    def set_Object_Reference(self, Object_Reference): self.Object_Reference = Object_Reference
    def add_Object_Reference(self, value): self.Object_Reference.append(value)
    def insert_Object_Reference(self, index, value): self.Object_Reference[index] = value
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def export(self, outfile, level, namespace_='maec:', name_='ObjectCollectionType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='ObjectCollectionType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='ObjectCollectionType'):
        outfile.write(' id=%s' % (quote_attrib(self.id), ))
        if self.name is not None:
            outfile.write(' name=%s' % (self.format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='ObjectCollectionType'):
        if self.Affinity_Type is not None:
            showIndent(outfile, level)
            outfile.write('<%sAffinity_Type>%s</%sAffinity_Type>\n' % (namespace_, self.format_string(quote_xml(self.Affinity_Type).encode(ExternalEncoding), input_name='Affinity_Type'), namespace_))
        if self.Affinity_Degree is not None:
            showIndent(outfile, level)
            outfile.write('<%sAffinity_Degree>%s</%sAffinity_Degree>\n' % (namespace_, self.format_string(quote_xml(self.Affinity_Degree).encode(ExternalEncoding), input_name='Affinity_Degree'), namespace_))
        for Object_Sub_Collection_ in self.Object_Sub_Collection:
            Object_Sub_Collection_.export(outfile, level, namespace_, name_='Object_Sub_Collection')
        for Object_ in self.Object:
            Object_.export(outfile, level, namespace_, name_='Object')
        for Object_Reference_ in self.Object_Reference:
            Object_Reference_.export(outfile, level, namespace_, name_='Object_Reference')
    def hasContent_(self):
        if (
            self.Affinity_Type is not None or
            self.Affinity_Degree is not None or
            self.Object_Sub_Collection or
            self.Object or
            self.Object_Reference
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ObjectCollectionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name = "%s",\n' % (self.name,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Affinity_Type is not None:
            showIndent(outfile, level)
            outfile.write('Affinity_Type=%s,\n' % quote_python(self.Affinity_Type).encode(ExternalEncoding))
        if self.Affinity_Degree is not None:
            showIndent(outfile, level)
            outfile.write('Affinity_Degree=%s,\n' % quote_python(self.Affinity_Degree).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('Object_Sub_Collection=[\n')
        level += 1
        for Object_Sub_Collection_ in self.Object_Sub_Collection:
            showIndent(outfile, level)
            outfile.write('model_.ObjectCollectionType(\n')
            Object_Sub_Collection_.exportLiteral(outfile, level, name_='ObjectCollectionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Object=[\n')
        level += 1
        for Object_ in self.Object:
            showIndent(outfile, level)
            outfile.write('model_.ObjectType(\n')
            Object_.exportLiteral(outfile, level, name_='ObjectType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Object_Reference=[\n')
        level += 1
        for Object_Reference_ in self.Object_Reference:
            showIndent(outfile, level)
            outfile.write('model_.ObjectReferenceType(\n')
            Object_Reference_.exportLiteral(outfile, level, name_='ObjectReferenceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('id'):
            self.id = attrs.get('id').value
        if attrs.get('name'):
            self.name = attrs.get('name').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Affinity_Type':
            Affinity_Type_ = ''
            for text__content_ in child_.childNodes:
                Affinity_Type_ += text__content_.nodeValue
            self.Affinity_Type = Affinity_Type_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Affinity_Degree':
            Affinity_Degree_ = ''
            for text__content_ in child_.childNodes:
                Affinity_Degree_ += text__content_.nodeValue
            self.Affinity_Degree = Affinity_Degree_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Object_Sub_Collection':
            obj_ = ObjectCollectionType.factory()
            obj_.build(child_)
            self.Object_Sub_Collection.append(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Object':
            obj_ = ObjectType.factory()
            obj_.build(child_)
            self.Object.append(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Object_Reference':
            obj_ = ObjectReferenceType.factory()
            obj_.build(child_)
            self.Object_Reference.append(obj_)
# end class ObjectCollectionType


class DataType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None, format=None, Data_Size=None, Discovery_Method=None, Data_Segment=None):
        self.id = _cast(None, id)
        self.format = _cast(None, format)
        self.Data_Size = Data_Size
        self.Discovery_Method = Discovery_Method
        self.Data_Segment = Data_Segment
    def factory(*args_, **kwargs_):
        if DataType.subclass:
            return DataType.subclass(*args_, **kwargs_)
        else:
            return DataType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Data_Size(self): return self.Data_Size
    def set_Data_Size(self, Data_Size): self.Data_Size = Data_Size
    def get_Discovery_Method(self): return self.Discovery_Method
    def set_Discovery_Method(self, Discovery_Method): self.Discovery_Method = Discovery_Method
    def get_Data_Segment(self): return self.Data_Segment
    def set_Data_Segment(self, Data_Segment): self.Data_Segment = Data_Segment
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def export(self, outfile, level, namespace_='maec:', name_='DataType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='DataType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='DataType'):
        outfile.write(' id=%s' % (quote_attrib(self.id), ))
        if self.format is not None:
            outfile.write(' format=%s' % (self.format_string(quote_attrib(self.format).encode(ExternalEncoding), input_name='format'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='DataType'):
        if self.Data_Size:
            self.Data_Size.export(outfile, level, namespace_, name_='Data_Size', )
        if self.Discovery_Method:
            self.Discovery_Method.export(outfile, level, namespace_, name_='Discovery_Method')
        if self.Data_Segment is not None:
            showIndent(outfile, level)
            outfile.write('<%sData_Segment>%s</%sData_Segment>\n' % (namespace_, self.format_string(quote_xml(self.Data_Segment).encode(ExternalEncoding), input_name='Data_Segment'), namespace_))
    def hasContent_(self):
        if (
            self.Data_Size is not None or
            self.Discovery_Method is not None or
            self.Data_Segment is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DataType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
        if self.format is not None:
            showIndent(outfile, level)
            outfile.write('format = "%s",\n' % (self.format,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Data_Size is not None:
            showIndent(outfile, level)
            outfile.write('Data_Size=model_.Data_Size(\n')
            self.Data_Size.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Discovery_Method is not None:
            showIndent(outfile, level)
            outfile.write('Discovery_Method=model_.DiscoveryMethod(\n')
            self.Discovery_Method.exportLiteral(outfile, level, name_='Discovery_Method')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Data_Segment is not None:
            showIndent(outfile, level)
            outfile.write('Data_Segment=%s,\n' % quote_python(self.Data_Segment).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('id'):
            self.id = attrs.get('id').value
        if attrs.get('format'):
            self.format = attrs.get('format').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Data_Size':
            obj_ = Data_Size.factory()
            obj_.build(child_)
            self.set_Data_Size(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Discovery_Method':
            obj_ = DiscoveryMethod.factory()
            obj_.build(child_)
            self.set_Discovery_Method(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Data_Segment':
            Data_Segment_ = ''
            for text__content_ in child_.childNodes:
                Data_Segment_ += text__content_.nodeValue
            self.Data_Segment = Data_Segment_
# end class DataType


class Data_Size(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=''):
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Data_Size.subclass:
            return Data_Size.subclass(*args_, **kwargs_)
        else:
            return Data_Size(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='maec:', name_='Data_Size', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Data_Size')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Data_Size'):
        outfile.write(' units=%s' % (self.format_string(quote_attrib(self.units).encode(ExternalEncoding), input_name='units'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Data_Size'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value)
        else:
            outfile.write(quote_xml('%s' % self.valueOf_))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Data_Size'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.units is not None:
            showIndent(outfile, level)
            outfile.write('units = "%s",\n' % (self.units,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('units'):
            self.units = attrs.get('units').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class Data_Size


class CodeType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, language=None, processor_family=None, start_address=None, codetype=None, xorpattern='55AA55AA55AA55BB', id=None, Discovery_Method=None, Code_Segment=None, Code_Segment_XOR=None, External_File=None):
        self.language = _cast(None, language)
        self.processor_family = _cast(None, processor_family)
        self.start_address = _cast(None, start_address)
        self.codetype = _cast(None, codetype)
        self.xorpattern = _cast(None, xorpattern)
        self.id = _cast(None, id)
        self.Discovery_Method = Discovery_Method
        self.Code_Segment = Code_Segment
        self.Code_Segment_XOR = Code_Segment_XOR
        self.External_File = External_File
    def factory(*args_, **kwargs_):
        if CodeType.subclass:
            return CodeType.subclass(*args_, **kwargs_)
        else:
            return CodeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Discovery_Method(self): return self.Discovery_Method
    def set_Discovery_Method(self, Discovery_Method): self.Discovery_Method = Discovery_Method
    def get_Code_Segment(self): return self.Code_Segment
    def set_Code_Segment(self, Code_Segment): self.Code_Segment = Code_Segment
    def get_Code_Segment_XOR(self): return self.Code_Segment_XOR
    def set_Code_Segment_XOR(self, Code_Segment_XOR): self.Code_Segment_XOR = Code_Segment_XOR
    def get_External_File(self): return self.External_File
    def set_External_File(self, External_File): self.External_File = External_File
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_processor_family(self): return self.processor_family
    def set_processor_family(self, processor_family): self.processor_family = processor_family
    def get_start_address(self): return self.start_address
    def set_start_address(self, start_address): self.start_address = start_address
    def get_codetype(self): return self.codetype
    def set_codetype(self, codetype): self.codetype = codetype
    def get_xorpattern(self): return self.xorpattern
    def set_xorpattern(self, xorpattern): self.xorpattern = xorpattern
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='maec:', name_='CodeType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='CodeType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='CodeType'):
        if self.language is not None:
            outfile.write(' language=%s' % (quote_attrib(self.language), ))
        if self.processor_family is not None:
            outfile.write(' processor_family=%s' % (quote_attrib(self.processor_family), ))
        if self.start_address is not None:
            outfile.write(' start_address=%s' % (quote_attrib(self.start_address), ))
        if self.codetype is not None:
            outfile.write(' codetype=%s' % (self.format_string(quote_attrib(self.codetype).encode(ExternalEncoding), input_name='codetype'), ))
        if self.xorpattern is not None:
            outfile.write(' xorpattern=%s' % (quote_attrib(self.xorpattern), ))
        outfile.write(' id=%s' % (quote_attrib(self.id), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='CodeType'):
        if self.Discovery_Method:
            self.Discovery_Method.export(outfile, level, namespace_, name_='Discovery_Method')
        if self.Code_Segment is not None:
            showIndent(outfile, level)
            outfile.write('<%sCode_Segment>%s</%sCode_Segment>\n' % (namespace_, self.format_string(quote_xml(self.Code_Segment).encode(ExternalEncoding), input_name='Code_Segment'), namespace_))
        if self.Code_Segment_XOR is not None:
            showIndent(outfile, level)
            outfile.write('<%sCode_Segment_XOR>%s</%sCode_Segment_XOR>\n' % (namespace_, self.format_string(quote_xml(self.Code_Segment_XOR).encode(ExternalEncoding), input_name='Code_Segment_XOR'), namespace_))
        if self.External_File:
            self.External_File.export(outfile, level, namespace_, name_='External_File')
    def hasContent_(self):
        if (
            self.Discovery_Method is not None or
            self.Code_Segment is not None or
            self.Code_Segment_XOR is not None or
            self.External_File is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='CodeType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.language is not None:
            showIndent(outfile, level)
            outfile.write('language = %s,\n' % (self.language,))
        if self.processor_family is not None:
            showIndent(outfile, level)
            outfile.write('processor_family = %s,\n' % (self.processor_family,))
        if self.start_address is not None:
            showIndent(outfile, level)
            outfile.write('start_address = %s,\n' % (self.start_address,))
        if self.codetype is not None:
            showIndent(outfile, level)
            outfile.write('codetype = "%s",\n' % (self.codetype,))
        if self.xorpattern is not None:
            showIndent(outfile, level)
            outfile.write('xorpattern = %s,\n' % (self.xorpattern,))
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Discovery_Method is not None:
            showIndent(outfile, level)
            outfile.write('Discovery_Method=model_.DiscoveryMethod(\n')
            self.Discovery_Method.exportLiteral(outfile, level, name_='Discovery_Method')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Code_Segment is not None:
            showIndent(outfile, level)
            outfile.write('Code_Segment=%s,\n' % quote_python(self.Code_Segment).encode(ExternalEncoding))
        if self.Code_Segment_XOR is not None:
            showIndent(outfile, level)
            outfile.write('Code_Segment_XOR=%s,\n' % quote_python(self.Code_Segment_XOR).encode(ExternalEncoding))
        if self.External_File is not None:
            showIndent(outfile, level)
            outfile.write('External_File=model_.ObjectType(\n')
            self.External_File.exportLiteral(outfile, level, name_='External_File')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('language'):
            self.language = attrs.get('language').value
        if attrs.get('processor_family'):
            self.processor_family = attrs.get('processor_family').value
        if attrs.get('start_address'):
            self.start_address = attrs.get('start_address').value
        if attrs.get('codetype'):
            self.codetype = attrs.get('codetype').value
        if attrs.get('xorpattern'):
            self.xorpattern = attrs.get('xorpattern').value
        if attrs.get('id'):
            self.id = attrs.get('id').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Discovery_Method':
            obj_ = DiscoveryMethod.factory()
            obj_.build(child_)
            self.set_Discovery_Method(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Code_Segment':
            Code_Segment_ = ''
            for text__content_ in child_.childNodes:
                Code_Segment_ += text__content_.nodeValue
            self.Code_Segment = Code_Segment_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Code_Segment_XOR':
            Code_Segment_XOR_ = ''
            for text__content_ in child_.childNodes:
                Code_Segment_XOR_ += text__content_.nodeValue
            self.Code_Segment_XOR = Code_Segment_XOR_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'External_File':
            obj_ = ObjectType.factory()
            obj_.build(child_)
            self.set_External_File(obj_)
# end class CodeType


class DiscoveryMethod(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, tool_id=None, method=None, valueOf_=''):
        self.tool_id = _cast(None, tool_id)
        self.method = _cast(None, method)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if DiscoveryMethod.subclass:
            return DiscoveryMethod.subclass(*args_, **kwargs_)
        else:
            return DiscoveryMethod(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_tool_id(self): return self.tool_id
    def set_tool_id(self, tool_id): self.tool_id = tool_id
    def get_method(self): return self.method
    def set_method(self, method): self.method = method
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='maec:', name_='DiscoveryMethod', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='DiscoveryMethod')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='DiscoveryMethod'):
        if self.tool_id is not None:
            outfile.write(' tool_id=%s' % (quote_attrib(self.tool_id), ))
        if self.method is not None:
            outfile.write(' method=%s' % (self.format_string(quote_attrib(self.method).encode(ExternalEncoding), input_name='method'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='DiscoveryMethod'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value)
        else:
            outfile.write(quote_xml('%s' % self.valueOf_))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DiscoveryMethod'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.tool_id is not None:
            showIndent(outfile, level)
            outfile.write('tool_id = %s,\n' % (self.tool_id,))
        if self.method is not None:
            showIndent(outfile, level)
            outfile.write('method = "%s",\n' % (self.method,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('tool_id'):
            self.tool_id = attrs.get('tool_id').value
        if attrs.get('method'):
            self.method = attrs.get('method').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class DiscoveryMethod


class HashType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, other_type=None, Hash_Value=None):
        self.type_ = _cast(None, type_)
        self.other_type = _cast(None, other_type)
        self.Hash_Value = Hash_Value
    def factory(*args_, **kwargs_):
        if HashType.subclass:
            return HashType.subclass(*args_, **kwargs_)
        else:
            return HashType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hash_Value(self): return self.Hash_Value
    def set_Hash_Value(self, Hash_Value): self.Hash_Value = Hash_Value
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_other_type(self): return self.other_type
    def set_other_type(self, other_type): self.other_type = other_type
    def export(self, outfile, level, namespace_='maec:', name_='HashType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='HashType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='HashType'):
        outfile.write(' type=%s' % (quote_attrib(self.type_), ))
        if self.other_type is not None:
            outfile.write(' other_type=%s' % (self.format_string(quote_attrib(self.other_type).encode(ExternalEncoding), input_name='other_type'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='HashType'):
        if self.Hash_Value is not None:
            showIndent(outfile, level)
            outfile.write('<%sHash_Value>%s</%sHash_Value>\n' % (namespace_, self.format_string(quote_xml(self.Hash_Value).encode(ExternalEncoding), input_name='Hash_Value'), namespace_))
    def hasContent_(self):
        if (
            self.Hash_Value is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='HashType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_ = %s,\n' % (self.type_,))
        if self.other_type is not None:
            showIndent(outfile, level)
            outfile.write('other_type = "%s",\n' % (self.other_type,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Hash_Value is not None:
            showIndent(outfile, level)
            outfile.write('Hash_Value=%s,\n' % quote_python(self.Hash_Value).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('type'):
            self.type_ = attrs.get('type').value
        if attrs.get('other_type'):
            self.other_type = attrs.get('other_type').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Hash_Value':
            Hash_Value_ = ''
            for text__content_ in child_.childNodes:
                Hash_Value_ += text__content_.nodeValue
            self.Hash_Value = Hash_Value_
# end class HashType


class PEDataDirectoryStruct(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Virtual_Address=None, Size=None):
        self.Virtual_Address = Virtual_Address
        self.Size = Size
    def factory(*args_, **kwargs_):
        if PEDataDirectoryStruct.subclass:
            return PEDataDirectoryStruct.subclass(*args_, **kwargs_)
        else:
            return PEDataDirectoryStruct(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Virtual_Address(self): return self.Virtual_Address
    def set_Virtual_Address(self, Virtual_Address): self.Virtual_Address = Virtual_Address
    def get_Size(self): return self.Size
    def set_Size(self, Size): self.Size = Size
    def export(self, outfile, level, namespace_='maec:', name_='PEDataDirectoryStruct', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='PEDataDirectoryStruct')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='PEDataDirectoryStruct'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='PEDataDirectoryStruct'):
        if self.Virtual_Address is not None:
            showIndent(outfile, level)
            outfile.write('<%sVirtual_Address>%s</%sVirtual_Address>\n' % (namespace_, self.format_string(quote_xml(self.Virtual_Address).encode(ExternalEncoding), input_name='Virtual_Address'), namespace_))
        if self.Size is not None:
            showIndent(outfile, level)
            outfile.write('<%sSize>%s</%sSize>\n' % (namespace_, self.format_integer(self.Size, input_name='Size'), namespace_))
    def hasContent_(self):
        if (
            self.Virtual_Address is not None or
            self.Size is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PEDataDirectoryStruct'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Virtual_Address is not None:
            showIndent(outfile, level)
            outfile.write('Virtual_Address=%s,\n' % quote_python(self.Virtual_Address).encode(ExternalEncoding))
        if self.Size is not None:
            showIndent(outfile, level)
            outfile.write('Size=%d,\n' % self.Size)
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Virtual_Address':
            Virtual_Address_ = ''
            for text__content_ in child_.childNodes:
                Virtual_Address_ += text__content_.nodeValue
            self.Virtual_Address = Virtual_Address_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Size':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError as exp:
                    raise ValueError('requires integer (Size): %s' % exp)
                self.Size = ival_
# end class PEDataDirectoryStruct


class PESectionHeaderStruct(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Hashes=None, Name=None, Physical_Address=None, Virtual_Address=None, Size_Of_Raw_Data=None, Pointer_To_Raw_Data=None, Pointer_To_Relocations=None, Pointer_To_Linenumbers=None, Number_Of_Relocations=None, Number_Of_Linenumbers=None, Characteristics=None):
        self.Hashes = Hashes
        self.Name = Name
        self.Physical_Address = Physical_Address
        self.Virtual_Address = Virtual_Address
        self.Size_Of_Raw_Data = Size_Of_Raw_Data
        self.Pointer_To_Raw_Data = Pointer_To_Raw_Data
        self.Pointer_To_Relocations = Pointer_To_Relocations
        self.Pointer_To_Linenumbers = Pointer_To_Linenumbers
        self.Number_Of_Relocations = Number_Of_Relocations
        self.Number_Of_Linenumbers = Number_Of_Linenumbers
        self.Characteristics = Characteristics
    def factory(*args_, **kwargs_):
        if PESectionHeaderStruct.subclass:
            return PESectionHeaderStruct.subclass(*args_, **kwargs_)
        else:
            return PESectionHeaderStruct(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hashes(self): return self.Hashes
    def set_Hashes(self, Hashes): self.Hashes = Hashes
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Physical_Address(self): return self.Physical_Address
    def set_Physical_Address(self, Physical_Address): self.Physical_Address = Physical_Address
    def get_Virtual_Address(self): return self.Virtual_Address
    def set_Virtual_Address(self, Virtual_Address): self.Virtual_Address = Virtual_Address
    def get_Size_Of_Raw_Data(self): return self.Size_Of_Raw_Data
    def set_Size_Of_Raw_Data(self, Size_Of_Raw_Data): self.Size_Of_Raw_Data = Size_Of_Raw_Data
    def get_Pointer_To_Raw_Data(self): return self.Pointer_To_Raw_Data
    def set_Pointer_To_Raw_Data(self, Pointer_To_Raw_Data): self.Pointer_To_Raw_Data = Pointer_To_Raw_Data
    def get_Pointer_To_Relocations(self): return self.Pointer_To_Relocations
    def set_Pointer_To_Relocations(self, Pointer_To_Relocations): self.Pointer_To_Relocations = Pointer_To_Relocations
    def get_Pointer_To_Linenumbers(self): return self.Pointer_To_Linenumbers
    def set_Pointer_To_Linenumbers(self, Pointer_To_Linenumbers): self.Pointer_To_Linenumbers = Pointer_To_Linenumbers
    def get_Number_Of_Relocations(self): return self.Number_Of_Relocations
    def set_Number_Of_Relocations(self, Number_Of_Relocations): self.Number_Of_Relocations = Number_Of_Relocations
    def get_Number_Of_Linenumbers(self): return self.Number_Of_Linenumbers
    def set_Number_Of_Linenumbers(self, Number_Of_Linenumbers): self.Number_Of_Linenumbers = Number_Of_Linenumbers
    def get_Characteristics(self): return self.Characteristics
    def set_Characteristics(self, Characteristics): self.Characteristics = Characteristics
    def export(self, outfile, level, namespace_='maec:', name_='PESectionHeaderStruct', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='PESectionHeaderStruct')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='PESectionHeaderStruct'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='PESectionHeaderStruct'):
        if self.Hashes:
            self.Hashes.export(outfile, level, namespace_, name_='Hashes')
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sName>%s</%sName>\n' % (namespace_, self.format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), namespace_))
        if self.Physical_Address is not None:
            showIndent(outfile, level)
            outfile.write('<%sPhysical_Address>%s</%sPhysical_Address>\n' % (namespace_, self.format_string(quote_xml(self.Physical_Address).encode(ExternalEncoding), input_name='Physical_Address'), namespace_))
        if self.Virtual_Address is not None:
            showIndent(outfile, level)
            outfile.write('<%sVirtual_Address>%s</%sVirtual_Address>\n' % (namespace_, self.format_string(quote_xml(self.Virtual_Address).encode(ExternalEncoding), input_name='Virtual_Address'), namespace_))
        if self.Size_Of_Raw_Data is not None:
            showIndent(outfile, level)
            outfile.write('<%sSize_Of_Raw_Data>%s</%sSize_Of_Raw_Data>\n' % (namespace_, self.format_string(quote_xml(self.Size_Of_Raw_Data).encode(ExternalEncoding), input_name='Size_Of_Raw_Data'), namespace_))
        if self.Pointer_To_Raw_Data is not None:
            showIndent(outfile, level)
            outfile.write('<%sPointer_To_Raw_Data>%s</%sPointer_To_Raw_Data>\n' % (namespace_, self.format_string(quote_xml(self.Pointer_To_Raw_Data).encode(ExternalEncoding), input_name='Pointer_To_Raw_Data'), namespace_))
        if self.Pointer_To_Relocations is not None:
            showIndent(outfile, level)
            outfile.write('<%sPointer_To_Relocations>%s</%sPointer_To_Relocations>\n' % (namespace_, self.format_string(quote_xml(self.Pointer_To_Relocations).encode(ExternalEncoding), input_name='Pointer_To_Relocations'), namespace_))
        if self.Pointer_To_Linenumbers is not None:
            showIndent(outfile, level)
            outfile.write('<%sPointer_To_Linenumbers>%s</%sPointer_To_Linenumbers>\n' % (namespace_, self.format_string(quote_xml(self.Pointer_To_Linenumbers).encode(ExternalEncoding), input_name='Pointer_To_Linenumbers'), namespace_))
        if self.Number_Of_Relocations is not None:
            showIndent(outfile, level)
            outfile.write('<%sNumber_Of_Relocations>%s</%sNumber_Of_Relocations>\n' % (namespace_, self.format_integer(self.Number_Of_Relocations, input_name='Number_Of_Relocations'), namespace_))
        if self.Number_Of_Linenumbers is not None:
            showIndent(outfile, level)
            outfile.write('<%sNumber_Of_Linenumbers>%s</%sNumber_Of_Linenumbers>\n' % (namespace_, self.format_integer(self.Number_Of_Linenumbers, input_name='Number_Of_Linenumbers'), namespace_))
        if self.Characteristics is not None:
            showIndent(outfile, level)
            outfile.write('<%sCharacteristics>%s</%sCharacteristics>\n' % (namespace_, self.format_string(quote_xml(self.Characteristics).encode(ExternalEncoding), input_name='Characteristics'), namespace_))
    def hasContent_(self):
        if (
            self.Hashes is not None or
            self.Name is not None or
            self.Physical_Address is not None or
            self.Virtual_Address is not None or
            self.Size_Of_Raw_Data is not None or
            self.Pointer_To_Raw_Data is not None or
            self.Pointer_To_Relocations is not None or
            self.Pointer_To_Linenumbers is not None or
            self.Number_Of_Relocations is not None or
            self.Number_Of_Linenumbers is not None or
            self.Characteristics is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PESectionHeaderStruct'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Hashes=model_.Hashes(\n')
            self.Hashes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
        if self.Physical_Address is not None:
            showIndent(outfile, level)
            outfile.write('Physical_Address=%s,\n' % quote_python(self.Physical_Address).encode(ExternalEncoding))
        if self.Virtual_Address is not None:
            showIndent(outfile, level)
            outfile.write('Virtual_Address=%s,\n' % quote_python(self.Virtual_Address).encode(ExternalEncoding))
        if self.Size_Of_Raw_Data is not None:
            showIndent(outfile, level)
            outfile.write('Size_Of_Raw_Data=%s,\n' % quote_python(self.Size_Of_Raw_Data).encode(ExternalEncoding))
        if self.Pointer_To_Raw_Data is not None:
            showIndent(outfile, level)
            outfile.write('Pointer_To_Raw_Data=%s,\n' % quote_python(self.Pointer_To_Raw_Data).encode(ExternalEncoding))
        if self.Pointer_To_Relocations is not None:
            showIndent(outfile, level)
            outfile.write('Pointer_To_Relocations=%s,\n' % quote_python(self.Pointer_To_Relocations).encode(ExternalEncoding))
        if self.Pointer_To_Linenumbers is not None:
            showIndent(outfile, level)
            outfile.write('Pointer_To_Linenumbers=%s,\n' % quote_python(self.Pointer_To_Linenumbers).encode(ExternalEncoding))
        if self.Number_Of_Relocations is not None:
            showIndent(outfile, level)
            outfile.write('Number_Of_Relocations=%d,\n' % self.Number_Of_Relocations)
        if self.Number_Of_Linenumbers is not None:
            showIndent(outfile, level)
            outfile.write('Number_Of_Linenumbers=%d,\n' % self.Number_Of_Linenumbers)
        if self.Characteristics is not None:
            showIndent(outfile, level)
            outfile.write('Characteristics=%s,\n' % quote_python(self.Characteristics).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Hashes':
            obj_ = Hashes.factory()
            obj_.build(child_)
            self.set_Hashes(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Name':
            Name_ = ''
            for text__content_ in child_.childNodes:
                Name_ += text__content_.nodeValue
            self.Name = Name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Physical_Address':
            Physical_Address_ = ''
            for text__content_ in child_.childNodes:
                Physical_Address_ += text__content_.nodeValue
            self.Physical_Address = Physical_Address_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Virtual_Address':
            Virtual_Address_ = ''
            for text__content_ in child_.childNodes:
                Virtual_Address_ += text__content_.nodeValue
            self.Virtual_Address = Virtual_Address_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Size_Of_Raw_Data':
            Size_Of_Raw_Data_ = ''
            for text__content_ in child_.childNodes:
                Size_Of_Raw_Data_ += text__content_.nodeValue
            self.Size_Of_Raw_Data = Size_Of_Raw_Data_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Pointer_To_Raw_Data':
            Pointer_To_Raw_Data_ = ''
            for text__content_ in child_.childNodes:
                Pointer_To_Raw_Data_ += text__content_.nodeValue
            self.Pointer_To_Raw_Data = Pointer_To_Raw_Data_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Pointer_To_Relocations':
            Pointer_To_Relocations_ = ''
            for text__content_ in child_.childNodes:
                Pointer_To_Relocations_ += text__content_.nodeValue
            self.Pointer_To_Relocations = Pointer_To_Relocations_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Pointer_To_Linenumbers':
            Pointer_To_Linenumbers_ = ''
            for text__content_ in child_.childNodes:
                Pointer_To_Linenumbers_ += text__content_.nodeValue
            self.Pointer_To_Linenumbers = Pointer_To_Linenumbers_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Number_Of_Relocations':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError as exp:
                    raise ValueError('requires integer (Number_Of_Relocations): %s' % exp)
                self.Number_Of_Relocations = ival_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Number_Of_Linenumbers':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError as exp:
                    raise ValueError('requires integer (Number_Of_Linenumbers): %s' % exp)
                self.Number_Of_Linenumbers = ival_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Characteristics':
            Characteristics_ = ''
            for text__content_ in child_.childNodes:
                Characteristics_ += text__content_.nodeValue
            self.Characteristics = Characteristics_
# end class PESectionHeaderStruct


class PEStringType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, length=None, encoding=None, address=None, String_Value=None, Hashes=None):
        self.length = _cast(int, length)
        self.encoding = _cast(None, encoding)
        self.address = _cast(None, address)
        self.String_Value = String_Value
        self.Hashes = Hashes
    def factory(*args_, **kwargs_):
        if PEStringType.subclass:
            return PEStringType.subclass(*args_, **kwargs_)
        else:
            return PEStringType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_String_Value(self): return self.String_Value
    def set_String_Value(self, String_Value): self.String_Value = String_Value
    def get_Hashes(self): return self.Hashes
    def set_Hashes(self, Hashes): self.Hashes = Hashes
    def get_length(self): return self.length
    def set_length(self, length): self.length = length
    def get_encoding(self): return self.encoding
    def set_encoding(self, encoding): self.encoding = encoding
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def export(self, outfile, level, namespace_='maec:', name_='PEStringType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='PEStringType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='PEStringType'):
        if self.length is not None:
            outfile.write(' length="%s"' % self.format_integer(self.length, input_name='length'))
        if self.encoding is not None:
            outfile.write(' encoding=%s' % (self.format_string(quote_attrib(self.encoding).encode(ExternalEncoding), input_name='encoding'), ))
        if self.address is not None:
            outfile.write(' address=%s' % (quote_attrib(self.address), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='PEStringType'):
        if self.String_Value is not None:
            showIndent(outfile, level)
            outfile.write('<%sString_Value>%s</%sString_Value>\n' % (namespace_, self.format_string(quote_xml(self.String_Value).encode(ExternalEncoding), input_name='String_Value'), namespace_))
        if self.Hashes:
            self.Hashes.export(outfile, level, namespace_, name_='Hashes')
    def hasContent_(self):
        if (
            self.String_Value is not None or
            self.Hashes is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PEStringType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.length is not None:
            showIndent(outfile, level)
            outfile.write('length = %d,\n' % (self.length,))
        if self.encoding is not None:
            showIndent(outfile, level)
            outfile.write('encoding = "%s",\n' % (self.encoding,))
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('address = %s,\n' % (self.address,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.String_Value is not None:
            showIndent(outfile, level)
            outfile.write('String_Value=%s,\n' % quote_python(self.String_Value).encode(ExternalEncoding))
        if self.Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Hashes=model_.Hashes(\n')
            self.Hashes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('length'):
            try:
                self.length = int(attrs.get('length').value)
            except ValueError as exp:
                raise ValueError('Bad integer attribute (length): %s' % exp)
        if attrs.get('encoding'):
            self.encoding = attrs.get('encoding').value
        if attrs.get('address'):
            self.address = attrs.get('address').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'String_Value':
            String_Value_ = ''
            for text__content_ in child_.childNodes:
                String_Value_ += text__content_.nodeValue
            self.String_Value = String_Value_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Hashes':
            obj_ = Hashes.factory()
            obj_.build(child_)
            self.set_Hashes(obj_)
# end class PEStringType


class PEImportType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, delay_load=None, File_Name=None, Virtual_Address=None, Imported_Functions=None):
        self.type_ = _cast(None, type_)
        self.delay_load = _cast(bool, delay_load)
        self.File_Name = File_Name
        self.Virtual_Address = Virtual_Address
        self.Imported_Functions = Imported_Functions
    def factory(*args_, **kwargs_):
        if PEImportType.subclass:
            return PEImportType.subclass(*args_, **kwargs_)
        else:
            return PEImportType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_File_Name(self): return self.File_Name
    def set_File_Name(self, File_Name): self.File_Name = File_Name
    def get_Virtual_Address(self): return self.Virtual_Address
    def set_Virtual_Address(self, Virtual_Address): self.Virtual_Address = Virtual_Address
    def get_Imported_Functions(self): return self.Imported_Functions
    def set_Imported_Functions(self, Imported_Functions): self.Imported_Functions = Imported_Functions
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_delay_load(self): return self.delay_load
    def set_delay_load(self, delay_load): self.delay_load = delay_load
    def export(self, outfile, level, namespace_='maec:', name_='PEImportType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='PEImportType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='PEImportType'):
        if self.type_ is not None:
            outfile.write(' type=%s' % (self.format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.delay_load is not None:
            outfile.write(' delay_load="%s"' % self.format_boolean(str_lower(str(self.delay_load)), input_name='delay_load'))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='PEImportType'):
        if self.File_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sFile_Name>%s</%sFile_Name>\n' % (namespace_, self.format_string(quote_xml(self.File_Name).encode(ExternalEncoding), input_name='File_Name'), namespace_))
        if self.Virtual_Address is not None:
            showIndent(outfile, level)
            outfile.write('<%sVirtual_Address>%s</%sVirtual_Address>\n' % (namespace_, self.format_string(quote_xml(self.Virtual_Address).encode(ExternalEncoding), input_name='Virtual_Address'), namespace_))
        if self.Imported_Functions:
            self.Imported_Functions.export(outfile, level, namespace_, name_='Imported_Functions')
    def hasContent_(self):
        if (
            self.File_Name is not None or
            self.Virtual_Address is not None or
            self.Imported_Functions is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PEImportType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
        if self.delay_load is not None:
            showIndent(outfile, level)
            outfile.write('delay_load = %s,\n' % (self.delay_load,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.File_Name is not None:
            showIndent(outfile, level)
            outfile.write('File_Name=%s,\n' % quote_python(self.File_Name).encode(ExternalEncoding))
        if self.Virtual_Address is not None:
            showIndent(outfile, level)
            outfile.write('Virtual_Address=%s,\n' % quote_python(self.Virtual_Address).encode(ExternalEncoding))
        if self.Imported_Functions is not None:
            showIndent(outfile, level)
            outfile.write('Imported_Functions=model_.Imported_Functions(\n')
            self.Imported_Functions.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('type'):
            self.type_ = attrs.get('type').value
        if attrs.get('delay_load'):
            if attrs.get('delay_load').value in ('true', '1'):
                self.delay_load = True
            elif attrs.get('delay_load').value in ('false', '0'):
                self.delay_load = False
            else:
                raise ValueError('Bad boolean attribute (delay_load)')
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'File_Name':
            File_Name_ = ''
            for text__content_ in child_.childNodes:
                File_Name_ += text__content_.nodeValue
            self.File_Name = File_Name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Virtual_Address':
            Virtual_Address_ = ''
            for text__content_ in child_.childNodes:
                Virtual_Address_ += text__content_.nodeValue
            self.Virtual_Address = Virtual_Address_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Imported_Functions':
            obj_ = Imported_Functions.factory()
            obj_.build(child_)
            self.set_Imported_Functions(obj_)
# end class PEImportType


class Imported_Functions(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Imported_Function=None):
        if Imported_Function is None:
            self.Imported_Function = []
        else:
            self.Imported_Function = Imported_Function
    def factory(*args_, **kwargs_):
        if Imported_Functions.subclass:
            return Imported_Functions.subclass(*args_, **kwargs_)
        else:
            return Imported_Functions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Imported_Function(self): return self.Imported_Function
    def set_Imported_Function(self, Imported_Function): self.Imported_Function = Imported_Function
    def add_Imported_Function(self, value): self.Imported_Function.append(value)
    def insert_Imported_Function(self, index, value): self.Imported_Function[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Imported_Functions', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Imported_Functions')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Imported_Functions'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Imported_Functions'):
        for Imported_Function_ in self.Imported_Function:
            Imported_Function_.export(outfile, level, namespace_, name_='Imported_Function')
    def hasContent_(self):
        if (
            self.Imported_Function
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Imported_Functions'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Imported_Function=[\n')
        level += 1
        for Imported_Function_ in self.Imported_Function:
            showIndent(outfile, level)
            outfile.write('model_.Imported_Function(\n')
            Imported_Function_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Imported_Function':
            obj_ = Imported_Function.factory()
            obj_.build(child_)
            self.Imported_Function.append(obj_)
# end class Imported_Functions


class Imported_Function(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Function_Name=None, Virtual_Address=None, Hint=None, Ordinal=None):
        self.Function_Name = Function_Name
        self.Virtual_Address = Virtual_Address
        self.Hint = Hint
        self.Ordinal = Ordinal
    def factory(*args_, **kwargs_):
        if Imported_Function.subclass:
            return Imported_Function.subclass(*args_, **kwargs_)
        else:
            return Imported_Function(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Function_Name(self): return self.Function_Name
    def set_Function_Name(self, Function_Name): self.Function_Name = Function_Name
    def get_Virtual_Address(self): return self.Virtual_Address
    def set_Virtual_Address(self, Virtual_Address): self.Virtual_Address = Virtual_Address
    def get_Hint(self): return self.Hint
    def set_Hint(self, Hint): self.Hint = Hint
    def get_Ordinal(self): return self.Ordinal
    def set_Ordinal(self, Ordinal): self.Ordinal = Ordinal
    def export(self, outfile, level, namespace_='maec:', name_='Imported_Function', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Imported_Function')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Imported_Function'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Imported_Function'):
        if self.Function_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sFunction_Name>%s</%sFunction_Name>\n' % (namespace_, self.format_string(quote_xml(self.Function_Name).encode(ExternalEncoding), input_name='Function_Name'), namespace_))
        if self.Virtual_Address is not None:
            showIndent(outfile, level)
            outfile.write('<%sVirtual_Address>%s</%sVirtual_Address>\n' % (namespace_, self.format_string(quote_xml(self.Virtual_Address).encode(ExternalEncoding), input_name='Virtual_Address'), namespace_))
        if self.Hint is not None:
            showIndent(outfile, level)
            outfile.write('<%sHint>%s</%sHint>\n' % (namespace_, self.format_string(quote_xml(self.Hint).encode(ExternalEncoding), input_name='Hint'), namespace_))
        if self.Ordinal is not None:
            showIndent(outfile, level)
            outfile.write('<%sOrdinal>%s</%sOrdinal>\n' % (namespace_, self.format_integer(self.Ordinal, input_name='Ordinal'), namespace_))
    def hasContent_(self):
        if (
            self.Function_Name is not None or
            self.Virtual_Address is not None or
            self.Hint is not None or
            self.Ordinal is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Imported_Function'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Function_Name is not None:
            showIndent(outfile, level)
            outfile.write('Function_Name=%s,\n' % quote_python(self.Function_Name).encode(ExternalEncoding))
        if self.Virtual_Address is not None:
            showIndent(outfile, level)
            outfile.write('Virtual_Address=%s,\n' % quote_python(self.Virtual_Address).encode(ExternalEncoding))
        if self.Hint is not None:
            showIndent(outfile, level)
            outfile.write('Hint=%s,\n' % quote_python(self.Hint).encode(ExternalEncoding))
        if self.Ordinal is not None:
            showIndent(outfile, level)
            outfile.write('Ordinal=%d,\n' % self.Ordinal)
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Function_Name':
            Function_Name_ = ''
            for text__content_ in child_.childNodes:
                Function_Name_ += text__content_.nodeValue
            self.Function_Name = Function_Name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Virtual_Address':
            Virtual_Address_ = ''
            for text__content_ in child_.childNodes:
                Virtual_Address_ += text__content_.nodeValue
            self.Virtual_Address = Virtual_Address_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Hint':
            Hint_ = ''
            for text__content_ in child_.childNodes:
                Hint_ += text__content_.nodeValue
            self.Hint = Hint_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Ordinal':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError as exp:
                    raise ValueError('requires integer (Ordinal): %s' % exp)
                self.Ordinal = ival_
# end class Imported_Function


class PEExportType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Function_Name=None, Entry_Point=None, Ordinal=None):
        self.Function_Name = Function_Name
        self.Entry_Point = Entry_Point
        self.Ordinal = Ordinal
    def factory(*args_, **kwargs_):
        if PEExportType.subclass:
            return PEExportType.subclass(*args_, **kwargs_)
        else:
            return PEExportType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Function_Name(self): return self.Function_Name
    def set_Function_Name(self, Function_Name): self.Function_Name = Function_Name
    def get_Entry_Point(self): return self.Entry_Point
    def set_Entry_Point(self, Entry_Point): self.Entry_Point = Entry_Point
    def get_Ordinal(self): return self.Ordinal
    def set_Ordinal(self, Ordinal): self.Ordinal = Ordinal
    def export(self, outfile, level, namespace_='maec:', name_='PEExportType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='PEExportType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='PEExportType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='PEExportType'):
        if self.Function_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sFunction_Name>%s</%sFunction_Name>\n' % (namespace_, self.format_string(quote_xml(self.Function_Name).encode(ExternalEncoding), input_name='Function_Name'), namespace_))
        if self.Entry_Point is not None:
            showIndent(outfile, level)
            outfile.write('<%sEntry_Point>%s</%sEntry_Point>\n' % (namespace_, self.format_string(quote_xml(self.Entry_Point).encode(ExternalEncoding), input_name='Entry_Point'), namespace_))
        if self.Ordinal is not None:
            showIndent(outfile, level)
            outfile.write('<%sOrdinal>%s</%sOrdinal>\n' % (namespace_, self.format_integer(self.Ordinal, input_name='Ordinal'), namespace_))
    def hasContent_(self):
        if (
            self.Function_Name is not None or
            self.Entry_Point is not None or
            self.Ordinal is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PEExportType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Function_Name is not None:
            showIndent(outfile, level)
            outfile.write('Function_Name=%s,\n' % quote_python(self.Function_Name).encode(ExternalEncoding))
        if self.Entry_Point is not None:
            showIndent(outfile, level)
            outfile.write('Entry_Point=%s,\n' % quote_python(self.Entry_Point).encode(ExternalEncoding))
        if self.Ordinal is not None:
            showIndent(outfile, level)
            outfile.write('Ordinal=%d,\n' % self.Ordinal)
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Function_Name':
            Function_Name_ = ''
            for text__content_ in child_.childNodes:
                Function_Name_ += text__content_.nodeValue
            self.Function_Name = Function_Name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Entry_Point':
            Entry_Point_ = ''
            for text__content_ in child_.childNodes:
                Entry_Point_ += text__content_.nodeValue
            self.Entry_Point = Entry_Point_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Ordinal':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError as exp:
                    raise ValueError('requires integer (Ordinal): %s' % exp)
                self.Ordinal = ival_
# end class PEExportType


class PESectionType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Header_Hashes=None, Data_Hashes=None, Section_Name=None, Entropy=None, Virtual_Address=None, Virtual_Size=None, Flags=None, Relocations=None):
        self.Header_Hashes = Header_Hashes
        self.Data_Hashes = Data_Hashes
        self.Section_Name = Section_Name
        self.Entropy = Entropy
        self.Virtual_Address = Virtual_Address
        self.Virtual_Size = Virtual_Size
        self.Flags = Flags
        self.Relocations = Relocations
    def factory(*args_, **kwargs_):
        if PESectionType.subclass:
            return PESectionType.subclass(*args_, **kwargs_)
        else:
            return PESectionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Header_Hashes(self): return self.Header_Hashes
    def set_Header_Hashes(self, Header_Hashes): self.Header_Hashes = Header_Hashes
    def get_Data_Hashes(self): return self.Data_Hashes
    def set_Data_Hashes(self, Data_Hashes): self.Data_Hashes = Data_Hashes
    def get_Section_Name(self): return self.Section_Name
    def set_Section_Name(self, Section_Name): self.Section_Name = Section_Name
    def get_Entropy(self): return self.Entropy
    def set_Entropy(self, Entropy): self.Entropy = Entropy
    def get_Virtual_Address(self): return self.Virtual_Address
    def set_Virtual_Address(self, Virtual_Address): self.Virtual_Address = Virtual_Address
    def get_Virtual_Size(self): return self.Virtual_Size
    def set_Virtual_Size(self, Virtual_Size): self.Virtual_Size = Virtual_Size
    def get_Flags(self): return self.Flags
    def set_Flags(self, Flags): self.Flags = Flags
    def get_Relocations(self): return self.Relocations
    def set_Relocations(self, Relocations): self.Relocations = Relocations
    def export(self, outfile, level, namespace_='maec:', name_='PESectionType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='PESectionType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='PESectionType'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='PESectionType'):
        if self.Header_Hashes:
            self.Header_Hashes.export(outfile, level, namespace_, name_='Header_Hashes')
        if self.Data_Hashes:
            self.Data_Hashes.export(outfile, level, namespace_, name_='Data_Hashes')
        if self.Section_Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sSection_Name>%s</%sSection_Name>\n' % (namespace_, self.format_string(quote_xml(self.Section_Name).encode(ExternalEncoding), input_name='Section_Name'), namespace_))
        if self.Entropy is not None:
            showIndent(outfile, level)
            outfile.write('<%sEntropy>%s</%sEntropy>\n' % (namespace_, self.format_float(self.Entropy, input_name='Entropy'), namespace_))
        if self.Virtual_Address is not None:
            showIndent(outfile, level)
            outfile.write('<%sVirtual_Address>%s</%sVirtual_Address>\n' % (namespace_, self.format_string(quote_xml(self.Virtual_Address).encode(ExternalEncoding), input_name='Virtual_Address'), namespace_))
        if self.Virtual_Size is not None:
            showIndent(outfile, level)
            outfile.write('<%sVirtual_Size>%s</%sVirtual_Size>\n' % (namespace_, self.format_integer(self.Virtual_Size, input_name='Virtual_Size'), namespace_))
        if self.Flags is not None:
            showIndent(outfile, level)
            outfile.write('<%sFlags>%s</%sFlags>\n' % (namespace_, self.format_string(quote_xml(self.Flags).encode(ExternalEncoding), input_name='Flags'), namespace_))
        if self.Relocations is not None:
            showIndent(outfile, level)
            outfile.write('<%sRelocations>%s</%sRelocations>\n' % (namespace_, self.format_integer(self.Relocations, input_name='Relocations'), namespace_))
    def hasContent_(self):
        if (
            self.Header_Hashes is not None or
            self.Data_Hashes is not None or
            self.Section_Name is not None or
            self.Entropy is not None or
            self.Virtual_Address is not None or
            self.Virtual_Size is not None or
            self.Flags is not None or
            self.Relocations is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PESectionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Header_Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Header_Hashes=model_.Header_Hashes(\n')
            self.Header_Hashes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Data_Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Data_Hashes=model_.Data_Hashes(\n')
            self.Data_Hashes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Section_Name is not None:
            showIndent(outfile, level)
            outfile.write('Section_Name=%s,\n' % quote_python(self.Section_Name).encode(ExternalEncoding))
        if self.Entropy is not None:
            showIndent(outfile, level)
            outfile.write('Entropy=%f,\n' % self.Entropy)
        if self.Virtual_Address is not None:
            showIndent(outfile, level)
            outfile.write('Virtual_Address=%s,\n' % quote_python(self.Virtual_Address).encode(ExternalEncoding))
        if self.Virtual_Size is not None:
            showIndent(outfile, level)
            outfile.write('Virtual_Size=%d,\n' % self.Virtual_Size)
        if self.Flags is not None:
            showIndent(outfile, level)
            outfile.write('Flags=%s,\n' % quote_python(self.Flags).encode(ExternalEncoding))
        if self.Relocations is not None:
            showIndent(outfile, level)
            outfile.write('Relocations=%d,\n' % self.Relocations)
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Header_Hashes':
            obj_ = Header_Hashes.factory()
            obj_.build(child_)
            self.set_Header_Hashes(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Data_Hashes':
            obj_ = Data_Hashes.factory()
            obj_.build(child_)
            self.set_Data_Hashes(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Section_Name':
            Section_Name_ = ''
            for text__content_ in child_.childNodes:
                Section_Name_ += text__content_.nodeValue
            self.Section_Name = Section_Name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Entropy':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    fval_ = float(sval_)
                except ValueError as exp:
                    raise ValueError('requires float or double (Entropy): %s' %exp)
                self.Entropy = fval_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Virtual_Address':
            Virtual_Address_ = ''
            for text__content_ in child_.childNodes:
                Virtual_Address_ += text__content_.nodeValue
            self.Virtual_Address = Virtual_Address_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Virtual_Size':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError as exp:
                    raise ValueError('requires integer (Virtual_Size): %s' % exp)
                self.Virtual_Size = ival_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Flags':
            Flags_ = ''
            for text__content_ in child_.childNodes:
                Flags_ += text__content_.nodeValue
            self.Flags = Flags_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Relocations':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError as exp:
                    raise ValueError('requires integer (Relocations): %s' % exp)
                self.Relocations = ival_
# end class PESectionType


class Header_Hashes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Hash=None):
        if Hash is None:
            self.Hash = []
        else:
            self.Hash = Hash
    def factory(*args_, **kwargs_):
        if Header_Hashes.subclass:
            return Header_Hashes.subclass(*args_, **kwargs_)
        else:
            return Header_Hashes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hash(self): return self.Hash
    def set_Hash(self, Hash): self.Hash = Hash
    def add_Hash(self, value): self.Hash.append(value)
    def insert_Hash(self, index, value): self.Hash[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Header_Hashes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Header_Hashes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Header_Hashes'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Header_Hashes'):
        for Hash_ in self.Hash:
            Hash_.export(outfile, level, namespace_, name_='Hash')
    def hasContent_(self):
        if (
            self.Hash
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Header_Hashes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Hash=[\n')
        level += 1
        for Hash_ in self.Hash:
            showIndent(outfile, level)
            outfile.write('model_.HashType(\n')
            Hash_.exportLiteral(outfile, level, name_='HashType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Hash':
            obj_ = HashType.factory()
            obj_.build(child_)
            self.Hash.append(obj_)
# end class Header_Hashes


class Data_Hashes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Hash=None):
        if Hash is None:
            self.Hash = []
        else:
            self.Hash = Hash
    def factory(*args_, **kwargs_):
        if Data_Hashes.subclass:
            return Data_Hashes.subclass(*args_, **kwargs_)
        else:
            return Data_Hashes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hash(self): return self.Hash
    def set_Hash(self, Hash): self.Hash = Hash
    def add_Hash(self, value): self.Hash.append(value)
    def insert_Hash(self, index, value): self.Hash[index] = value
    def export(self, outfile, level, namespace_='maec:', name_='Data_Hashes', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Data_Hashes')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='Data_Hashes'):
        pass
    def exportChildren(self, outfile, level, namespace_='maec:', name_='Data_Hashes'):
        for Hash_ in self.Hash:
            Hash_.export(outfile, level, namespace_, name_='Hash')
    def hasContent_(self):
        if (
            self.Hash
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Data_Hashes'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Hash=[\n')
        level += 1
        for Hash_ in self.Hash:
            showIndent(outfile, level)
            outfile.write('model_.HashType(\n')
            Hash_.exportLiteral(outfile, level, name_='HashType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Hash':
            obj_ = HashType.factory()
            obj_.build(child_)
            self.Hash.append(obj_)
# end class Data_Hashes


class PEResourceType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, Name=None, Hashes=None):
        self.type_ = _cast(None, type_)
        self.Name = Name
        self.Hashes = Hashes
    def factory(*args_, **kwargs_):
        if PEResourceType.subclass:
            return PEResourceType.subclass(*args_, **kwargs_)
        else:
            return PEResourceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Hashes(self): return self.Hashes
    def set_Hashes(self, Hashes): self.Hashes = Hashes
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def export(self, outfile, level, namespace_='maec:', name_='PEResourceType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='PEResourceType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='maec:', name_='PEResourceType'):
        if self.type_ is not None:
            outfile.write(' type=%s' % (self.format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
    def exportChildren(self, outfile, level, namespace_='maec:', name_='PEResourceType'):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('<%sName>%s</%sName>\n' % (namespace_, self.format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), namespace_))
        if self.Hashes:
            self.Hashes.export(outfile, level, namespace_, name_='Hashes')
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Hashes is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='PEResourceType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
        if self.Hashes is not None:
            showIndent(outfile, level)
            outfile.write('Hashes=model_.Hashes(\n')
            self.Hashes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('type'):
            self.type_ = attrs.get('type').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Name':
            Name_ = ''
            for text__content_ in child_.childNodes:
                Name_ += text__content_.nodeValue
            self.Name = Name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'Hashes':
            obj_ = Hashes.factory()
            obj_.build(child_)
            self.set_Hashes(obj_)
# end class PEResourceType


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print(USAGE_TEXT)
    sys.exit(1)


def parse(inFileName):
    doc = minidom.parse(inFileName)
    rootNode = doc.documentElement
    rootObj = BundleType.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="MAEC_Bundle", 
        namespacedef_='')
    return rootObj


def parseString(inString):
    doc = minidom.parseString(inString)
    rootNode = doc.documentElement
    rootObj = BundleType.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="MAEC_Bundle",
        namespacedef_='')
    return rootObj


def parseLiteral(inFileName):
    doc = minidom.parse(inFileName)
    rootNode = doc.documentElement
    rootObj = BundleType.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from MAEC_v1_1 import *\n\n')
    sys.stdout.write('import MAEC_v1_1 as model_\n\n')
    sys.stdout.write('rootObj = model_.MAEC_Bundle(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_="MAEC_Bundle")
    sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

