/*
 * Decompiled with CFR 0.152.
 */
package com.google.instrumentation.stats;

import com.google.instrumentation.common.Function;
import com.google.instrumentation.common.Timestamp;
import com.google.instrumentation.stats.DistributionAggregation;
import com.google.instrumentation.stats.IntervalAggregation;
import com.google.instrumentation.stats.ViewDescriptor;
import java.util.List;

public abstract class View {
    public abstract ViewDescriptor getViewDescriptor();

    public abstract <T> T match(Function<DistributionView, T> var1, Function<IntervalView, T> var2);

    private View() {
    }

    public static final class IntervalView
    extends View {
        private final ViewDescriptor.IntervalViewDescriptor intervalViewDescriptor;
        private final List<IntervalAggregation> intervalAggregations;

        public static IntervalView create(ViewDescriptor.IntervalViewDescriptor intervalViewDescriptor, List<IntervalAggregation> list) {
            return new IntervalView(intervalViewDescriptor, list);
        }

        public List<IntervalAggregation> getIntervalAggregations() {
            return this.intervalAggregations;
        }

        @Override
        public ViewDescriptor.IntervalViewDescriptor getViewDescriptor() {
            return this.intervalViewDescriptor;
        }

        @Override
        public <T> T match(Function<DistributionView, T> function, Function<IntervalView, T> function2) {
            return function2.apply(this);
        }

        private IntervalView(ViewDescriptor.IntervalViewDescriptor intervalViewDescriptor, List<IntervalAggregation> list) {
            this.intervalViewDescriptor = intervalViewDescriptor;
            this.intervalAggregations = list;
        }
    }

    public static final class DistributionView
    extends View {
        private final ViewDescriptor.DistributionViewDescriptor distributionViewDescriptor;
        private final List<DistributionAggregation> distributionAggregations;
        private final Timestamp start;
        private final Timestamp end;

        public static DistributionView create(ViewDescriptor.DistributionViewDescriptor distributionViewDescriptor, List<DistributionAggregation> list, Timestamp timestamp, Timestamp timestamp2) {
            return new DistributionView(distributionViewDescriptor, list, timestamp, timestamp2);
        }

        public List<DistributionAggregation> getDistributionAggregations() {
            return this.distributionAggregations;
        }

        Timestamp getStart() {
            return this.start;
        }

        Timestamp getEnd() {
            return this.end;
        }

        @Override
        public ViewDescriptor.DistributionViewDescriptor getViewDescriptor() {
            return this.distributionViewDescriptor;
        }

        @Override
        public <T> T match(Function<DistributionView, T> function, Function<IntervalView, T> function2) {
            return function.apply(this);
        }

        private DistributionView(ViewDescriptor.DistributionViewDescriptor distributionViewDescriptor, List<DistributionAggregation> list, Timestamp timestamp, Timestamp timestamp2) {
            this.distributionViewDescriptor = distributionViewDescriptor;
            this.distributionAggregations = list;
            this.start = timestamp;
            this.end = timestamp2;
        }
    }
}

