/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic;

import java.util.Arrays;
import java.util.List;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.generic.GenericTypeDescription;
import net.bytebuddy.description.type.generic.GenericTypeList;
import net.bytebuddy.utility.ByteBuddyCommons;

public interface MethodTransformer {
    public MethodDescription transform(TypeDescription var1, MethodDescription var2);

    public static class Compound
    implements MethodTransformer {
        private final List<? extends MethodTransformer> methodTransformers;

        public Compound(MethodTransformer ... methodTransformer) {
            this(Arrays.asList(methodTransformer));
        }

        public Compound(List<? extends MethodTransformer> methodTransformers) {
            this.methodTransformers = methodTransformers;
        }

        @Override
        public MethodDescription transform(TypeDescription instrumentedType, MethodDescription methodDescription) {
            MethodDescription transformed = methodDescription;
            for (MethodTransformer methodTransformer : this.methodTransformers) {
                transformed = methodTransformer.transform(instrumentedType, transformed);
            }
            return transformed;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.methodTransformers.equals(((Compound)other).methodTransformers);
        }

        public int hashCode() {
            return this.methodTransformers.hashCode();
        }

        public String toString() {
            return "MethodTransformer.Compound{methodTransformers=" + this.methodTransformers + '}';
        }
    }

    public static class Simple
    implements MethodTransformer {
        private final Transformer transformer;

        public Simple(Transformer transformer) {
            this.transformer = transformer;
        }

        public static MethodTransformer withModifiers(ModifierContributor.ForMethod ... modifierTransformer) {
            return new Simple(new Transformer.ForModifierTransformation(Arrays.asList(ByteBuddyCommons.nonNull(modifierTransformer))));
        }

        @Override
        public MethodDescription transform(TypeDescription instrumentedType, MethodDescription methodDescription) {
            return new TransformedMethod(methodDescription.getDeclaringType(), this.transformer.transform((MethodDescription.Token)methodDescription.asToken()), (MethodDescription.InDefinedShape)methodDescription.asDefined());
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.transformer.equals(((Simple)other).transformer);
        }

        public int hashCode() {
            return this.transformer.hashCode();
        }

        public String toString() {
            return "MethodTransformer.Simple{transformer=" + this.transformer + '}';
        }

        protected static class TransformedMethod
        extends MethodDescription.AbstractBase {
            private final GenericTypeDescription declaringType;
            private final MethodDescription.Token methodToken;
            private final MethodDescription.InDefinedShape definedShape;

            protected TransformedMethod(GenericTypeDescription declaringType, MethodDescription.Token methodToken, MethodDescription.InDefinedShape definedShape) {
                this.declaringType = declaringType;
                this.methodToken = methodToken;
                this.definedShape = definedShape;
            }

            @Override
            public GenericTypeList getTypeVariables() {
                return GenericTypeList.ForDetachedTypes.OfTypeVariable.attach(this, (List<? extends GenericTypeDescription>)this.methodToken.getTypeVariables());
            }

            @Override
            public GenericTypeDescription getReturnType() {
                return this.methodToken.getReturnType().accept(GenericTypeDescription.Visitor.Substitutor.ForAttachment.of(this));
            }

            @Override
            public ParameterList<?> getParameters() {
                return new TransformedParameterList();
            }

            @Override
            public GenericTypeList getExceptionTypes() {
                return GenericTypeList.ForDetachedTypes.attach(this, (List<? extends GenericTypeDescription>)this.methodToken.getExceptionTypes());
            }

            @Override
            public AnnotationList getDeclaredAnnotations() {
                return this.methodToken.getAnnotations();
            }

            @Override
            public String getInternalName() {
                return this.methodToken.getInternalName();
            }

            @Override
            public GenericTypeDescription getDeclaringType() {
                return this.declaringType;
            }

            @Override
            public int getModifiers() {
                return this.methodToken.getModifiers();
            }

            @Override
            public Object getDefaultValue() {
                return this.methodToken.getDefaultValue();
            }

            @Override
            public MethodDescription.InDefinedShape asDefined() {
                return this.definedShape;
            }

            protected class TransformedParameter
            extends ParameterDescription.AbstractBase {
                private final int index;
                private final ParameterDescription.Token parameterToken;

                protected TransformedParameter(int index, ParameterDescription.Token parameterToken) {
                    this.index = index;
                    this.parameterToken = parameterToken;
                }

                @Override
                public GenericTypeDescription getType() {
                    return this.parameterToken.getType().accept(GenericTypeDescription.Visitor.Substitutor.ForAttachment.of(this));
                }

                @Override
                public MethodDescription getDeclaringMethod() {
                    return TransformedMethod.this;
                }

                @Override
                public int getIndex() {
                    return this.index;
                }

                @Override
                public boolean isNamed() {
                    return this.parameterToken.getName() != null;
                }

                @Override
                public boolean hasModifiers() {
                    return this.parameterToken.getModifiers() != null;
                }

                @Override
                public String getName() {
                    return this.isNamed() ? this.parameterToken.getName() : super.getName();
                }

                @Override
                public int getModifiers() {
                    return this.hasModifiers() ? this.parameterToken.getModifiers().intValue() : super.getModifiers();
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return this.parameterToken.getAnnotations();
                }

                @Override
                public ParameterDescription.InDefinedShape asDefined() {
                    return (ParameterDescription.InDefinedShape)TransformedMethod.this.definedShape.getParameters().get(this.index);
                }
            }

            protected class TransformedParameterList
            extends ParameterList.AbstractBase<ParameterDescription> {
                protected TransformedParameterList() {
                }

                @Override
                public ParameterDescription get(int index) {
                    return new TransformedParameter(index, (ParameterDescription.Token)TransformedMethod.this.methodToken.getParameterTokens().get(index));
                }

                @Override
                public int size() {
                    return TransformedMethod.this.methodToken.getParameterTokens().size();
                }
            }
        }

        public static interface Transformer {
            public MethodDescription.Token transform(MethodDescription.Token var1);

            public static class ForModifierTransformation
            implements Transformer {
                private final List<? extends ModifierContributor.ForMethod> modifierContributors;

                public ForModifierTransformation(List<? extends ModifierContributor.ForMethod> modifierContributors) {
                    this.modifierContributors = modifierContributors;
                }

                @Override
                public MethodDescription.Token transform(MethodDescription.Token methodToken) {
                    int modifiers = methodToken.getModifiers();
                    for (ModifierContributor.ForMethod forMethod : this.modifierContributors) {
                        modifiers = modifiers & ~forMethod.getRange() | forMethod.getMask();
                    }
                    return new MethodDescription.Token(methodToken.getInternalName(), modifiers, methodToken.getTypeVariables(), methodToken.getReturnType(), methodToken.getParameterTokens(), methodToken.getExceptionTypes(), methodToken.getAnnotations(), methodToken.getDefaultValue());
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.modifierContributors.equals(((ForModifierTransformation)other).modifierContributors);
                }

                public int hashCode() {
                    return this.modifierContributors.hashCode();
                }

                public String toString() {
                    return "MethodTransformer.Simple.Transformer.ForModifierTransformation{modifierContributors=" + this.modifierContributors + '}';
                }
            }
        }
    }

    public static enum NoOp implements MethodTransformer
    {
        INSTANCE;


        @Override
        public MethodDescription transform(TypeDescription instrumentedType, MethodDescription methodDescription) {
            return methodDescription;
        }

        public String toString() {
            return "MethodTransformer.NoOp." + this.name();
        }
    }
}

