"use strict";

const prettier = require("prettier/local");
const concat = prettier.doc.builders.concat;

module.exports = {
  languages: [
    {
      name: "bar",
      parsers: ["bar"]
    }
  ],
  parsers: {
    bar: {
      parse: text => ({ text }),
      astFormat: "bar"
    }
  },
  printers: {
    bar: {
      print: path => concat(["bar+", path.getValue().text])
    }
  },
  defaultOptions: {
    tabWidth: 4
  }
};
