package controller

import (
	"net/http"

	"github.com/go-fuego/fuego"
	"github.com/raghavyuva/nixopus-api/internal/features/logger"
	shared_types "github.com/raghavyuva/nixopus-api/internal/types"
)

func (c *OrganizationsController) GetOrganizations(f fuego.ContextNoBody) (*shared_types.Response, error) {
	organizations, err := c.service.GetOrganizations()
	if err != nil {
		c.logger.Log(logger.Error, err.Error(), "")
		return nil, fuego.HTTPError{
			Err:    err,
			Status: http.StatusInternalServerError,
		}
	}

	return &shared_types.Response{
		Status:  "success",
		Message: "Organizations fetched successfully",
		Data:    organizations,
	}, nil
}
