package types

import "errors"

var (
	ErrMissingOrganizationID              = errors.New("organization id is required to get organizations")
	ErrFailedToGetOrganizations           = errors.New("failed to get organizations")
	ErrFailedToGetOrganization            = errors.New("failed to get organization")
	ErrMissingOrganizationName            = errors.New("name is required")
	ErrFailedToCreateOrganization         = errors.New("failed to create organization")
	ErrFailedToUpdateOrganization         = errors.New("failed to update organization")
	ErrFailedToDeleteOrganization         = errors.New("failed to delete organization")
	ErrFailedToGetOrganizationUsers       = errors.New("failed to get organization users")
	ErrFailedToAddUserToOrganization      = errors.New("failed to add user to organization")
	ErrOrganizationDoesNotExist           = errors.New("organization does not exist")
	ErrOrganizationAlreadyExists          = errors.New("organization already exists")
	ErrMissingUserID                      = errors.New("user id is required to add user to organization")
	ErrUserDoesNotExist                   = errors.New("user does not exist")
	ErrUserAlreadyInOrganization          = errors.New("user already in organization")
	ErrUserNotInOrganization              = errors.New("user not in organization")
	ErrFailedToRemoveUserFromOrganization = errors.New("failed to remove user from organization")
	ErrFailedToUpdateUserRole             = errors.New("failed to update user role")
	ErrInternalServer                     = errors.New("internal server error")
	ErrInvalidRoleID                      = errors.New("invalid role id")
	ErrMissingRoleID                      = errors.New("role id is required to add user to organization")
	ErrOrganizationNameTooLong            = errors.New("organization name is too long")
	ErrOrganizationNameContainsSpaces     = errors.New("organization name contains spaces")
	ErrOrganizationDescriptionTooLong     = errors.New("organization description is too long")
	ErrInvalidOrganizationID              = errors.New("invalid organization id")
	ErrInvalidUserID                      = errors.New("invalid user id")
	ErrInvalidRequestType                 = errors.New("invalid request type")
	ErrRoleDoesNotExist                   = errors.New("role does not exist")
	ErrOrganizationNotFound               = errors.New("organization not found")
	ErrUserNotFound                       = errors.New("user not found")
	ErrFailedToGetRoles                   = errors.New("failed to get roles")
	ErrInvalidEmail                       = errors.New("invalid email format")
)
