from typing import Protocol


class LoggerProtocol(Protocol):
    def debug(self, message: str) -> None: ...
    def info(self, message: str) -> None: ...
    def warning(self, message: str) -> None: ...
    def error(self, message: str) -> None: ...
    def success(self, message: str) -> None: ...
    def highlight(self, message: str) -> None: ...


class DockerServiceProtocol(Protocol):
    def execute_services(self, name: str, env_file: str = None, compose_file: str = None) -> tuple[bool, str]: ...
