---
outline: deep
---

# Notifications

Want to know what's happening in your workspace? We've built a simple notification system that works with email, Slack, and Discord - use whichever you prefer!

## Email Setup

To get email notifications working, you'll need to plug in your SMTP details:

| Field | Description |
|-------|-------------|
| Host | The address of your SMTP server (e.g., smtp.gmail.com) |
| Port | The port number your SMTP server uses (usually 587 for TLS) |
| Username | Your email account username |
| Password | Your email account password or app-specific password |
| From Email | The email address that will appear as the sender |
| From Name | The display name that recipients will see |
| Security | The type of security protocol (SSL/TLS) for the connection |

Once that's done, important updates will land straight in your inbox.

## Adding Slack

Getting Slack notifications is pretty straightforward. You'll need:

| Field | Description |
|-------|-------------|
| Webhook URL | The unique URL provided by Slack for sending messages to your channel |

Just add these and your Slack channel will start getting real-time updates.

## Setting up Discord

Discord is super simple - all you need is:

| Field | Description |
|-------|-------------|
| Webhook URL | The URL generated by Discord for sending messages to your channel |

Plug that in and you're good to go! Updates will show up in your Discord channel.

## What You'll Get Notified About

We've grouped notifications into three main buckets:

* Activity stuff (like new deployments)
* Security heads-ups
* System changes

For each of these, you can:
* Pick which ones you want to get
* Choose where they go (email/Slack/Discord)
* Set different rules for different types

## Tweaking Your Settings

Need to change things up? No problem! You can:
* Update your email settings
* Switch webhook URLs
* Change what triggers notifications

Everything's right there in the settings - just point and click to get it how you want it.