export interface ThemeColors {
  [key: string]: {
    background: string;
    foreground: string;
    card: string;
    'card-foreground': string;
    popover: string;
    'popover-foreground': string;
    primary: string;
    'primary-foreground': string;
    secondary: string;
    'secondary-foreground': string;
    muted: string;
    'muted-foreground': string;
    accent: string;
    'accent-foreground': string;
    destructive: string;
    'destructive-foreground': string;
    border: string;
    input: string;
    ring: string;
    radius?: string;
    'chart-1'?: string;
    'chart-2'?: string;
    'chart-3'?: string;
    'chart-4'?: string;
    'chart-5'?: string;
  };
}

export const palette = [
  'light',
  'dark',
  'aurora',
  'emerald',
  'citrus',
  'sandalwood',
  'sunset',
  'obsidian',
  'arctic-chill',
  'celestial-night',
  'material-light',
  'pearl-elegance'
];

export const themeColors: ThemeColors = {
  light: {
    background: '0 0% 100%',
    foreground: '240 10% 3.9%',
    card: '0 0% 100%',
    'card-foreground': '240 10% 3.9%',
    popover: '0 0% 100%',
    'popover-foreground': '240 10% 3.9%',
    primary: '240 5.9% 10%',
    'primary-foreground': '0 0% 98%',
    secondary: '240 4.8% 95.9%',
    'secondary-foreground': '240 5.9% 10%',
    muted: '240 4.8% 95.9%',
    'muted-foreground': '240 3.8% 46.1%',
    accent: '240 4.8% 95.9%',
    'accent-foreground': '240 5.9% 10%',
    destructive: '0 84.2% 60.2%',
    'destructive-foreground': '0 0% 98%',
    border: '240 5.9% 90%',
    input: '240 5.9% 90%',
    ring: '240 5.9% 10%',
    radius: '0.5rem',
    'chart-1': '12 76% 61%',
    'chart-2': '173 58% 39%',
    'chart-3': '197 37% 24%',
    'chart-4': '43 74% 66%',
    'chart-5': '27 87% 67%'
  },
  dark: {
    background: '20 14.3% 4.1%',
    foreground: '0 0% 95%',
    card: '24 9.8% 10%',
    'card-foreground': '0 0% 95%',
    popover: '0 0% 9%',
    'popover-foreground': '0 0% 95%',
    primary: '142.1 70.6% 45.3%',
    'primary-foreground': '144.9 80.4% 10%',
    secondary: '240 3.7% 15.9%',
    'secondary-foreground': '0 0% 98%',
    muted: '0 0% 15%',
    'muted-foreground': '240 5% 64.9%',
    accent: '12 6.5% 15.1%',
    'accent-foreground': '0 0% 98%',
    destructive: '0 62.8% 30.6%',
    'destructive-foreground': '0 85.7% 97.3%',
    border: '240 3.7% 15.9%',
    input: '240 3.7% 15.9%',
    ring: '142.4 71.8% 29.2%',
    'chart-1': '220 70% 50%',
    'chart-2': '160 60% 45%',
    'chart-3': '30 80% 55%',
    'chart-4': '280 65% 60%',
    'chart-5': '340 75% 55%'
  },
  aurora: {
    background: '276 12% 14.7%',
    foreground: '276 3% 98.5%',
    card: '276 12% 14.7%',
    'card-foreground': '276 3% 98.5%',
    popover: '276 12% 14.7%',
    'popover-foreground': '276 3% 98.5%',
    primary: '276 40% 68%',
    'primary-foreground': '276 15% 22%',
    secondary: '276 6% 27.4%',
    'secondary-foreground': '276 3% 98.5%',
    muted: '276 6% 27.4%',
    'muted-foreground': '276 12% 70.7%',
    accent: '276 6% 27.4%',
    'accent-foreground': '276 3% 98.5%',
    destructive: '0 62.8% 30.6%',
    'destructive-foreground': '25 85.7% 63.7%',
    border: '276 6% 27.4%',
    input: '276 6% 27.4%',
    ring: '276 8% 44.6%',
    'chart-1': '276 40% 48.8%',
    'chart-2': '296 35% 69.6%',
    'chart-3': '316 38% 76.9%',
    'chart-4': '256 45% 62.7%',
    'chart-5': '236 42% 64.5%'
  },
  emerald: {
    background: '170 12% 14.7%',
    foreground: '170 3% 98.5%',
    card: '170 12% 14.7%',
    'card-foreground': '170 3% 98.5%',
    popover: '170 12% 14.7%',
    'popover-foreground': '170 3% 98.5%',
    primary: '150 48% 72%',
    'primary-foreground': '150 18% 22%',
    secondary: '170 6% 27.4%',
    'secondary-foreground': '170 3% 98.5%',
    muted: '170 6% 27.4%',
    'muted-foreground': '170 12% 70.7%',
    accent: '170 6% 27.4%',
    'accent-foreground': '170 3% 98.5%',
    destructive: '0 62.8% 30.6%',
    'destructive-foreground': '25 85.7% 63.7%',
    border: '170 6% 27.4%',
    input: '170 6% 27.4%',
    ring: '150 8% 44.6%',
    'chart-1': '150 42% 48.8%',
    'chart-2': '130 35% 69.6%',
    'chart-3': '110 38% 76.9%',
    'chart-4': '170 45% 62.7%',
    'chart-5': '190 42% 64.5%'
  },
  citrus: {
    background: '80 12% 14.7%',
    foreground: '80 3% 98.5%',
    card: '80 12% 14.7%',
    'card-foreground': '80 3% 98.5%',
    popover: '80 12% 14.7%',
    'popover-foreground': '80 3% 98.5%',
    primary: '65 45% 75%',
    'primary-foreground': '65 18% 22%',
    secondary: '80 6% 27.4%',
    'secondary-foreground': '80 3% 98.5%',
    muted: '80 6% 27.4%',
    'muted-foreground': '80 12% 70.7%',
    accent: '80 6% 27.4%',
    'accent-foreground': '80 3% 98.5%',
    destructive: '0 62.8% 30.6%',
    'destructive-foreground': '25 85.7% 63.7%',
    border: '80 6% 27.4%',
    input: '80 6% 27.4%',
    ring: '65 8% 44.6%',
    'chart-1': '65 42% 48.8%',
    'chart-2': '50 35% 69.6%',
    'chart-3': '35 38% 76.9%',
    'chart-4': '80 45% 62.7%',
    'chart-5': '95 42% 64.5%'
  },
  sandalwood: {
    background: '35 4% 97%',
    foreground: '35 4% 15%',
    card: '35 4% 97%',
    'card-foreground': '35 4% 15%',
    popover: '35 4% 97%',
    'popover-foreground': '35 4% 15%',
    primary: '35 20% 45%',
    'primary-foreground': '35 4% 97%',
    secondary: '35 8% 92%',
    'secondary-foreground': '35 6% 25%',
    muted: '35 8% 92%',
    'muted-foreground': '35 8% 45%',
    accent: '35 8% 92%',
    'accent-foreground': '35 6% 25%',
    destructive: '0 84.2% 60.2%',
    'destructive-foreground': '0 0% 98%',
    border: '35 12% 88%',
    input: '35 12% 88%',
    ring: '35 20% 45%',
    'chart-1': '35 30% 62%',
    'chart-2': '15 25% 58%',
    'chart-3': '55 20% 45%',
    'chart-4': '25 30% 74%',
    'chart-5': '45 35% 67%'
  },
  sunset: {
    background: '25 12% 14.7%',
    foreground: '25 3% 98.5%',
    card: '25 12% 14.7%',
    'card-foreground': '25 3% 98.5%',
    popover: '25 12% 14.7%',
    'popover-foreground': '25 3% 98.5%',
    primary: '20 40% 68%',
    'primary-foreground': '20 15% 22%',
    secondary: '25 6% 27.4%',
    'secondary-foreground': '25 3% 98.5%',
    muted: '25 6% 27.4%',
    'muted-foreground': '25 12% 70.7%',
    accent: '25 6% 27.4%',
    'accent-foreground': '25 3% 98.5%',
    destructive: '0 62.8% 30.6%',
    'destructive-foreground': '25 85.7% 63.7%',
    border: '25 6% 27.4%',
    input: '25 6% 27.4%',
    ring: '20 8% 44.6%',
    'chart-1': '20 42% 48.8%',
    'chart-2': '5 35% 69.6%',
    'chart-3': '35 38% 76.9%',
    'chart-4': '15 45% 62.7%',
    'chart-5': '30 42% 64.5%'
  },
  obsidian: {
    background: '290 12% 14.7%',
    foreground: '290 3% 98.5%',
    card: '290 12% 14.7%',
    'card-foreground': '290 3% 98.5%',
    popover: '290 12% 14.7%',
    'popover-foreground': '290 3% 98.5%',
    primary: '290 30% 80%',
    'primary-foreground': '290 12% 22%',
    secondary: '290 6% 27.4%',
    'secondary-foreground': '290 3% 98.5%',
    muted: '290 6% 27.4%',
    'muted-foreground': '290 12% 70.7%',
    accent: '290 6% 27.4%',
    'accent-foreground': '290 3% 98.5%',
    destructive: '0 62.8% 30.6%',
    'destructive-foreground': '25 85.7% 63.7%',
    border: '290 6% 27.4%',
    input: '290 6% 27.4%',
    ring: '290 8% 44.6%',
    'chart-1': '290 42% 48.8%',
    'chart-2': '270 35% 69.6%',
    'chart-3': '310 38% 76.9%',
    'chart-4': '250 45% 62.7%',
    'chart-5': '330 42% 64.5%'
  },
  'arctic-chill': {
    background: '200 12% 14.7%',
    foreground: '200 3% 98.5%',
    card: '200 12% 14.7%',
    'card-foreground': '200 3% 98.5%',
    popover: '200 12% 14.7%',
    'popover-foreground': '200 3% 98.5%',
    primary: '200 20% 78%',
    'primary-foreground': '200 8% 22%',
    secondary: '200 6% 27.4%',
    'secondary-foreground': '200 3% 98.5%',
    muted: '200 6% 27.4%',
    'muted-foreground': '200 12% 70.7%',
    accent: '200 6% 27.4%',
    'accent-foreground': '200 3% 98.5%',
    destructive: '0 62.8% 30.6%',
    'destructive-foreground': '25 85.7% 63.7%',
    border: '200 6% 27.4%',
    input: '200 6% 27.4%',
    ring: '200 8% 44.6%',
    'chart-1': '200 42% 48.8%',
    'chart-2': '220 35% 69.6%',
    'chart-3': '180 38% 76.9%',
    'chart-4': '240 45% 62.7%',
    'chart-5': '160 42% 64.5%'
  },
  'celestial-night': {
    background: '265 12% 14.7%',
    foreground: '265 3% 98.5%',
    card: '265 12% 14.7%',
    'card-foreground': '265 3% 98.5%',
    popover: '265 12% 14.7%',
    'popover-foreground': '265 3% 98.5%',
    primary: '265 38% 72%',
    'primary-foreground': '265 15% 22%',
    secondary: '265 6% 27.4%',
    'secondary-foreground': '265 3% 98.5%',
    muted: '265 6% 27.4%',
    'muted-foreground': '265 12% 70.7%',
    accent: '265 6% 27.4%',
    'accent-foreground': '265 3% 98.5%',
    destructive: '0 62.8% 30.6%',
    'destructive-foreground': '25 85.7% 63.7%',
    border: '265 6% 27.4%',
    input: '265 6% 27.4%',
    ring: '265 8% 44.6%',
    'chart-1': '265 42% 48.8%',
    'chart-2': '245 35% 69.6%',
    'chart-3': '285 38% 76.9%',
    'chart-4': '225 45% 62.7%',
    'chart-5': '305 42% 64.5%'
  },
  'material-light': {
    background: '220 2% 98%',
    foreground: '220 6% 18%',
    card: '220 2% 98%',
    'card-foreground': '220 6% 18%',
    popover: '220 2% 98%',
    'popover-foreground': '220 6% 18%',
    primary: '220 38% 52%',
    'primary-foreground': '220 2% 98%',
    secondary: '220 6% 94%',
    'secondary-foreground': '220 8% 26%',
    muted: '220 6% 94%',
    'muted-foreground': '220 12% 48%',
    accent: '220 6% 94%',
    'accent-foreground': '220 8% 26%',
    destructive: '0 84.2% 60.2%',
    'destructive-foreground': '0 0% 98%',
    border: '220 8% 88%',
    input: '220 8% 88%',
    ring: '220 38% 52%',
    'chart-1': '220 38% 52%',
    'chart-2': '200 30% 58%',
    'chart-3': '240 35% 48%',
    'chart-4': '180 32% 62%',
    'chart-5': '260 40% 55%'
  },
  'pearl-elegance': {
    background: '110 3% 98.5%',
    foreground: '110 8% 15%',
    card: '110 3% 98.5%',
    'card-foreground': '110 8% 15%',
    popover: '110 3% 98.5%',
    'popover-foreground': '110 8% 15%',
    primary: '295 30% 45%',
    'primary-foreground': '295 3% 98.5%',
    secondary: '110 6% 95.5%',
    'secondary-foreground': '110 10% 22%',
    muted: '110 6% 95.5%',
    'muted-foreground': '110 14% 42%',
    accent: '330 15% 92%',
    'accent-foreground': '330 12% 25%',
    destructive: '0 84.2% 60.2%',
    'destructive-foreground': '0 0% 98%',
    border: '110 12% 88.5%',
    input: '110 12% 88.5%',
    ring: '295 30% 45%',
    'chart-1': '295 30% 45%',
    'chart-2': '320 35% 58%',
    'chart-3': '270 40% 52%',
    'chart-4': '340 45% 48%',
    'chart-5': '250 30% 62%'
  }
};
