﻿# Controls
Controls are the building blocks of the Azure UX. They allow users to view, edit, and analyze data. Using built in controls provides consistency across the portal.  Additionally, issues around usability, accessibility, security and any other fundamentals are handled by the Framework team.  For developer info see [top-extensions-controls.md](top-extensions-controls.md) 

<a name="text-input"></a>
## Text input
* [CopyableLabel](design-patterns-controls-CopyableLabel.md)
* [NumericTextBox](design-patterns-controls-NumericTextBox.md)
* [PasswordBox](design-patterns-controls-PasswordBox.md)
* [TextBox](design-patterns-controls-TextBox.md)
* [MultiLineTextBox](design-patterns-controls-MultiLineTextBox.md)

<a name="selectors"></a>
## Selectors
* [CheckBox](design-patterns-controls-CheckBox.md)
* [TriStateCheckBox](design-patterns-controls-TriStateCheckBox.md)
* [DropDown](design-patterns-controls-DropDown.md)
* [OptionsGroup](design-patterns-controls-OptionsGroup.md)
* [RadioButtons](design-patterns-controls-RadioButtons.md)
* [RangeSlider](design-patterns-controls-RangeSlider.md)
* [Slider](design-patterns-controls-Slider.md)
* [SubscriptionDropDown](design-pattern-controls-SubscriptionDropDown.md)
* [ResourceGroupDropDown](design-pattern-controls-ResourceGroupDropDown.md)
* [LocationDropDown](design-pattern-controls-LocationDropDown.md)

<a name="pickers"></a>
## Pickers
* [DatePicker](design-patterns-controls-DatePicker.md)
* [DateTimePicker](design-patterns-controls-DateTimePicker.md)
* [DateTimeRangePicker](design-patterns-controls-DateTimeRangePicker.md)
* [DayPicker](design-patterns-controls-DayPicker.md)
* [DurationPicker](design-patterns-controls-DurationPicker.md)
* [TimePicker](design-patterns-controls-TimePicker.md)
* [ScopePicker](design-patterns-controls-scopepicker.md)

<a name="additional-input-controls"></a>
## Additional input controls
* [DiffEditor](design-patterns-controls-DiffEditor.md)
* [EditableGrid](design-patterns-controls-EditableGrid.md)
* [Editor](design-patterns-controls-Editor.md)
* [FileUpload](design-patterns-controls-fileupload.md)
* [InputParameters](design-patterns-controls-InputParameters.md)
* [PricingControl](design-patterns-controls-PricingControl.md)
* [TagsByResource](design-patterns-controls-TagsByResource.md)

<a name="layout"></a>
## Layout
* [Accordion](design-patterns-controls-accordion.md)
* [Section](design-patterns-controls-Section.md)
* [Splitter](design-patterns-controls-Splitter.md)
* [TabControl](design-patterns-controls-TabControl.md)

<a name="content"></a>
## Content
* [CopyableLabel](design-patterns-controls-CopyableLabel.md)
* [CustomHtml](design-patterns-controls-CustomHtml.md)
* [DocsControl](design-patterns-controls-DocsControl.md)
* [Essentials](design-patterns-controls-Essentials.md)
* [InfoBalloon](design-patterns-controls-InfoBalloon.md)
* [InfoBox](design-patterns-controls-InfoBox.md)
* [FrameControl](design-patterns-controls-FrameControl.md)
* [Legend](design-patterns-controls-Legend.md)
* [Markdown](design-patterns-controls-Markdown.md)
* [TextBlock](design-patterns-controls-TextBlock.md)
* [Summary](design-patterns-controls-Summary.md)
* [Video](design-patterns-controls-Video.md)

<a name="grids-and-lists"></a>
## Grids and lists
* [DataGrid](design-patterns-controls-DataGrid.md)
* [EditableGrid](design-patterns-controls-EditableGrid.md)
* [ListView](design-patterns-controls-ListView.md)

<a name="filtering"></a>
## Filtering
* [Pill](design-patterns-controls-Pill.md)
* [PillCollection](design-patterns-controls-PillCollection.md)
* [SearchBox](design-patterns-controls-SearchBox.md)

<a name="commands"></a>
## Commands
* [Button](design-patterns-controls-button.md)
* [Toolbar](design-patterns-controls-Toolbar.md)

<a name="data-visualization"></a>
## Data visualization
* [AreaChart](design-patterns-controls-AreaChart.md)
* [BarChart](design-patterns-controls-BarChart.md)
* [Donut](design-patterns-controls-Donut.md)
* [LineChart](design-patterns-controls-LineChart.md)
* [Map](design-patterns-controls-Map.md)
* [Metrics](design-patterns-controls-Metrics.md)
* [MonitorChartV2](design-patterns-controls-MonitorChartV2.md)
* [QuotaGauge](design-patterns-controls-QuotaGauge.md)
* [ScatterChart](design-patterns-controls-ScatterChart.md)
* [SingleMetric](design-patterns-controls-SingleMetric.md)
* [SingleValueGauge](design-patterns-controls-SingleValueGauge.md)

<a name="progress-validation"></a>
## Progress &amp; validation
* [ArmErrorList](design-patterns-controls-ArmErrorList.md)
* [ProgressBar](design-patterns-controls-ProgressBar.md)

<a name="surfaces"></a>
## Surfaces
* [Blade](top-extensions-blades.md)
* [ContextPane](top-extensions-context-panes.md)
* [Dialog](top-extensions-dialogs.md)
* Card (what is the name) []()

<a name="utilities"></a>
## Utilities
* [Console](design-patterns-controls-Console.md)
* [FileDownload](design-patterns-controls-FileDownload.md)
* [LogStream](design-patterns-controls-LogStream.md)
* [OAuthButton](design-patterns-controls-OAuthButton.md)

<a name="customization"></a>
## Customization
Themes and colors are handled at the portal level see [portalfx-extensions-style-themed-color-classes.md](portalfx-extensions-style-themed-color-classes.md)

<a name="accessibility"></a>
## Accessibility
For accessibility information see [portalfx-accessibility.md](portalfx-accessibility.md)

