
<a name="stackoverflow-forums"></a>
## Stackoverflow Forums

The Ibiza team strives to answer the questions that are tagged with Ibiza tags on the Microsoft [Stackoverflow](https://stackoverflow.microsoft.com) Web site within 24 hours. If you do not receive a response within 24 hours, please email the owner associated with the tag.

To help the Azure UI team answer your questions, the submissions are categorized into various topics that are marked with tags.
To read forum submissions, enter the following in the address bar of your browser:

```https://stackoverflow.microsoft.com/questions/tagged/<ibizaTag>```

To ask a question in a forum, enter the following in the address bar of your browser.

```https://stackoverflow.microsoft.com/questions/ask?tags=<ibizaTag>```

where

**ibizaTag**:  One of the tags from the following table, without the angle brackets.

You can also click on the links in the table to open the correct Stackoverflow forum.

| Tag                                                                                                   | Purpose                                                                                       | Owner               | Contact |
| ----------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------- | ------------------- | ------- |
| [ibiza](https://stackoverflow.microsoft.com/questions/tagged/ibiza)                                   | This is a generic Ibiza tag that should only be used when none of the below tags apply to your question. The 24 hour response SLA does not apply to this tag as someone from the Ibiza team has to triage the question and send it to the appropriate owner. Please use one of the below tags when possible and resort to this tag only when none of the other tags apply.   | Shrisha Kumar     | |
| [ibiza-accessibility](https://stackoverflow.microsoft.com/questions/tagged/ibiza-accessibility)       | Questions regarding accessibility onboarding, best practices, supported accessible controls, etc. Also, questions regarding the accessibility bug process and exception process.         | Paymon Parsadmehr   | <a href="mailto:ibiza-accessibility@microsoft.com?subject=Stackoverflow: Accessibility">ibiza-accessibility@microsoft.com </a> |
|[ibiza-alert](https://stackoverflow.microsoft.com/questions/tagged/ibiza-alert)|A tag for questions related to the alerting and monitoring framework that Ibiza provides for extension owners.|Ayesha Ghaffar| |
| [ibiza-az](https://stackoverflow.microsoft.com/questions/tagged/ibiza-az)                             | Questions related to the '`Az`' FX feature that renders a standard HTML page into a Blade or Part (rendered in a child IFrame). | Brad Olenick | |
| [ibiza-blades-parts](https://stackoverflow.microsoft.com/questions/tagged/ibiza-blades-parts)         | A tag for all questions related to Ibiza Blades, Parts (Tiles), Commands.                     | Sean Watson         | |
| [ibiza-breaking-changes](https://stackoverflow.microsoft.com/questions/tagged/ibiza-breaking-changes) | Breaking changes that are are insufficiently documented on [https://aka.ms/portalfx/breaking](https://aka.ms/portalfx/breaking)  | Shrisha Kumar | |
| [ibiza-browse](https://stackoverflow.microsoft.com/questions/tagged/ibiza-browse)                     | The primary navigation path in the Azure Portal. Browse consists of the Browse/Services menu, the resource list blade, and pinned part. Browse supports ARM subscription resources, ARM tenant resources, as well as custom data or simply launching your own blade. Learn more at [http://aka.ms/portalfx/browse](http://aka.ms/portalfx/browse).                                                     | Adrienne Chan         | |
| [ibiza-controls](https://stackoverflow.microsoft.com/questions/tagged/ibiza-controls)                 | Tag for questions related to Ibiza's control library                                | Paymon Parsadmehr    | |
| [ibiza-controls-grid](https://stackoverflow.microsoft.com/questions/tagged/ibiza-controls-grid)       | A tag specially for questions related to Ibiza's Grid controls.   | Paymon Parsadmehr    | |
| [ibiza-create](https://stackoverflow.microsoft.com/questions/tagged/ibiza-create) | A tag for questions related to Ibiza's resource create experiences and provisioning APIs. | Balbir Singh        | |
| [ibiza-data](https://stackoverflow.microsoft.com/questions/tagged/ibiza-data) | A tag for questions related to the Batch API that Ibiza supports. | Balbir Singh | |
| [ibiza-development](https://stackoverflow.microsoft.com/questions/tagged/ibiza-development)   | A tag for questions related local development of extensions like IDE integration, side-loading etc. | Shrisha Kumar | |
| [ibiza-missing-docs](https://stackoverflow.microsoft.com/questions/tagged/ibiza-docs)         | Topics that are not included in [https://aka.ms/portalfx/docs](https://aka.ms/portalfx/docs), are incomplete, or are difficult to understand  | Shrisha Kumar | |
| [ibiza-forms](https://stackoverflow.microsoft.com/questions/tagged/ibiza-forms)                       | An Ibiza monitored tag for questions related to Azure Portal forms                            | Paymon Parsadmehr    | |
| [ibiza-hosting-service](https://stackoverflow.microsoft.com/questions/tagged/ibiza-hosting-service)   | Questions related to the Hosting Service. For questions related to on-boarding to the Hosting Service, please use the ibiza-onboarding tag. | Shrisha Kumar | |
| [ibiza-hubs](https://stackoverflow.microsoft.com/questions/tagged/ibiza-hubs)   | Questions related to the Hubs extension. | Balbir Singh | |
| [ibiza-localization-global](https://stackoverflow.microsoft.com/questions/tagged/ibiza-localization-global) | Questions related to Localization or globalization within the portal. Guidence on what is or is not supported, and current languages that the Portal supports.                                                             | Shrisha Kumar   | |
| [ibiza-notifications](https://stackoverflow.microsoft.com/questions/tagged/ibiza-notifications) | Tag for questions related to notifications in the Azure Portal. | Paymon Parsadmehr | |
| [ibiza-onboarding](https://stackoverflow.microsoft.com/questions/tagged/ibiza-onboarding) | A tag for questions related to on-boarding a new extension to the Azure Portal or onboarding to the Hosting Service | Santhosh Somayajula | |
| [ibiza-performance](https://stackoverflow.microsoft.com/questions/tagged/ibiza-performance)           | Questions related to Ibiza performance.                                                       | Sean Watson         | <a href="mailto:ibiza-perf@microsoft.com?subject=Stackoverflow: Performance">ibiza-perf@microsoft.com </a> |
| [ibiza-react](https://stackoverflow.microsoft.com/questions/tagged/ibiza-react)           | Questions related to Ibiza React views development.                                                       | Sean Watson         | |
| [ibiza-sdkupdate](https://stackoverflow.microsoft.com/questions/tagged/ibiza-sdkupdate)               | Issues encountered during updating from one version of the ibiza sdk to another, for example,  **NuGet**, **Node Modules**, **PowerShell**, or **AzureUX-TemplateExtension** project template-related issues   | Shrisha Kumar | |
| [ibiza-security-auth](https://stackoverflow.microsoft.com/questions/tagged/ibiza-security-auth)       | Questions related to Portal Authentication, Security model, AAD onboarding, Ibiza extension onboarding. Please provide details on your extension name and requirements/scenarios.                                         | Santhosh Somayajula | |
| [ibiza-telemetry](https://stackoverflow.microsoft.com/questions/tagged/ibiza-telemetry)               | All questions regarding Ibiza-Telemetry                                                       | Ayesha Ghaffar | ibiza-telemetry@microsoft.com</a> |
| [ibiza-test](https://stackoverflow.microsoft.com/questions/tagged/ibiza-test)                         | The CSharp test framework `Microsoft.Portal.TestFramework` and the nodejs test framework `msportalfx-test` and `msportalfx-ut` | Shrisha Kumar | |