<a name="glossary"></a>
## Glossary

This section contains a glossary of terms and acronyms that are used in this document. For common computing terms, see [https://techterms.com/](https://techterms.com/). For common acronyms, see [https://www.acronymfinder.com](https://www.acronymfinder.com).

| Term                              | Meaning |
| ---                               | --- |
| AAD                               |  |
| AMD                               | Asynchronous Module Definition |
| API                               | Application Programmer Interface |
| ARM                               | Azure Resource Manager | 
| asynchronous module definition    | A JavaScript API that specifies a mechanism that defines code modules and their dependencies in order to load them asynchronously. |
| chrome | The graphic control elements of a browser interface. These include elements like scrollbars, toolbar buttons,  the browser window frame, and other browser helper objects. | 
| CLI                               | Command Line Interface |
| CORS | Cross-origin resource sharing. A mechanism that defines a way in which a browser and server can interact to determine whether or not it is safe to allow the cross-origin requests to be served.  For example, restricted resources, like  fonts,  may be requested from domains outside the domain from other resources are served. It may use additional HTTP headers to allow users to gain permission to access selected resources from a server on a different origin. | 
| extension                         | A Web application that was developed using the Azure Portal SDK and is made available to users through the Azure Portal. |
| MVVM                 | Model-View-View-Model methodology.  A  method of software organization that separates the view from the data storage model, but depends on intelligence in the view or in the data objects so that there is no controller module that needs to process or transfer information.  The controller's function is handled instead by the device operating system or by the server that is communicating with the application. This methodology allows the application to multitask, call other functions that are located on the device, or switch between orientations without losing data or damaging the view. |
| live tile                         | An object that displays at-a-glance information without opening an app. |
| PDE | Portal Definition Exports | 
| PDL | Program Definition Language or Portal Definition Language |
| resource provider   | A service that supplies the resources that can be deployed and managed by using Resource Manager. Some common resource providers are `Microsoft.Compute`, which supplies the virtual machine resource, `Microsoft.Storage`, which supplies the storage account resource, and `Microsoft.Web`, which supplies resources related to web apps.  |
| same-origin policy | A security policy that allows scripts that are contained in one web page can access data in another web page, but only if both pages share the same URI scheme, host name, and port number.  |
| single page application           | A web application or web site that interacts with the user by dynamically rewriting the current page rather than loading entire new pages from a server. | 
| UI                                | User Interface |
| UX                                | User Experience |
| ViewModel | A code construct that separates the application view from the data model.  It conveys relevant streams of data to the View and applies the UI logic.  It also exposes methods, commands, and other elements that maintain the state of the view, or manipulates the data model as the result of actions on the view.  | 


