
<a name="samples-controls"></a>
## Samples Controls

There are some controls that are not yet ported over to the V2 programming model that uses a `create factory` method).  Additionally, there are some scenarios that are a bit more complicated than can be handled by the playground.  As such, we ship some code samples in the samples extension, which we provide to extension authors as part of the SDK. The following tables include the location of code samples for common scenarios in the samples extension.
 
**NOTE**: In the following tables, `<dir>` is the `SamplesExtension\Extension\` directory, and  `<dirParent>`  is the `SamplesExtension\` directory, based on where the samples were installed when the developer set up the SDK. If there is a working copy of the sample in the Dogfood environment, it can be experienced by using the link in the table. 

| Control              | Sample Directory                                         | Experience                                                                              |
| -------------------- | -------------------------------------------------------- | --------------------------------------------------------------------------------------- |
| Code Editor          | `<dir>\Client\V1\Controls\Editor\ViewModels`             | [https://aka.ms/portalfx/samples#blade/SamplesExtension/EditorSamplesBlade](https://aka.ms/portalfx/samples#blade/SamplesExtension/EditorSamplesBlade) |
| Controls Chart       | `<dir>\Client\V1\Controls\Chart\ViewModels`              | [https://aka.ms/portalfx/samples#blade/SamplesExtension/ChartInstructions](https://aka.ms/portalfx/samples#blade/SamplesExtension/ChartInstructions) |
| Donut                | `<dir>\Client\V2\Controls\Donut`                         | [https://aka.ms/portalfx/samples#blade/SamplesExtension/DonutBlade](https://aka.ms/portalfx/samples#blade/SamplesExtension/DonutBlade) |
| EditableGrid         | `<dir>\Client\V2\Controls\EditableGrid`                  | [https://aka.ms/portalfx/samples#blade/SamplesExtension/EditableGrid](https://aka.ms/portalfx/samples#blade/SamplesExtension/EditableGrid) |
| Essentials Control   | `<dir>\Client\V2\Controls\Essentials`                    | [https://aka.ms/portalfx/samples#blade/SamplesExtension/EssentialsIndexBlade](https://aka.ms/portalfx/samples#blade/SamplesExtension/EssentialsIndexBlade) |
| File Download Button | `<dir>\Client\V1\Controls\FileDownloadButton\ViewModels` | [https://aka.ms/portalfx/samples#blade/SamplesExtension/FileDownloadButtonInstructions](https://aka.ms/portalfx/samples#blade/SamplesExtension/FileDownloadButtonInstructions) |
| Graph                | `<dir>\Client\V1\Controls\Graph\ViewModels`              | [https://aka.ms/portalfx/samples#blade/SamplesExtension/GraphIndex](https://aka.ms/portalfx/samples#blade/SamplesExtension/GraphIndex) |
| Grid Controls        | `<dir>\Client\V1\Controls\Grid\`                         | [https://aka.ms/portalfx/samples#blade/SamplesExtension/GridInstructions](https://aka.ms/portalfx/samples#blade/SamplesExtension/GridInstructions) |
| ListView             | `<dir>\Client\V1\Controls\ListView\ViewModels`           | [https://aka.ms/portalfx/samples#blade/SamplesExtension/ListViewInstructions](https://aka.ms/portalfx/samples#blade/SamplesExtension/ListViewInstructions) |
| Pill                 | `<dir>\Client\V2\Controls\Pill`                          | [https://aka.ms/portalfx/samples#blade/SamplesExtension/PillBlade](https://aka.ms/portalfx/samples#blade/SamplesExtension/PillBlade) |
| Splitter             | `<dir>\Client\V2\Controls\Splitter`                      | [https://aka.ms/portalfx/samples#blade/SamplesExtension/SplitterBlade](https://aka.ms/portalfx/samples#blade/SamplesExtension/SplitterBlade) |
| Toolbar              | `<dir>\Client\V1\Blades\Toolbar`                         | [https://aka.ms/portalfx/samples#blade/SamplesExtension/BladeWithToolbar](https://aka.ms/portalfx/samples#blade/SamplesExtension/BladeWithToolbar) |
| Tree View            | `<dir>\Client\V1\Controls\Tree`                          | [https://aka.ms/portalfx/samples#blade/SamplesExtension/TreeBlade](https://aka.ms/portalfx/samples#blade/SamplesExtension/TreeBlade) |
