
<a name="legacy-contentunbundler-step-by-step"></a>
## Legacy ContentUnbundler step-by-step

**ContentUnbundler is no longer supported** , for migration instructions please see [https://aka.ms/portalfx/removecuvideo](https://aka.ms/portalfx/removecuvideo).

<a name="legacy-contentunbundler-step-by-step-step-by-step-onboarding"></a>
### Step-by-Step Onboarding

<a name="legacy-contentunbundler-step-by-step-step-by-step-onboarding-step-1-verify-build-output-is-in-the-correct-format"></a>
#### Step 1: Verify build output is in the correct format

The content unbundler expects the build output of the extension project to be in a specific format.

1. All assemblies that are generated by your build should be in a directory called `bin`.
1. `web.config` should be in the same level as the bin directory.
1. In short, the content unbundler should point at the same directory as you would point IIS at to load the extension.

<a name="legacy-contentunbundler-step-by-step-step-by-step-onboarding-step-2-update-isdevelopmentmode-to-false"></a>
#### Step 2: Update <code>IsDevelopmentMode</code> to <code>false</code>

Content unbundler requires development mode be set to `false` to assign correct build version to the zip file.

Update `IsDevelopmentMode` in `web.config` to `false.`

```xml
    <add key="Microsoft.Portal.Extensions.<YourExtension>.ApplicationConfiguration.IsDevelopmentMode" value="false"/>
```

Here is an example of the monitoring extension - 

```xml
    <add key="Microsoft.Portal.Extensions.MonitoringExtension.ApplicationConfiguration.IsDevelopmentMode" value="false"/> 
```

If you wish to achieve this only on release builds a [`web.Release.config`](http://go.microsoft.com/fwlink/?LinkId=125889) transform can be used.

<a name="legacy-contentunbundler-step-by-step-step-by-step-onboarding-step-3-switch-to-use-portal-logging-for-telemetry-and-traces"></a>
#### Step 3: Switch to use Portal logging for telemetry and traces

The portal provides a way for extensions to log to MDS using a feature that can be enabled in the extension. More information about the portal logging feature can be found [here](/portal-sdk/generated/top-telemetry.md#logging-telemetry).

When this feature is enabled, the logs generated by the extension can be found in a couple of tables in the portal's MDS account.

<a name="legacy-contentunbundler-step-by-step-step-by-step-onboarding-step-3-switch-to-use-portal-logging-for-telemetry-and-traces-trace-events"></a>
##### Trace Events

[`ExtEvents | where PreciseTimeStamp >ago(10m)`](https://ailoganalyticsportal-privatecluster.cloudapp.net/clusters/Azportal/databases/AzurePortal?query=ExtEvents%7Cwhere+PreciseTimeStamp%3Eago(10m))

<a name="legacy-contentunbundler-step-by-step-step-by-step-onboarding-step-3-switch-to-use-portal-logging-for-telemetry-and-traces-telemetry-events"></a>
##### Telemetry Events

[`ExtTelemetry | where PreciseTimeStamp >ago(10m)`](https://ailoganalyticsportal-privatecluster.cloudapp.net/clusters/Azportal/databases/AzurePortal?query=ExtTelemetry%7Cwhere+PreciseTimeStamp%3Eago(10m))

<a name="legacy-contentunbundler-step-by-step-step-by-step-onboarding-step-4-install-microsoft-portal-tools-contentunbundler-and-import-targets"></a>
#### Step 4: Install <code>Microsoft.Portal.Tools.ContentUnbundler</code> and import targets

`Microsoft.Portal.Tools.ContentUnbundler` provides content unbundler tool that can be run against the extension assemblies to extract static content and bundles.

- If you installed via Visual Studio, NuGet package manager or NuGet.exe it will automatically add the following target.

- If you are using CoreXT global packages.config you will have to add the target to your .csproj manually

    ```xml
    <Import Project="$(PkgMicrosoft_Portal_Tools_ContentUnbundler)\build\Microsoft.Portal.Tools.ContentUnbundler.targets" />
    ```

<a name="legacy-contentunbundler-step-by-step-step-by-step-onboarding-step-5-verify-if-your-build-has-a-version-number-set"></a>
#### Step 5: Verify if your build has a version number set

The zip file generated during the build should be named as `<BUILD_VERSION>.zip`, where `<BUILD_VERSION>` is the current version number of your build.

<a name="legacy-contentunbundler-step-by-step-step-by-step-onboarding-step-5-verify-if-your-build-has-a-version-number-set-for-extensions-using-corext"></a>
##### For extensions using <code>CoreXT</code>

Executing following command will prompt the version number

```
$>set CURRENT_BUILD_VERSION
```

In my case this prompts:

```
CURRENT_BUILD_VERSION=5.0.0.440
```

<a name="legacy-contentunbundler-step-by-step-step-by-step-onboarding-step-5-verify-if-your-build-has-a-version-number-set-for-extensions-not-using-corext"></a>
##### For extensions not using <code>CoreXT</code>

There are multiple build systems used by teams. We think you understand your build system better than us. Once you have identified how to identify build version for your build system, feel free to send a PR to help other extension developers.

<a name="legacy-contentunbundler-step-by-step-step-by-step-onboarding-step-5-verify-if-your-build-has-a-version-number-set-if-your-build-does-not-have-a-version-set"></a>
##### If your build does not have a version set

If your build does not have a version number, you can add `AssemblyInfo.cs` to you project with following content. This will set the build version to 1.0.0.0

**NOTE:** `Microsoft.Portal.Extensions.` here specifies the fully qualified name of your extension. Also, in this scenario the build version is hard-coded to 1.0.0.0

1. Add new file AssemblyInfo.cs

    ```xml
    <Compile Include="AssemblyInfo.cs" />
    ```
    
1. Update AssemblyInfo.cs content

    ```csharp
    //-----------------------------------------------------------------------------
    // Copyright (c) Microsoft Corporation.  All rights reserved.
    //-----------------------------------------------------------------------------
    using Microsoft.Portal.Framework;
    [assembly: AllowEmbeddedContent("Microsoft.Portal.Extensions.<YourExtension>")]
    [assembly: System.Reflection.AssemblyFileVersion("1.0.0.0")]
    ```

<a name="legacy-contentunbundler-step-by-step-step-by-step-onboarding-step-6-environment-specific-configuration-files"></a>
#### Step 6: Environment specific configuration files

In order to load your extension in a specific environments you will need to provide environment specific configuration file as an embedded resource in the `Content\Config` directory.

**NOTE:**
- The files need to be placed under `\Content\Config`
- The file should be set as an EmbeddedResource, otherwise the file will not be included in the output that gets generated by the content unbundler.
- The files need to be named with the following convention: <host>.<domain>.json (e.g. portal.azure.com.json, ms.portal.azure.com.json)
	
Here are example for each environment. For now, just add this empty file as an embedded resource:

1. **Dogfood:** Configuration file name should be `df.onecloud.azure-test.net.json`.

    ```xml
    <EmbeddedResource Include="Content\Config\df.onecloud.azure-test.net.json" />
    ```
    
1. **Production:** Configuration file name should be `portal.azure.com.json`.

    ```xml
    <EmbeddedResource Include="Content\Config\portal.azure.com.json" />
    ```
    
	Production environment has 3 stamps - 
    
    1. RC - rc.portal.azure.com
    1. MPAC - ms.portal.azure.com
    1. PROD - portal.azure.com
    
	One single configuration file is enough for all three stamps.
    
1. **Mooncake:** (portal.azure.cn) - Configuration file name should be `portal.azure.cn.json`.

    ```xml
    <EmbeddedResource Include="Content\Config\portal.azure.cn.json" />
    ```

1. **Blackforest:** (portal.microsoftazure.de) - Configration file name should be `portal.microsoftazure.de.json`

    ```xml
    <EmbeddedResource Include="Content\Config\portal.microsoftazure.de.json" />
    ```
    
1. **Fairfax:** (portal.azure.us) - Configuration file name should be `portal.azure.us.json`.

    ```xml
    <EmbeddedResource Include="Content\Config\portal.azure.us.json" />
    ```

Environment configuration files server 2 purposes - 

1. Make the extension available in target environment. Override settings for target environment. If there are no settings that needs to be overridden, the file should contain an empty json object.

1. The file content is a json object with key/value pairs for settings to be overridden.

When the portal requests an extension, it passes the portal host name as a query string parameter to the extension. The hosting service reads this query string parameter and checks if the extension has provided a configuration file for that portal host name. If it does then the hosting service will load that file and will merge the settings defined in the file with the settings that are included in the extension home page. If a file does not exist for the portal host name, the hosting service will respond with a 400 bad request response code.

<a name="legacy-contentunbundler-step-by-step-step-by-step-onboarding-step-6-environment-specific-configuration-files-updating-content-of-config-file"></a>
##### Updating content of config file

The portal framework expects the settings to be in the format of `Microsoft.Azure.MyExtension.MySetting`. The framework will propagate setting to the client in the format of `mySetting`. So to be able to provide a value for this setting, the `web.config` file should be something like - 

```xml
<add key="Microsoft.Azure.MyExtension.MySetting" value="myValue" />
```

The equivalent configuration file would like like:

```json
{
    "mySetting": "myValue"      
}
```

For example, if you have backend controllers that you would like to call from the client, you would add a property to your `ApplicationConfiguration` C# class that is called `ControllerEndpoint`.

You can find more information about propagating configuration to the client where [here](/portal-sdk/generated/portalfx-load-configuration.md). Once you do that, you can provide a value to that property for each cloud by adding the property name in camel casing to the environment specific config file.

```json
{
   "controllerEndpoint":"https://mycontrollerendpoint.mybackendhostname.net"
}
```

<a name="legacy-contentunbundler-step-by-step-step-by-step-onboarding-step-7-execute-content-unbundler-as-part-of-build-to-generate-zip-file"></a>
#### Step 7: Execute content unbundler as part of build to generate zip file

The tool will generate a folder and a zip file with a name same as the extension version. The folder will contain all content required to serve the extension.

<a name="legacy-contentunbundler-step-by-step-step-by-step-onboarding-step-7-execute-content-unbundler-as-part-of-build-to-generate-zip-file-build-configuration"></a>
##### Build configuration
The content unbundler target uses the below settings. They are defined in the targets file and have default values. You can override them in your project file to meet the needs of your build environment.

- `ContentUnbundlerSourceDirectory`: Defaults to `$(OutputPath)`. This needs to be set to the directory of the build output of your web project that contains your `web.config` and `/bin` dir.
- `ContentUnbundlerOutputDirectory`: Defaults to `$(OutputPath)`. This is the output directory in which content unbundler will place the unbundled content, under this directory ContentUnbundler will create a folder with name `HostingSvc`.
- `ContentUnbundlerRunAfterTargets`: Defaults to `AfterBuild`. This is used to sequence when the `RunContentUnbundler` target will run. The value of this property will be used to set the `RunContentUnbundler` targets `AfterTargets` property.
- `ContentUnbundlerExtensionRoutePrefix`: The prefix name of your extension e.g scheduler that is supplied as part of onboarding to the extension host.
 - `ContentUnbundlerZipOutput`: Defaults to false. set to `true` to zip the unbunduled output that can be used for deployment.
	
For example this is the customized configuration for scheduler extension in CoreXT

```xml
<PropertyGroup>
    <ContentUnbundlerSourceDirectory>$(WebProjectOutputDir.Trim('\'))</ContentUnbundlerSourceDirectory>
    <ContentUnbundlerOutputDirectory>$(BinariesBuildTypeArchDirectory)\HostingSvc</ContentUnbundlerOutputDirectory>
    <ContentUnbundlerExtensionRoutePrefix>[YourExtensionNameInHostingService]</ContentUnbundlerExtensionRoutePrefix>
    <ContentUnbundlerZipOutput>true</ContentUnbundlerZipOutput>
</PropertyGroup>
 ```

Outside of CoreXT, the default settings in the targets file should work for most cases. The only property that needs to be overriden is `ContentUnbundlerExtensionRoutePrefix`

```xml
<PropertyGroup>
    <ContentUnbundlerExtensionRoutePrefix>[YourExtensionNameInHostingService]</ContentUnbundlerExtensionRoutePrefix>
</PropertyGroup>
  ```

`[YourExtensionNameInHostingService]` should be replaced by an alphanumeric string that will be used when registering the extension in the hosting service. This string will be used to create the extension host name as well. Once the extension is registered in the hosting service, this value should not be changed.

<a name="legacy-contentunbundler-step-by-step-step-by-step-onboarding-step-8-upload-safe-deployment-config"></a>
#### Step 8: Upload safe deployment config

You will need to author this file.

- Property names in the `config.json` are case sensitive.
- File name `config.json` is case sensitive.

In addition to the zip files, the hosting service expects a config file in the storage account. This config file is used to specify the versions that hosting service needs to download, process and serve. The file should be called `config.json` and should have the below structure:

```json
{
    "$version": "3",
    "stage1": "1.0.0.5",
    "stage2": "1.0.0.4",
    "stage3": "1.0.0.3",
    "stage4": "1.0.0.2",
    "stage5": "1.0.0.1",
    "friendlyName": "2.0.0.0"
}
```

**`$version`:** This is a mandatory attribute and should always be defined in the `config.json`. This is the version of the current `config.json` schema. Hosting service requires extension developers to use the latest version i.e. 3.

**stage(1-5):** stage(1-5) are mandatory attributes and should always be defined in the `config.json` with a valid version number associated with it. Safe deployment requires that extensions should be rolled out to all data centers in a staged manner. Out of the box hosting service provides extension the capability to rollout extension in 5 stages. From extension developer's point of view the stages correspond to datacenters: 

- stage1: centraluseuap
- stage2: westcentralus
- stage3: southcentralus
- stage4: westus
- stage5: All other public azure regions

This essentially means that if a user request the extension to be loaded in portal, then, based on the nearest data center, portal will decide which version of extension to load. For example, based on the above mentioned `config.json` if a user from Central US region requests to load `Microsoft_Azue_MyExtension` then hosting service will load the stage 1 version i.e. 1.0.0.5 to the user. However, if a user from Singapore loads the extension then the user will be served 1.0.0.1 of the extension.

For national clouds, there are only 2 stages as outlined below - 

**Mooncake:**

- stage1: chinanorth
- stage2: All other mooncake regions

**Blackforest:**

- stage1: germanynortheast
- stage2: All other blackforest regions

**Fairfax:**

- stage1: usgovcentral
- stage2: All other fairfax regions

In addition to the stages, you can add custom names to versions that you want to test but not serve to customers. We call them friendly names. You can define up to a 100 friendly names in the `config.json`. If more than 100 friendly names are defined in the config, the hosting service will fail to sync the extension and an IcM incident will be created against the owning team. Friendly names should point to valid versions of your extension, and those versions should exist in the storage account.

Each of the properties defined in your config (stages and friendly names) get a unique url that you can use to access the version that it points to. For example, to load the version that is in stage1 above, the url would be - 

[https://myextension.hosting.portal.azure.net/myextension/stage1?l=en&trustedAuthority=portal.azure.com](https://myextension.hosting.portal.azure.net/myextension/stage1?l=en&trustedAuthority=portal.azure.com)

To load version 2.0.0.0 the url would be - 

[https://myextension.hosting.portal.azure.net/myextension/friendlyname?l=en&trustedAuthority=portal.azure.com](https://myextension.hosting.portal.azure.net/myextension/friendlyname?l=en&trustedAuthority=portal.azure.com)

<a name="legacy-contentunbundler-step-by-step-step-by-step-onboarding-step-9-registering-your-extension-with-the-hosting-service"></a>
#### Step 9: Registering your extension with the hosting service

Extensions that intend to use extension hosting service should publish the extracted deployment artifacts (zip file) that are generated during the build along with `config.json` to a public endpoint. Make sure that all the zip files and `config.json` are at the same level.

Once you have these files available on a public endpoint, file a request to register this endpoint using the following [link](https://aka.ms/extension-hosting-service/onboarding).

To onboard the extension, please provide the following information in the task:

1. Extension Name.

    For example, Microsoft_Azure_Test 
 
1. Public read-only endpoint for Dogfood.

    For example, [https://mybizaextensiondf.blob.core.windows.net/extension](https://mybizaextensiondf.blob.core.windows.net/extension)
    
1. Public read-only endpoint for PROD.

    For example, [https://mybizaextensionprod.blob.core.windows.net/extension](https://mybizaextensionprod.blob.core.windows.net/extension) 

Please submit your onboarding request [here](https://mybizaextensionprod.blob.core.windows.net/extension).

| Environment 	| SLA (in business days) 	|
|-------------	|------------------------	|
| DOGFOOD     	| 5 days                 	|
| MPAC        	| 7 days                 	|
| PROD        	| 12 days                	|
| BLACKFOREST 	| 15 days                	|
| FAIRFAX     	| 15 days                	|
| MOONCAKE    	| 15 days                	|

<a name="legacy-contentunbundler-step-by-step-step-by-step-onboarding-step-9-migrating-extensions-that-use-server-side-controllers"></a>
#### Step 9: Migrating extensions that use server side controllers

If your extension uses server side controllers, there is some extra work that needs to be done to make your extension ready for hosting in the hosting service.

1. In most cases Controllers are legacy and it is easy to get rid of Controllers. One advantage of getting rid of controllers is that all your clients such as Ibiza and powershell will now have a consistent experience. In order to get rid of controllers you can follow either of these approach:
    - If the functionality is already available from another service.
    - By Hosting serverside code within existing RP

1. If getting rid of Controllers is not a short terms task, you can deploy UI through hosting service by modifying the relative controller URLs used in client code to absolute URLS. [Here](https://msazure.visualstudio.com/One/_git/AzureUX-CloudServices/commit/ac183c0ec197de7c7fd3e1eee1f7b41eb5f2dc8b) is a sample Pull-request for cloud services extension. Post this code change, you can deploy the as a server-only service that will be behind Traffic Manager.

** Legacy ContentUnbundler FAQ **

ContentUnbundler has been replaced with v2 build output.  Maintaining FAQ below for legacy.

** My local build is slow ? How can I speed up the dev/test cycles ?**

The default F5 experience for extension development remains unchanged however with the addition of the ContentUnbundler target some teams perfer to optimize to only run it on official builds or when they set a flag to force it to run. The following example demonstrates how the Azure Scheduler extension is doing this within CoreXT.

```xml
<PropertyGroup>
    <ForceUnbundler>false</ForceUnbundler>
</PropertyGroup>
<Import Project="$(PkgMicrosoft_Portal_Tools_ContentUnbundler)\build\Microsoft.Portal.Tools.ContentUnbundler.targets" 
        Condition="'$(IsOfficialBuild)' == 'true' Or '$(ForceUnbundler)' == 'true'" />
```

** Content Unbundler throws an Aggregate Exception during build?**

This usually happens when the build output generated by content unbundler is different from the expected format. Please refer to prerequisites. More specifically following: 

1. Verify build output directory is called bin.
1. Verify you can point IIS to bin directory and load extension.
