# Breaking Changes in the last four months 
* Additional Q&A about breaking changes can be found [here](./breaking-changes.md) 
* To ask a question about breaking changes [use this](https://aka.ms/ask/ibiza-breaking-change)  


## 6.0.303.11
<table><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7364462'>7364462</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7364462'>xplat Microsoft.Portal.Tools to ship correctly named target file dotnetcore correct ordered target import</a><p><br style="box-sizing:border-box;"></span><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Expected Errors:<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">- those that use VS GUI for installing NuGet packages will get&nbsp;&nbsp;<span>warning MSB4011: &quot;Microsoft.Portal.Tools.5.0.303...\build\Microsoft.Portal.Tools.targets&quot; cannot be imported again. It was alre</span><span>ady imported at &quot;...\Microsoft.Portal.Tools.5.0.303....\build\Microsoft.Portal.Tools.V2.targets (3,3)&quot;. This is most likely a build authoring error. This subsequent import will be ignored.</span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Solution:<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">- Your \*.csproj has an import to both Microsoft.Portal.Tools.targets and Microsoft.Portal.Tools.V2.targets. Drop the import to Microsoft.Portal.Tools.V2.targets and retain the import to Microsoft.Portal.Tools.targets.<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Reason For Breaking Change<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">- xplat PackageReference syntax requires targets file to be named the same as the NuGet package for correct ordering of imports.<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">- NuGet convention states that build\ targets should have the same name as the NuGet Package.<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7343607'>7343607</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7343607'>Add dependency MSBuild DLLs to Bundle </a><p></div><div style="box-sizing:border-box;font-family:&quot;Segoe UI&quot;, system-ui, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, sans-serif;">This change introduces some required DLLs for running Bundle.exe in certain stand-alone configurations (outside of an MSBuild pipeline) which were previously unaccounted for.</div><div style="box-sizing:border-box;font-family:&quot;Segoe UI&quot;, system-ui, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, sans-serif;">This change is not expected to be breaking.</div><div style="box-sizing:border-box;font-family:&quot;Segoe UI&quot;, system-ui, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, sans-serif;"></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7283821'>7283821</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7283821'>xplat disable brotli and cloudbuild symlink resolution when running on nix</a><p></div><div><br></div><div><div style="box-sizing:border-box;">Expected Errors:<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">- If you're running MSBUILD 14 the build will produce<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br></div><div style="box-sizing:border-box;">```</div><div style="box-sizing:border-box;"><span>Unhandled Exception: System.Runtime.InteropServices.COMException: Invalid value for registry (Exception from HRESULT: 0x80040153 (REGDB_E_INVALIDVALUE))<br></span><div>&nbsp; &nbsp;at System.Runtime.InteropServices.RuntimeEnvironment.GetDeveloperPath()<br></div><div>&nbsp; &nbsp;at System.AppDomain.SetupFusionStore(AppDomainSetup info, AppDomainSetup oldInfo)<br></div><span>&nbsp; &nbsp;at System.AppDomain.SetupDomain(Boolean allowRedirects, String path, String configFile, String[] propertyNames, String[] propertyValues)</span><br></div><div style="box-sizing:border-box;"><span>```</span></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Solution:<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">- Update to a modern version of msbuild &gt;= 15.0<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Reason For Breaking Change<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="display:inline !important;"><span style="display:inline !important;">- MsBuild 14.0 was released with Visual Studio 2015.</span><br></span></div><div style="box-sizing:border-box;"><span style="display:inline !important;">- MsBuild 15.0 or above required for xplat support.</span></div><div style="box-sizing:border-box;"><br></div></div><div></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7278961'>7278961</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7278961'>Add support for pin part to Dashboard experience into msportalfx-test</a><p></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Expected Errors:<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;display:inline !important;"><span style="box-sizing:border-box;"><div style="box-sizing:border-box;"><b style="box-sizing:border-box;"></b><br style="box-sizing:border-box;">- Extensions running tests on pinning a part or blade to dashboards will have their tests fail as the new pin to dashboard pane will launch and tests will timeout with an exception.&nbsp;</div><div style="box-sizing:border-box;">- Extension that run pin tests should also ensure that full portal is instantiated during tests with Dashboards accessible as pin functionality needs access to recent dashboards for pinning.&nbsp;</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;">Solution:</span></div><div style="box-sizing:border-box;"><b style="box-sizing:border-box;"></b><br style="box-sizing:border-box;">- To continue running tests upgrade to the latest Microsoft.Portal.TestFramework.CSharp nuget version&nbsp;1.0.210.0 or higher.&nbsp;The test framework will automatically handle pinning a blade to the most recent dashboard.&nbsp;</div><div style="box-sizing:border-box;">- For pin tests that make use of pinning of a part using Fx/Pinner/Pin function calls to framework or that validate pinning of extension developed parts, should now handle the context pane opening in tests by finding the pin context pane and then pin button and clicking on the pin button.</div><div style="box-sizing:border-box;"><b style="box-sizing:border-box;"></b><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;">Reason For Breaking Change</span></div><div style="box-sizing:border-box;"><b style="box-sizing:border-box;"></b>New pin to any dashboard functionality launches a context pane for users to select a dashboard or create new. This new UI flow will cause existing tests to fail if they aren't handling the context pane.</div></span></span></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7261315'>7261315</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7261315'>Normalize msportalfx-test to import/from pattern</a><p><br style="box-sizing:border-box;"></span><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Expected Errors:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">- After updating to the latest Msportalfx-Test framework, you may get the following compile error:</div><div style="box-sizing:border-box;"><br></div><div style="box-sizing:border-box;">`This module is declared with using 'export =', and can only be used with a default import when using the 'esModuleInterop' flag.`<br></div><div style="box-sizing:border-box;"><br></div><div style="box-sizing:border-box;">The error will be surrounded with a lot of other errors about non existent properties and implicit any types, which are rooted in the initial error mentioned above.</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Solution:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">- In your tsconfig.json, add a new compiler option as follow:&nbsp;<span style="font-family:Consolas, &quot;Courier New&quot;, monospace;color:rgb(4, 81, 165);">`&quot;esModuleInterop&quot;</span><span style="font-family:Consolas, &quot;Courier New&quot;, monospace;">:&nbsp;</span><span style="font-family:Consolas, &quot;Courier New&quot;, monospace;color:rgb(0, 0, 255);">true`</span></div><div style="box-sizing:border-box;"><span style="font-family:Consolas, &quot;Courier New&quot;, monospace;color:rgb(0, 0, 255);"><br></span></div><div style="box-sizing:border-box;"><span style="font-family:Consolas, &quot;Courier New&quot;, monospace;color:rgb(0, 0, 255);">Note that enabling `esModuleInterop` may create new errors once it is turned on like these:</span></div><div style="box-sizing:border-box;"><span style="font-family:Consolas, &quot;Courier New&quot;, monospace;color:rgb(0, 0, 255);"><br></span></div><div style="box-sizing:border-box;"><span style="font-family:Consolas, &quot;Courier New&quot;, monospace;color:rgb(0, 0, 255);">- `Type originates at this import. A namespace-style import cannot be called or constructed, and will cause a failure at runtime. Consider using a default import or import require here instead.`</span></div><div style="box-sizing:border-box;"><span style="font-family:Consolas, &quot;Courier New&quot;, monospace;color:rgb(0, 0, 255);">- `Type 'typeof Q' has no call signatures.`</span></div><div style="box-sizing:border-box;"><br></div><div style="box-sizing:border-box;">They should be few, and likely are related to your import of the Q, nconf and assert libraries. Fix for Q and other errors as such:</div><div style="box-sizing:border-box;"><br></div><div style="box-sizing:border-box;">Before: `import * as Q from &quot;q&quot;;`</div><div style="box-sizing:border-box;"><br></div><div style="box-sizing:border-box;">After: `import Q from &quot;q&quot;;`</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Reason For Breaking Change**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">- Normalization of import pattern improves the code maintainability and import/from is the pattern that aligns with ES6. The current import/require pattern is maintained and still works.</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><span style="box-sizing:border-box;"></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7232935'>7232935</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7232935'>Obsolete old file download control</a><p><br></span><div><br></div><div>**Expected Errors:**<br></div><div>You will hit compilation error when using the below view models as they are getting obsoleted,<br></div><div>MsPortalFx.ViewModels.Controls.FileDownload<br></div><div>MsPortalFx.ViewModels.Controls.FileDownloadButton<br></div><div><br></div><div>**Solution:**<br></div><div>Please migrate to the new AMD modules in Fx/Controls/FileDownload for download scenarios.<br></div><div><br></div><div>**Reason For Breaking Change**<br></div><div>MsPortalFx namespace in non-AMD module. For perf reasons and using new api pattern we have exposed AMD modules under Fx/Controls and asking partners to migrate to new API patterns.<br></div><div>Please refer to https://aka.ms/portalfx/breaking for more details.<br></div><div><br></div><span></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7216444'>7216444</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7216444'>[Hubs] [Breaking change] Obsolete MsPortalFx.Base.Net</a><p><br></span><div>&nbsp;<br></div><div>**Expected Errors:**<br></div><div>&nbsp;- Expect compile-time errors when using APIs in MsPortalFx.Base.Net module.<br></div><div>&nbsp;<br></div><div>**Solution:**<br></div><div>&nbsp;- Please use MsPortalFx.Base.Net2 or preferably the &quot;Fx/Ajax&quot; module for the functionality previously used in MsPortalFx.Base.Net<br></div><div>&nbsp;<br></div><div>**Reason For Breaking Change**<br></div><div>&nbsp;- MsPortalFx.Base.Net was deprecated in 2017. marking as obsolete so these older APIs can be removed in a future SDK.<br></div><div><br></div><div></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7212383'>7212383</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7212383'>update to eslint v7</a><p></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Expected Errors:<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;display:inline !important;"><span style="box-sizing:border-box;"><div style="box-sizing:border-box;"><b style="box-sizing:border-box;"></b><br style="box-sizing:border-box;">-&nbsp; no known expected errors however teams with a high level of customization e.g using rules that are now deprecated may need to update per the eslint7 migration guide.</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;">Solution:</span></div><div style="box-sizing:border-box;"><b style="box-sizing:border-box;"></b><br style="box-sizing:border-box;">- Its unlikely that you will be impacted however if you are follow the relevant eslint7 migration guide&nbsp;<a href="https://eslint.org/docs/user-guide/migrating-to-7.0.0#breaking-changes-for-users" style="box-sizing:border-box;text-decoration:underline;cursor:pointer;">https://eslint.org/docs/user-guide/migrating-to-7.0.0#breaking-changes-for-users</a></div><div style="box-sizing:border-box;"><b style="box-sizing:border-box;"></b><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;">Reason For Breaking Change</span></div><div style="box-sizing:border-box;"><b style="box-sizing:border-box;"></b><br style="box-sizing:border-box;">- fixes an eslint bug on windows that we contributed back impacts our workflow</div><div style="box-sizing:border-box;">- replaces synchronous CLIEngine with new async ESLint api</div></span></span></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7165931'>7165931</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7165931'>Deprecate/Obsolete old Donut/Gauge controls</a><p><br style="box-sizing:border-box;"></span><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Expected Errors:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">You will hit compilation error when using MsPortalFx view models for the below ontrols as these are getting obsoleted.</div><div style="box-sizing:border-box;"><span><br></span><span>MsPortalFx.ViewModels.Controls.Visualization.Donut</span></div><div style="box-sizing:border-box;"><span>MsPortalFx.ViewModels.Controls.Visualization.QuotaGauge</span></div><div style="box-sizing:border-box;"><span>MsPortalFx.ViewModels.Controls.Visualization.SingleValueGauge</span><br></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Solution:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Please migrate to the new AMD modules in Fx/Controls/</div><div style="box-sizing:border-box;">Fx/Controls/Donut</div><div style="box-sizing:border-box;"><span style="display:inline !important;background-color:rgba(255, 255, 255, 1);">Fx/Controls/QuotaGauge</span></div><div style="box-sizing:border-box;"><span style="display:inline !important;background-color:rgba(255, 255, 255, 1);">Fx/Controls/SingleValueGauge</span></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Reason For Breaking Change**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">MsPortalFx namespace in non-AMD module. For perf reasons and using new api pattern we have exposed AMD modules under Fx/Controls and asking partners to migrate to new API patterns.</div><div style="box-sizing:border-box;"><div style="box-sizing:border-box;">Please refer to https://aka.ms/portalfx/breaking for more details.<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;"></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7103953'>7103953</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7103953'>[Hubs][Breaking change] Remove enableSupportTroubleshoot from ResourceMenuOptions</a><p></div><div>&nbsp;</div><div>**Expected Errors:**</div><div>&nbsp;</div><div><ul><li>Expect compile-time errors when using the &quot;enableSupportTroubleshoot&quot; option in ResourceMenuOptions for an asset type.</li></ul></div><div>&nbsp;</div><div>**Solution:**</div><div>&nbsp;</div><div><ul><li>Use the enableSupportTroubleshootV2 option</li></ul></div><div>&nbsp;</div><div>**Reason For Breaking Change**</div><div>&nbsp;</div><div><ul><li>enableSupportTroubleshoot option adds a resource menu option that targets the same blade as enableSupportTroubleshootV2. Removing old option to reduce API bloat.<br></li></ul></div><div><br></div><div></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7102872'>7102872</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7102872'>Remove HeroBanner and other already obsoleted APIs</a><p></span><br></div><div style="box-sizing:border-box;"><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Expected Errors:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><ol><li>'signInFlags' are no longer supported in Fx/Redirect.ForceSignInOptions and usage of those will cause a compile time error and a runtime failure</li><li>MsPortalFx.ViewModels.Controls.TypableControl,&nbsp;<span style="display:inline !important;">MsPortalFx.ViewModels.Controls.ValidationPlacements and&nbsp;<span style="display:inline !important;">MsPortalFx.ViewModels.Controls.Visualization.CsmTopology</span></span>&nbsp;have been removed from runtime. These were already obsoleted and extensions should not have been using them.</li><li><span>MsPortalFx.ViewModels.Controls.HeroBanner has been removed and any usage of this will cause a compile time error.</span><br></li></ol><div><br></div></div><div style="box-sizing:border-box;">**Solution:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><ol><li>Use 'signInParameters' instead of 'signInFlags' in Fx/Redirect.ForceSigInOptions</li><li>For the controls which are removed from runtime, there should not be any action item from extensions as they were already obsoleted and should not have been used anymore as they are outside of backward compatibility window.</li><li><span style="display:inline !important;">MsPortalFx.ViewModels.Controls.HeroBanner is no longer supported. If you still depend on it, you can build the experience yourself using custom HTML.</span><br></li></ol></div><div style="box-sizing:border-box;">**Reason For Breaking Change**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><ol><li>Sign in workflows are changed and the model of passing parameters has been updated.</li><li><span style=""><span style="display:inline !important;">MsPortalFx.ViewModels.Controls.HeroBanner</span> has only a single usage and is very basic UI. If this is still needed, extensions should build this experience on their own using custom HTML.</span><br></li></ol></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;"></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7066128'>7066128</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7066128'>Update Portal SDK to TypeScript 3.9</a><p><br style="box-sizing:border-box;"></span><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Expected Errors:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">There may be typing errors where there were none before, due to the improved type inference, especially with callbacks and union types.</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Solution:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Please review the <span style="display:inline !important;">[Breaking Changes in TypeScript](https://github.com/Microsoft/TypeScript/wiki/Breaking-Changes) wiki to understand the breaking changes and options to re-solve issues.</span></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Reason For Breaking Change**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span>The TypeScript compiler in use by the SDK has been upgraded to 3.9 (from 3.5).<br></span><div>There are a few breaking changes in the compiler itself. See [Breaking Changes in TypeScript](https://github.com/Microsoft/TypeScript/wiki/Breaking-Changes).<br></div><div>There are a lot of improvements and new &nbsp;features in the language and bug fixes / improvements in the compiler. Please read the articles for [3.6](https://devblogs.microsoft.com/typescript/announcing-typescript-3-6/), [3.7](https://devblogs.microsoft.com/typescript/announcing-typescript-3-7/), [3.8](https://devblogs.microsoft.com/typescript/announcing-typescript-3-8/) and [3.9](https://devblogs.microsoft.com/typescript/announcing-typescript-3-9/) if you are interested in the full details of what changed since 3.5.</div></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;"></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7064237'>7064237</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7064237'>Deprecate StaticSection</a><p><br style="box-sizing:border-box;"></span></div><div style="box-sizing:border-box;"><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Expected Warnings:**</div><div style="box-sizing:border-box;">MsPortalFx.ViewModels.Forms.StaticSection.ViewModel is no longer supported.&nbsp;<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br></div><div style="box-sizing:border-box;">**Solution:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">P<span style="display:inline !important;">lease use Fx/Controls/Sections in place of this control. You might need to change the template a little as the StaticSection supported adding children directly in the template, whereas the Section control only allows adding children via the ViewModel.</span></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Reason For Breaking Change**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">The old variants of controls are being deprecated for the newer more performant AMD versions of controls.</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;"></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063649'>7063649</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063649'>Deprecate old selector models</a><p><br style="box-sizing:border-box;"></span></div><div style="box-sizing:border-box;"><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Expected Errors:**<br style="box-sizing:border-box;"></div></div><div>MsPortalFx.ViewModels.Forms.CreatorAndSelectorV2<br></div><div>MsPortalFx.ViewModels.Controls.Wizard</div><div>MsPortalFx.ViewModels.Forms.Selector</div><div>- [...].[...] is no&nbsp;longer&nbsp;a&nbsp;supported&nbsp;navigation/layout&nbsp;model.&nbsp;Please&nbsp;redesign&nbsp;the&nbsp;blades&nbsp;for&nbsp;better&nbsp;full&nbsp;screen&nbsp;blade&nbsp;experiences.</div><div style="box-sizing:border-box;"><div style="box-sizing:border-box;"><br></div><div style="box-sizing:border-box;">**Solution:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Redesign
the blades for better full screen blade experiences.<br></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Reason For Breaking Change**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><div><table style="border-collapse:collapse;border-style:solid;border-color:#A3A3A3;border-width:1pt;" title="">
 <tbody><tr>
  </tr></tbody></table></div></div><div style="box-sizing:border-box;">These three controls are no longer a supported navigation/layout model and has been communicated as
deprecated for 2+ years. Extensions should redesign the blades for a better full-screen experience.<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;"></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063623'>7063623</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063623'>Deprecate old list view</a><p><br style="box-sizing:border-box;"></span></div><div style="box-sizing:border-box;"><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">The Ms<span style="display:inline !important;">PortalFx.ViewModels.Controls.Lists.ListView and <span style="display:inline !important;">MsPortalFx.ViewModels.Controls.Lists.Gallery&nbsp;</span>controls are being deprecated.&nbsp; Going forward extensions should use &quot;Fx/Controls/ListView&quot; instead.&nbsp; Build processes may run into the following errors.</span></div><div style="box-sizing:border-box;"><span style="display:inline !important;"><br></span></div><div style="box-sizing:border-box;"><span>TsLint rule violations:</span></div><div style="box-sizing:border-box;"><span>&quot;ViewModel is deprecated: MsPortalFx.ViewModels.Controls.Lists.ListView is deprecated.&quot;<br></span><div><br></div><div>To resolve the violations replace&nbsp;<span style="display:inline !important;">MsPortalFx.ViewModels.Controls.Lists.ListView and <span style="display:inline !important;">MsPortalFx.ViewModels.Controls.Lists.Gallery&nbsp;</span>controls with the&nbsp;</span>&quot;Fx/Controls/ListView&quot; control.<br></div><div><br></div><div><span style="">SpecPickerExtenders may also run into compilation errors such as:</span><br></div><div><br></div><div>&quot;is not assignable to type 'SpecPickerExtender'&quot;<br></div><div>&quot;'selectionMode' in type '' is not assignable to the same property in base type 'SpecPickerExtender'&quot;<br></div><div><br></div><div>To fix the SpecPickerExtender change usage of &quot;MsPortalFx.ViewModels.Controls.Lists.ListView.SelectionMode&quot; to &quot;HubsExtension.Azure.SpecPicker.SelectionMode&quot;.<br></div><div><br></div><div>PairedTimeline usage may also run into compilation errors such as:</div><div><br></div><div>&quot;is not assignable to parameter of type 'ExtensionOptions'&quot;<br></div><div>&quot;Property 'selectable' in type '' is not assignable to the same property in base type 'ExtensionOptions'.&quot;<br></div><div>&quot;Property 'selectionMode' in type '' is not assignable to the same property in base type 'SelectableOptions'&quot;<br></div><div><br></div><div>To fix the PairedTimeline change usage of types from &quot;MsPortalFx.ViewModels.Controls.Lists.ListView&quot; to equivalent types from &quot;Fx/Controls/PairedTimeline&quot;.<br></div><div><br></div><div><span style=""></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063515'>7063515</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063515'>Deprecate old chart controls</a><p><br></div><div><br></div><div>**Expected Errors:**<br></div><div>You will hit tslint errors when using the below view models as they are getting deprecated,<br></div><div>&nbsp;MsPortalFx.ViewModels.Controls.Visualization.Chart<br></div><div>&nbsp;MsPortalFx.ViewModels.Controls.Visualization.SimpleChart<br></div><div><br></div><div>**Solution:**<br></div><div>&nbsp;Please migrate to Fx/Controls/LineChart or Fx/Controls/BarChart or Fx/Controls/AreaChart or Fx/Controls/ScatterChart.<br></div><div>&nbsp; &nbsp; <br></div><div><br></div><div>**Reason For Breaking Change**<br></div><div>MsPortalFx namespace in non-AMD module. For perf reasons and using new api pattern we have exposed AMD modules under Fx/Controls and asking partners to migrate to new API patterns.<br></div><div>Please refer to https://aka.ms/portalfx/breaking for more details.<br></div><div><br></div><div></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063498'>7063498</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063498'>Deprecate/Obsolete old balloons</a><p><br style="box-sizing:border-box;"></span><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><div style="box-sizing:border-box;">**Expected Errors:**&nbsp;Usage of the old `Balloon` view models and options (i.e. `MsPortalFx.ViewModels.Controls.Balloon` and `MsPortalFx.ViewModels.Controls.DockedBalloon`) will be flagged as a compile-time TSLint error at build time:</div><br><div style="box-sizing:border-box;font-family:Consolas, &quot;Courier New&quot;, monospace;font-weight:normal;"><span style="box-sizing:border-box;color:rgb(0, 128, 0);">&nbsp;*&nbsp;</span><span style="box-sizing:border-box;color:rgb(0, 0, 255);">@deprecated</span><span style="box-sizing:border-box;color:rgb(0, 128, 0);">&nbsp;[...][Docked]Balloon[...] is&nbsp;deprecated.&nbsp;Use&nbsp;</span><span style="box-sizing:border-box;color:rgb(0, 128, 0);">Fx/Controls/InfoBalloon&nbsp;instead.</span></div></div><div style="box-sizing:border-box;"><div style="color:#000000;background-color:#ffffff;font-family:Consolas, 'Courier New', monospace;font-weight:normal;"><div><span style="color:#008000;">&nbsp;*&nbsp;Please&nbsp;refer&nbsp;to&nbsp;<a href="https://aka.ms/portalfx/breaking">https://aka.ms/portalfx/breaking</a>&nbsp;for&nbsp;more&nbsp;details.</span></div></div><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><img src="https://msazure.visualstudio.com/b32aa71e-8ed2-41b2-9d77-5bc261222004/_apis/wit/attachments/283bac13-2581-494a-b111-552232114c7b?fileName=image.png" alt=Image><br></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><ul><li><span style="box-sizing:border-box;"><div style="box-sizing:border-box;"><div style="box-sizing:border-box;">Additionally, the <a href="https://ms.portal.azure.com/?Microsoft_Azure_Playground=true#blade/Microsoft_Azure_Playground/ControlsIndexBlade/Pill_create_Playground">Fx Pill</a> and the Fx&nbsp;<a href="https://df.onecloud.azure-test.net/#blade/SamplesExtension/PairedTimelineInstructions">PairedTimelineBadges </a>controls do not accept the MsPortalFx.DockedBalloon.ViewModel argument, but an <a href="https://ms.portal.azure.com/?Microsoft_Azure_Playground=true#blade/Microsoft_Azure_Playground/ControlsIndexBlade/InfoBalloon_create_Playground">Fx InfoBalloon.Contract</a> instead.</div></div></span></li></ul></div><div style="box-sizing:border-box;"><br></div><div style="box-sizing:border-box;">**Solution:**&nbsp;<span>Please use</span><span>&nbsp;</span><span>Fx/Controls/InfoBalloon</span><span>&nbsp;</span><span>instead:</span></div><div style="box-sizing:border-box;"><ul style="box-sizing:border-box;padding:0px 0px 0px 40px;"><li style="box-sizing:border-box;"><a href="https://ms.portal.azure.com/?Microsoft_Azure_Playground=true#blade/Microsoft_Azure_Playground/ControlsIndexBlade/InfoBalloon_create_Playground">https://ms.portal.azure.com/?Microsoft_Azure_Playground=true#blade/Microsoft_Azure_Playground/ControlsIndexBlade/InfoBalloon_create_Playground</a><br style="box-sizing:border-box;"></li></ul></div><div style="box-sizing:border-box;">**Reason For Breaking Change:**&nbsp;<span lang=EN-US style="box-sizing:border-box;margin:0px;color:windowtext;font-weight:normal;text-align:left;font-size:11pt;font-family:Calibri, Calibri_MSFontService, sans-serif;"><span style="box-sizing:border-box;margin:0px;"><span lang=EN-US style="box-sizing:border-box;margin:0px;"><span style="box-sizing:border-box;margin:0px;">This control has a better accessibility support in the new variant.</span></span></span></span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;"></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063490'>7063490</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063490'>Deprecate old controls: MsPortalFx.ViewModels.Controls.InfoBox, MsPortalFx.ViewModels.Forms.CustomHtml, MsPortalFx.ViewModels.Forms.Section</a><p><br style="box-sizing:border-box;"></span></div><div style="box-sizing:border-box;"><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Expected Errors:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Users of these controls would see a warning which says that the control is deprecated and should be replaced by a newer control.</div><div style="box-sizing:border-box;"><ul><li><span style="box-sizing:border-box;">MsPortalFx.ViewModels.Controls.InfoBox</span></li><li>MsPortalFx.ViewModels.Forms.CustomHtml</li><li><span style="box-sizing:border-box;">MsPortalFx.ViewModels.Forms.Section</span></li></ul></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Solution:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Please use the newer control defined under &quot;Fx/Controls&quot; instead of using MsPortalFx controls.</div><div style="box-sizing:border-box;">Example, import&nbsp;CustomHtmlfrom &quot;Fx/Controls/CustomHtml&quot; instead of&nbsp;MsPortalFx.ViewModels.Forms.CustomHtml.</div><div style="box-sizing:border-box;"><br></div><div style="box-sizing:border-box;">The deprecated controls and their replacements are mentioned below:</div><div style="box-sizing:border-box;"><br></div><div style="box-sizing:border-box;"><b>Deprecated Control -&gt; Replacement control</b></div><div style="box-sizing:border-box;"><b><br></b></div><div style="box-sizing:border-box;"><span>MsPortalFx.ViewModels.Controls.InfoBox&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;-&gt; Fx/Controls/InfoBox<br></span><div>MsPortalFx.ViewModels.Forms.CustomHtml&nbsp; &nbsp; &nbsp; &nbsp;-&gt;&nbsp;<span style="display:inline !important;">Fx/Controls/<span style="display:inline !important;">CustomHtml&nbsp; &nbsp; &nbsp; &nbsp;</span></span><br></div><span>MsPortalFx.ViewModels.Forms.Section&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;-&gt;&nbsp;<span style="display:inline !important;">Fx/Controls/<span style="display:inline !important;">Section&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></span></span><br></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Reason For Breaking Change**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">We are no longer supporting these controls. They are deprecated and should be replaced by corresponding newer controls.</div><div style="box-sizing:border-box;"><br></div><div style="box-sizing:border-box;"><br></div><div style="box-sizing:border-box;"><span></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063486'>7063486</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063486'>Remove old controls</a><p><br style="box-sizing:border-box;"></span></div><div style="box-sizing:border-box;"><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Expected Errors:** The following interfaces and classes have been marked as of type `Obsolete` and their usages will be flagged as compile errors at build time:</div><span style="box-sizing:border-box;text-align:left;background-color:rgb(255, 255, 254);"><br style="box-sizing:border-box;"><font color="#008080" face="Consolas, Courier New, monospace" style="box-sizing:border-box;"><span style="box-sizing:border-box;font-size:12px;">MsPortalFx.ViewModels.Controls.Splitter.Options and&nbsp;</span></font><div style="box-sizing:border-box;color:rgb(0, 128, 128);font-family:Consolas, &quot;Courier New&quot;, monospace;font-size:12px;"><div style="box-sizing:border-box;">MsPortalFx.ViewModels.Controls.Splitter.ViewModel</div></div><ul style="box-sizing:border-box;padding:0px 0px 0px 40px;color:rgb(0, 128, 128);font-family:Consolas, &quot;Courier New&quot;, monospace;font-size:12px;"><li style="box-sizing:border-box;"><div style="box-sizing:border-box;background-color:rgb(255, 255, 254);font-weight:normal;"><span style="box-sizing:border-box;"><div style="box-sizing:border-box;background-color:rgb(255, 255, 254);"></div></span></div></li></ul><div style="box-sizing:border-box;font-family:Consolas, &quot;Courier New&quot;, monospace;font-size:12px;display:inline !important;"><span style="box-sizing:border-box;color:rgb(0, 128, 128);">MsPortalFx.ViewModels.Controls.SearchBox</span><span style="box-sizing:border-box;color:rgb(0, 128, 128);">.Options and&nbsp;</span><span style="box-sizing:border-box;color:rgb(0, 128, 128);"><div style="box-sizing:border-box;"><div style="box-sizing:border-box;">MsPortalFx.ViewModels.Controls.SearchBox.ViewModel</div></div><div style="box-sizing:border-box;"></div><br><span style="background-color:rgb(255, 255, 254);display:inline !important;">MsPortalFx.ViewModels.Controls.Visualization.ProgressBar.Options,</span><div style="box-sizing:border-box;"><span style="background-color:rgb(255, 255, 254);display:inline !important;">MsPortalFx.ViewModels.Controls.Visualization.ProgressBar.Contract, and&nbsp;</span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><div style="box-sizing:border-box;">MsPortalFx.ViewModels.Controls.Visualization.ProgressBar.ViewModel</div></div><br style="box-sizing:border-box;">MsPortalFx.ViewModels.Controls.TextBlock.Options and&nbsp;<div style="box-sizing:border-box;"><div style="box-sizing:border-box;">MsPortalFx.ViewModels.Controls.TextBlock.ViewModel</div></div><br style="box-sizing:border-box;background-color:rgb(255, 255, 254);"><span style="box-sizing:border-box;background-color:rgb(255, 255, 254);display:inline !important;">MsPortalFx.ViewModels.</span><span style="box-sizing:border-box;background-color:rgb(255, 255, 254);display:inline !important;">Controls.Forms.CopyableLabel</span><span style="box-sizing:border-box;background-color:rgb(255, 255, 254);display:inline !important;">.Options,</span><br><span style="background-color:rgb(255, 255, 254);display:inline !important;">MsPortalFx.ViewModels.Controls.Forms.CopyableLabel.Contract, and</span><div style="box-sizing:border-box;"><div style="box-sizing:border-box;"><span style="background-color:rgb(255, 255, 254);display:inline !important;">MsPortalFx.ViewModels.Controls.Forms.CopyableLabel.ViewModel</span></div></div><br style="box-sizing:border-box;">MsPortalFx.ViewModels.Controls.SimpleButton.Options and&nbsp;<div style="box-sizing:border-box;"><div style="box-sizing:border-box;">MsPortalFx.ViewModels.Controls.SimpleButton.ViewModel</div></div></span></div></span><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Additionally, `MsPortalFx.ViewModels.PartOperationList.<span style="font-family:Consolas, &quot;Courier New&quot;, monospace;">progressBarViewModel` is getting obsoleted: please do not use this API field anymore as it is of type `Obsolete` and will consequently generate compile time build errors.</span></div><div style="box-sizing:border-box;"><br></div><div style="box-sizing:border-box;">**Solution:** Please use the corresponding &quot;Fx/Controls&quot; entities in the place of the obsolete items above e.g. &quot;Fx/Controls/<span style="color:rgba(0, 0, 0, 0.9);text-align:left;display:inline !important;">Splitter</span>&quot; instead of &quot;MsPortalFx.ViewModels.<span style="display:inline !important;">Controls</span>.<span style="color:rgba(0, 0, 0, 0.9);text-align:left;display:inline !important;">Splitter</span>&quot; etc.<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">These can all be discovered at&nbsp;<a href="https://aka.ms/portalfx/playground" style="box-sizing:border-box;text-decoration:underline;cursor:pointer;">https://aka.ms/portalfx/playground</a></div><div style="box-sizing:border-box;"><div style="color:#000000;background-color:#ffffff;font-family:Consolas, 'Courier New', monospace;font-weight:normal;"><div><span style="color:#008000;"><br></span></div><div><span style="color:#008000;">*&nbsp;Please&nbsp;refer&nbsp;to&nbsp;https://aka.ms/portalfx/breaking&nbsp;for&nbsp;more&nbsp;details.</span></div></div><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Reason For Breaking Change**&nbsp;<span lang=EN-US style="box-sizing:border-box;margin:0px;color:windowtext;font-weight:normal;text-align:left;font-size:11pt;font-family:Calibri, Calibri_MSFontService, sans-serif;"><span style="box-sizing:border-box;margin:0px;"></span></span><span lang=EN-US style="margin:0px;color:windowtext;font-weight:normal;font-size:11pt;font-family:Calibri, Calibri_MSFontService, sans-serif;"><span style="margin:0px;">This control has a one-to-one mapping with the newer control. These can be easily replaced (with minimal hand coding) if you use the tool from<span>&nbsp;</span></span></span><a href="onenote:#Replacement%20tool&amp;section-id={F25B71CA-D8A0-4DFC-983B-C88CD6686469}&amp;page-id={6B379D6C-9994-4A0F-8518-D4FCCFE7406E}&amp;end&amp;base-path=https://microsoft.sharepoint.com/teams/azureteams/aapt/azureux/portalfx/SiteAssets/PortalFx%20Notebook/Controls/Obsoleting.one" target=_blank rel="noreferrer noopener" style="margin:0px;cursor:text;font-family:&quot;Segoe UI&quot;, &quot;Segoe UI Web&quot;, Arial, Verdana, sans-serif;font-size:12px;"><span lang=EN-US style="margin:0px;font-weight:normal;font-size:11pt;font-family:Calibri, Calibri_MSFontService, sans-serif;"><span style="margin:0px;">Replacement tool</span></span></a><span lang=EN-US style="margin:0px;color:windowtext;font-weight:normal;font-size:11pt;font-family:Calibri, Calibri_MSFontService, sans-serif;"><span style="margin:0px;">.</span></span><span style="margin:0px;font-size:11pt;font-family:Calibri, Calibri_MSFontService, sans-serif;">&nbsp;</span><span style="box-sizing:border-box;margin:0px;text-align:left;font-size:11pt;font-family:Calibri, Calibri_MSFontService, sans-serif;"></span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;"></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063465'>7063465</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063465'>Deprecate old MsPortalFx map</a><p><br></div><div><br></div><div>**Expected Errors:**<br></div><div>You will hit tslint errors when using MsPortalFx.ViewModels.Controls.Visualization.Map view models as they are getting obsoleted,<br></div><div><br></div><div><br></div><div>**Solution:**<br></div><div>If you are using basic map, please migrate to the new AMD modules in Fx/Controls/Map.<br></div><div>Legacy MsPortalx HexagonLayout map should be used by SQL extension only. Other extensions should migrate to Fx/Controls/Map.<br></div><div><br></div><div>**Reason For Breaking Change**<br></div><div>MsPortalFx namespace in non-AMD module. For perf reasons and using new api pattern we have exposed AMD modules under Fx/Controls and asking partners to migrate to new API patterns.<br></div><div>Please refer to https://aka.ms/portalfx/breaking for more details.<br></div><div><br></div><span></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063455'>7063455</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063455'>Remove old diffeditor and deprecate old editor</a><p><br style="box-sizing:border-box;"></span><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Expected Errors:**</div><div style="box-sizing:border-box;"><br></div><div style="box-sizing:border-box;"><ol><li>&nbsp;<span>The following interfaces and classes have been marked as of type `Obsolete` and their usages will be flagged as compile errors at build time:</span></li><ol style="list-style:lower-alpha;"><li><span><span style="box-sizing:border-box;color:rgb(0, 128, 128);font-family:Consolas, &quot;Courier New&quot;, monospace;font-size:12px;background-color:rgb(255, 255, 254);display:inline !important;">MsPortalFx.ViewModels.Controls.Documents.DiffEditor.Options,</span><div style="box-sizing:border-box;background-color:rgb(255, 255, 254);color:rgb(0, 128, 128);font-family:Consolas, &quot;Courier New&quot;, monospace;font-size:12px;"><span style="box-sizing:border-box;background-color:rgb(255, 255, 254);display:inline !important;">MsPortalFx.ViewModels.Controls.Documents.DiffEditor.Contract, and&nbsp;</span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;background-color:rgb(255, 255, 254);color:rgb(0, 128, 128);font-family:Consolas, &quot;Courier New&quot;, monospace;font-size:12px;"><div style="box-sizing:border-box;">MsPortalFx.ViewModels.Controls.Documents.DiffEditor.ViewModel</div></div><br></span></li></ol><li><span><span style="text-align:start;display:inline !important;">Usage of the old Editor control in <span style="display:inline !important;">MsPortalFx.ViewModels.Controls.Documents.Editor and its&nbsp;</span>`Editor` `ViewModel`, `Contract`, `Options`, and all its other 24 exported types (i.e. `MsPortalFx.ViewModels.Controls.Documents.Editor.ViewModel`, `MsPortalFx.ViewModels.Controls.Documents.Editor.Contract`, `MsPortalFx.ViewModels.Controls.Documents.Editor.Options`, etc.) will be flagged as a compile-time TSLint error at build time e.g.:</span><br></span></li><ol style="list-style:lower-alpha;"><li><span><span style="text-align:start;display:inline !important;"><div style="box-sizing:border-box;"><div style="box-sizing:border-box;font-family:Consolas, &quot;Courier New&quot;, monospace;font-weight:normal;"><span style="box-sizing:border-box;color:rgb(0, 128, 0);">&nbsp;*&nbsp;</span><span style="box-sizing:border-box;color:rgb(0, 0, 255);">@deprecated</span><span style="box-sizing:border-box;color:rgb(0, 128, 0);">&nbsp;<span style="display:inline !important;">MsPortalFx.ViewModels.Controls.Documents.Editor</span>[...] is&nbsp;deprecated.&nbsp;Use&nbsp;</span><span style="box-sizing:border-box;color:rgb(0, 128, 0);">Fx/Controls/Editor instead.</span></div></div><div style="box-sizing:border-box;"><div style="box-sizing:border-box;font-family:Consolas, &quot;Courier New&quot;, monospace;font-weight:normal;"><div style="box-sizing:border-box;"><span style="box-sizing:border-box;color:rgb(0, 128, 0);">&nbsp;*&nbsp;Please&nbsp;refer&nbsp;to&nbsp;<a href="https://aka.ms/portalfx/breaking" style="box-sizing:border-box;text-decoration:underline;cursor:pointer;">https://aka.ms/portalfx/breaking</a>&nbsp;for&nbsp;more&nbsp;details.</span></div></div></div></span></span></li></ol></ol></div><div style="box-sizing:border-box;"><span>**Solution:** Please use the corresponding Fx controls instead:</span><br></div><div style="box-sizing:border-box;"><ol><li>Fx/Controls/DiffEditor, and</li><li>Fx/Controls/Editor respectively.</li></ol></div><div style="box-sizing:border-box;">They can both be found among playground controls at&nbsp;<a href="https://aka.ms/portalfx/playground">https://aka.ms/portalfx/playground</a>&nbsp;</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Reason For Breaking Change** For the old DiffEditor and old Editor controls respectively:<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><ol><li><span lang=EN-US style="margin:0px;color:windowtext;font-weight:normal;font-size:11pt;font-family:Calibri, Calibri_MSFontService, sans-serif;"><span style="margin:0px;">This control has a one-to-one mapping with the newer control. These can be easily replaced (with minimal hand coding) if you use the tool from<span>&nbsp;</span></span></span><a href="onenote:#Replacement%20tool&amp;section-id={F25B71CA-D8A0-4DFC-983B-C88CD6686469}&amp;page-id={6B379D6C-9994-4A0F-8518-D4FCCFE7406E}&amp;end&amp;base-path=https://microsoft.sharepoint.com/teams/azureteams/aapt/azureux/portalfx/SiteAssets/PortalFx%20Notebook/Controls/Obsoleting.one" target=_blank rel="noreferrer noopener" style="margin:0px;cursor:text;font-family:&quot;Segoe UI&quot;, &quot;Segoe UI Web&quot;, Arial, Verdana, sans-serif;font-size:12px;"><span lang=EN-US style="margin:0px;font-weight:normal;font-size:11pt;font-family:Calibri, Calibri_MSFontService, sans-serif;"><span style="margin:0px;">Replacement tool</span></span></a><span lang=EN-US style="margin:0px;color:windowtext;font-weight:normal;font-size:11pt;font-family:Calibri, Calibri_MSFontService, sans-serif;"><span style="margin:0px;">.</span></span><span style="margin:0px;font-size:11pt;font-family:Calibri, Calibri_MSFontService, sans-serif;">&nbsp;</span><br></li><li><span style="margin:0px;font-size:11pt;font-family:Calibri, Calibri_MSFontService, sans-serif;"><span lang=EN-US style="margin:0px;color:windowtext;font-weight:normal;"><span style="margin:0px;">This control has a one-to-one mapping for all functionality with the new control. The only thing different is that the newer variant does not support DiscussionThreads. If you are not using that capability, you should migrate to the newer control as it has more functionality.</span></span><span style="margin:0px;">&nbsp;</span><br></span></li></ol></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;"></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063452'>7063452</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063452'>Deprecate/Obsolete old frame controls</a><p><br style="box-sizing:border-box;"></span><div style="box-sizing:border-box;"><br></div></div><div style="box-sizing:border-box;"><span>**Expected Errors:**<br></span><div>You will hit compilation error when using MsPortalFx.ViewModels.Controls.Internal.IFrameV2 view model as old IFrameV2 control is getting obsoleted.<br></div><div><br></div><div>You will see tslint errors when using MsPortalFx.ViewModels.Controls.Internal.IFrame view model as old IFrame control is getting deprecated and will be obsoleted in future.<br></div><div><br></div><div>**Solution:**<br></div><div>Please migrate to the new AMD modules in Fx/Controls/FrameControls if you are using MsPortalFx.ViewModels.Controls.Internal.IFrame or MsPortalFx.ViewModels.Controls.Internal.IFrameV2 controls.<br></div><div><br></div><div>**Reason For Breaking Change**<br></div><div>MsPortalFx namespace in non-AMD module. For perf reasons and using new api pattern we have exposed AMD modules under Fx/Controls and asking partners to migrate to new API patterns.<br></div><div>Please refer to https://aka.ms/portalfx/breaking for more details.<br></div><span></span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><div style="box-sizing:border-box;"><span style="box-sizing:border-box;"></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063375'>7063375</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063375'>Deprecate editscope controls</a><p><br style="box-sizing:border-box;"></span></div><div style="box-sizing:border-box;"><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Expected Errors:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Users of these controls would see a warning which says that the control is deprecated and should be replaced by a newer control.&nbsp;<span style="">The controls being deprecated in this Task are as follows:</span></div><div style="box-sizing:border-box;"><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;">MsPortalFx.ViewModels.Forms.OAuthButton<br style="box-sizing:border-box;"></span><div style="box-sizing:border-box;">MsPortalFx.ViewModels.Forms.DatePicker<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">MsPortalFx.ViewModels.Forms.Slider<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">MsPortalFx.ViewModels.Forms.DateTimePicker<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">MsPortalFx.ViewModels.Forms.PasswordBox<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">MsPortalFx.ViewModels.Forms.MultiLineTextBox<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">MsPortalFx.ViewModels.Forms.NumericTextBox<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">MsPortalFx.ViewModels.Forms.CheckBox<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">MsPortalFx.ViewModels.Forms.OptionsGroup<br style="box-sizing:border-box;"></div><span style="box-sizing:border-box;">MsPortalFx.ViewModels.Forms.TextBox</span></div><br></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Solution:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Please use the newer control defined under &quot;Fx/Controls&quot; instead of using MsPortalFx controls.</div><div style="box-sizing:border-box;">Example, import&nbsp;OAuthButton from &quot;Fx/Controls/OAuthButton&quot; instead of&nbsp;MsPortalFx.ViewModels.Forms.OAuthButton</div><div style="box-sizing:border-box;"><span style="display:inline !important;">The deprecated controls and their replacements are mentioned below:</span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="display:inline !important;"><br></span></div><div style="box-sizing:border-box;"><span style="display:inline !important;"><b style="box-sizing:border-box;">Deprecated Control -&gt; Replacement control</b><br></span></div><div style="box-sizing:border-box;"><span style="display:inline !important;"><b style="box-sizing:border-box;"><br></b></span></div><div style="box-sizing:border-box;"><span style="display:inline !important;"><span style="box-sizing:border-box;">MsPortalFx.ViewModels.Forms.OAuthButton&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;-&gt;&nbsp;<span style="display:inline !important;">Fx/Controls/<span style="display:inline !important;">OAuthButton<span>&nbsp;</span></span></span><br><div style="">MsPortalFx.ViewModels.Forms.DatePicker&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;-&gt;&nbsp;<span style="display:inline !important;">Fx/Controls/<span style="display:inline !important;">DatePicker<span>&nbsp;</span></span></span><br></div><div style="">MsPortalFx.ViewModels.Forms.Slider&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;-&gt;&nbsp;<span style="display:inline !important;">Fx/Controls/<span style="display:inline !important;"><span style="display:inline !important;">Slider<span>&nbsp;</span></span><span></span></span></span><br></div><div style="">MsPortalFx.ViewModels.Forms.DateTimePicker&nbsp; &nbsp; &nbsp; &nbsp;-&gt;&nbsp;<span style="display:inline !important;">Fx/Controls/<span style="display:inline !important;">DateTimePicker<span>&nbsp;</span></span></span><br></div><div style="">MsPortalFx.ViewModels.Forms.PasswordBox&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;-&gt;&nbsp;<span style="display:inline !important;">Fx/Controls/<span style="display:inline !important;">PasswordBox<span>&nbsp;</span></span></span><br></div><div style="">MsPortalFx.ViewModels.Forms.MultiLineTextBox&nbsp; &nbsp; &nbsp;-&gt;&nbsp;<span style="display:inline !important;">Fx/Controls/<span style="display:inline !important;">MultiLineTextBox<span>&nbsp;</span></span></span><br></div><div style="">MsPortalFx.ViewModels.Forms.NumericTextBox&nbsp; &nbsp; &nbsp; -&gt;&nbsp;<span style="display:inline !important;">Fx/Controls/<span style="display:inline !important;">NumericTextBox<span>&nbsp;</span></span></span><br></div><div style="">MsPortalFx.ViewModels.Forms.CheckBox&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; -&gt;&nbsp;<span style="display:inline !important;">Fx/Controls/<span style="display:inline !important;">CheckBox<span>&nbsp;</span></span></span><br></div><div style="">MsPortalFx.ViewModels.Forms.OptionsGroup&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;-&gt;&nbsp;<span style="display:inline !important;">Fx/Controls/<span style="display:inline !important;">OptionsGroup<span>&nbsp;</span></span></span><br></div>MsPortalFx.ViewModels.Forms.TextBox&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;-&gt;&nbsp;<span style="display:inline !important;">Fx/Controls/<span style="display:inline !important;">TextBox<span>&nbsp;</span></span></span><br></span></span></div><div style="box-sizing:border-box;"><span style="display:inline !important;"><br></span></div><div style="box-sizing:border-box;">**Reason For Breaking Change**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">We are no longer supporting these controls. They are deprecated and should be replaced by corresponding newer controls.&nbsp;</div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;"></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063363'>7063363</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063363'>Remove editscope controls with less than 10 usages</a><p><br style="box-sizing:border-box;"></span></div><div style="box-sizing:border-box;"><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Expected Errors:** The following interfaces and classes have been marked as of type `Obsolete` and their usages will be flagged as compile errors at build time:</div><span style="box-sizing:border-box;text-align:left;background-color:rgb(255, 255, 254);"><div style="box-sizing:border-box;"><br></div><font color="#008080" face="Consolas, Courier New, monospace"><span style="font-size:12px;">MsPortalFx.ViewModels.Forms.CustomValueSlider.Options and&nbsp;</span></font><div style="color:rgb(0, 128, 128);font-family:Consolas, &quot;Courier New&quot;, monospace;font-size:12px;"><div>MsPortalFx.ViewModels.Forms.CustomValueSlider.ViewModel</div></div><ul style="color:rgb(0, 128, 128);font-family:Consolas, &quot;Courier New&quot;, monospace;font-size:12px;"><li><div style="color:#000000;background-color:#fffffe;font-family:Consolas, 'Courier New', monospace;font-weight:normal;"><span style="color:#008080;"><div style="color:#000000;background-color:#fffffe;"></div></span></div></li></ul><div style="color:rgb(0, 0, 0);font-family:Consolas, &quot;Courier New&quot;, monospace;font-size:12px;display:inline !important;"><span style="color:#008080;">MsPortalFx.ViewModels.Forms.</span><span style="color:rgb(0, 128, 128);">DateTimeRangePicker</span><span style="color:rgb(0, 128, 128);">.Options and&nbsp;</span><span style="color:#008080;"><div><div>MsPortalFx.ViewModels.Forms.<span style="background-color:rgb(255, 255, 254);display:inline !important;">DateTimeRangePicker</span>.ViewModel</div></div><div><br></div><div>MsPortalFx.ViewModels.Forms.DayPicker.Options and&nbsp;<br></div><div><div>MsPortalFx.ViewModels.Forms.DayPicker.ViewModel</div></div><br>MsPortalFx.ViewModels.Forms.DurationPicker.Options and&nbsp;<div><div>MsPortalFx.ViewModels.Forms.DurationPicker.ViewModel</div></div><br>MsPortalFx.ViewModels.Forms.RangeSlider.Options and&nbsp;<div><div>MsPortalFx.ViewModels.Forms.RangeSlider.ViewModel</div></div><br>MsPortalFx.ViewModels.Forms.TimePicker.Options and&nbsp;<div><div>MsPortalFx.ViewModels.Forms.TimePicker.ViewModel</div></div></span></div></span><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Solution:** Please use the corresponding &quot;Fx/Controls&quot; entities in the place of the obsolete items above e.g. &quot;Fx/Controls/DayPicker&quot; instead of &quot;MsPortalFx.ViewModels.Forms.DayPicker&quot; etc.<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br></div><div style="box-sizing:border-box;">These can all be discovered at&nbsp;<a href="https://aka.ms/portalfx/playground">https://aka.ms/portalfx/playground</a></div><div style="box-sizing:border-box;"><span style="color:rgb(0, 128, 0);font-family:Consolas, &quot;Courier New&quot;, monospace;display:inline !important;">&nbsp;*&nbsp;Please&nbsp;refer&nbsp;to&nbsp;</span><a href="https://aka.ms/portalfx/breaking" style="box-sizing:border-box;text-decoration:underline;cursor:pointer;font-family:Consolas, &quot;Courier New&quot;, monospace;">https://aka.ms/portalfx/breaking</a><span style="color:rgb(0, 128, 0);font-family:Consolas, &quot;Courier New&quot;, monospace;display:inline !important;">&nbsp;for&nbsp;more&nbsp;details.</span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Reason For Breaking Change**&nbsp;<span lang=EN-US style="margin:0px;color:windowtext;font-weight:normal;text-align:left;font-size:11pt;font-family:Calibri, Calibri_MSFontService, sans-serif;"><span style="margin:0px;">This control has a one-to-one mapping with the newer control. It might use EditScope but has really low usage (less than 10 across all extensions).&nbsp; In case you rely on EditScope, you can use<span>&nbsp;</span></span></span><a href="onenote:#How%20to%20migrate&amp;section-id={F25B71CA-D8A0-4DFC-983B-C88CD6686469}&amp;page-id={3C2D3899-24EC-4B81-BD7C-8A13D7464BB1}&amp;end&amp;base-path=https://microsoft.sharepoint.com/teams/azureteams/aapt/azureux/portalfx/SiteAssets/PortalFx%20Notebook/Controls/Obsoleting.one" target=_blank rel="noreferrer noopener" style="margin:0px;cursor:text;font-family:&quot;Segoe UI&quot;, &quot;Segoe UI Web&quot;, Arial, Verdana, sans-serif;font-size:12px;text-align:left;"><span lang=EN-US style="margin:0px;font-weight:normal;font-size:11pt;font-family:Calibri, Calibri_MSFontService, sans-serif;"><span style="margin:0px;">How to migrate<span>&nbsp;</span></span></span></a><span lang=EN-US style="margin:0px;color:windowtext;font-weight:normal;text-align:left;font-size:11pt;font-family:Calibri, Calibri_MSFontService, sans-serif;"><span style="margin:0px;">page to add support for EditScope to the new control.</span></span><span style="margin:0px;text-align:left;font-size:11pt;font-family:Calibri, Calibri_MSFontService, sans-serif;">&nbsp;</span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;"></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063320'>7063320</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063320'>Update Pill APIs to not rely on MsPortalFx APIs</a><p><br></span><div><br></div><div>**Expected Errors:**<br></div><div>Pill view model's tooltip property is obsoleted as it had dependency with MsPortalFx DockedBalloon view model. <br></div><div>Pill's DialogEditor usages will see compilation error for using the below two MsPortalFx types, <br></div><div>MsPortalFx.ViewModels.Dialog.DialogResult<br></div><div>MsPortalFx.ViewModels.CustomDialogButton<br></div><div><br></div><div>**Solution:**<br></div><div>For tooltip property, please migrate to use infoBalloonContent property to specify the tooltip.<br></div><div>For MsPortalFx.ViewModels.Dialog.DialogResult type, please migrate to use DialogButton from &quot;Fx/Composition/Dialog&quot; <br></div><div>For MsPortalFx.ViewModels.CustomDialogButton type, please migrate to use CustomDialogButton from &quot;Fx/Composition/Dialog&quot;<br></div><div><br></div><div><br></div><div>**Reason For Breaking Change**<br></div><div>AMD Fx APIs are getting cleaned up to not have any legacy MsPortalFx dependencies.<br></div><div>Migrating to AMD module will be more performant and will use the latest recommended API patterns.<br></div><div><div style="box-sizing:border-box;">Please refer to https://aka.ms/portalfx/breaking for more details.<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><br></div><span></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063314'>7063314</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063314'>Remove 'size' and 'image' from infobox</a><p><br style="box-sizing:border-box;"></span><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Expected Errors:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">'size' and 'image' property is no longer supported in Fx/Controls/InfoBox. These will cause a compile time error if used.</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Solution:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">If you relied on the 'size' property, then you should now move to choosing the styling based on the appropriate control factory method (create vs createInline) for the Fx/Control/InfoBox. Please refer to the guidance on the playground for more details on when to use which variant.</div><div style="box-sizing:border-box;"><br></div><div style="box-sizing:border-box;">If you relied on the 'image' property, that is now being removed as we want to only support standard infoBox styles. You can simply remove the image from the control and set the 'style' option to get similar/identical behavior. In case you were using custom images, that is no longer supported, and unfortunately you would need to build this experience by hand using custom HTML.</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Reason For Breaking Change**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">The removal of the 'size' property was primarily for better API segregation between the 2 types of the infoboxes as there is functional differences between the 2 variants.</div><div style="box-sizing:border-box;"><br></div><div style="box-sizing:border-box;">The removal of the 'image' property was to ensure consistency across all infoboxes and for better control on styling and theming, which custom images were hindering.</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;"></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063306'>7063306</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063306'>Remove 'boxSize' from checkbox</a><p><br style="box-sizing:border-box;"></span><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Expected Errors:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">'boxSize ' is no longer supported in Fx/Controls/CheckBox &amp; Fx/Controls/TriStateCheckBox and will result in a compile time error</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Solution:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Remove the use of 'boxSize' from checkboxes</div><div style="box-sizing:border-box;"><br></div><div style="box-sizing:border-box;">**Reason For Breaking Change**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Based on design reviews and alignment to Fabric UI, checkboxes will now only have a single standard size.<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;"></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063304'>7063304</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063304'>Remove unused and duplicate icons</a><p><br style="box-sizing:border-box;"></span><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Expected Errors:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">If using an icon that has been removed, you will get a building with wording&nbsp; similar to &quot;This expression is not callable&quot;.</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Solution:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Use the following table to find a replacement for your icon:</div><div style="box-sizing:border-box;"><div><table style="border-collapse:collapse;border-style:solid;border-color:#A3A3A3;border-width:1pt;" title="">
 <tbody><tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;background-color:#DEEBF6;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;"><span style="font-weight:bold;">Deleted icons</span></p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;background-color:#DEEBF6;vertical-align:top;width:1.5277in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;"><span style="font-weight:bold;">Use this instead</span></p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">AddAlternate</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5277in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">Add</p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">AddBoxed</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5277in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">Add</p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">Clone</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5277in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">Copy</p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">Commits</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5277in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">Commit</p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">Disabled</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5277in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">Disable</p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">EditInverted</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5277in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">Edit</p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">ForPlacementOnly</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5277in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">Disable</p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">GearAlternate</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5277in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">Gear</p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">GitLogo</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5277in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">Logos.Git</p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">GitLogoBox</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5277in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">Logos.GitBox</p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">InstallVisualStudio</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5277in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">DownloadFlat</p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">LoadingLoader</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5277in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">LoadingSpinner</p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">NumberError</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5277in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">Error</p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">NumberSuccess</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5277in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">Check</p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">Plus</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5277in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">Add</p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">PolyResourceList</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">PolyResourceGroupList</p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">ShellAdd</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5277in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">Add</p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">QuickStart</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5277in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">AzureQuickStart</p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">Settings</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5277in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">Gear</p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">ShellCollapse</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5277in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">CaretDown</p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">Tag</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5277in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">Tags</p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">Tour</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5277in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">InfoFlat</p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">VisualStudio</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5277in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">Logos.VisualStudio</p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5159in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">VisualStudioLogoBox</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.55in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">Logos.VisualStudioBox</p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">ArrowWideUp</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5277in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">ArrowUp</p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">ArrowWideDown</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5277in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">ArrowDown</p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">ShellFilter</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5277in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">Filter</p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">ShellPin</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5277in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">Pin</p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">PolyResourceList</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">PolyResourceGroupList</p>
  </td>
 </tr>
 <tr>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.4965in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">ShellSave</p>
  </td>
  <td style="border-style:solid;border-color:#A3A3A3;border-width:1pt;vertical-align:top;width:1.5277in;padding:4pt 4pt 4pt 4pt;">
  <p style="margin:0in;">Save</p>
  </td>
 </tr></tbody></table></div><br></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Reason For Breaking Change**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="display:inline !important;">Certain icons will be removed since they are not used or they have an identical existing replacement.&nbsp;</span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;"></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063289'>7063289</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063289'>Deprecate hotspot</a><p><br style="box-sizing:border-box;"></span><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Expected Errors:**&nbsp;Usage of the `HotSpot` view models and options will be flagged as a compile-time TSLint error at build time:</div><div style="box-sizing:border-box;"><br><div style="box-sizing:border-box;font-family:Consolas, &quot;Courier New&quot;, monospace;font-weight:normal;"><div style="box-sizing:border-box;"><span style="box-sizing:border-box;color:rgb(0, 128, 0);">&nbsp;*&nbsp;</span><span style="box-sizing:border-box;color:rgb(0, 0, 255);">@deprecated</span><span style="box-sizing:border-box;color:rgb(0, 128, 0);">&nbsp;[...]HotSpot[...] is&nbsp;deprecated.&nbsp;Use&nbsp;fxclick&nbsp;directly&nbsp;in&nbsp;your HTML template&nbsp;instead.</span></div></div><div style="color:#000000;background-color:#ffffff;font-family:Consolas, 'Courier New', monospace;font-weight:normal;"><div><span style="color:#008000;">&nbsp;*&nbsp;Please&nbsp;refer&nbsp;to&nbsp;<a href="https://aka.ms/portalfx/breaking">https://aka.ms/portalfx/breaking</a>&nbsp;for&nbsp;more&nbsp;details.</span></div></div><br></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><img src="https://msazure.visualstudio.com/b32aa71e-8ed2-41b2-9d77-5bc261222004/_apis/wit/attachments/b2b66cf7-43db-4aaa-94a0-e1cd29530adc?fileName=image.png" alt=Image style="box-sizing:border-box;max-width:100%;align-self:center;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><img src="https://msazure.visualstudio.com/b32aa71e-8ed2-41b2-9d77-5bc261222004/_apis/wit/attachments/e3b3515d-6272-4e58-bf87-fa4adb261f6b?fileName=image.png" alt=Image style="box-sizing:border-box;max-width:100%;align-self:center;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Solution:**&nbsp;<span lang=EN-US style="box-sizing:border-box;margin:0px;color:windowtext;font-weight:normal;text-align:left;font-size:11pt;font-family:Calibri, Calibri_MSFontService, sans-serif;"><span style="box-sizing:border-box;margin:0px;">Extensions should build the HTML themselves and use `fxclick` binding to hook up on-click handlers.</span></span><span style="box-sizing:border-box;margin:0px;text-align:left;font-size:11pt;font-family:Calibri, Calibri_MSFontService, sans-serif;">&nbsp;</span></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Please use `fxclick` instead in your own HTML template:</div><div style="box-sizing:border-box;"><ul style="box-sizing:border-box;padding:0px 0px 0px 40px;"><li style="box-sizing:border-box;">`fxclick` samples at&nbsp;<a href="https://df.onecloud.azure-test.net/?clientOptimizations=false#blade/SamplesExtension/FxClickLinksBlade" style="box-sizing:border-box;text-decoration:underline;cursor:pointer;">https://df.onecloud.azure-test.net/?clientOptimizations=false#blade/SamplesExtension/FxClickLinksBlade</a></li><li style="box-sizing:border-box;">the corresponding sample `fxclick` code at&nbsp;<a href="https://msazure.visualstudio.com/One/_git/AzureUX-PortalFx?version=GBproduction&amp;path=/src/SDK/Extensions/SamplesExtension/Extension/Client/V2/Navigation/FxClickLinksBlade.ts" style="box-sizing:border-box;text-decoration:underline;cursor:pointer;">https://msazure.visualstudio.com/One/_git/AzureUX-PortalFx?version=GBproduction&amp;path=%2Fsrc%2FSDK%2FExtensions%2FSamplesExtension%2FExtension%2FClient%2FV2%2FNavigation%2FFxClickLinksBlade.ts</a></li><li style="box-sizing:border-box;">more `fxclick` docs in the context of opening blades at&nbsp;<a href="https://github.com/Azure/portaldocs/blob/d2d164db30647308788333635f59115116ec6fdc/portal-sdk/generated/portalfx-extensions-bp-blades.md" style="box-sizing:border-box;text-decoration:underline;cursor:pointer;">https://github.com/Azure/portaldocs/blob/d2d164db30647308788333635f59115116ec6fdc/portal-sdk/generated/portalfx-extensions-bp-blades.md</a></li></ul></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Reason For Breaking Change:**&nbsp;<span lang=EN-US style="box-sizing:border-box;margin:0px;color:windowtext;font-weight:normal;text-align:left;font-size:11pt;font-family:Calibri, Calibri_MSFontService, sans-serif;"><span style="box-sizing:border-box;margin:0px;">This control has accessibility issues&nbsp; and is an old pattern of creating links.</span></span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;"></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063286'>7063286</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063286'>Remove deprecated Part types</a><p><br style="box-sizing:border-box;"></span><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Expected Errors:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">PartKind</div></div><div>-&nbsp;This&nbsp;part&nbsp;is&nbsp;no&nbsp;longer&nbsp;supported.&nbsp;Use&nbsp;a&nbsp;custom&nbsp;part&nbsp;instead.<br></div><div>-&nbsp;This&nbsp;part&nbsp;is&nbsp;no&nbsp;longer&nbsp;supported.&nbsp;Use&nbsp;Essentials&nbsp;control&nbsp;instead.</div><div><br></div><div>Part</div><div>- ResourceSummary.[...]&nbsp;<span>This&nbsp;part&nbsp;is&nbsp;no&nbsp;longer&nbsp;supported.&nbsp;Please&nbsp;use&nbsp;Fx/Controls/Essentials&nbsp;instead.</span></div><div><span>- SingValueGauge.[...]&nbsp;</span><span>This&nbsp;part&nbsp;is&nbsp;no&nbsp;longer&nbsp;supported.&nbsp;&nbsp;Please&nbsp;use&nbsp;a&nbsp;custom&nbsp;part&nbsp;with&nbsp;SingleValueGauge&nbsp;and&nbsp;Metrics&nbsp;control.</span></div><div><span>- QuotaGauge.[...]&nbsp;</span><span>This&nbsp;part&nbsp;is&nbsp;no&nbsp;longer&nbsp;supported.&nbsp;Please&nbsp;use&nbsp;custom&nbsp;part&nbsp;with&nbsp;QuotaGauge&nbsp;and&nbsp;Metrics&nbsp;control&nbsp;instead.</span></div><div><span>- Donut.[...]&nbsp;</span><span>This&nbsp;part&nbsp;is&nbsp;no&nbsp;longer&nbsp;supported.&nbsp;Please&nbsp;use&nbsp;custom&nbsp;part&nbsp;with&nbsp;the&nbsp;Donut,&nbsp;Legend&nbsp;and&nbsp;Metrics&nbsp;control&nbsp;instead.</span></div><div style="box-sizing:border-box;"><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Solution:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">- for ResourceSummary part:&nbsp;&nbsp;<span>Please&nbsp;replace it with the Essentials control.</span></div></div><div></div><div>- for SingleValueGauge part:&nbsp;&nbsp;Please replace it with a&nbsp;custom&nbsp;part&nbsp;using SingleValueGauge&nbsp;and&nbsp;Metrics&nbsp;control.</div><div>- for QuotaGauge part:&nbsp;&nbsp;Please&nbsp;replace it with a custom&nbsp;part&nbsp;using QuotaGauge&nbsp;and&nbsp;Metrics&nbsp;control.</div><div style="box-sizing:border-box;"><div style="box-sizing:border-box;">- for Donut part:&nbsp;<span>Please&nbsp;replace it with a custom&nbsp;part&nbsp;using Donut,&nbsp;Legend&nbsp;and&nbsp;Metrics&nbsp;control.</span></div></div><div style="box-sizing:border-box;"><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Reason For Breaking Change**<br style="box-sizing:border-box;"></div></div><div>ResourceSummary Part:&nbsp;<p style="margin:0in;">This part was
communicated as deprecated for over 2+ years. Extensions should move to using
the Essentials control. </p><p style="margin:0in;"><br></p><p style="margin:0in;">SingleValueGauge Part:&nbsp;</p><p style="margin:0in;">This
part is a basic wrapper over existing controls and has low usage. This is easy
to replace with a custom part with the SingleValueGauge and Metrics control.</p><br style="box-sizing:border-box;"></div><div>QuotaGauge Part:</div><div style="box-sizing:border-box;"><div style="box-sizing:border-box;"><p style="margin:0in;">This part is a basic
wrapper over existing controls and has low usage. This is easy to replace with
a custom part with the QuotaGauge and Metrics control.</p><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Donut Part:</div><div style="box-sizing:border-box;"><p style="margin:0in;">This part is a basic
wrapper over existing controls and has low usage. This is easy to replace with
a custom part with the Donut, Legend and Metrics control.</p><p style="margin:0in;"><br></p></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;"></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063240'>7063240</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063240'>Remove deprecated dropdowns</a><p><br style="box-sizing:border-box;"></span><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Expected Errors:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">The following old dropdowns are removed:</div><div style="box-sizing:border-box;"><span style="font-family:Calibri, sans-serif;font-size:14.6667px;display:inline !important;">FxImpl.ViewModels.Forms.CreatorAndComboBox</span><br></div><div style="box-sizing:border-box;"><span style="font-family:Calibri, sans-serif;font-size:14.6667px;display:inline !important;"><span>MsPortalFx.ViewModels.Obsolete.Forms.GroupDropDown</span><br></span></div><div style="box-sizing:border-box;"><span style="font-family:Calibri, sans-serif;font-size:14.6667px;display:inline !important;"><span><span>MsPortalFx.ViewModels.Obsolete.Forms.FilterComboBox<br></span><div>MsPortalFx.ViewModels.Obsolete.Forms.MultiSelectDropDown<br></div><span>MsPortalFx.ViewModels.Obsolete.Forms.DropDown</span><br></span></span></div><div style="box-sizing:border-box;"><font face="Calibri, sans-serif"><span style="font-size:14.6667px;">You will see a compile time error if you are using these.</span></font></div><div style="box-sizing:border-box;"><font face="Calibri, sans-serif"><span style="font-size:14.6667px;"><br></span></font></div><div style="box-sizing:border-box;"><font face="Calibri, sans-serif"><span style="font-size:14.6667px;">As part of the above the &quot;MultiselectDropDownFormFieldInfo' and 'HtmlBindingsType.MultiselectDropDown' have also been removed as the underlying dropdown is not supported anymore.</span></font></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Solution:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="font-family:Calibri, sans-serif;font-size:14.6667px;display:inline !important;">For the dropdowns, you should use Fx/Controls/DropDown or Fx/Controls/ComboBox depending on what your use case is.</span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="font-family:Calibri, sans-serif;font-size:14.6667px;display:inline !important;">For the grid changes, you should move using the DroDownFormFieldInfo or GroupDropDownFormFieldInfo. For some of the missing functionalities from&nbsp;<span style="font-family:Calibri, sans-serif;display:inline !important;">MultiselectDropDownFormFieldInfo, those are no longer supported due to user feedback and consistency issues and if you are using any of those, feel free to reach out to the framework team to go over alternatives.&nbsp;</span></span></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Reason For Breaking Change**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">The old dropdowns were obsoleted almost 3 years ago and are now being removed. The new dropdown is accessible and much more performant and should have functional parity.</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;"></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063136'>7063136</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7063136'>Deprecate inline editing mode in Pill</a><p><br style="box-sizing:border-box;"></span><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Expected Errors:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Pill InlineEditor is getting deprecated.</div><div style="box-sizing:border-box;">You will see TS lint errors if you are using Pill's InlineEditor.</div><div style="box-sizing:border-box;"><br></div><div style="box-sizing:border-box;">**Solution:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Please migrate to DialogEditor or CustomEditor for your scenario.</div><div style="box-sizing:border-box;"><br></div><div style="box-sizing:border-box;">**Reason For Breaking Change**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">InlineEditor is getting deprecated after user feedbacks around jumpyness of the UX and the dropdown/pill movement. We want to streamline the UX with less jumpiness and recomending DialogEditor to be used uniformly.</div><div style="box-sizing:border-box;"><div style="box-sizing:border-box;">Please refer to https://aka.ms/portalfx/breaking for more details.<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><br></div><div style="box-sizing:border-box;"><span></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=6623500'>6623500</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=6623500'>[Hubs] [Breaking change] Obsolete the old hubs dropdowns</a><p></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=6623485'>6623485</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=6623485'>[Hubs] [Breaking change] Deprecate the WidthInPixels property in PDL </a><p></div><div><br></div><div>The PDL compiler will emit an error if the ARG browse Column entry uses the WidthInPixels property.&nbsp; This property has been superseded by the Width property which includes grid column units such as 'px' for pixel units and 'fr' for fractional units.</div><div><br></div><div>For a one-to-one mapping, replace:</div><div><br></div><div>WidthInPixels=&quot;50&quot;</div><div><br></div><div>with:</div><div><br></div><div>Width=&quot;50px&quot;</div><div><br></div><div>However, given the benefits of using fractional units, it would be better to start with replacing this:</div><div><br></div><div>WidthInPixels=&quot;50&quot;</div><div><br></div><div>with:</div><div><br></div><div>Width=&quot;50fr&quot;</div><div><br></div><div>And then adjusting to suit the column for better resizing.</div><div><br></div><div></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=6585041'>6585041</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=6585041'>Pin Part to Dashboard Experience</a><p></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Expected Errors:<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;display:inline !important;"><span style="box-sizing:border-box;"><div style="box-sizing:border-box;"><b style="box-sizing:border-box;"></b><br style="box-sizing:border-box;">- Extensions running tests on pinning a part or blade to dashboards will have their tests fail as the new pin to dashboard pane will launch and tests will timeout with an exception.&nbsp;</div><div style="box-sizing:border-box;">- Extension that run pin tests should also ensure that full portal is instantiated during tests with Dashboards accessible as pin functionality needs access to recent dashboards for pinning.&nbsp;</div><div style="box-sizing:border-box;"><br></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;">Solution:</span></div><div style="box-sizing:border-box;"><b style="box-sizing:border-box;"></b><br style="box-sizing:border-box;">- To continue running tests upgrade to the latest Microsoft.Portal.TestFramework.CSharp nuget version&nbsp;1.0.210.0 or higher.&nbsp;The test framework will automatically handle pinning a blade to the most recent dashboard.&nbsp;</div><div style="box-sizing:border-box;">- For pin tests that make use of pinning of a part using Fx/Pinner/Pin function calls to framework or that validate pinning of extension developed parts, should now handle the context pane opening in tests by finding the pin context pane and then pin button and clicking on the pin button.</div><div style="box-sizing:border-box;"><b style="box-sizing:border-box;"></b><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;">Reason For Breaking Change</span></div><div style="box-sizing:border-box;"><b style="box-sizing:border-box;"></b>New pin to any dashboard functionality launches a context pane for users to select a dashboard or create new. This new UI flow will cause existing tests to fail if they aren't handling the context pane.</div></span></span></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=6449603'>6449603</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=6449603'>Cleanup isLogo usage from code</a><p><br style="box-sizing:border-box;"></span><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Expected Errors:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">- Usage of the `isLogo` SVG options will be flagged as compile error at build time.</div><div style="box-sizing:border-box;">- SVG attribute `data-islogo` is flagged at runtime as unsupported. This has no effect on rendering.<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Solution:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">- Remove `isLogo`. The option has not have effect since September 2019, and this is cleanup work on our API surface.<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Reason For Breaking Change**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">- This deprecation and removal is a simplification of the SVG options to reduce confusion on how to preserve colors on the rendered SVG. Now the embedded colors are respected, and when none are provided, they are themed in their respective context.</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><span style="box-sizing:border-box;"></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=6433114'>6433114</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=6433114'>Update the OWIN library to version 4.1</a><p></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Expected Errors:<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;display:inline !important;"><span style="box-sizing:border-box;"><div style="box-sizing:border-box;"><b style="box-sizing:border-box;"></b><br style="box-sizing:border-box;">- The&nbsp;IIdentityFederationMetadataSource interface and the corresponding IdentitiyFederationMetadataSource class have been removed as they are no longer required in the new library.</div><div style="box-sizing:border-box;">- The constructor for class Microsoft.Portal.Security.AzureActiveDirectory.JwtValidater does not have the IIdentityFederationMetadataSource parameter.</div><div style="box-sizing:border-box;">- The constructor for class Microsoft.Portal.Security.AzureActiveDirectory.JwtValidationParameters has been changed to accept a list of signing keys instead of signing tokens.</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;">Solution:</span></div><div style="box-sizing:border-box;"><b style="box-sizing:border-box;"></b><br style="box-sizing:border-box;">- You'll have to modify the code to meet the new variables.</div><div style="box-sizing:border-box;"><b style="box-sizing:border-box;"></b><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;">Reason For Breaking Change</span></div><div style="box-sizing:border-box;"><b style="box-sizing:border-box;"></b><br style="box-sizing:border-box;">- This change upgrages to the latest OWIN v4.1. The breaking changes introduced in this work item are because of underlying changes in the latest OWIN library.</div><div style="box-sizing:border-box;">- There's no concept of a SecurityToken anymore. It has been changed to SigningKeys instead. So this is going to break anyone using this class if they adopt the new SDK.</div><div style="box-sizing:border-box;">- Also, the federation metadata used to be in XML format. The new federation metadata endpoint uses JSON format. So, corresponding changes have been made to how the federation metadata is read.</div></span></span></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=6063098'>6063098</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=6063098'>[Hubs][Breaking change] Obsolete armEndpointLowerCase in Fx/Ajax</a><p><br></span><div>&nbsp;<br></div><div>**Expected Errors:**<br></div><div>&nbsp;- Expect compile-time errors when using armEndpointLowerCase from the Fx/Ajax module<br></div><div>&nbsp;<br></div><div>**Solution:**<br></div><div>&nbsp;- Use the getEndpoints() function in the Fx/Ajax module to get the set of commonly-used endpoints, and lowercase the `arm` property if necessary<br></div><div>&nbsp;<br></div><div>**Reason For Breaking Change**<br></div><div>&nbsp;- Unnecessary duplication with getEndpoints()<br></div><div><br></div><span></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=6016095'>6016095</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=6016095'>Add running ESLint deprecated rule in extension build targets, breaking</a><p><br style="box-sizing:border-box;"></span><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Expected Errors:<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">- `Install the azure portal CLI using 'npm install -g @microsoft/azureportalcli' documentation <a href="https://aka.ms/portalfx/apclidoc">https://aka.ms/portalfx/apclidoc</a>`&nbsp;<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">- msbuild warnings and errors corresponding to lint warnings/errors</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Solution:<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">- Install the CLI see&nbsp;<a href="https://aka.ms/portalfx/apclidoc">https://aka.ms/portalfx/apclidoc</a>&nbsp;and video&nbsp;<a href="https://aka.ms/portalfx/apcli" style="box-sizing:border-box;text-decoration:underline;cursor:pointer;">https://aka.ms/portalfx/apcli</a><span style="display:inline !important;">&nbsp;</span></div><div style="box-sizing:border-box;">- For warnings and errors recommended approach: fix lint warnings/errors by moving to the recommended APIs.<span style="">&nbsp;If you can't immediately implement the recommended fix you can silence the lint warning/error using standard eslint disable comments&nbsp;</span><a href="https://eslint.org/docs/user-guide/configuring#disabling-rules-with-inline-comments" style="">https://eslint.org/docs/user-guide/configuring#disabling-rules-with-inline-comments</a><span style="">.&nbsp; If you do this we recommend you take a work item and include a reference to that in the comment. Disabling linting will drop that use from telemetry and as such you may be broken in a future release if we remove the said API based on apparent non/usage.</span></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Reason For Breaking Change<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span><br></span></div><div style="box-sizing:border-box;"><span>Linting will run on dev mode builds builds targeting local hosting service i.e whenever RunBundlerInDevMode=true for the following reasons</span><br></div><div style="box-sizing:border-box;">- clear notification of deprecated APIs for for extension developers</div><div style="box-sizing:border-box;">- telemetry for portal to understand which deprecated APIs are not in use and can be removed</div><div style="box-sizing:border-box;">- telemetry for portal to understand which deprecated APIs are in heavy use and need --fix rule automation and/or documentation for migration</div><div style="box-sizing:border-box;"><span style="display:inline !important;">- lint for code hygiene, we will drip feed a larger set of rules into the core ruleset over time rather then all at once to avoid large amount of linting warn/errors. if you want to be proactive update to use the recommended set, see linting in <a href="https://aka.ms/portalfx/apcli">https://aka.ms/portalfx/apcli</a>&nbsp;</span><br></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=5142904'>5142904</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=5142904'>Remove 'autosize' API from viewmodel partcontainer and part composition</a><p><br></span><div><br></div><div>**Expected Errors:**<br></div><div><br></div><div>- Calls to `autoSize` API on the PartContainer will now break build since the API was removed.<br></div><div><br></div><div>**Solution:**<br></div><div><br></div><div>- Remove calls to `autosize`. If applicable, migrate to `resizeTo` API on the same container.<br></div><div><br></div><div>**Reason For Breaking Change**<br></div><div><br></div><div>- The API was developed as a prototype and was solely usable by a single extension. That extension already cleaned up their usage. Other usage was already not working and just dead code as such.</div><div><br></div><span></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=5012171'>5012171</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=5012171'>Remove the 'Browse' noPDL blade from ART browse, the 'BrowseResource' blade is the appropriate blade</a><p></div><div><br></div><div>If you are using the Browse noPDL blade, switch your code to use BrowseResource noPDL blade.&nbsp; If you have used the MsPortalFx.Base.Constants.AssetTypes.BrowseBlade constant in Base.Constants.ts, switch to the <span style="display:inline !important;">MsPortalFx.Base.Constants.AssetTypes.</span>BrowseResourceBlade constant (though the value is the same).</div><div><br></div><div>If you have a deep link to the Browse blade (#blade/HubsExtension/Browse) switch the deep link to the BrowseResource blade (#blade/HubsExtension/BrowseResource).</div><div><br></div><div></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=3822777'>3822777</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=3822777'>Deprecate browse V1 (PDL + code in shell and hubs)</a><p></div><div><br></div><div>Browse V1 has been deprecated for some time and no teams are actively using browse V1 at this point.&nbsp; We confirmed the usage using Kusto telemetry logs and have mitigation in place for the few pinning parts remaining.</div><div><br></div><div>This means that the ServiceViewModel's for Browse, Grid, Security and DynamicBlade have all been set to Obsolete and implementation code in FX has been removed.</div><div><br></div><div>Affected:</div><div>PDL compiler will emit a compile error for Browse Type=&quot;ServiceViewModel&quot;. Either remove the Browse entry from PDL or change the Type to:</div><div><ul><li> ResourceType for all ARM resource or</li><li>AssetTypeBlade for custom browse using the asset type's blade property.</li></ul></div><div><br></div><div>PDL compiler will emit a compile error for GridColumns entry, please remove that entry from PDL.</div><div><br></div><div>PDL compiler will emit a compile error for Security entry, please remove that entry from PDL.</div><div><br></div><div>PDL compiler will (and has) emitted a compile error for DynamicBlade entry, please remove that entry from PDL.</div><div><br></div><div>If you have an asset type view model which referenced one of the following interfaces, it is safe to remove that reference:</div><div><br></div><div>MsPortalFx.ViewModels.Services.Browse.Contract</div><div>MsPortalFx.ViewModels.Services.DynamicBlade.Contract<br></div><div>MsPortalFx.ViewModels.Services.GridColumns.Contract<br></div><div>MsPortalFx.ViewModels.Services.Security.Contract<br></div><div><br></div><div>Similarly, if you have an asset view model which derived from one of the following base classes, it is safe to remove that reference:</div><div><br></div><div><div style="box-sizing:border-box;">MsPortalFx.ViewModels.Services.Browse.<span style="display:inline !important;">Service</span></div><div style="box-sizing:border-box;">MsPortalFx.ViewModels.Services.DynamicBlade.<span style="display:inline !important;">Service</span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">MsPortalFx.ViewModels.Services.GridColumns.Service<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">MsPortalFx.ViewModels.Services.Security.Service<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><br></div><div></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=3331114'>3331114</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=3331114'>Obsolete  MsPortalFx.ViewModels.Controls.PreviewTag</a><p><br style="box-sizing:border-box;"></span></div><div style="box-sizing:border-box;"><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Expected Errors:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">MsPortalFx.ViewModels.Controls.PreviewTag is no longer supported and will cause a compile time error is used.<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Solution:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">This control is no longer supported and would need to be replaced with custom HTML if still needed.</div><div style="box-sizing:border-box;"><br></div><div style="box-sizing:border-box;">**Reason For Breaking Change**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><div style="box-sizing:border-box;">This was a control created for internal use of preview features and is not intended to be used externally. On code scan it was determined that no extension is currently using this.</div><div style="box-sizing:border-box;"><br></div></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;"></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=2729311'>2729311</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=2729311'>MsPortalFx.ViewModels.Services.ResourceTypes needs clean up</a><p></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Most of the APIs in MsPortalFx.ViewModels.Services.ResourceTypes are being deprecated.&nbsp; There are performance issues with the majority of the APIs due to excessive regex use and constantly parsing the IDs.</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">The Fx/ArmId module should be used instead:</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">import { ArmId } from &quot;Fx/ResourceManagement&quot;;</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">The ArmId namespace has two main functions, 'parse()' and 'stringify' which operator like JSON's parse and stringify.&nbsp; The parse takes any string value and will produce an 'ArmId' interface which at the top level contains a 'kind' property which if of type const enum ArmId.Kind.&nbsp; If the resource ID parsed is null or not a valid resource ID (including subscription ID or resource group ID), the kind property will be ArmId.Kind.Invalid but the function never returns null.&nbsp; If the kind is not Invalid, it is one of the other kinds which represents a valid ID.&nbsp; The stringify function takes a parsed ArmId and the ArmId.Kind for the string and produces a canonical string for that ID.&nbsp; This two way translation also parsing and stringifying the IDs.</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">For optimum performance any parse() calls inside of loops or in observable subscriptions/computeds should be avoided.&nbsp; Intead in these cases, parse the ID once and store the resulting ArmId value which can be reasoned over many times without the penalty of parsing the resource ID.</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Some of the existing ResourceTypes APIs have fairly direct translations:</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Deprecated | New Recipe</div><div style="box-sizing:border-box;">-- | --</div><div style="box-sizing:border-box;">isTenantResource(resource) |&nbsp;ArmId.parse(resource).kind === ArmId.Kind.TenantResource<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">isSubscriptionId(id) |&nbsp;ArmId.parse(id).kind === ArmId.Kind.Subscription<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">isResourceGroupId(id) | ArmId.parse(id).kind === ArmId.Kind.ResourceGroup<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">isResourceId(id) |&nbsp;ArmId.parse(id).kind === ArmId.Kind.Resource<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">isTagId(id) |&nbsp;ArmId.parse(id).kind === ArmId.Kind.SubscriptionTagValue<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">isResourceManagerId(id) | ArmId.parse(id).kind !== ArmId.Kind.Invalid<br style="box-sizing:border-box;"><br style="box-sizing:border-box;">The following interfaces are replaced by a single ArmId interface with the kind property and all the properties under the follow interfaces:</div><div style="box-sizing:border-box;"><br></div><div style="box-sizing:border-box;">Deprecated | ArmId</div><div style="box-sizing:border-box;">-- | --</div><div style="box-sizing:border-box;">ISubscriptionDescriptor<span style="display:inline !important;"><span>&nbsp;</span>| ArmId</span></div><div style="box-sizing:border-box;">IResourceGroupDescriptor<span style="display:inline !important;"><span>&nbsp;</span>| ArmId</span><br style="box-sizing:border-box;">IResourceManagerDescriptor<span style="display:inline !important;"><span>&nbsp;</span>| ArmId</span><br style="box-sizing:border-box;">IResourceDescriptorBase<span style="display:inline !important;"><span>&nbsp;</span>| ArmId</span><br style="box-sizing:border-box;">IResourceDescriptor<span style="display:inline !important;"><span>&nbsp;</span>| ArmId</span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">IDeploymentDescriptor<span style="display:inline !important;"><span>&nbsp;</span>| ArmId</span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">ITagDescriptor<span style="display:inline !important;"><span>&nbsp;</span>| ArmId</span><br style="box-sizing:border-box;"><br style="box-sizing:border-box;">Subsequently, all the following APIs should be replaced with single ArmId.parse() call:</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Deprecated | ArmId.parse()</div><div style="box-sizing:border-box;">-- | --</div><div style="box-sizing:border-box;">parseSubscriptionDescriptor<span style="display:inline !important;"><span>&nbsp;</span>| ArmId.parse()</span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">parseResourceGroupDescriptor<span style="display:inline !important;"><span>&nbsp;</span>| ArmId.parse()</span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">parseResourceDescriptor<span style="display:inline !important;"><span>&nbsp;</span>| ArmId.parse()</span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">parseResourceManagerDescriptor<span style="display:inline !important;"><span>&nbsp;</span>| ArmId.parse()</span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">parseDeploymentDescriptor<span style="display:inline !important;"><span>&nbsp;</span>| ArmId.parse()</span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">parseTagDescriptor<span style="display:inline !important;"><span>&nbsp;</span>| ArmId.parse()</span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">And all the following build APIs should be replaced with single ArmId.stringify() call with the desired Kind:</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Deprecated |&nbsp;<span style="display:inline !important;">ArmId.stringify()</span></div><div style="box-sizing:border-box;"><span style="display:inline !important;">-- | --</span></div><div style="box-sizing:border-box;">buildDeploymentId<span style="display:inline !important;"><span>&nbsp;</span>|&nbsp;</span><span style="box-sizing:border-box;display:inline !important;">ArmId.stringify()</span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">buildSubscriptionIdFromDescriptor<span style="display:inline !important;"><span>&nbsp;</span>|&nbsp;</span><span style="box-sizing:border-box;display:inline !important;">ArmId.stringify()</span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">buildSubscriptionIdFromResourceGroupDescriptor<span style="display:inline !important;"><span>&nbsp;</span>|&nbsp;</span><span style="box-sizing:border-box;display:inline !important;">ArmId.stringify()</span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">buildSubscriptionIdFromResourceDescriptor<span style="display:inline !important;"><span>&nbsp;</span>|&nbsp;</span><span style="box-sizing:border-box;display:inline !important;">ArmId.stringify()</span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">buildSubscriptionIdFromResourceGroupId<span style="display:inline !important;"><span>&nbsp;</span>|&nbsp;</span><span style="box-sizing:border-box;display:inline !important;">ArmId.stringify()</span> - use ArmId.parse() on the resource group ID<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">buildSubscriptionIdFromResourceId<span style="display:inline !important;"><span>&nbsp;</span>|&nbsp;</span><span style="box-sizing:border-box;display:inline !important;">ArmId.stringify()</span> - use ArmId.parse() on the resource ID<br style="box-sizing:border-box;">buildResourceGroupIdFromDescriptor<span style="display:inline !important;"><span>&nbsp;</span>|&nbsp;</span><span style="box-sizing:border-box;display:inline !important;">ArmId.stringify()</span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">buildResourceGroupIdFromResourceDescriptor<span style="display:inline !important;"><span>&nbsp;</span>|&nbsp;</span><span style="box-sizing:border-box;display:inline !important;">ArmId.stringify()</span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">buildResourceGroupIdFromResourceId<span style="display:inline !important;"><span>&nbsp;</span>|&nbsp;</span><span style="box-sizing:border-box;display:inline !important;">ArmId.stringify()</span> - use ArmId.parse() on the resource ID<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">buildResourceIdFromDescriptor<span style="display:inline !important;"><span>&nbsp;</span>|&nbsp;</span><span style="box-sizing:border-box;display:inline !important;">ArmId.stringify()</span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">For the compare functions, simply toLowerCase() each ID and use string comparison:</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">compareSubscriptionId<br style="box-sizing:border-box;">compareResourceGroupId<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">compareResourceId<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">compareResourceManagerId<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Similarly, for the buildLowerCaseXxx() functions, simply toLowerCase() the ID:</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">buildLowerCaseSubscriptionId<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">buildLowerCaseResourceGroupId<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">buildLowerCaseResourceId<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">Others require some work:</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">isDeploymentId should use parse(id), then check that the kind is Resource and that the provider is 'Microsoft.Resources' and type is 'deployments'</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">buildSubscriptionIdFromSubscriptionName (and buildSubscriptionFromId) - use&nbsp;`/subscriptions/${subscription}`<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">buildResourceGroupIdFromSubscriptionAndResourceGroupName - use&nbsp;subscription ? `/subscriptions/${subscription}${resourceGroup ? `/resourceGroups/${resourceGroup}` : ``}` : ``<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">buildResourceTypeFromResourceDescriptor - use armId.resourceType<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">buildResourceTypeFromResourceId (and&nbsp;buildResourceTypeFromResourceManagerId) - use ArmId.parse(resourceId).resourceType<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">buildTopmostParentResourceIdFromDescriptor - use&nbsp;`/subscriptions/${armId.subscription}/resourceGroups/${armId.resourceGroup}/providers/${armId.provider}/${armId.resourceTypes[0]}/${armId.resourceIds[0]}`</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">buildParentResourceIdFromDescriptor - there is no great way to handle this case other than parsing the resource ID using ArmId.parse(), then trimming the last entry from the resourceTypes and resourceIds and then calling ArmId.stringify().&nbsp; This is a special case and should be implemented locally however.<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">isParentResource - use:<br style="box-sizing:border-box;"><span style="box-sizing:border-box;">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;const pattern = toLowerCase(parentResourceId) + &quot;/&quot;;<br style="box-sizing:border-box;"></span><div style="box-sizing:border-box;">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;return startsWith(toLowerCase(childResourceId), pattern);<br style="box-sizing:border-box;"></div><span style="box-sizing:border-box;"></span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">buildTagName - use:&nbsp;`${tagPrefix}:${resourceId}`<br style="box-sizing:border-box;"><br style="box-sizing:border-box;">buildRelatedTagName - use:&nbsp;`hidden-related:${resourceId}`<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">buildLinkTagName - use:&nbsp;`hidden-link:${resourceId}`<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">tryBuildResourceManagerKey - use:&nbsp;ArmId.parse(id) !== ArmId.Kind.Invalid ? id.toLowerCase() : null<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">subscriptionContainsResourceGroup - use:&nbsp;<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;const subscriptionArmId = ArmId.parse(subscriptionId);<br style="box-sizing:border-box;"></span><div style="box-sizing:border-box;">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;if (subscriptionArmId.subscription === ArmId.parse(resourceGroupId).subscription &amp;&amp; subscriptionArmId.kind === ArmId.Kind.Subscription) {}<br style="box-sizing:border-box;"></div><span style="box-sizing:border-box;"></span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">subscriptionContainsResource - use:<br style="box-sizing:border-box;"><span style="box-sizing:border-box;">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;const subscriptionArmId = ArmId.parse(subscriptionId);<br style="box-sizing:border-box;"></span><div style="box-sizing:border-box;">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;if (subscriptionArmId.subscription === ArmId.parse(resourceId).subscription &amp;&amp; subscriptionArmId.kind === ArmId.Kind.Subscription) {}<br style="box-sizing:border-box;"></div><span style="box-sizing:border-box;"></span><br style="box-sizing:border-box;">resourceGroupContainsResource - use:&nbsp;<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;const rgArmId = ArmId.parse(resourceGroupId);<br style="box-sizing:border-box;"></span><div style="box-sizing:border-box;">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;const resArmId = ArmId.parse(resourceId);<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;if (rgArmId.subscription === resArmId.subscription &amp;&amp; rgArmId.resourceGroup === resArmId.resourceGroup &amp;&amp; rgArmId.kind === ArmId.Kind.ResourceGroup) {}<br style="box-sizing:border-box;"></div><span style="box-sizing:border-box;"></span><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><span style="box-sizing:border-box;"></p></td></tr><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=2649781'>2649781</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=2649781'>remove status from ResourceTypes.ts. Contract interface</a><p></p></td></tr></table>

## 5.0.303.7391
<table><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7343607'>7343607</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=7343607'>Add dependency MSBuild DLLs to Bundle </a><p></div><div style="box-sizing:border-box;font-family:&quot;Segoe UI&quot;, system-ui, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, sans-serif;">This change introduces some required DLLs for running Bundle.exe in certain stand-alone configurations (outside of an MSBuild pipeline) which were previously unaccounted for.</div><div style="box-sizing:border-box;font-family:&quot;Segoe UI&quot;, system-ui, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, sans-serif;">This change is not expected to be breaking.</div><div style="box-sizing:border-box;font-family:&quot;Segoe UI&quot;, system-ui, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, sans-serif;"></p></td></tr></table>

## 5.0.303.4271
<table><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=5468245'>5468245</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=5468245'>Investigate .NET Core support for the build</a><p></div><div><br></div><div>This change adds .NET Core versions of some Portal SDK tools to the existing NuGet packages. (In folders &quot;netcore30&quot; and &quot;netstandard20&quot; etc.)</div><div><br></div><div>**PLEASE DO NOT USE THE .NET CORE BINARIES YET**</div><div><br></div><div>Support for .NET Core in the Portal SDK is not ready for broad consumption.</div><div>Existing binaries in existing packages are still .NET Framework versions, and are the only type supported.</div><div><br></div><div>If you are seeing C# build errors with the following error: &quot;You must add a reference to assembly 'netstandard'....&quot; then follow the answer in this StackOverflow question:&nbsp;<a href="https://stackoverflow.microsoft.com/questions/145700/145701#145701">https://stackoverflow.microsoft.com/questions/145700/145701#145701</a></div><div><br></div><div></p></td></tr></table>

## 5.0.303.3341
<table><tr><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=6449603'>6449603</a></td><td><a href='https://msazure.visualstudio.com/DefaultCollection/One/_queries?id=6449603'>Cleanup isLogo usage from code</a><p><br style="box-sizing:border-box;"></span><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Expected Errors:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">- Usage of the `isLogo` SVG options will be flagged as compile error at build time.</div><div style="box-sizing:border-box;">- SVG attribute `data-islogo` is flagged at runtime as unsupported. This has no effect on rendering.<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Solution:**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">- Remove `isLogo`. The option has not have effect since September 2019, and this is cleanup work on our API surface.<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">**Reason For Breaking Change**<br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><div style="box-sizing:border-box;">- This deprecation and removal is a simplification of the SVG options to reduce confusion on how to preserve colors on the rendered SVG. Now the embedded colors are respected, and when none are provided, they are themed in their respective context.</div><div style="box-sizing:border-box;"><br style="box-sizing:border-box;"></div><span style="box-sizing:border-box;"></p></td></tr></table>