﻿# Editor

 
<a name="basics"></a>
### Basics
Editor control is a wrapper for the "Monaco" editor which supports various languages, syntax highlighting, intellisense, real-time syntax checking and validation.


<!-- TODO get an IMAGE to embed here -->

<!-- TODO get an SAMPLE CODE to embed here -->

 
<a name="when-to-use"></a>
### When to use
The SDK offers the **Editor** and **DiffEditor** control to use when the user is managing text content.  You can use them in conjuction with each other. The Editor is useful for creating, viewing and editing content while the DiffEditor enables the user to review changes before or after having saved them.

Use the Editor control when the user needs to view/edit text in various languages
* B - Bat
* C - C, CoffeeScript, Cpp, CSharp, CSHTML, Css, Custom, Dockerfile
* F - Fsharp
* G - Go
* H - Handlebars, HTML
* I - Ini
* J - Java, JavaScript, JSHTM, JSON
* L - Less, Lua
* M - MarkDown, MySQL
* O - ObjectiveC
* P - PgSQL, Php, PowerShell, Pug, Python
* R - R, Ruby
* S - SQL, Swift
* T - Text, TypeScript
* V - VisualBasic
* X - XAML, XML



 
<a name="best-practices"></a>
### Best practices

<a name="best-practices-do"></a>
#### Do

* Set the proper contentType for your needs

<a name="best-practices-don-t"></a>
#### Don&#39;t

* Don't make the Editor too narrow, you need enough room to display content




 
<a name="developer-tips-and-tricks"></a>
### Developer tips and tricks



<a name="developer-tips-and-tricks-interactive-control-and-sample-source-code"></a>
#### Interactive control and sample source code
Go to the playground site to use the latest control and get source code for your project.  [Learn more about playground](./top-extensions-controls-playground.md).

The Editor control offers different create methods and has the following entries in the interactive controls playground

*  <a href="https://ms.portal.azure.com/?Microsoft_Azure_Playground=true#blade/Microsoft_Azure_Playground/ControlsIndexBlade/Editor_createEditor_Playground" target="_blank">Editor (Editor)</a>

*  <a href="https://ms.portal.azure.com/?Microsoft_Azure_Playground=true#blade/Microsoft_Azure_Playground/ControlsIndexBlade/Editor_createCustomEditor_Playground" target="_blank">Editor (CustomEditor)</a>

*  <a href="https://ms.portal.azure.com/?Microsoft_Azure_Playground=true#blade/Microsoft_Azure_Playground/ControlsIndexBlade/Editor_createJSONEditor_Playground" target="_blank">Editor (JSONEditor)</a>

*  <a href="https://ms.portal.azure.com/?Microsoft_Azure_Playground=true#blade/Microsoft_Azure_Playground/ControlsIndexBlade/Editor_createTypeScriptEditor_Playground" target="_blank">Editor (TypeScriptEditor)</a>



 
<a name="related-info"></a>
### Related info

<!-- TODO link to Figma -->

* [Azure design guidance](http://aka.ms/portalfx/design)


