<a name="glossary"></a>
## Glossary

This section contains a glossary of terms and acronyms that are used in this document. For common computing terms, see [https://techterms.com/](https://techterms.com/). For common acronyms, see [https://www.acronymfinder.com](https://www.acronymfinder.com).
 
| Term                         | Meaning |
| ---                          | --- |
| data stack                   | Contains all the information that the browser associates with the current testing session. |
| deep link                    | A link that jumps directly into the extension within the Portal. Each deep link consists of the Portal URL, the target directory domain name or tenant id (e.g. microsoft.com), the type prefix (i.e. asset, resource, blade, browse, or marketplace), and the actual deep link target. |
| Document Object Model (DOM)  | A methodology that treats an  HTML, XHTML, or XML page as a tree structure that contains hierarchical objects. These nodes   represent every item  that is part of the document and can be manipulated programmatically. Visible changes to DOM nodes may be displayed in the browser. |
| iFrame                       | An inline frame that embeds a document within the current HTML document. | 
| Knockout                     | A standalone JavaScript implementation of the Model-View-ViewModel architecture. | 
| KO                         |  Knockout   | 
| minification                 | The process of removing all unnecessary characters from source code and rewriting it to make it smaller without changing its functionality. Removed characters may be whitespace, newlines, comments, and other non-executable items that increase code readability, while rewritten code can be local variable names, boolean logic, etc. Minification reduces the amount of data that is transferred across the Internet. | 
| PO | Proxy Observable |
| proxy observable (PO)        | A layer over **Knockout** observables that is used to keep in sync an observable's value across iframes. | 
| Selenium                     | Software-testing framework for web applications that  provides a playback tool for authoring tests.  |
| startboard                   | |
| sticky                       | Provides quick statistics and fast access to specific types of testing functionality. |
| ViewModel                    | Holds all the data associated with the screen. Allows user data to be separated from context pane data and to persist through configuration changes. Also view model, View-Model. |

