<a name="design-guidelines"></a>
# Design Guidelines

These design guidelines provide solutions for common scenarios in Azure.  We formalize these best practices once several teams solve a similar problem using a well-researched approach and see successful real-world usage of the common solution. Azure teams should leverage these design guidelines to accelerate extension development and to provide users with a familiar experience so that users can easily adopt new Azure services.

<a name="design-guidelines-controls-design-guidance"></a>
## Controls design guidance
Controls are the building blocks of the Azure UX. They allow users to view, edit, and analyze data. Using built in controls provides consistency across the portal. Additionally, issues around usability, accessibility, security and any other fundamentals are handled by the Framework team.   
* [Controls list and design guidance](design-patterns-controls.md)


<a name="design-guidelines-design-patterns"></a>
## Design patterns
Design patterns provide solutions for common Azure scenarios.

<a name="design-guidelines-design-patterns-portal-patterns"></a>
### Portal patterns
Common navigation and interaction models across the portal

* [Full screen navigation](design-patterns-page-fullscreen.md) ensures the portal behaves like a website with full screen pages and no horizontal scrolling

* [Guidance and feedback](design-patterns-page-notifications.md) provide in-line guidance, feedback, validations, errors and portal notifications to users

<a name="design-guidelines-design-patterns-resource-management-patterns"></a>
### Resource management patterns
UX to manage the full lifecycle of Azure resources.

* [Create a resource](design-patterns-resource-create.md)

* [Browse resources](design-patterns-resource-browse.md)

* [Manage a resource](design-patterns-resource-manage.md)

<a name="design-guidelines-design-patterns-page-design-patterns"></a>
### Page design patterns
Page layouts for common Azure scenarios including guidance on where commands, tabs, fields and buttons should be placed

* [Overview pages](design-patterns-page-overview.md) provide get started, overview, configuration, monitoring and other information for a service or resource

* [Responsive pages](design-patterns-page-responsive-design.md)

* [Lists and grids](design-patterns-page-grid.md)

* [Forms](design-patterns-page-forms.md) gather, validate and submit user input

* [Filtering](design-patterns-page-filtering.md)


<a name="design-guidelines-design-patterns-page-design-patterns-quick-tips-on-page-design"></a>
#### Quick tips on page design
    * Pages should be full screen so that we avoid partial pages and avoid horizontal scrolling
    * Content on a page should be constrained to a maximum width of 700px
    * Each page that is displaying data should have a **Refresh** command

<a name="design-guidelines-design-templates-toolkits-and-resources"></a>
## Design templates, toolkits and resources
Design templates, toolkits and resources are available so that you can easily create designs that leverage these patterns.

* Design templates and toolkits
    * <a href="https://www.figma.com/file/Bwn8rmUOYtnPRwA3JoQTBn/Azure-Portal-Toolkit?node-id=3002%3A373291" target="_blank">Portal design toolkit in Figma</a>
    * List of all [design templates and toolkits](design-patterns-toolkits.md)

* [Icons and illustrations](design-patterns-icons.md)

* [Style guide](design-patterns-style-guide.md)


<a name="design-guidelines-writing-guides"></a>
## Writing guides
Writing guides are key resources to brand voice and content style and standards for Azure and the Business Applications Group within the Cloud + AI division. These two guides supply quick answers and essential direction for anyone who creates content — whether for brand naming, product design, documentation, marketing, PR, events, or other customer communications. 

 * [Microsoft Cloud Style Guide](https://worldready.cloudapp.net/Styleguide/Read?id=2696&topicid=25351)
 * [Microsoft Writing Style Guide](http://aka.ms/style)





