# Contributing to the W3C Process Document
Thank-you for offering to contribute to the [W3C Process Document](https://www.w3.org/Consortium/Process/). Here we provide some details on how you can contribute. 

Changes to the process document tend to fall into a few classes, and how the W3C handles these varies. Simple editorial changes may require little review, but more substantial changes will require a more substantial review and discussions by the W3C community. Please read the material below, and get involved as explained. 

If you have any questions, please [raise an issue](/../../issues).

## Simple Editorial Changes
For simple editorial changes, please feel free to raise a `pull request` or [raise an issue](/../../issues) on this repository. A simple editorial change can be things like spelling and grammar mistakes, broken links, and so on.

Some changes may appear simple but may actually be more complicated than they appear. Don't worry - please continue to send your `pull request` or [raise an issue](/../../issues) and we can discuss. 

## The W3C Process Community Group
The W3C runs a [Process Community Group](https://www.w3.org/community/w3process/), which is an open group created to manage discussions on developing the [W3C Process Document](https://www.w3.org/Consortium/Process/). Some suggestions for changes to the [W3C Process Document](https://www.w3.org/Consortium/Process/) will need to be made within the [Process Community Group](https://www.w3.org/community/w3process/), please see information below as to whether you need to take your suggestions to the group or can just raise a `pull request` or `issue`.

## Changes that Affect the Way the W3C Operates but Do Not Change the Policy
For changes that affect the way that the W3C operates but do not change policy please do the following:

* [Raise an issue](/../../issues) on this repo
* Make sure the [Process Community Group](https://www.w3.org/community/w3process/) adds the issue to its agenda. This will allow you to explain why you think this is an improvement to the operation of the W3C (it's probably not helpful to provide a Pull Request until you have consensus on the approach).

The best way to ensure your issue gets added to the [Process Community Group](https://www.w3.org/community/w3process/) agenda is to add yourself to the group, please visit [the group homepage](https://www.w3.org/community/w3process/) and select the button "Join or Leave this Group".

Another way to ensure the [Process Community Group](https://www.w3.org/community/w3process/) addressed your issue is to check back on the [issues page](/../../issues) page and ask whether it has been addressed. It is more effective to join the group, but you have this option if you need it. 

The [Process Community Group](https://www.w3.org/community/w3process/) will discuss your issue, and decide whether the change can be made or whether the issue needs to be brought to the [Advisory Board](https://www.w3.org/Consortium/Process/#AB) or [Advisory Committee](https://www.w3.org/Consortium/Process/#AC) for discussion; see the next section for more information on this process.

If the [Process Community Group](https://www.w3.org/community/w3process/) agrees the issue does not change the policy and agrees to make the changes detailed in your issue, you may either raise a `pull request` or wait for the Editor to make the required changes. Note: raising a `pull request` **will** be faster. See more details about `pull requests` below.

## Changes that Affect the Way the W3C Operates and Change the Policy
For changes that represent a change of policy in the W3C, the idea will need to be brought to the [Advisory Board](https://www.w3.org/2002/ab/) or [Advisory Committee](https://www.w3.org/participate/meetings). Again, a Pull Request can wait until you have gained consensus with these two committees.

You can raise the issue with the [Process Community Group](https://www.w3.org/community/w3process/), and you can suggest (or they will notice) that it needs policy discussion and refer it onwards. But you may prefer to initiate that discussion yourself.

Getting something in front of both the [Advisory Board](https://www.w3.org/Consortium/Process/#AB) or [Advisory Committee](https://www.w3.org/Consortium/Process/#AC) can be tricky. If your organisation is a W3C member please let your Advisory Committee member know; they will then be able to email the Advisory Committee or bring the issue up at an Advisory Committee meeting. To reach the [Advisory Board](https://www.w3.org/2002/ab/) you can [raise an issue](/../../issues) on this repo (at least two AB members monitor this repo) or send an email to ab@w3.org.

Gaining consensus from the [Advisory Board](https://www.w3.org/2002/ab/) or [Advisory Committee](https://www.w3.org/participate/meetings) will take some time. After consensus has been reached you may either raise a `pull request` which include the changes agreed by these committees or wait for the Editor to make the required changes. See more details about `pull requests` below.

## Edit and Pull Request Instructions
To make an edit to the document simply edit the [`index.bs`](index.bs) file
and send a pull request when your changes are done.
This document is maintained using [Bikeshed](https://tabatkins.github.io/bikeshed/).
See the [section about markup](https://tabatkins.github.io/bikeshed/#markup-shortcuts) in Bikeshed's documentation
for full details about the syntax.

**Only the source (`index.bs`) should be committed**,
as this repository is configured to run bikeshed server-side and push the result to the gh-pages branch.

If you want to run Bikeshed locally to check the results of your edits before committing or sending a pull request,
follow [the installation instructions](https://tabatkins.github.io/bikeshed/#installing) in Bikeshed's documentation.
Once Bikeshed is installed, just type `bikeshed` to generate `index.html` from `index.bs`.

If you have the rights to edit this repo your edits will need to be made on a new branch. If you do not have the rights to edit this repo please `fork` the repo, make your edits, then send a `pull request`.

Pull Requests should result in a correct-looking document (formats and lays out correctly).

## Notes
Please feel free to suggest how this document can improve by [raising an issue](/../../issues) on this repo.
