<!--
	This document is formatted using Bikeshed.
	Roughly speaking, it is a Markdown preprocessor,
	with additional functionality for cross-spec autolinking,
	automatic generation of indexes/ToC/etc,
	and many other features.
	See https://tabatkins.github.io/bikeshed/ for detailed documentation.

	When making edits, please respect the following coding style:
	- Tabs for indentation, spaces for alignment.
	- Semantic line breaks: at phrases boundaries, each line < ~80ch
	- Indent the entire spec one level except for headings.
	- Line break after opening heading tag, so heading text
	  is easy to pick out when scanning the source.
	- Empty lines between blocks.
	- Indent contents of block-level HTML elements
	  (except <p>, which we usually imply via Markdown formatting
	  and otherwise leave inlined at the start of the paragraph).
	  Definitely leave a break and indent
	  after any block start tag with attributes, though.
	- No optional end tags.
	- Use manual IDs so that IDs remain stable as you adjust the heading text;
	  add old IDs (via empty elements with IDs, or e.g. Bikeshed's oldids attribute)
	  when removing or changing IDs so that links to your spec don't break.
-->
<pre class='metadata'>
Title: W3C Process Document
Group: processcg
Status: CG-DRAFT
ED: https://www.w3.org/Consortium/Process/Drafts/
TR: https://www.w3.org/Consortium/Process/
Previous Version: https://www.w3.org/2021/Process-20211102/
Previous Version: https://www.w3.org/2020/Process-20200915/
Previous Version: https://www.w3.org/2019/Process-20190301/
Previous Version: https://www.w3.org/2018/Process-20180201/
Previous Version: https://www.w3.org/2017/Process-20170301/
Editor: Elika J. Etemad / fantasai, Invited Expert, https://fantasai.inkedblade.net/contact
Editor: Florian Rivoal, Invited Expert, https://florian.rivoal.net/
Former Editor: Natasha Rooney, Invited Expert
Former Editor: Charles McCathie Nevile, Yandex, http://yandex.com
Former Editor: Ian Jacobs, W3C, https://www.w3.org/
Level: none
Repository: w3c/w3process
Shortname: w3process
Abstract:
	The mission of the World Wide Web Consortium (<abbr>W3C</abbr>) is to lead the World Wide Web to its full potential
	by developing common protocols that promote its evolution and ensure its interoperability.
	The W3C Process Document describes the organizational structure of W3C and processes,
	responsibilities and functions that enable W3C to accomplish its mission.
	This document does not describe the internal workings of the Team.

	For more information about the W3C mission and the history of W3C,
	please refer to <a href="https://www.w3.org/Consortium/">About W3C</a>.
Status Text:
	This document,
	which is based on the <a href="https://www.w3.org/2021/Process-20211102/">2 November 2021 Process</a>,
	is a work in progress
	and further changes may occur before completion of this revision cycle.
	As detailed in <a href="https://www.w3.org/Consortium/Process/#GAProcess">Section 11 Process Changes</a>,
	once the W3C Advisory Board considers it ready for adoption,
	it will be offered for W3C Advisory Committee Review.
	A <a href="https://www.w3.org/Consortium/Process/Drafts/snapshots/2023-04">7 April snapshot</a> was created
	and sent for W3C Advisory Committee Review on 12 April 2023.
Issue Tracking: Github (preferred) https://github.com/w3c/w3process/issues/
Issue Tracking: Public mailing list https://lists.w3.org/Archives/Public/public-w3process/
Issue Tracking: Member-only mailing list https://lists.w3.org/Archives/Member/process-issues
Boilerplate: repository-issue-tracking off
</pre>

<style>
.about { margin-left: 3em; margin-right: 3em; font-size: .83em}
table { margin-left: auto; margin-right: auto }
.diagram { text-align: center; margin: 2.5em 0 }
.issue::before {content: "Issue: "}
.issue {border: 2px dashed red; background-color: #ffa;}
.issue .issue {background-color: #fcc;}
.rfc2119 {font-variant:small-caps}

/*for the SVG - navigation highlighting */

:focus path,
:focus polygon,
:focus ellipse {
	stroke-width: 4px;
}
g g:hover path,
g g:hover polygon,
g g:hover ellipse {
	stroke-width: 4px;
}
:focus text,
g g:hover text {
	stroke: black;
	stroke-width: .5px;
}

@media print {
	a[data-ref]::after { content: " [" attr(data-ref) "]"; }
}

.table-borders {
	border-collapse: collapse;
}
.table-borders td,
.table-borders th {
	border: 1px solid black;
	padding: 0.5ex;
}

</style>
<!--[if lt IE 9]><script src='undefined://www.w3.org/2008/site/js/html5shiv.js'></script><![endif]-->

<h2 class="no-num no-toc no-ref" id="pp">
Relation of Process Document to Patent Policy and Other Policies</h2>

	<!-- DO NOT REMOVE THIS SECTION OR ITS REFERENCE TO THE PATENT POLICY WITHOUT DISCUSSING WITH PSIG / COUNSEL. -->

	W3C Members' attention is called to the fact
	that provisions of the Process Document are binding on Members
	per the <a href="https://www.w3.org/Consortium/Agreement/Member-Agreement">Membership Agreement</a> [[MEMBER-AGREEMENT]].
	The <a href="https://www.w3.org/Consortium/Patent-Policy/">W3C Patent Policy</a> [[!PATENT-POLICY]]
	and other policies
	incorporated by normative reference as a part of the Process Document
	are equally binding.

	The Patent Policy and CEPC place additional obligations on Members, Team, and other participants in W3C.
	The Process Document does not restate those requirements but includes references to them.
	The Process Document, Patent Policy, and CEPC have been designed to allow each to evolve independently.

	In the Process Document, the term “participant” refers to an individual, not an organization.

<h2 class="no-num no-toc no-ref" id=terms>
Conformance and specialized terms</h2>

	The terms
	<em class="rfc2119">must</em>,
	<em class="rfc2119">must not</em>,
	<em class="rfc2119">should</em>,
	<em class="rfc2119">should not</em>,
	<em class="rfc2119">required</em>,
	and <em class="rfc2119">may</em>
	are used in accordance with <a href="https://www.ietf.org/rfc/rfc2119.txt">RFC 2119</a>.
	The term <dfn id="not-required" noexport><em class="rfc2119">not required</em></dfn>
	is equivalent to the term <em class="rfc2119">may</em>
	as defined in RFC2119
	[[!RFC2119]].

	Some terms have been capitalized in this document (and in other W3C materials)
	to indicate that they are entities with special relevance to the W3C Process.
	These terms are defined within this document,
	and readers are reminded that the ordinary English definitions are insufficient
	for the purpose of understanding this document.

<nav data-fill-with="table-of-contents"></nav>
<main>

<h2 id="Intro">
Introduction</h2>

	W3C work revolves around the standardization of Web technologies.
	To accomplish this work, W3C follows processes that promote the development of high-quality standards
	based on the <a href="#Consensus">consensus</a> of the Membership, Team, and public.
	W3C processes promote fairness, responsiveness, and progress:
	all facets of the W3C mission.
	This document describes the processes W3C follows in pursuit of its mission.

	The W3C Process promotes the goals of quality and fairness in technical decisions
	by encouraging <a href="#Consensus">consensus</a>,
	soliciting reviews (by both Members and public),
	incorporating implementation and interoperability experience,
	and requiring Membership-wide approval as part of the <a href="#Reports">technical report development process</a>.
	[[#group-participation|Participants]] in W3C include
	<a href="#member-rep">representatives of its Members</a> and the [=Team=],
	as well as <a href="#invited-expert-wg">Invited Experts</a>
	who can bring additional expertise or represent additional stakeholders.
	[=Team=] representatives both contribute to the technical work
	and help ensure each group's proper integration with the rest of W3C.

	W3C’s technical standards, called [=W3C Recommendations=],
	are developed by its [=Working Groups=];
	W3C also has other types of publications,
	all described in [[#Reports]].
	W3C has various types of groups;
	this document describes the formation and policies
	of its chartered [=Working Groups=] and [=Interest Groups=],
	see [[#Policies]] and [[#GAGeneral]].
	W3C also operates Community and Business Groups,
	which are separately described in <a href="https://www.w3.org/community/about/agreements/">their own process document</a> [[BG-CG]].

	In addition, several groups are formally established by the Consortium:
	the <a href="#AC">W3C Advisory Committee</a>, which has a representative from each Member,
	and two oversight groups elected by its membership:
	the <a href="#AB">Advisory Board (AB)</a>,
	which helps resolve Consortium-wide non-technical issues and manages the <a href="#GAProcess">evolution of the W3C process</a>;
	and the <a href="#TAG">Technical Architecture Group (TAG)</a>,
	which helps resolve Consortium-wide technical issues.

	Here is a general overview of how W3C initiates standardization of a Web technology:

	<ol>
		<li>
			People generate interest in a particular topic.
			For instance, Members express interest by developing proposals in Community Groups
			or proposing ideas in <a href="#Submission">Member Submissions</a>.
			Also, the <a href="#Team">Team</a> monitors work inside and outside of W3C for signs of interest,
			and helps organize <a href="#GAEvents">Workshops</a> to bring people together
			to discuss topics that interest the W3C community.

		<li>
			When there is enough interest and an engaged community,
			the [=Team=] works with the Membership
			to draft proposed <a href="#WGCharterDevelopment">Interest Group or Working Group charters</a>.
			W3C Members <a href="#CharterReview">review</a> the proposed charters,
			and when there is support within W3C for investing resources in the topic of interest,
			W3C approves the group(s),
			and they begin their work.
	</ol>

	Further sections of this Process Document deal with topics including
	liaisons ([[#Liaisons]]),
	confidentiality ([[#dissemination]]),
	and formal decisions and appeals ([[#decisions]]).


<h2 id="Organization">
Members and the Team</h2>

	W3C's mission is to lead the Web to its full potential.
	W3C <a href="#Members">Member</a> organizations provide resources to this end,
	and the W3C <a href="#Team">Team</a> provides the technical leadership
	and organization to coordinate the effort.

<h3 id="Members">
Members</h3>

	<dfn lt="W3C Member|Member">W3C Members</dfn> are
	organizations subscribed according to the <a href="https://www.w3.org/Consortium/Agreement/Member-Agreement">Membership Agreement</a> [[MEMBER-AGREEMENT]].
	They are represented in W3C processes as follows:

	<ol>
		<li>
			One representative per Member organization participates
			in the [=Advisory Committee=]
			which oversees the work of W3C.

		<li>
			Representatives of Member organizations participate
			in <a href="#GAGeneral">Working Groups and Interest Groups</a>,
			where they author and review <a href="#Reports">technical reports</a>.
	</ol>

	<p id="MemberSubscription">W3C membership is open to all entities,
	as described in “<a href="https://www.w3.org/Consortium/join">How to Join W3C</a>” [[JOIN]];
	(refer to the public list of <a href="https://www.w3.org/Consortium/Member/List">current W3C Members</a> [[MEMBER-LIST]]).
	The <a href="#Team">Team</a> <em class="rfc2119">must</em> ensure
	that Member participation agreements remain <a href="#Team-only">Team-only</a>
	and that no Member receives preferential treatment within W3C.

	<p id="IndividualParticipation">While W3C does not have a class of membership tailored to individuals,
	individuals <em class="rfc2119">may</em> join W3C.
	Restrictions pertaining to <a href="#MemberRelated">related Members</a> apply
	when the individual also <a href="#member-rep">represents</a> another W3C Member.

<h4 id="MemberBenefits">
Rights of Members</h4>

	Each Member organization enjoys the following rights and benefits:

	<ul>
		<li>
			A seat on the <a href="#AC">Advisory Committee</a>;

		<li>
			Access to <a href="#Member-only">Member-only</a> information;

		<li>
			The <a href="#Submission">Member Submission</a> process;

		<li>
			Use of the W3C Member logo on promotional material and to publicize the Member's participation in W3C.
			For more information, please refer to the Member logo usage policy
			described in the <a href="https://www.w3.org/Member/Intro">New Member Orientation</a> [[INTRO]].
	</ul>

	Furthermore, subject to further restrictions included in the Member Agreement,
	representatives of Member organizations participate in W3C as follows:

	<ul>
		<li>
			In <a href="#GAGeneral">Working Groups and Interest Groups</a>.

		<li>
			In <a href="#GAEvents">Workshops and Symposia</a>;

		<li>
			On the Team, as <a href="#fellows">W3C Fellows</a>.
	</ul>

	The rights and benefits of W3C membership [[MEMBER-AGREEMENT]]
	are contingent upon conformance to the processes described in this document.
	Disciplinary action for anyone participating in W3C activities is described in [[#discipline]].

	Additional information for Members is available at the <a href="https://www.w3.org/Member/">Member website</a> [[MEMBER-HP]].

<h4 id="RelatedAndAssociatedMembers" oldids="RelatedAndConsortiumMembers">
Member Associations and Related Members</h4>

<h5 id="MemberAssoc" oldids="fdn-member-consortium, MemberConsortia">
Membership Associations</h5>

	A “<dfn lt="Member Association | Member Associations">Member Association</dfn>” means a consortium,
	user society,
	or association of two or more individuals,
	companies,
	organizations or governments,
	or any combination of these entities
	which has the purpose of participating in a common activity
	or pooling resources to achieve a common goal other than participation in,
	or achieving certain goals in,
	W3C.
	A joint-stock corporation or similar entity is not a [=Member Association=]
	merely because it has shareholders or stockholders.
	If it is not clear whether a prospective Member qualifies as a [=Member Association=],
	the [=CEO=] may reasonably make the determination.
	For a [=Member Association=], the rights and privileges of W3C Membership
	described in the W3C Process Document extend to the [=Member Association=]'s paid staff
	and Advisory Committee representative.

	[=Member Associations=] <em class="rfc2119">may</em> also designate
	up to four (or more at the Team's discretion) individuals
	who, though not employed by the organization,
	<em class="rfc2119">may</em> exercise the rights of <a href="#member-rep">Member representatives</a>.

	For [=Member Associations=] that have individual people as members,
	these individuals <em class="rfc2119">must</em> disclose their employment affiliation
	when participating in W3C work.
	Provisions for <a href="#MemberRelated">related Members</a> apply.
	Furthermore, these individuals <em class="rfc2119">must</em> represent the broad interests of the W3C Member organization
	and not the particular interests of their employers.

	For Member Associations that have organizations as Members,
	all such designated representatives <em class="rfc2119">must</em> be an official representative of the Member organization
	(e.g. a Committee or Task Force Chairperson)
	and <em class="rfc2119">must</em> disclose their employment affiliation when participating in W3C work.
	Provisions for <a href="#MemberRelated">related Members</a> apply.
	Furthermore, these individuals <em class="rfc2119">must</em> represent the broad interests of the W3C Member organization
	and not the particular interests of their employers.

	For all representatives of a Member Association,
	IPR commitments are made on behalf of the Member Association,
	unless a further IPR commitment is made by the individuals' employers.

<h5 id="MemberRelated">
Related Members</h5>

	In the interest of ensuring the integrity of the consensus process,
	Member involvement in some of the processes in this document is affected by related Member status.
	As used herein, two Members are <dfn export lt="Related Member">related</dfn> if:

	<ol>
		<li>
			Either Member is a [=subsidiary=] of the other, or

		<li>
			Both Members are [=subsidiaries=] of a common entity, or

		<li>
			The Members have an employment contract or consulting contract that affects W3C participation.
	</ol>

	A <dfn>subsidiary</dfn> is an organization of which effective control and/or majority ownership rests with another,
	single organization.

	[=Related Members=] <em class="rfc2119">must</em> disclose these relationships
	according to the mechanisms described in the <a href="https://www.w3.org/Member/Intro">New Member Orientation</a> [[INTRO]].

<h3 id="Team" oldids="def-Director">
The W3C Team</h3>

	The <dfn export lt="Team | W3C Team">Team</dfn> consists of
	<dfn>CEO</dfn>,
	W3C paid staff,
	unpaid interns,
	and W3C Fellows.
	<dfn id="fellows">W3C Fellows</dfn> are Member employees working as part of the Team;
	see the <a href="https://www.w3.org/Consortium/Recruitment/Fellows">W3C Fellows Program</a> [[FELLOWS]].
	The Team provides technical leadership about Web technologies,
	organizes and manages W3C activities to reach goals
	within practical constraints (such as resources available),
	and communicates with the Members and the public
	about the Web and W3C technologies.

	The CEO <em class="rfc2119">may</em> delegate responsibility
	(generally to other individuals in the Team)
	for any of their roles described in this document.
	[=Team Decisions=] derive from the [=CEO=]'s authority,
	even when they are carried out by other members of the [=Team=].

	Oversight over the [=Team=],
	budgeting,
	and other business decisions,
	is provided by the <dfn export lt="BoD | Board | Board of Directors | W3C Board of Directors">W3C Board of Directors</dfn>,
	rather than managed directly by the Process.

	Note: See the [[BYLAWS inline|W3C Bylaws]] for more details
	on the [=Board=] and overall governance of W3C.

<h2 id=groups>
Groups and Participation</h2>

	For the purposes of this Process, a <dfn lt="W3C Group" local-lt="group">W3C Group</dfn> is one of W3C’s
	<a href="#wgparticipant">Working Groups</a>,
	<a href="#igparticipant">Interest Groups</a>,
	<a href="#AC">Advisory Committee</a>,
	<a href="#ABParticipation">Advisory Board</a>,
	or <a href="#tag-participation">TAG</a>,
	and a <dfn>participant</dfn> is a member of such a group.

<h3 id="Policies">
Policies for Participation in W3C Groups</h3>

<h4 id="ParticipationCriteria">
Individual Participation Criteria</h4>

<h5 id="discipline">
Expectations and Discipline</h5>

	There are three qualities an individual is expected to demonstrate in order to participate in W3C:

	<ol>
		<li>
			Technical competence in one's role;

		<li>
			The ability to act fairly;

		<li>
			Social competence in one's role.
	</ol>

	[=Advisory Committee representatives=] who nominate individuals from their organization for participation in W3C activities
	are responsible for assessing and attesting to the qualities of those nominees.

	<p>Participants in any W3C activity <em class="rfc2119">must</em> abide
	by the terms and spirit of the <a href="https://www.w3.org/Consortium/cepc/">W3C Code of Ethics and Professional Conduct</a> [[!CEPC]]
	and the participation requirements described in
	“Disclosure”
	in the W3C Patent Policy [[!PATENT-POLICY]].

	The [=CEO=] <em class="rfc2119">may</em> take disciplinary action,
	including suspending or removing for cause
	a participant in any group (including the [=AB=] and [=TAG=])
	if serious and/or repeated violations,
	such as failure to meet the requirements on individual behavior of
	(a) this process
	and in particular the CEPC, or
	(b) the membership agreement, or
	(c) applicable laws,
	occur.
	Refer to the <a href="https://www.w3.org/Guide/process/banning.html">Guidelines to suspend or remove participants from groups</a>.

<h5 id="coi">
Conflict of Interest Policy</h5>

	Individuals participating materially in W3C work <em class="rfc2119">must</em> disclose significant relationships
	when those relationships might reasonably be perceived as creating a conflict of interest with the individual's role at W3C.
	These disclosures <em class="rfc2119">must</em> be kept up-to-date
	as the individual's affiliations change and W3C membership evolves
	(since, for example, the individual might have a relationship with an organization that joins or leaves W3C).
	Each section in this document that describes a W3C group
	provides more detail about the disclosure mechanisms for that group.

	The ability of an individual to fulfill a role within a group
	without risking a conflict of interest depends on the individual's affiliations.
	When these affiliations change,
	the individual's assignment to the role <em class="rfc2119">must</em> be evaluated.
	The role <em class="rfc2119">may</em> be reassigned according to the appropriate process.
	For instance,
	the [=Team=] <em class="rfc2119">may</em> appoint a new group [=Chair=]
	when the current Chair changes affiliations
	(e.g., if there is a risk of conflict of interest,
	or if there is risk that the Chair's new employer will be over-represented within a W3C activity).

	The following are some scenarios where disclosure is appropriate:

	<ul>
		<li>
			Paid consulting for an organization whose activity is relevant to W3C,
			or any consulting compensated with equity
			(shares of stock, stock options, or other forms of corporate equity).

		<li>
			A decision-making role/responsibility
			(such as participating on a Board)
			in other organizations relevant to W3C.

		<li>
			A position on a publicly visible advisory body,
			even if no decision-making authority is involved.
	</ul>

	Individuals seeking assistance on these matters <em class="rfc2119">should</em> contact the [=Team=].

	[=Team=] members are subject to the <a href="https://www.w3.org/2000/09/06-conflictpolicy">W3C Team conflict of interest policy</a> [[!CONFLICT-POLICY]].

<h5 id="member-rep">
Individuals Representing a Member Organization</h5>

	Generally, individuals representing a Member in an official capacity within W3C
	are employees of the Member organization.
	However, an [=Advisory Committee representative=] <em class="rfc2119">may</em> designate a non-employee
	to represent the Member.
	Non-employee Member representatives <em class="rfc2119">must</em> disclose
	relevant affiliations to the Team and to any group in which the individual participates.

	In exceptional circumstances
	(e.g., situations that might jeopardize the progress of a group or create a <a href="#coi">conflict of interest</a>),
	the [=CEO=] <em class="rfc2119">may</em> decline
	to allow an individual designated by an Advisory Committee representative to participate in a group.

	A group charter <em class="rfc2119">may</em> limit
	the number of individuals representing a W3C Member
	(or group of <a href="#MemberRelated">related Members</a>).

<h4 id="GeneralMeetings">
Meetings</h4>

	The requirements in this section apply to the official meetings of any [=W3C group=].

	<p>W3C distinguishes two types of meetings:</p>

	<ol>
		<li>
			A <dfn id="ftf-meeting">face-to-face meeting</dfn> is one
			where most of the attendees are expected to participate in the same physical location.

		<li>
			A <dfn id="distributed-meeting">distributed meeting</dfn> is one
			where most of the attendees are expected to participate from remote locations
			(e.g., by telephone, video conferencing, or <abbr title="Internet Relay Chat">IRC</abbr>).
	</ol>

	A [=Chair=] <em class="rfc2119">may</em> invite an individual with a particular expertise
	to attend a meeting on an exceptional basis.
	This person is a meeting guest,
	not a group [=participant=].
	Meeting guests do not have <a href="#Votes">voting rights</a>.
	It is the responsibility of the Chair to ensure
	that all meeting guests respect the chartered <a href="#confidentiality-levels">level of confidentiality</a>
	and other group requirements.

<h5 id="meeting-schedules">
Meeting Scheduling and Announcements</h5>

	Meeting announcements <em class="rfc2119">should</em> be sent to all appropriate group mailing lists,
	i.e. those most relevant to the anticipated meeting participants.

	The following table lists <em class="rfc2119">recommendations</em> for organizing a meeting:

	<table class="data">
	<thead>
		<tr>
			<td>
			<th scope=col>Face-to-face meetings
			<th scope=col>Distributed meetings

	<tbody>
		<tr>
			<th scope=row>Meeting announcement (before)
			<td><span class="time-interval">eight weeks<sup>*</sup></span>
			<td><span class="time-interval">one week<sup>*</sup></span>
		<tr>
			<th scope=row>Agenda available (before)
			<td><span class="time-interval">two weeks</span>
			<td><span class="time-interval">24 hours</span> (or longer if a meeting is scheduled after a weekend or holiday)
		<tr>
			<th scope=row>Participation confirmed (before)
			<td><span class="time-interval">three days</span>
			<td><span class="time-interval">24 hours</span>
		<tr>
			<th scope=row>Action items available (after)
			<td><span class="time-interval">three days</span>
			<td><span class="time-interval">24 hours</span>
		<tr>
			<th scope=row>[=Minutes=] available (after)
			<td><span class="time-interval">two weeks</span>
			<td><span class="time-interval">48 hours</span>
	</table>

	<sup>*</sup> To allow proper planning (e.g., travel arrangements),
	the Chair is responsible for giving sufficient advance notice
	about the date and location of a meeting.
	Shorter notice for a meeting is allowed
	provided that there are no objections from group participants.

<h5 id="meeting-minutes">
Meeting Minutes</h5>

	Groups <em class=rfc2119>should</em> take and retain <dfn>minutes</dfn> of their meetings,
	and <em class="rfc2119">must</em> record
	any official [=group decisions=] made during the meeting discussions.
	Details of the discussion leading to such decisions are not required,
	provided that the rationale for the [=group decision=] is nonetheless clear.

<h5 id="meeting-recording">
Meeting Recordings and Transcripts</h5>

	No-one may take an audio or video recording of a meeting,
	or retain an automated transcript,
	unless the intent is announced at the start of the meeting,
	and no-one participating in the recorded portion of the meeting withholds consent.
	If consent is withheld by anyone, recording/retention <em class=rfc2119>must</em> not occur.
	The announcement <em class=rfc2119>must</em> cover:
	(a) who will have access to the recording or transcript and
	(b) the purpose/use of it and
	(c) how it will be retained (e.g. privately, in a cloud service) and for how long.

<h4 id="tooling">
Tooling and Archiving for Discussions and Publications</h4>

	For [=W3C Groups=] operating under this Process,
	a core operating principle is to allow access across disabilities,
	across country borders,
	and across time.
	Thus in order to allow all would-be participants to effectively participate,
	to allow future participants and observers to understand the rationale and origins of current decisions,
	and to guarantee long-lived access to its publications,
	W3C requires that:

	<ul>
		<li id=report-stability>
			All reports, publications, or other deliverables
			produced by the group for public consumption
			(i.e. intended for use or reference outside its own membership)
			<em class=rfc2119>should</em> be published and promoted at a W3C-controlled URL,
			and backed up by W3C systems
			such that if the underlying service is discontinued,
			W3C can continue to serve such content without breaking incoming links
			or other key functionality.

		<li id=report-accessibility>
			All reports, publications, or other deliverables
			produced by the group for public consumption
			<em class=rfc2119>should</em> follow best practices for internationalization
			and for accessibility to people with disabilities.
			Network access to W3C-controlled domains may be assumed.

		<li id=discussion-archiving>
			Official meeting minutes and other records of decisions made <em class=rfc2119>must</em>
			be archived by W3C for future reference;
			and other persistent text-based discussions
			sponsored by the group,
			pertaining to their work
			and intended to be referenceable by all group members
			<em class=rfc2119>should</em> be.
			This includes discussions conducted over email lists
			or in issue-tracking services
			or any equivalent fora.
			Materials referenced from discussions
			and necessary to understand them
			should be available at a stable URL,
			at a level of confidentiality no stricter than the discussion minutes.

			Note: The lack, or loss, of such archives does not by itself
			invalidate an otherwise-valid decision.

		<li id=tool-accessibility>
			Any tooling used by the group
			for producing its documentation and deliverables
			or for official group discussions
			<em class=rfc2119>should</em> be usable
			(without additional cost)
			by all who wish to participate,
			including people with disabilities,
			to allow their effective participation.

			Note: If a new participant joins who cannot use the tool,
			this can require the [=Working Group=] to change its tooling
			or operate some workaround.

		<li id=where-is-your-stuff>
			All tools and archives used by the group
			for its discussions and recordkeeping
			<em class=rfc2119>should</em> be documented
			such that new participants and observers
			can easily find the group’s tools and records.

	</ul>

	The [=Team=] is responsible for ensuring adherence to these rules
	and for bringing any group not in compliance into compliance.

<h4 id="resignation">
Resignation from a Group</h4>

	A W3C Member or Invited Expert <em class="rfc2119">may</em> resign from a group.
	On written notification from an Advisory Committee representative
	or Invited Expert
	to the [=Team=],
	the Member and their representatives
	or the Invited Expert
	will be deemed to have resigned from the relevant group.
	The [=Team=] <em class="rfc2119">must</em> record the notification.
	See “Exclusion and Resignation from the Working Group” in the W3C Patent Policy [[PATENT-POLICY]]
	for information about obligations remaining after resignation from certain groups.

<h3 id="AC">
The Advisory Committee (AC)</h3>

<h4 id=ac-role>
Role of the Advisory Committee</h4>

	<p id=ReviewAppeal>
	The <dfn export lt="Advisory Committee|AC">Advisory Committee</dfn> represents
	the [=Members=] of W3C at large.
	It is responsible for:

	<ul>
		<li>
			reviewing plans for W3C at each <a href="#ACMeetings">Advisory Committee meeting</a>.

		<li>
			<a href="#ACReview">reviewing formal proposals</a> of W3C:
			<a href="#CharterReview">Charter Proposals</a>,
			<a href="#RecsPR">Proposed Recommendations</a>,
			and <a href="#GAProcess">Proposed Process Documents</a>.

		<li>
			electing the <a href="#AB">Advisory Board</a> participants other than the Advisory Board Chair.

		<li>
			electing a majority (6) of the participants on the <a href="#TAG">Technical Architecture Group</a>.
	</ul>

	[=Advisory Committee representatives=] <em class="rfc2119">may</em> initiate
	an <a href="#ACAppeal">Advisory Committee Appeal</a>
	of a [=W3C decision=]
	or [=Team=]'s decision.

	See also the additional roles of [=Advisory Committee representatives=]
	described in the W3C Patent Policy [[PATENT-POLICY]].

<h4 id=ac-participation>
Participation in the Advisory Committee</h4>

	The [=Advisory Committee=]
	is composed of one <dfn export lt="Advisory Committee representative| AC representative">representative</dfn>
	from each Member organization
	(refer to the [=Member-only=] list
	of <a href="https://www.w3.org/Member/ACList">current Advisory Committee representatives</a>. [[CURRENT-AC]])

	When an organization joins W3C
	(see “<a href="https://www.w3.org/Consortium/join">How to Join W3C</a>” [[JOIN]]),
	it <em class="rfc2119">must</em> name its Advisory Committee representative as part of the Membership Agreement.
	The <a href="https://www.w3.org/Member/Intro">New Member Orientation</a> [[INTRO]]
	explains how to subscribe or unsubscribe to Advisory Committee mailing lists,
	provides information about <a href="#ACMeetings">Advisory Committee Meetings</a>,
	explains how to name a new [=Advisory Committee representative=],
	and more.
	[=Advisory Committee representatives=] <em class="rfc2119">must</em> follow the <a href="#coi">conflict of interest policy</a>
	by disclosing information according to the mechanisms described in the New Member Orientation.

	The AC representative may delegate any of their rights and responsibilities
	to an <dfn export lt="alternate AC representative | alternate Advisory Committee representative | alt AC rep">alternate</dfn>
	(except the ability to designate an alternate).

<h4 id="ACCommunication">
Advisory Committee Mailing Lists</h4>

	The [=Team=] <em class="rfc2119">must</em> provide two mailing lists for use by the [=Advisory Committee=]:

	<ol>
		<li>
			One for official announcements (e.g., those required by this document) from the [=Team=] to the [=Advisory Committee=].
			This list is read-only for Advisory Committee representatives.

		<li>
			One for discussion among [=Advisory Committee representatives=].
			Though this list is primarily for Advisory Committee representatives,
			the [=Team=] <em class="rfc2119">must</em> monitor discussion
			and <em class="rfc2119">should</em> participate in discussion when appropriate.
			Ongoing detailed discussions <em class="rfc2119">should</em> be moved to other appropriate lists
			(new or existing, such as a mailing list created for a <a href="#GAEvents">Workshop</a>).
	</ol>

	An [=Advisory Committee representative=] <em class="rfc2119">may</em> request
	that additional individuals from their organization be subscribed to these lists.
	Failure to contain distribution internally
	<em class="rfc2119">may</em> result in suspension of additional email addresses,
	at the discretion of the Team.

<h4 id="ACMeetings">
Advisory Committee Meetings</h4>

	The [=Team=] organizes a <a href="#ftf-meeting">face-to-face meeting</a> for the [=Advisory Committee=]
	<span class="time-interval">twice a year</span>.
	The [=Team=] appoints the Chair of these meetings (generally the CEO).
	At each Advisory Committee meeting,
	the Team <em class="rfc2119">should</em> provide an update to the Advisory Committee about:

	<dl>
		<dt><em>Resources</em>
		<dd>
			<ul>
				<li>
					The number of W3C Members at each level.

				<li>
					An overview of the financial status of W3C.
			</ul>

		<dt><em>Allocations</em>
		<dd>
			<ul>
				<li>
					The allocation of the annual budget, including size of the Team and their approximate deployment.

				<li>
					A list of all activities (including but not limited to Working and Interest Groups)
					and brief status statement about each,
					in particular those started or terminated since the previous Advisory Committee meeting.

				<li>
					The allocation of resources to pursuing <a href="#Liaisons">liaisons</a> with other organizations.
			</ul>
		</dd>
	</dl>

	Each Member organization <em class="rfc2119">should</em> send one <a href="#member-rep">representative</a>
	to each Advisory Committee Meeting.
	In exceptional circumstances
	(e.g., during a period of transition between representatives from an organization),
	the meeting Chair <em class="rfc2119">may</em> allow a Member organization to send two representatives to a meeting.

	The [=Team=] <em class="rfc2119">must</em> announce the date and location of each Advisory Committee meeting
	no later than at the end of the previous meeting;
	<span class="time-interval">one year's</span> notice is preferred.
	The Team <em class="rfc2119">must</em> announce the region of each Advisory Committee meeting
	at least <span class="time-interval">one year</span> in advance.

	More information about <a href="https://www.w3.org/Member/Meeting/">Advisory Committee meetings</a> [[AC-MEETING]]
	is available at the Member website.

<h3 id=elected-groups>
Elected Groups: The AB and the TAG</h3>

	The W3C Process defines two types of <dfn id=elected-group export>elected groups</dfn>:
	the [=Advisory Board=] (AB) and
	the [=Technical Architecture Group=] (TAG),
	both elected by the [=Advisory Committee=].

<h4 id="AB">
Advisory Board (AB)</h4>

<h5 id=ab-role>
Role of the Advisory Board</h5>

	The <dfn export lt="Advisory Board|AB">Advisory Board</dfn> provides ongoing guidance to the Team
	on issues of strategy,
	management,
	legal matters,
	process,
	and conflict resolution.
	The Advisory Board also serves the Members
	by tracking issues raised between Advisory Committee meetings,
	soliciting Member comments on such issues,
	and proposing actions to resolve these issues.
	The Advisory Board manages the <a href="#GAProcess">evolution of the Process Document</a>.
	As part of a [=W3C Council=],
	members of the [=Advisory Board=] hear and adjudicate on <a href="#SubmissionNo">Submission Appeals</a>
	and [=Formal Objections=].

	The [=Advisory Board=] is distinct from the [=Board of Directors=]
	and has no decision-making authority within W3C;
	its role is strictly advisory.

	Note: While the [=AB=] as such does not have decision-making authority,
	its members do when sitting as part of a [=W3C Council=].

	Details about the Advisory Board
	(e.g., the list of Advisory Board participants,
	mailing list information, and summaries of Advisory Board meetings)
	are available at the <a href="https://www.w3.org/2002/ab/">Advisory Board home page</a> [[AB-HP]].

<h5 id="ABParticipation">
Composition of the Advisory Board</h5>

	The [=Advisory Board=] consists of nine to eleven elected participants and one Chair
	(who <em class=rfc2119>may</em> be one of the elected participants).
	With the input of the [=AB=],
	the [=Team=] appoints the Chair,
	who <em class=rfc2119>should</em> choose a co-chair among the elected participants.
	The Chair(s) are subject to ratification by secret ballot
	by two thirds of the AB upon appointment.
	Chair selection <em class=rfc2119>must</em> be run
	at least at the start of each regular term,
	as well as when a majority of the participants request it;
	and <em class=rfc2119>may</em> be run at other times when initiated by the current chairs or the Team,
	for example if a chair steps down or if a minority of the participants make such a request.

	The team also appoints a <a href="https://www.w3.org/Guide/teamcontact/role.html">Team Contact</a>,
	as described in <a href="#ReqsAllGroups"></a>.
	The CEO and Team Contact have a standing invitation
	to all regular Advisory Board sessions.

	The nine to eleven [=Advisory Board=] participants are elected by the W3C [=Advisory Committee=]
	following the <a href="#AB-TAG-elections">AB/TAG nomination and election process</a>.

	The terms of elected Advisory Board participants are for <span class="time-interval">two years</span>.
	Terms are staggered so that each year,
	either five or six terms expire.
	If an individual is elected to fill an incomplete term,
	that individual's term ends at the normal expiration date of that term.
	Regular Advisory Board terms begin on 1 July and end on 30 June.</p>

<h5 id=ab-comm>
Communications of the Advisory Board</h5>

	The [=Team=] <em class="rfc2119">must</em> make available a mailing list,
	confidential to the Advisory Board and Team,
	for the Advisory Board to use for its communication.

	The [=Advisory Board=] <em class="rfc2119">should</em> send a summary of each of its meetings
	to the Advisory Committee and other group Chairs.
	The Advisory Board <em class="rfc2119">should</em> also report on its activities
	at each <a href="#ACMeetings">Advisory Committee meeting</a>.

<h5 id=ab-bod-liaison>
Liaisons between the Advisory Board and the Board of Directors</h5>

	To ensure good communication between the [=AB=] and the [=Board of Directors=]
	and facilitate operational and management consistency,
	the [=AB=] <em class=rfc2119>may</em> appoint up to two of its participants as liaisons to the [=Board=].
	Such appointees are expected to attend and participate in [=Board=] meetings
	and access [=Board=] materials
	as Non-voting Observers. [[BYLAWS]]
	They do not form part of the [=Board=]'s decision-making body,
	and may be excluded from such participation
	in accordance with applicable Board procedures.

	The [=Advisory Board=] <em class=rfc2119>should</em> reevaluate
	who is assigned to this role
	at least at the beginning of each term,
	and <em class=rfc2119>may</em> swap its appointees more frequently
	as they deem appropriate.

<h4 id="TAG">
Technical Architecture Group (TAG)</h4>

<h5 id=tag-role>
Role of the Technical Architecture Group</h5>

	The mission of the <dfn export lt="Technical Architecture Group|TAG">TAG</dfn> is stewardship of the Web architecture.
	There are three aspects to this mission:

	<ol>
		<li>
			to document and build consensus around principles of Web architecture
			and to interpret and clarify these principles when necessary;

		<li>
			to resolve issues involving general Web architecture brought to the TAG;

		<li>
			to help coordinate cross-technology architecture developments inside and outside W3C.
	</ol>

	As part of a [=W3C Council=],
	the members of the [=TAG=] hear and adjudicate on <a href="#SubmissionNo">Submission Appeals</a>
	and [=Formal Objections=].

	The [=TAG=]'s scope is limited to technical issues about Web architecture.
	The TAG <em class="rfc2119">should not</em> consider
	administrative,
	process,
	or organizational policy issues of W3C,
	which are generally addressed by
	the W3C Advisory Committee,
	Advisory Board,
	and Team.
	Please refer to the <a href="https://www.w3.org/2004/10/27-tag-charter.html">TAG charter</a> [[TAG-CHARTER]]
	for more information about the background and scope of the TAG,
	and the expected qualifications of TAG participants.

	When the [=TAG=] votes to resolve an issue,
	each TAG participant
	(whether appointed, elected, or the Chair)
	has one vote;
	see also the section on <a href="https://www.w3.org/2004/10/27-tag-charter.html#Voting">voting in the TAG charter</a> [[TAG-CHARTER]]
	and the general section on <a href="#Votes">votes</a> in this Process Document.

	Details about the [=TAG=]
	(e.g., the list of TAG participants, mailing list information, and summaries of TAG meetings)
	are available at the <a href="https://www.w3.org/2001/tag/">TAG home page</a> [[TAG-HP]].

<h5 id="tag-participation">
Composition of the Technical Architecture Group</h5>

	The [=TAG=] consists of:

	<ul>
		<li>
			Tim Berners-Lee, who is a life member;

		<li>
			Three participants [[#TAG-appointments|appointed by the Team]];

		<li>
			Six participants elected by the [=Advisory Committee=]
			following the <a href="#AB-TAG-elections">AB/TAG nomination and election process</a>.
	</ul>

	Participants in the [=TAG=] choose by consensus their Chair or co-Chairs;
	in the absence of consensus, the [=Team=] appoints the Chair or co-Chairs of the TAG.
	The Chair or co-Chairs <em class="rfc2119">must</em> be selected from the participants of the TAG.
	Chair selection <em class=rfc2119>must</em> be run
	at least at the start of each regular term,
	as well as when a majority of the participants request it;
	and <em class=rfc2119>may</em> be run at other times when initiated by the current chairs or the Team,
	for example if a chair steps down or if a minority of the participants make such a request.

	The [=Team=] also appoints a <a href="https://www.w3.org/Guide/teamcontact/role.html">Team Contact</a> [[TEAM-CONTACT]] for the TAG,
	as described in <a href="#ReqsAllGroups"></a>.

	The terms of TAG participants last for <span class="time-interval">two years</span>.
	Terms are staggered so that three elected terms
	and either one or two appointed terms expire each year.
	If an individual is appointed or elected to fill an incomplete term,
	that individual's term ends at the normal expiration date of that term.
	Regular TAG terms begin on 1 February and end on 31 January.

<h5 id=tag-comm>
Communications of the Technical Architecture Group</h5>

	The [=Team=] <em class="rfc2119">must</em> make available two mailing lists for the TAG:

	<ul>
		<li>
			a public discussion (not just input) list for issues of Web architecture.
			The [=TAG=] will conduct its public business on this list.

		<li>
			a <a href="#Member-only">Member-only</a> list for discussions within the TAG
			and for requests to the TAG that,
			for whatever reason, cannot be made on the public list.
	</ul>

	The [=TAG=] <em class="rfc2119">may</em> also request the creation of additional topic-specific, public mailing lists.
	For some TAG discussions (e.g.,  a <a href="#SubmissionNo">Submission Appeal</a>),
	the TAG <em class="rfc2119">may</em> use a list that will be <a href="#Member-only">Member-only</a>.

	The [=TAG=] <em class="rfc2119">should</em> send a summary of each of its <a href="#GeneralMeetings">meetings</a>
	to the Advisory Committee and other group Chairs.
	The [=TAG=] <em class="rfc2119">should</em> also report on its activities at each <a href="#ACMeetings">Advisory Committee meeting</a>.

<h4 id="AB-TAG-participation">
Participation in Elected Groups</h4>

<h5 id=elected-expectations>
Expectations for Elected Groups Participants</h5>

	[=Advisory Board=] and [=TAG=] participants have a special role within W3C:
	they are elected by the Membership and appointed by the [=Team=]
	with the expectation that they will use their best judgment
	to find the best solutions for the Web,
	not just for any particular network,
	technology,
	vendor,
	or user.
	Advisory Board and TAG participants are expected to participate regularly and fully.
	Advisory Board and TAG participants <em class="rfc2119">should</em> attend <a href="#ACMeetings">Advisory Committee meetings</a>.

	Individuals elected or appointed to the Advisory Board or TAG act in their personal capacity,
	to serve the needs of the W3C membership as a whole,
	and the Web community.
	Whether they are Member representatives or Invited Experts,
	their activities in those roles are separate and distinct from their activities on the Advisory Board or TAG.

	An individual participates on the Advisory Board or TAG
	from the moment the individual's term begins until the seat is <a href="#AB-TAG-vacated">vacated</a>
	(e.g. because the term ends).
	Although Advisory Board and TAG participants do not advocate for the commercial interests of their employers,
	their participation does carry the responsibilities associated with Member representation,
	Invited Expert status,
	or Team representation
	(as described in the section on the <a href="#AB-TAG-elections">AB/TAG nomination and election process</a>).

	Participation in the TAG or AB is afforded to the specific individuals elected or appointed to those positions,
	and a participant's seat <em class="rfc2119">must not</em> be delegated to any other person.

<h5 id="AB-TAG-constraints">
Elected Groups Participation Constraints</h5>

	Given the few seats available on the [=Advisory Board=] and the [=TAG=],
	and in order to ensure that the diversity of W3C Members is represented:

	<ul>
		<li>
			Two participants with the same [=primary affiliation=] per <a href="#AB-TAG-elections"></a>
			must not both occupy elected seats on the TAG
			except when this is caused by a change of affiliation of an existing participant.
			At the completion of the next regularly scheduled election for the TAG,
			the organization <em class="rfc2119">must</em> have returned to having at most one seat.

		<li>
			Two participants with the same [=primary affiliation=] per <a href="#AB-TAG-elections"></a>
			must not both occupy elected seats on the AB.
			If, for whatever reason, these constraints are not satisfied
			(e.g., because an [=AB=] participant changes jobs),
			one participant <em class="rfc2119">must</em> cease [=AB=] participation
			until the situation has been resolved.
			If after <span class="time-interval">30 days</span> the situation has not been resolved,
			the Chair will apply
			the <a href="#random">verifiable random selection procedure</a> described below
			to choose one person for continued participation and declare the other seat(s) vacant.
		<li>
			An individual <em class="rfc2119">must not</em> participate on both the TAG and the AB.
	</ul>

<h5 id="AB-TAG-elections">
Advisory Board and Technical Architecture Group Elections</h5>

	The [=Advisory Board=] and a portion of the [=Technical Architecture Group=] are elected by the [=Advisory Committee=],
	using a Single Transferable Vote system.
	An election begins when the Team sends a Call for Nominations to the Advisory Committee.
	Any Call for Nominations specifies the minimum and maximum number of available seats,
	the deadline for nominations,
	details about the specific vote tabulation system selected by the Team for the election,
	and operational information such as how to nominate a candidate.
	The [=Team=] <em class="rfc2119">may</em> modify the tabulation system after the Call for Nominations
	but <em class="rfc2119">must</em> stabilize it no later than the Call for Votes.
	The [=Team=] announces appointments
	after the results of the election are known,
	and before the start of the term,
	as described in [[#TAG-appointments]].

	In the case of regularly scheduled elections of the [=TAG=],
	the minimum and maximum number of available seats are the same:
	the 3 seats of the terms expiring that year,
	plus the number of other seats that are vacant or will be vacant by the time the newly elected members take their seats.

	In the case of regularly scheduled elections of the [=AB=],
	the minimum and maximum number of available seats differ:
	The maximum number is the 5 or 6 seats of the terms expiring that year,
	plus the number of other seats that are vacant or will be vacant by the time the newly elected members take their seats;
	the minimum number is such that when added to the occupied seats from the prior year,
	the minimum size of the AB (9) is reached.

	Each Member (or group of [=related Members=])
	<em class="rfc2119">may</em> nominate one individual.
	A nomination <em class="rfc2119">must</em> be made with the consent of the nominee.
	In order for an individual to be nominated as a Member representative,
	the individual <em class="rfc2119">must</em> qualify for <a href="#member-rep">Member representation</a>
	and the Member's [=Advisory Committee representative=] <em class="rfc2119">must</em> include in the nomination
	the (same) <a href="#member-rep-info">information required for a Member representative in a Working Group</a>.
	In order for an individual to be nominated as an Invited Expert,
	the individual <em class="rfc2119">must</em> provide
	the (same) <a href="#inv-expert-info">information required for an Invited Expert in a Working Group</a>
	and the nominating [=Advisory Committee representative=] <em class="rfc2119">must</em> include that information in the nomination.
	In order for an individual to be nominated as a [=Team=] representative,
	the nominating [=Advisory Committee representative=]
	<em class="rfc2119">must</em> first secure approval from [=Team=] management.
	A nominee is <em class="rfc2119">not required</em> to be an employee of a Member organization,
	and <em class="rfc2119">may</em> be a <a href="#fellows">W3C Fellow</a>.
	The nomination form <em class="rfc2119">must</em> ask for the nominee's [=primary affiliation=],
	and this will be reported on the ballot.
	For most nominees,
	the <dfn>primary affiliation</dfn> is their employer and will match their affiliation in the W3C database.
	For contractors and invited experts,
	this will normally be their contracting company
	or their invited expert status;
	in some cases
	(e.g. where a consultant is consulting for only one organization)
	this <em class="rfc2119">may</em> be the organization for whom the nominee is consulting.
	A <a href="#AB-TAG-constraints">change of affiliation</a> is defined
	such that this field would carry a different answer
	if the nominee were to be re-nominated
	(therefore,
	terminating employment,
	or accepting new employment,
	are changes of affiliation).
	(Other formal relationships such as other contracts should be disclosed as potential conflicts of interest.)
	Each nomination <em class="rfc2119">should</em> include
	a few informative paragraphs about the nominee.

	If, after the deadline for nominations, the number of nominees is:

	<ul>
		<li>
			Greater than or equal to the minimum number of available seats
			and less than or equal to the maximum number of available seats,
			those nominees are thereby elected.
			This situation constitutes a tie for the purpose of assigning <a href="#short-term">incomplete terms</a>.
			Furthermore, if the number is less than the maximum number of available seats,
			the longest terms are filled first.

		<li>
			Less than the minimum number of available seats,
			Calls for Nominations are issued until a sufficient number of people have been nominated.
			Those already nominated do not need to be renominated after a renewed call.

		<li>
			Greater than the maximum number of available seats,
			the [=Team=] issues a Call for Votes
			that includes the names of all candidates,
			the (maximum) number of available seats,
			the deadline for votes,
			details about the vote tabulation system selected by the Team for the election,
			and operational information.
	</ul>

	When there is a vote,
	each Member
	(or group of [=related Members=])
	<em class="rfc2119">may</em> submit one ballot that ranks candidates in the Member's preferred order.
	Once the deadline for votes has passed,
	the [=Team=] announces the results to the [=Advisory Committee=].
	In case of a tie the <a href="#random">verifiable random selection procedure</a> described below
	will be used to fill the available seats.

	<p id="short-term">The shortest incomplete term is assigned to the elected candidate ranked lowest by the tabulation of votes,
	the next shortest term to the next-lowest ranked elected candidate,
	and so on.
	In the case of a tie among those eligible for a incomplete term,
	the <a href="#random">verifiable random selection procedure</a> described below
	will be used to assign the incomplete term.

	Refer to <a href="https://www.w3.org/2002/10/election-howto">How to Organize an Advisory Board or TAG election</a> [[ELECTION-HOWTO]]
	for more details.

<h5 id="TAG-appointments">
Technical Architecture Group Appointments</h5>

	The [=Team=] is responsible for appointing
	3 of the participants to the [=Technical Architecture Group=].
	This mechanism complements the election process.
	The [=Team=] <em class=rfc2119>should</em> use its appointments to support
	a diverse and well-balanced [=TAG=],
	including diversity of technical background, knowledge, and skill sets.

	The [=Team=] <em class=rfc2119>should</em> actively seek
	candidates for appointment to the TAG,
	and <em class=rfc2119>must</em> make available to
	the W3C community at large
	a means to propose candidates for consideration,
	explicitly soliciting input from at least
	current and incoming [=TAG=] members, the [=Advisory Committee=], and [=Working Group=] [=Chairs=].

	The constraints for appointment to the [=TAG=] are
	the same as for elected participants
	(see [[#AB-TAG-constraints]] and [[#AB-TAG-elections]]),
	with the additional constraint that
	a person <em class=rfc2119>must not</em> be appointed
	for more than two <em>consecutive</em> terms.
	(Partial terms used to fill a vacated seat do not count towards this limit.)

	Note: Individuals who have reached the limit of two consecutive appointed terms
	<em class=rfc2119>may</em> freely run for election
	if they wish to continue serving on the [=TAG=].

	The [=Team=]'s choice of appointee(s)
	is subject to ratification by secret ballot
	by both the [=AB=] and the [=TAG=],
	each requiring a two-thirds approval.
	In the case of regularly scheduled elections,
	the [=TAG=] participants in this ratification are
	its members for the upcoming term.

	For regularly scheduled elections,
	selection begins once the results of the elections are known,
	and the [=Team=] <em class=rfc2119>should</em> announce the ratified appointment(s)
	no later than the start of the regularly scheduled term.
	When an appointed seat is vacated outside of a regularly scheduled election,
	the [=Team=] <em class=rfc2119>should</em> seek to appoint a replacement
	unless a regular Call for Nominations is scheduled within 2 months,
	and it <em class=rfc2119>must</em> announce the ratified appointment
	no later than the Call for Nominations of the next scheduled election.

<h5 id="random">
Verifiable Random Selection Procedure</h5>

	When it is necessary to use a verifiable random selection process
	(e.g., in an [=AB=] or [=TAG=] election,
	to “draw straws” in case of a tie
	or to fill a incomplete term),
	W3C uses the random and verifiable procedure defined in <a href="https://www.ietf.org/rfc/rfc3797.txt">RFC 3797</a> [[!RFC3797]].
	The procedure orders an input list of names
	(listed in alphabetical order by family name unless otherwise specified)
	into a “result order”.

	W3C applies this procedure as follows:</p>

	<ol>
		<li>
			When N people have tied for M (less than N) seats.
			In this case, only the names of the N individuals who tied
			are provided as input to the procedure.
			The M seats are assigned in result order.

		<li>
			After all elected individuals have been identified,
			when N people are eligible for M (less than N) incomplete terms.
			In this case, only the names of those N individuals are provided as input to the procedure.
			The incomplete terms are assigned in result order.
	</ol>

<h5 id="AB-TAG-vacated">
Elected Groups Vacated Seats</h5>

	An [=Advisory Board=] or [=TAG=] participant's seat is vacated when:

	<ul>
		<li>
			the participant resigns, or

		<li>
			an Advisory Board or TAG participant changes affiliations
			such that the <a href="#AB-TAG-constraints">Advisory Board and TAG participation constraints</a> are no longer met,
			or

		<li>
			the [=CEO=] dismisses the participant
			for failing to meet the criteria in section <a href="#ParticipationCriteria"></a>,
			or

		<li>
			their term ends.
	</ul>

	If a participant changes affiliation,
	but the <a href="#AB-TAG-constraints">participation constraints</a> are met,
	that participant's seat becomes vacant at the next regularly scheduled election for that group.

	Vacated seats are filled according to this schedule:

	<ul>
		<li>
			When an appointed [=TAG=] seat is vacated,
			the [=Team=] [[#TAG-appointments|appoints]] a replacement.

		<li>
			When an elected seat on either the [=AB=] or [=TAG=] is vacated,
			the seat is filled at the next regularly scheduled election for the group
			unless the group Chair requests that W3C hold an election before then
			(for instance, due to the group's workload).

			<ul>
				<li>
					The group Chair <em class="rfc2119">should not</em> request such an election
					if the next regularly scheduled election is fewer than three months away.

				<li>
					The group Chair <em class="rfc2119">may</em> request an election,
					and the election may begin, as soon as a current member gives notice of a resignation,
					including a resignation effective as of a given date in the future.
			</ul>

			When such an election is held,
			the minimum number of available seats is such that
			when added to the number of continuing participants,
			the minimum total number of elected seats is met
			(6 for the [=TAG=], 9 for the [=AB=]);
			and the maximum number corresponds to all unoccupied seats.
			Except for the number of available seats and the length of the terms,
			the <a href="#AB-TAG-elections">usual rules for Advisory Board and Technical Architecture Group Elections</a> apply.
	</ul>

<h3 id="GAGeneral" oldids="ChapterGroups, WG-and-IG">
Chartered Groups: Working Groups and Interest Groups</h3>

	<p id="GAGroups">This document defines two types of <dfn id=chartered-group export>chartered groups</dfn>:

	<dl>
		<dt>
			<dfn export id="GroupsWG"><a href="#GroupsWG">Working Groups</a></dfn>.
		<dd>
			Working Groups typically produce deliverables
			(e.g., <a href="#rec-advance">Recommendation Track technical reports</a>,
			software,
			test suites,
			and reviews of the deliverables of other groups)
			as defined in their <a href=#WGCharter>charter</a>.

			Working Groups have additional participation requirements
			described in the W3C Patent Policy [[!PATENT-POLICY]],
			see particularly the “<a href="https://www.w3.org/Consortium/Patent-Policy/#sec-Obligations">Licensing Obligations of Working Group Participants</a>”
			and the patent claim exclusion process
			in “<a href="https://www.w3.org/Consortium/Patent-Policy/#sec-Exclusion">Exclusion From W3C RF Licensing Requirements</a>”.


		<dt>
			<dfn export id="GroupsIG"><a href="#GroupsIG">Interest Groups</a></dfn>.
		<dd>
			The primary goal of an Interest Group
			is to bring together people who wish to evaluate potential Web technologies and policies.
			An Interest Group is a forum for the exchange of ideas.

			Interest Groups do not publish <a href="#RecsW3C">Recommendation Track technical reports</a>;
			but can publish <a href="#WGNote">technical reports on the Note Track</a>.
	</dl>

<h4 id="ReqsAllGroups">
Requirements for All Chartered Groups</h4>

	Each group <em class="rfc2119">must</em> have a [=charter=].
	Requirements for the charter depend on the group type.
	All group charters <em class="rfc2119">must</em> be public
	(even if other proceedings of the group are <a href="#Member-only">Member-only</a>).

	Each group <em class="rfc2119">must</em> have a <dfn id="GeneralChairs" export>Chair</dfn> (or co-Chairs)
	to coordinate the group's tasks.
	The [=Team=] appoints (and re-appoints) Chairs for all groups.
	The Chair is a <a href="#member-rep">Member representative</a>,
	a <a href="#Team">Team representative</a>,
	or an <a href="#invited-expert-wg">Invited Expert</a>,
	(invited by the [=Team=]).
	The requirements of this document that apply to those types of participants apply to Chairs as well.
	
	Note: The <a href="https://www.w3.org/Guide/chair/role.html">role of the Chair</a> [[CHAIR]] is described
	in the <a href="https://www.w3.org/Guide/">Art of Consensus</a> [[GUIDE]].

	Each group <em class="rfc2119">must</em> have a <dfn id="TeamContact" export>Team Contact</dfn>,
	who acts as the interface between the [=Chair=],
	group participants,
	and the rest of the Team.
	
	Note: The <a href="https://www.w3.org/Guide/teamcontact/role.html">role of the Team Contact</a> [[TEAM-CONTACT]] 
	is described in the <a href="https://www.w3.org/Guide/">Art of Consensus</a> [[GUIDE]].
				
	The [=Chair=] and the [=Team Contact=] of a group <em class="rfc2119">should not</em> be the same individual.

	Each group <em class="rfc2119">must</em> have an archived mailing list
	for formal group communication
	(e.g., for meeting announcements and [=minutes=],
	documentation of decisions,
	and [=Formal Objections=] to decisions).
	It is the responsibility of the [=Chair=] and [=Team Contact=]
	to ensure that new participants are subscribed to all relevant mailing lists.
	Refer to the list of <a href="https://www.w3.org/groups/">group mailing lists</a> [[GROUP-MAIL]].

	<p>A [=Chair=] <em class="rfc2119">may</em> form task forces
	(composed of group participants)
	to carry out assignments for the group.
	The scope of these assignments <em class="rfc2119">must not</em> exceed the scope of the group's charter.
	A group <em class="rfc2119">should</em> document the process it uses
	to create task forces
	(e.g., each task force might have an informal "charter").
	Task forces do not publish <a href="#Reports">technical reports</a>;
	the Working Group <em class="rfc2119">may</em> choose to publish their results as part of a technical report.

<h4 id="group-participation">
Participation in Chartered Groups</h4>

	There are three types of individual <dfn id="wgparticipant">participants in a Working Group</dfn>:
	<a href="#member-rep">Member representatives</a>,
	<a href="#invited-expert-wg">Invited Experts</a>,
	and <a href="#Team">Team representatives</a>
	(including the <a href="#TeamContact">Team Contact</a>).

	There are four types of individual <dfn id="igparticipant">participants in an Interest Group</dfn>:
	the same three types as for Working Groups plus,
	for an Interest Group where the only <a href="#ig-mail-only">participation requirement is mailing list subscription</a>,
	<dfn id="public-participant-ig">public participants</dfn>.

	Except where noted in this document or in a group charter,
	all participants share the same rights and responsibilities in a group;
	see also the <a href="#ParticipationCriteria">individual participation criteria</a>.

	A participant <em class="rfc2119">may</em> represent more than one organization
	in a [=Working Group=] or [=Interest Group=].
	Those organizations <em class="rfc2119">must</em> all be members of the group.

	An individual <em class="rfc2119">may</em> become
	a Working or Interest Group participant
	at any time during the group's existence.
	See also relevant requirements in
	“Joining an Already Established Working Group”
	in the W3C Patent Policy [[PATENT-POLICY]].

	On an exceptional basis,
	a Working or Interest Group participant <em class="rfc2119">may</em> designate
	a <dfn id="mtg-substitute">substitute</dfn>
	to attend a <a href="#GeneralMeetings">meeting</a>
	and <em class="rfc2119">should</em> inform the [=Chair=].
	The substitute <em class="rfc2119">may</em> act on behalf of the participant,
	including for <a href="#Votes">votes</a>.
	For the substitute to vote,
	the participant <em class="rfc2119">must</em> inform the [=Chair=] in writing in advance.
	As a courtesy to the group,
	if the substitute is not well-versed in the group's discussions,
	the regular participant <em class="rfc2119">should</em> authorize another participant to act as <a href="#proxy">proxy</a> for votes.

	To allow rapid progress,
	Working Groups are intended to be small
	(typically fewer than 15 people)
	and composed of experts in the area defined by the charter.
	In principle,
	Interest Groups have no limit on the number of participants.
	When a Working Group grows too large to be effective,
	W3C <em class="rfc2119">may</em> split it into an Interest Group
	(a discussion forum)
	and a much smaller Working Group
	(a core group of highly dedicated participants).

<h4 id=chartered-group-participants>
Types of Participants in Chartered Groups</h4>

<h5 id="member-rep-wg">
Member Representative in a Working Group</h5>

	An individual is a <dfn export>Member representative in a Working Group</dfn>
	if all of the following conditions are satisfied:

	<ul>
		<li>
			the Advisory Committee representative of the Member in question
			has designated the individual as a Working Group participant, and

		<li>
			the individual qualifies for <a href="#member-rep">Member representation</a>.
	</ul>

	To designate an individual as a Member representative in a [=Working Group=],
	an [=Advisory Committee representative=] <em class="rfc2119">must</em> provide the [=Chair=] and [=Team Contact=]
	with all of the following <span id=member-rep-info>information</span>,
	in addition to any other information required by the <a href="#cfp">Call for Participation</a>
	and charter
	(including the participation requirements of the W3C Patent Policy [[!PATENT-POLICY]]):

	<ol>
		<li>
			The name of the W3C Member the individual represents
			and whether the individual is an employee of that Member organization;

		<li>
			A statement that the individual accepts the participation terms
			set forth in the charter
			(with an indication of charter date or version);

		<li>
			A statement that the Member will provide the necessary financial support for participation
			(e.g., for travel, telephone calls, and conferences).
	</ol>

	A Member participates in a [=Working Group=]
	from the moment the first Member representative joins the group
	until either of the following occurs:

	<ul>
		<li>
			the group closes, or
		<li>
			the Member <a href="#resignation">resigns</a> from the Working Group;
			this is done through the Member's Advisory Committee representative.
	</ul>

<h5 id="member-rep-ig">
Member Representative in an Interest Group</h5>

	When the participation requirements exceed <a href="#ig-mail-only">Interest Group mailing list subscription</a>,
	an individual is a <dfn export>Member representative in an Interest Group</dfn>
	if all of the following conditions are satisfied:

	<ul>
		<li>
			the [=Advisory Committee representative=] of the Member in question has designated the individual
			as an Interest Group participant, and

		<li>
			the individual qualifies for <a href="#member-rep">Member representation</a>.
	</ul>

	To designate an individual as a [=Member representative in an Interest Group=],
	the Advisory Committee representative <em class="rfc2119">must</em> follow the instructions
	in the <a href="#cfp">Call for Participation</a> and charter.

	Member participation in an Interest Group ceases under the same conditions as for a Working Group.

<h5 id="invited-expert-wg">
Invited Expert in a Working Group</h5>

	The [=Chair=] <em class="rfc2119">may</em> invite an individual with a particular expertise
	to participate in a Working Group.
	This individual <em class="rfc2119">may</em> represent an organization in the group
	(e.g., if acting as a liaison with another organization).

	An individual is an <dfn export>Invited Expert in a Working Group</dfn> if all of the following conditions are satisfied:

	<ul>
		<li>
			the Chair has designated the individual as a group participant,

		<li>
			the Team Contact has agreed with the Chair's choice, and

		<li>
			the individual has provided the <a href="#inv-expert-info">information required of an Invited Expert</a>
			to the Chair and Team Contact.
	</ul>

	To designate an individual as an Invited Expert in a Working Group,
	the [=Chair=] <em class="rfc2119">must</em> inform the Team Contact
	and provide rationale for the choice.
	When the [=Chair=] and the [=Team Contact=] disagree about a designation,
	the [=CEO=] determines
	whether the individual will be invited to participate in the Working Group.

	To <dfn id="inv-expert-info">participate in a [=Working Group=] as an Invited Expert</dfn>,
	an individual <em class="rfc2119">must</em>:

	<ul>
		<li>
			identify the organization, if any, the individual represents as a participant in this group,

		<li>
			agree to the terms of the
			<a href="https://www.w3.org/Consortium/Legal/collaborators-agreement">invited expert and collaborators agreement</a> [[!COLLABORATORS-AGREEMENT]],

		<li>
			accept the participation terms set forth in the charter,
			including the participation requirements of
			the W3C Patent Policy [[!PATENT-POLICY]],
			especially in “Note on Licensing Commitments for Invited Experts”
			and in “Disclosure”,
			indicating a specific charter date or version,

		<li>
			disclose whether the individual is an employee of a W3C Member;
			see the <a href="#coi">conflict of interest policy</a>,

		<li>
			provide a statement of who will provide the necessary financial support
			for the individual's participation
			(e.g., for travel, telephone calls, and conferences), and

		<li>
			if the individual's employer (including a self-employed individual)
			or the organization the individual represents
			is not a W3C Member,
			indicate whether that organization intends to join W3C.
			If the organization does not intend to join W3C,
			indicate reasons the individual is aware of for this choice.
	</ul>

	The [=Chair=] <em class="rfc2119">should not</em> designate as an [=Invited Expert in a Working Group=]
	an individual who is an employee of a W3C Member.
	The Chair <em class="rfc2119">must not</em> use Invited Expert status
	to circumvent participation limits imposed by the <a href="#WGCharter">charter</a>.

	An Invited Expert participates in a Working Group
	from the moment the individual joins the group
	until any of the following occurs:

	<ul>
		<li>
			the group closes, or

		<li>
			the Chair or [=CEO=] withdraws the invitation to participate, or

		<li>
			the individual <a href="#resignation">resigns</a>.
	</ul>

<h5 id="invited-expert-ig">
Invited Expert in an Interest Group</h5>

	When the participation requirements exceed <a href="#ig-mail-only">Interest Group mailing list subscription</a>,
	the participation requirements for an <dfn export>Invited Expert in an Interest Group</dfn>
	are the same as those for an [=Invited Expert in a Working Group=].

<h5 id="team-rep-wg">
Team Representative in a Working Group</h5>

	An individual is a <dfn export>Team representative in a Working Group</dfn>
	when so designated by W3C management.
	Team representatives both contribute to the technical work
	and help ensure the group's proper integration with the rest of W3C.

	A Team representative participates in a Working Group
	from the moment the individual joins the group
	until any of the following occurs:

	<ul>
		<li>
			the group closes, or

		<li>
			W3C management changes Team representation by sending email to the Chair,
			copying the group mailing list.
	</ul>

	The Team participates in a Working Group
	from the moment the creation of the group is announced
	until the group closes.

<h5 id="team-rep-ig">
Team Representative in an Interest Group</h5>

	When the participation requirements exceed <a href="#ig-mail-only">Interest Group mailing list subscription</a>,
	an individual is a <dfn export>Team representative in an Interest Group</dfn> when so designated by W3C management.

<h2 id=group-lifecyle>
Lifecycle of Chartered Groups</h2>

<h3 id="WGCharterDevelopment">
Initiating Charter Development</h3>

	W3C creates charters for [=chartered groups=]
	based on interest from the Members and Team.
	The Team <em class="rfc2119">must</em> notify the Advisory Committee
	when a charter for a new Working Group or Interest Group is in development.
	This is intended to raise awareness,
	even if no formal proposal is yet available.
	Advisory Committee representatives <em class="rfc2119">may</em> provide
	feedback on the <a href="#ACCommunication">Advisory Committee discussion list</a>
	or via other designated channels.

	W3C <em class="rfc2119">may</em> begin work
	on a Working Group or Interest Group charter
	at any time.

<h3 id="WGCharter">
Content of a Charter</h3>

	A Working Group or Interest Group <dfn export>charter</dfn>
	<em class="rfc2119">must</em> include all of the following information.

	<ul>
		<li>
			The group's mission
			(e.g., develop a technology or process, review the work of other groups).

		<li>
			The scope of the group's work and criteria for success.

		<li>
			The duration of the group (typically from six months to two years).

		<li>
			The nature of any deliverables (technical reports, reviews of the deliverables of other groups, or software).

		<li>
			Expected milestone dates where available.

			Note: A charter is <em class="rfc2119">not required</em>
			to include schedules for review of other group's deliverables.

		<li>
			The process for the group to approve the release of deliverables
			(including intermediate results).

		<li>
			Any dependencies by groups within or outside of W3C on the deliverables of this group.
			For any dependencies, the charter <em class="rfc2119">must</em> specify
			the mechanisms for communication about the deliverables.

		<li>
			Any dependencies of this group on other groups within or outside of W3C.
			Such dependencies include interactions with
			<a href="https://www.w3.org/Guide/process/charter.html#horizontal-review">W3C Horizontal Groups</a> [[CHARTER]].

		<li>
			The <a href="#confidentiality-levels">level of confidentiality</a>
			of the group's proceedings and deliverables.

		<li>
			Meeting mechanisms and expected frequency.

		<li>
			If known,
			the date of the first <a href="#ftf-meeting">face-to-face meeting</a>.
			The date of the first face-to-face meeting of a proposed group
			<em class="rfc2119">must not</em> be sooner than <span class="time-interval">eight weeks</span>
			after the date of the proposal.

		<li>
			Communication mechanisms to be employed within the group,
			between the group and the rest of W3C,
			and with the general public.

		<li>
			Any voting procedures or requirements
			other than those specified in <a href="#Votes"></a>.

		<li>
			An estimate of the expected time commitment from participants.

		<li>
			The expected time commitment and level of involvement by the Team
			(e.g., to track developments,
			write and edit technical reports,
			develop code,
			or organize pilot experiments).

		<li>
			Intellectual property information.
			What are the intellectual property (including patents and copyright)
			considerations affecting the success of the Group?
			In particular, is there any reason to believe
			that it will be difficult to meet the Royalty-Free licensing goals
			in “Licensing Goals for W3C Specifications”
			in the W3C Patent Policy [[PATENT-POLICY]]?
	</ul>

	See also the charter requirements in “Licensing Goals for W3C Specifications”
	in the W3C Patent Policy [[!PATENT-POLICY]].

	For every Recommendation Track deliverable
	that continues work on [=technical report=]
	published under any other Charter (including a predecessor group of the same name),
	for which there is at least an existing [=First Public Working Draft=]
	the description of that deliverable in the proposed charter of the adopting Working Group
	<em class="rfc2119">must</em> provide the following information:

	<ul>
		<li>
			The title,
			stable URL,
			and publication date of the [=Working Draft=]
			or other Recommendation-track document
			that will serve as the basis for work on the deliverable
			(labeled “<dfn export id="adopted-draft">Adopted Draft</dfn>”);

		<li>
			The title,
			stable URL,
			and publication date of the document
			that was used as the basis for its most recent Exclusion Opportunity
			as per
			<!--[[PATENT-POLICY#lrd-exclusion-pediods|section 5.4.1]] of-->
			the W3C Patent Policy [[!PATENT-POLICY]].
			(labeled “<dfn export id="exclusion-draft">Exclusion Draft</dfn>”); and

		<li>
			The stable URL of the Working Group charter
			under which the Exclusion Draft was published
			(labeled the “<dfn export id=exclusion-draft-charter oldids="other-charter">Exclusion Draft Charter</dfn>”).
	</ul>

	All of the above data <em class=rfc2119>must</em> be identified
	in the adopting Working Group's charter using the labels indicated.

	The [=Adopted Draft=] and the [=Exclusion Draft=]
	<em class="rfc2119">must</em> each be adopted in their entirety and without any modification.
	The proposed charter <em class="rfc2119">must</em> state
	the dates on which the Exclusion Opportunity
	that arose on publishing the [=Exclusion Draft=]
	began and ended.
	As per “Joining an Already Established Working Group”
	in the W3C Patent Policy [[!PATENT-POLICY]],
	this potentially means that exclusions can only be made immediately on joining a Working Group.

	<p id="ig-charter-participation">An Interest Group charter
	<em class="rfc2119">may</em> include provisions regarding participation,
	including specifying
	that the <span id="ig-mail-only">only requirement for participation (by anyone) in
	the Interest Group is subscription to the Interest Group mailing list</span>.
	This type of Interest Group
	<em class="rfc2119">may</em> have <a href="#public-participant-ig">public participants</a>.

	A charter <em class="rfc2119">may</em> include
	provisions other than those required by this document.
	The charter <em class="rfc2119">should</em> highlight
	whether additional provisions impose constraints
	beyond those of the W3C Process Document
	(e.g., limits on the number of individuals in a Working Group
	who represent the same Member organization or group of <a href="#MemberRelated">related Members</a>).

<h3 id="CharterReview">
Advisory Committee Review of a Charter</h3>

	The [=Team=] <em class="rfc2119">must</em> solicit <a href="#ACReview">Advisory Committee review</a>
	of every new or substantively modified Working Group or Interest Group charter,
	except for either:
	* a charter extension
	* substantive changes to a charter that do not affect the way the group functions in any significant way.

	The review period <em class="rfc2119">must</em> be at least 28 days.
	The following are examples of substantive changes that would not require an [=Advisory Committee Review=]:
	the addition of an in-scope deliverable,
	a change of [=Team Contact=],
	or a change of [=Chair=].
	Such changes must nonetheless be announced
	to the [=Advisory Committee=]
	and to <a href="#wgparticipant"> participants in the Working</a> or <a href="#igparticipant">in the Interest Group</a>,
	and a rationale must be provided.

	The Call for Review of a substantively modified charter
	<em class="rfc2119">must</em> highlight important changes
	(e.g., regarding deliverables or resource allocation)
	and include rationale for the changes.

	As part of the Advisory Committee review of any new or substantively modified Working Group charter,
	any Advisory Committee representative <em class="rfc2119">may</em> request an extended review period.

	Such a request must be submitted with a Member's comments
	in response to the Call for Review.
	Upon receipt of any such request,
	the [=Team=] <em class="rfc2119">must</em> ensure
	that the Call for Participation for the Working Group
	occurs at least 60 days
	after the Call for Review of the charter.

<h3 id="cfp">
Call for Participation in a Chartered Group</h3>

	Deciding whether to adopt a proposed [=Working Group=] or [=Interest Group=] [=charter=]
	is a [=W3C Decision=].
	Charters <em class="rfc2119">may</em> be amended based on review comments
	per [[#ACReviewAfter]]
	before the Call for Participation.

	If the decision is to charter the group,
	the [=Team=] <em class="rfc2119">must</em> issue a Call for Participation to the Advisory Committee.
	For a new group, this announcement officially creates the group.
	The announcement <em class="rfc2119">must</em> include a reference to the <a href="#WGCharter">charter</a>,
	the name(s) of the group's [=Chair=](s),
	and the name(s) of the [=Team Contact=](s).

	After a Call for Participation,
	any <a href="#member-rep">Member representatives</a>
	and <a href="#invited-expert-wg">Invited Experts</a>
	<em class="rfc2119">must</em> be designated (or re-designated).
	When a group is re-chartered,
	individuals participating in the [=Working Group=] or [=Interest Group=] before the new Call for Participation
	may attend any meetings held within forty-five (45) days of the Call for Participation
	even if they have not yet formally rejoined the group
	(i.e., committed to the terms of the charter and patent policy).

	Advisory Committee representatives <em class="rfc2119">may</em> initiate
	an <a href="#ACAppeal">Advisory Committee Appeal</a>
	against the decision to create
	or substantially modify
	a Working Group or Interest Group charter.

<h3 id="charter-extension">
Charter Extension</h3>

	The [=Team=] <em class="rfc2119">may</em> decide
	to extend a Working Group or Interest Group charter
	with no other substantive modifications.
	The [=Team=] <em class="rfc2119">must</em> announce
	such <dfn id=dfn-charter-extension export lt="charter extension">extensions</dfn>
	to the [=Advisory Committee=].
	The announcement <em class="rfc2119">must</em> indicate the new duration.
	The announcement <em class="rfc2119">must</em> also include rationale for the extension,
	a reference to the <a href="#WGCharter">charter</a>,
	and the Group homepage
	(which includes at least
	the name(s) of the group's [=Chair=](s),
	the name of the [=Team Contact=],
	and instructions for joining the group).

	After a charter extension,
	Advisory Committee representatives
	and the [=Chair=] are <em class="rfc2119">not required</em> to re-designate <a href="#member-rep">Member representatives</a>
	and <a href="#invited-expert-wg">Invited Experts</a>.

	Advisory Committee representatives <em class="rfc2119">may</em> initiate
	an <a href="#ACAppeal">Advisory Committee Appeal</a> against a [=Team decision=]
	regarding the extension of a Working Group or Interest Group charter.

<h3 id="GeneralTermination">
Chartered Group Closure</h3>

	A [=Working Group=] or [=Interest Group=] charter specifies a duration for the group.

	The [=Team=], the [=TAG=], or the [=AB=] <em class=rfc2119>may</em> propose to close a group
	prior to the date specified in the charter in any of the following circumstances:

	* There are insufficient member resources to produce chartered deliverables
		or to maintain the group,
		according to priorities established within W3C.
	* A [=Patent Advisory Group=] concluded that the work
		<em class=rfc2119>should</em> be terminated.
	* The [=TAG=] or [=AB=] determined that continuing operation of the chartered group or its work
		would be detrimental to W3C or its mission.
	* The group produced all chartered deliverables ahead of schedule.

	Such a proposal to close a group must be accompanied by rationale,
	and the proposal must be confirmed by an [=AC Review=] as a [=W3C Decision=].

	Closing a Working Group has implications
	with respect to the W3C Patent Policy [[!PATENT-POLICY]].

<h2 id=decisions>
Decisions</h2>

	W3C attempts to resolve issues through dialog.
	Individuals who disagree strongly with a decision
	<em class="rfc2119">should</em> register with the Chair any [=Formal Objections=].

<h3 id=decision-types>
Types of Decisions</h3>

	The [=Chair=] of a [=Working Group=] or [=Interest Group=] has the prerogative
	to make certain decisions based on their own judgment.
	Such decisions are called <dfn export>chair decisions</dfn>.

	In contrast,
	decisions taken by the [=Chair=] of a [=Working Group=] or [=Interest Group=]
	on the basis of having assessed the [=consensus=] of the group
	or following a vote (see [[#Votes]])
	are called <dfn export lt="group decision | resolution">group decisions</dfn>
	(also known as group “resolutions”).

	Decisions made by members of the [=Team=]
	in connection with this Process,
	based on their own individual or collective judgement,
	are called <dfn noexport lt="Team Decision | Team's Decision">Team Decisions</dfn>.

	In contrast,
	a <dfn id="def-w3c-decision">W3C decision</dfn> is
	determined by the [=Team=] on behalf of the W3C community
	by assessing the consensus of the W3C Community after an [=Advisory Committee review=].

<h3 id=consensus-building>
Consensus Building</h3>

<h4 id="Consensus">
Consensus</h4>

	Consensus is a core value of W3C.
	To promote consensus,
	the W3C process requires Chairs to ensure
	that groups consider all legitimate views and objections,
	and endeavor to resolve them,
	whether these views and objections are expressed by the active participants of the group
	or by others
	(e.g., another W3C group,
	a group in another organization,
	or the general public).
	Decisions <em class="rfc2119">may</em> be made during meetings
	(<a href="#ftf-meeting">face-to-face</a>
	or <a href="#distributed-meeting">distributed</a>)
	as well as through <a href=#discussion-archiving>persistent text-based discussions</a>.

	Note: The CEO has the role of
	assessing consensus within the Advisory Committee.

	The following terms are used in this document
	to describe the level of support for a decision among a set of eligible individuals:

	<dl>
		<dt><dfn id="def-Consensus">Consensus</dfn>:
		<dd>
			A substantial number of individuals in the set
			support the decision
			and there is no sustained objection from anybody in the set.
			Individuals in the set <em class="rfc2119">may</em> abstain.
			Abstention is either an explicit expression of no opinion
			or silence by an individual in the set.

		<dt><dfn id="def-Unanimity">Unanimity</dfn>:
		<dd>
			The particular case of [=consensus=]
			where all individuals in the set support the decision
			(i.e., no individual in the set abstains).

		<dt><dfn id="def-Dissent">Dissent</dfn>:
		<dd>
			At least one individual in the set sustains an objection.
	</dl>

	Note: A [=Formal Objection=] always indicates a sustained objection,
	but isn't necessary to express it
	(except in the context of formal [=AC Reviews=]).
	Disagreement with a proposed decision,
	however, does not always rise to the level of sustained objection,
	as individuals could be willing to accept a decision
	while expressing disagreement.

	By default, the set of individuals eligible to participate in a decision is the set of group participants.
	The Process Document does not require a quorum for decisions
	(i.e., the minimal number of eligible participants required to be present before the Chair can call a question).
	A charter <em class="rfc2119">may</em> include a quorum requirement for consensus decisions.

	Where [=unanimity=] is not possible,
	a group <em class="rfc2119">should</em> strive to make [=consensus=] decisions
	where there is significant support and few abstentions.
	The Process Document does not require a particular percentage of eligible participants
	to agree to a motion in order for a decision to be made.
	To avoid decisions where there is widespread apathy,
	(i.e., little support and many abstentions),
	groups <em class="rfc2119">should</em> set minimum thresholds of active support before a decision can be recorded.
	The appropriate percentage <em class="rfc2119">may</em> vary depending on the size of the group
	and the nature of the decision.
	A charter <em class="rfc2119">may</em> include threshold requirements for consensus decisions.
	For instance, a charter might require a supermajority of eligible participants
	(i.e., some established percentage above 50%)
	to support certain types of consensus decisions.

	<div class=note>
	Note: Chairs have substantial flexibility
	in how they obtain and assess consensus among their groups.
	Unless otherwise constrained by charter,
	they may use modes including but not limited to explicit calls for consensus,
	polls of participants,
	“lazy consensus” in which lack of objection after sufficient notice is taken as assent;
	or they may also delegate and empower a document editor
	to assess consensus on their behalf,
	whether in general
	or for specific pre-determined circumstances
	(e.g. in non-controversial situations, for specific types of issues, etc.).

	If questions or disagreements arise,
	the final determination of consensus remains with the chair.
	</div>

<h4 id="managing-dissent">
Managing Dissent</h4>

	In some cases, even after careful consideration of all points of view,
	a group might find itself unable to reach consensus.
	The [=Chair=] <em class="rfc2119">may</em> record a decision where there is [=dissent=]
	so that the group can make progress
	(for example, to produce a deliverable in a timely manner).
	Dissenters cannot stop a group's work
	simply by saying that they cannot live with a decision.
	When the Chair believes that the Group has duly considered
	the legitimate concerns of dissenters as far as is possible and reasonable,
	the group <em class="rfc2119">should</em> move on.

	Groups <em class="rfc2119">should</em> favor proposals that create the weakest objections.
	This is preferred over proposals that are supported by a large majority
	but that cause strong objections from a few people.
	As part of making a decision where there is [=dissent=],
	the [=Chair=] is expected to be aware of which participants work for the same
	(or <a href="#MemberRelated">related</a>)
	Member organizations and weigh their input accordingly.

	Note: Dissenters can escalate their sustained objection to a decision by registering a [=Formal Objection=].

<h4 id="Votes">
Deciding by Vote</h4>

	A group <em class="rfc2119">should</em> only conduct a vote to resolve a <em>substantive issue</em>
	after the [=Chair=] has determined that all available means of <a href="#Consensus">reaching consensus</a>
	through technical discussion and compromise have failed,
	and that a vote is necessary to break a deadlock.
	In this case the [=Chair=] <em class="rfc2119">must</em> record
	(e.g., in the [=minutes=] of the meeting or in an archived email message):

	<ul>
		<li>
			an explanation of the issue being voted on;

		<li>
			the decision to conduct a vote
			(e.g., a simple majority vote) to resolve the issue;

		<li>
			the outcome of the vote;

		<li>
			any Formal Objections.
	</ul>

	In order to vote to resolve a substantive issue,
	an individual <em class="rfc2119">must</em> be a group [=participant=].
	Each organization represented in the group <em class="rfc2119">must</em> have at most one vote,
	even when the organization is represented by several participants in the group
	(including Invited Experts).
	For the purposes of voting:

	<ul>
		<li>
			A Member or group of <a href="#MemberRelated">related Members</a> is considered a single organization.

		<li>
			The <a href="#Team">Team</a> is considered an organization.
	</ul>

	Unless the charter states otherwise,
	<a href="#invited-expert-wg">Invited Experts</a> <em class="rfc2119">may</em> vote.

	If a participant is unable to attend a vote,
	that individual <em class="rfc2119">may</em> authorize anyone at the meeting
	to act as a <dfn id="proxy">proxy</dfn>.
	The absent participant <em class="rfc2119">must</em> inform the Chair in writing
	who is acting as proxy, with written instructions on the use of the proxy.
	For a Working Group or Interest Group,
	see the related requirements regarding an individual
	who attends a meeting as a <a href="#mtg-substitute">substitute</a> for a participant.

	A group <em class="rfc2119">may</em> vote for other purposes than to resolve a substantive issue.
	For instance, the Chair often conducts a “straw poll” vote
	as a means of determining whether there is consensus about a potential decision.

	A group <em class="rfc2119">may</em> also vote to make a process decision.
	For example,
	it is appropriate to decide by simple majority
	whether to hold a meeting in San Francisco or San Jose
	(there's not much difference geographically).
	When simple majority votes are used to decide minor issues,
	voters are <em class="rfc2119">not required</em> to state the reasons for votes,
	and the group is <em class="rfc2119">not required</em> to record individual votes.

	A group charter <em class="rfc2119">may</em> include formal voting procedures
	(e.g., quorum or threshold requirements)
	for making decisions about substantive issues.

<h3 id="formal-address">
Formally Addressing an Issue</h3>

	In the context of this document,
	a group has <dfn export>formally addressed</dfn> an issue when it has sent a public, substantive response
	to the reviewer who raised the issue.
	A substantive response is expected to include rationale for decisions
	(e.g., a technical explanation, a pointer to charter scope, or a pointer to a requirements document).
	The adequacy of a response is measured
	against what a W3C reviewer would generally consider to be technically sound.
	If a group believes that a reviewer's comments result from a misunderstanding,
	the group <em class="rfc2119">should</em> seek clarification before reaching a decision.

	As a courtesy,
	both Chairs and reviewers <em class="rfc2119">should</em> set expectations
	for the schedule of responses and acknowledgments.
	The group <em class="rfc2119">should</em> reply to a reviewer's initial comments
	in a timely manner.
	The group <em class="rfc2119">should</em> set a time limit
	for acknowledgment by a reviewer of the group's substantive response;
	a reviewer cannot block a group's progress.
	It is common for a reviewer to require a week or more
	to acknowledge and comment on a substantive response.
	The group's responsibility to respond to reviewers
	does not end once a reasonable amount of time has elapsed.
	However, reviewers <em class="rfc2119">should</em> realize
	that their comments will carry less weight
	if not sent to the group in a timely manner.

	Substantive responses <em class="rfc2119">should</em> be recorded.
	The group <em class="rfc2119">should</em> maintain an accurate summary
	of all substantive issues and responses to them
	(e.g., in the form of an issues list with links to mailing list archives).

<h3 id="WGChairReopen">
Reopening a Decision When Presented With New Information</h3>

	The [=Chair=] <em class="rfc2119">may</em> reopen a decision
	when presented with new information, including:

	<ul>
		<li>
			additional technical information,
		<li>
			comments by email from participants who were unable to attend a scheduled meeting,

		<li>
			comments by email from meeting attendees
			who chose not to speak out during a meeting
			(e.g., so they could confer later with colleagues or for cultural reasons).
	</ul>

	The [=Chair=] <em class="rfc2119">should</em> record
	that a decision has been reopened,
	and <em class="rfc2119">must</em> do so upon request from a group participant.

<h3 id="registering-objections" oldids="WGArchiveMinorityViews, WGAppeals, wg-decision-appeal, chair-decision-appeal">
Registering Formal Objections</h3>

	Any individual
	(regardless of whether they are associated with a Member)
	<em class="rfc2119">may</em> appeal any decision made in connection with this Process
	(except those having a different appeal process)
	by registering a <dfn id="FormalObjection">Formal Objection</dfn> with the [=Team=].
	Group participants <em class="rfc2119">should</em> inform
	their <a href="#TeamContact">Team Contact</a> as well as the group's Chair(s).
	The Team Contact <em class="rfc2119">must</em> inform the [=CEO=]
	when a group participant has also raised concerns about due process.

	Note: In this document, the term [=Formal Objection=] is used to emphasize this process implication:
	Formal Objections receive formal consideration and a formal response.
	The word “objection” used alone has its ordinary English connotations.
	See [[#consensus-building]].

	A [=Formal Objection=]
	<em class="rfc2119">must</em> include a summary of
	the issue (whether technical or procedural),
	the decision being appealed,
	and the rationale for the objection.
	It <em class="rfc2119">should</em> cite technical arguments
	and propose changes that would remove the [=Formal Objection=];
	these proposals <em class="rfc2119">may</em> be vague or incomplete.
	[=Formal Objections=] that do not provide substantive arguments
	or rationale are unlikely to receive serious consideration.
	Counter-arguments,
	rationales,
	and decisions <em class="rfc2119">should</em> also be recorded.

	A record of each [=Formal Objection=] against a decision regarding a publicly-available document
	<em class="rfc2119">must</em> be made <a href="#confidentiality-change">publicly available</a>;
	likewise, a record of each [=Formal Objection=] against a [=Member-only|Member-visible=] decision
	<em class="rfc2119">must</em> be made <a href="#confidentiality-change">available to Members</a>.
	A Call for Review to the Advisory Committee
	<em class="rfc2119">must</em> identify any [=Formal Objections=]
	related to that review.

	Note: [=Formal Objections=] against matter in a [=technical report=]
	are required to be addressed before <a href="#rec-advance">requesting advancement</a>
	of the [=technical report=].

	A [=Formal Objection=] filed during an [=Advisory Committee Review=]
	is considered registered at the close of the review period.

<h3 id=addressing-fo>
Addressing Formal Objections</h3>

<h4 id=team-fo-mediation>
Investigation and Mediation by the Team</h4>

	The [=Team=] considers the [=Formal objection=],
	researches the question,
	interviews parties,
	and so on,
	to make sure the problem and the various viewpoints are well understood,
	and to the extent possible,
	to arrive at a recommended disposition.
	If the [=Team=] can resolve the issue
	to the satisfaction of the individual that filed the [=Formal Objection=],
	the individual withdraws the objection and the disposition process terminates.

	Otherwise,
	upon concluding that consensus cannot be found,
	and no later than 90 days after the [=Formal Objection=] being registered,
	the [=Team=] <em class=rfc2119>must</em> initiate formation of a [=W3C Council=],
	which should be <a href="#council-convention">convened</a> within 45 days of being initiated.
	Concurrently, it must prepare a report for the [=Council=]
	documenting its findings and attempts to find consensus.

<h4 id=council>
W3C Council</h4>

	A <dfn export local-lt="Council">W3C Council</dfn> is the body convened to resolve [=Formal Objections=]
	by combining the capabilities and perspectives of the [=AB=], the [=TAG=], and the [=Team=],
	and is tasked with doing so in the best interests of the Web and W3C.

<h5 id=council-composition>
Council Composition</h5>

	Each [=W3C Council=] is composed of the following members (excepting any [[#council-participation|renounced or dismissed]]):
	* the [=CEO=] or their chosen [=Team=] delegate
	* the members of the [=Advisory Board=]
	* the members of the [=Technical Architecture Group=]

	Participation in a [=W3C Council=] <em class=rfc2119>must not</em> require attendance of [=face-to-face meetings=].

	A distinct instance of the [=W3C Council=] is convened for each decision being appealed or objected to.
	Membership of each [=Council=] instance is fixed at formation,
	and is not changed by any [=AB=] or [=TAG=] elections
	occurring before that Council has reached a conclusion.
	However, if participation in a [=Council=] falls so low as to hinder effective and balanced deliberations,
	the [=W3C Council Chair=] <em class="rfc2119">should</em> dissolve the [=Council=]
	and call for a new one to be convened.

	A [=Team=] member is assigned
	to act as the <dfn export>Council Team Contact</dfn>,
	to support this Council
	and to facilitate adherence to this Process.

<h5 id=council-delegation>
Extraordinary Delegation</h5>

	In extraordinary cases,
	if they feel a [=Council=] would not be the appropriate deciding body,
	a member of the [=Team=] (particularly the Legal Counsel) or
	any potential Council member
	may suggest that the decision for that specific Formal Objection be delegated
	to the W3C Board of Directors,
	to an officer of its corporation (such as the Legal Counsel),
	or to one or more specific individuals from the [=Team=].
	The potential Council members then <em class=rfc2119>may</em> confidentially discuss
	and <em class=rfc2119>must</em> vote
	whether to delegate the decision for that specific [=Formal Objection=].
	A decision to delegate <em class=rfc2119>must</em> be supported by a two-thirds supermajority vote
	(i.e., at least twice as many votes in favor as against).
	Delegation in such cases cannot be later revoked.

	The [=Team=] <em class=rfc2119>must</em> inform the [=Advisory Committee=]
	when a [=Formal Objection=] has been delegated,
	and to whom it has been delegated.


<h5 id=council-participation>
Council Participation, Dismissal, and Renunciation</h5>

	A potential Council member may be <dfn lt="dismissed | dismiss | dismissal">dismissed</dfn> from the Council.
	In order to apply consistent criteria,
	the potential Council members decide collectively
	which reasons against service
	rise to a sufficient level for a potential member to be [=dismissed=].
	No-one is automatically dismissed,
	and individual recusal is not used in the Council.
	[=Dismissal=] applies to an individual person in the context of a specific Council,
	and should be used rarely in order to preserve the greatest diversity on the Council.

	Note: A W3C Council is a deliberative body whose purpose is
	to find the best way forward for the Web and for W3C.
	It is not a judicial body tasked with determining right or wrong.

	The [=Team=] <em class=rfc2119>must</em> draft a list of potential [=Council=] members,
	with annotations of possible reasons for dismissal against each one.
	The W3C community,
	including members and team, and potential council members,
	<em class=rfc2119>must</em> be given an opportunity to contribute possible reasons to this list.
	Affected members <em class=rfc2119>must</em> be given
	an opportunity to respond to such comments about themselves.
	The [=Team=] may report comments verbatim
	or may paraphrase them while preserving their intent;
	they may also elide inappropriate comments,
	such as any that violate applicable laws or the [[CEPC]].

	Before a Council forms,
	the [=Team=] presents the entire list of potential members
	and collected reasons and responses
	to the potential Council members,
	who then consider for each potential member
	whether that individual's participation
	would compromise the integrity of the Council decision,
	and vote whether to dismiss that potential member.
	No one is allowed to vote on their own dismissal;
	each dismissal is decided by simple majority of those not abstaining.

	Note: Since dismissal is individual,
	when the decision being objected to was made by the [=TAG=] or [=AB=] acting as a body,
	the entire [=TAG=] or [=AB=] is not expected or required to be dismissed.

	An individual <em class=rfc2119>may</em> also <dfn lt="renounce | renunciation">renounce</dfn> their seat on a Council, for strong reason,
	such as being forbidden by their employer to serve. The individual chooses the extent to which they explain
	their renunciation.
	Renunciation is disqualification from participation,
	not abstention,
	and <em class=rfc2119>should not</em> be used
	to excuse an absence of participation.

	Any person who has been [=dismissed=]
	or who [=renounces=] their seat
	does not receive [=Council=] materials,
	take part in its deliberations,
	help in the determination of consensus,
	or vote.
	The [=W3C Council=] <em class=rfc2110>may</em> still solicit and hear their testimony,
	as they can of anyone else in the W3C community.

<h5 id=council-short-circuit>
Unanimous Short Circuit</h5>


	The full Council process <em class=rfc2119>may</em> be short-circuited if
	the Team recommends a resolution
	and every potential member of a Council who is not renouncing their seat
	votes affirmatively (no abstentions) to adopt this resolution.

	This step <em class=rfc2119>may</em> be run concurrently with [[#council-participation]]
	and prior to choosing a [=W3C Council Chair|Chair=].

	Note: This is intended for exceptional cases
	that don't seem to warrant a full Council response
	because they are, for instance, too trivial, duplicative, etc.

<h5 id=council-chairing>
Council Chairing</h5>

	The <dfn lt="W3C Council Chair">Chair</dfn> of each W3C Council is chosen by its members,
	by consensus if possible,
	falling back to a vote if that fails.
	The chair must be a member of that [=W3C Council=].
	Chair selection happens during formation of each Council,
	and <em class=rfc2119>must</em> be re-run
	if requested by the [=Council Team Contact=] or by the [=Chair=]
	during the Council’s operation.

<h5 id=council-deliberations>
Council Deliberations</h5>

	<p id=council-convention>
	Upon appointment of the [=W3C Council Chair=]
	and delivery of the [=Team=]’s report,
	the [=W3C Council=] is considered to be convened
	and can start deliberations.

	Having reviewed the information gathered by the [=Team=],
	the Council <em class=rfc2119>may</em> conduct additional research or analysis,
	or request additional information or interviews from anyone,
	including the Team.

	<p id=broker-consensus>
	The Council <em class=rfc2119>may</em>
	further attempt to broker consensus,
	which, if successful, disposes the formal objection.

	Otherwise,
	after sufficient deliberation,
	the [=W3C Council=] decides whether to
	<dfn lt="uphold | upholds | upheld | upholding">uphold</dfn> or <dfn>overrule</dfn> the objection.
	The [=W3C Council=] <em class=rfc2119>may</em> [=overrule=] the [=Formal Objection=]
	even if it agrees with some of the supportive arguments.

	<p id=fo-mitigations>
	When [=upholding=] an objection,
	it <em class=rfc2199>should</em> recommend a way forward.
	If the overturned decision has already had consequences
	(e.g., if the objection concerns material already in a published document)
	the Council <em class=rfc2119>should</em> suggest how these consequences might be mitigated.
	The [=Team=] is responsible for making sure that adequate mitigations are enacted in a timely fashion;
	and the [=Formal Objection=] is not considered <dfn>fully addressed</dfn> until then.

	Note: This does not create new powers for the [=Team=],
	such as the ability to “unpublish” documents.
	The [=Team=]'s role is to ensure the responsible parties enact adequate mitigations,
	by whatever means they already have at their disposal.

	A Council <em class=rfc2119>may</em> form sub-groups for deliberation,
	who may return with a recommendation,
	but the full Council issues the final decision.
	The decision of the [=W3C Council=] <em class=rfc2119>should</em> be unanimous,
	and <em class=rfc2119>may</em> be issued under consensus.
	However, if despite careful deliberation
	a [=W3C Council=] is unable to reach consensus,
	the [=W3C Council Chair=] may instead resort to voting.
	In that case,
	the decision is made by simple majority,
	with the [=W3C Council Chair=] breaking any tie.
	In case of a vote,
	if two members of a Council who share the same affiliation cast an identical ballot,
	then their ballots count as a one vote,
	not two.

	In the case of non-unanimous decisions,
	members of a [=W3C Council=] who disagree with the decision
	<em class=rfc2119>may</em> write a <dfn>Minority Opinion</dfn>
	explaining the reason for their disagreement.

	The deliberations of a [=W3C Council=] are confidential to that [=W3C Council=]
	and its [=Council Team Contact=].

	If a [=W3C Council=] is unable to come to a conclusion within 45 days of being <a href="#council-convention">convened</a>,
	the [=W3C Council Chair=] <em class=rfc2119>must</em> inform the [=AC=] of this delay
	and of the status of the discussions.
	The [=W3C Council Chair=] <em class=rfc2119>may</em> additionally make this report <a href="#confidentiality-levels">public</a>.

<h5 id=council-decision>
Council Decision Report</h5>

	A [=Council=] terminates by issuing a <dfn export>Council Report</dfn>,
	which:
	* <em class=rfc2119>must</em> state whether the Council [=upholds=] or [=overrules=] the objection(s).
	* <em class=rfc2119>must</em> provide a rationale supporting the decision,
		which <em class=rfc2119>should</em> address each argument raised in the Formal Objection(s).
	* <em class=rfc2119>must</em> include any recommendation decided by the [=Council=].
	* if the [=Formal Objection=] has been upheld, <em class=rfc2119>should</em> include any suggested <a href="#fo-mitigations">mitigations</a>.
	* <em class=rfc2119>must</em> include the [=Minority Opinion=](s), if any.
	* <em class=rfc2119>must</em> report the names of those who were [=dismissed=] or [=renounced=] their seat as well as those who were qualified to serve.
	* <em class=rfc2119>must</em> report the names of the individuals who participated in the final decision.
	* <em class=rfc2119>may</em> report vote totals, if any vote was held.
	* <em class=rfc2119>must not</em> attribute any position to any individual on the Council.

	The [=Team=] <em class=rfc2119>must</em> maintain a [[COUNCIL-REPORT-INDEX inline|public page on the W3C website]]
	indexing all completed [=Council Reports=].
	If a Council decision is later overturned by an [=AC Appeal=],
	this <em class=rfc2119>must</em> also be mentioned.
	[=Council Reports=] <em class=rfc2119>must</em> be no more confidential
	than the decision or document being objected to.

	The [=Council=] <em class=rfc2119>may</em> also issue a <dfn export>Supplemental Confidential Council Report</dfn>
	with a more restricted <a href="#confidentiality-levels">level of confidentiality</a> than its main report
	when it believes that additional commentary on confidential aspects of the case
	would be informative.
	However, the main [=Council Report=] <em class=rfc2119>should</em> be self-sufficient
	and understandable without reference to Supplemental Confidential Council Reports.

<h5 id=council-appeals>
Appealing Council Decisions</h5>

	[=Advisory Committee representatives=] <em class=rfc2119>may</em> initiate an [=Advisory Committee Appeal=]
	of a Council decision issued in a [=Council Report=].

<h3 id="ACReview">
Advisory Committee Reviews</h3>

	<dfn export lt="Advisory Committee review | AC Review"> Advisory Committee review</dfn> is the process
	by which the [=Advisory Committee=] formally confers its approval
	on [=charters=],
	[=technical reports=],
	and other matters.

<h4 id="ACReviewStart">
Start of a Review Period</h4>

	Each [=Advisory Committee review=] period
	begins with a Call for Review from the [=Team=] to the [=Advisory Committee=].
	The <dfn id="reviewform">Call for Review</dfn> describes the proposal,
	raises attention to deadlines,
	estimates when the decision will be available,
	and includes other practical information.
	Each Member organization <em class="rfc2119">may</em> send one review,
	which <em class="rfc2119">must</em> be returned by its [=Advisory Committee representative=].

	For clarity,
	in the context of an [=AC Review=],
	[=dissent=] <em class=rfc2119>must</em> be expressed as a [=Formal Objection=].

	The Team <em class="rfc2119">must</em> provide two channels for Advisory Committee review comments:

	<ol>
		<li>
			an archived [=Team-only=] channel;

		<li>
			an archived [=Member-only=] channel.
	</ol>

	The [=Call for Review=] <em class="rfc2119">must</em> specify
	which channel is the default for review comments on that Call.

	Reviewers <em class="rfc2119">may</em> send information
	to either or both channels.
	A reviewer <em class="rfc2119">may</em> also share their own reviews
	with other Members on the <a href="#ACCommunication">Advisory Committee discussion list</a>,
	and <em class=rfc2119>may</em> also make it available to the public.

	A Member organization <em class="rfc2119">may</em> modify its review
	during a review period
	(e.g., in light of comments from other Members).

<h4 id="ACReviewAfter">
After the Review Period</h4>

	After the review period,
	the [=Team=] determines the appropriate [=W3C Decision=],
	which they <em class=rfc2119>must</em> announce to the [=Advisory Committee=].
	The announcement <em class="rfc2119">must</em> indicate
	the level of support for the proposal
	([=consensus=] or [=dissent=]),
	and specifically
	whether there were any [=Formal Objections=],
	with attention to <a href="#confidentiality-change">changing the confidentiality level</a> of the [=Formal Objections=].

	If there were [=Formal Objections=], at least some of which were [=upheld=],
	or if there is not [=consensus=] because of insufficient support,
	[=W3C Decision=] <em class=rfc2119>must</em> be one of:

	<ul>
		<li>
			The proposal is returned for additional work,
			with a request to the initiator to improve the proposal.

		<li>
			The proposal is rejected.
	</ul>

	If the proposal has [=consensus=],
	or if any [=Formal Objections=] are retracted or overruled
	and the proposal otherwise has sufficient support to achieve [=consensus=],
	this [=W3C Decision=] <em class=rfc2119>must</em> be one of:

	<ul>
		<li>
			The proposal is adopted,
			possibly with additional changes integrated
			in order to address the comments of the [=AC=]
			(see below).

		<li>
			The proposal is returned for additional work,
			with a request to the initiator to make desirable changes identified during the review
			and to resubmit.
	</ul>

	If the proposal is adopted with changes other than <a href="#class-1">class 1 (markup) changes</a>,
	then those changes <em class=rfc2119>must</em> be announced to the [=AC=]
	and to the [=Group=] that owns the document (if any).

	Additionally, when adopting a proposal with [=substantive changes=] integrated,
	the announcement <em class="rfc2119">must</em> include rationale
	for the substantive changes,
	and those changes must have the [=consensus=]
	of the subset of the [=AC=] that voted on the proposal
	(including anyone who explicitly abstained).
	For publications which have conditions in addition to [=AC=] approval
	for introducing [=substantive changes=]
	(such as [=Group=] consensus or implementation experience),
	those other conditions must also be re-fulfilled.

	<div class="example">
		For example, to make [=substantive changes=] to a [=Proposed Recommendations=],
		the [=technical report=] could be returned to [=Candidate Recommendation=].
		Alternatively, the desired changes can be introduced as non-substantive amendments
		using the process for [[#revising-rec|revising a Recommendation]].
		However, they cannot be directly integrated between [=PR=] and [=REC=],
		because that would fail to trigger a patent exclusion opportunity.
	</div>

	This document does not specify
	time intervals between the end of an [=Advisory Committee review=] period
	and the [=W3C decision=].
	This is to ensure that the Members and [=Team=]
	have sufficient time to consider comments
	gathered during the review.
	The [=Advisory Committee=] <em class="rfc2119">should not</em> expect an announcement
	sooner than <span class="time-interval">two weeks</span> after the end of a review period.
	If, after <span class="time-interval">three weeks</span>, the outcome has not been announced,
	the [=Team=] <em class="rfc2119">should</em> provide the [=Advisory Committee=] with an update.

<h3 id="ACVotes">
Advisory Committee Votes</h3>

	The [=Advisory Committee=] votes in <a href="#AB-TAG-elections">elections for seats on the TAG or Advisory Board</a>,
	and in the event of an [=Advisory Committee Appeal=]
	achieving the required support to trigger an appeal vote.
	Whenever the [=Advisory Committee=] votes,
	each Member or group of [=related Members=] has one vote.

<h3 id="ACAppeal">
Appeal by Advisory Committee Representatives</h3>

	[=Advisory Committee representatives=] <em class="rfc2119">may</em> appeal certain decisions,
	though appeals are only expected to occur in extraordinary circumstances.

	When a [=W3C decision=] is made following an [=Advisory Committee review=],
	[=Advisory Committee representatives=] <em class="rfc2119">may</em> initiate
	an <dfn export lt="Advisory Committee Appeal|AC Appeal| Appeal">Advisory Committee Appeal</dfn>.
	These [=W3C decisions=] include those related to group creation and modification,
	and transitions to new maturity stages for Recommendation Track documents
	and the Process document.

	[=Advisory Committee representatives=] <em class="rfc2119">may</em> also initiate an appeal
	for decisions of a [=W3C Council=], and
	for certain decisions that do not involve an [=Advisory Committee review=].
	These cases are identified in the sections
	which describe the requirements for the decision
	and include
	additional (non-reviewed) maturity stages of Recommendation Track documents,
	group [=charter extensions=] and closures,
	and [=Memoranda of Understanding=].

	In all cases,
	an [=appeal=] <em class="rfc2119">must</em> be initiated within <span class="time-interval">three weeks</span> of the decision.

	An [=Advisory Committee representative=] initiates an [=appeal=] by sending a request to the [=Team=],
	and should also share this request with the [=Advisory Committee=].
	The request should say “I appeal this Decision”
	and identify the decision,
	and may also include their rationale for appealing the decision.

	Note: See [[DECISION-APPEAL inline]] for a recommendation
	on how to communicate an appeal request to the [=Team=] and the [=AC=].

	Within one week the [=Team=] <em class="rfc2119">must</em> announce the appeal process
	to the [=Advisory Committee=]
	and provide a mechanism for [=Advisory Committee representatives=]
	to respond with a statement of positive support for this appeal.
	The archive of these statements <em class="rfc2119">must</em> be [=member-only=].
	If, within <span class="time-interval">one week</span> of the Team's announcement,
	5% or more of the [=Advisory Committee=] support the appeal request,
	the Team <em class="rfc2119">must</em> organize an appeal vote
	asking the [=Advisory Committee=]
	“Do you approve of the Decision?”
	together with links to the decision and the appeal support.

	The ballot <em class="rfc2119">must</em> allow for three possible responses:
	“Approve”,
	“Reject”,
	and “Abstain”,
	together with Comments.

	If the number of votes to reject
	exceeds the number of votes to approve,
	the decision is overturned.
	In that case, there are the following possible next steps:

	<ol>
		<li>
			The proposal is rejected.

		<li>
			The proposal is returned for additional work,
			after which the applicable decision process is re-initiated.
	</ol>

<h2 id="Reports">
W3C Technical Reports</h2>

	The W3C technical report development process is the set of steps and requirements
	followed by W3C [=Working Groups=] to standardize Web technology.
	The W3C technical report development process is designed to:

	<ul>
		<li>
			support multiple specification development methodologies

		<li>
			maximize [=consensus=] about the content of stable technical reports

		<li>
			ensure high technical and editorial quality

		<li>
			promote consistency among specifications

		<li>
			facilitate royalty-free, interoperable implementations of Web Standards, and

		<li>
			earn endorsement by W3C and the broader community.
	</ul>

	See also “licensing goals for W3C Specifications”
	in the W3C Patent Policy [[PATENT-POLICY]].

<h3 id="recs-and-notes">
Types of Technical Reports</h3>

	This chapter describes the formal requirements
	for [=publishing=] and maintaining a [=W3C Recommendation=],
	[=Note=],
	or [=Registry Report=].

	<dl>
		<dt>Recommendations
		<dd>
			[=Working Groups=] develop technical reports on the [=W3C Recommendation Track=]
			in order to produce normative specifications or guidelines
			as standards for the Web.
			The [=Recommendation Track=] process incorporates requirements for [=wide review=],
			[=adequate implementation experience=],
			and [=consensus=]-building,
			and is subject to the W3C Patent Policy [[PATENT-POLICY]],
			under which participants commit to Royalty-Free IPR licenses for implementations.
			See [[#rec-track]] for details.

		<dt>Notes
		<dd>
			Groups can also publish documents as [=W3C Notes=] and [=W3C Statements=],
			typically either to document information
			other than technical specifications,
			such as use cases motivating a specification
			and best practices for its use.
			See [[#note-track]] for details.

		<dt>Registries
		<dd>
			[=Working Groups=] can also publish [=registries=]
			in order to document collections of values or other data.
			These are typically published in a separate [=registry report=],
			although they can also be directly embedded in [=Recommendation Track=] documents
			as a [=registry section=].
			[=registry definition|Defining a registry=] requires [=wide review=] and [=consensus=],
			but once set up, changes to registry entries are lightweight
			and can even be done without a [=Working Group=].
			See [[#registries]] for details.
	</dl>

	Individual [=Working Groups=] and [=Interest Groups=]
	<em class="rfc2119">should</em> adopt additional processes
	for developing publications,
	so long as they do not conflict with the requirements in this chapter.

<h3 id="general-requirements">
General Requirements for Technical Reports</h3>

<h4 id=publication>
Publication of Technical Reports</h4>

	<dfn id="publishing" lt="publish">Publishing</dfn> as used in this document
	refers to producing a version which is listed as a W3C <dfn export>Technical Report</dfn>
	on its <a href="https://www.w3.org/TR/">Technical Reports index at https://www.w3.org/TR</a> [[TR]].
	Every document published as part of the technical report development process
	<em class="rfc2119 old">must</em> be a public document.
	W3C strives to make archival documents indefinitely available
	at their original address in their original form.

	Every document published as part of the technical report development process
	<em class="rfc2119 old">must</em> clearly indicate its <a href="#maturity-stages">maturity stage</a>,
	and <em id="DocumentStatus" class="rfc2119">must</em> include information about the status of the document.
	This status information:

	<ul>
		<li>
			<em class="rfc2119">must</em> be unique each time a specification is [=published=],

		<li>
			<em class="rfc2119">must</em> state which [=Working Group=] developed the specification,

		<li>
			<em class="rfc2119">must</em> state how to send comments or file bugs,
			and where these are recorded,

		<li>
			<em class="rfc2119">must</em> include expectations about next steps,

		<li>
			<em class="rfc2119">should</em> explain how the technology relates to existing international standards
			and related work inside or outside W3C,
			and

		<li>
			<em class="rfc2119">should</em> explain
			or link to
			an explanation of significant changes from the previous version.
	</ul>

	Every Technical Report published
	as part of the Technical Report development process
	is edited by one or more editors
	appointed by a Group [=Chair=].
	It is the responsibility of these editors to ensure that the decisions of the Group are
	correctly reflected in subsequent drafts of the technical report.
	An editor <em class="rfc2119">must</em> be a participant,
	per <a href="#group-participation"></a>
	in the Group responsible for the document(s) they are editing.

	The Team is <em class="rfc2119">not required</em> to publish a [=Technical Report=]
	that does not conform to the Team's <a href="https://www.w3.org/pubrules/">Publication Rules</a> [[!PUBRULES]]
	(e.g., for <span id="DocumentName">naming</span>,
	status information,
	style,
	and <span id="document-copyright">copyright requirements</span>).
	These rules are subject to change by the Team from time to time.
	The Team <em class="rfc2119">must</em> inform group [=Chairs=]
	and the [=Advisory Committee=]
	of any changes to these rules.

	The primary language for W3C [=Technical Reports=] is English.
	W3C encourages the translation of its [=Technical Reports=].
	<a href="https://www.w3.org/Consortium/Translation/">Information about translations of W3C technical reports</a> [[TRANSLATION]]
	is available at the W3C website.

<h4 id="doc-reviews">
Reviews and Review Responsibilities</h4>

	A document is available for review
	from the moment it is first [=published=].
	Working Groups <em class="rfc2119">should</em> [=formally address=]
	<em>any</em> substantive review comment
	about a technical report in a timely manner.

	Reviewers <em class="rfc2119">should</em> send substantive technical reviews as early as possible.
	[=Working Groups=] are often reluctant to make [=substantive changes=] to a mature document,
	particularly if this would cause significant compatibility problems
	due to existing implementation.
	[=Working Groups=] <em class="rfc2119">should</em> record substantive
	or interesting proposals raised by reviews
	but not incorporated into a current specification.

<h5 id="wide-review">
Wide Review</h5>

	The requirements for <dfn id=dfn-wide-review export>wide review</dfn> are not precisely defined by the W3C Process.
	The objective is to ensure that the entire set of stakeholders of the Web community,
	including the general public,
	have had adequate notice of the progress of the [=Working Group=]
	(for example through notices posted to <a href="https://lists.w3.org/Archives/Public/public-review-announce/">public-review-announce@w3.org</a>)
	and were able to actually perform reviews of and provide comments on the specification.
	A second objective is to encourage groups to request reviews
	early enough that comments and suggested changes
	can still be reasonably incorporated in response to the review.
	Before approving transitions,
	the [=Team=] will consider who has been explicitly offered
	a reasonable opportunity to review the document,
	who has provided comments,
	the record of requests to and responses from reviewers,
	especially <a href="https://www.w3.org/Guide/process/charter.html#horizontal-review">W3C Horizontal Groups</a> [[CHARTER]]
	and groups identified as dependencies in the charter
	or identified as <a href="https://www.w3.org/2001/11/StdLiaison.html">liaisons</a> [[LIAISON]],
	and seek evidence of clear communication to the general public
	about appropriate times and which content to review
	and whether such reviews actually occurred.

	For example,
	inviting review of new or significantly revised sections published in Working Drafts,
	and tracking those comments
	and the [=Working Group=]'s responses,
	is generally a good practice which would often be considered positive evidence of wide review.
	[=Working Groups=]
	<em class="rfc2119">should</em> follow the <a href="https://www.w3.org/Guide/documentreview/#how_to_get_horizontal_review">W3C Horizontal Groups</a>’ review processes,
	and <em class="rfc2119">should</em> announce to other W3C Working Groups
	as well as the general public,
	especially those affected by this specification,
	a proposal to enter [=Candidate Recommendation=]
	(for example in approximately 28 days).
	By contrast a generic statement in a document
	requesting review at any time
	is likely not to be considered as sufficient evidence
	that the group has solicited wide review.

	A [=Working Group=] could present evidence that wide review has been received,
	irrespective of solicitation.
	But it is important to note that receiving many detailed reviews
	is not necessarily the same as wide review,
	since they might only represent comment
	from a small segment of the relevant stakeholder community.

<h4 id="correction-classes">
Classes of Changes</h4>


	This document distinguishes the following 5 classes of changes to a document.
	The first two classes of change are considered <dfn lt="editorial change">editorial changes</dfn>,
	the next two <dfn lt="substantive change">substantive changes</dfn>,
	and the last one <dfn lt="registry change">registry changes</dfn>.

	<dl>
		<dt id=class-1>
			1. No changes to text content
		<dd>
			These changes include fixing broken links, style sheets, or invalid markup.

		<dt id=class-2>
			2. Changes that do not functionally affect interpretation of the document
		<dd>
			For [=Recommendation-track=] [=technical reports=] specifically,
            this constitutes changes that do not affect conformance,
            i.e. changes that reasonable implementers
			would not interpret as changing architectural
			or interoperability requirements
			or their implementation.
			Changes which resolve ambiguities in the specification
			are considered to change (by clarification) the implementation requirements
			and do not fall into this class.
		<dd>
			Examples of changes in this class include
			correcting non-normative examples
			which clearly conflict with normative requirements,
			clarifying informative use cases or other non-normative text,
			fixing typos or grammatical errors
			where the change does not change requirements.
		<dd>
			If there is any doubt or disagreement
			as to whether a change functionally affects interpretation,
			that change does not fall into this class.

		<dt id=class-3>
			3. Other changes that do not add new features
		<dd>
			For [=Recommendation-track=] documents,
            these changes <em class="rfc2119">may</em> affect conformance to the specification.
			A change that affects conformance is one that:

			<ul>
				<li>
					makes conforming data, processors, or other conforming agents become non-conforming according to the new version,
					or
				<li>
					makes non-conforming data, processors, or other agents become conforming,
					or
				<li>
					clears up an ambiguity or under-specified part of the specification
					in such a way that data,
					a processor,
					or an agent
					whose conformance was once unclear
					becomes clearly either conforming or non-conforming.
			</ul>

		<dt id=class-4>
			4. New features
		<dd>
			Changes that add new functionality,
			such as new elements, new APIs, new rules, etc.

		<dt id=class-5>
			5. Changes to the contents of a [=registry table=]
		<dd>
			Changes that add, remove, or alter [=registry entries=] in a [=registry table=].
	</dl>

<h4 id="errata">
Errata Management</h4>

	Tracking errors is an important part of a [=Working Group=]'s ongoing care of a [=technical report=];
	for this reason,
	the scope of a [=Working Group=] charter generally allows time
	for work after publication of a [=Recommendation=].
	In this Process Document,
	the term “<dfn lt="erratum | errata" export>erratum</dfn>”
	(plural “errata”) refers to any error
	that can be resolved by one or more changes in classes 1-3
	of section [[#correction-classes]]</a>.

	[=Working Groups=] <em class="rfc2119">must</em> keep
	a public record of errors
	that are reported by readers and implementers
	for [=Recommendations=].
	Such error reports <em class="rfc2119">should</em> be compiled
	no less frequently than quarterly.

	[=Working Groups=] decide how to document errata.
	Such documentation <em class="rfc2119">must</em> identify
	the affected [=technical report=] text
	and describe the error;
	it <em class="rfc2119">may</em> also describe some possible solution(s).
	Readers of the [=technical report=] <em class="rfc2119">should</em> be able easily
	to find and see the errata
	that apply to that specific [=technical report=] with their associated tests.
	Errata <em class="rfc2119">may</em> be documented
	in a separate errata page or tracking system.
	They <em class="rfc2119">may</em>,
	in addition or alternatively,
	be annotated inline
	alongside the affected [=technical report=] text
	or at the start or end of the most relevant section(s).

<h4 id=candidate-amendments oldids=candidate-changes>
Candidate Amendments</h4>

	An [=erratum=] <em class="rfc2119">may</em> be accompanied by an informative,
	<dfn>candidate correction</dfn> approved by [=group decision=].
	When annotated inline,
	errata--
	including their [=candidate corrections=]--
	must be marked as such,
	are treated as <a href="#correction-classes">class 2 changes</a>,
	and are published accordingly.

	Note: Annotating changes in this way allows more mature documents
	such as [=Recommendations=] and [=Candidate Recommendations=]
	to be updated quickly with the Working Group's most current thinking,
	even when the [=candidate amendments=] have not yet received
	sufficient review or implementation experience
	to be normatively incorporated into the specification proper.

	A <dfn>candidate addition</dfn> is similar to a [=candidate correction=],
	except that it proposes a new feature
	rather than an error correction.

	If there is no group chartered to maintain a [=technical report=],
	the [=Team=] <em class="rfc2119">may</em> maintain its [=errata=]
	and associated [=candidate corrections=].
	Such corrections <em class=rfc2119>must</em> be marked
	as <dfn>Team correction</dfn>,
	and do not constitute
	a normative portion of the Recommendation,
	as defined in the Patent Policy [[PATENT-POLICY]]
	(i.e. they are not covered by the Patent Policy).
	The [=Team=] <em class=rfc2119>must</em> solicit [=wide review=]
	on [=Team corrections=] that it produces.

	[=Candidate corrections=] and [=candidate additions=] are collectively known as
	<dfn lt="candidate amendment">candidate amendments</dfn>.

	In addition to their actual [[#maturity-stages|maturity stage]],
	[=published=] [=REC Track=] documents with [=candidate amendments=] are also considered,
	for the purpose of the W3C Patent Policy [[PATENT-POLICY]],
	to be [=Working Drafts=] with those [=candidate amendments=] treated as normative.

<h4 id="contributor-license">
License Grants from Non-Participants</h4>

	When a party who is not already obligated under the Patent Policy
	offers a change in class 3 or 4
	(as described in [[#correction-classes]]) to a technical report under this process
	the [=Team=] <em class=rfc2119>must</em> request
	a recorded royalty-free patent commitment;
	for a change in class 4, the Team <em class=rfc2119>must</em> secure such commitment.
	Such commitment <em class=rfc2119>should</em> cover,
	at a minimum,
	all the party's Essential Claims both in the contribution,
	and that become Essential Claims as a result of incorporating the contribution into the draft
	that existed at the time of the contribution,
	on the terms specified in the “W3C Royalty-Free (RF) Licensing Requirements” section of the W3C Patent Policy [[PATENT-POLICY]].


<h3 id=rec-track oldids="rec-advance">
The W3C Recommendation Track</h3>

	[=Working Groups=] create specifications and guidelines
	to complete the scope of work envisioned by a [=Working Group=]'s [=charter=].
	These [=technical reports=] undergo cycles of revision and review
	as they advance towards [=W3C Recommendation=] status.
	Once review suggests the Working Group has met their requirements for a new standard,
	including [=wide review=],
	a [=Candidate Recommendation=] phase
	allows the [=Working Group=] to formally collect <a href="#implementation-experience">implementation experience</a>
	to demonstrate that the specification works in practice.
	At the end of the process,
	the Advisory Committee reviews the mature technical report,
	and if there is support from its Membership,
	W3C publishes it as a <a href="#RecsW3C">Recommendation</a>.

	In summary, the <dfn lt="W3C Recommendation Track | REC Track | Recommendation Track | Recommendation-track">W3C Recommendation Track</dfn> consists of:

	<ol>
		<li>Publication of the [=First Public Working Draft=].
		<li>Publication of zero or more revised [=Working Drafts=].
		<li>Publication of one or more [=Candidate Recommendations=].
		<li>Publication of a [=Proposed Recommendation=].
		<li>Publication as a [=W3C Recommendation=].
	</ol>

	<div role="region" aria-label="Basic W3C Recommendation Track">
		<pre class=include-raw>
			path: basic-rec-track.svg
		</pre>
	</div>

	This Process defines certain [=Recommendation Track=] publications as <dfn>Patent Review Drafts</dfn>.
	Under the 2004 Patent Policy (and its 2017 update) [[!PATENT-POLICY-2004]],
	these correspond to “Last Call Working Draft” in the Patent Policy;
	Starting from the 2020 Patent Policy [[!PATENT-POLICY-2020]],
	these correspond to “Patent Review Draft” in the Patent Policy [[!PATENT-POLICY]].

	W3C <em class="rfc2119">may</em> <a href="#tr-end">end work on a technical report</a> at any time.

	As described in [[#transition-reqs]],
	the [=Team=] will decline a request to advance in maturity stage
	and return the specification to a [=Working Group=] for further work
	if it determines that the requirements for advancement
	have not been met.

<h4 id="maturity-stages" oldids="maturity-levels">
Maturity Stages on the Recommendation Track</h4>

	<dl>
		<dt>
			<dfn id="RecsWD" export lt="W3C Working Draft | Working Draft | WD">Working Draft</dfn> (<abbr>WD</abbr>)
		<dd>
			A Working Draft is a document that W3C has [=published=]
			on the <a href="https://www.w3.org/TR/">W3C's Technical Reports page</a> [[TR]]
			for review by the community (including W3C Members), the public,
			and other technical organizations,
			and for simple historical reference.
			Some, but not all, Working Drafts are meant to advance to [=Recommendation=];
			see the <a href="#DocumentStatus">document status section</a> of a Working Draft
			for the group's expectations.
			[=Working Drafts=] do not necessarily represent a [=consensus=] of the [=Working Group=] with respect to their content,
			and do not imply any endorsement by W3C
			or its members beyond agreement to work on a general area of technology.
			Nevertheless the [=Working Group=] decided to adopt the [=Working Draft=]
			as the basis for their work at the time of adoption.
			A [=Working Draft=] is suitable for gathering [=wide review=]
			prior to advancing to the next stage of maturity.

			For all Working Drafts a Working Group:

			<ul>
				<li>
					<em class="rfc2119">should</em> document outstanding issues,
					and parts of the document on which the Working Group does not have consensus,
					and

				<li>
					<em class="rfc2119">may</em> request publication of a Working Draft
					even if its content is considered unstable
					and does not meet all Working Group requirements.
			</ul>

			The first Working Draft of a technical report is called the <dfn export id=fpwd>First Public Working Draft</dfn> (<abbr>FPWD</abbr>),
			and has patent implications as defined in the W3C Patent Policy [[!PATENT-POLICY]].

		<dt>
			<dfn id="RecsCR" export lt="W3C Candidate Recommendation | Candidate Recommendation | CR">Candidate Recommendation</dfn> (<abbr>CR</abbr>)
		<dd>
			A Candidate Recommendation is a document that satisfies the technical
			requirements of the Working Group that produced it and their dependencies,
			and has already received wide review.
			W3C publishes a Candidate Recommendation to

			<ul>
				<li>
					signal to the wider community that it is time to do a final review
				<li>
					gather <a href="#implementation-experience">implementation experience</a>
			</ul>

			Note: Advancing to [=Candidate Recommendation=] indicates
			that the document is considered complete and fit for purpose,
			and that no further refinement to the text is expected
			without additional implementation experience and testing;
			additional features in a later revision may however be expected.
			A [=Candidate Recommendation=] is expected to be as well-written,
			detailed,
			self-consistent,
			and technically complete
			as a [=Recommendation=],
			and acceptable as such
			if and when the requirements for further advancement are met.

			Candidate Recommendation publications take one of two forms:

			<dl>
				<dt>
					<dfn export lt="Candidate Recommendation Snapshot | CRS">Candidate Recommendation Snapshot</dfn> (<abbr>CRS</abbr>)
				<dd>
					A Candidate Recommendation Snapshot
					corresponds to a [=Patent Review Draft=]
					as used in the W3C Patent Policy [[!PATENT-POLICY]].
					Publishing a [=Patent Review Draft=] triggers a Call for Exclusions,
					per “Exclusion From W3C RF Licensing Requirements”
					in the W3C Patent Policy.

					Publication as a [=Candidate Recommendation Snapshot=]
					requires verification of either a [=Transition Request=]
					(for the first [=Candidate Recommendation=] publication from another maturity stage)
					or an [=Update Request=]
					(for subsequent [=Candidate Recommendation Snapshots=]).
				<dt>
					<dfn export lt="Candidate Recommendation Draft | CRD">Candidate Recommendation Draft</dfn> (<abbr>CRD</abbr>)
				<dd>
					A Candidate Recommendation Draft
					is published on the <a href="https://www.w3.org/TR/">W3C's Technical Reports page</a> [[TR]]
					to integrate changes from the previous [=Candidate Recommendation Snapshot=]
					that the Working Group intends to include
					in a subsequent [=Candidate Recommendation Snapshot=].
					This allows for wider review of the changes
					and for ease of reference to the integrated specification.

					Any changes published directly into a [=Candidate Recommendation Draft=]
					should be at the same level of quality as a [=Candidate Recommendation Snapshot=].
					However, the process requirements are minimized
					so that the Working Group can easily keep the specification up to date.

					A [=Candidate Recommendation Draft=]
					<em>does not</em> provide an exclusion opportunity;
					instead, it is considered a [=Working Draft=]
					for the purpose of the <a href="https://www.w3.org/Consortium/Patent-Policy">W3C Patent Policy</a> [[PATENT-POLICY]].
			</dl>

			A <dfn>Rescinded Candidate Recommendation</dfn>
			is a [=Candidate Recommendation=] in which significant problems have been discovered
			such that W3C cannot endorse it or continue work on it,
			for example due to burdensome patent claims that affect implementers and cannot be resolved
			(see the W3C Patent Policy [[PATENT-POLICY]]
			and in particular “PAG Conclusion”).
			There is no path to restoration for a [=Rescinded Candidate Recommendation=].
			See “W3C Royalty-Free (RF) Licensing Requirements”
			in the W3C Patent Policy [[!PATENT-POLICY]]
			for implication on patent licensing obligations.

		<dt>
			<dfn export id="RecsPR" lt="W3C Proposed Recommendation | Proposed Recommendation | PR">Proposed Recommendation</dfn> (<abbr>PR</abbr>)
		<dd>
			A Proposed Recommendation is a document
			that has been accepted by W3C
			as of sufficient quality to become a [=W3C Recommendation=].
			This phase triggers formal review by the [=Advisory Committee=],
			who <em class="rfc2119">may</em> recommend
			that the document be [=published=] as a [=W3C Recommendation=],
			returned to the [=Working Group=] for further work,
			or abandoned.
			[=Substantive changes=] <em class="rfc2119">must not</em> be made to a [=Proposed Recommendation=]
			except by [=publishing=] a new [=Working Draft=] or [=Candidate Recommendation=].

		<dt>
			<dfn id="RecsW3C" export lt="W3C Recommendation | Recommendation | REC">W3C Recommendation</dfn> (<abbr>REC</abbr>)
		<dd>
			A W3C Recommendation is a specification
			or set of guidelines
			or requirements that,
			after extensive [=consensus=]-building,
			has received the endorsement of W3C and its Members.
			W3C recommends the wide deployment
			of its Recommendations as standards for the Web.
			The W3C Royalty-Free IPR licenses
			granted under the W3C Patent Policy [[PATENT-POLICY]]
			apply to [=W3C Recommendations=].
			As technology evolves,
			a [=W3C Recommendation=] may become:
			<dl>
				<dt>
					A <dfn export id="RecsSup">Superseded Recommendation</dfn>
				<dd>
					A Superseded Recommendation is a specification
					that has been replaced by a newer version
					that W3C recommends for new adoption.
					An [=Obsolete Recommendation|Obsolete=] or Superseded specification
					has the same status as a [=W3C Recommendation=]
					with regards to W3C Royalty-Free IPR Licenses granted under the Patent Policy.

					Note: When a Technical Report which had previously been published as a [=Recommendation=]
					is again published as a [=Recommendation=]
					after following the necessary steps to <a href="#revising-rec">revise</a> it,
					the latest version replaces the previous one,
					without the need to invoke the steps of [[#rec-rescind]]:
					it is the same document, updated.
					Explicitly declaring a documented superseded, using the process documented in [[#rec-rescind]],
					is intended for cases where a [=Recommendation=] is superseded by a separate [=Technical Report=]
					(or by a document managed outside of W3C).

				<dt>
					An <dfn export id="RecsObs">Obsolete Recommendation</dfn>
				<dd>
					An Obsolete Recommendation is a specification
					that W3C has determined lacks sufficient market relevance
					to continue recommending it for implementation,
					but which does not have fundamental problems
					that would require it to be [=Rescinded Recommendation|Rescinded=].
					If an Obsolete specification gains sufficient market relevance,
					W3C may decide to restore it to [=Recommendation=] status.

				<dt>
					<dfn export id="RescindedRec">Rescinded Recommendation</dfn>
				<dd>
					A Rescinded Recommendation is an entire Recommendation that W3C no longer endorses,
					and believes is unlikely to ever be restored to [=Recommendation=] status.
					See also “W3C Royalty-Free (RF) Licensing Requirements”
					in the W3C Patent Policy [[!PATENT-POLICY]].
			</dl>
		<dt>
			<dfn id="discontinuedREC" export >Discontinued Draft</dfn>
		<dd>
			A [=technical report=] representing the state of a Recommendation-track document
			at the point at which work on it was discontinued.
			See [[#abandon-draft]].

	</dl>

	Only sufficiently technically mature work should be advanced.

	Note: Should faster advancement to meet scheduling considerations be desired,
	this can be achieved by reducing the scope of the technical report to a subset that is adequately mature and deferring
	less stable features to other technical reports.

	When publishing an updated version of an existing [=Candidate Recommendation=] or [=Recommendation=],
	technical reports are expected to meet the same maturity criteria as when they are first published under that status.
	However, in the interest of replacing stale documents with improved ones in a timely manner,
	if flaws have been discovered in the technical report after its initial publication as a [=CR=] or [=REC=]
	that would have been severe enough to reject that publication had they be known in time,
	it is also permissible to publish an updated [=CR=] or [=REC=] following the usual process,
	even if only some of these flaws have been satisfactorily addressed.

	[=Working Groups=] and [=Interest Groups=] <em class="rfc2119">may</em> make available [=Editor's drafts=].
	<dfn export lt="Editor's Draft | Editor Draft | ED">Editor's drafts</dfn> (<abbr>ED</abbr>) have no official standing whatsoever,
	and do not necessarily imply consensus of a [=Working Group=] or [=Interest Group=],
	nor are their contents endorsed in any way by W3C.

<h4 id="implementation-experience">
Implementation Experience</h4>

	Implementation experience is required to show that a specification is sufficiently clear,
	complete,
	and relevant to market needs,
	to ensure that independent interoperable implementations
	of each feature of the specification will be realized.
	While no exhaustive list of requirements is provided here,
	when assessing that there is <dfn id="adequate-implementation">adequate implementation experience</dfn>
	the [=Team=] will consider (though not be limited to):

	<ul>
		<li>
			is each feature of the current specification implemented,
			and how is this demonstrated?

		<li>
			are there independent interoperable implementations of the current specification?

		<li>
			are there implementations created by people other than the authors of the specification?

		<li>
			are implementations publicly deployed?

		<li>
			is there implementation experience
			at all levels of the specification's ecosystem
			(authoring, consuming, publishing…)?

		<li>
			are there reports of difficulties or problems with implementation?
	</ul>

	Planning and accomplishing a demonstration of (interoperable) implementations can be very time consuming.
	Groups are often able to work more effectively
	if they plan how they will demonstrate interoperable implementations
	early in the development process;
	for example, developing tests in concert with implementation efforts.


<h4 id="transition-reqs">
Advancement on the Recommendation Track</h4>

	For <em>all</em> requests to advance a specification
	to a new maturity stage
	(called <dfn id=trans-req export>Transition Requests</dfn>),
	the Working Group:

	<ul>
		<li>
			<em class="rfc2119">must</em> record the group's decision to request advancement.

		<li>
			<em class="rfc2119">must </em> obtain [=Team=] verification.
			[=Team=] verification (a [=Team decision=])
			<em class=rfc2119>must</em> be withheld if any Process requirements are not met
			or if there remain any unresolved Formal Objections
			(including any [=upheld=] by a [=Council=] but not yet [=fully addressed=]),
			or if the document does not adequately reflect all relevant decisions of the [=W3C Council=] (or its delegates).
			If the [=Team=] rejects a [=Transition Request=]
			it <em class=rfc2119>must</em> indicate its rationale
			to the [=Advisory Committee=] and the [=Working Group=].

		<li>
			<em class="rfc2119 ">must</em> publicly document all new features
			(<a href="#correction-classes">class 4 changes</a>) to the technical report
			since the previous publication.

		<li>
			<em class="rfc2119">must</em> publicly document if other substantive changes
			(<a href="#correction-classes">class 3 changes</a>) have been made,
			and <em class="rfc2119">should</em> document the details of such changes.

		<li>
			<em class="rfc2119">should</em> publicly document if [=editorial changes=] have been made,
			and <em class="rfc2119">may</em> document the details of such changes.
		<li>
			<em class="rfc2119">must</em> [=formally address=] all issues
			raised about the document since the previous <a href="#maturity-stages">maturity stage</a>.

		<li>
			<em class="rfc2119">must</em> provide public documentation of any [=Formal Objections=].

		<li>
			<em class="rfc2119">should</em> report which, if any, of the [=Working Group=]'s requirements
			for this document have changed since the previous step.

		<li>
			<em class="rfc2119">should</em> report any changes in dependencies with other groups.

		<li>
			<em class="rfc2119">should</em> provide information about implementations known to the [=Working Group=].
	</ul>

	For a [=First Public Working Draft=] there is no “previous maturity stage”,
	so many requirements do not apply,
	and verification is normally fairly straightforward.
	For later stages,
	especially transition to [=Candidate Recommendation|Candidate=] or [=Proposed Recommendation=],
	there is usually a formal review meeting
	to verify that the requirements have been met.

	[=Transition Requests=] to [=First Public Working Draft=]
	or [=Candidate Recommendation=]
	will not normally be approved
	while a [=Working Group=]'s [=charter=] is undergoing or awaiting a decision
	on an [=Advisory Committee Review=].</p>

<h4 id="update-reqs">
Updating Mature Publications on the Recommendation Track</h4>

	Certain requests to re-publish a specification
	within its current maturity stage
	(called <dfn export>Update Requests</dfn>)
	require extra verification.
	For such [=update requests=], the Working Group:

	<ul>
		<li>
			<em class="rfc2119">must</em> record the group's decision to request the update.

		<li>
			<em class="rfc2119">must</em> show that the changes have received [=wide review=].

		<li>
			<em class="rfc2119">must </em> obtain [=Team=] verification,
			or fulfill the criteria for [[#streamlined-update]].
			[=Team=] verification (a [=Team decision=]),
			<em>should</em> be withheld if any Process requirements are not met,
			and <em class=rfc2119>may</em> be withheld in consideration of unresolved Formal Objections
			(including any [=upheld=] by a [=Council=] but not yet [=fully addressed=])
			or if the document does not adequately reflect all relevant decisions of the [=W3C Council=] (or its delegates).
			If the [=Team=] rejects an [=Update Request=],
			it must indicate its rationale to the [=Working Group=].
			If it waives any Process requirements,
			it must indicate its rationale to the [=AC=].


		<li>
			<em class="rfc2119">must</em> provide public documentation of any [=Formal Objections=].

		<li>
			<em class="rfc2119 ">must</em> publicly document of all new features
			(<a href="#correction-classes">class 4 changes</a>) to the technical report
			since the previous publication.

		<li>
			<em class="rfc2119">must</em> publicly document if other substantive changes
			(<a href="#correction-classes">class 3 changes</a>) have been made,
			and <em class="rfc2119">should</em> document the details of such changes.

		<li>
			<em class="rfc2119">should</em> publicly document if [=editorial changes=] changes have been made,
			and <em class="rfc2119">may</em> document the details of such changes.

		<li>
			<em class="rfc2119">must</em> show that the revised specification
			meets all [=Working Group=] requirements,
			or explain why the requirements have changed or been deferred,

		<li>
			<em class="rfc2119">should</em> report which, if any, of the [=Working Group=]'s requirements
			for this document have changed since the previous step.

		<li>
			<em class="rfc2119">should</em> report any changes in dependencies with other groups.

		<li>
			<em class="rfc2119">should</em> provide information about implementations known to the [=Working Group=].
	</ul>

	There is usually a formal review meeting
	to verify that the requirements have been met.

	Note: [=Update request=] verification is expected to be fairly simple
	compared to verification of a [=transition request=].

	The [=Team=] <em class="rfc2119">must</em> announce the publication
	of the revised specification
	to other W3C groups and the Public.


<h5 id="streamlined-update">
Streamlined Publication Approval</h5>

	Note: These criteria are intentionally stricter than
	the general requirements for an [=update request=].
	This is in order to minimize ambiguities and the need for expert judgment,
	and to make self-evaluation practical.

	In order to streamline the publication process in non-controversial cases,
	verification of an [=update request=] is automatically granted without formal review
	when the following <em>additional</em> criteria are fulfilled:

	<ul>
		<li>
			There <em class=rfc2119>must</em> have been no changes to [=Working Group=] requirements about this document.

		<li>
			For each of the
			<a href="https://www.w3.org/Guide/process/charter.html#horizontal-review">W3C Horizontal Groups</a> [[CHARTER]],
			if the Horizontal Review Group has made available a set criteria
			under which their review is not necessary,
			the [=Working Group=] <em class=rfc2119>must</em> document that these criteria have been fulfilled.
			Otherwise, the [=Working Group=] <em class=rfc2119>must</em> show
			that review from that group has been solicited and received.

		<li>
			No [=Formal Objection=] has been registered against the document.

		<li>
			The [=Working Group=] <em class=rfc2119>must</em>
			have [=formally addressed=]:
			* all issues raised against the document that resulted in changes since the previous publication
			* all issues raised against changes since the previous publication
			* all issues raised against the document that were closed since the previous publication with no change to the document

			The response to each of these issues <em class=rfc2119>must</em> be to the satisfaction
			of the person who raised it:
			their proposal has been accepted,
			or a compromise has been found,
			or they accepted the Working Group's rationale for rejecting it.

			Note: This is stricter than the general Transition Request criteria.
	</ul>

	Additionally, for updates to [=Recommendations=]
	with <a href="#revised-rec-substantive">substantive changes</a>
	or <a href="#revised-rec-features">with new features</a>:

	<ul>

		<li>
			Changes to the document are limited to
			[=proposed corrections=] that were included in a [=Last Call for Review of Proposed Corrections=]
			possibly combined with <a href=#correction-classes>class 1 or 2 changes</a>,
			and/or (in the case of a [=Recommendation=] that [=allow new feature|allows new features=])
			[=proposed additions=] that were included in a [=Last Call for Review of Proposed Additions=].

		<li>
			The [=Working Group=] <em class=rfc2119>must</em> show
			that all changes have been implemented in at least 2 distinct products by 2 different implementers,
			as evidenced by passing tests of a test suite
			providing extensive coverage of the changes,
			or an alternative streamlined verification implementation requirement
			described in the [=working Group=] charter has been met.

			Note: This is stricter than the general criteria for [=adequate implementation experience=].
	</ul>

	The [=Working Group=] must provide written evidence for these claims,
	and the [=Team=] must make these answers publicly and permanently available.

	After publication,
	if an AC Representative
	or Team member
	doubts that the evidence presented supports the claims,
	they <em class=rfc2119>may</em> request that a formal review meeting be convened post facto.
	If that review finds that the requirements were not fulfilled,
	the Team <em class=rfc2119>may</em> revert the changes
	by updating in place the status section to indicate that it has been reverted,
	and by republishing the previously approved version of the technical report.

<h4 id="first-wd">
Publishing a First Public Working Draft</h4>

	To publish the [=First Public Working Draft=] of a document,
	a [=Working Group=] <em class="rfc2119">must</em> meet the applicable <a href="#transition-reqs">requirements for advancement</a>.

	The [=Team=] <em class="rfc2119">must</em> announce
	the publication of a [=First Public Working Draft=]
	to other W3C groups and to the public.

<h4 id="revising-wd" oldids="revised-wd">
Revising a Working Draft</h4>

	A [=Working Group=] <em class="rfc2119">should</em> [=publish=] a [=Working Draft=]
	to the W3C Technical Reports page
	when there have been significant changes
	to the previous published document
	that would benefit from review beyond the Working Group.

	If 6 months elapse without significant changes to a specification,
	a Working Group <em class="rfc2119">should</em> publish a revised [=Working Draft=],
	whose status section <em class="rfc2119">should</em> indicate reasons for the lack of change.

	To publish a revision of a Working draft, a Working Group:

	<ul>
		<li>
			<em class="rfc2119">must</em> record the group's decision to request publication.
			[=Consensus=] is not required,
			as this is a procedural step,

		<li>
			<em class="rfc2119">must</em> provide public documentation
			of [=substantive changes=] to the technical report
			since the previous [=Working Draft=],

		<li>
			<em class="rfc2119">should</em> provide public documentation
			of significant [=editorial changes=] to the technical report
			since the previous step,

		<li>
			<em class="rfc2119">should</em> report which,
			if any,
			of the Working Group's requirements for this document
			have changed since the previous step,

		<li>
			<em class="rfc2119">should</em> report any changes in dependencies with other groups,
	</ul>

	Possible next steps for any Working Draft:

	<ul>
		<li>Revised <a href="#revising-wd">Working Draft</a>
		<li><a href="#transition-cr">Candidate Recommendation</a>
		<li><a href="#abandon-draft">Discontinued Draft</a></li>
	</ul>

<h4 id="transition-cr" oldids="candidate-rec, last-call">
Transitioning to Candidate Recommendation</h4>

	To publish a [=Candidate Recommendation=],
	in addition to meeting the <a href="#transition-reqs">requirements for advancement</a>
	a [=Working Group=]:

	<ul>
		<li>
			<em class="rfc2119">must</em> show that the specification
			has met all [=Working Group=] requirements,
			or explain why the requirements have changed or been deferred,

		<li>
			<em class="rfc2119">must</em> document changes to dependencies during the development of the specification,

		<li>
			<em class="rfc2119">must</em> document
			how [=adequate implementation experience=] will be demonstrated,

		<li>
			<em class="rfc2119">must</em> specify the deadline for comments,
			delineating the <dfn>Candidate Recommendation review period</dfn>,
			which <em class="rfc2119">must</em> be <strong>at least</strong> 28 days after publication,
			and <em class="rfc2119">should</em> be longer for complex documents,

		<li>
			<em class="rfc2119">must</em> show that the specification has received [=wide review=], and

		<li>
			<em class="rfc2119">may</em> identify features in the document as <dfn export>at risk</dfn>.
			These features <em class="rfc2119">may</em> be removed
			before advancement to [=Proposed Recommendation=]
			without a requirement to publish a new [=Candidate Recommendation=].
	</ul>

	The first Candidate Recommendation publication
	after verification of having met the requirements for a [=Transition Request=]
	is always a [=Candidate Recommendation Snapshot=].
	The [=Team=] <em class="rfc2119">must</em> announce
	the publication of the [=Candidate Recommendation Snapshot=]
	to other W3C groups
	and to the public.

	Possible next steps after a [=Candidate Recommendation Snapshot=]:

	<ul>
		<li>Return to <a href="#revising-wd">Working Draft</a></li>
		<li>A revised <a href="#publishing-crrs">Candidate Recommendation Snapshot</a></li>
		<li>A revised <a href="#publishing-crud">Candidate Recommendation Draft</a></li>
		<li><a href="#transition-pr">Proposed Recommendation</a></li>
		<li><a href="#abandon-draft">Discontinued Draft</a></li>
	</ul>

	[=Advisory Committee=] representatives <em class="rfc2119">may</em> initiate an
	<a href="#ACAppeal">Advisory Committee Appeal</a> of the decision to advance the technical report.

<h4 id=revising-cr oldids="revised-cr">
Revising a Candidate Recommendation</h4>

<h5 id="publishing-crrs">
Publishing a [=Candidate Recommendation Snapshot=]</h5>

	If there are any [=substantive changes=] made to a [=Candidate Recommendation=]
	since the previous [=Candidate Recommendation Snapshot=]
	other than to remove features explicitly identified as [=at risk=],
	the [=Working Group=] <em class="rfc2119">must</em>
	meet the requirements of an [=update request=] in order to republish.

	In addition the Working Group:

	<ul>
		<li>
			<em class="rfc2119">must</em> specify the deadline for further comments,
			which <em class="rfc2119">must</em> be <strong>at least</strong> 28 days after publication,
			and <em class="rfc2119">should</em> be longer for complex documents,

		<li>
			<em class="rfc2119">may</em> identify features in the document as [=at risk=].
			These features <em class="rfc2119">may</em> be removed
			before advancement to [=Proposed Recommendation=]
			without a requirement to publish a new [=Candidate Recommendation=].
	</ul>

	The [=Team=] <em class="rfc2119">must</em> announce
	the publication of a revised [=Candidate Recommendation Snapshot=]
	to other W3C groups
	and to the public.

	To provide timely updates and patent protection,
	a [=Candidate Recommendation Snapshot=]
	<em class=rfc2119>should</em> be published
	within 24 months of the Working Group accepting
	any proposal for a substantive change
	(and preferably sooner).
	To make scheduling reviews easier,
	a [=Candidate Recommendation Snapshot=] <em class=rfc2119>should not</em> be published
	more often than approximately once every 6 months.

	Note: [=Substantive changes=] trigger a new Exclusion Opportunity
	per “Exclusion From W3C RF Licensing Requirements”
	in the W3C Patent Policy [[!PATENT-POLICY]].

<h5 id="publishing-crud">
Publishing a [=Candidate Recommendation Draft=]</h5>

	A [=Working Group=] <em class="rfc2119">should</em> [=publish=] an [=Candidate Recommendation Draft|Update Draft=]
	to the W3C Technical Reports page
	when there have been significant changes
	to the previous published document
	that would benefit from review beyond the Working Group.


	To publish a revision of a [=Candidate Recommendation Draft=],
	a Working Group:

	<ul>
		<li>
			<em class="rfc2119">must</em> record the group's decision to request publication,

		<li>
			<em class="rfc2119">must</em> provide public documentation
			of [=substantive changes=] to the technical report
			since the previous [=Candidate Recommendation Snapshot=],

		<li>
			<em class="rfc2119">should</em> provide public documentation
			of significant [=editorial changes=] to the technical report
			since the previous [=Candidate Recommendation Snapshot=],

		<li>
			<em class="rfc2119">should</em> document outstanding issues,
			and parts of the document on which the Working Group does not have consensus,

		<li>
			<em class="rfc2119">should</em> report which,
			if any,
			of the Working Group's requirements for this document
			have changed since the previous step,

		<li>
			<em class="rfc2119">should</em> report any changes in dependencies with other groups.

	</ul>

	Note: A Working Group <em>does not</em> need to
	meet the requirements of a [=Candidate Recommendation Snapshot=] [=update request=]
	in order to publish a [=Candidate Recommendation Draft=].

	Possible next steps after a [=Candidate Recommendation Draft=]:

	<ul>
		<li>Return to <a href="#revising-wd">Working Draft</a></li>
		<li>A revised <a href="#publishing-crrs">Candidate Recommendation Snapshot</a></li>
		<li>A revised <a href="#publishing-crud">Candidate Recommendation Draft</a></li>
		<li><a href="#transition-pr">Proposed Recommendation</a>,
		if there are no [=substantive change=] other than dropping [=at risk=] features</li>
		<li><a href="#abandon-draft">Discontinued Draft</a></li>
	</ul>


<h4 id=transition-pr oldids="rec-pr">
Transitioning to Proposed Recommendation</h4>

	In addition to meeting the <a href="#transition-reqs">requirements for advancement</a>,

	<ul>
		<li>
			The status information <em class="rfc2119">must</em> specify the deadline for [=Advisory Committee review=],
			which <em class="rfc2119">must</em> be <strong>at least</strong> 28 days
			after the publication of the [=Proposed Recommendation=]
			and <em class="rfc2119">should</em> be at least 10 days
			after the end of the last Exclusion Opportunity
			per ”Exclusion From W3C RF Licensing Requirements”
			in the W3C Patent Policy [[!PATENT-POLICY]].
	</ul>

	A Working Group:

	<ul>
		<li>
			<em class="rfc2119">must</em> show [=adequate implementation experience=]
			except where an exception is approved by a [=Team Decision=],
		<li>
			<em class="rfc2119">must</em> show that the document has received [=wide review=],

		<li>
			<em class="rfc2119">must</em> show that all issues
			raised during the [=Candidate Recommendation review period=]
			have been [=formally addressed=],

		<li>
			<em class="rfc2119">must </em>identify any substantive issues
			raised since the close of the [=Candidate Recommendation review period=],

		<li>
			<em class=rfc2119>must not</em> have made any [=substantive changes=] to the document
			since the most recent [=Candidate Recommendation Snapshot=],
			other than dropping features identified [=at risk=].

		<li>
			<em class="rfc2119">may</em> have removed features
			identified in the [=Candidate Recommendation Snapshot=] document as [=at risk=]
			without republishing the specification as a [=Candidate Recommendation Snapshot=].
	</ul>

	The [=Team=]:

	<ul>
		<li>
			<em class="rfc2119">must</em> announce the publication of a [=Proposed Recommendation=]
			to the <a href="#AC">Advisory Committee</a>,
			and <em class="rfc2119">must</em> begin an [=Advisory Committee Review=]
			on the question of whether the specification is appropriate to [=publish=] as a [=W3C Recommendation=].

		<li>
			<em class="rfc2119">may</em> approve a [=Proposed Recommendation=]
			with minimal <a href="#implementation-experience">implementation experience</a>
			where there is a compelling reason to do so.
			In such a case, the [=Team=] <em class="rfc2119">must</em> explain the reasons for that decision,
			and that information <em class=rfc2119>must</em> be included in the [=Call for Review=]
			proposing advancement to [=W3C Recommendation=].
	</ul>

	Since a [=W3C Recommendation=] <em class="rfc2119">must not</em> include any [=substantive changes=]
	from the [=Proposed Recommendation=] it is based on,
	to make any [=substantive change=] to a [=Proposed Recommendation=]
	the [=Working Group=] <em class="rfc2119">must</em> return the specification to [=Candidate Recommendation=]
	or [=Working Draft=].

	<p id="expandable-rec">
	A [=Proposed Recommendation=] may identify itself
	as intending to <dfn>allow new features</dfn>
	(<a href="#correction-classes">class 4 changes</a>)
	after its initial publication as a [=Recommendation=],
	as described in [[#revised-rec-features]].
	Such an allowance cannot be added
	to a [=technical report=] previously published as a [=Recommendation=]
	that did not allow such changes.

	Possible Next Steps:

	<ul>
		<li>
			Return to <a href="#revising-wd">Working Draft</a>

		<li>
			Return to <a href="#transition-cr">Candidate Recommendation</a>

		<li>
			<a href="#transition-rec">Recommendation status</a>,
			(the expected next step).

		<li>
			<a href="#abandon-draft">Discontinued Draft</a></li>
	</ul>

	[=Advisory Committee representatives=] <em class="rfc2119">may</em> initiate an [=Advisory Committee Appeal=]
	of the decision to advance the technical report.

<h4 id="transition-rec" oldids="rec-publication">
Transitioning to W3C Recommendation</h4>

	The decision to advance a document to [=Recommendation=]
	is a [=W3C Decision=].

	In addition to meeting the <a href="#transition-reqs">requirements for advancement</a>,

	<ul>
		<li>
			A [=Recommendation=] <em class="rfc2119">must</em> identify where errata are tracked, and

		<li>
			A [=Recommendation=] <em class="rfc2119">must not</em> include any [=substantive changes=]
			from the [=Proposed Recommendation=]
			on which it is based.

		<li>
			If there was any [=dissent=] in Advisory Committee reviews,
			the [=Team=] <em class="rfc2119">must</em> publish the substantive content of the dissent
			to W3C and the general public,
			and <em class="rfc2119">must</em> [=formally address=] the comment
			at least 14 days before publication as a [=W3C Recommendation=].

		<li>
			[=Advisory Committee representatives=] <em class="rfc2119">may</em> initiate
			an [=Advisory Committee Appeal=]
			of the [=W3C decision=]

		<li>
			The [=Team=] <em class="rfc2119">must</em> announce the publication of a [=W3C Recommendation=]
			to <a href="#AC">Advisory Committee</a>,
			other W3C groups
			and to the public.
	</ul>

	Possible next steps:
	A [=W3C Recommendation=] normally retains its status indefinitely.
	However it <em class="rfc2119">may</em> be:

	<ul>
		<li>
			republished as a <a href="#revising-rec">revised Recommendation</a>, or

		<li>
			republished as a <a href="#transition-cr">Candidate Recommendation</a>
			to be developed towards a revised [=Recommendation=], or

		<li>
			declared <a href="#rec-rescind">superseded or obsolete</a>, or

		<li>
			<a href="#rec-rescind">rescinded</a>.
	</ul>

<h4 id=revising-rec oldids="rec-modify, revised-rec">
Revising a W3C Recommendation</h4>

	This section details the process for making changes to a [=Recommendation=].

<h5 id="revised-rec-markup">
Revising a Recommendation: Markup Changes</h5>

	A [=Working group=] <em class="rfc2119">may</em> request republication of a [=Recommendation=]
	to make corrections that do not result
	in any changes to the text of the specification.
	(See <a href="#correction-classes">class 1 changes</a>.)

	If there is no [=Working Group=] chartered to maintain a [=Recommendation=],
	the [=Team=] <em class="rfc2119">may</em> republish the [=Recommendation=]
	with such changes incorporated.

<h5 id="revised-rec-editorial">
Revising a Recommendation: Editorial Changes</h5>

	[=Editorial changes=] to a [=Recommendation=] require no technical review of the intended changes.
	A [=Working Group=],
	provided there are no votes against the [=group decision|decision=] to publish,
	<em class="rfc2119">may</em> request publication of a [=Recommendation=]
	to make this class of change without passing through earlier maturity stages.
	(See <a href="#correction-classes">class 2 changes</a>.)

	If there is no [=Working Group=] chartered to maintain a [=Recommendation=],
	the [=Team=] <em class="rfc2119">may</em> republish the [=Recommendation=]
	with such changes incorporated,
	including [=errata=] and [=Team corrections=].

<h5 id="revised-rec-substantive">
Revising a Recommendation: Substantive Changes</h5>

	A [=candidate correction=] can be made normative
	and be folded into the main text of the [=Recommendation=],
	once it has satisfied all the same criteria
	as the rest of the [=Recommendation=],
	including review by the community to ensure
	the technical and editorial soundness of the [=candidate amendments=].
	To validate this, the [=Working Group=] must request
	a [=Last Call for Review of Proposed Amendments=],
	followed by an [=update request=].
	See [[#change-review]].

	Alternatively,
	a [=Working Group=] <em class="rfc2119">may</em> incorporate the changes
	and <a href="#revising-wd">publish as a Working Draft</a>--
	or, if the relevant criteria are fulfilled,
	<a href="#transition-cr">publish as a Candidate Recommendation</a>--
	and advance the specification from that state.
	(See <a href="#correction-classes">class 3 changes</a>.)

	Note: If there is no [=Working Group=] chartered to maintain a [=Recommendation=]
	the [=Team=] cannot make substantive changes and republish the [=Recommendation=].
	It can, however, informatively highlight problems and desirable changes
	using [=errata=] and [=candidate corrections=]
	and republish as described in [[#revised-rec-editorial|the previous section]].

<h5 id="revised-rec-features">
Revising a Recommendation: New Features</h5>

	New features (see <a href="#correction-classes">class 4 changes</a>)
	may be incorporated into a [=Recommendation=]
	explicitly identified as [=allow new features|allowing new features=]
	using [=candidate additions=].
	A [=candidate addition=] can be made normative
	and be folded into the main text of the [=Recommendation=]
	using the same process as for [=candidate amendments=],
	as detailed in [[#revised-rec-substantive]].

	Note: This prohibition against new features unless explicitly allowed
	enables third parties to depend on Recommendations having a stable feature-set,
	as they have prior to the 2020 revision of this Process.

	To make changes which introduce a new feature
	to a [=Recommendation=] that does not [=allow new features=],
	W3C <em class="rfc2119">must</em> create a new [=technical report=],
	following the full process of <a href="#rec-advance">advancing a technical report to Recommendation</a>
	beginning with a new [=First Public Working Draft=].

<h5 id=change-review>
Incorporating Candidate Amendments</h5>

	A <dfn id=last-call-review>Last Call for Review of Proposed Amendments</dfn>
	verifies acceptance by the W3C community of [=candidate amendments=]
	by combining an [=AC Review=] with a patent exclusion opportunity.

	The <a>Last Call for Review of Proposed Amendments</a>
	must be announced to other W3C groups, the public, and the [=Advisory Committee=].
	The announcement <em class="rfc2119">must</em>:
	<ul>
		<li>
			Identify whether this is a
			<dfn>Last Call for Review of Proposed Corrections</dfn>,
			<dfn>Last Call for Review of Proposed Additions</dfn>,
			or <dfn>Last Call for Review of Proposed Corrections and Additions</dfn>.

		<li>
			Identify the specific [=candidate amendments=] under review
			as <dfn>proposed amendments</dfn>
			(<dfn>proposed corrections</dfn>/<dfn oldids="proposed-addition">proposed additions</dfn>).

		<li>
			Specify the deadline for review comments,
			which must not be any sooner than 60 days from the Call for Review.

		<li>
			Solicit review and, if it does not already have it, implementation experience.
	</ul>

	The combination of the existing [=Recommendation=]
	with the [=proposed amendments=] included in the [=Last Call for Review of Proposed Amendments=]
	is considered a [=Patent Review Draft=]
	for the purposes of the Patent Policy [[PATENT-POLICY]].
	Also, the review initiated by the [=Last Call for Review of Proposed Amendments=]
	is an [=Advisory Committee Review=].

	Note: [=Last Call for Review of Proposed Additions=] and
	[=Last Call for Review of Proposed Corrections and Additions=]
	can only be issued for [=Recommendations=] that [=allow new features=].

	A [=Working Group=] <em class="rfc2119">may</em> batch
	multiple [=proposed amendments=] into a single <a>Last Call for Review of Proposed Amendments</a>.
	To facilitate review,
	a <a>Last Call for Review of Proposed Amendments</a> on a given specification
	<em class=rfc2119>should not</em> be issued more frequently
	than approximately once every 6 months.

	At the end of the <a>Last Call for Review of Proposed Amendments</a>,
	the [=W3C Decision=] may either be
	to reject the [=proposed amendment=],
	or to clear the [=proposed amendment=] for advancement as is,
	or to return the proposal to the [=Working Group=] with a request to [=formally address=]
	comments made on the changes under review.
	If the [=Working Group=] needs to amend a [=proposed amendment=]
	in response to review feedback
	it must issue another <a>Last Call for Review of Proposed Amendments</a> on the revised change
	before it can be incorporated into the main text.

	Once all comments on a [=proposed amendment=] have been [=formally addressed=],
	and after the [=Working Group=] can show [=adequate implementation experience=]
	and the fulfillment of all other requirements of Recommendation text,
	it may incorporate the [=proposed amendment=] into the normative [=Recommendation=]
	by issuing an [=update request=] for publication of the updated [=Recommendation=].

	To ensure adequate review of [=proposed amendment=] combinations,
	only [=proposed amendments=] included in the most recent
	[=Last Call for Review of Proposed Amendments=]
	can be incorporated into the normative [=Recommendation=] text.
	(Thus if incorporation of a [=proposed amendment=] is postponed,
	it may need to be included in multiple Last Calls for Review of Proposed Amendments.)

<h4 id=rec-track-regression>
Regression on the Recommendation Track</h4>

	A [=Working Group=] may republish a [=Recommendation-track=] [=technical report=] at a lower <a href="#maturity-stages">maturity stage</a>
	by fulfilling the requirements to transition to that maturity stage,
	as described above.

	Additionally,
	with the approval of the [=TAG=] and the [=AB=]
	the [=Team=] <em class="rfc2119">may</em> return
	the [=technical report=] to a lower <a href="#maturity-stages">maturity stage</a>
	in response to [=wide review=] or a [=formal objection=].

<h4 id="tr-end">
Retiring Recommendation Track Documents</h4>

	Work on a technical report <em class="rfc2119">may</em> cease at any time.
	Work <em class="rfc2119 new">should</em> cease
	if W3C or a [=Working Group=] determines
	that it cannot productively carry the work any further.

	<h5 id=abandon-draft>
Abandoning an Unfinished Recommendation</h5>

	Any [=Recommendation-track=] [=technical report=] no longer intended
	to advance or to be maintained,
	and that is not being rescinded,
	<em class="rfc2119">should</em> be [=published=]
	as a [=Discontinued Draft=],
	with no [=substantive change=] compared to the previous publication.
	This can happen if
	the [=Working Group=] decided
	to abandon work on the report,
	or as the result of an [=AC Review=] requiring the [=Working Group=]
	to discontinue work on the technical report before completion.
	If a [=Working Group=] is made to <a href="#GeneralTermination">close</a>,
	W3C <em class="rfc2119">must</em> re-[=publish=] any unfinished [=technical report=]
	on the Recommendation track as [=Discontinued Draft=].

	Such a document should include in its status section
	an explanation of why it was discontinued.

	A [=Working Group=] <em class="rfc2119">may</em> resume work
	on such a [=technical report=]
	within the scope of its charter
	at any time,
	by re-[=publishing=] it as a [=Working Draft=].

<h5 id=rescind-cr>
Rescinding a Candidate Recommendation</h5>

	The process for rescinding a [=Candidate Recommendation=]
	is the same as for rescinding a [=Recommendation=].

<h5 id="rec-rescind">
Abandoning a W3C Recommendation</h5>

	It is possible that W3C decides
	that implementing a particular [=Recommendation=] is no longer recommended.
	There are three designations for such specifications,
	chosen depending on the advice W3C wishes to give about further use of the specification.

	W3C <em class="rfc2119">may</em> obsolete a [=Recommendation=],
	for example if the W3C Community decides that the [=Recommendation=] no longer represents best practices,
	or is not adopted and is not apparently likely to be adopted.
	An [=Obsolete Recommendation=] <em class="rfc2119">may</em> be restored to normal [=Recommendation=],
	for example because despite marking it Obsolete the specification is later more broadly adopted.

	W3C <em class="rfc2119">may</em> declare a Recommendation Superseded
	if a newer version exists which W3C recommends for new adoption.
	The process for declaring a Recommendation Superseded is the same as for declaring it Obsolete, below;
	only the name and explanation change.

	W3C <em class="rfc2119">may</em> rescind a Recommendation
	if W3C believes there is no reasonable prospect of it being restored
	for example due to burdensome patent claims that affect implementers and cannot be resolved;
	see the W3C Patent Policy [[!PATENT-POLICY]]
	and in particular “W3C Royalty-Free (RF) Licensing Requirements”
	and “PAG Conclusion”.

	W3C only rescinds, supersedes, or obsoletes entire Recommendations.
	A [=Recommendation=] can be both superseded and obsolete.
	To rescind, supersede, or obsolete some part of a Recommendation,
	W3C follows the process for <a href="#revising-rec">modifying a Recommendation</a>.


	Note: For the purposes of the W3C Patent Policy
	[[PATENT-POLICY]]
	an [=Obsolete Recommendation|Obsolete=] or [=Superseded Recommendation=] has the status of an active [=Recommendation=],
	although it is not recommended for future implementation;
	a [=Rescinded Recommendation=] ceases to be in effect
	and no new licenses are granted under the Patent Policy.

	<div role="region" aria-label="Retiring a W3C Recommendation">
		<pre class=include-raw>
			path: retiring-rec.svg
		</pre>
	</div>

<h5 id="deactivation">
Process for Rescinding, Obsoleting, Superseding, Restoring a Recommendation</h5>

	The process of rescinding, obsoleting,
	superseding,
	or restoring
	a [=Recommendation=] can be initiated
	either by a request from the [=Team=]
	or via a request from any of the following:

	<ul>
		<li>
			The [=Working Group=] who produced,
			or is chartered to maintain,
			the [=Recommendation=]

		<li>
			The [=TAG=], if there is no such [=Working Group=]

		<li>
			Any individual who made a request to the relevant [=Working Group=] as described above,
			or the [=TAG=] if such a group does not exist, to obsolete, rescind, supersede, or restore a [=Recommendation=],
			where the request was not answered within 90 days

		<li>
			5% of the members of the Advisory Committee
	</ul>

	<p id="proposed-rescinded-rec">The [=Team=] <em class="rfc2119">must</em> then
	submit the request to the <a href="#AC">Advisory Committee</a> for review.
	For any [=Advisory Committee review=] of a proposal to
	rescind,
	obsolete,
	supersede,
	or restore
	a [=Recommendation=] the [=Team=] <em class="rfc2119">must</em>:

	<ul>
		<li>
			announce the proposal to all [=Working Group=] [=Chairs=],
			and to the Public,
			as well as to the [=Advisory Committee=]

		<li>
			indicate that this is a proposal to
			Rescind,
			Obsolete,
			Supersede,
			or restore,
			a [=Recommendation=] as appropriate

		<li>
			identify the [=Recommendation=] by URL

		<li>
			publish a rationale for the proposal

		<li>
			identify known dependencies
			and solicit review from all dependent [=Working Groups=]

		<li>
			solicit public review

		<li>
			specify the deadline for review comments,
			which <em class="rfc2119">must</em> be at least 28 days
			after the announcement
	</ul>

	and <em class="rfc2119">should</em>

	<ul>
		<li>
			identify known implementations.
	</ul>

	If there was any [=dissent=] in the [=Advisory Committee review=],
	the [=Team=] <em class="rfc2119">must</em> publish
	the substantive content of the dissent to W3C
	<strong>and the public</strong>,
	and <em class="rfc2119">must</em> [=formally address=] the dissent
	at least 14 days
	before publication as an [=Obsolete Recommendation|Obsolete=] or [=Rescinded Recommendation=].

	The <a href="#AC">Advisory Committee</a> <em class="rfc2119">may</em> initiate an [=Advisory Committee Appeal=]
	of the [=Team=]'s decision.

	W3C <em class="rfc2119">must</em> publish an [=Obsolete Recommendation|Obsolete=] or [=Rescinded Recommendation=]
	with up to date status.
	The updated version <em class="rfc2119">may</em> remove the main body of the document.
	The Status of this Document section <em class="rfc2119">should</em> link
	to the explanation of <a href="https://www.w3.org/2016/11/obsoleting-rescinding/">Obsoleting and Rescinding W3C Specifications</a> [[OBS-RESC]] as appropriate.

	Once W3C has published a Rescinded Recommendation,
	future W3C technical reports <em class="rfc2119">must not</em> include normative references
	to that technical report.

	Note: W3C strives to ensure that all Technical Reports
	will continue to be available at their version-specific URL.


<h3 id=note-track>
The Note Track (Notes and Statements)</h3>

<h4 id="Note">
Group Notes</h4>

	A <dfn export id="WGNote" lt="Group Note | Note | W3C Note | Working Group Note | Interest Group Note | AB Note | TAG Note">Group Note</dfn> (<abbr>NOTE</abbr>)
	is published
	to provide a stable reference for a useful document
	that is not intended to be a formal standard.

	[=Working Groups=],
	[=Interest Groups=],
	the [=TAG=]
	and the [=AB=]
	<em class="rfc2119">may</em> publish work as [=Notes=].
	Examples include:

	<ul>
		<li>
			supporting documentation for a specification,
			such as explanations of design principles
			or use cases and requirements

		<li>
			non-normative guides to good practices
	</ul>

	Some [=Notes=] are developed through successive <dfn lt="Draft Note">Draft Notes</dfn>
	before publication as a full [=Notes=],
	while others are [=published=] directly as a [=Note=].
	There are few formal requirements to [=publish=] a document as a [=Note=] or [=Draft Note=],
	and they have no standing as a recommendation of W3C
	but are simply documents preserved for historical reference.

	Note: The W3C Patent Policy [[PATENT-POLICY]]
	does not apply any licensing requirements or commitments for [=Notes=] or [=Draft Notes=].

<h4 id="publishing-notes">
Publishing Notes</h4>

	In order to publish a [=Note=] or [=Draft Note=],
	the group:

	<ul>
		<li>
			<em class="rfc2119">must</em> record their decision
			to request publication as a [=Note=] or [=Draft Note=], and

		<li>
			<em class="rfc2119">should</em> publish documentation
			of significant changes to the technical report
			since any previous publication.
	</ul>

	Both [=Notes=] and [=Draft Notes=] can be updated by republishing
	as a [=Note=] or [=Draft Note=].
	A [=technical report=] <em class="rfc2119">may</em> remain
	a [=Note=] indefinitely.

	If a [=Note=] produced by a [=chartered group=] is no longer in scope for any group,
	the [=Team=] <em class=rfc2119>may</em> republish the [=Note=] with [[#correction-classes|class 1]] changes incorporated,
	as well as with [=errata=] and [=Team corrections=] annotated.

<h4 id=w3c-statement oldids=memo>
Elevating Group Notes to W3C Statement status</h4>

	A <dfn lt="Statement | W3C Statement">W3C Statement</dfn> is a [=Note=]
	that has been endorsed by W3C as a whole.
	In order to elevate a [=Note=] to [=W3C Statement=] status,
	A group <em class=rfc2119>must</em>:

	<ul>
		<li>
			show that the document has received [=wide review=].

		<li>
			record the group’s decision to request publication as a [=W3C Statement=].

		<li>
			show that all issues raised against the document
			since its first publication as a [=Note=]
			have been [=formally addressed=].

		<li>
			provide public documentation of any [=Formal Objections=].
	</ul>

	A [=Note=] specifying implementable technology <em class=rfc2119>should not</em> be elevated to [=W3C Statement=] status;
	if it does,
	the request to publish as a [=Statement=] <em class=rfc2119>must</em> include rationale
	for why it should be elevated,
	and why it is not on the [=Recommendation track=].

	Once these conditions are fulfilled,
	the [=Team=] <em class=rfc2119>must</em> then
	begin an Advisory Committee Review on the question of
	whether the document is appropriate to publish as a [=W3C Statement=].
	During this review period,
	the [=Note=] <em class=rfc2119>must not</em> be updated.

	The decision to advance a document to [=W3C Statement=] is a [=W3C Decision=].
	[=Advisory Committee representatives=] may initiate an [=Advisory Committee Appeal=] of the decision.

	The [=Team=] must announce the publication of a [=W3C Statement=]
	to the [=Advisory Committee=], other W3C groups, and the public.

<h4 id=revising-memo>
Revising W3C Statements</h4>

	Given a recorded [=group decision=] to do so,
	groups can request publication of a [=W3C Statement=] with [=editorial changes=]--
	including [=candidate amendment=]--
	without any additional process.

	A [=candidate amendment=] can be folded into the main text of the [=W3C Statement=],
	once it has satisfied all the same criteria
	as the rest of the [=Statement=],
	including review by the community to ensure
	the substantive and editorial soundness of the [=candidate amendments=].
	To validate this, the group must request
	an [=Advisory Committee review=] of the changes it wishes to incorporate.
	The specific [=candidate amendments=] under review
	<em class=rfc2119>must</em> be identified as [=proposed amendments=]
	just as in a [=Last Call for Review of Proposed Corrections=].

	The decision to incorporate [=proposed amendments=] into [=W3C Statement=] is a [=W3C Decision=].
	[=Advisory Committee representatives=] may initiate an [=Advisory Committee Appeal=] of the decision.

<h3 id="registries">
The Registry Track</h3>

	A <dfn export>registry</dfn> documents a data set
	consisting of one or more associated <dfn export lt="registry table">registry tables</dfn>,
	each table representing an updatable collection
	of logically independent, consistently-structured <dfn export lt="registry entry">registry entries</dfn>.
	A registry has three associated components:
	<ul>
		<li>the [=registry definition=], defining how the [=registry tables=] are structured and maintained
		<li>one or more [=registry tables=], holding the data set represented by the [=registry=] (the <dfn>registry data</dfn>)
		<li>one or more referencing specifications, which make use of the [=registry=]
	</ul>

	The purposes of maintaining a [=registry=] can include:

	<dl>
		<dt>non-collision
		<dd>
			Avoiding the problem
			of two entities using the same value with different semantics.

		<dt>non-duplication
		<dd>
			Avoiding the problem
			of having two or more different values in use with the same semantics.

		<dt>information
		<dd>
			Providing a central index
			where anyone can find out
			what a value means
			and what its formal definition is
			(and where it is).

		<dt>submission
		<dd>
			Ease of adding new terms,
			including by stakeholders external to the [=custodian=] organization.

		<dt>consensus
		<dd>
			Promoting a clear consensus of the community on the terms.
	</dl>

	This section of the W3C Process provides a specialized process
	facilitating the publication and maintenance of such [=registry tables=],
	particularly those required by or closely related to [=W3C Recommendations=].

	Note: Not every table in a specification is a potential registry.
	If the intent or effect is that the table enumerates
	all the possibilities the authors of the specification expect or envisage,
	then the table by itself is enough.
	Similarly, if the table is managed by the Working Group
	and only updated as part of specification update,
	then the complexities of registry management are not needed.

<h4 id=reg-def>
Registry Definitions</h4>

	A <dfn export>registry definition</dfn>
	defines what each [=registry table=] is and how it is maintained.
	It <em class=rfc2119>must</em>:

	<ul>
		<li>
			Define the scope and purpose of each [=registry table=].

		<li>
			Define the fields of each [=registry table=]
			and their constraints
			(e.g. values must be drawn from a defined set, or be unique,
			or only reference publicly available resources,
			etc.)

		<li>
			 Define the policy for changes to existing entries, such as
			<ul>
				<li>whether entries can be deleted or deprecated
				<li>whether entries can be changed after being published, and what kinds of changes are allowed
				<li>whether previously-deleted unique identifiers can be re-used, or are reserved indefinitely
			</ul>

		<li>
			Define the method and criteria by which changes are proposed, approved, and incorporated.
			(For example, a [=registry=] could define
			that changes to [=registry entries=] can be proposed using a particular web form or email address,
			that they must be accompanied by certain background information,
			or that they do or do not need to be approved by any member of a particular Working Group.)

		<li>
			Identify the <dfn export>custodian</dfn> of the [=registry table=]:
			the entity to which requests for [=registry changes=] must be sent,
			and which is responsible for evaluating whether such requests
			satisfy the criteria defined in the [=registry definition=].

			The [=custodian=] may be the [=Working Group=], the [=Team=], or a delegated entity.
			The [=custodian=] for all [=registry tables=] in a single [=registry=]
			<em class=rfc2119>should</em> generally be the same entity.
	</ul>

<h4 id=reg-pub>
Publishing Registries</h4>

	[=Registries=] can be published either
	as a stand-alone [=technical report=] on the [=Registry Track=] called a <dfn>registry report</dfn>,
	or incorporated as part of a [=Recommendation=] as a <dfn>registry section</dfn>.

	A [=registry report=] or [=registry section=]
	is purely documentational,
	is not subject to the W3C Patent Policy,
	and <em class=rfc2119>must not</em> contain any requirements on implementations.
	For the purposes of the Patent Policy [[PATENT-POLICY]],
	any [=registry section=] in a [=Recommendation track=] document
	is not a normative portion of that specification.

	The [=registry report=] or [=registry section=] <em class=rfc2119>must</em>:
	<ul>
		<li>
			Clearly label the [=registry report=]/[=registry section|section=],
			its [=registry tables|tables=],
			and its [=registry definitions=] as such,
			including a link to [[#registries]] in this Process.

		<li>
			Include the [=registry definition=] for each of its [=registry tables=].

		<li>
			Provide the [=registry data=] by either:
			<ul>
				<li>
					Including the entire contents of each [=registry table=],
					either inline in the report
					(e.g. formatted as a table, or list, or other appropriate representation),
					or in a machine-readable file published as part of the [=technical report=],
					or (preferably) both.

				<li>
					Linking to one or more standalone [=Registry Data Reports=]
					containing the [=registry tables=]
					in human-readable form, machine-readable form,
					or (preferably) both.
			</ul>

		<li>
			Include, if the [=registry table=] is provided in a machine-readable file,
			a definition of the format of that file.
	</ul>

	The [=Team=] <em class="rfc2119">must</em> make available
	a means for interested parties to be notified of any updates to a [=registry table=].

	Note: Since the Process does not impose requirements
	on changes to the contents of a [=registry table=]
	other than those imposed by the [=registry definition=],
	acceptance of proposed [=registry changes=] on behalf of the [=custodian=] and
	publication of an updated [=registry report=] that contains
	only [=registry changes=] since the previous publication
	can be automated
	if satisfaction of those rules can be automatically verified.

	Rules for publication and advancement on the <dfn>Registry Track</dfn>
	are identical to that of the [=Recommendation Track=]
	with the following exceptions:

	<ul>
		<li>
			[=Registry reports=] are not subject to the [[PATENT-POLICY]],
			and therefore none of their publications correspond,
			to [=First Public Working Draft=],
			[=Working Draft=],
			or [=Patent Review Draft=]
			for the purposes of the [[PATENT-POLICY]].

		<li>
			For the same reason,
			there is no equivalent to [=Rescinded Recommendation=]
			nor to [=Rescinded Candidate Recommendation=] for [=Registries=].

		<li>
			The equivalent of [=Working Draft=] is called <dfn export>Draft Registry</dfn>.

		<li>
			The equivalent of [=Candidate Recommendation=] is called <dfn export>Candidate Registry</dfn>,
			with [=Candidate Recommendation Snapshot=] and [=Candidate Recommendation Draft=] corresponding to
			<dfn export>Candidate Registry Snapshot</dfn> and <dfn export>Candidate Registry Draft</dfn>.

		<li>
			The equivalent of [=W3C Recommendation=] is called <dfn export>W3C Registry</dfn>;
			[=Obsolete Recommendation=] and [=Superseded Recommendation=] correspond to
			<dfn export>Obsolete Registry</dfn> and <dfn export>Superseded Registry</dfn>.

		<li>
			There is no equivalent to the Proposed Recommendation phase.
			Instead,
			an [=Advisory Committee Review=] is started
			upon publication of each [=Candidate Registry Snapshot=].

		<li>
			Changes that add new features (i.e. [[#correction-classes|class 4 changes]]) are allowed
			in all [=W3C Registries=],
			without needing the to explicitly indicate that this is allowed.
	</ul>

<h4 id=reg-table-update>
Updating Registry Tables</h4>

	Changes to the contents of a [=registry table=] that are in accordance with the [=registry definition=],
	(i.e. [[#correction-classes|Class 5 changes]])
	can be made by re-publishing the [=technical report=] that contains the affected table,
	without needing to satisfy any other requirements for the publication
	(not even Working Group consensus, unless this is required by the [=registry definition=]).
	Such [=registry changes=] do not trigger new [=Advisory Committee Reviews=],
	nor Exclusion Opportunities,
	and do not require verification via an [=update request=],
	even for [=technical reports=] at maturities where this would normally be expected.
	Such publications can be made
	even in the absence of a [=Working Group=] chartered to maintain the registry
	when the [=custodian=] is another entity.

	Note: The custodian is only empowered to make [=registry changes=].
	If the Working Group establishing the registry wishes
	to empower the custodian to add commentary on individual entries,
	this needs to be part of the registry table’s definition.
	If other changes are desired,
	they must be requested of the responsible Working Group--
	or in the absence of a Working Group, of the Team.

	Changes to the [=registry tables=]
	made in accordance with [=candidate amendment|candidate=] or [=proposed amendments=] to the [=registry definition=]
	which would not be allowed by the unamended [=registry definition=]
	<em class=rfc2119>must</em> be identified as such.

<h4 id=reg-data-reports>
Registry Data Reports</h4>

	When the [=registry data=] is published in a separate [=technical report=]
	from its [=registry definition=],
	that [=technical report|report=] is called a <dfn>Registry Data Report</dfn>.
	This [=technical report=]:
	<ul>
		<li>
			<em class=rfc2119>Must</em> link to the [=registry definition=]
			establishing the [=registry tables=] that it contain.

		<li>
			<em class=rfc2119>May</em> contain informative introductory text, examples, and notes
			about the [=registry tables=] and [=registry entries|entries=] that it contains.
			(Changes to these parts are deemed to be [=editorial changes=]).
	</ul>

	[=Registry Data Reports=] do not have maturity stages in and of themselves;
	The maturity stage of the [=registry=] whose [=registry data|data=] they record
	is that of the [=technical report=] holding the [=registry definition=].

	Anytime a change is made to a [=registry definition=],
	the Working Group <em class=rfc2119>must</em> update and republish
	any document holding the corresponding [=registry tables=]
	to make it consistent with these changes.

	Given a recorded [=group decision=] to do so,
	the [=Working Group=]
	<em class=rfc2119>may</em> republish the [=Registry Data Report=] to incorporate
	[=editorial changes=].
	If there is no [=Working Group=] chartered to maintain this registry,
	the [=Team=] <em class=rfc2119>may</em> do so instead.

<h4 id=reg-ref-specifications>
Specifications that Reference Registries</h4>

	Registries document values,
	they do not define any architectural or interoperability requirements
	related to those values.
	All architectural and interoperability requirements
	pertaining to [=registry entries=]
	<em class=rfc2119>must</em> be contained in the specifications that reference the registry,
	and are therefore subject to the processes
	(including approval and intellectual property provisions)
	applicable to those referencing specifications.

	If there are entries that must be implemented,
	or any other such restrictions,
	they <em class=rfc2119>must</em> be defined or documented
	in the referencing specification
	without dependency on the registry.

	<div class=example>
		For example,
		“All implementations must implement the <code>Basic-Method</code> as defined in the registry”
		is not acceptable;
		a change to the definition of the <code>Basic-Method</code> in the registry would then affect conformance.
		Instead, the requirement must be complete in the specification,
		directly or by reference to another specification.
		For example
		“All implementations must recognize the name <code>Basic-Method</code>,
		and implement it as defined by section yy of IETF RFC xxxx”.
		(The Registry should nonetheless contain </code>Basic-Method</code> as an entry.)
	</div>

<h3 id="switching-tracks">
Switching Tracks</h3>

	Given a [=Group decision=] to do so,
	[=Working Groups=] can republish a [=technical report=]
	on a different track than the one it is on,
	under the following restrictions:

	<ul>
		<li>
			A [=technical report=] that is or was
			a [=W3C Recommendation=], [=W3C Statement=], or [=Patent Review Draft=]
			cannot switch tracks.

		<li>
			A [=technical report=] should not switch away from the [=Recommendation Track=]
			without due consideration of the Patent Policy implications
			and approval of W3C’s legal counsel
			if the [=Working Group=] envisions a likelihood of returning to it later.
	</ul>

	[=Technical reports=] that switch tracks start at
	their new track’s initial maturity stage,
	while retaining any established identity (url, shortname, etc.).

<h3 id="further-reading">
Further reading</h3>

	Refer to <a href="https://www.w3.org/Guide/transitions">"How to Organize a Recommendation Track Transition"</a> [[TRANSITION]]
	in the <a href="https://www.w3.org/Guide/">Art of Consensus</a> [[GUIDE]]
	for practical information about preparing for the reviews
	and announcements of the various steps,
	and <a href="https://www.w3.org/2002/05/rec-tips">tips on getting to Recommendation faster</a> [[REC-TIPS]].
	Please see also the <a href="https://www.w3.org/2003/01/republishing/">Requirements for modification of W3C Technical Reports</a> [[REPUBLISHING]].

<h2 id="dissemination"> <span id="chapterDissemination"></span>
Dissemination Policies</h2>

<h3 id=pub-com>
Public Communication</h3>

	The [=Team=] is responsible for managing communication within W3C
	and with the general public
	(e.g., news services, press releases, managing the website and access privileges, and managing calendars).
	Members <em class="rfc2119">should</em> solicit review by the Team
	prior to issuing press releases about their work within W3C.

	The [=Team=] makes every effort to ensure the persistence and availability of the following public information:

	<ul>
		<li>
			<a href="#Reports">W3C technical reports</a> whose publication has been approved.
			Per [[W3C-IPR inline]],
			W3C technical reports (and software) are available free of charge to the general public.

		<li>
			A <a href="https://www.w3.org/Consortium/mission">mission statement</a> [[MISSION]]
			that explains the purpose and mission of W3C,
			the key benefits for Members,
			and the organizational structure of W3C.

		<li>
			Legal documents,
			including the <a href="https://www.w3.org/Consortium/Agreement/Member-Agreement">Membership Agreement</a> [[MEMBER-AGREEMENT]]
			and documentation of any legal commitments W3C has with other entities.

		<li>
			The Process Document.

		<li>
			Public results of W3C activities and <a href="#GAEvents">Workshops</a>.
	</ul>

	To keep the Members abreast of W3C meetings,
	[=Workshops=],
	and review deadlines,
	the Team provides them with a regular (e.g., weekly) news service
	and maintains a <a href="https://www.w3.org/participate/eventscal">calendar</a> [[CALENDAR]]
	of official W3C events.
	Members are encouraged to send schedule and event information to the Team for inclusion on this calendar.

<h3 id="confidentiality-levels">
Confidentiality Levels</h3>

	There are three principal levels of access to W3C information
	(on the W3C website, in W3C meetings, etc.):
	public,
	Member-only,
	and Team-only.

	While much information made available by W3C is public,
	“<dfn export id="Member-only" lt="Member-Only">Member-only</dfn>” information
	is available to authorized parties only,
	including representatives of Member organizations,
	<a href="#invited-expert-wg">Invited Experts</a>,
	the Advisory Board,
	the TAG,
	and the Team.
	For example,
	the <a href="#WGCharter">charter</a> of some Working Groups
	<em class="rfc2119">may</em> specify a [=Member-only=] confidentiality level for group proceedings.

	“<dfn export id="Team-only" lt="Team-Only">Team-only</dfn>” information
	is available to the Team and other authorized parties.

	Those authorized to access [=Member-only=] and [=Team-only=] information:

	<ul>
		<li>
			<em class="rfc2119">must</em> treat the information as confidential within W3C,

		<li>
			<em class="rfc2119">must</em> use reasonable efforts to maintain the proper level of confidentiality, and

		<li>
			<em class="rfc2119">must not</em> release this information to the general public or press.
	</ul>

	The [=Team=] <em class="rfc2119">must</em> provide mechanisms
	to protect the confidentiality of [=Member-only=] information
	and ensure that authorized parties have proper access to this information.
	Documents <em class="rfc2119">should</em> clearly indicate
	whether they require [=Member-only=] confidentiality.
	Individuals uncertain of the confidentiality level of a piece of information
	<em class="rfc2119">should</em> contact the Team.

	[=Advisory Committee representatives=] <em class="rfc2119">may</em> authorize
	[=Member-only=] access to <a href="#member-rep">Member representatives</a>
	and other individuals employed by the Member
	who are considered appropriate recipients.
	For instance,
	it is the responsibility of the [=Advisory Committee representative=]
	and other employees
	and official representatives of the organization
	to ensure that Member-only news announcements
	are distributed for internal use only within their organization.
	Information about Member mailing lists is available
	in the <a href="https://www.w3.org/Member/Intro">New Member Orientation</a> [[INTRO]].

<h3 id="confidentiality-change">
Changing Confidentiality Level</h3>

	As a benefit of membership,
	W3C provides some [=Team-only=] and [=Member-only=] channels
	for certain types of communication.
	For example, [=Advisory Committee representatives=]
	can send <a href="#ACReview">reviews</a> to a [=Team-only=] channel.
	However, for W3C processes with a significant public component,
	such as the technical report development process,
	it is also important for information that affects decision-making to be publicly available.
	The Team <em class="rfc2119">may</em> need to communicate [=Team-only=] information to a Working Group or the public.
	Similarly, a Working Group whose proceedings are [=Member-only=]
	<em class="rfc2119">must</em> make public
	information pertinent to the technical report development process.

	This document clearly indicates which information <em class="rfc2119">must</em> be available to Members or the public,
	even though that information was initially communicated on [=Team-only=] or [=Member-only=] channels.
	Only the [=Team=] and parties authorized by the Team
	may change the level of confidentiality of this information.
	When doing so:

	<ol>
		<li>
			The [=Team=] <em class="rfc2119">must</em> use a version of the information
			that was expressly provided by the author for the new confidentiality level.
			In Calls for Review and other similar messages,
			the Team <em class="rfc2119">should</em> remind recipients to provide such alternatives.

		<li>
			The [=Team=] <em class="rfc2119">must not</em> attribute the version
			for the new confidentiality level to the author without the author's consent.

		<li>
			If the author has not conveyed to the [=Team=] a version
			that is suitable for another confidentiality level,
			the Team <em class="rfc2119">may</em> make available a version that reasonably communicates what is required,
			while respecting the original level of confidentiality,
			and without attribution to the original author.
	</ol>

<h2 id="GAEvents">
Workshops and Symposia</h2>

	The Team organizes <dfn id="EventsW" export>Workshops</dfn>
	and <dfn id="EventsS" export lt="Symposium | Symposia">Symposia</dfn>
	to promote early involvement in the development of W3C activities
	from Members and the public.

	The goal of a Workshop is usually
	either to convene experts and other interested parties for an exchange of ideas
	about a technology or policy,
	or to address the pressing concerns of W3C Members.
	Organizers of the first type of Workshop
	<em class="rfc2119">may</em> solicit position papers for the Workshop program
	and <em class="rfc2119">may</em> use those papers
	to choose attendees and/or presenters.

	The goal of a Symposium is usually
	to educate interested parties about a particular subject.

	The Call for Participation in a Workshop or Symposium
	<em class="rfc2119">may</em> indicate participation requirements or limits,
	and expected deliverables
	(e.g., reports and [=minutes=]).
	Organization of an event does not guarantee
	further investment by W3C in a particular topic,
	but <em class="rfc2119">may</em> lead to proposals for new activities or groups.

	Workshops and Symposia generally last one to three days.
	If a Workshop is being organized to address the pressing concerns of Members,
	the Team <em class="rfc2119">must</em> issue the Call for Participation
	no later than <span class="time-interval">six weeks</span>
	prior to the Workshop's scheduled start date.
	For other Workshops and Symposia,
	the Team <em class="rfc2119">must</em> issue a Call for Participation
	no later than <span class="time-interval">eight weeks</span>
	prior to the meeting's scheduled start date.
	This helps ensure that speakers and authors
	have adequate time to prepare position papers and talks.

<h2 id="Liaisons">
Liaisons</h2>

	W3C uses the term <dfn export>liaison</dfn>
	to refer to coordination of activities with a variety of organizations,
	through a number of mechanisms
	ranging from very informal
	(e.g., an individual from another organization participates in a W3C Working Group,
	or just follows its work)
	to mutual membership,
	to even more formal agreements.
	Liaisons are not meant to substitute for W3C membership.

	All liaisons <em class="rfc2119">must</em> be coordinated by the [=Team=]
	due to requirements for public communication;
	patent,
	copyright,
	and other IPR policies;
	confidentiality agreements;
	and mutual membership agreements.

	W3C <em class="rfc2119">may</em> negotiate
	[=technical agreements=] with another organization.
	For purposes of the W3C Process,
	a <dfn local-lt="agreement">technical agreement</dfn> is a formal contract,
	or a Memorandum of Understanding (<abbr id=mou>MoU</abbr>),
	or a similar document,
	between W3C and another party or parties,
	that relates to the technical activity of the Consortium
	(e.g., its publications, groups, or liaisons).
	It specifies rights and obligations of each party toward the others.
	These rights and obligations <em class="rfc2119">may</em> include joint deliverables,
	an agreed share of technical responsibilities with due coordination,
	and/or considerations for confidentiality and specific IPR.

	Non-technical agreements, including
	those between W3C and its [=Members=] for the purposes of membership,
	between W3C and its Partners for the purposes of partnership [[BYLAWS]],
	and other agreements related to the operation of the Consortium
	or to the ordinary provision of services,
	are not subject to these Process provisions.

	When considering a [=technical agreement=]
	(i.e., before the decision whether to sign is made),
	the Team <em class="rfc2119">should</em> provide
	the [=Advisory Committee=] with a draft of the proposed [=agreement=],
	along with an explanation of how W3C would benefit from signing this [=agreement=],
	for their review and discussion.
	After addressing any comments,
	and subject to any management or governance procedures that apply
	(e.g., formal review of proposed contracts by legal counsel or by the [=Board=]),
	if the [=Team Decision|Team decides=] to proceed with signing the [=agreement=],
	the Team <em class="rfc2119">must</em> announce the intent to sign,
	and provide the final text of the [=agreement=],
	with an explanation of signing rationale, to
	the [=Advisory Committee=].
	[=Advisory Committee representatives=] <em class="rfc2119">may</em> initiate an [=Advisory Committee Appeal=]
	of the decision to sign the [=agreement=].
	If the proposal is rejected on [=appeal=],
	the [=Team=] <em class=rfc2119>must not</em> sign the [=agreement=] on behalf of W3C
	unless directed to do so by the [=Board=].
	A signed [=agreement=] <em class="rfc2119">should</em> be made public.

	Information about <a href="https://www.w3.org/2001/11/StdLiaison">W3C liaisons with other organizations</a> [[LIAISON]]
	and the guidelines W3C follows when creating a liaison is available on the Web.

<h2 id="Submission">
Member Submission Process</h2>

	The Member Submission process allows Members
	to propose technology
	or other ideas
	for consideration by the [=Team=].
	After review,
	the [=Team=] <em class="rfc2119">may</em> make the material available at the W3C website.
	The formal process affords Members a record of their contribution
	and gives them a mechanism for disclosing the details of the transaction with the Team
	(including IPR claims).
	The [=Team=] also makes review comments on the Submitted materials available for W3C Members,
	the public,
	and the media.

	A <dfn id="MemberSubmission">Member Submission</dfn> consists of:

	<ul>
		<li>
			One or more documents developed outside of the W3C process, and

		<li>
			Information about the documents,
			provided by the Submitter.
	</ul>

	One or more Members (called the <dfn export lt="submitter">Submitter(s)</dfn>)
	<em class="rfc2119">may</em> participate in a Member Submission.
	Only W3C Members <em class="rfc2119">may</em> be listed as [=Submitters=].

	The Submission process consists of the following steps:

	<ol>
		<li>
			One of the [=Submitters=] sends a request to the Team to acknowledge the Submission request.
			The Team and [=Submitter=](s) communicate to ensure that the [=Member Submission=] is complete.

		<li>
			After review, the [=Team=] <em class="rfc2119">must</em> either
			acknowledge or reject the Submission request.

			<ul>
				<li>
					If <a href="#SubmissionYes">acknowledged</a>,
					the Team <em class="rfc2119">must</em> make the [=Member Submission=] available
					at the public W3C website,
					in addition to Team comments about the [=Member Submission=].

				<li>If <a href="#SubmissionNo">rejected</a>,
					the [=Submitter=](s) <em class="rfc2119">may</em> initiate a <a href="#SubmissionNo">Submission Appeal</a>.
			</ul>
	</ol>

	<div class=note>
		Note: To avoid confusion about the Member Submission process, please note that:

		<ul>
			<li>
				Documents in a [=Member Submission=] are developed outside
				of the W3C <a href="#Reports">technical report development process</a>
				(and therefore are not included in the <a href="https://www.w3.org/TR/">index of W3C technical reports</a> [[TR]]).

			<li>
				The Submission process is <strong>not</strong> a means
				by which Members ask for “ratification” of these documents
				as [=W3C Recommendations=].

			<li>
				There is no requirement or guarantee
				that technology which is part of an acknowledged Submission request
				will receive further consideration by W3C
				(e.g., by a W3C [=Working Group=]).
		</ul>
	</div>

	Making a Member Submission available at the W3C website
	does not imply endorsement by W3C,
	including the W3C Team or Members.
	The acknowledgment of a Submission request
	does not imply that any action will be taken by W3C.
	It merely records publicly
	that the Submission request has been made by the Submitter.
	A Member Submission made available by W3C
	<em class="rfc2119">must not</em> be referred to as “work in progress” of W3C.

	The list of <a href="https://www.w3.org/Submission/">acknowledged Member Submissions</a> [[SUBMISSION-LIST]]
	is available at the W3C website.

<h3 id="SubmissionRights">
Submitter Rights and Obligations</h3>

	When more than one Member jointly participates in a Submission request,
	only one Member formally sends in the request.
	That Member <em class="rfc2119">must</em> copy
	each of the [=Advisory Committee representatives=] of the other participating Members,
	and each of those [=Advisory Committee representatives=] <em class="rfc2119">must</em> confirm
	(by email to the Team)
	their participation in the Submission request.

	At any time prior to acknowledgment,
	any [=Submitter=] <em class="rfc2119">may</em> withdraw support for a Submission request
	(described in "<a href="https://www.w3.org/2000/09/submission">How to send a Submission request</a>" [[SUBMISSION-REQ]]).
	A Submission request is “withdrawn” when no Submitter(s) support it.
	The Team <em class="rfc2119">must not</em> make statements
	about withdrawn Submission requests.

	Prior to acknowledgment,
	the [=Submitter=](s) <em class="rfc2119">must not</em>,
	<strong>under any circumstances</strong>,
	refer to a document as “submitted to the World Wide Web Consortium”
	or “under consideration by W3C” or any similar phrase
	either in public or Member communication.
	The [=Submitter=](s) <em class="rfc2119">must not</em> imply
	in public or Member communication
	that W3C is working (with the [=Submitter=](s)) on the material in the [=Member Submission=].
	The [=Submitter=](s) <em class="rfc2119">may</em> release the documents in the Member Submission to the public
	prior to acknowledgment
	(without reference to the Submission request).

	After acknowledgment,
	the [=Submitter=](s) <em class="rfc2119">must not</em>,
	<strong>under any circumstances</strong>,
	imply W3C investment in the Member Submission
	until, and unless, the material has been adopted as a deliverable
	of a W3C [=Working Group=].

<h4 id="SubmissionScope">
Scope of Member Submissions</h4>

	When a technology overlaps in scope with the work of a chartered Working Group,
	Members <em class="rfc2119">should</em> <a href="#group-participation">participate in the Working Group</a>
	and contribute the technology to the group's process
	rather than seek publication through the Member Submission process.
	The [=Working Group=] <em class="rfc2119">may</em> incorporate the contributed technology into its deliverables.
	If the Working Group does not incorporate the technology,
	it <em class="rfc2119">should not</em> publish the contributed documents
	as [=Working Group Notes=] since [=Working Group Notes=]
	represent group output,
	not input to the group.

	On the other hand,
	while W3C is in the early stages of developing a charter,
	Members <em class="rfc2119">should</em> use the Submission process
	to build consensus around concrete proposals for new work.

	Members <em class="rfc2119">should not</em> submit materials
	covering topics well outside the scope of <a href="https://www.w3.org/Consortium/mission">W3C's mission</a> [[MISSION]].

<h4 id="SubmissionReqs">
Information Required in a Submission Request</h4>

	The [=Submitter=](s)
	and any other authors of the submitted material
	<em class="rfc2119">must</em> agree that,
	if the request is acknowledged,
	the documents in the Member Submission will be subject to the <a href="https://www.w3.org/Consortium/Legal/copyright-documents">W3C Document License</a> [[!DOC-LICENSE]]
	and will include a reference to it.
	The [=Submitter=](s) <em class="rfc2119">may</em> hold the copyright for the documents in a Member Submission.

	The request <em class="rfc2119">must</em> satisfy the Member Submission licensing commitments
	in “Licensing Commitments in W3C Submissions”
	in the W3C Patent Policy [[!PATENT-POLICY]].

	The [=Submitter=](s) <em class="rfc2119">must</em> include the following information:

	<ul>
		<li>
			The list of all submitting Members.

		<li>
			Position statements from all submitting Members (gathered by the Submitter).
			All position statements <em class="rfc2119">must</em> appear in a separate document.

		<li>
			Complete electronic copies of any documents submitted for consideration
			(e.g., a technical specification,
			a position paper,
			etc.)
			If the Submission request is acknowledged,
			these documents will be made available by W3C
			and therefore <em class="rfc2119">must</em> satisfy the Team's
			<a href="https://www.w3.org/pubrules/">Publication Rules</a> [[!PUBRULES]].
			[=Submitters=] <em class="rfc2119">may</em> hold the copyright for the material contained in these documents,
			but when made available by W3C,
			these documents <em class="rfc2119">must</em> be subject to the provisions
			of the <a href="https://www.w3.org/Consortium/Legal/copyright-documents">W3C Document License</a> [[!DOC-LICENSE]].
	</ul>

	The request <em class="rfc2119">must</em> also answer the following questions.

	<ul>
		<li>
			What proprietary technology is required to implement the areas addressed by the request,
			and what terms are associated with its use?
			Again, many answers are possible,
			but the specific answer will affect the [=Team's Decision=].

		<li>
			What resources, if any,
			does the Submitter intend to make available
			if W3C acknowledges the Submission request
			and takes action on it?

		<li>
			What action would the Submitter like W3C to take
			if the Submission request is acknowledged?

		<li>
			What mechanisms are there to make changes to the specification being submitted?
			This includes, but is not limited to,
			stating where change control will reside
			if the request is acknowledged.
	</ul>

	For other administrative requirements related to Submission requests,
	see “<a href="https://www.w3.org/2000/09/submission">How to send a Submission request</a>” [[MEMBER-SUB]].

<h3 id="TeamSubmissionRights">
Team Rights and Obligations</h3>

	Although they are not technical reports,
	the documents in a [=Member Submission=]
	<em class="rfc2119">must</em> fulfill the requirements established by the [=Team=],
	including the Team's <a href="https://www.w3.org/pubrules/">Publication Rules</a> [[!PUBRULES]].

	The [=Team=] sends a <dfn id="validation-notice">validation notice</dfn> to the [=Submitter=](s)
	once the Team has reviewed a Submission request
	and judged it complete and correct.

	Prior to a <a lt="Team Decision">decision</a> to <a href="#SubmissionYes">acknowledge</a>
	or <a href="#SubmissionNo">reject</a> the request,
	the request is [=Team-only=],
	and the [=Team=] <em class="rfc2119">must</em> hold it in the strictest confidentiality.
	In particular,
	the Team <em class="rfc2119">must not</em> comment to the media
	about the Submission request.

<h3 id="SubmissionYes">
Acknowledgment of a Submission Request</h3>

	The [=Team=] <a href="#SubmissionYes">acknowledges</a> a Submission request
	by sending an announcement to the [=Advisory Committee=].
	Though the announcement <em class="rfc2119">may</em> be made at any time,
	the [=Submitter=](s) can expect an announcement between <span class="time-interval">four to six weeks</span>
	after the [=validation notice=].
	The [=Team=] <em class="rfc2119">must</em> keep the [=Submitter=](s) informed
	of when an announcement is likely to be made.

	Once a Submission request has been acknowledged,
	the [=Team=] <em class="rfc2119">must</em>:

	<ul>
		<li>
			Make the [=Member Submission=] available at the W3C website.

		<li>
			Make the Team comments about the Submission request available at the W3C website.
	</ul>

	If the [=Submitter=](s) wishes to modify
	a document made available as the result of acknowledgment,
	the Submitter(s) <em class="rfc2119">must</em> start the Submission process from the beginning,
	even just to correct [=editorial changes=].

<h3 id="SubmissionNo">
Rejection of a Submission Request, and Submission Appeals</h3>

	The [=Team=] <em class="rfc2119">may</em> reject a Submission request
	for a variety of reasons,
	including any of the following:

	<ul>
		<li>
			The ideas expressed in the request
			overlap in scope with the work of a chartered Working Group,
			and acknowledgment might jeopardize the progress of the group.

		<li>
			The IPR statement made by the [=Submitter=](s) is inconsistent with W3C's
			Patent Policy [[!PATENT-POLICY]]
			and in particular the “Licensing Commitments in W3C Submissions”,
			<a href="https://www.w3.org/Consortium/Legal/copyright-documents">Document License</a> [[!DOC-LICENSE]],
			or other IPR policies.

		<li>
			The ideas expressed in the request are poor,
			might harm the Web,
			or run counter to <a href="https://www.w3.org/Consortium/mission">W3C's mission</a> [[MISSION]].

		<li>
			The ideas expressed in the request lie well outside the scope of W3C's mission.
	</ul>

	In case of a rejection,
	the [=Team=] <em class="rfc2119">must</em> inform the [=Advisory Committee representative=](s)
	of the [=Submitter=](s).
	If requested by the [=Submitter=](s),
	the [=Team=] <em class="rfc2119">must</em> provide rationale
	to the [=Submitter=](s) about the rejection.
	Other than to the [=Submitter=](s),
	the Team <em class="rfc2119">must not</em> make statements about why a Submission request was rejected.

	The [=Advisory Committee representative=](s) of the [=Submitters=](s)
	<em class="rfc2119">may</em> initiate a [=Submission Appeal=].
	The procedure for handling <dfn>Submission Appeals</dfn> is the same as for [=Formal Objections=],
	except that an [=AC Appeal=] is not possible
	and both the Formal Objection and the [=Council Report=] are confidential to the [=Team=], [=TAG=], and [=AB=].

<h2 id="GAProcess">
Process Evolution</h2>

	Revision of the W3C Process and related documents (see below) undergoes similar [=consensus=]-building processes as for [=technical reports=],
	with the [=Advisory Board=]--
	acting as the sponsoring [=Working Group=].
	The documents may be developed by the [=AB=] or by another group to whom the [=AB=] has delegated development.
	Review includes
	soliciting input from the W3C community,
	and in particular the Team.

	The documents covered by this section are:
	* the W3C Process (this document)
	* the W3C Patent Policy [[!PATENT-POLICY]]
	* the W3C Code of Ethics and Professional Conduct [[!CEPC]]
	* The W3C Document License [[!DOC-LICENSE]]

	The [=Advisory Board=] initiates review as follows:

	<ol>
		<li>
			The [=Team=] sends a Call for Review to the [=Advisory Committee=] and other W3C groups.

		<li>
			After comments have been [=formally addressed=] and the document possibly modified,
			the Team seeks endorsement from the Members by initiating an [=Advisory Committee review=].
			The review period <em class="rfc2119">must</em> last at least <span class="time-interval">28 days</span>.

		<li>
			<a href="#ACReviewAfter">After the Advisory Committee review</a>,
			following a [=W3C decision=] to adopt the document(s),
			the Team does so
			and sends an announcement to the [=Advisory Committee=].
			Advisory Committee representatives <em class="rfc2119">may</em> initiate
			an [=Advisory Committee Appeal=] to W3C.
	</ol>

	Note: As of June 2020,
	the [[PATENT-POLICY|Patent Policy]] is developed in the <a href="https://www.w3.org/2004/pp/psig/">Patents and Standards Interest Group</a>,
	the [[CEPC|Code of Ethics and Professional Conduct]] in the <a href="https://www.w3.org/community/pwe/">Positive Work Environment Community Group</a>,
	and the Process in the <a href="https://www.w3.org/community/w3process/">W3C Process Community Group</a>.

<h2 id="acks" class=non-normative>
Acknowledgments</h2>

	<em>This section is non-normative.</em>

	The editors are grateful to the following people,
	who as interested individuals and/or with the affiliation(s) listed,
	have contributed to this proposal for a revised Process:
	Brian Kardell,
	Carine Bournez (W3C),
	Charles McCathie Nevile (ConsenSys),
	Chris Needham (BBC),
	Chris Wilson (Google),
	David Singer (Apple),
	Delfí Ramírez,
	Dominique Hazaël-Massieux (W3C),
	Elika J. Etemad <abbr title="also known as">aka</abbr> fantasai,
	Fuqiao Xue (W3C),
	Jeff Jaffe (W3C),
	Jeffrey Yasskin (Google),
	Kevin Fleming (Bloomberg),
	Léonie Watson (The Paciello Group),
	Mark Nottingham (Cloudflare),
	Michael Champion (Microsoft),
	Nigel Megitt (BBC),
	Philippe Le Hégaret (W3C),
	Ralph Swick (W3C),
	Samuel Weiler (W3C),
	Sandro Hawke (W3C),
	Shawn Lawton Henry,
	Tantek Çelik (Mozilla),
	Ted Thibodeau Jr (OpenLink Software),
	Virginia Fournier (Apple),
	Wendy Seltzer (W3C),
	Yves Lafon (W3C).

	The editors are sorry for forgetting any names,
	and grateful to those who have listened patiently to conversations about this document
	without feeling a need to add more.

	The following individuals contributed to the development of earlier versions of the Process:
	Alex Russell (Google),
	Andreas Tai (Institut fuer Rundfunktechnik),
	Andrew Betts (Fastly),
	Ann Bassetti (The Boeing Company),
	Anne van Kesteren,
	Art Barstow (Nokia, unaffiliated),
	Bede McCall (MITRE),
	Ben Wilson,
	Brad Hill (Facebook),
	Brian Kardell (JQuery),
	Carine Bournez (W3C),
	Carl Cargill (Netscape, Sun Microsystems, Adobe),
	Chris Lilley (W3C),
	Chris Wilson (Google),
	Claus von Riegen (SAP AG),
	Coralie Mercier (W3C),
	Cullen Jennings (Cisco),
	Dan Appelquist (Telefonica, Samsung),
	Dan Connolly (W3C),
	Daniel Dardailler (W3C),
	Daniel Glazman (Disruptive Innovations),
	David Baron (Mozilla),
	David Fallside (IBM),
	David Singer (Apple),
	David Singer (IBM),
	Delfí Ramírez,
	Dominique Hazaël-Massieux (W3C),
	Don Brutzman (Web3D),
	Don Deutsch (Oracle),
	Eduardo Gutentag (Sun Microsystems),
	Elika J. Etemad <abbr title="also known as">aka</abbr> fantasai,
	Florian Rivoal,
	Fuqiao Xue (W3C),
	Geoffrey Creighton (Microsoft),
	Giri Mandyam (Qualcomm),
	Gregg Kellogg,
	Hadley Beeman,
	Helene Workman (Apple),
	Henri Sivonen (Mozilla),
	Håkon Wium Lie (Opera Software),
	Ian Hickson (Google),
	Ian Jacobs (W3C),
	Ivan Herman (W3C),
	J Alan Bird (W3C),
	Jay Kishigami 岸上順一 (NTT),
	Jean-Charles Verdié (MStar),
	Jean-François Abramatic (IBM, ILOG, W3C),
	Jeff Jaffe (W3C),
	Jim Bell (HP),
	Jim Miller (W3C),
	Joe Hall (CDT),
	John Klensin (MCI),
	Josh Soref (BlackBerry, unaffiliated),
	Judy Brewer (W3C),
	Judy Zhu 朱红儒 (Alibaba),
	Kari Laihonen (Ericsson),
	Karl Dubost (Mozilla),
	Ken Laskey (MITRE),
	Kevin Fleming (Bloomberg),
	Klaus Birkenbihl (Fraunhofer Gesellschaft),
	Larry Masinter (Adobe Systems),
	Lauren Wood (unaffiliated),
	Liam Quin (W3C),
	Léonie Watson (The Paciello Group),
	Marcos Cáceres (Mozilla),
	Maria Courtemanche (IBM),
	Mark Crawford (SAP),
	Mark Nottingham,
	Michael Champion (Microsoft),
	Michael Geldblum (Oracle),
	Mike West (Google),
	Mitch Stoltz (EFF),
	Natasha Rooney (GSMA),
	Nigel Megitt (BBC),
	Olle Olsson (SICS),
	Ora Lassila (Nokia),
	Paul Cotton (Microsoft),
	Paul Grosso (Arbortext),
	Peter Linss,
	Peter Patel-Schneider,
	Philippe Le Hégaret (W3C),
	Qiuling Pan (Huawei),
	Ralph Swick (W3C),
	Renato Iannella (IPR Systems),
	Rigo Wenning (W3C),
	Rob Sanderson (J Paul Getty Trust),
	Robin Berjon (W3C),
	Sally Khudairi (W3C),
	Sam Ruby (IBM),
	Sam Sneddon,
	Sandro Hawke (W3C),
	Sangwhan Moon (Odd Concepts),
	Scott Peterson (Google),
	Steve Holbrook (IBM),
	Steve Zilles (Adobe Systems)
	Steven Pemberton (CWI),
	TV Raman (Google),
	Tantek Çelik (Mozilla),
	Terence Eden (Her Majesty's Government),
	Thomas Reardon (Microsoft),
	Tim Berners-Lee (W3C),
	Tim Krauskopf (Spyglass),
	Travis Leithead (Microsoft),
	Virginia Fournier (Apple),
	Virginie Galindo (Gemalto),
	Wayne Carr (Intel),
	Wendy Fong (Hewlett-Packard),
	Wendy Seltzer (W3C),
	Yves Lafon (W3C).

<h2 id="changes" class=non-normative>
Changes</h2>

	<em>This section is non-normative.</em>

<h3 id=changes-2021 class=no-num>
Changes since the <a href="https://www.w3.org/2021/Process-20211102/">2 November 2021 Process</a></h3>

	<p>This document is based on the <a href="https://www.w3.org/2021/Process-20211102/">2 November 2021 Process</a>.
	A <a href="https://github.com/w3c/w3process/issues?q=milestone%3A%22Process+2022%22+is%3Aclosed">list of issues addressed</a>,
	a <a href="https://services.w3.org/htmldiff?doc1=&amp;doc2=https%3A%2F%2Fwww.w3.org%2FConsortium%2FProcess%2FDrafts%2F">diff from Process 2021 to this latest version</a>,
	as well as
	a <a href="https://github.com/w3c/w3process/compare/p2021...main">detailed log of all changes since then</a>
	are available.

	In addition to a number of editorial adjustments
	and minor teaks,
	the following is a summary of the main differences:

<h4 id=dirfree-changes>
Changes related to the role of the Director</h4>

	<ul>
		<li>
			<a href="#ACReviewAfter">Outcomes of AC Reviews</a> are no longer unconstrained decisions (by the Director),
			but instead must be based on the content of the review,
			with specific rules (based on current best practices)
			about what can or cannot be adjusted post review,
			and under what circumstances.

		<li>
			Rather than the Director, the [=W3C Council=],
			which is composed of TAG+AB+CEO,
			will now hear and resolve formal objections.

		<li>
			The W3C Council will also hear [=Submission Appeals=],
			which were previously handled separately by either the TAG or the AB,
			depending on the grounds for the appeal.

		<li>
			The [=Team=] rather than the Director is charged with
			[[#TAG-appointments|appointing]] the 3 non-elected [=TAG=] members,
			subject to ratification by the [=TAG=] and [=AB=].

		<li>
			There is no longer an ex-officio seat for the Director on the [=TAG=],
			but Tim Berners-Lee personally does continue to hold one.

		<li>
			The [=Team=] rather than the Director is charged with verification that the various expectations of the Process
			have been fulfilled for [=Transition Requests=] and [=Update Requests=].

		<li>
			Require AB and TAG approval when the [=Team=] wants to
			<a href="#rec-track-regression">lower the maturity stage</a>
			of a technical report without a [=Group Decision=].

		<li>
			The [=Team=], [=AB=], or [=TAG=] rather than the Director is now responsible
			for proposing group creation and forcible closure;
			[=AC Review=] is now required for forcible <a href="#GeneralTermination">group closure</a>
			(it already was for group creation).

		<li>
			The [=CEO=] rather than the Director is charged with [[#discipline|disciplinary questions]].

		<li>
			The [=Team=] rather than the Director is charged with negotiating [=MoUs=]
			(now called [=technical agreements=])
			and other agreements related to the technical program.

		<li>
			The [=Team=] rather than the Director is charged with handling various participation-related judgement calls
			(see [[#MemberAssoc]], [[#coi]], [[#member-rep]], [[#ReqsAllGroups]], and [[#invited-expert-wg]]).

		<li>
			The [=Team=] rather than the Director is charged with handling [=Member Submission=] requests
			(but see also [=Submission Appeals=]).
	</ul>

<h4 id=other-gov-changes>
Other Governance Changes</h4>

	<ul>
		<li>
			The [=TAG=] now picks its own chair(s),
			and the timing of AB and TAG chair selection is clarified.

		<li>
			Appointed [=TAG=] seats now have consecutive term limits.

		<li>
			Remove mentions of the Hosts,
			add recognition of the existence of the W3C Inc. Board of Directors,
			and adjust language for W3C being rooted in W3C Inc.

		<li>
			Codify that the AB is expected to pick up to two of its participants
			as <a href="#ab-bod-liaison">liaisons for the board</a>.

		<li>
			Clarify interactions between AC / Team / Board about MoUs
			(now called [=technical agreements=]).
	</ul>

<h4 id=misc-changes>
Other miscellaneous changes</h4>

	<ul>
		<li>
			Improve the definition of consensus
			to make the notion usable even in contexts
			where Formal Objections would be inappropriate
			(such as inside a W3C Council,
			or when the TAG or AB pick their chair),
			and to avoid circular definitions.

		<li>
			Merge Chair Decision Appeal, Group Decision Appeal, and Formal Objection;
			clarify what can be objected to.

		<li>
			Define editorial vs substantive changes for non-REC-track documents.

		<li>
			Expect supporting material to meeting minutes to be archived as the minutes are.

		<li>
			Encourage people requesting an [=AC Appeal=]
			to share their request with the [=Advisory Committee=]
			in addition to the [=Team=].

		<li>
			Allow [=Recommendations=] to transition directly to [=Working Draft=]
			without having to go through [=Candidate Recommendation=]
			when making [[#revised-rec-substantive|substantive changes]].

		<li>
			Place the W3C Document License under the same <a href="#GAProcess">revision process and requirements</a>
			as this document, the CEPC, or the Patent Policy.

		<li>
			Similarly to the pre-existing requirement that a public record be made
			about confidential Formal Objections about public things,
			added a requirement that a member visible record be made
			about confidential Formal Objections about member-visible things.

		<li>
			Stop excluding comments from AC Reps from those that have to be addressed
			while [[#transition-pr|transitioning to Proposed Recommendation]];
			just because there will be an opportunity to address them later
			doesn't mean they shouldn't be handled at the first opportunity.

		<li>
			Clarify what the term [=Candidate Recommendation review period=] refers to.

		<li>
			Clarify how the advance notice period for [=MoU=] works.

		<li>
			Various bits of information that were so far required
			to be included in announcements of [=charter extensions=]
			are covered in the group's homepage,
			making it sufficient to point to that page
			rather than having to inline everything in the announcement.

		<li>
			Be more rigorous in references to the Patent Policy,
			using dated versions when appropriate.

		<li>
			Rename “Member Consortia” into [=Member Associations=]
			to align with terminology in the Bylaws
			(and to avoid confusion with W3C itself).

		<li>
			Rename “maturity level” into “maturity stage”.
	</ul>

<h3 id=changes-previous class=no-num oldids="changes-2020, changes-2019, changes-2018, changes-2017">
Changes since earlier versions</h3>

	Changes since earlier versions of the Process are detailed
	in the <a href="https://www.w3.org/2021/Process-20211102/#changes">changes section of the previous version</a>
	of the Process.

<pre class=biblio>
{
	"JOIN": {
		"href": "https://www.w3.org/Consortium/join",
		"title": "How to Join W3C",
		"publisher": "W3C"
		},
	"MEMBER-AGREEMENT": {
		"href": "https://www.w3.org/Consortium/Agreement/Member-Agreement",
		"title": "W3C Membership Agreement",
		"publisher": "W3C"
	},
	"MEMBER-LIST": {
		"href": "https://www.w3.org/Consortium/Member/List",
		"title": "The list of current W3C Members",
		"publisher": "W3C"
	},
	"SUBMISSION-LIST": {
		"href": "https://www.w3.org/Submission/",
		"title": "The list of acknowledged Member Submissions",
		"publisher": "W3C"
	},
	"SUBMISSION-REQ": {
		"href": "https://www.w3.org/2000/09/submission",
		"title": "Make or Withdraw a Member Submission Request (Member-only access)",
		"publisher": "W3C"
	},
	"TR": {
		"href": "https://www.w3.org/TR/",
		"title": "The W3C technical reports index",
		"publisher": "W3C"
	},
	"MISSION": {
		"href": "https://www.w3.org/Consortium/mission",
		"title": "The W3C Mission statement",
		"publisher": "W3C"
	},
	"COLLABORATORS-AGREEMENT": {
		"href": "https://www.w3.org/Consortium/Legal/collaborators-agreement",
		"title": "Invited expert and collaborators agreement",
		"publisher": "W3C"
	},
	"DOC-LICENSE": {
		"href": "https://www.w3.org/Consortium/Legal/copyright-documents",
		"title": "W3C Document License",
		"publisher": "W3C"
	},
	"TRANSLATION": {
		"href": "https://www.w3.org/Consortium/Translation/",
		"title": "Translations of W3C technical reports",
		"publisher": "W3C"
	},
	"CONFLICT-POLICY": {
		"href": "https://www.w3.org/2000/09/06-conflictpolicy",
		"title": "Conflict of Interest Policy for W3C Team Members Engaged in Outside Professional Activities",
		"publisher": "W3C"
	},
	"TAG-CHARTER": {
		"href": "https://www.w3.org/2004/10/27-tag-charter.html",
		"title": "Technical Architecture Group (TAG) Charter",
		"publisher": "W3C"
	},
	"TAG-HP": {
		"href": "https://www.w3.org/2001/tag/",
		"title": "The TAG home page",
		"publisher": "W3C"
	},
	"REC-TIPS": {
		"href": "https://www.w3.org/2002/05/rec-tips",
		"title": "Tips for Getting to Recommendation Faster",
		"publisher": "W3C"
	},
	"LIAISON": {
		"href": "https://www.w3.org/2001/11/StdLiaison",
		"title": "W3C liaisons with other organizations",
		"publisher": "W3C"
	},
	"AB-HP": {
		"href": "https://www.w3.org/2002/ab/",
		"title": "The Advisory Board home page",
		"publisher": "W3C"
	},
	"PUBRULES": {
		"href": "https://www.w3.org/pubrules/",
		"title": "Publication Rules",
		"publisher": "W3C"
	},
	"FELLOWS": {
		"href": "https://www.w3.org/Consortium/Recruitment/Fellows",
		"title": "W3C Fellows Program",
		"publisher": "W3C"
	},
	"PATENT-POLICY": {
		"href": "https://www.w3.org/Consortium/Patent-Policy/",
		"title": "The W3C Patent Policy",
		"publisher": "W3C"
	},
	"PATENT-POLICY-2004": {
		"href": "https://www.w3.org/Consortium/Patent-Policy-20170801/",
		"title": "The W3C 2004 Patent Policy, Updated 2017",
		"publisher": "W3C"
	},
	"PATENT-POLICY-2020": {
		"href": " https://www.w3.org/Consortium/Patent-Policy-20200915/",
		"title": "The W3C 2020 Patent Policy",
		"publisher": "W3C"
	},
	"REPUBLISHING": {
		"href": "https://www.w3.org/2003/01/republishing/",
		"title": "In-place modification of W3C Technical Reports",
		"publisher": "W3C"
	},
	"CALENDAR": {
		"href": "https://www.w3.org/participate/eventscal",
		"title": "Calendar of all scheduled official W3C events",
		"publisher": "W3C"
	},
	"GUIDE": {
		"href": "https://www.w3.org/Guide/",
		"title": "The Art of Consensus, a guidebook for W3C Working Group Chairs and other collaborators",
		"publisher": "W3C"
	},
	"CEPC": {
		"href": "https://www.w3.org/Consortium/cepc/",
		"title": "W3C Code of Ethics and Professional Conduct",
		"publisher": "W3C"
	},
	"OBS-RESC": {
		"href": "https://www.w3.org/2016/11/obsoleting-rescinding/",
		"title": "Obsoleting and Rescinding W3C Specifications",
		"publisher": "W3C"
	},
	"BG-CG": {
		"href": "https://www.w3.org/community/about/process/",
		"title": "Community and Business Group Process",
		"publisher": "W3C"
	},
	"CURRENT-AC": {
		"href": "https://www.w3.org/Member/ACList",
		"title": "Current Advisory Committee representatives (Member-only access)",
		"publisher": "W3C"
	},
	"GROUP-MAIL": {
		"href": "https://www.w3.org/groups/",
		"title": "Group mailing lists",
		"publisher": "W3C"
	},
	"INTRO": {
		"href": "https://www.w3.org/Member/Intro",
		"title": "Process, Patent Policy, Finances, Specs management, Strategic vision (Member-only access)",
		"publisher": "W3C"
	},
	"AC-MEETING": {
		"href": "https://www.w3.org/Member/Meeting/",
		"title": "Advisory Committee meetings (Member-only access)",
		"publisher": "W3C"
	},
	"MEMBER-HP": {
		"href": "https://www.w3.org/Member/",
		"title": "Member website (Member-only access)",
		"publisher": "W3C"
	},
	"MEMBER-SUB": {
		"href": "https://www.w3.org/2000/09/submission",
		"title": "How to send a Submission request",
		"publisher": "W3C"
	},
	"ELECTION-HOWTO": {
		"href": "https://www.w3.org/2002/10/election-howto",
		"title": "How to Organize an Advisory Board or TAG election",
		"publisher": "W3C",
		"id": "MEM15"
	},
	"TEAM-CONTACT": {
		"href": "https://www.w3.org/Guide/teamcontact/role.html",
		"title": "Role of the Team Contact",
		"publisher": "W3C"
	},
	"CHAIR": {
		"href": "https://www.w3.org/Guide/chair/role.html",
		"title": "W3C Working/Interest Group Chair",
		"publisher": "W3C"
	},
	"CHARTER": {
		"href": "https://www.w3.org/Guide/process/charter.html",
		"title": "How to Create a Working Group or Interest Group",
		"publisher": "W3C"
	},
	"TRANSITION": {
		"href": "https://www.w3.org/Guide/transitions",
		"title": "Organize a Technical Report Transition",
		"publisher": "W3C"
	},
	"DECISION-APPEAL": {
		"href": "https://www.w3.org/Guide/process/ac-appeal",
		"title": "Appealing a W3C Decision",
		"publisher": "W3C"
	},
	"BYLAWS": {
		"href": "https://www.w3.org/2022/10/w3c-bylaws-20221019.pdf",
		"title": "Amended and Restated Bylaws of World Wide Web Consortium, Inc."
	},
	"W3C-IPR": {
		"href": "https://www.w3.org/Consortium/Legal/2002/ipr-notice-20021231",
		"title": "W3C IPR Policies"
	},
	"COUNCIL-REPORT-INDEX": {
		"href": "https://beta.w3.org/about/council/",
		"title": "Council Report Index"
	}

}
</pre>
