#region MIT license
// 
// MIT license
//
// Copyright (c) 2007-2008 Jiri Moudry, Pascal Craponne
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
// 
#endregion

using System;
using System.Collections.Generic;

namespace DbLinq.Schema.Dbml.Adapter
{
    /// <summary>
    /// sort of light IList<>
    /// </summary>
    /// <typeparam name="T"></typeparam>
#if !MONO_STRICT
    public
#endif
    interface ISimpleList<T> : IEnumerable<T>
    {
        /// <summary>
        /// Items count
        /// </summary>
        int Count { get; }

        /// <summary>
        /// Append a parameter
        /// </summary>
        /// <param name="item"></param>
        void Add(T item);

        /// <summary>
        /// Index accessor
        /// </summary>
        /// <param name="index"></param>
        /// <returns></returns>
        T this[int index] { get; set; }

        /// <summary>
        /// Sorts using a given sorter.
        /// </summary>
        /// <param name="sorter">The sorter.</param>
        void Sort(IComparer<T> sorter);

        /// <summary>
        /// Finds all items matching a given predicate.
        /// </summary>
        /// <param name="match">The match.</param>
        /// <returns></returns>
        List<T> FindAll(Predicate<T> match);
    }
}