const { assert, skip, test, module: describe, only } = require('qunit');
const { WebGL2Kernel } = require('../../../../../src');

describe('internal: WebGL2Kernel');

(typeof global !== 'undefined' ? test : skip)('.setupFeatureChecks() if context is available, but .getExtension() is falsey', () => {
  const mockContext = {
    getExtension: null // this is important
  };
  const mockElement = {
    getContext: () => mockContext,
  };
  const mockDocument = {
    createElement: () => {
      return mockElement;
    }
  };
  global.document = mockDocument;

  WebGL2Kernel.setupFeatureChecks();
  assert.ok(true);

  delete global.document;
});

test('.validateSettings() checks output texture size - too large', () => {
  const mockContext = {
    constructor: {
      features: {
        maxTextureSize: 1,
      },
    },
    checkOutput: () => {},
    output: [2],
    validate: true,
    checkTextureSize: WebGL2Kernel.prototype.checkTextureSize,
  };
  assert.throws(() => {
    WebGL2Kernel.prototype.validateSettings.apply(mockContext, []);
  }, new Error('Texture size [1,2] generated by kernel is larger than supported size [1,1]'));
});

test('.validateSettings() checks output texture size - ok', () => {
  const mockContext = {
    constructor: {
      features: {
        maxTextureSize: 1,
      },
    },
    checkOutput: () => {},
    output: [1],
    validate: true,
    checkTextureSize: WebGL2Kernel.prototype.checkTextureSize,
  };
  WebGL2Kernel.prototype.validateSettings.apply(mockContext, []);
  assert.ok(true);
});
