//line parser/lexer.go:2
//line parser/lexer.l:33
package parser

import (
    "fmt"
    "io"
    "log"
    "os"
    "math"
    "strconv"
    "strings"

    "github.com/VirusTotal/gyp/ast"
    "github.com/VirusTotal/gyp/hex"
    gyperror "github.com/VirusTotal/gyp/error"
)

type YYcontext struct {}

// YYtype is the structure returned by the lexer every time the scanner asks
// for the next token. Each token may have an associated value, for example,
// the _IDENTIFIER_ token has an associated string with the identifier's name.
// If the lexer wants to return an error to the scanner it
// sets the Error field and leaves the Token and Value empty.
type YYtype struct {
  Token int
  Lineno int
  Value *yrSymType
  Error gyperror.Error
}

// Token creates a YYtype struct for the given token type with no associated
// value.
func (s *Scanner) Token(t int) YYtype {
  return YYtype{Token: t, Lineno: s.Lineno}
}

// TokenString creates a YYtype struct for the given token type with an
// associated string.
func (s *Scanner) TokenString(t int, v string) YYtype {
  return YYtype{Token: t, Lineno: s.Lineno, Value: &yrSymType{s: v}}
}

func (s *Scanner) TokenInt64(t int, v int64) YYtype {
  return YYtype{Token: t, Lineno: s.Lineno, Value: &yrSymType{i64: v}}
}

func (s *Scanner) TokenRegExp(reg *ast.LiteralRegexp) YYtype {
  return YYtype{Token: _REGEXP_, Lineno: s.Lineno, Value: &yrSymType{reg: reg}}
}

func (s *Scanner) TokenHexString(hexTokens []ast.HexToken) YYtype {
  return YYtype{Token: _HEX_STRING_, Lineno: s.Lineno, Value: &yrSymType{hexTokens: hexTokens}}
}

func Error(c gyperror.Code, msg string) YYtype {
  return YYtype{Error: gyperror.Error{c, msg, 0,}}
}

func validateAscii(s string) error {
  for i := 0; i < len(s); i++ {
    if s[i] < 32 || s[i] >= 127 {
       return fmt.Errorf(`non-ascii character "\x%02x"`, s[i])
    }
  }
  return nil
}


// The YY_USER_DATA macro is used to define variables inside the Scanner
// Lex() method. These variables manage buffers for gathering groups of
// tokens. Flex collects tokens individually but strings and conditions may
// contain several tokens.
// Two different buffers are necessary because conditions may contain strings.

// This comment applies to the YY_USER_ACTION macro, which is having
// a problem with comments...
// For condition, the colons and whitespace will be collected in the
// prefix and the right brace for the suffix. Use strings.TrimLeft/Right



//line parser/lexer.go:85

// START OF SKELL ------------------------------------------------------
// A lexical scanner generated by flexgo

type Scanner struct {
	In   io.Reader
	Out  io.Writer
	Lineno int

	Filename      string
	Wrap          func(*Scanner) bool
	IsInteractive func(io.Reader) bool
	Context       YYcontext

	lastAcceptingState   int
	lastAcceptingCpos    int
	debug                bool
	start                int
	stateBuf             []int
	statePtr             int
	fullState            int
	fullMatch            int
	fullLp               int
	lp                   int
	lookingForTrailBegin int
	holdChar             byte
	cBufP                int
	didBufferSwitchOnEof bool
	textPtr              int
	nChars               int
	init                 bool
	moreFlag             bool
    moreLen              int

	// buffer
	inputFile    io.Reader
	chBuf        []byte // input buffer
	bufPos       int    // current position in input buffer
	bufSize      int
	bufNChars    int
	Interactive  bool
	atBol        int // 0 (false) or 1 (true)
	fillBuffer   bool
	bufferStatus int
}

func NewScanner() *Scanner {
	yy := Scanner{
		Lineno: 1,
		In:            os.Stdin,
		Out:           os.Stdout,
		Wrap:          func(yyy *Scanner) bool { return true },
		IsInteractive: func(file io.Reader) bool { return yyInteractiveDefault },
		bufSize:       yyBufSize,
		chBuf:         make([]byte, yyBufSize+2),
		start:         1,
		stateBuf:      make([]int, yyBufSize+2),
		atBol:         1,
		debug:         yyFlexDebug,
		fillBuffer:    true,
	}
	return &yy
}

func (yy *Scanner) NewFile() {
	yy.Restart(yy.In)
}

const yyEndOfBufferChar = 0

const yyBufSize = 32768

const (
	eobActEndOfFile    = 0
	eobActContinueScan = 1
	eobActLastMatch    = 2
)

const (
	yyBufferNew        = 0
	yyBufferNormal     = 1
	yyBufferEofPending = 2
)

// [1.0] the user's section 1 definitions and yytext/yyin/yyout/yy_state_type/yylineno etc. def's & init go here
/* Begin user sect3 */
const yyFlexDebug = false

const yyInteractiveDefault = false
// SKEL ----------------------------------------------------------------

// [1.5] DFA------------------------------------------------------------
// SKEL ----------------------------------------------------------------

// [4.0] data tables for the DFA go here -------------------------------
const yyNumRules = 80
const yyEndOfBuffer = 81
var yyAccept = [291]int16{   0,
        0,    0,    0,    0,    0,    0,    0,    0,   81,   79,
       78,   78,   54,   75,   52,   51,   79,   76,   57,   57,
        2,   79,    3,   53,   56,   56,   56,   56,   56,   56,
       56,   56,   56,   56,   56,   56,   56,   56,   56,   56,
       56,   56,   79,   67,   68,   61,   80,   73,   74,   70,
       80,   48,   48,   54,    7,   52,   50,   51,    1,   46,
       49,    0,   57,    0,    0,    0,    0,    8,    4,    6,
        5,    9,   53,   56,   56,   56,   56,   28,   56,   56,
       56,   56,   56,   56,   56,   56,   56,   56,   56,   29,
       56,   56,   56,   56,   30,   27,   56,   56,   56,   56,

       56,   56,   56,   56,    0,    0,   67,   69,   64,   65,
       63,   62,   69,   73,   70,   70,   72,   71,   47,   49,
       58,   57,   60,   59,   33,   26,   34,   56,   56,   56,
       56,   56,   56,   56,   32,   56,   56,   56,   56,   56,
       56,   56,   56,   56,   56,   56,   25,   56,   56,   56,
       56,   56,   56,   56,   56,   19,   77,    0,    0,    0,
       56,   56,   56,   56,   56,   56,   56,   56,   56,   56,
       56,   56,   56,   56,   56,   56,   55,   56,   56,   13,
       56,   56,   12,   56,   56,   31,   23,   18,    0,    0,
        0,    0,    0,   77,   66,   15,   56,   56,   56,   56,

       56,   24,   56,   56,   56,   56,   56,   56,   56,   56,
       56,   56,   56,   56,   56,   56,    0,    0,   16,   56,
       56,   56,   56,   56,   56,   11,   56,   56,   44,   56,
       55,   56,   56,   21,   56,   56,   56,    0,    0,    0,
        0,    0,   77,   56,   56,   56,   56,   56,   56,   56,
       56,   56,   45,   56,   37,   10,   56,   14,    0,   77,
        0,    0,    0,   56,   56,   38,   42,   56,   36,   20,
       56,   56,   56,   56,    0,    0,    0,   56,   22,   56,
       39,   43,   56,   56,   17,   35,   56,   40,   41,    0,
    }

var yyEc = [256]byte{    0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    4,    5,    6,    7,    1,    1,    1,    8,
        8,    9,    1,    1,    8,   10,   11,   12,   13,   14,
       15,   16,   17,   18,   17,   19,   20,    1,    1,   21,
       22,   23,    8,   24,   25,   26,   25,   25,   25,   25,
       27,   27,   27,   27,   28,   27,   29,   27,   27,   27,
       27,   27,   27,   27,   27,   27,   27,   27,   27,   27,
        8,   30,    8,    1,   31,    1,   32,   33,   34,   35,

       36,   37,   38,   39,   40,   27,   27,   41,   42,   43,
       44,   45,   27,   46,   47,   48,   49,   50,   51,   52,
       53,   54,   55,    8,   56,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,
    }

var yyMeta = [57]byte{    0,
        1,    2,    3,    1,    4,    1,    1,    2,    5,    6,
        7,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        1,    9,    1,    1,   10,   10,   11,   12,   12,   13,
       11,   10,   10,   10,   10,   10,   10,   11,   11,   11,
       11,   11,   11,   12,   11,   11,   11,   11,   11,   11,
       11,   12,   11,   11,    1,    1,
    }

var yyBase = [312]uint16{   0,
        0,    0,   54,   55,   58,   59,  590,  589,  597,  600,
      600,  600,  574,  600,    0,  586,  584,   54,   54,   58,
       45,  571,   49,    0,    0,   32,  560,  547,  547,   59,
      548,   58,   42,  544,   44,  541,  537,  537,   58,  544,
      543,  538,  570,    0,  600,  600,   88,    0,  600,   67,
      569,  600,  568,  556,  600,    0,  600,  568,  600,  600,
        0,    0,    0,  550,  549,  107,    0,  600,  600,  600,
      600,  600,    0,    0,  533,   42,  539,    0,  525,  528,
       61,  529,  528,  522,  526,  522,  521,  521,  518,   78,
      514,  513,  512,   79,    0,    0,  519,  516,   83,  492,

      476,  470,  465,  446,  100,  119,    0,  600,  600,  600,
      600,  600,    0,    0,  441,  600,  600,  600,  600,    0,
        0,  600,  129,    0,    0,    0,    0,  424,  427,  100,
      412,  410,  408,  418,    0,  407,  410,  397,  404,  394,
      395,  119,  399,  395,  396,  391,    0,  326,  339,  328,
      333,  330,  335,  322,  333,    0,  600,  359,  155,    0,
      327,  348,  325,  332,  312,  309,  325,  313,  308,  320,
      303,  303,  303,  299,  327,  330,  310,  296,  292,    0,
      281,  295,    0,  278,  282,    0,    0,    0,  256,  253,
      210,    0,  128,    0,  600,    0,  247,  214,  221,  220,

      214,    0,  218,  213,  215,  223,  203,  205,  217,  215,
      202,  213,  212,  193,  193,  201,  266,  140,  187,  197,
      191,  185,  188,  177,  174,    0,  179,  177,    0,  180,
        0,  168,  167,    0,  174,  158,  161,    0,    0,  321,
      196,  141,    0,  166,  161,  157,  164,  162,  165,  165,
      156,  150,    0,  146,    0,    0,  156,    0,  144,  186,
      150,  183,  151,  158,  143,    0,    0,  142,    0,    0,
      137,  144,  142,  117,  167,    0,  168,  128,    0,  106,
        0,    0,   85,   78,    0,    0,   77,    0,    0,  600,
      377,  390,  403,  409,  414,  422,  429,  434,  439,  450,

      460,  472,  485,  497,  510,   68,  516,  519,  529,  542,
      548,
    }

var yyDef = [312]int16{   0,
      290,    1,  291,  291,  292,  292,  293,  293,  290,  290,
      290,  290,  294,  290,  295,  296,  290,  290,  297,  297,
      290,  290,  290,  298,  299,  299,  299,  299,  299,  299,
      299,  299,  299,  299,  299,  299,  299,  299,  299,  299,
      299,  299,  300,  301,  290,  290,  302,  303,  290,  290,
      304,  290,  290,  294,  290,  295,  290,  296,  290,  290,
      305,  306,   20,  290,  290,  290,  307,  290,  290,  290,
      290,  290,  298,  299,  299,  299,  299,  299,  299,  299,
      299,  299,  299,  299,  299,  299,  299,  299,  299,  299,
      299,  299,  299,  299,  299,  299,  299,  299,  299,  299,

      299,  299,  299,  299,  300,  290,  301,  290,  290,  290,
      290,  290,  308,  303,  290,  290,  290,  290,  290,  305,
      306,  290,  290,  307,  299,  299,  299,  299,  299,  299,
      299,  299,  299,  299,  299,  299,  299,  299,  299,  299,
      299,  299,  299,  299,  299,  299,  299,  299,  299,  299,
      299,  299,  299,  299,  299,  299,  290,  309,  310,  311,
      299,  299,  299,  299,  299,  299,  299,  299,  299,  299,
      299,  299,  299,  299,  299,  299,  299,  299,  299,  299,
      299,  299,  299,  299,  299,  299,  299,  299,  309,  290,
      310,  191,  191,  191,  290,  299,  299,  299,  299,  299,

      299,  299,  299,  299,  299,  299,  299,  299,  299,  299,
      299,  299,  299,  299,  299,  299,  290,  191,  299,  299,
      299,  299,  299,  299,  299,  299,  299,  299,  299,  299,
      299,  299,  299,  299,  299,  299,  299,  217,  217,  309,
      191,  217,  217,  299,  299,  299,  299,  299,  299,  299,
      299,  299,  299,  299,  299,  299,  299,  299,  309,  309,
      191,  217,  217,  299,  299,  299,  299,  299,  299,  299,
      299,  299,  299,  299,  309,  217,  217,  299,  299,  299,
      299,  299,  299,  299,  299,  299,  299,  299,  299,    0,
      290,  290,  290,  290,  290,  290,  290,  290,  290,  290,

      290,  290,  290,  290,  290,  290,  290,  290,  290,  290,
      290,
    }

var yyNxt = [657]uint16{   0,
       10,   11,   12,   13,   14,   15,   16,   10,   10,   17,
       18,   19,   20,   20,   20,   20,   20,   20,   20,   20,
       21,   22,   23,   24,   25,   25,   25,   25,   25,   10,
       25,   26,   27,   28,   25,   29,   30,   31,   25,   32,
       25,   33,   34,   35,   36,   37,   38,   39,   40,   25,
       41,   42,   25,   25,   43,   10,   45,   45,   46,   46,
       49,   49,   60,   62,   61,   68,   69,   62,   50,   50,
       71,   72,   75,   92,   76,  121,  126,   93,   77,   78,
       95,   64,   65,   47,   47,   64,   65,   51,   51,   96,
       82,   87,  109,   88,  127,  131,  100,   66,   83,   89,

       90,  290,   84,  101,   91,   67,  115,   85,  132,  290,
      106,  141,  146,  116,  150,  289,  288,  110,  123,  123,
      123,  123,  123,  123,  123,  142,  147,  158,  151,  159,
      111,  175,  287,  176,  163,  112,  217,  177,  218,  113,
      123,  123,  123,  123,  123,  123,  123,  164,  217,  262,
      218,  263,  275,  286,  276,  157,  192,  105,  217,  262,
      218,  263,  192,  285,  284,  193,  192,  192,  192,  192,
      192,  192,  192,  192,  192,  190,  262,  240,  263,  192,
      192,  283,  282,  281,  280,  279,  192,  192,  192,  192,
      192,  192,  278,  277,  190,  274,  273,  272,  271,  270,

      269,  268,  267,  266,  265,  264,  261,  258,  257,  256,
      194,  192,  105,  255,  254,  253,  252,  192,  251,  250,
      193,  192,  192,  192,  192,  192,  192,  192,  192,  192,
      249,  248,  247,  246,  192,  192,  245,  244,  237,  236,
      235,  192,  192,  192,  192,  192,  192,  234,  233,  232,
      231,  230,  229,  228,  227,  226,  225,  224,  223,  222,
      221,  220,  219,  105,  190,  194,  238,  239,  240,  238,
      238,  238,  238,  239,  241,  238,  242,  239,  239,  239,
      239,  239,  239,  239,  239,  239,  238,  238,  238,  238,
      239,  239,  238,  238,  238,  238,  238,  239,  239,  239,

      239,  239,  239,  238,  238,  238,  238,  238,  238,  238,
      238,  238,  238,  238,  238,  238,  238,  238,  238,  238,
      238,  243,  240,  240,  216,  215,  214,  213,  240,  190,
      212,  259,  240,  240,  240,  240,  240,  240,  240,  240,
      240,  211,  210,  177,  177,  240,  240,  209,  208,  207,
      206,  205,  240,  240,  240,  240,  240,  240,  204,  203,
      202,  201,  200,  199,  198,  197,  196,  190,  188,  142,
      187,  186,  185,  184,  183,  182,  260,   44,   44,   44,
       44,   44,   44,   44,   44,   44,   44,   44,   44,   44,
       48,   48,   48,   48,   48,   48,   48,   48,   48,   48,

       48,   48,   48,   52,   52,   52,   52,   52,   52,   52,
       52,   52,   52,   52,   52,   52,   54,   54,   54,   54,
       54,   56,  181,   56,   56,   56,   58,  180,  179,   58,
      178,   58,   58,   58,   63,  174,   63,  173,  172,  171,
       63,   73,  170,   73,   73,   73,   74,  169,   74,   74,
       74,  105,  105,  168,  167,  166,  105,  105,  165,  105,
      107,  107,  162,  161,  107,  107,  107,  107,  107,  107,
      107,  107,  108,  108,  108,  108,  108,  108,  108,  108,
      108,  108,  108,  108,  108,  114,  114,  116,  114,  114,
      114,  156,  114,  114,  114,  114,  114,  117,  117,  155,

      117,  117,  117,  117,  117,  117,  117,  117,  117,  117,
      120,  120,  154,  120,  120,  120,  120,  120,  120,  120,
      120,  120,  120,  124,  153,  124,  160,  152,  160,  189,
      189,  189,  189,  189,  189,  189,  189,  189,  189,  189,
      189,  189,  191,  191,  191,  191,  191,  191,  191,  191,
      191,  191,  191,  191,  191,  195,  149,  195,  148,  145,
      144,  143,  140,  139,  138,  137,  136,  135,  134,  133,
      130,  129,  128,  125,  122,  122,   57,  290,  119,  118,
      106,  104,  103,  102,   99,   98,   97,   94,   86,   81,
       80,   79,   70,   59,   57,   55,  290,   53,   53,    9,

      290,  290,  290,  290,  290,  290,  290,  290,  290,  290,
      290,  290,  290,  290,  290,  290,  290,  290,  290,  290,
      290,  290,  290,  290,  290,  290,  290,  290,  290,  290,
      290,  290,  290,  290,  290,  290,  290,  290,  290,  290,
      290,  290,  290,  290,  290,  290,  290,  290,  290,  290,
      290,  290,  290,  290,  290,  290,
    }

var yyChk = [657]int16{   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    3,    4,    3,    4,
        5,    6,   18,   19,   18,   21,   21,   20,    5,    6,
       23,   23,   26,   33,   26,  306,   76,   33,   26,   26,
       35,   19,   19,    3,    4,   20,   20,    5,    6,   35,
       30,   32,   47,   32,   76,   81,   39,   19,   30,   32,

       32,   20,   30,   39,   32,   19,   50,   30,   81,   20,
      105,   90,   94,   50,   99,  287,  284,   47,   66,   66,
       66,   66,   66,   66,   66,   90,   94,  106,   99,  106,
       47,  142,  283,  142,  130,   47,  193,  142,  193,   47,
      123,  123,  123,  123,  123,  123,  123,  130,  218,  242,
      218,  242,  259,  280,  259,  105,  159,  159,  261,  263,
      261,  263,  159,  278,  274,  159,  159,  159,  159,  159,
      159,  159,  159,  159,  159,  275,  277,  275,  277,  159,
      159,  273,  272,  271,  268,  265,  159,  159,  159,  159,
      159,  159,  264,  262,  260,  257,  254,  252,  251,  250,

      249,  248,  247,  246,  245,  244,  241,  237,  236,  235,
      159,  191,  191,  233,  232,  230,  228,  191,  227,  225,
      191,  191,  191,  191,  191,  191,  191,  191,  191,  191,
      224,  223,  222,  221,  191,  191,  220,  219,  216,  215,
      214,  191,  191,  191,  191,  191,  191,  213,  212,  211,
      210,  209,  208,  207,  206,  205,  204,  203,  201,  200,
      199,  198,  197,  190,  189,  191,  217,  217,  217,  217,
      217,  217,  217,  217,  217,  217,  217,  217,  217,  217,
      217,  217,  217,  217,  217,  217,  217,  217,  217,  217,
      217,  217,  217,  217,  217,  217,  217,  217,  217,  217,

      217,  217,  217,  217,  217,  217,  217,  217,  217,  217,
      217,  217,  217,  217,  217,  217,  217,  217,  217,  217,
      217,  217,  240,  240,  185,  184,  182,  181,  240,  240,
      179,  240,  240,  240,  240,  240,  240,  240,  240,  240,
      240,  178,  177,  176,  175,  240,  240,  174,  173,  172,
      171,  170,  240,  240,  240,  240,  240,  240,  169,  168,
      167,  166,  165,  164,  163,  162,  161,  158,  155,  154,
      153,  152,  151,  150,  149,  148,  240,  291,  291,  291,
      291,  291,  291,  291,  291,  291,  291,  291,  291,  291,
      292,  292,  292,  292,  292,  292,  292,  292,  292,  292,

      292,  292,  292,  293,  293,  293,  293,  293,  293,  293,
      293,  293,  293,  293,  293,  293,  294,  294,  294,  294,
      294,  295,  146,  295,  295,  295,  296,  145,  144,  296,
      143,  296,  296,  296,  297,  141,  297,  140,  139,  138,
      297,  298,  137,  298,  298,  298,  299,  136,  299,  299,
      299,  300,  300,  134,  133,  132,  300,  300,  131,  300,
      301,  301,  129,  128,  301,  301,  301,  301,  301,  301,
      301,  301,  302,  302,  302,  302,  302,  302,  302,  302,
      302,  302,  302,  302,  302,  303,  303,  115,  303,  303,
      303,  104,  303,  303,  303,  303,  303,  304,  304,  103,

      304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
      305,  305,  102,  305,  305,  305,  305,  305,  305,  305,
      305,  305,  305,  307,  101,  307,  308,  100,  308,  309,
      309,  309,  309,  309,  309,  309,  309,  309,  309,  309,
      309,  309,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  310,  310,  311,   98,  311,   97,   93,
       92,   91,   89,   88,   87,   86,   85,   84,   83,   82,
       80,   79,   77,   75,   65,   64,   58,   54,   53,   51,
       43,   42,   41,   40,   38,   37,   36,   34,   31,   29,
       28,   27,   22,   17,   16,   13,    9,    8,    7,  290,

      290,  290,  290,  290,  290,  290,  290,  290,  290,  290,
      290,  290,  290,  290,  290,  290,  290,  290,  290,  290,
      290,  290,  290,  290,  290,  290,  290,  290,  290,  290,
      290,  290,  290,  290,  290,  290,  290,  290,  290,  290,
      290,  290,  290,  290,  290,  290,  290,  290,  290,  290,
      290,  290,  290,  290,  290,  290,
    }

/* Table of booleans, true if rule could match eol. */
var yyRuleCanMatchEol = [81]int32{   0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 
    0,     };

//line parser/lexer.l:1
/*
Copyright (c) 2007-2013. The YARA Authors. All Rights Reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

3. Neither the name of the copyright holder nor the names of its contributors
may be used to endorse or promote products derived from this software without
specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/* Lexical analyzer for YARA */

//line parser/lexer.l:114
 

 

// Define a constant for end-of-file
const eof = 0



//line parser/lexer.go:532
// SKEL ----------------------------------------------------------------

const yyInitial  = 0
const STR = 1
const REGEXP = 2
const COMMENT = 3

const yyReadBufSize = 16384

func (yy *Scanner) input(offset, maxRead int) int {

// [5.0] fread()/read() definition of yy_INPUT goes here ---------------
// nothing here, all moved to skeleton
// SKEL ----------------------------------------------------------------

	if yy.Interactive {
		b := make([]byte, 1)
		var n int
		for n = 0; n < maxRead; n++ {
			nn, err := yy.inputFile.Read(b)
			if err != nil && err != io.EOF {
				log.Panicln("Reading 1 byte:", err)
			}
			if nn < 1 {
				break
			}
			yy.chBuf[offset+n] = b[0]
			if b[0] == '\n' {
				n++
				break
			}
		}
		return n
	}

	n, err := yy.inputFile.Read(yy.chBuf[offset:offset+maxRead])
	if err != nil  && err != io.EOF {
		log.Panicf("Reading %d bytes: %v\n", maxRead, err)
	}
	return n
}

/* [6.0] YY_RULE_SETUP definition goes here --------------------------*/

// SKEL ----------------------------------------------------------------

// The main scanner function which does all the work.
func (yy *Scanner) Lex() YYtype {
	var yyCurrentState int
	var yyBp, yyCp int
	var yyAct int
	var yytext []byte
	var yyleng int
	var yylineno int
	_ = yytext
	_ = yyleng
	_ =  yylineno 

	var (
    str      []byte
    regexp   []byte
    YYtext   string  // each action sets this to the current yytext
  )

	if !yy.init {
		yy.init = true
		
		if yy.In == nil {
			yy.In = os.Stdin
		}
		if yy.Out == nil {
			yy.Out = os.Stdout
		}
		yy.initBuffer(yy.In)
		yy.loadBufferState()
	}

	yyout := yy.Out
	_ = yyout

// [7.0] user's declarations go here -----------------------------------
//line parser/lexer.l:148


//line parser/lexer.go:617
// SKEL ----------------------------------------------------------------

	for { // loops until end-of-file is reached

// [8.0] yy''more-related code goes here -------------------------------
// SKEL ----------------------------------------------------------------

		yyCp = yy.cBufP

		/* Support of yytext. */
		yy.chBuf[yyCp] = yy.holdChar

		// yyBp points to the position in yy_ch_buf of the start of
		// the current run.
		yyBp = yyCp

// [9.0] code to set up and find next match goes here ------------------
		yyCurrentState = yy.start
yyMatch:
		for {
			yyC := int(yyEc[yy.chBuf[yyCp]])
						if yyAccept[yyCurrentState] != 0 {
				yy.lastAcceptingState = yyCurrentState
				yy.lastAcceptingCpos = yyCp
			}
			for int(yyChk[int(yyBase[yyCurrentState])+yyC]) != yyCurrentState {
				yyCurrentState = int(yyDef[yyCurrentState])
				if yyCurrentState >= 291 {
					yyC = int(yyMeta[yyC])
				}
			}
			yyCurrentState = int(yyNxt[int(yyBase[yyCurrentState])+yyC])
			yyCp++
			if yyCurrentState == 290 {
				break
			}
		}
		yyCp = yy.lastAcceptingCpos
		yyCurrentState = yy.lastAcceptingState
// SKEL ----------------------------------------------------------------

	yyFindAction:

// [10.0] code to find the action number goes here ---------------------
		yyAct = int(yyAccept[yyCurrentState])
// SKEL ----------------------------------------------------------------

		yy.textPtr = yyBp

// [2.0] code to fiddle yytext and yyleng for yy''more() goes here -------
	yyleng = yyCp - yyBp
// SKEL ----------------------------------------------------------------

		yy.holdChar = yy.chBuf[yyCp]
		yy.chBuf[yyCp] = 0

// [3.0] code to copy yytext_ptr to yytext[] goes here, if %array ------
// SKEL ----------------------------------------------------------------

		yy.cBufP = yyCp
		yytext = yy.chBuf[yy.textPtr:yyCp]
 
// [11.0] code for yylineno update goes here ---------------------------

		if yyAct != yyEndOfBuffer && yyRuleCanMatchEol[yyAct] != 0 {
			for yyl := 0; yyl < yyleng; yyl++ {
				if yytext[yyl] == '\n' {
					yy.Lineno++
				}
			}
		}

// SKEL ----------------------------------------------------------------

	doAction: // This label is used only to access EOF actions.

// [12.0] debug code goes here -----------------------------------------
// SKEL ----------------------------------------------------------------

		switch yyAct { // beginning of action switch

// [13.0] actions go here ----------------------------------------------
			case 0: // must back up
			// undo the effects of yy_DO_BEFORE_ACTION
			yy.chBuf[yyCp] = yy.holdChar
			yyCp = yy.lastAcceptingCpos
			yyCurrentState = yy.lastAcceptingState
			goto yyFindAction

case 1:

	yylineno = yy.Lineno
	YYtext = string(yytext)

//line parser/lexer.l:150
{ return yy.Token(_DOT_DOT_);     }
case 2:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:151
{ return yy.Token(_LT_);          }
case 3:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:152
{ return yy.Token(_GT_);          }
case 4:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:153
{ return yy.Token(_LE_);          }
case 5:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:154
{ return yy.Token(_GE_);          }
case 6:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:155
{ return yy.Token(_EQ_);          }
case 7:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:156
{ return yy.Token(_NEQ_);         }
case 8:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:157
{ return yy.Token(_SHIFT_LEFT_);  }
case 9:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:158
{ return yy.Token(_SHIFT_RIGHT_); }
case 10:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:159
{ return yy.Token(_PRIVATE_);     }
case 11:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:160
{ return yy.Token(_GLOBAL_);      }
case 12:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:161
{ return yy.Token(_RULE_);        }
case 13:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:162
{ return yy.Token(_META_);        }
case 14:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:163
{ return yy.Token(_STRINGS_);     }
case 15:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:164
{ return yy.Token(_ASCII_);       }
case 16:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:165
{ return yy.Token(_BASE64_);      }
case 17:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:166
{ return yy.Token(_BASE64WIDE_);  }
case 18:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:167
{ return yy.Token(_WIDE_);        }
case 19:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:168
{ return yy.Token(_XOR_);         }
case 20:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:169
{ return yy.Token(_FULLWORD_);    }
case 21:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:170
{ return yy.Token(_NOCASE_);      }
case 22:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:171
{ return yy.Token(_CONDITION_);   }
case 23:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:172
{ return yy.Token(_TRUE_);        }
case 24:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:173
{ return yy.Token(_FALSE_);       }
case 25:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:174
{ return yy.Token(_NOT_);         }
case 26:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:175
{ return yy.Token(_AND_);         }
case 27:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:176
{ return yy.Token(_OR_);          }
case 28:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:177
{ return yy.Token(_AT_);          }
case 29:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:178
{ return yy.Token(_IN_);          }
case 30:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:179
{ return yy.Token(_OF_);          }
case 31:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:180
{ return yy.Token(_THEM_);        }
case 32:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:181
{ return yy.Token(_FOR_);         }
case 33:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:182
{ return yy.Token(_ALL_);         }
case 34:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:183
{ return yy.Token(_ANY_);         }
case 35:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:184
{ return yy.Token(_ENTRYPOINT_);  }
case 36:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:185
{ return yy.Token(_FILESIZE_);    }
case 37:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:186
{ return yy.Token(_MATCHES_);     }
case 38:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:187
{ return yy.Token(_CONTAINS_);    }
case 39:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:188
{ return yy.Token(_ICONTAINS_);   }
case 40:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:189
{ return yy.Token(_STARTSWITH_);  }
case 41:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:190
{ return yy.Token(_ISTARTSWITH_); }
case 42:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:191
{ return yy.Token(_ENDSWITH_);    }
case 43:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:192
{ return yy.Token(_IENDSWITH_);   }
case 44:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:193
{ return yy.Token(_IMPORT_);      }
case 45:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:194
{ return yy.Token(_INCLUDE_);     }
case 46:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:196
{ yy.start = 1 + 2*  (COMMENT);       }
case 47:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:197
{ yy.start = 1 + 2*  (yyInitial );       }
case 48:
/* rule 48 can match eol */

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:198
{ /* skip comments */   }
case 49:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:201
{ /* skip single-line comments */ }
case (yyEndOfBuffer + yyInitial  + 1) :
	fallthrough
case (yyEndOfBuffer + STR + 1) :
	fallthrough
case (yyEndOfBuffer + REGEXP + 1) :
	fallthrough
case (yyEndOfBuffer + COMMENT + 1) :
//line parser/lexer.l:203
{ return yy.Token(eof) }
case 50:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:206
{
  return yy.TokenString(_STRING_IDENTIFIER_WITH_WILDCARD_, string(yytext));
}
case 51:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:211
{
  return yy.TokenString(_STRING_IDENTIFIER_, string(yytext));
}
case 52:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:216
{
  return yy.TokenString(_STRING_COUNT_, string(yytext));
}
case 53:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:221
{
  return yy.TokenString(_STRING_OFFSET_, string(yytext));
}
case 54:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:226
{
  return yy.TokenString(_STRING_LENGTH_, string(yytext));
}
case 55:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:231
{
  return yy.TokenString(_INTEGER_FUNCTION_, string(yytext));
}
case 56:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:236
{
  return yy.TokenString(_IDENTIFIER_, string(yytext));
}
case 57:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:241
{
  s := strings.TrimRight(YYtext, "MKB")
  v, err := strconv.ParseInt(s, 10, 64)
  if err != nil {
    return Error(
      gyperror.NumberConversionError,
      fmt.Sprintf("%s", err))
  }
  if strings.HasSuffix(YYtext, "KB") {
      if v > math.MaxInt64 / 1024 {
        return Error(
          gyperror.IntegerOverflowError,
          fmt.Sprintf("Found %s; Max: %d", YYtext, math.MaxInt64))
      } else {
        v *= 1024
      }
  } else if strings.HasSuffix(YYtext, "MB") {
      if v > math.MaxInt64 / 1048576 {
        return Error(
          gyperror.IntegerOverflowError,
          fmt.Sprintf("Found %s; Max: %d", YYtext, math.MaxInt64))
      } else {
          v *= 1048576
      }
  }
  return yy.TokenInt64(_NUMBER_, v);
}
case 58:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:269
{
  return yy.Token(_DOUBLE_);
}
case 59:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:273
{
  v, err := strconv.ParseInt(YYtext, 0, 64)
  if err != nil {
    return Error(
      gyperror.NumberConversionError,
      fmt.Sprintf("%s", err))
  }
  return yy.TokenInt64(_NUMBER_, v);
}
case 60:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:283
{
  s := strings.TrimLeft(YYtext, "0o")
  v, err := strconv.ParseInt(s, 8, 64)
  if err != nil {
    return Error(
      gyperror.NumberConversionError,
      fmt.Sprintf("%s", err))
  }
  return yy.TokenInt64(_NUMBER_, v);
}
case 61:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:295
{     /* saw closing quote - all done */
  yy.start = 1 + 2*  (yyInitial );
  return yy.TokenString(_TEXT_STRING_, string(str));
}
case 62:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:301
{
  str = append(str, yytext...)
}
case 63:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:306
{
  str = append(str, yytext...)
}
case 64:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:311
{
  str = append(str, yytext...)
}
case 65:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:316
{
  str = append(str, yytext...)
}
case 66:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:321
{
  str = append(str, yytext...)
}
case 67:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:326
{
  str = append(str, yytext...)
}
case 68:
/* rule 68 can match eol */

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:331
{
  return Error(
    gyperror.UnterminatedStringError,
    "unterminate string")
}
case 69:
/* rule 69 can match eol */

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:338
{
  return Error(
    gyperror.IllegalEscapeSequenceError,
    "illegal escape sequence")
}
case 70:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:345
{
  if err := validateAscii(string(regexp)); err != nil {
    return Error(gyperror.NonAsciiByteError, err.Error())
  }

  var mods ast.RegexpModifiers
  for _, c := range YYtext {
      switch c {
      case 'i':
          mods = mods | ast.RegexpCaseInsensitive
      case 's':
          mods = mods | ast.RegexpDotAll
      case '/':
          // Ignore
      default:
          // Should be impossible
          return Error(
            gyperror.InvalidRegexModifierError,
            fmt.Sprintf(`invalid regexp modifier "%c"`, c))
      }
  }

  yy.start = 1 + 2*  (yyInitial );
  return yy.TokenRegExp(&ast.LiteralRegexp{
     Value: string(regexp),
     Modifiers: mods,
  });
}
case 71:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:375
{
  regexp = append(regexp, yytext...)
}
case 72:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:380
{
  regexp = append(regexp, yytext...)
}
case 73:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:385
{
  regexp = append(regexp, yytext...)
}
case 74:
/* rule 74 can match eol */

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:390
{
  return Error(
    gyperror.UnterminatedRegexError,
    "unterminated regexp")
}
case 75:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:397
{
  str = []byte{}
  yy.start = 1 + 2*  (STR);
}
case 76:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:403
{
  regexp = []byte{}
  yy.start = 1 + 2*  (REGEXP);
}
case 77:
/* rule 77 can match eol */

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:409
{
  // Match hex-digits with whitespace or comments. The latter are stripped
  // out by hex_lexer.l

  // NOTE: The above comment may not apply. We plan to not use hex_lexer.l

  // No need to collect like str and regexp start conditions
  hexTokens, err := hex.Parse(strings.NewReader(YYtext))
  if err != nil {
    return YYtype{Error: err.(gyperror.Error)}
  }

  return yy.TokenHexString(hexTokens);
}
case 78:
/* rule 78 can match eol */

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:425
/* skip whitespace */
case 79:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:427
{

  r := int(yytext[0])

  if r >= 32 && r < 127 {
    return yy.Token(r)
  }

  return Error(
    gyperror.NonAsciiByteError,
    fmt.Sprintf(`non-ascii character "\x%02x"`, r))
}
case 80:

	yylineno = yy.Lineno
	YYtext = string(yytext)


//line parser/lexer.l:440
yyout.Write(yytext) 
//line parser/lexer.go:1510
// SKEL ----------------------------------------------------------------

		case yyEndOfBuffer:
			/* Amount of text matched not including the EOB char. */
			yyAmountOfMatchedText := yyCp - yy.textPtr - 1

			/* Undo the effects of yy_DO_BEFORE_ACTION. */
			yy.chBuf[yyCp] = yy.holdChar
			 
			if yy.bufferStatus == yyBufferNew {
				/* We're scanning a new file or input source.  It's
				 * possible that this happened because the user
				 * just pointed yyin at a new source and called
				 * yylex().  If so, then we have to assure
				 * consistency between yy_CURRENT_BUFFER and our
				 * globals.  Here is the right place to do so, because
				 * this is the first action (other than possibly a
				 * back-up) that will match for the new input source.
				 */
				yy.nChars = yy.bufNChars
				yy.inputFile = yy.In
				yy.bufferStatus = yyBufferNormal
			}

			/* Note that here we test for yy_c_buf_p "<=" to the position
			 * of the first EOB in the buffer, since yy_c_buf_p will
			 * already have been incremented past the NUL character
			 * (since all states make transitions on EOB to the
			 * end-of-buffer state).  Contrast this with the test
			 * in input().
			 */
			if yy.cBufP <= yy.nChars {
				/* This was really a NUL. */
				var yyNextState int

				yy.cBufP = yy.textPtr + yyAmountOfMatchedText

				yyCurrentState = yy.getPreviousState()

				/* Okay, we're now positioned to make the NUL
				 * transition.  We couldn't have
				 * yy_get_previous_state() go ahead and do it
				 * for us because it doesn't know how to deal
				 * with the possibility of jamming (and we don't
				 * want to build jamming into it because then it
				 * will run more slowly).
				 */

				yyNextState = yy.tryNulTrans(yyCurrentState)

				yyBp = yy.textPtr + 0 

				if yyNextState != 0 {
					/* Consume the NUL. */
					yy.cBufP++
					yyCp = yy.cBufP
					yyCurrentState = yyNextState
					goto yyMatch
				} else {

// [14.0] code to do back-up for compressed tables and set up yy_cp goes here
				yyCp = yy.lastAcceptingCpos
				yyCurrentState = yy.lastAcceptingState
// SKEL ----------------------------------------------------------------

					goto yyFindAction
				}

			} else {

				switch yy.getNextBuffer() {
				case eobActEndOfFile:
					yy.didBufferSwitchOnEof = false

					if yy.Wrap(yy) {
						// Note: because we've taken care in
						// yy_get_next_buffer() to have set up
						// yytext, we can now set up
						// yy.cBufP so that if some total
						// hoser (like flex itself) wants to
						// call the scanner after we return the
						// yy_NULL, it'll still work - another
						// yy_NULL will get returned.
						yy.cBufP = yy.textPtr + 0 

						yyAct = (yyEndOfBuffer + ((yy.start - 1) / 2)  + 1) 
						goto doAction
					} else {
						if !yy.didBufferSwitchOnEof {
							yy.NewFile()
						}
					}
				case eobActContinueScan:
					yy.cBufP = yy.textPtr + yyAmountOfMatchedText

					yyCurrentState = yy.getPreviousState()

					yyCp = yy.cBufP
					yyBp = yy.textPtr + 0 
					goto yyMatch
				case eobActLastMatch:
					yy.cBufP = yy.nChars

					yyCurrentState = yy.getPreviousState()

					yyCp = yy.cBufP
					yyBp = yy.textPtr + 0 
					goto yyFindAction
				}
			}

		default:
			log.Panicln("fatal flex scanner internal error--no action found:", yyAct)
		} // end of action switch
	} // end of scanning one token
	var yyvalue YYtype
	return yyvalue
} // end of yylex

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
func (yy *Scanner) getNextBuffer() int {

	var numberToMove int
	var retval int

	if yy.cBufP > yy.nChars+1 {
		log.Panic("fatal flex scanner internal error--end of buffer missed")
	}

	if !yy.fillBuffer {
		// Don't try to fill the buffer, so this is an EOF.
		if yy.cBufP-yy.textPtr-0  == 1 {
			// We matched a single character, the EOB, so
			// treat this as a final EOF.
			return eobActEndOfFile
		} else {
			// We matched some text prior to the EOB, first
			// process it.
			return eobActLastMatch
		}
	}

	// Try to read more data.

	// First move last chars to start of buffer.
	numberToMove = yy.cBufP - yy.textPtr - 1

	copy(yy.chBuf, yy.chBuf[yy.textPtr:yy.textPtr+numberToMove])

	if yy.bufferStatus == yyBufferEofPending {
		// don't do the read, it's not guaranteed to return an EOF,
		// just force an EOF
		yy.nChars = 0
		yy.bufNChars = 0
	} else {
		numToRead := yy.bufSize - numberToMove - 1

		for numToRead <= 0 {
			// Not enough room in the buffer - grow it.

			yyCBufPOffset := yy.cBufP

			new_size := yy.bufSize * 2

			if new_size <= 0 {
				yy.bufSize += yy.bufSize / 8
			} else {
				yy.bufSize *= 2
			}

			// Include room in for 2 EOB chars.
			bb := make([]byte, yy.bufSize+2-len(yy.chBuf))
			yy.chBuf = append(yy.chBuf, bb...)

			yy.cBufP = yyCBufPOffset

			numToRead = yy.bufSize - numberToMove - 1

		}

		if numToRead > yyReadBufSize {
			numToRead = yyReadBufSize
		}

		// Read in more data.
		yy.nChars = yy.input(numberToMove, numToRead)
		yy.bufNChars = yy.nChars
	}

	if yy.nChars == 0 {
		if numberToMove == 0  {
			retval = eobActEndOfFile
			yy.Restart(yy.In)
		} else {
			retval = eobActLastMatch
			yy.bufferStatus = yyBufferEofPending
		}
	} else {
		retval = eobActContinueScan
	}

	if yy.nChars+numberToMove > yy.bufSize {
		// Extend the array by 50%, plus the number we really need. *
		newSize := yy.nChars + numberToMove + (yy.nChars >> 1)
		if leng := len(yy.chBuf); leng < newSize {
			chBuf := make([]byte, newSize-leng)
			yy.chBuf = append(yy.chBuf, chBuf...)
		}
	}

	yy.nChars += numberToMove
	//yy.bufNChars += numberToMove // TODO: missing in C skel, bug?
	yy.chBuf[yy.nChars] = yyEndOfBufferChar
	yy.chBuf[yy.nChars+1] = yyEndOfBufferChar

	yy.textPtr = 0

	return retval
}

/* yy_get_previous_state - get the state just before the EOB char was reached */
func (yy *Scanner) getPreviousState() int {

	var yyCurrentState int
	var yyCp int

// [15.0] code to get the start state into yy_current_state goes here --
	yyCurrentState = yy.start
// SKEL ----------------------------------------------------------------

	for yyCp = yy.textPtr + 0 ; yyCp < yy.cBufP; yyCp++ {

// [16.0] code to find the next state goes here ------------------------
		yyC := yyIfElse(yy.chBuf[yyCp] != 0, int(yyEc[yy.chBuf[yyCp]]), 1)
				if yyAccept[yyCurrentState] != 0 {
			yy.lastAcceptingState = yyCurrentState
			yy.lastAcceptingCpos = yyCp
		}
		for int(yyChk[int(yyBase[yyCurrentState])+yyC]) != yyCurrentState {
			yyCurrentState = int(yyDef[yyCurrentState])
			if yyCurrentState >= 291 {
				yyC = int(yyMeta[yyC])
			}
		}
		yyCurrentState = int(yyNxt[int(yyBase[yyCurrentState])+yyC])
// SKEL ----------------------------------------------------------------

	}
	return yyCurrentState
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *      next_state = yy_try_NUL_trans( current_state );
 */
func (yy *Scanner) tryNulTrans(yyCurrentState int) int {

	var yyIsJam bool
	var yyCp int
	_ = yyCp

// [17.0] code to find the next state, and perhaps do backing up, goes here
	yyCp = yy.cBufP

	yyC := 1
		if yyAccept[yyCurrentState] != 0 {
		yy.lastAcceptingState = yyCurrentState
		yy.lastAcceptingCpos = yyCp
	}
	for int(yyChk[int(yyBase[yyCurrentState])+yyC]) != yyCurrentState {
		yyCurrentState = int(yyDef[yyCurrentState])
		if yyCurrentState >= 291 {
			yyC = int(yyMeta[yyC])
		}
	}
	yyCurrentState = int(yyNxt[int(yyBase[yyCurrentState])+yyC])
	if yyCurrentState == 290 {
		yyIsJam = true
	}
// SKEL ----------------------------------------------------------------

	if yyIsJam {
		return 0
	}
	return yyCurrentState
}

func (yy *Scanner) Input() (byte, error) {

	yy.chBuf[yy.cBufP] = yy.holdChar

	if yy.chBuf[yy.cBufP] == yyEndOfBufferChar {
		// yy_c_buf_p now points to the character we want to return.
		// If this occurs *before* the EOB characters, then it's a
		// valid NUL; if not, then we've hit the end of the buffer.
		if yy.cBufP < yy.nChars {
			// This was really a NUL.
			yy.chBuf[yy.cBufP] = 0
		} else {
			// need more input
			offset := yy.cBufP - yy.textPtr
			yy.cBufP++

			switch yy.getNextBuffer() {
			case eobActLastMatch:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
				yy.Restart(yy.In)

				fallthrough

			case eobActEndOfFile:
				if yy.Wrap(yy) {
					return 0, io.EOF
				}

				if !yy.didBufferSwitchOnEof {
					yy.Restart(yy.In)
				}

				return yy.Input()

			case eobActContinueScan:
				yy.cBufP = yy.textPtr + offset
			}
		}
	}

	c := yy.chBuf[yy.cBufP]
	yy.chBuf[yy.cBufP] = 0	// preserve yytext
	yy.cBufP++
	yy.holdChar = yy.chBuf[yy.cBufP]

// [19.0] update BOL and yylineno --------------------------------------
	if c == '\n' {
		yy.Lineno++
	}
// SKEL ----------------------------------------------------------------

return c, nil
}

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 *
 * @note This function does not reset the start condition to @c yyInitial  .
 */
func (yy *Scanner) Restart(input_file io.Reader) {
	yy.initBuffer(input_file)
	yy.loadBufferState()
}

func (yy *Scanner) loadBufferState() {
	yy.nChars = yy.bufNChars
	yy.cBufP = yy.bufPos
	yy.textPtr = yy.cBufP
	yy.In = yy.inputFile
	yy.holdChar = yy.chBuf[yy.cBufP]
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
func (yy *Scanner) initBuffer(file io.Reader) {

	yy.flushBuffer()

	yy.inputFile = file

	yy.fillBuffer = true

	yy.Interactive = yy.IsInteractive(file)

}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 *
 */
func (yy *Scanner) flushBuffer() {

	yy.bufNChars = 0

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	yy.chBuf[0] = yyEndOfBufferChar
	yy.chBuf[1] = yyEndOfBufferChar

	yy.bufPos = 0

	yy.atBol = 1
	yy.bufferStatus = yyBufferNew

	yy.loadBufferState()
}

func yyIfElse(b bool, i1, i2 int) int {
	if b {
		return i1
	}
	return i2
}

func YYmain(filenames ...string) (interface{}, error) {

	var errval error

	yy := NewScanner()

	yy.Filename = "<stdin>"

	if len(filenames) > 0 {
		yy.Filename = filenames[0]
		yy.In, errval = os.Open(yy.Filename)
		if errval != nil {
			return nil, errval
		}
		yy.Wrap = func(yyy *Scanner) bool {
			if len(filenames) == 0 {
				// should not happen
				return true
			}
			yyy.In.(*os.File).Close()
			filenames = filenames[1:]
			if len(filenames) == 0 {
				return true
			}
			yyy.Filename = filenames[0]
			yyy.In, errval = os.Open(yyy.Filename)
			if errval != nil {
				return true
			}
			return false
		}
	}

	return yy.Lex(), errval

}

// END OF SKELL --------------------------------------------------------
//line parser/lexer.l:440



