// Code generated by goyacc -p yr -o parser/parser.go parser/grammar.y. DO NOT EDIT.

//line parser/grammar.y:31
package parser

import __yyfmt__ "fmt"

//line parser/grammar.y:31

import (
	"github.com/VirusTotal/gyp/ast"
	gyperror "github.com/VirusTotal/gyp/error"
	"strings"
)

type modifiers uint64

const (
	_                   = iota // ignore first value by assigning to blank identifier
	ModGlobal modifiers = 1 << iota
	ModPrivate
	ModASCII
	ModWide
	ModXor
	ModFullword
	ModNocase
	ModBase64
	ModBase64Wide
)

type stringModifiers struct {
	modifiers
	XorMin         int32
	XorMax         int32
	Base64Alphabet string
}

//line parser/grammar.y:170
type yrSymType struct {
	yys        int
	i64        int64
	f64        float64
	s          string
	ss         []string
	reg        *ast.LiteralRegexp
	hexTokens  []ast.HexToken
	mod        modifiers
	smod       stringModifiers
	rule       *ast.Rule
	meta       *ast.Meta
	metas      []*ast.Meta
	ys         ast.String
	yss        []ast.String
	node       ast.Node
	nodes      []ast.Node
	rng        *ast.Range
	expr       ast.Expression
	exprs      []ast.Expression
	si         *ast.StringIdentifier
	sis        []*ast.StringIdentifier
	quantifier *ast.Quantifier

	// lineno is not a symbol type, it's the line number where the symbol
	// appears in the source file. This is a little hack used for passing
	// the line number where each token appears from the lexer to the parser.
	// This relies on the fact that Go doesn't implement unions, and therefore
	// goyacc actually uses a struct for passing around symbol values. Being
	// a struct those values can contain both the value itself (in some of
	// the fields listed above) and the line number. This wouldn't work with
	// C code produced by yacc, as this would be a union instead of a struct.
	//
	// This can be used within rule actions as:
	//
	//  lineNumber := $<lineno>1
	//
	// In the example lineNumber will hold the line number for the first
	// symbol in the production rule. The value for the symbol itself would
	// be $1 as usual. Similarly $<lineno>N will return the line number for
	// the N-th symbol in the production rule.

	lineno int
}

const _END_OF_INCLUDED_FILE_ = 57346
const _DOT_DOT_ = 57347
const _RULE_ = 57348
const _PRIVATE_ = 57349
const _GLOBAL_ = 57350
const _META_ = 57351
const _STRINGS_ = 57352
const _CONDITION_ = 57353
const _IDENTIFIER_ = 57354
const _STRING_IDENTIFIER_ = 57355
const _STRING_COUNT_ = 57356
const _STRING_OFFSET_ = 57357
const _STRING_LENGTH_ = 57358
const _STRING_IDENTIFIER_WITH_WILDCARD_ = 57359
const _NUMBER_ = 57360
const _DOUBLE_ = 57361
const _INTEGER_FUNCTION_ = 57362
const _TEXT_STRING_ = 57363
const _HEX_STRING_ = 57364
const _REGEXP_ = 57365
const _ASCII_ = 57366
const _WIDE_ = 57367
const _XOR_ = 57368
const _NOCASE_ = 57369
const _FULLWORD_ = 57370
const _BASE64_ = 57371
const _BASE64WIDE_ = 57372
const _AT_ = 57373
const _FILESIZE_ = 57374
const _ENTRYPOINT_ = 57375
const _ALL_ = 57376
const _ANY_ = 57377
const _IN_ = 57378
const _OF_ = 57379
const _FOR_ = 57380
const _THEM_ = 57381
const _MATCHES_ = 57382
const _CONTAINS_ = 57383
const _ICONTAINS_ = 57384
const _STARTSWITH_ = 57385
const _ISTARTSWITH_ = 57386
const _ENDSWITH_ = 57387
const _IENDSWITH_ = 57388
const _IMPORT_ = 57389
const _TRUE_ = 57390
const _FALSE_ = 57391
const _INCLUDE_ = 57392
const _OR_ = 57393
const _AND_ = 57394
const _EQ_ = 57395
const _NEQ_ = 57396
const _LT_ = 57397
const _LE_ = 57398
const _GT_ = 57399
const _GE_ = 57400
const _SHIFT_LEFT_ = 57401
const _SHIFT_RIGHT_ = 57402
const _NOT_ = 57403
const UNARY_MINUS = 57404

var yrToknames = [...]string{
	"$end",
	"error",
	"$unk",
	"_END_OF_INCLUDED_FILE_",
	"_DOT_DOT_",
	"_RULE_",
	"_PRIVATE_",
	"_GLOBAL_",
	"_META_",
	"_STRINGS_",
	"_CONDITION_",
	"_IDENTIFIER_",
	"_STRING_IDENTIFIER_",
	"_STRING_COUNT_",
	"_STRING_OFFSET_",
	"_STRING_LENGTH_",
	"_STRING_IDENTIFIER_WITH_WILDCARD_",
	"_NUMBER_",
	"_DOUBLE_",
	"_INTEGER_FUNCTION_",
	"_TEXT_STRING_",
	"_HEX_STRING_",
	"_REGEXP_",
	"_ASCII_",
	"_WIDE_",
	"_XOR_",
	"_NOCASE_",
	"_FULLWORD_",
	"_BASE64_",
	"_BASE64WIDE_",
	"_AT_",
	"_FILESIZE_",
	"_ENTRYPOINT_",
	"_ALL_",
	"_ANY_",
	"_IN_",
	"_OF_",
	"_FOR_",
	"_THEM_",
	"_MATCHES_",
	"_CONTAINS_",
	"_ICONTAINS_",
	"_STARTSWITH_",
	"_ISTARTSWITH_",
	"_ENDSWITH_",
	"_IENDSWITH_",
	"_IMPORT_",
	"_TRUE_",
	"_FALSE_",
	"_INCLUDE_",
	"_OR_",
	"_AND_",
	"'|'",
	"'^'",
	"'&'",
	"_EQ_",
	"_NEQ_",
	"_LT_",
	"_LE_",
	"_GT_",
	"_GE_",
	"_SHIFT_LEFT_",
	"_SHIFT_RIGHT_",
	"'+'",
	"'-'",
	"'*'",
	"'\\\\'",
	"'%'",
	"_NOT_",
	"'~'",
	"UNARY_MINUS",
	"'{'",
	"'}'",
	"':'",
	"'='",
	"'('",
	"')'",
	"'.'",
	"'['",
	"']'",
	"','",
}

var yrStatenames = [...]string{}

const yrEofCode = 1
const yrErrCode = 2
const yrInitialStackSize = 16

//line parser/grammar.y:1132

// This function takes an operator and two operands and returns a Expression
// representing the operation. If the left operand is an operation of the
// the same kind than the specified by the operator, the right operand is
// simply appended to that existing operation. This implies that the operator
// must be left-associative in order to be used with this function.
func operation(operator ast.OperatorType, left, right ast.Expression) (n ast.Expression) {
	if operation, ok := left.(*ast.Operation); ok && operation.Operator == operator {
		operation.Operands = append(operation.Operands, right)
		n = operation
	} else {
		n = &ast.Operation{
			Operator: operator,
			Operands: []ast.Expression{left, right},
		}
	}
	return n
}

//line yacctab:1
var yrExca = [...]int{
	-1, 1,
	1, -1,
	-2, 15,
	-1, 52,
	37, 108,
	-2, 95,
	-1, 112,
	37, 108,
	-2, 95,
	-1, 170,
	77, 66,
	81, 66,
	-2, 69,
	-1, 213,
	77, 67,
	81, 67,
	-2, 69,
}

const yrPrivate = 57344

const yrLast = 437

var yrAct = [...]int{
	52, 185, 151, 49, 67, 158, 81, 82, 83, 84,
	85, 86, 87, 228, 211, 181, 193, 229, 212, 101,
	99, 100, 92, 93, 88, 90, 89, 91, 102, 103,
	94, 95, 96, 97, 98, 101, 99, 100, 70, 119,
	116, 117, 118, 162, 102, 103, 94, 95, 96, 97,
	98, 80, 79, 80, 79, 107, 115, 240, 112, 234,
	182, 111, 191, 232, 231, 113, 73, 192, 161, 120,
	121, 233, 227, 160, 221, 216, 42, 239, 38, 237,
	215, 214, 152, 128, 129, 130, 131, 132, 133, 134,
	135, 136, 137, 138, 139, 140, 141, 142, 143, 144,
	145, 146, 147, 148, 149, 150, 48, 114, 39, 157,
	159, 218, 210, 40, 28, 163, 164, 165, 26, 167,
	127, 17, 110, 170, 94, 95, 96, 97, 98, 73,
	207, 64, 65, 66, 18, 61, 62, 60, 63, 55,
	74, 96, 97, 98, 79, 125, 126, 80, 79, 58,
	59, 71, 72, 180, 99, 100, 5, 109, 75, 77,
	76, 183, 102, 103, 94, 95, 96, 97, 98, 73,
	53, 64, 65, 66, 104, 61, 62, 60, 63, 105,
	74, 30, 68, 74, 208, 224, 205, 69, 153, 58,
	59, 71, 72, 108, 106, 54, 35, 213, 156, 7,
	223, 13, 4, 8, 217, 50, 51, 238, 220, 44,
	225, 37, 43, 78, 222, 102, 103, 94, 95, 96,
	97, 98, 68, 155, 186, 36, 56, 69, 187, 209,
	236, 41, 166, 57, 101, 99, 100, 31, 23, 46,
	47, 20, 14, 102, 103, 94, 95, 96, 97, 98,
	33, 25, 22, 101, 99, 100, 45, 9, 11, 12,
	179, 190, 102, 103, 94, 95, 96, 97, 98, 122,
	73, 27, 64, 65, 66, 15, 61, 62, 60, 63,
	189, 74, 1, 184, 177, 154, 206, 230, 204, 219,
	58, 59, 168, 235, 81, 82, 83, 84, 85, 86,
	87, 174, 173, 169, 175, 176, 32, 101, 99, 100,
	92, 93, 88, 90, 89, 91, 102, 103, 94, 95,
	96, 97, 98, 68, 6, 10, 124, 178, 69, 101,
	99, 100, 203, 123, 108, 172, 171, 194, 102, 103,
	94, 95, 96, 97, 98, 101, 99, 100, 34, 24,
	21, 29, 19, 226, 102, 103, 94, 95, 96, 97,
	98, 101, 99, 100, 16, 2, 3, 0, 0, 188,
	102, 103, 94, 95, 96, 97, 98, 0, 0, 0,
	101, 99, 100, 0, 0, 162, 0, 0, 0, 102,
	103, 94, 95, 96, 97, 98, 101, 99, 100, 0,
	0, 0, 0, 0, 0, 102, 103, 94, 95, 96,
	97, 98, 100, 199, 0, 0, 0, 0, 0, 102,
	103, 94, 95, 96, 97, 98, 0, 0, 0, 0,
	196, 195, 202, 197, 198, 200, 201,
}

var yrPact = [...]int{
	-1000, 152, -1000, -1000, 182, -1000, 251, 180, -1000, 230,
	-1000, -1000, -1000, -1000, -1000, 47, 62, 229, 243, 226,
	-1000, 241, 44, -1000, -1000, 40, 225, 239, 212, 225,
	-1000, 3, 35, 39, 212, -1000, 1, -1000, 191, -1000,
	157, -1000, 137, -1000, -1000, 195, -1000, -1000, 96, -1000,
	-1000, -1000, 254, 143, 117, 120, 157, 157, -1000, -1000,
	31, -1000, -1000, -1000, -1000, -23, -39, -37, 258, 258,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, 157,
	157, 160, 258, 258, 258, 258, 258, 258, 258, 258,
	258, 258, 258, 258, 258, 258, 258, 258, 258, 258,
	258, 258, 258, 258, 258, 6, 186, 343, 258, 34,
	-1000, -9, -34, 96, 258, 258, 258, 220, 258, 157,
	-1000, -1000, -1000, 277, 253, -1000, 92, -1000, 343, 343,
	343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
	75, 75, -1000, -1000, -1000, 357, 153, 100, 60, 60,
	343, -1000, 258, -1000, -21, 34, -1000, 308, -1000, 211,
	-1000, -1000, -1000, 292, 200, 181, -1000, -18, -10, -65,
	-1000, 406, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	327, 54, 217, 38, -63, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, 157, -1000, -1000, -1000, -1000, -1000, -1000,
	5, 4, -1, 258, 37, -37, -1000, 258, -1000, -1000,
	-2, -1000, 211, -1000, 179, 164, 192, 276, -4, -64,
	327, 157, -1000, -13, -14, -6, -1000, 157, -1000, 258,
	2, -1000, -1000, -1000, 189, 0, 343, -1000, -20, -1000,
	-1000,
}

var yrPgo = [...]int{
	0, 366, 365, 364, 352, 181, 351, 350, 349, 196,
	348, 337, 336, 335, 333, 327, 326, 325, 324, 306,
	3, 65, 0, 4, 303, 292, 139, 289, 288, 286,
	5, 38, 2, 285, 283, 1, 282, 275, 271, 269,
}

var yrR1 = [...]int{
	0, 36, 36, 36, 36, 36, 1, 37, 38, 2,
	7, 7, 8, 8, 19, 18, 18, 17, 17, 3,
	3, 4, 4, 6, 6, 5, 5, 5, 5, 5,
	10, 10, 39, 9, 9, 9, 12, 12, 11, 11,
	11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
	14, 14, 13, 13, 13, 13, 13, 16, 16, 15,
	23, 23, 23, 23, 25, 25, 24, 24, 31, 21,
	20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
	20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
	20, 20, 20, 20, 20, 20, 20, 29, 29, 32,
	27, 27, 30, 30, 34, 34, 35, 35, 26, 26,
	26, 33, 33, 28, 28, 22, 22, 22, 22, 22,
	22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
	22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
	22,
}

var yrR2 = [...]int{
	0, 0, 2, 2, 3, 2, 2, 0, 0, 11,
	0, 3, 0, 3, 3, 0, 2, 1, 1, 0,
	2, 1, 2, 1, 2, 3, 3, 4, 3, 3,
	1, 2, 0, 5, 4, 4, 0, 2, 1, 1,
	1, 1, 1, 1, 1, 4, 4, 1, 4, 6,
	0, 2, 1, 1, 1, 1, 1, 0, 2, 1,
	1, 3, 4, 4, 0, 1, 1, 3, 1, 1,
	1, 1, 3, 3, 3, 3, 3, 3, 3, 1,
	3, 3, 3, 9, 8, 3, 2, 3, 3, 3,
	3, 3, 3, 3, 3, 1, 3, 3, 1, 5,
	1, 3, 3, 1, 1, 3, 1, 1, 1, 1,
	1, 1, 3, 1, 1, 3, 1, 1, 4, 1,
	1, 1, 1, 4, 1, 4, 1, 1, 2, 3,
	3, 3, 3, 3, 3, 3, 3, 2, 3, 3,
	1,
}

var yrChk = [...]int{
	-1000, -36, -2, -1, 50, 4, -18, 47, 21, 6,
	-17, 7, 8, 21, 12, -37, -3, 74, 72, -4,
	12, -7, 9, 12, -8, 10, 74, -38, 74, -6,
	-5, 12, -19, 11, -10, -9, 13, -5, 75, 73,
	74, -9, 75, 21, 18, 65, 48, 49, -21, -20,
	48, 49, -22, 13, 38, -26, 69, 76, 32, 33,
	20, 18, 19, 21, 14, 15, 16, -23, 65, 70,
	-31, 34, 35, 12, 23, 21, 23, 22, 18, 52,
	51, 40, 41, 42, 43, 44, 45, 46, 58, 60,
	59, 61, 56, 57, 64, 65, 66, 67, 68, 54,
	55, 53, 62, 63, 31, 36, -26, -22, 76, 37,
	-21, -20, -22, -21, 76, 79, 79, 78, 79, 76,
	-22, -22, -39, -14, -16, -21, -21, -31, -22, -22,
	-22, -22, -22, -22, -22, -22, -22, -22, -22, -22,
	-22, -22, -22, -22, -22, -22, -22, -22, -22, -22,
	-22, -32, 76, 2, -33, 37, 12, -22, -30, 76,
	39, 77, 77, -22, -22, -22, 12, -22, -25, -24,
	-20, -12, -13, 25, 24, 27, 28, 7, -15, 7,
	-22, 36, 81, -30, -34, -35, 13, 17, 77, 80,
	80, 80, 77, 81, -11, 25, 24, 27, 28, 7,
	29, 30, 26, 5, -28, -23, -29, 76, -32, 12,
	74, 77, 81, -20, 76, 76, 76, -22, 74, -27,
	-22, 76, -35, 21, 21, 18, 77, 76, 77, 81,
	-21, 77, 77, 77, 65, -21, -22, 77, 18, 77,
	77,
}

var yrDef = [...]int{
	1, -2, 2, 3, 0, 5, 0, 0, 4, 0,
	16, 17, 18, 6, 7, 19, 0, 0, 10, 20,
	21, 12, 0, 22, 8, 0, 0, 0, 0, 11,
	23, 0, 0, 0, 13, 30, 0, 24, 0, 9,
	0, 31, 0, 25, 26, 0, 28, 29, 14, 69,
	70, 71, -2, 79, 0, 0, 0, 0, 116, 117,
	0, 119, 120, 121, 122, 124, 126, 127, 0, 0,
	140, 109, 110, 60, 68, 32, 50, 57, 27, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 108, 0, 0,
	86, 69, -2, 0, 0, 0, 0, 0, 0, 64,
	128, 137, 36, 34, 35, 87, 88, 72, 73, 74,
	75, 76, 77, 78, 89, 90, 91, 92, 93, 94,
	129, 130, 131, 132, 133, 134, 135, 136, 138, 139,
	80, 81, 0, 82, 0, 0, 111, 0, 85, 0,
	103, 96, 115, 0, 0, 0, 61, 0, 0, 65,
	-2, 33, 51, 52, 53, 54, 55, 56, 58, 59,
	0, 0, 0, 0, 0, 104, 106, 107, 118, 123,
	125, 62, 63, 0, 37, 38, 39, 40, 41, 42,
	43, 44, 47, 0, 0, 113, 114, 0, 98, 112,
	0, 102, 0, -2, 0, 0, 0, 0, 0, 0,
	100, 0, 105, 0, 0, 0, 99, 0, 97, 0,
	0, 45, 46, 48, 0, 0, 101, 84, 0, 83,
	49,
}

var yrTok1 = [...]int{
	1, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 68, 55, 3,
	76, 77, 66, 64, 81, 65, 78, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 74, 3,
	3, 75, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 79, 67, 80, 54, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 72, 53, 73, 70,
}

var yrTok2 = [...]int{
	2, 3, 4, 5, 6, 7, 8, 9, 10, 11,
	12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
	22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
	32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
	42, 43, 44, 45, 46, 47, 48, 49, 50, 51,
	52, 56, 57, 58, 59, 60, 61, 62, 63, 69,
	71,
}

var yrTok3 = [...]int{
	0,
}

var yrErrorMessages = [...]struct {
	state int
	token int
	msg   string
}{}

//line yaccpar:1

/*	parser for yacc output	*/

var (
	yrDebug        = 0
	yrErrorVerbose = false
)

type yrLexer interface {
	Lex(lval *yrSymType) int
	Error(s string)
}

type yrParser interface {
	Parse(yrLexer) int
	Lookahead() int
}

type yrParserImpl struct {
	lval  yrSymType
	stack [yrInitialStackSize]yrSymType
	char  int
}

func (p *yrParserImpl) Lookahead() int {
	return p.char
}

func yrNewParser() yrParser {
	return &yrParserImpl{}
}

const yrFlag = -1000

func yrTokname(c int) string {
	if c >= 1 && c-1 < len(yrToknames) {
		if yrToknames[c-1] != "" {
			return yrToknames[c-1]
		}
	}
	return __yyfmt__.Sprintf("tok-%v", c)
}

func yrStatname(s int) string {
	if s >= 0 && s < len(yrStatenames) {
		if yrStatenames[s] != "" {
			return yrStatenames[s]
		}
	}
	return __yyfmt__.Sprintf("state-%v", s)
}

func yrErrorMessage(state, lookAhead int) string {
	const TOKSTART = 4

	if !yrErrorVerbose {
		return "syntax error"
	}

	for _, e := range yrErrorMessages {
		if e.state == state && e.token == lookAhead {
			return "syntax error: " + e.msg
		}
	}

	res := "syntax error: unexpected " + yrTokname(lookAhead)

	// To match Bison, suggest at most four expected tokens.
	expected := make([]int, 0, 4)

	// Look for shiftable tokens.
	base := yrPact[state]
	for tok := TOKSTART; tok-1 < len(yrToknames); tok++ {
		if n := base + tok; n >= 0 && n < yrLast && yrChk[yrAct[n]] == tok {
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}
	}

	if yrDef[state] == -2 {
		i := 0
		for yrExca[i] != -1 || yrExca[i+1] != state {
			i += 2
		}

		// Look for tokens that we accept or reduce.
		for i += 2; yrExca[i] >= 0; i += 2 {
			tok := yrExca[i]
			if tok < TOKSTART || yrExca[i+1] == 0 {
				continue
			}
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}

		// If the default action is to accept or reduce, give up.
		if yrExca[i+1] != 0 {
			return res
		}
	}

	for i, tok := range expected {
		if i == 0 {
			res += ", expecting "
		} else {
			res += " or "
		}
		res += yrTokname(tok)
	}
	return res
}

func yrlex1(lex yrLexer, lval *yrSymType) (char, token int) {
	token = 0
	char = lex.Lex(lval)
	if char <= 0 {
		token = yrTok1[0]
		goto out
	}
	if char < len(yrTok1) {
		token = yrTok1[char]
		goto out
	}
	if char >= yrPrivate {
		if char < yrPrivate+len(yrTok2) {
			token = yrTok2[char-yrPrivate]
			goto out
		}
	}
	for i := 0; i < len(yrTok3); i += 2 {
		token = yrTok3[i+0]
		if token == char {
			token = yrTok3[i+1]
			goto out
		}
	}

out:
	if token == 0 {
		token = yrTok2[1] /* unknown char */
	}
	if yrDebug >= 3 {
		__yyfmt__.Printf("lex %s(%d)\n", yrTokname(token), uint(char))
	}
	return char, token
}

func yrParse(yrlex yrLexer) int {
	return yrNewParser().Parse(yrlex)
}

func (yrrcvr *yrParserImpl) Parse(yrlex yrLexer) int {
	var yrn int
	var yrVAL yrSymType
	var yrDollar []yrSymType
	_ = yrDollar // silence set and not used
	yrS := yrrcvr.stack[:]

	Nerrs := 0   /* number of errors */
	Errflag := 0 /* error recovery flag */
	yrstate := 0
	yrrcvr.char = -1
	yrtoken := -1 // yrrcvr.char translated into internal numbering
	defer func() {
		// Make sure we report no lookahead when not parsing.
		yrstate = -1
		yrrcvr.char = -1
		yrtoken = -1
	}()
	yrp := -1
	goto yrstack

ret0:
	return 0

ret1:
	return 1

yrstack:
	/* put a state and value onto the stack */
	if yrDebug >= 4 {
		__yyfmt__.Printf("char %v in %v\n", yrTokname(yrtoken), yrStatname(yrstate))
	}

	yrp++
	if yrp >= len(yrS) {
		nyys := make([]yrSymType, len(yrS)*2)
		copy(nyys, yrS)
		yrS = nyys
	}
	yrS[yrp] = yrVAL
	yrS[yrp].yys = yrstate

yrnewstate:
	yrn = yrPact[yrstate]
	if yrn <= yrFlag {
		goto yrdefault /* simple state */
	}
	if yrrcvr.char < 0 {
		yrrcvr.char, yrtoken = yrlex1(yrlex, &yrrcvr.lval)
	}
	yrn += yrtoken
	if yrn < 0 || yrn >= yrLast {
		goto yrdefault
	}
	yrn = yrAct[yrn]
	if yrChk[yrn] == yrtoken { /* valid shift */
		yrrcvr.char = -1
		yrtoken = -1
		yrVAL = yrrcvr.lval
		yrstate = yrn
		if Errflag > 0 {
			Errflag--
		}
		goto yrstack
	}

yrdefault:
	/* default state action */
	yrn = yrDef[yrstate]
	if yrn == -2 {
		if yrrcvr.char < 0 {
			yrrcvr.char, yrtoken = yrlex1(yrlex, &yrrcvr.lval)
		}

		/* look through exception table */
		xi := 0
		for {
			if yrExca[xi+0] == -1 && yrExca[xi+1] == yrstate {
				break
			}
			xi += 2
		}
		for xi += 2; ; xi += 2 {
			yrn = yrExca[xi+0]
			if yrn < 0 || yrn == yrtoken {
				break
			}
		}
		yrn = yrExca[xi+1]
		if yrn < 0 {
			goto ret0
		}
	}
	if yrn == 0 {
		/* error ... attempt to resume parsing */
		switch Errflag {
		case 0: /* brand new error */
			yrlex.Error(yrErrorMessage(yrstate, yrtoken))
			Nerrs++
			if yrDebug >= 1 {
				__yyfmt__.Printf("%s", yrStatname(yrstate))
				__yyfmt__.Printf(" saw %s\n", yrTokname(yrtoken))
			}
			fallthrough

		case 1, 2: /* incompletely recovered error ... try again */
			Errflag = 3

			/* find a state where "error" is a legal shift action */
			for yrp >= 0 {
				yrn = yrPact[yrS[yrp].yys] + yrErrCode
				if yrn >= 0 && yrn < yrLast {
					yrstate = yrAct[yrn] /* simulate a shift of "error" */
					if yrChk[yrstate] == yrErrCode {
						goto yrstack
					}
				}

				/* the current p has no shift on "error", pop stack */
				if yrDebug >= 2 {
					__yyfmt__.Printf("error recovery pops state %d\n", yrS[yrp].yys)
				}
				yrp--
			}
			/* there is no state on the stack with an error shift ... abort */
			goto ret1

		case 3: /* no shift yet; clobber input char */
			if yrDebug >= 2 {
				__yyfmt__.Printf("error recovery discards %s\n", yrTokname(yrtoken))
			}
			if yrtoken == yrEofCode {
				goto ret1
			}
			yrrcvr.char = -1
			yrtoken = -1
			goto yrnewstate /* try again in the same state */
		}
	}

	/* reduction by production yrn */
	if yrDebug >= 2 {
		__yyfmt__.Printf("reduce %v in:\n\t%v\n", yrn, yrStatname(yrstate))
	}

	yrnt := yrn
	yrpt := yrp
	_ = yrpt // guard against "declared and not used"

	yrp -= yrR2[yrn]
	// yrp is now the index of $0. Perform the default action. Iff the
	// reduced production is ε, $1 is possibly out of range.
	if yrp+1 >= len(yrS) {
		nyys := make([]yrSymType, len(yrS)*2)
		copy(nyys, yrS)
		yrS = nyys
	}
	yrVAL = yrS[yrp+1]

	/* consult goto table to find next state */
	yrn = yrR1[yrn]
	yrg := yrPgo[yrn]
	yrj := yrg + yrS[yrp].yys + 1

	if yrj >= yrLast {
		yrstate = yrAct[yrg]
	} else {
		yrstate = yrAct[yrj]
		if yrChk[yrstate] != -yrn {
			yrstate = yrAct[yrg]
		}
	}
	// dummy call; replaced with literal code
	switch yrnt {

	case 2:
		yrDollar = yrS[yrpt-2 : yrpt+1]
//line parser/grammar.y:220
		{
			ruleSet := asLexer(yrlex).ruleSet
			ruleSet.Rules = append(ruleSet.Rules, yrDollar[2].rule)
		}
	case 3:
		yrDollar = yrS[yrpt-2 : yrpt+1]
//line parser/grammar.y:225
		{
			ruleSet := asLexer(yrlex).ruleSet
			ruleSet.Imports = append(ruleSet.Imports, yrDollar[2].s)
		}
	case 4:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:230
		{
			ruleSet := asLexer(yrlex).ruleSet
			ruleSet.Includes = append(ruleSet.Includes, string(yrDollar[3].s))
		}
	case 5:
		yrDollar = yrS[yrpt-2 : yrpt+1]
//line parser/grammar.y:235
		{

		}
	case 6:
		yrDollar = yrS[yrpt-2 : yrpt+1]
//line parser/grammar.y:243
		{
			if err := validateAscii(yrDollar[2].s); err != nil {
				return asLexer(yrlex).setError(
					gyperror.NonAsciiByteError, err.Error())
			}

			yrVAL.s = yrDollar[2].s
		}
	case 7:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:256
		{
			lexer := asLexer(yrlex)

			// Forbid duplicate rules
			for _, r := range lexer.ruleSet.Rules {
				if yrDollar[3].s == r.Identifier {
					return lexer.setError(
						gyperror.DuplicateRuleError, `duplicate rule "%s"`, yrDollar[3].s)
				}
			}

			yrVAL.rule = &ast.Rule{
				LineNo:     yrDollar[2].lineno,
				Global:     yrDollar[1].mod&ModGlobal == ModGlobal,
				Private:    yrDollar[1].mod&ModPrivate == ModPrivate,
				Identifier: yrDollar[3].s,
			}
		}
	case 8:
		yrDollar = yrS[yrpt-8 : yrpt+1]
//line parser/grammar.y:275
		{
			yrDollar[4].rule.Tags = yrDollar[5].ss
			yrDollar[4].rule.Meta = yrDollar[7].metas
			yrDollar[4].rule.Strings = yrDollar[8].yss
		}
	case 9:
		yrDollar = yrS[yrpt-11 : yrpt+1]
//line parser/grammar.y:281
		{
			yrDollar[4].rule.Condition = yrDollar[10].expr
			yrVAL.rule = yrDollar[4].rule
		}
	case 10:
		yrDollar = yrS[yrpt-0 : yrpt+1]
//line parser/grammar.y:290
		{
			yrVAL.metas = []*ast.Meta{}
		}
	case 11:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:294
		{
			yrVAL.metas = yrDollar[3].metas
		}
	case 12:
		yrDollar = yrS[yrpt-0 : yrpt+1]
//line parser/grammar.y:302
		{
			yrVAL.yss = []ast.String{}
		}
	case 13:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:306
		{
			yrVAL.yss = yrDollar[3].yss
		}
	case 14:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:314
		{
			yrVAL.expr = yrDollar[3].expr
		}
	case 15:
		yrDollar = yrS[yrpt-0 : yrpt+1]
//line parser/grammar.y:322
		{
			yrVAL.mod = 0
		}
	case 16:
		yrDollar = yrS[yrpt-2 : yrpt+1]
//line parser/grammar.y:326
		{
			yrVAL.mod = yrDollar[1].mod | yrDollar[2].mod
		}
	case 17:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:334
		{
			yrVAL.mod = ModPrivate
		}
	case 18:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:338
		{
			yrVAL.mod = ModGlobal
		}
	case 19:
		yrDollar = yrS[yrpt-0 : yrpt+1]
//line parser/grammar.y:346
		{
			yrVAL.ss = []string{}
		}
	case 20:
		yrDollar = yrS[yrpt-2 : yrpt+1]
//line parser/grammar.y:350
		{
			yrVAL.ss = yrDollar[2].ss
		}
	case 21:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:358
		{
			yrVAL.ss = []string{yrDollar[1].s}
		}
	case 22:
		yrDollar = yrS[yrpt-2 : yrpt+1]
//line parser/grammar.y:362
		{
			lexer := asLexer(yrlex)

			for _, tag := range yrDollar[1].ss {
				if tag == yrDollar[2].s {
					return lexer.setError(
						gyperror.DuplicateTagError, `duplicate tag "%s"`, yrDollar[2].s)
				}
			}

			yrVAL.ss = append(yrDollar[1].ss, yrDollar[2].s)
		}
	case 23:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:379
		{
			yrVAL.metas = []*ast.Meta{yrDollar[1].meta}
		}
	case 24:
		yrDollar = yrS[yrpt-2 : yrpt+1]
//line parser/grammar.y:383
		{
			yrVAL.metas = append(yrDollar[1].metas, yrDollar[2].meta)
		}
	case 25:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:391
		{
			yrVAL.meta = &ast.Meta{
				Key:   yrDollar[1].s,
				Value: string(yrDollar[3].s),
			}
		}
	case 26:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:398
		{
			yrVAL.meta = &ast.Meta{
				Key:   yrDollar[1].s,
				Value: yrDollar[3].i64,
			}
		}
	case 27:
		yrDollar = yrS[yrpt-4 : yrpt+1]
//line parser/grammar.y:405
		{
			yrVAL.meta = &ast.Meta{
				Key:   yrDollar[1].s,
				Value: -yrDollar[4].i64,
			}
		}
	case 28:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:412
		{
			yrVAL.meta = &ast.Meta{
				Key:   yrDollar[1].s,
				Value: true,
			}
		}
	case 29:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:419
		{
			yrVAL.meta = &ast.Meta{
				Key:   yrDollar[1].s,
				Value: false,
			}
		}
	case 30:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:430
		{
			yrVAL.yss = []ast.String{yrDollar[1].ys}
		}
	case 31:
		yrDollar = yrS[yrpt-2 : yrpt+1]
//line parser/grammar.y:434
		{
			yrVAL.yss = append(yrDollar[1].yss, yrDollar[2].ys)
		}
	case 32:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:442
		{
			if err := validateAscii(yrDollar[3].s); err != nil {
				return asLexer(yrlex).setError(
					gyperror.NonAsciiByteError, err.Error())
			}
		}
	case 33:
		yrDollar = yrS[yrpt-5 : yrpt+1]
//line parser/grammar.y:449
		{
			yrVAL.ys = &ast.TextString{
				BaseString: ast.BaseString{
					Identifier: strings.TrimPrefix(yrDollar[1].s, "$"),
					LineNo:     yrDollar[1].lineno,
				},
				ASCII:          yrDollar[5].smod.modifiers&ModASCII != 0,
				Wide:           yrDollar[5].smod.modifiers&ModWide != 0,
				Nocase:         yrDollar[5].smod.modifiers&ModNocase != 0,
				Fullword:       yrDollar[5].smod.modifiers&ModFullword != 0,
				Private:        yrDollar[5].smod.modifiers&ModPrivate != 0,
				Base64:         yrDollar[5].smod.modifiers&ModBase64 != 0,
				Base64Wide:     yrDollar[5].smod.modifiers&ModBase64Wide != 0,
				Base64Alphabet: yrDollar[5].smod.Base64Alphabet,
				Xor:            yrDollar[5].smod.modifiers&ModXor != 0,
				XorMin:         yrDollar[5].smod.XorMin,
				XorMax:         yrDollar[5].smod.XorMax,
				Value:          yrDollar[3].s,
			}
		}
	case 34:
		yrDollar = yrS[yrpt-4 : yrpt+1]
//line parser/grammar.y:470
		{
			yrVAL.ys = &ast.RegexpString{
				BaseString: ast.BaseString{
					Identifier: strings.TrimPrefix(yrDollar[1].s, "$"),
					LineNo:     yrDollar[1].lineno,
				},
				ASCII:    yrDollar[4].mod&ModASCII != 0,
				Wide:     yrDollar[4].mod&ModWide != 0,
				Nocase:   yrDollar[4].mod&ModNocase != 0,
				Fullword: yrDollar[4].mod&ModFullword != 0,
				Private:  yrDollar[4].mod&ModPrivate != 0,
				Regexp:   yrDollar[3].reg,
			}
		}
	case 35:
		yrDollar = yrS[yrpt-4 : yrpt+1]
//line parser/grammar.y:485
		{
			yrVAL.ys = &ast.HexString{
				BaseString: ast.BaseString{
					Identifier: strings.TrimPrefix(yrDollar[1].s, "$"),
					LineNo:     yrDollar[1].lineno,
				},
				Private: yrDollar[4].mod&ModPrivate != 0,
				Tokens:  yrDollar[3].hexTokens,
			}
		}
	case 36:
		yrDollar = yrS[yrpt-0 : yrpt+1]
//line parser/grammar.y:500
		{
			yrVAL.smod = stringModifiers{}
		}
	case 37:
		yrDollar = yrS[yrpt-2 : yrpt+1]
//line parser/grammar.y:504
		{
			if yrDollar[1].smod.modifiers&yrDollar[2].smod.modifiers != 0 {
				return asLexer(yrlex).setError(
					gyperror.DuplicateModifierError, `duplicate modifier`)
			}

			yrDollar[1].smod.modifiers |= yrDollar[2].smod.modifiers

			if yrDollar[2].smod.modifiers&ModXor != 0 {
				yrDollar[1].smod.XorMin = yrDollar[2].smod.XorMin
				yrDollar[1].smod.XorMax = yrDollar[2].smod.XorMax
			}

			if yrDollar[2].smod.modifiers&(ModBase64|ModBase64Wide) != 0 {
				yrDollar[1].smod.Base64Alphabet = yrDollar[2].smod.Base64Alphabet
			}

			yrVAL.smod = yrDollar[1].smod
		}
	case 38:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:527
		{
			yrVAL.smod = stringModifiers{modifiers: ModWide}
		}
	case 39:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:528
		{
			yrVAL.smod = stringModifiers{modifiers: ModASCII}
		}
	case 40:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:529
		{
			yrVAL.smod = stringModifiers{modifiers: ModNocase}
		}
	case 41:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:530
		{
			yrVAL.smod = stringModifiers{modifiers: ModFullword}
		}
	case 42:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:531
		{
			yrVAL.smod = stringModifiers{modifiers: ModPrivate}
		}
	case 43:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:532
		{
			yrVAL.smod = stringModifiers{modifiers: ModBase64}
		}
	case 44:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:533
		{
			yrVAL.smod = stringModifiers{modifiers: ModBase64Wide}
		}
	case 45:
		yrDollar = yrS[yrpt-4 : yrpt+1]
//line parser/grammar.y:535
		{
			if err := validateAscii(yrDollar[3].s); err != nil {
				return asLexer(yrlex).setError(
					gyperror.NonAsciiByteError, err.Error())
			}

			if len(yrDollar[3].s) != 64 {
				return asLexer(yrlex).setError(
					gyperror.InvalidStringModifierError,
					"length of base64 alphabet must be 64")
			}

			yrVAL.smod = stringModifiers{
				modifiers:      ModBase64,
				Base64Alphabet: yrDollar[3].s,
			}
		}
	case 46:
		yrDollar = yrS[yrpt-4 : yrpt+1]
//line parser/grammar.y:553
		{
			if err := validateAscii(yrDollar[3].s); err != nil {
				return asLexer(yrlex).setError(
					gyperror.NonAsciiByteError, err.Error())
			}

			if len(yrDollar[3].s) != 64 {
				return asLexer(yrlex).setError(
					gyperror.InvalidStringModifierError,
					"length of base64 alphabet must be 64")
			}

			yrVAL.smod = stringModifiers{
				modifiers:      ModBase64Wide,
				Base64Alphabet: yrDollar[3].s,
			}
		}
	case 47:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:571
		{
			yrVAL.smod = stringModifiers{
				modifiers: ModXor,
				XorMin:    0,
				XorMax:    255,
			}
		}
	case 48:
		yrDollar = yrS[yrpt-4 : yrpt+1]
//line parser/grammar.y:579
		{
			yrVAL.smod = stringModifiers{
				modifiers: ModXor,
				XorMin:    int32(yrDollar[3].i64),
				XorMax:    int32(yrDollar[3].i64),
			}
		}
	case 49:
		yrDollar = yrS[yrpt-6 : yrpt+1]
//line parser/grammar.y:587
		{
			lexer := asLexer(yrlex)

			if yrDollar[3].i64 < 0 {
				return lexer.setError(
					gyperror.InvalidStringModifierError,
					"lower bound for xor range exceeded (min: 0)")
			}

			if yrDollar[5].i64 > 255 {
				return lexer.setError(
					gyperror.InvalidStringModifierError,
					"upper bound for xor range exceeded (max: 255)")
			}

			if yrDollar[3].i64 > yrDollar[5].i64 {
				return lexer.setError(
					gyperror.InvalidStringModifierError,
					"xor lower bound exceeds upper bound")
			}

			yrVAL.smod = stringModifiers{
				modifiers: ModXor,
				XorMin:    int32(yrDollar[3].i64),
				XorMax:    int32(yrDollar[5].i64),
			}
		}
	case 50:
		yrDollar = yrS[yrpt-0 : yrpt+1]
//line parser/grammar.y:619
		{
			yrVAL.mod = 0
		}
	case 51:
		yrDollar = yrS[yrpt-2 : yrpt+1]
//line parser/grammar.y:623
		{
			yrVAL.mod = yrDollar[1].mod | yrDollar[2].mod
		}
	case 52:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:630
		{
			yrVAL.mod = ModWide
		}
	case 53:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:631
		{
			yrVAL.mod = ModASCII
		}
	case 54:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:632
		{
			yrVAL.mod = ModNocase
		}
	case 55:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:633
		{
			yrVAL.mod = ModFullword
		}
	case 56:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:634
		{
			yrVAL.mod = ModPrivate
		}
	case 57:
		yrDollar = yrS[yrpt-0 : yrpt+1]
//line parser/grammar.y:640
		{
			yrVAL.mod = 0
		}
	case 58:
		yrDollar = yrS[yrpt-2 : yrpt+1]
//line parser/grammar.y:644
		{
			yrVAL.mod = yrDollar[1].mod | yrDollar[2].mod
		}
	case 59:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:651
		{
			yrVAL.mod = ModPrivate
		}
	case 60:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:657
		{
			yrVAL.expr = &ast.Identifier{Identifier: yrDollar[1].s}
		}
	case 61:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:661
		{
			yrVAL.expr = &ast.MemberAccess{
				Container: yrDollar[1].expr,
				Member:    yrDollar[3].s,
			}
		}
	case 62:
		yrDollar = yrS[yrpt-4 : yrpt+1]
//line parser/grammar.y:668
		{
			yrVAL.expr = &ast.Subscripting{
				Array: yrDollar[1].expr,
				Index: yrDollar[3].expr,
			}
		}
	case 63:
		yrDollar = yrS[yrpt-4 : yrpt+1]
//line parser/grammar.y:675
		{
			yrVAL.expr = &ast.FunctionCall{
				Callable:  yrDollar[1].expr,
				Arguments: yrDollar[3].exprs,
			}
		}
	case 64:
		yrDollar = yrS[yrpt-0 : yrpt+1]
//line parser/grammar.y:686
		{
			yrVAL.exprs = []ast.Expression{}
		}
	case 65:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:690
		{
			yrVAL.exprs = yrDollar[1].exprs
		}
	case 66:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:697
		{
			yrVAL.exprs = []ast.Expression{yrDollar[1].expr}
		}
	case 67:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:701
		{
			yrVAL.exprs = append(yrDollar[1].exprs, yrDollar[3].expr)
		}
	case 68:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:709
		{
			yrVAL.reg = yrDollar[1].reg
		}
	case 69:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:717
		{
			yrVAL.expr = yrDollar[1].expr
		}
	case 70:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:725
		{
			yrVAL.expr = ast.KeywordTrue
		}
	case 71:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:729
		{
			yrVAL.expr = ast.KeywordFalse
		}
	case 72:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:733
		{
			yrVAL.expr = &ast.Operation{
				Operator: ast.OpMatches,
				Operands: []ast.Expression{yrDollar[1].expr, yrDollar[3].reg},
			}
		}
	case 73:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:740
		{
			yrVAL.expr = &ast.Operation{
				Operator: ast.OpContains,
				Operands: []ast.Expression{yrDollar[1].expr, yrDollar[3].expr},
			}
		}
	case 74:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:747
		{
			yrVAL.expr = &ast.Operation{
				Operator: ast.OpIContains,
				Operands: []ast.Expression{yrDollar[1].expr, yrDollar[3].expr},
			}
		}
	case 75:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:754
		{
			yrVAL.expr = &ast.Operation{
				Operator: ast.OpStartsWith,
				Operands: []ast.Expression{yrDollar[1].expr, yrDollar[3].expr},
			}
		}
	case 76:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:761
		{
			yrVAL.expr = &ast.Operation{
				Operator: ast.OpIStartsWith,
				Operands: []ast.Expression{yrDollar[1].expr, yrDollar[3].expr},
			}
		}
	case 77:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:768
		{
			yrVAL.expr = &ast.Operation{
				Operator: ast.OpEndsWith,
				Operands: []ast.Expression{yrDollar[1].expr, yrDollar[3].expr},
			}
		}
	case 78:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:775
		{
			yrVAL.expr = &ast.Operation{
				Operator: ast.OpIEndsWith,
				Operands: []ast.Expression{yrDollar[1].expr, yrDollar[3].expr},
			}
		}
	case 79:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:782
		{
			yrVAL.expr = &ast.StringIdentifier{
				Identifier: strings.TrimPrefix(yrDollar[1].s, "$"),
			}
		}
	case 80:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:788
		{
			yrVAL.expr = &ast.StringIdentifier{
				Identifier: strings.TrimPrefix(yrDollar[1].s, "$"),
				At:         yrDollar[3].expr,
			}
		}
	case 81:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:795
		{
			yrVAL.expr = &ast.StringIdentifier{
				Identifier: strings.TrimPrefix(yrDollar[1].s, "$"),
				In:         yrDollar[3].rng,
			}
		}
	case 82:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:801
		{
		}
	case 83:
		yrDollar = yrS[yrpt-9 : yrpt+1]
//line parser/grammar.y:803
		{
			yrVAL.expr = &ast.ForIn{
				Quantifier: yrDollar[2].quantifier,
				Variables:  yrDollar[3].ss,
				Iterator:   yrDollar[5].node,
				Condition:  yrDollar[8].expr,
			}
		}
	case 84:
		yrDollar = yrS[yrpt-8 : yrpt+1]
//line parser/grammar.y:812
		{
			yrVAL.expr = &ast.ForOf{
				Quantifier: yrDollar[2].quantifier,
				Strings:    yrDollar[4].node,
				Condition:  yrDollar[7].expr,
			}
		}
	case 85:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:820
		{
			yrVAL.expr = &ast.Of{
				Quantifier: yrDollar[1].quantifier,
				Strings:    yrDollar[3].node,
			}
		}
	case 86:
		yrDollar = yrS[yrpt-2 : yrpt+1]
//line parser/grammar.y:827
		{
			yrVAL.expr = &ast.Not{yrDollar[2].expr}
		}
	case 87:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:831
		{
			yrVAL.expr = operation(ast.OpAnd, yrDollar[1].expr, yrDollar[3].expr)
		}
	case 88:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:835
		{
			yrVAL.expr = operation(ast.OpOr, yrDollar[1].expr, yrDollar[3].expr)
		}
	case 89:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:839
		{
			yrVAL.expr = &ast.Operation{
				Operator: ast.OpLessThan,
				Operands: []ast.Expression{yrDollar[1].expr, yrDollar[3].expr},
			}
		}
	case 90:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:846
		{
			yrVAL.expr = &ast.Operation{
				Operator: ast.OpGreaterThan,
				Operands: []ast.Expression{yrDollar[1].expr, yrDollar[3].expr},
			}
		}
	case 91:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:853
		{
			yrVAL.expr = &ast.Operation{
				Operator: ast.OpLessOrEqual,
				Operands: []ast.Expression{yrDollar[1].expr, yrDollar[3].expr},
			}
		}
	case 92:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:860
		{
			yrVAL.expr = &ast.Operation{
				Operator: ast.OpGreaterOrEqual,
				Operands: []ast.Expression{yrDollar[1].expr, yrDollar[3].expr},
			}
		}
	case 93:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:867
		{
			yrVAL.expr = &ast.Operation{
				Operator: ast.OpEqual,
				Operands: []ast.Expression{yrDollar[1].expr, yrDollar[3].expr},
			}
		}
	case 94:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:874
		{
			yrVAL.expr = &ast.Operation{
				Operator: ast.OpNotEqual,
				Operands: []ast.Expression{yrDollar[1].expr, yrDollar[3].expr},
			}
		}
	case 95:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:881
		{
			yrVAL.expr = yrDollar[1].expr
		}
	case 96:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:885
		{
			yrVAL.expr = &ast.Group{yrDollar[2].expr}
		}
	case 97:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:893
		{
			yrVAL.node = &ast.Enum{Values: yrDollar[2].exprs}
		}
	case 98:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:897
		{
			yrVAL.node = yrDollar[1].rng
		}
	case 99:
		yrDollar = yrS[yrpt-5 : yrpt+1]
//line parser/grammar.y:905
		{
			yrVAL.rng = &ast.Range{
				Start: yrDollar[2].expr,
				End:   yrDollar[4].expr,
			}
		}
	case 100:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:916
		{
			yrVAL.exprs = []ast.Expression{yrDollar[1].expr}
		}
	case 101:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:920
		{
			yrVAL.exprs = append(yrDollar[1].exprs, yrDollar[3].expr)
		}
	case 102:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:928
		{
			yrVAL.node = &ast.Enum{Values: yrDollar[2].exprs}
		}
	case 103:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:932
		{
			yrVAL.node = ast.KeywordThem
		}
	case 104:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:940
		{
			yrVAL.exprs = []ast.Expression{yrDollar[1].si}
		}
	case 105:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:944
		{
			yrVAL.exprs = append(yrDollar[1].exprs, yrDollar[3].si)
		}
	case 106:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:952
		{
			yrVAL.si = &ast.StringIdentifier{
				Identifier: strings.TrimPrefix(yrDollar[1].s, "$"),
			}
		}
	case 107:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:958
		{
			yrVAL.si = &ast.StringIdentifier{
				Identifier: strings.TrimPrefix(yrDollar[1].s, "$"),
			}
		}
	case 108:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:968
		{
			yrVAL.quantifier = &ast.Quantifier{yrDollar[1].expr}
		}
	case 109:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:972
		{
			yrVAL.quantifier = &ast.Quantifier{ast.KeywordAll}
		}
	case 110:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:976
		{
			yrVAL.quantifier = &ast.Quantifier{ast.KeywordAny}
		}
	case 111:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:984
		{
			yrVAL.ss = []string{yrDollar[1].s}
		}
	case 112:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:988
		{
			yrVAL.ss = append(yrDollar[1].ss, yrDollar[3].s)
		}
	case 113:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:995
		{
			yrVAL.node = yrDollar[1].expr
		}
	case 114:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:999
		{
			yrVAL.node = yrDollar[1].node
		}
	case 115:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:1007
		{
			yrVAL.expr = &ast.Group{yrDollar[2].expr}
		}
	case 116:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:1011
		{
			yrVAL.expr = ast.KeywordFilesize
		}
	case 117:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:1015
		{
			yrVAL.expr = ast.KeywordEntrypoint
		}
	case 118:
		yrDollar = yrS[yrpt-4 : yrpt+1]
//line parser/grammar.y:1019
		{
			yrVAL.expr = &ast.FunctionCall{
				Callable:  &ast.Identifier{Identifier: yrDollar[1].s},
				Arguments: []ast.Expression{yrDollar[3].expr},
			}
		}
	case 119:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:1026
		{
			yrVAL.expr = &ast.LiteralInteger{yrDollar[1].i64}
		}
	case 120:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:1030
		{
			yrVAL.expr = &ast.LiteralFloat{yrDollar[1].f64}
		}
	case 121:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:1034
		{
			if err := validateAscii(yrDollar[1].s); err != nil {
				return asLexer(yrlex).setError(
					gyperror.NonAsciiByteError, err.Error())
			}

			yrVAL.expr = &ast.LiteralString{yrDollar[1].s}
		}
	case 122:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:1043
		{
			yrVAL.expr = &ast.StringCount{
				Identifier: strings.TrimPrefix(yrDollar[1].s, "#"),
			}
		}
	case 123:
		yrDollar = yrS[yrpt-4 : yrpt+1]
//line parser/grammar.y:1049
		{
			yrVAL.expr = &ast.StringOffset{
				Identifier: strings.TrimPrefix(yrDollar[1].s, "@"),
				Index:      yrDollar[3].expr,
			}
		}
	case 124:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:1056
		{
			yrVAL.expr = &ast.StringOffset{
				Identifier: strings.TrimPrefix(yrDollar[1].s, "@"),
			}
		}
	case 125:
		yrDollar = yrS[yrpt-4 : yrpt+1]
//line parser/grammar.y:1062
		{
			yrVAL.expr = &ast.StringLength{
				Identifier: strings.TrimPrefix(yrDollar[1].s, "!"),
				Index:      yrDollar[3].expr,
			}
		}
	case 126:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:1069
		{
			yrVAL.expr = &ast.StringLength{
				Identifier: strings.TrimPrefix(yrDollar[1].s, "!"),
			}
		}
	case 127:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:1075
		{
			yrVAL.expr = yrDollar[1].expr
		}
	case 128:
		yrDollar = yrS[yrpt-2 : yrpt+1]
//line parser/grammar.y:1079
		{
			yrVAL.expr = &ast.Minus{yrDollar[2].expr}
		}
	case 129:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:1083
		{
			yrVAL.expr = operation(ast.OpAdd, yrDollar[1].expr, yrDollar[3].expr)
		}
	case 130:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:1087
		{
			yrVAL.expr = operation(ast.OpSub, yrDollar[1].expr, yrDollar[3].expr)
		}
	case 131:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:1091
		{
			yrVAL.expr = operation(ast.OpMul, yrDollar[1].expr, yrDollar[3].expr)
		}
	case 132:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:1095
		{
			yrVAL.expr = operation(ast.OpDiv, yrDollar[1].expr, yrDollar[3].expr)
		}
	case 133:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:1099
		{
			yrVAL.expr = operation(ast.OpMod, yrDollar[1].expr, yrDollar[3].expr)
		}
	case 134:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:1103
		{
			yrVAL.expr = operation(ast.OpBitXor, yrDollar[1].expr, yrDollar[3].expr)
		}
	case 135:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:1107
		{
			yrVAL.expr = operation(ast.OpBitAnd, yrDollar[1].expr, yrDollar[3].expr)
		}
	case 136:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:1111
		{
			yrVAL.expr = operation(ast.OpBitOr, yrDollar[1].expr, yrDollar[3].expr)
		}
	case 137:
		yrDollar = yrS[yrpt-2 : yrpt+1]
//line parser/grammar.y:1115
		{
			yrVAL.expr = &ast.BitwiseNot{yrDollar[2].expr}
		}
	case 138:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:1119
		{
			yrVAL.expr = operation(ast.OpShiftLeft, yrDollar[1].expr, yrDollar[3].expr)
		}
	case 139:
		yrDollar = yrS[yrpt-3 : yrpt+1]
//line parser/grammar.y:1123
		{
			yrVAL.expr = operation(ast.OpShiftRight, yrDollar[1].expr, yrDollar[3].expr)
		}
	case 140:
		yrDollar = yrS[yrpt-1 : yrpt+1]
//line parser/grammar.y:1127
		{
			yrVAL.expr = yrDollar[1].reg
		}
	}
	goto yrstack /* stack new state and value */
}
