// Code generated by protoc-gen-go. DO NOT EDIT.
// source: pb/yara.proto

package pb

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Keywords used in expressions of rule condition.
type Keyword int32

const (
	Keyword_UNKNOWN Keyword = 1
	// Raw offset of a PE or ELF file entrypoint.
	Keyword_ENTRYPOINT Keyword = 2
	// Size of the scanned file.
	Keyword_FILESIZE Keyword = 3
)

var Keyword_name = map[int32]string{
	1: "UNKNOWN",
	2: "ENTRYPOINT",
	3: "FILESIZE",
}

var Keyword_value = map[string]int32{
	"UNKNOWN":    1,
	"ENTRYPOINT": 2,
	"FILESIZE":   3,
}

func (x Keyword) Enum() *Keyword {
	p := new(Keyword)
	*p = x
	return p
}

func (x Keyword) String() string {
	return proto.EnumName(Keyword_name, int32(x))
}

func (x *Keyword) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Keyword_value, data, "Keyword")
	if err != nil {
		return err
	}
	*x = Keyword(value)
	return nil
}

func (Keyword) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{0}
}

// Keywords used in FOR expressions.
type ForKeyword int32

const (
	// All items must satisfy a condition.
	ForKeyword_ALL ForKeyword = 1
	// At least one item must satisfy a condition.
	ForKeyword_ANY ForKeyword = 2
)

var ForKeyword_name = map[int32]string{
	1: "ALL",
	2: "ANY",
}

var ForKeyword_value = map[string]int32{
	"ALL": 1,
	"ANY": 2,
}

func (x ForKeyword) Enum() *ForKeyword {
	p := new(ForKeyword)
	*p = x
	return p
}

func (x ForKeyword) String() string {
	return proto.EnumName(ForKeyword_name, int32(x))
}

func (x *ForKeyword) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ForKeyword_value, data, "ForKeyword")
	if err != nil {
		return err
	}
	*x = ForKeyword(value)
	return nil
}

func (ForKeyword) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{1}
}

// Keywords used in string sets.
type StringSetKeyword int32

const (
	// All the strings in the rule (equivalent to $*).
	StringSetKeyword_THEM StringSetKeyword = 1
)

var StringSetKeyword_name = map[int32]string{
	1: "THEM",
}

var StringSetKeyword_value = map[string]int32{
	"THEM": 1,
}

func (x StringSetKeyword) Enum() *StringSetKeyword {
	p := new(StringSetKeyword)
	*p = x
	return p
}

func (x StringSetKeyword) String() string {
	return proto.EnumName(StringSetKeyword_name, int32(x))
}

func (x *StringSetKeyword) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(StringSetKeyword_value, data, "StringSetKeyword")
	if err != nil {
		return err
	}
	*x = StringSetKeyword(value)
	return nil
}

func (StringSetKeyword) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{2}
}

type BinaryExpression_Operator int32

const (
	BinaryExpression_UNKNOWN          BinaryExpression_Operator = 0
	BinaryExpression_MATCHES          BinaryExpression_Operator = 1
	BinaryExpression_CONTAINS         BinaryExpression_Operator = 2
	BinaryExpression_AT               BinaryExpression_Operator = 3
	BinaryExpression_IN               BinaryExpression_Operator = 4
	BinaryExpression_LT               BinaryExpression_Operator = 5
	BinaryExpression_GT               BinaryExpression_Operator = 6
	BinaryExpression_LE               BinaryExpression_Operator = 7
	BinaryExpression_GE               BinaryExpression_Operator = 8
	BinaryExpression_EQ               BinaryExpression_Operator = 9
	BinaryExpression_NEQ              BinaryExpression_Operator = 10
	BinaryExpression_INTEGER_FUNCTION BinaryExpression_Operator = 11
	BinaryExpression_PLUS             BinaryExpression_Operator = 12
	BinaryExpression_MINUS            BinaryExpression_Operator = 13
	BinaryExpression_TIMES            BinaryExpression_Operator = 14
	BinaryExpression_DIV              BinaryExpression_Operator = 15
	BinaryExpression_MOD              BinaryExpression_Operator = 16
	BinaryExpression_XOR              BinaryExpression_Operator = 17
	BinaryExpression_BITWISE_AND      BinaryExpression_Operator = 18
	BinaryExpression_BITWISE_OR       BinaryExpression_Operator = 19
	BinaryExpression_SHIFT_LEFT       BinaryExpression_Operator = 20
	BinaryExpression_SHIFT_RIGHT      BinaryExpression_Operator = 21
	BinaryExpression_ICONTAINS        BinaryExpression_Operator = 22
	BinaryExpression_STARTSWITH       BinaryExpression_Operator = 23
	BinaryExpression_ISTARTSWITH      BinaryExpression_Operator = 24
	BinaryExpression_ENDSWITH         BinaryExpression_Operator = 25
	BinaryExpression_IENDSWITH        BinaryExpression_Operator = 26
)

var BinaryExpression_Operator_name = map[int32]string{
	0:  "UNKNOWN",
	1:  "MATCHES",
	2:  "CONTAINS",
	3:  "AT",
	4:  "IN",
	5:  "LT",
	6:  "GT",
	7:  "LE",
	8:  "GE",
	9:  "EQ",
	10: "NEQ",
	11: "INTEGER_FUNCTION",
	12: "PLUS",
	13: "MINUS",
	14: "TIMES",
	15: "DIV",
	16: "MOD",
	17: "XOR",
	18: "BITWISE_AND",
	19: "BITWISE_OR",
	20: "SHIFT_LEFT",
	21: "SHIFT_RIGHT",
	22: "ICONTAINS",
	23: "STARTSWITH",
	24: "ISTARTSWITH",
	25: "ENDSWITH",
	26: "IENDSWITH",
}

var BinaryExpression_Operator_value = map[string]int32{
	"UNKNOWN":          0,
	"MATCHES":          1,
	"CONTAINS":         2,
	"AT":               3,
	"IN":               4,
	"LT":               5,
	"GT":               6,
	"LE":               7,
	"GE":               8,
	"EQ":               9,
	"NEQ":              10,
	"INTEGER_FUNCTION": 11,
	"PLUS":             12,
	"MINUS":            13,
	"TIMES":            14,
	"DIV":              15,
	"MOD":              16,
	"XOR":              17,
	"BITWISE_AND":      18,
	"BITWISE_OR":       19,
	"SHIFT_LEFT":       20,
	"SHIFT_RIGHT":      21,
	"ICONTAINS":        22,
	"STARTSWITH":       23,
	"ISTARTSWITH":      24,
	"ENDSWITH":         25,
	"IENDSWITH":        26,
}

func (x BinaryExpression_Operator) Enum() *BinaryExpression_Operator {
	p := new(BinaryExpression_Operator)
	*p = x
	return p
}

func (x BinaryExpression_Operator) String() string {
	return proto.EnumName(BinaryExpression_Operator_name, int32(x))
}

func (x *BinaryExpression_Operator) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(BinaryExpression_Operator_value, data, "BinaryExpression_Operator")
	if err != nil {
		return err
	}
	*x = BinaryExpression_Operator(value)
	return nil
}

func (BinaryExpression_Operator) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{11, 0}
}

type UnaryExpression_Operator int32

const (
	UnaryExpression_UNKNOWN     UnaryExpression_Operator = 0
	UnaryExpression_UNARY_MINUS UnaryExpression_Operator = 1
	UnaryExpression_BITWISE_NOT UnaryExpression_Operator = 2
)

var UnaryExpression_Operator_name = map[int32]string{
	0: "UNKNOWN",
	1: "UNARY_MINUS",
	2: "BITWISE_NOT",
}

var UnaryExpression_Operator_value = map[string]int32{
	"UNKNOWN":     0,
	"UNARY_MINUS": 1,
	"BITWISE_NOT": 2,
}

func (x UnaryExpression_Operator) Enum() *UnaryExpression_Operator {
	p := new(UnaryExpression_Operator)
	*p = x
	return p
}

func (x UnaryExpression_Operator) String() string {
	return proto.EnumName(UnaryExpression_Operator_name, int32(x))
}

func (x *UnaryExpression_Operator) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(UnaryExpression_Operator_value, data, "UnaryExpression_Operator")
	if err != nil {
		return err
	}
	*x = UnaryExpression_Operator(value)
	return nil
}

func (UnaryExpression_Operator) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{12, 0}
}

// Rule modifiers.
type RuleModifiers struct {
	// Impose restrictions on all the rules in the ruleset.
	Global *bool `protobuf:"varint,1,opt,name=global" json:"global,omitempty"`
	// Rule is not reported when matches a file.
	Private              *bool    `protobuf:"varint,2,opt,name=private" json:"private,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RuleModifiers) Reset()         { *m = RuleModifiers{} }
func (m *RuleModifiers) String() string { return proto.CompactTextString(m) }
func (*RuleModifiers) ProtoMessage()    {}
func (*RuleModifiers) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{0}
}

func (m *RuleModifiers) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RuleModifiers.Unmarshal(m, b)
}
func (m *RuleModifiers) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RuleModifiers.Marshal(b, m, deterministic)
}
func (m *RuleModifiers) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RuleModifiers.Merge(m, src)
}
func (m *RuleModifiers) XXX_Size() int {
	return xxx_messageInfo_RuleModifiers.Size(m)
}
func (m *RuleModifiers) XXX_DiscardUnknown() {
	xxx_messageInfo_RuleModifiers.DiscardUnknown(m)
}

var xxx_messageInfo_RuleModifiers proto.InternalMessageInfo

func (m *RuleModifiers) GetGlobal() bool {
	if m != nil && m.Global != nil {
		return *m.Global
	}
	return false
}

func (m *RuleModifiers) GetPrivate() bool {
	if m != nil && m.Private != nil {
		return *m.Private
	}
	return false
}

// Rule metadata entry.
type Meta struct {
	// Metadata key. Can be repeated. Required.
	Key *string `protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	// Entry value, which can be a string, a number or a boolean.
	//
	// Types that are valid to be assigned to Value:
	//	*Meta_Text
	//	*Meta_Number
	//	*Meta_Boolean
	Value                isMeta_Value `protobuf_oneof:"value"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Meta) Reset()         { *m = Meta{} }
func (m *Meta) String() string { return proto.CompactTextString(m) }
func (*Meta) ProtoMessage()    {}
func (*Meta) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{1}
}

func (m *Meta) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Meta.Unmarshal(m, b)
}
func (m *Meta) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Meta.Marshal(b, m, deterministic)
}
func (m *Meta) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Meta.Merge(m, src)
}
func (m *Meta) XXX_Size() int {
	return xxx_messageInfo_Meta.Size(m)
}
func (m *Meta) XXX_DiscardUnknown() {
	xxx_messageInfo_Meta.DiscardUnknown(m)
}

var xxx_messageInfo_Meta proto.InternalMessageInfo

func (m *Meta) GetKey() string {
	if m != nil && m.Key != nil {
		return *m.Key
	}
	return ""
}

type isMeta_Value interface {
	isMeta_Value()
}

type Meta_Text struct {
	Text string `protobuf:"bytes,2,opt,name=text,oneof"`
}

type Meta_Number struct {
	Number int64 `protobuf:"varint,3,opt,name=number,oneof"`
}

type Meta_Boolean struct {
	Boolean bool `protobuf:"varint,4,opt,name=boolean,oneof"`
}

func (*Meta_Text) isMeta_Value() {}

func (*Meta_Number) isMeta_Value() {}

func (*Meta_Boolean) isMeta_Value() {}

func (m *Meta) GetValue() isMeta_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Meta) GetText() string {
	if x, ok := m.GetValue().(*Meta_Text); ok {
		return x.Text
	}
	return ""
}

func (m *Meta) GetNumber() int64 {
	if x, ok := m.GetValue().(*Meta_Number); ok {
		return x.Number
	}
	return 0
}

func (m *Meta) GetBoolean() bool {
	if x, ok := m.GetValue().(*Meta_Boolean); ok {
		return x.Boolean
	}
	return false
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Meta) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Meta_Text)(nil),
		(*Meta_Number)(nil),
		(*Meta_Boolean)(nil),
	}
}

// Rule string entry.
type String struct {
	// String identifier. Required.
	Id *string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// String value, which can be a text string, an hexadecimal string or a
	// regular expression.
	//
	// Types that are valid to be assigned to Value:
	//	*String_Text
	//	*String_Hex
	//	*String_Regexp
	Value                isString_Value `protobuf_oneof:"value"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *String) Reset()         { *m = String{} }
func (m *String) String() string { return proto.CompactTextString(m) }
func (*String) ProtoMessage()    {}
func (*String) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{2}
}

func (m *String) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_String.Unmarshal(m, b)
}
func (m *String) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_String.Marshal(b, m, deterministic)
}
func (m *String) XXX_Merge(src proto.Message) {
	xxx_messageInfo_String.Merge(m, src)
}
func (m *String) XXX_Size() int {
	return xxx_messageInfo_String.Size(m)
}
func (m *String) XXX_DiscardUnknown() {
	xxx_messageInfo_String.DiscardUnknown(m)
}

var xxx_messageInfo_String proto.InternalMessageInfo

func (m *String) GetId() string {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return ""
}

type isString_Value interface {
	isString_Value()
}

type String_Text struct {
	Text *TextString `protobuf:"bytes,2,opt,name=text,oneof"`
}

type String_Hex struct {
	Hex *HexTokens `protobuf:"bytes,3,opt,name=hex,oneof"`
}

type String_Regexp struct {
	Regexp *Regexp `protobuf:"bytes,4,opt,name=regexp,oneof"`
}

func (*String_Text) isString_Value() {}

func (*String_Hex) isString_Value() {}

func (*String_Regexp) isString_Value() {}

func (m *String) GetValue() isString_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *String) GetText() *TextString {
	if x, ok := m.GetValue().(*String_Text); ok {
		return x.Text
	}
	return nil
}

func (m *String) GetHex() *HexTokens {
	if x, ok := m.GetValue().(*String_Hex); ok {
		return x.Hex
	}
	return nil
}

func (m *String) GetRegexp() *Regexp {
	if x, ok := m.GetValue().(*String_Regexp); ok {
		return x.Regexp
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*String) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*String_Text)(nil),
		(*String_Hex)(nil),
		(*String_Regexp)(nil),
	}
}

// Modifiers for TextStrings and Regexps.
type StringModifiers struct {
	// Case-insensitive.
	Nocase *bool `protobuf:"varint,1,opt,name=nocase" json:"nocase,omitempty"`
	// Strings should be ASCII-encoded.
	Ascii *bool `protobuf:"varint,2,opt,name=ascii" json:"ascii,omitempty"`
	// String should be encoded with two bytes per character.
	Wide *bool `protobuf:"varint,3,opt,name=wide" json:"wide,omitempty"`
	// Only matches the string if it appears delimited by non-alphanumeric chars.
	Fullword *bool `protobuf:"varint,4,opt,name=fullword" json:"fullword,omitempty"`
	// Matches strings with a single-byte XOR applied to them.
	Xor *bool `protobuf:"varint,5,opt,name=xor" json:"xor,omitempty"`
	// Regexp case-insensitive modifier.
	I *bool `protobuf:"varint,6,opt,name=i" json:"i,omitempty"`
	// Regexp single-line modifier.
	S *bool `protobuf:"varint,7,opt,name=s" json:"s,omitempty"`
	// String is private.
	Private *bool `protobuf:"varint,8,opt,name=private" json:"private,omitempty"`
	// Minimum and maximum values for the XOR key. These values are present
	// only if the "xor" field is true.
	XorMin *int32 `protobuf:"varint,9,opt,name=xor_min,json=xorMin" json:"xor_min,omitempty"`
	XorMax *int32 `protobuf:"varint,10,opt,name=xor_max,json=xorMax" json:"xor_max,omitempty"`
	// String is base64.
	Base64 *bool `protobuf:"varint,11,opt,name=base64" json:"base64,omitempty"`
	// Optional alphabet for base64 strings.
	Base64Alphabet *string `protobuf:"bytes,12,opt,name=base64alphabet" json:"base64alphabet,omitempty"`
	// String is base64 wide.
	Base64Wide           *bool    `protobuf:"varint,13,opt,name=base64wide" json:"base64wide,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StringModifiers) Reset()         { *m = StringModifiers{} }
func (m *StringModifiers) String() string { return proto.CompactTextString(m) }
func (*StringModifiers) ProtoMessage()    {}
func (*StringModifiers) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{3}
}

func (m *StringModifiers) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StringModifiers.Unmarshal(m, b)
}
func (m *StringModifiers) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StringModifiers.Marshal(b, m, deterministic)
}
func (m *StringModifiers) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StringModifiers.Merge(m, src)
}
func (m *StringModifiers) XXX_Size() int {
	return xxx_messageInfo_StringModifiers.Size(m)
}
func (m *StringModifiers) XXX_DiscardUnknown() {
	xxx_messageInfo_StringModifiers.DiscardUnknown(m)
}

var xxx_messageInfo_StringModifiers proto.InternalMessageInfo

func (m *StringModifiers) GetNocase() bool {
	if m != nil && m.Nocase != nil {
		return *m.Nocase
	}
	return false
}

func (m *StringModifiers) GetAscii() bool {
	if m != nil && m.Ascii != nil {
		return *m.Ascii
	}
	return false
}

func (m *StringModifiers) GetWide() bool {
	if m != nil && m.Wide != nil {
		return *m.Wide
	}
	return false
}

func (m *StringModifiers) GetFullword() bool {
	if m != nil && m.Fullword != nil {
		return *m.Fullword
	}
	return false
}

func (m *StringModifiers) GetXor() bool {
	if m != nil && m.Xor != nil {
		return *m.Xor
	}
	return false
}

func (m *StringModifiers) GetI() bool {
	if m != nil && m.I != nil {
		return *m.I
	}
	return false
}

func (m *StringModifiers) GetS() bool {
	if m != nil && m.S != nil {
		return *m.S
	}
	return false
}

func (m *StringModifiers) GetPrivate() bool {
	if m != nil && m.Private != nil {
		return *m.Private
	}
	return false
}

func (m *StringModifiers) GetXorMin() int32 {
	if m != nil && m.XorMin != nil {
		return *m.XorMin
	}
	return 0
}

func (m *StringModifiers) GetXorMax() int32 {
	if m != nil && m.XorMax != nil {
		return *m.XorMax
	}
	return 0
}

func (m *StringModifiers) GetBase64() bool {
	if m != nil && m.Base64 != nil {
		return *m.Base64
	}
	return false
}

func (m *StringModifiers) GetBase64Alphabet() string {
	if m != nil && m.Base64Alphabet != nil {
		return *m.Base64Alphabet
	}
	return ""
}

func (m *StringModifiers) GetBase64Wide() bool {
	if m != nil && m.Base64Wide != nil {
		return *m.Base64Wide
	}
	return false
}

// Text string.
type TextString struct {
	// String content.
	Text *string `protobuf:"bytes,1,opt,name=text" json:"text,omitempty"`
	// String modifiers.
	Modifiers            *StringModifiers `protobuf:"bytes,2,opt,name=modifiers" json:"modifiers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *TextString) Reset()         { *m = TextString{} }
func (m *TextString) String() string { return proto.CompactTextString(m) }
func (*TextString) ProtoMessage()    {}
func (*TextString) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{4}
}

func (m *TextString) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextString.Unmarshal(m, b)
}
func (m *TextString) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextString.Marshal(b, m, deterministic)
}
func (m *TextString) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextString.Merge(m, src)
}
func (m *TextString) XXX_Size() int {
	return xxx_messageInfo_TextString.Size(m)
}
func (m *TextString) XXX_DiscardUnknown() {
	xxx_messageInfo_TextString.DiscardUnknown(m)
}

var xxx_messageInfo_TextString proto.InternalMessageInfo

func (m *TextString) GetText() string {
	if m != nil && m.Text != nil {
		return *m.Text
	}
	return ""
}

func (m *TextString) GetModifiers() *StringModifiers {
	if m != nil {
		return m.Modifiers
	}
	return nil
}

// Regular expression string.
type Regexp struct {
	// String content.
	Text *string `protobuf:"bytes,1,opt,name=text" json:"text,omitempty"`
	// String modifiers.
	Modifiers            *StringModifiers `protobuf:"bytes,2,opt,name=modifiers" json:"modifiers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Regexp) Reset()         { *m = Regexp{} }
func (m *Regexp) String() string { return proto.CompactTextString(m) }
func (*Regexp) ProtoMessage()    {}
func (*Regexp) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{5}
}

func (m *Regexp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Regexp.Unmarshal(m, b)
}
func (m *Regexp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Regexp.Marshal(b, m, deterministic)
}
func (m *Regexp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Regexp.Merge(m, src)
}
func (m *Regexp) XXX_Size() int {
	return xxx_messageInfo_Regexp.Size(m)
}
func (m *Regexp) XXX_DiscardUnknown() {
	xxx_messageInfo_Regexp.DiscardUnknown(m)
}

var xxx_messageInfo_Regexp proto.InternalMessageInfo

func (m *Regexp) GetText() string {
	if m != nil && m.Text != nil {
		return *m.Text
	}
	return ""
}

func (m *Regexp) GetModifiers() *StringModifiers {
	if m != nil {
		return m.Modifiers
	}
	return nil
}

// Sequence of hexadecimal string tokens.
type HexTokens struct {
	// Tokens.
	Token                []*HexToken `protobuf:"bytes,1,rep,name=token" json:"token,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *HexTokens) Reset()         { *m = HexTokens{} }
func (m *HexTokens) String() string { return proto.CompactTextString(m) }
func (*HexTokens) ProtoMessage()    {}
func (*HexTokens) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{6}
}

func (m *HexTokens) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HexTokens.Unmarshal(m, b)
}
func (m *HexTokens) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HexTokens.Marshal(b, m, deterministic)
}
func (m *HexTokens) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HexTokens.Merge(m, src)
}
func (m *HexTokens) XXX_Size() int {
	return xxx_messageInfo_HexTokens.Size(m)
}
func (m *HexTokens) XXX_DiscardUnknown() {
	xxx_messageInfo_HexTokens.DiscardUnknown(m)
}

var xxx_messageInfo_HexTokens proto.InternalMessageInfo

func (m *HexTokens) GetToken() []*HexToken {
	if m != nil {
		return m.Token
	}
	return nil
}

// A token in a hexadecimal string. A token can be either a sequence of bytes,
// a jump or an alternative.
type HexToken struct {
	// Types that are valid to be assigned to Value:
	//	*HexToken_Sequence
	//	*HexToken_Jump
	//	*HexToken_Alternative
	Value                isHexToken_Value `protobuf_oneof:"value"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *HexToken) Reset()         { *m = HexToken{} }
func (m *HexToken) String() string { return proto.CompactTextString(m) }
func (*HexToken) ProtoMessage()    {}
func (*HexToken) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{7}
}

func (m *HexToken) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HexToken.Unmarshal(m, b)
}
func (m *HexToken) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HexToken.Marshal(b, m, deterministic)
}
func (m *HexToken) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HexToken.Merge(m, src)
}
func (m *HexToken) XXX_Size() int {
	return xxx_messageInfo_HexToken.Size(m)
}
func (m *HexToken) XXX_DiscardUnknown() {
	xxx_messageInfo_HexToken.DiscardUnknown(m)
}

var xxx_messageInfo_HexToken proto.InternalMessageInfo

type isHexToken_Value interface {
	isHexToken_Value()
}

type HexToken_Sequence struct {
	Sequence *BytesSequence `protobuf:"bytes,1,opt,name=sequence,oneof"`
}

type HexToken_Jump struct {
	Jump *Jump `protobuf:"bytes,2,opt,name=jump,oneof"`
}

type HexToken_Alternative struct {
	Alternative *HexAlternative `protobuf:"bytes,3,opt,name=alternative,oneof"`
}

func (*HexToken_Sequence) isHexToken_Value() {}

func (*HexToken_Jump) isHexToken_Value() {}

func (*HexToken_Alternative) isHexToken_Value() {}

func (m *HexToken) GetValue() isHexToken_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *HexToken) GetSequence() *BytesSequence {
	if x, ok := m.GetValue().(*HexToken_Sequence); ok {
		return x.Sequence
	}
	return nil
}

func (m *HexToken) GetJump() *Jump {
	if x, ok := m.GetValue().(*HexToken_Jump); ok {
		return x.Jump
	}
	return nil
}

func (m *HexToken) GetAlternative() *HexAlternative {
	if x, ok := m.GetValue().(*HexToken_Alternative); ok {
		return x.Alternative
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*HexToken) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*HexToken_Sequence)(nil),
		(*HexToken_Jump)(nil),
		(*HexToken_Alternative)(nil),
	}
}

// List of alternatives for a part in the hexadecimal string.
type HexAlternative struct {
	// Alternatives, which are sequences of tokens.
	Tokens               []*HexTokens `protobuf:"bytes,1,rep,name=tokens" json:"tokens,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *HexAlternative) Reset()         { *m = HexAlternative{} }
func (m *HexAlternative) String() string { return proto.CompactTextString(m) }
func (*HexAlternative) ProtoMessage()    {}
func (*HexAlternative) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{8}
}

func (m *HexAlternative) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HexAlternative.Unmarshal(m, b)
}
func (m *HexAlternative) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HexAlternative.Marshal(b, m, deterministic)
}
func (m *HexAlternative) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HexAlternative.Merge(m, src)
}
func (m *HexAlternative) XXX_Size() int {
	return xxx_messageInfo_HexAlternative.Size(m)
}
func (m *HexAlternative) XXX_DiscardUnknown() {
	xxx_messageInfo_HexAlternative.DiscardUnknown(m)
}

var xxx_messageInfo_HexAlternative proto.InternalMessageInfo

func (m *HexAlternative) GetTokens() []*HexTokens {
	if m != nil {
		return m.Tokens
	}
	return nil
}

// A sequence of bytes, which may contain wildcards.
type BytesSequence struct {
	// The list of values.
	Value []byte `protobuf:"bytes,1,opt,name=value" json:"value,omitempty"`
	// The mask applied to each byte in value.
	// Indexes and length of value and mask must match.
	// Possible masks:
	// 00 -> Full wildcard, value is ignored (??).
	// 0F -> Nibble-wise wildcard (?v).
	// F0 -> Nibble-wise wildcard (v?).
	// FF -> No wildcard (vv).
	Mask                 []byte   `protobuf:"bytes,2,opt,name=mask" json:"mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BytesSequence) Reset()         { *m = BytesSequence{} }
func (m *BytesSequence) String() string { return proto.CompactTextString(m) }
func (*BytesSequence) ProtoMessage()    {}
func (*BytesSequence) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{9}
}

func (m *BytesSequence) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BytesSequence.Unmarshal(m, b)
}
func (m *BytesSequence) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BytesSequence.Marshal(b, m, deterministic)
}
func (m *BytesSequence) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BytesSequence.Merge(m, src)
}
func (m *BytesSequence) XXX_Size() int {
	return xxx_messageInfo_BytesSequence.Size(m)
}
func (m *BytesSequence) XXX_DiscardUnknown() {
	xxx_messageInfo_BytesSequence.DiscardUnknown(m)
}

var xxx_messageInfo_BytesSequence proto.InternalMessageInfo

func (m *BytesSequence) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *BytesSequence) GetMask() []byte {
	if m != nil {
		return m.Mask
	}
	return nil
}

// Sequence of arbitrary content and variable length.
type Jump struct {
	// Minimum jump length. 0 if not present.
	Start *int64 `protobuf:"varint,1,opt,name=start" json:"start,omitempty"`
	// Maximum jump length. Infinite if not present.
	End                  *int64   `protobuf:"varint,2,opt,name=end" json:"end,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Jump) Reset()         { *m = Jump{} }
func (m *Jump) String() string { return proto.CompactTextString(m) }
func (*Jump) ProtoMessage()    {}
func (*Jump) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{10}
}

func (m *Jump) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Jump.Unmarshal(m, b)
}
func (m *Jump) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Jump.Marshal(b, m, deterministic)
}
func (m *Jump) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Jump.Merge(m, src)
}
func (m *Jump) XXX_Size() int {
	return xxx_messageInfo_Jump.Size(m)
}
func (m *Jump) XXX_DiscardUnknown() {
	xxx_messageInfo_Jump.DiscardUnknown(m)
}

var xxx_messageInfo_Jump proto.InternalMessageInfo

func (m *Jump) GetStart() int64 {
	if m != nil && m.Start != nil {
		return *m.Start
	}
	return 0
}

func (m *Jump) GetEnd() int64 {
	if m != nil && m.End != nil {
		return *m.End
	}
	return 0
}

// Binary expression, consisting of two expressions joined by an operator.
type BinaryExpression struct {
	// Operator. Required.
	Operator *BinaryExpression_Operator `protobuf:"varint,1,opt,name=operator,enum=BinaryExpression_Operator" json:"operator,omitempty"`
	// Left expression. Required.
	Left *Expression `protobuf:"bytes,2,opt,name=left" json:"left,omitempty"`
	// Right expression. Required.
	Right                *Expression `protobuf:"bytes,3,opt,name=right" json:"right,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *BinaryExpression) Reset()         { *m = BinaryExpression{} }
func (m *BinaryExpression) String() string { return proto.CompactTextString(m) }
func (*BinaryExpression) ProtoMessage()    {}
func (*BinaryExpression) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{11}
}

func (m *BinaryExpression) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BinaryExpression.Unmarshal(m, b)
}
func (m *BinaryExpression) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BinaryExpression.Marshal(b, m, deterministic)
}
func (m *BinaryExpression) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BinaryExpression.Merge(m, src)
}
func (m *BinaryExpression) XXX_Size() int {
	return xxx_messageInfo_BinaryExpression.Size(m)
}
func (m *BinaryExpression) XXX_DiscardUnknown() {
	xxx_messageInfo_BinaryExpression.DiscardUnknown(m)
}

var xxx_messageInfo_BinaryExpression proto.InternalMessageInfo

func (m *BinaryExpression) GetOperator() BinaryExpression_Operator {
	if m != nil && m.Operator != nil {
		return *m.Operator
	}
	return BinaryExpression_UNKNOWN
}

func (m *BinaryExpression) GetLeft() *Expression {
	if m != nil {
		return m.Left
	}
	return nil
}

func (m *BinaryExpression) GetRight() *Expression {
	if m != nil {
		return m.Right
	}
	return nil
}

// Unary expression, consisting of an operator applied to an expression.
type UnaryExpression struct {
	// Operator. Required.
	Operator *UnaryExpression_Operator `protobuf:"varint,1,opt,name=operator,enum=UnaryExpression_Operator" json:"operator,omitempty"`
	// Expression. Required.
	Expression           *Expression `protobuf:"bytes,2,opt,name=expression" json:"expression,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *UnaryExpression) Reset()         { *m = UnaryExpression{} }
func (m *UnaryExpression) String() string { return proto.CompactTextString(m) }
func (*UnaryExpression) ProtoMessage()    {}
func (*UnaryExpression) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{12}
}

func (m *UnaryExpression) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UnaryExpression.Unmarshal(m, b)
}
func (m *UnaryExpression) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UnaryExpression.Marshal(b, m, deterministic)
}
func (m *UnaryExpression) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UnaryExpression.Merge(m, src)
}
func (m *UnaryExpression) XXX_Size() int {
	return xxx_messageInfo_UnaryExpression.Size(m)
}
func (m *UnaryExpression) XXX_DiscardUnknown() {
	xxx_messageInfo_UnaryExpression.DiscardUnknown(m)
}

var xxx_messageInfo_UnaryExpression proto.InternalMessageInfo

func (m *UnaryExpression) GetOperator() UnaryExpression_Operator {
	if m != nil && m.Operator != nil {
		return *m.Operator
	}
	return UnaryExpression_UNKNOWN
}

func (m *UnaryExpression) GetExpression() *Expression {
	if m != nil {
		return m.Expression
	}
	return nil
}

// A range of values. The start and end of a range are expressions, so they do
// not need to be constants.
type Range struct {
	// Range start. Required.
	Start *Expression `protobuf:"bytes,1,opt,name=start" json:"start,omitempty"`
	// Range end. Required.
	End                  *Expression `protobuf:"bytes,2,opt,name=end" json:"end,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *Range) Reset()         { *m = Range{} }
func (m *Range) String() string { return proto.CompactTextString(m) }
func (*Range) ProtoMessage()    {}
func (*Range) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{13}
}

func (m *Range) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Range.Unmarshal(m, b)
}
func (m *Range) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Range.Marshal(b, m, deterministic)
}
func (m *Range) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Range.Merge(m, src)
}
func (m *Range) XXX_Size() int {
	return xxx_messageInfo_Range.Size(m)
}
func (m *Range) XXX_DiscardUnknown() {
	xxx_messageInfo_Range.DiscardUnknown(m)
}

var xxx_messageInfo_Range proto.InternalMessageInfo

func (m *Range) GetStart() *Expression {
	if m != nil {
		return m.Start
	}
	return nil
}

func (m *Range) GetEnd() *Expression {
	if m != nil {
		return m.End
	}
	return nil
}

// Functions for reading data from a file at a specified offset or virtual address.
type IntegerFunction struct {
	// Integer function: (u)intXX(be). Required.
	Function *string `protobuf:"bytes,1,opt,name=function" json:"function,omitempty"`
	// Offset or virtual address. Required.
	Argument             *Expression `protobuf:"bytes,2,opt,name=argument" json:"argument,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *IntegerFunction) Reset()         { *m = IntegerFunction{} }
func (m *IntegerFunction) String() string { return proto.CompactTextString(m) }
func (*IntegerFunction) ProtoMessage()    {}
func (*IntegerFunction) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{14}
}

func (m *IntegerFunction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IntegerFunction.Unmarshal(m, b)
}
func (m *IntegerFunction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IntegerFunction.Marshal(b, m, deterministic)
}
func (m *IntegerFunction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IntegerFunction.Merge(m, src)
}
func (m *IntegerFunction) XXX_Size() int {
	return xxx_messageInfo_IntegerFunction.Size(m)
}
func (m *IntegerFunction) XXX_DiscardUnknown() {
	xxx_messageInfo_IntegerFunction.DiscardUnknown(m)
}

var xxx_messageInfo_IntegerFunction proto.InternalMessageInfo

func (m *IntegerFunction) GetFunction() string {
	if m != nil && m.Function != nil {
		return *m.Function
	}
	return ""
}

func (m *IntegerFunction) GetArgument() *Expression {
	if m != nil {
		return m.Argument
	}
	return nil
}

// Expression for iterating over iterators.
// Example: for <for_expression> k,v in iterator : ( expression )
// Next id: 6
type ForInExpression struct {
	// FOR expression: "for any". Required.
	ForExpression *ForExpression `protobuf:"bytes,1,opt,name=for_expression,json=forExpression" json:"for_expression,omitempty"`
	// Identifiers that will hold the values returned by the iterator. Required.
	Identifiers []string `protobuf:"bytes,2,rep,name=identifiers" json:"identifiers,omitempty"`
	// Iterator: "(1..10)", "(1,2,3)", "identifier" . Required.
	Iterator *Iterator `protobuf:"bytes,5,opt,name=iterator" json:"iterator,omitempty"`
	// Expression to match: "@s1[i] != @s2[i]". Required.
	Expression           *Expression `protobuf:"bytes,4,opt,name=expression" json:"expression,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *ForInExpression) Reset()         { *m = ForInExpression{} }
func (m *ForInExpression) String() string { return proto.CompactTextString(m) }
func (*ForInExpression) ProtoMessage()    {}
func (*ForInExpression) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{15}
}

func (m *ForInExpression) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ForInExpression.Unmarshal(m, b)
}
func (m *ForInExpression) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ForInExpression.Marshal(b, m, deterministic)
}
func (m *ForInExpression) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ForInExpression.Merge(m, src)
}
func (m *ForInExpression) XXX_Size() int {
	return xxx_messageInfo_ForInExpression.Size(m)
}
func (m *ForInExpression) XXX_DiscardUnknown() {
	xxx_messageInfo_ForInExpression.DiscardUnknown(m)
}

var xxx_messageInfo_ForInExpression proto.InternalMessageInfo

func (m *ForInExpression) GetForExpression() *ForExpression {
	if m != nil {
		return m.ForExpression
	}
	return nil
}

func (m *ForInExpression) GetIdentifiers() []string {
	if m != nil {
		return m.Identifiers
	}
	return nil
}

func (m *ForInExpression) GetIterator() *Iterator {
	if m != nil {
		return m.Iterator
	}
	return nil
}

func (m *ForInExpression) GetExpression() *Expression {
	if m != nil {
		return m.Expression
	}
	return nil
}

type Iterator struct {
	// Types that are valid to be assigned to Iterator:
	//	*Iterator_IntegerSet
	//	*Iterator_Identifier
	Iterator             isIterator_Iterator `protobuf_oneof:"iterator"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Iterator) Reset()         { *m = Iterator{} }
func (m *Iterator) String() string { return proto.CompactTextString(m) }
func (*Iterator) ProtoMessage()    {}
func (*Iterator) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{16}
}

func (m *Iterator) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Iterator.Unmarshal(m, b)
}
func (m *Iterator) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Iterator.Marshal(b, m, deterministic)
}
func (m *Iterator) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Iterator.Merge(m, src)
}
func (m *Iterator) XXX_Size() int {
	return xxx_messageInfo_Iterator.Size(m)
}
func (m *Iterator) XXX_DiscardUnknown() {
	xxx_messageInfo_Iterator.DiscardUnknown(m)
}

var xxx_messageInfo_Iterator proto.InternalMessageInfo

type isIterator_Iterator interface {
	isIterator_Iterator()
}

type Iterator_IntegerSet struct {
	IntegerSet *IntegerSet `protobuf:"bytes,1,opt,name=integer_set,json=integerSet,oneof"`
}

type Iterator_Identifier struct {
	Identifier *Identifier `protobuf:"bytes,2,opt,name=identifier,oneof"`
}

func (*Iterator_IntegerSet) isIterator_Iterator() {}

func (*Iterator_Identifier) isIterator_Iterator() {}

func (m *Iterator) GetIterator() isIterator_Iterator {
	if m != nil {
		return m.Iterator
	}
	return nil
}

func (m *Iterator) GetIntegerSet() *IntegerSet {
	if x, ok := m.GetIterator().(*Iterator_IntegerSet); ok {
		return x.IntegerSet
	}
	return nil
}

func (m *Iterator) GetIdentifier() *Identifier {
	if x, ok := m.GetIterator().(*Iterator_Identifier); ok {
		return x.Identifier
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Iterator) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Iterator_IntegerSet)(nil),
		(*Iterator_Identifier)(nil),
	}
}

// Set of integer numbers, which can be either an enumeration of integer values
// or a range of values.
type IntegerSet struct {
	// Types that are valid to be assigned to Set:
	//	*IntegerSet_IntegerEnumeration
	//	*IntegerSet_Range
	Set                  isIntegerSet_Set `protobuf_oneof:"set"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *IntegerSet) Reset()         { *m = IntegerSet{} }
func (m *IntegerSet) String() string { return proto.CompactTextString(m) }
func (*IntegerSet) ProtoMessage()    {}
func (*IntegerSet) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{17}
}

func (m *IntegerSet) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IntegerSet.Unmarshal(m, b)
}
func (m *IntegerSet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IntegerSet.Marshal(b, m, deterministic)
}
func (m *IntegerSet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IntegerSet.Merge(m, src)
}
func (m *IntegerSet) XXX_Size() int {
	return xxx_messageInfo_IntegerSet.Size(m)
}
func (m *IntegerSet) XXX_DiscardUnknown() {
	xxx_messageInfo_IntegerSet.DiscardUnknown(m)
}

var xxx_messageInfo_IntegerSet proto.InternalMessageInfo

type isIntegerSet_Set interface {
	isIntegerSet_Set()
}

type IntegerSet_IntegerEnumeration struct {
	IntegerEnumeration *IntegerEnumeration `protobuf:"bytes,1,opt,name=integer_enumeration,json=integerEnumeration,oneof"`
}

type IntegerSet_Range struct {
	Range *Range `protobuf:"bytes,2,opt,name=range,oneof"`
}

func (*IntegerSet_IntegerEnumeration) isIntegerSet_Set() {}

func (*IntegerSet_Range) isIntegerSet_Set() {}

func (m *IntegerSet) GetSet() isIntegerSet_Set {
	if m != nil {
		return m.Set
	}
	return nil
}

func (m *IntegerSet) GetIntegerEnumeration() *IntegerEnumeration {
	if x, ok := m.GetSet().(*IntegerSet_IntegerEnumeration); ok {
		return x.IntegerEnumeration
	}
	return nil
}

func (m *IntegerSet) GetRange() *Range {
	if x, ok := m.GetSet().(*IntegerSet_Range); ok {
		return x.Range
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*IntegerSet) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*IntegerSet_IntegerEnumeration)(nil),
		(*IntegerSet_Range)(nil),
	}
}

// Enumeration of integer values.
type IntegerEnumeration struct {
	// Enumeration values, which can be calculated from an expression.
	Values               []*Expression `protobuf:"bytes,1,rep,name=values" json:"values,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *IntegerEnumeration) Reset()         { *m = IntegerEnumeration{} }
func (m *IntegerEnumeration) String() string { return proto.CompactTextString(m) }
func (*IntegerEnumeration) ProtoMessage()    {}
func (*IntegerEnumeration) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{18}
}

func (m *IntegerEnumeration) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IntegerEnumeration.Unmarshal(m, b)
}
func (m *IntegerEnumeration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IntegerEnumeration.Marshal(b, m, deterministic)
}
func (m *IntegerEnumeration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IntegerEnumeration.Merge(m, src)
}
func (m *IntegerEnumeration) XXX_Size() int {
	return xxx_messageInfo_IntegerEnumeration.Size(m)
}
func (m *IntegerEnumeration) XXX_DiscardUnknown() {
	xxx_messageInfo_IntegerEnumeration.DiscardUnknown(m)
}

var xxx_messageInfo_IntegerEnumeration proto.InternalMessageInfo

func (m *IntegerEnumeration) GetValues() []*Expression {
	if m != nil {
		return m.Values
	}
	return nil
}

// FOR expression, used as part of ForInExpressions and ForOrExpressions.
// Can contain either an expression or a keyword.
type ForExpression struct {
	// Types that are valid to be assigned to For:
	//	*ForExpression_Expression
	//	*ForExpression_Keyword
	For                  isForExpression_For `protobuf_oneof:"for"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ForExpression) Reset()         { *m = ForExpression{} }
func (m *ForExpression) String() string { return proto.CompactTextString(m) }
func (*ForExpression) ProtoMessage()    {}
func (*ForExpression) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{19}
}

func (m *ForExpression) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ForExpression.Unmarshal(m, b)
}
func (m *ForExpression) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ForExpression.Marshal(b, m, deterministic)
}
func (m *ForExpression) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ForExpression.Merge(m, src)
}
func (m *ForExpression) XXX_Size() int {
	return xxx_messageInfo_ForExpression.Size(m)
}
func (m *ForExpression) XXX_DiscardUnknown() {
	xxx_messageInfo_ForExpression.DiscardUnknown(m)
}

var xxx_messageInfo_ForExpression proto.InternalMessageInfo

type isForExpression_For interface {
	isForExpression_For()
}

type ForExpression_Expression struct {
	Expression *Expression `protobuf:"bytes,1,opt,name=expression,oneof"`
}

type ForExpression_Keyword struct {
	Keyword ForKeyword `protobuf:"varint,2,opt,name=keyword,enum=ForKeyword,oneof"`
}

func (*ForExpression_Expression) isForExpression_For() {}

func (*ForExpression_Keyword) isForExpression_For() {}

func (m *ForExpression) GetFor() isForExpression_For {
	if m != nil {
		return m.For
	}
	return nil
}

func (m *ForExpression) GetExpression() *Expression {
	if x, ok := m.GetFor().(*ForExpression_Expression); ok {
		return x.Expression
	}
	return nil
}

func (m *ForExpression) GetKeyword() ForKeyword {
	if x, ok := m.GetFor().(*ForExpression_Keyword); ok {
		return x.Keyword
	}
	return ForKeyword_ALL
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ForExpression) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ForExpression_Expression)(nil),
		(*ForExpression_Keyword)(nil),
	}
}

// A ForOfExpression is satisfied if at least "expression" strings in "string_set"
// satisfy "expression".
// Example: for all of ($s1, $s2) : (@$ > 10)
type ForOfExpression struct {
	// FOR expression: "for all". Required.
	ForExpression *ForExpression `protobuf:"bytes,1,opt,name=for_expression,json=forExpression" json:"for_expression,omitempty"`
	// String set: "($s1, $s2)". Required.
	StringSet *StringSet `protobuf:"bytes,2,opt,name=string_set,json=stringSet" json:"string_set,omitempty"`
	// Expression to match: "(@$ > 10)"
	Expression           *Expression `protobuf:"bytes,3,opt,name=expression" json:"expression,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *ForOfExpression) Reset()         { *m = ForOfExpression{} }
func (m *ForOfExpression) String() string { return proto.CompactTextString(m) }
func (*ForOfExpression) ProtoMessage()    {}
func (*ForOfExpression) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{20}
}

func (m *ForOfExpression) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ForOfExpression.Unmarshal(m, b)
}
func (m *ForOfExpression) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ForOfExpression.Marshal(b, m, deterministic)
}
func (m *ForOfExpression) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ForOfExpression.Merge(m, src)
}
func (m *ForOfExpression) XXX_Size() int {
	return xxx_messageInfo_ForOfExpression.Size(m)
}
func (m *ForOfExpression) XXX_DiscardUnknown() {
	xxx_messageInfo_ForOfExpression.DiscardUnknown(m)
}

var xxx_messageInfo_ForOfExpression proto.InternalMessageInfo

func (m *ForOfExpression) GetForExpression() *ForExpression {
	if m != nil {
		return m.ForExpression
	}
	return nil
}

func (m *ForOfExpression) GetStringSet() *StringSet {
	if m != nil {
		return m.StringSet
	}
	return nil
}

func (m *ForOfExpression) GetExpression() *Expression {
	if m != nil {
		return m.Expression
	}
	return nil
}

// Set of strings. Can be either an enumeration of strings or a keyword.
type StringSet struct {
	// Types that are valid to be assigned to Set:
	//	*StringSet_Strings
	//	*StringSet_Keyword
	Set                  isStringSet_Set `protobuf_oneof:"set"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *StringSet) Reset()         { *m = StringSet{} }
func (m *StringSet) String() string { return proto.CompactTextString(m) }
func (*StringSet) ProtoMessage()    {}
func (*StringSet) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{21}
}

func (m *StringSet) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StringSet.Unmarshal(m, b)
}
func (m *StringSet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StringSet.Marshal(b, m, deterministic)
}
func (m *StringSet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StringSet.Merge(m, src)
}
func (m *StringSet) XXX_Size() int {
	return xxx_messageInfo_StringSet.Size(m)
}
func (m *StringSet) XXX_DiscardUnknown() {
	xxx_messageInfo_StringSet.DiscardUnknown(m)
}

var xxx_messageInfo_StringSet proto.InternalMessageInfo

type isStringSet_Set interface {
	isStringSet_Set()
}

type StringSet_Strings struct {
	Strings *StringEnumeration `protobuf:"bytes,1,opt,name=strings,oneof"`
}

type StringSet_Keyword struct {
	Keyword StringSetKeyword `protobuf:"varint,2,opt,name=keyword,enum=StringSetKeyword,oneof"`
}

func (*StringSet_Strings) isStringSet_Set() {}

func (*StringSet_Keyword) isStringSet_Set() {}

func (m *StringSet) GetSet() isStringSet_Set {
	if m != nil {
		return m.Set
	}
	return nil
}

func (m *StringSet) GetStrings() *StringEnumeration {
	if x, ok := m.GetSet().(*StringSet_Strings); ok {
		return x.Strings
	}
	return nil
}

func (m *StringSet) GetKeyword() StringSetKeyword {
	if x, ok := m.GetSet().(*StringSet_Keyword); ok {
		return x.Keyword
	}
	return StringSetKeyword_THEM
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*StringSet) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*StringSet_Strings)(nil),
		(*StringSet_Keyword)(nil),
	}
}

// Enumeration of strings, referenced by their identifier.
// A wildcard can be used to match multiple strings.
// Examples: $str1, $str*
type StringEnumeration struct {
	// Items in the strings enumeration.
	Items                []*StringEnumeration_StringEnumerationItem `protobuf:"bytes,1,rep,name=items" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                   `json:"-"`
	XXX_unrecognized     []byte                                     `json:"-"`
	XXX_sizecache        int32                                      `json:"-"`
}

func (m *StringEnumeration) Reset()         { *m = StringEnumeration{} }
func (m *StringEnumeration) String() string { return proto.CompactTextString(m) }
func (*StringEnumeration) ProtoMessage()    {}
func (*StringEnumeration) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{22}
}

func (m *StringEnumeration) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StringEnumeration.Unmarshal(m, b)
}
func (m *StringEnumeration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StringEnumeration.Marshal(b, m, deterministic)
}
func (m *StringEnumeration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StringEnumeration.Merge(m, src)
}
func (m *StringEnumeration) XXX_Size() int {
	return xxx_messageInfo_StringEnumeration.Size(m)
}
func (m *StringEnumeration) XXX_DiscardUnknown() {
	xxx_messageInfo_StringEnumeration.DiscardUnknown(m)
}

var xxx_messageInfo_StringEnumeration proto.InternalMessageInfo

func (m *StringEnumeration) GetItems() []*StringEnumeration_StringEnumerationItem {
	if m != nil {
		return m.Items
	}
	return nil
}

// An entry in the strings enumeration.
type StringEnumeration_StringEnumerationItem struct {
	// String identifier or part of it if a wildcard (*) is used.
	// Includes the wildcard if present.
	StringIdentifier *string `protobuf:"bytes,1,opt,name=string_identifier,json=stringIdentifier" json:"string_identifier,omitempty"`
	// Wildcard (*).
	HasWildcard          *bool    `protobuf:"varint,2,opt,name=has_wildcard,json=hasWildcard" json:"has_wildcard,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StringEnumeration_StringEnumerationItem) Reset() {
	*m = StringEnumeration_StringEnumerationItem{}
}
func (m *StringEnumeration_StringEnumerationItem) String() string { return proto.CompactTextString(m) }
func (*StringEnumeration_StringEnumerationItem) ProtoMessage()    {}
func (*StringEnumeration_StringEnumerationItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{22, 0}
}

func (m *StringEnumeration_StringEnumerationItem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StringEnumeration_StringEnumerationItem.Unmarshal(m, b)
}
func (m *StringEnumeration_StringEnumerationItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StringEnumeration_StringEnumerationItem.Marshal(b, m, deterministic)
}
func (m *StringEnumeration_StringEnumerationItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StringEnumeration_StringEnumerationItem.Merge(m, src)
}
func (m *StringEnumeration_StringEnumerationItem) XXX_Size() int {
	return xxx_messageInfo_StringEnumeration_StringEnumerationItem.Size(m)
}
func (m *StringEnumeration_StringEnumerationItem) XXX_DiscardUnknown() {
	xxx_messageInfo_StringEnumeration_StringEnumerationItem.DiscardUnknown(m)
}

var xxx_messageInfo_StringEnumeration_StringEnumerationItem proto.InternalMessageInfo

func (m *StringEnumeration_StringEnumerationItem) GetStringIdentifier() string {
	if m != nil && m.StringIdentifier != nil {
		return *m.StringIdentifier
	}
	return ""
}

func (m *StringEnumeration_StringEnumerationItem) GetHasWildcard() bool {
	if m != nil && m.HasWildcard != nil {
		return *m.HasWildcard
	}
	return false
}

// Expression used as part of a rule condition.
type Expression struct {
	// Types that are valid to be assigned to Expression:
	//	*Expression_BoolValue
	//	*Expression_BinaryExpression
	//	*Expression_UnaryExpression
	//	*Expression_StringIdentifier
	//	*Expression_ForInExpression
	//	*Expression_ForOfExpression
	//	*Expression_NotExpression
	//	*Expression_OrExpression
	//	*Expression_AndExpression
	//	*Expression_Range
	//	*Expression_Regexp
	//	*Expression_Keyword
	//	*Expression_NumberValue
	//	*Expression_DoubleValue
	//	*Expression_Text
	//	*Expression_StringCount
	//	*Expression_StringOffset
	//	*Expression_StringLength
	//	*Expression_Identifier
	//	*Expression_IntegerFunction
	Expression           isExpression_Expression `protobuf_oneof:"expression"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *Expression) Reset()         { *m = Expression{} }
func (m *Expression) String() string { return proto.CompactTextString(m) }
func (*Expression) ProtoMessage()    {}
func (*Expression) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{23}
}

func (m *Expression) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Expression.Unmarshal(m, b)
}
func (m *Expression) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Expression.Marshal(b, m, deterministic)
}
func (m *Expression) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Expression.Merge(m, src)
}
func (m *Expression) XXX_Size() int {
	return xxx_messageInfo_Expression.Size(m)
}
func (m *Expression) XXX_DiscardUnknown() {
	xxx_messageInfo_Expression.DiscardUnknown(m)
}

var xxx_messageInfo_Expression proto.InternalMessageInfo

type isExpression_Expression interface {
	isExpression_Expression()
}

type Expression_BoolValue struct {
	BoolValue bool `protobuf:"varint,1,opt,name=bool_value,json=boolValue,oneof"`
}

type Expression_BinaryExpression struct {
	BinaryExpression *BinaryExpression `protobuf:"bytes,2,opt,name=binary_expression,json=binaryExpression,oneof"`
}

type Expression_UnaryExpression struct {
	UnaryExpression *UnaryExpression `protobuf:"bytes,3,opt,name=unary_expression,json=unaryExpression,oneof"`
}

type Expression_StringIdentifier struct {
	StringIdentifier string `protobuf:"bytes,4,opt,name=string_identifier,json=stringIdentifier,oneof"`
}

type Expression_ForInExpression struct {
	ForInExpression *ForInExpression `protobuf:"bytes,5,opt,name=for_in_expression,json=forInExpression,oneof"`
}

type Expression_ForOfExpression struct {
	ForOfExpression *ForOfExpression `protobuf:"bytes,6,opt,name=for_of_expression,json=forOfExpression,oneof"`
}

type Expression_NotExpression struct {
	NotExpression *Expression `protobuf:"bytes,7,opt,name=not_expression,json=notExpression,oneof"`
}

type Expression_OrExpression struct {
	OrExpression *Expressions `protobuf:"bytes,8,opt,name=or_expression,json=orExpression,oneof"`
}

type Expression_AndExpression struct {
	AndExpression *Expressions `protobuf:"bytes,9,opt,name=and_expression,json=andExpression,oneof"`
}

type Expression_Range struct {
	Range *Range `protobuf:"bytes,10,opt,name=range,oneof"`
}

type Expression_Regexp struct {
	Regexp *Regexp `protobuf:"bytes,11,opt,name=regexp,oneof"`
}

type Expression_Keyword struct {
	Keyword Keyword `protobuf:"varint,12,opt,name=keyword,enum=Keyword,oneof"`
}

type Expression_NumberValue struct {
	NumberValue int64 `protobuf:"varint,13,opt,name=number_value,json=numberValue,oneof"`
}

type Expression_DoubleValue struct {
	DoubleValue float64 `protobuf:"fixed64,14,opt,name=double_value,json=doubleValue,oneof"`
}

type Expression_Text struct {
	Text string `protobuf:"bytes,15,opt,name=text,oneof"`
}

type Expression_StringCount struct {
	StringCount string `protobuf:"bytes,16,opt,name=string_count,json=stringCount,oneof"`
}

type Expression_StringOffset struct {
	StringOffset *StringOffset `protobuf:"bytes,17,opt,name=string_offset,json=stringOffset,oneof"`
}

type Expression_StringLength struct {
	StringLength *StringLength `protobuf:"bytes,18,opt,name=string_length,json=stringLength,oneof"`
}

type Expression_Identifier struct {
	Identifier *Identifier `protobuf:"bytes,19,opt,name=identifier,oneof"`
}

type Expression_IntegerFunction struct {
	IntegerFunction *IntegerFunction `protobuf:"bytes,20,opt,name=integer_function,json=integerFunction,oneof"`
}

func (*Expression_BoolValue) isExpression_Expression() {}

func (*Expression_BinaryExpression) isExpression_Expression() {}

func (*Expression_UnaryExpression) isExpression_Expression() {}

func (*Expression_StringIdentifier) isExpression_Expression() {}

func (*Expression_ForInExpression) isExpression_Expression() {}

func (*Expression_ForOfExpression) isExpression_Expression() {}

func (*Expression_NotExpression) isExpression_Expression() {}

func (*Expression_OrExpression) isExpression_Expression() {}

func (*Expression_AndExpression) isExpression_Expression() {}

func (*Expression_Range) isExpression_Expression() {}

func (*Expression_Regexp) isExpression_Expression() {}

func (*Expression_Keyword) isExpression_Expression() {}

func (*Expression_NumberValue) isExpression_Expression() {}

func (*Expression_DoubleValue) isExpression_Expression() {}

func (*Expression_Text) isExpression_Expression() {}

func (*Expression_StringCount) isExpression_Expression() {}

func (*Expression_StringOffset) isExpression_Expression() {}

func (*Expression_StringLength) isExpression_Expression() {}

func (*Expression_Identifier) isExpression_Expression() {}

func (*Expression_IntegerFunction) isExpression_Expression() {}

func (m *Expression) GetExpression() isExpression_Expression {
	if m != nil {
		return m.Expression
	}
	return nil
}

func (m *Expression) GetBoolValue() bool {
	if x, ok := m.GetExpression().(*Expression_BoolValue); ok {
		return x.BoolValue
	}
	return false
}

func (m *Expression) GetBinaryExpression() *BinaryExpression {
	if x, ok := m.GetExpression().(*Expression_BinaryExpression); ok {
		return x.BinaryExpression
	}
	return nil
}

func (m *Expression) GetUnaryExpression() *UnaryExpression {
	if x, ok := m.GetExpression().(*Expression_UnaryExpression); ok {
		return x.UnaryExpression
	}
	return nil
}

func (m *Expression) GetStringIdentifier() string {
	if x, ok := m.GetExpression().(*Expression_StringIdentifier); ok {
		return x.StringIdentifier
	}
	return ""
}

func (m *Expression) GetForInExpression() *ForInExpression {
	if x, ok := m.GetExpression().(*Expression_ForInExpression); ok {
		return x.ForInExpression
	}
	return nil
}

func (m *Expression) GetForOfExpression() *ForOfExpression {
	if x, ok := m.GetExpression().(*Expression_ForOfExpression); ok {
		return x.ForOfExpression
	}
	return nil
}

func (m *Expression) GetNotExpression() *Expression {
	if x, ok := m.GetExpression().(*Expression_NotExpression); ok {
		return x.NotExpression
	}
	return nil
}

func (m *Expression) GetOrExpression() *Expressions {
	if x, ok := m.GetExpression().(*Expression_OrExpression); ok {
		return x.OrExpression
	}
	return nil
}

func (m *Expression) GetAndExpression() *Expressions {
	if x, ok := m.GetExpression().(*Expression_AndExpression); ok {
		return x.AndExpression
	}
	return nil
}

func (m *Expression) GetRange() *Range {
	if x, ok := m.GetExpression().(*Expression_Range); ok {
		return x.Range
	}
	return nil
}

func (m *Expression) GetRegexp() *Regexp {
	if x, ok := m.GetExpression().(*Expression_Regexp); ok {
		return x.Regexp
	}
	return nil
}

func (m *Expression) GetKeyword() Keyword {
	if x, ok := m.GetExpression().(*Expression_Keyword); ok {
		return x.Keyword
	}
	return Keyword_UNKNOWN
}

func (m *Expression) GetNumberValue() int64 {
	if x, ok := m.GetExpression().(*Expression_NumberValue); ok {
		return x.NumberValue
	}
	return 0
}

func (m *Expression) GetDoubleValue() float64 {
	if x, ok := m.GetExpression().(*Expression_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

func (m *Expression) GetText() string {
	if x, ok := m.GetExpression().(*Expression_Text); ok {
		return x.Text
	}
	return ""
}

func (m *Expression) GetStringCount() string {
	if x, ok := m.GetExpression().(*Expression_StringCount); ok {
		return x.StringCount
	}
	return ""
}

func (m *Expression) GetStringOffset() *StringOffset {
	if x, ok := m.GetExpression().(*Expression_StringOffset); ok {
		return x.StringOffset
	}
	return nil
}

func (m *Expression) GetStringLength() *StringLength {
	if x, ok := m.GetExpression().(*Expression_StringLength); ok {
		return x.StringLength
	}
	return nil
}

func (m *Expression) GetIdentifier() *Identifier {
	if x, ok := m.GetExpression().(*Expression_Identifier); ok {
		return x.Identifier
	}
	return nil
}

func (m *Expression) GetIntegerFunction() *IntegerFunction {
	if x, ok := m.GetExpression().(*Expression_IntegerFunction); ok {
		return x.IntegerFunction
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Expression) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Expression_BoolValue)(nil),
		(*Expression_BinaryExpression)(nil),
		(*Expression_UnaryExpression)(nil),
		(*Expression_StringIdentifier)(nil),
		(*Expression_ForInExpression)(nil),
		(*Expression_ForOfExpression)(nil),
		(*Expression_NotExpression)(nil),
		(*Expression_OrExpression)(nil),
		(*Expression_AndExpression)(nil),
		(*Expression_Range)(nil),
		(*Expression_Regexp)(nil),
		(*Expression_Keyword)(nil),
		(*Expression_NumberValue)(nil),
		(*Expression_DoubleValue)(nil),
		(*Expression_Text)(nil),
		(*Expression_StringCount)(nil),
		(*Expression_StringOffset)(nil),
		(*Expression_StringLength)(nil),
		(*Expression_Identifier)(nil),
		(*Expression_IntegerFunction)(nil),
	}
}

// Refers to the offset or virtual address at which a string (or, optionally,
// the i-th occurence of the string) is found.
// Examples:
// - $s1 at 1000
// - $s1[2] at 1000
type StringOffset struct {
	// String identifier. Required.
	StringIdentifier *string `protobuf:"bytes,1,opt,name=string_identifier,json=stringIdentifier" json:"string_identifier,omitempty"`
	// The index of the occurrence of the string.
	Index                *Expression `protobuf:"bytes,2,opt,name=index" json:"index,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *StringOffset) Reset()         { *m = StringOffset{} }
func (m *StringOffset) String() string { return proto.CompactTextString(m) }
func (*StringOffset) ProtoMessage()    {}
func (*StringOffset) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{24}
}

func (m *StringOffset) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StringOffset.Unmarshal(m, b)
}
func (m *StringOffset) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StringOffset.Marshal(b, m, deterministic)
}
func (m *StringOffset) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StringOffset.Merge(m, src)
}
func (m *StringOffset) XXX_Size() int {
	return xxx_messageInfo_StringOffset.Size(m)
}
func (m *StringOffset) XXX_DiscardUnknown() {
	xxx_messageInfo_StringOffset.DiscardUnknown(m)
}

var xxx_messageInfo_StringOffset proto.InternalMessageInfo

func (m *StringOffset) GetStringIdentifier() string {
	if m != nil && m.StringIdentifier != nil {
		return *m.StringIdentifier
	}
	return ""
}

func (m *StringOffset) GetIndex() *Expression {
	if m != nil {
		return m.Index
	}
	return nil
}

// Refers to the length of the matches of a string (or, optionally, to the
// length of the i-th match). It is useful when combined with regular
// expressions or hexadecimal strings, which may contain jumps.
// Examples:
// - !s1 > 50
// - !s1[1] != 30
type StringLength struct {
	// String Identifier. Required.
	StringIdentifier *string `protobuf:"bytes,1,opt,name=string_identifier,json=stringIdentifier" json:"string_identifier,omitempty"`
	// The index of the match.
	Index                *Expression `protobuf:"bytes,2,opt,name=index" json:"index,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *StringLength) Reset()         { *m = StringLength{} }
func (m *StringLength) String() string { return proto.CompactTextString(m) }
func (*StringLength) ProtoMessage()    {}
func (*StringLength) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{25}
}

func (m *StringLength) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StringLength.Unmarshal(m, b)
}
func (m *StringLength) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StringLength.Marshal(b, m, deterministic)
}
func (m *StringLength) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StringLength.Merge(m, src)
}
func (m *StringLength) XXX_Size() int {
	return xxx_messageInfo_StringLength.Size(m)
}
func (m *StringLength) XXX_DiscardUnknown() {
	xxx_messageInfo_StringLength.DiscardUnknown(m)
}

var xxx_messageInfo_StringLength proto.InternalMessageInfo

func (m *StringLength) GetStringIdentifier() string {
	if m != nil && m.StringIdentifier != nil {
		return *m.StringIdentifier
	}
	return ""
}

func (m *StringLength) GetIndex() *Expression {
	if m != nil {
		return m.Index
	}
	return nil
}

// Identifier used as part of expressions.
// Consists of sequence of identifiers, expressions and arguments.
// Examples:
// - my_var
// - pe.number_of_resources
// - math.entropy(mystr[i])
type Identifier struct {
	// Items in the identifier.
	Items                []*Identifier_IdentifierItem `protobuf:"bytes,1,rep,name=items" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *Identifier) Reset()         { *m = Identifier{} }
func (m *Identifier) String() string { return proto.CompactTextString(m) }
func (*Identifier) ProtoMessage()    {}
func (*Identifier) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{26}
}

func (m *Identifier) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Identifier.Unmarshal(m, b)
}
func (m *Identifier) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Identifier.Marshal(b, m, deterministic)
}
func (m *Identifier) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Identifier.Merge(m, src)
}
func (m *Identifier) XXX_Size() int {
	return xxx_messageInfo_Identifier.Size(m)
}
func (m *Identifier) XXX_DiscardUnknown() {
	xxx_messageInfo_Identifier.DiscardUnknown(m)
}

var xxx_messageInfo_Identifier proto.InternalMessageInfo

func (m *Identifier) GetItems() []*Identifier_IdentifierItem {
	if m != nil {
		return m.Items
	}
	return nil
}

type Identifier_IdentifierItem struct {
	// Types that are valid to be assigned to Item:
	//	*Identifier_IdentifierItem_Identifier
	//	*Identifier_IdentifierItem_Index
	//	*Identifier_IdentifierItem_Arguments
	Item                 isIdentifier_IdentifierItem_Item `protobuf_oneof:"item"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *Identifier_IdentifierItem) Reset()         { *m = Identifier_IdentifierItem{} }
func (m *Identifier_IdentifierItem) String() string { return proto.CompactTextString(m) }
func (*Identifier_IdentifierItem) ProtoMessage()    {}
func (*Identifier_IdentifierItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{26, 0}
}

func (m *Identifier_IdentifierItem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Identifier_IdentifierItem.Unmarshal(m, b)
}
func (m *Identifier_IdentifierItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Identifier_IdentifierItem.Marshal(b, m, deterministic)
}
func (m *Identifier_IdentifierItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Identifier_IdentifierItem.Merge(m, src)
}
func (m *Identifier_IdentifierItem) XXX_Size() int {
	return xxx_messageInfo_Identifier_IdentifierItem.Size(m)
}
func (m *Identifier_IdentifierItem) XXX_DiscardUnknown() {
	xxx_messageInfo_Identifier_IdentifierItem.DiscardUnknown(m)
}

var xxx_messageInfo_Identifier_IdentifierItem proto.InternalMessageInfo

type isIdentifier_IdentifierItem_Item interface {
	isIdentifier_IdentifierItem_Item()
}

type Identifier_IdentifierItem_Identifier struct {
	Identifier string `protobuf:"bytes,1,opt,name=identifier,oneof"`
}

type Identifier_IdentifierItem_Index struct {
	Index *Expression `protobuf:"bytes,2,opt,name=index,oneof"`
}

type Identifier_IdentifierItem_Arguments struct {
	Arguments *Expressions `protobuf:"bytes,3,opt,name=arguments,oneof"`
}

func (*Identifier_IdentifierItem_Identifier) isIdentifier_IdentifierItem_Item() {}

func (*Identifier_IdentifierItem_Index) isIdentifier_IdentifierItem_Item() {}

func (*Identifier_IdentifierItem_Arguments) isIdentifier_IdentifierItem_Item() {}

func (m *Identifier_IdentifierItem) GetItem() isIdentifier_IdentifierItem_Item {
	if m != nil {
		return m.Item
	}
	return nil
}

func (m *Identifier_IdentifierItem) GetIdentifier() string {
	if x, ok := m.GetItem().(*Identifier_IdentifierItem_Identifier); ok {
		return x.Identifier
	}
	return ""
}

func (m *Identifier_IdentifierItem) GetIndex() *Expression {
	if x, ok := m.GetItem().(*Identifier_IdentifierItem_Index); ok {
		return x.Index
	}
	return nil
}

func (m *Identifier_IdentifierItem) GetArguments() *Expressions {
	if x, ok := m.GetItem().(*Identifier_IdentifierItem_Arguments); ok {
		return x.Arguments
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Identifier_IdentifierItem) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Identifier_IdentifierItem_Identifier)(nil),
		(*Identifier_IdentifierItem_Index)(nil),
		(*Identifier_IdentifierItem_Arguments)(nil),
	}
}

// Sequence of expressions.
type Expressions struct {
	// Terms in the sequence.
	Terms                []*Expression `protobuf:"bytes,1,rep,name=terms" json:"terms,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *Expressions) Reset()         { *m = Expressions{} }
func (m *Expressions) String() string { return proto.CompactTextString(m) }
func (*Expressions) ProtoMessage()    {}
func (*Expressions) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{27}
}

func (m *Expressions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Expressions.Unmarshal(m, b)
}
func (m *Expressions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Expressions.Marshal(b, m, deterministic)
}
func (m *Expressions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Expressions.Merge(m, src)
}
func (m *Expressions) XXX_Size() int {
	return xxx_messageInfo_Expressions.Size(m)
}
func (m *Expressions) XXX_DiscardUnknown() {
	xxx_messageInfo_Expressions.DiscardUnknown(m)
}

var xxx_messageInfo_Expressions proto.InternalMessageInfo

func (m *Expressions) GetTerms() []*Expression {
	if m != nil {
		return m.Terms
	}
	return nil
}

// YARA rule.
type Rule struct {
	// Rule modifiers (global, private).
	Modifiers *RuleModifiers `protobuf:"bytes,1,opt,name=modifiers" json:"modifiers,omitempty"`
	// Rule identifier. Must be unique in the ruleset. Required.
	Identifier *string `protobuf:"bytes,2,opt,name=identifier" json:"identifier,omitempty"`
	// Tags. Cannot be repeated.
	Tags []string `protobuf:"bytes,3,rep,name=tags" json:"tags,omitempty"`
	// Metadata.
	Meta []*Meta `protobuf:"bytes,4,rep,name=meta" json:"meta,omitempty"`
	// String declarations.
	Strings []*String `protobuf:"bytes,5,rep,name=strings" json:"strings,omitempty"`
	// Boolean expression to check.
	Condition            *Expression `protobuf:"bytes,6,opt,name=condition" json:"condition,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *Rule) Reset()         { *m = Rule{} }
func (m *Rule) String() string { return proto.CompactTextString(m) }
func (*Rule) ProtoMessage()    {}
func (*Rule) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{28}
}

func (m *Rule) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Rule.Unmarshal(m, b)
}
func (m *Rule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Rule.Marshal(b, m, deterministic)
}
func (m *Rule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Rule.Merge(m, src)
}
func (m *Rule) XXX_Size() int {
	return xxx_messageInfo_Rule.Size(m)
}
func (m *Rule) XXX_DiscardUnknown() {
	xxx_messageInfo_Rule.DiscardUnknown(m)
}

var xxx_messageInfo_Rule proto.InternalMessageInfo

func (m *Rule) GetModifiers() *RuleModifiers {
	if m != nil {
		return m.Modifiers
	}
	return nil
}

func (m *Rule) GetIdentifier() string {
	if m != nil && m.Identifier != nil {
		return *m.Identifier
	}
	return ""
}

func (m *Rule) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Rule) GetMeta() []*Meta {
	if m != nil {
		return m.Meta
	}
	return nil
}

func (m *Rule) GetStrings() []*String {
	if m != nil {
		return m.Strings
	}
	return nil
}

func (m *Rule) GetCondition() *Expression {
	if m != nil {
		return m.Condition
	}
	return nil
}

// Set of YARA rules.
type RuleSet struct {
	// Names of the imported modules.
	// Examples: "pe", "elf", "cuckoo", "magic", "hash", "math", ...
	Imports []string `protobuf:"bytes,1,rep,name=imports" json:"imports,omitempty"`
	// Path to other YARA source files whose content should be included.
	// Examples:
	// - "other_rule.yar"
	// - "rules/rule1.yar"
	Includes []string `protobuf:"bytes,2,rep,name=includes" json:"includes,omitempty"`
	// Set of rules.
	Rules                []*Rule  `protobuf:"bytes,3,rep,name=rules" json:"rules,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RuleSet) Reset()         { *m = RuleSet{} }
func (m *RuleSet) String() string { return proto.CompactTextString(m) }
func (*RuleSet) ProtoMessage()    {}
func (*RuleSet) Descriptor() ([]byte, []int) {
	return fileDescriptor_525dc6cd5d3d5c82, []int{29}
}

func (m *RuleSet) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RuleSet.Unmarshal(m, b)
}
func (m *RuleSet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RuleSet.Marshal(b, m, deterministic)
}
func (m *RuleSet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RuleSet.Merge(m, src)
}
func (m *RuleSet) XXX_Size() int {
	return xxx_messageInfo_RuleSet.Size(m)
}
func (m *RuleSet) XXX_DiscardUnknown() {
	xxx_messageInfo_RuleSet.DiscardUnknown(m)
}

var xxx_messageInfo_RuleSet proto.InternalMessageInfo

func (m *RuleSet) GetImports() []string {
	if m != nil {
		return m.Imports
	}
	return nil
}

func (m *RuleSet) GetIncludes() []string {
	if m != nil {
		return m.Includes
	}
	return nil
}

func (m *RuleSet) GetRules() []*Rule {
	if m != nil {
		return m.Rules
	}
	return nil
}

func init() {
	proto.RegisterEnum("Keyword", Keyword_name, Keyword_value)
	proto.RegisterEnum("ForKeyword", ForKeyword_name, ForKeyword_value)
	proto.RegisterEnum("StringSetKeyword", StringSetKeyword_name, StringSetKeyword_value)
	proto.RegisterEnum("BinaryExpression_Operator", BinaryExpression_Operator_name, BinaryExpression_Operator_value)
	proto.RegisterEnum("UnaryExpression_Operator", UnaryExpression_Operator_name, UnaryExpression_Operator_value)
	proto.RegisterType((*RuleModifiers)(nil), "RuleModifiers")
	proto.RegisterType((*Meta)(nil), "Meta")
	proto.RegisterType((*String)(nil), "String")
	proto.RegisterType((*StringModifiers)(nil), "StringModifiers")
	proto.RegisterType((*TextString)(nil), "TextString")
	proto.RegisterType((*Regexp)(nil), "Regexp")
	proto.RegisterType((*HexTokens)(nil), "HexTokens")
	proto.RegisterType((*HexToken)(nil), "HexToken")
	proto.RegisterType((*HexAlternative)(nil), "HexAlternative")
	proto.RegisterType((*BytesSequence)(nil), "BytesSequence")
	proto.RegisterType((*Jump)(nil), "Jump")
	proto.RegisterType((*BinaryExpression)(nil), "BinaryExpression")
	proto.RegisterType((*UnaryExpression)(nil), "UnaryExpression")
	proto.RegisterType((*Range)(nil), "Range")
	proto.RegisterType((*IntegerFunction)(nil), "IntegerFunction")
	proto.RegisterType((*ForInExpression)(nil), "ForInExpression")
	proto.RegisterType((*Iterator)(nil), "Iterator")
	proto.RegisterType((*IntegerSet)(nil), "IntegerSet")
	proto.RegisterType((*IntegerEnumeration)(nil), "IntegerEnumeration")
	proto.RegisterType((*ForExpression)(nil), "ForExpression")
	proto.RegisterType((*ForOfExpression)(nil), "ForOfExpression")
	proto.RegisterType((*StringSet)(nil), "StringSet")
	proto.RegisterType((*StringEnumeration)(nil), "StringEnumeration")
	proto.RegisterType((*StringEnumeration_StringEnumerationItem)(nil), "StringEnumeration.StringEnumerationItem")
	proto.RegisterType((*Expression)(nil), "Expression")
	proto.RegisterType((*StringOffset)(nil), "StringOffset")
	proto.RegisterType((*StringLength)(nil), "StringLength")
	proto.RegisterType((*Identifier)(nil), "Identifier")
	proto.RegisterType((*Identifier_IdentifierItem)(nil), "Identifier.IdentifierItem")
	proto.RegisterType((*Expressions)(nil), "Expressions")
	proto.RegisterType((*Rule)(nil), "Rule")
	proto.RegisterType((*RuleSet)(nil), "RuleSet")
}

func init() { proto.RegisterFile("pb/yara.proto", fileDescriptor_525dc6cd5d3d5c82) }

var fileDescriptor_525dc6cd5d3d5c82 = []byte{
	// 1957 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x18, 0xdb, 0x72, 0xdb, 0xc6,
	0x95, 0xe0, 0x1d, 0x07, 0xbc, 0xac, 0xd6, 0x4a, 0x02, 0x2b, 0xad, 0x2d, 0x41, 0x6d, 0xa3, 0x38,
	0x36, 0x9b, 0x51, 0x94, 0xcc, 0xf8, 0xa1, 0x99, 0x4a, 0x36, 0x65, 0xa2, 0x91, 0x48, 0x67, 0x09,
	0xd9, 0x75, 0xa6, 0x53, 0x0e, 0x28, 0x2e, 0x29, 0xd4, 0x24, 0xc0, 0x00, 0xa0, 0x4d, 0x4d, 0x3f,
	0xa0, 0x4f, 0x7d, 0xea, 0x0f, 0xf4, 0x13, 0xfa, 0x01, 0x9d, 0xbe, 0xf7, 0xa5, 0x33, 0x9d, 0x4e,
	0xff, 0xa0, 0x1f, 0xd2, 0xd9, 0x0b, 0xae, 0xa4, 0x93, 0xe9, 0x34, 0x4f, 0xd8, 0x73, 0xdd, 0xb3,
	0xe7, 0x9c, 0x3d, 0x7b, 0x0e, 0xa0, 0xb9, 0x1c, 0xff, 0xfc, 0xd6, 0xf6, 0xed, 0xce, 0xd2, 0xf7,
	0x42, 0xcf, 0x38, 0x85, 0x26, 0x59, 0xcd, 0xe9, 0xa5, 0x37, 0x71, 0xa6, 0x0e, 0xf5, 0x03, 0xfc,
	0x3e, 0x54, 0x67, 0x73, 0x6f, 0x6c, 0xcf, 0x75, 0x65, 0x5f, 0x39, 0xaa, 0x13, 0x09, 0x61, 0x1d,
	0x6a, 0x4b, 0xdf, 0x79, 0x63, 0x87, 0x54, 0x2f, 0x72, 0x42, 0x04, 0x1a, 0x0b, 0x28, 0x5f, 0xd2,
	0xd0, 0xc6, 0x08, 0x4a, 0xaf, 0xe9, 0x2d, 0x17, 0x53, 0x09, 0x5b, 0xe2, 0x5d, 0x28, 0x87, 0x74,
	0x1d, 0x72, 0x01, 0xb5, 0x57, 0x20, 0x1c, 0xc2, 0x3a, 0x54, 0xdd, 0xd5, 0x62, 0x4c, 0x7d, 0xbd,
	0xb4, 0xaf, 0x1c, 0x95, 0x7a, 0x05, 0x22, 0x61, 0xbc, 0x07, 0xb5, 0xb1, 0xe7, 0xcd, 0xa9, 0xed,
	0xea, 0x65, 0xb6, 0x47, 0xaf, 0x40, 0x22, 0xc4, 0x59, 0x0d, 0x2a, 0x6f, 0xec, 0xf9, 0x8a, 0x1a,
	0x7f, 0x50, 0xa0, 0x3a, 0x0c, 0x7d, 0xc7, 0x9d, 0xe1, 0x16, 0x14, 0x9d, 0x89, 0xdc, 0xb0, 0xe8,
	0x4c, 0xf0, 0x41, 0x6a, 0x3f, 0xed, 0x58, 0xeb, 0x58, 0x74, 0x1d, 0x0a, 0xd6, 0x78, 0xf3, 0x7b,
	0x50, 0xba, 0xa1, 0x6b, 0xbe, 0xb3, 0x76, 0x0c, 0x9d, 0x1e, 0x5d, 0x5b, 0xde, 0x6b, 0xea, 0x06,
	0xbd, 0x02, 0x61, 0x04, 0x7c, 0x00, 0x55, 0x9f, 0xce, 0xe8, 0x7a, 0xc9, 0x2d, 0xd0, 0x8e, 0x6b,
	0x1d, 0xc2, 0x41, 0x66, 0xa5, 0x20, 0x24, 0x96, 0xfc, 0xbd, 0x08, 0x6d, 0xa1, 0x3e, 0xe3, 0x3e,
	0xd7, 0xbb, 0xb6, 0x03, 0x1a, 0xb9, 0x4f, 0x40, 0x78, 0x17, 0x2a, 0x76, 0x70, 0xed, 0x38, 0xd2,
	0x79, 0x02, 0xc0, 0x18, 0xca, 0x6f, 0x9d, 0x09, 0xe5, 0xe6, 0xd4, 0x09, 0x5f, 0xe3, 0x3d, 0xa8,
	0x4f, 0x57, 0xf3, 0xf9, 0x5b, 0xcf, 0x9f, 0x08, 0x2f, 0x90, 0x18, 0x66, 0x2e, 0x5e, 0x7b, 0xbe,
	0x5e, 0xe1, 0x68, 0xb6, 0xc4, 0x0d, 0x50, 0x1c, 0xbd, 0xca, 0x61, 0xc5, 0x61, 0x50, 0xa0, 0xd7,
	0x04, 0x14, 0xa4, 0x43, 0x56, 0xcf, 0x84, 0x0c, 0x7f, 0x00, 0xb5, 0xb5, 0xe7, 0x8f, 0x16, 0x8e,
	0xab, 0xab, 0xfb, 0xca, 0x51, 0x85, 0x54, 0xd7, 0x9e, 0x7f, 0xe9, 0xb8, 0x31, 0xc1, 0x5e, 0xeb,
	0x90, 0x10, 0xec, 0x35, 0x3b, 0xd7, 0xd8, 0x0e, 0xe8, 0x17, 0x27, 0xba, 0x26, 0xce, 0x25, 0x20,
	0xfc, 0x33, 0x68, 0x89, 0x95, 0x3d, 0x5f, 0xde, 0xd8, 0x63, 0x1a, 0xea, 0x0d, 0x1e, 0x8e, 0x1c,
	0x16, 0xdf, 0x03, 0x10, 0x18, 0x7e, 0xde, 0x26, 0xd7, 0x91, 0xc2, 0x18, 0xcf, 0x01, 0x92, 0x68,
	0x31, 0xbf, 0xf0, 0x40, 0x8a, 0xd0, 0x8a, 0xc8, 0x75, 0x40, 0x5d, 0x44, 0x6e, 0x96, 0x11, 0x46,
	0x9d, 0x9c, 0xfb, 0x49, 0xc2, 0x62, 0x5c, 0x40, 0x55, 0x84, 0xee, 0x07, 0xd1, 0xf6, 0x10, 0xd4,
	0x38, 0x57, 0xf0, 0x7d, 0xa8, 0x84, 0x6c, 0xa5, 0x2b, 0xfb, 0xa5, 0x23, 0xed, 0x58, 0x8d, 0xd3,
	0x88, 0x08, 0xbc, 0xf1, 0x27, 0x05, 0xea, 0x11, 0x0e, 0x3f, 0x84, 0x7a, 0x40, 0xbf, 0x5d, 0x51,
	0xf7, 0x5a, 0x24, 0x85, 0x76, 0xdc, 0xea, 0x9c, 0xdd, 0x86, 0x34, 0x18, 0x4a, 0x6c, 0xaf, 0x40,
	0x62, 0x0e, 0xfc, 0x21, 0x94, 0x7f, 0xb7, 0x5a, 0x2c, 0xa5, 0x4d, 0x95, 0xce, 0xaf, 0x56, 0x0b,
	0x96, 0x7c, 0x1c, 0x89, 0x3f, 0x03, 0xcd, 0x9e, 0x87, 0xd4, 0x77, 0xed, 0xd0, 0x79, 0x43, 0x65,
	0x16, 0xb7, 0xd9, 0xf6, 0xa7, 0x09, 0xba, 0x57, 0x20, 0x69, 0xae, 0x24, 0x5f, 0x4f, 0xa0, 0x95,
	0xe5, 0xc4, 0x06, 0x54, 0xb9, 0xc1, 0x81, 0x3c, 0x49, 0xea, 0x42, 0x10, 0x49, 0x31, 0x1e, 0x43,
	0x33, 0x63, 0x2d, 0x4b, 0x65, 0xae, 0x8f, 0x1f, 0xa6, 0x41, 0x04, 0xc0, 0x9c, 0xbc, 0xb0, 0x83,
	0xd7, 0xdc, 0xee, 0x06, 0xe1, 0x6b, 0xa3, 0x03, 0x65, 0x66, 0x3e, 0x93, 0x08, 0x42, 0xdb, 0x17,
	0x11, 0x28, 0x11, 0x01, 0xb0, 0x64, 0xa6, 0xee, 0x84, 0x0b, 0x94, 0x08, 0x5b, 0x1a, 0xff, 0x29,
	0x01, 0x3a, 0x73, 0x5c, 0xdb, 0xbf, 0xed, 0xae, 0x97, 0x3e, 0x0d, 0x02, 0xc7, 0x73, 0xf1, 0x17,
	0x50, 0xf7, 0x96, 0xd4, 0xb7, 0x43, 0xcf, 0xe7, 0xf2, 0xad, 0xe3, 0xbd, 0x4e, 0x9e, 0xa9, 0x33,
	0x90, 0x1c, 0x24, 0xe6, 0xc5, 0xf7, 0xa1, 0x3c, 0xa7, 0xd3, 0xa4, 0x18, 0x24, 0xdc, 0x84, 0x13,
	0xf0, 0x01, 0x54, 0x7c, 0x67, 0x76, 0x13, 0x4a, 0x37, 0x66, 0x38, 0x04, 0xc5, 0xf8, 0x57, 0x11,
	0xea, 0x91, 0x6a, 0xac, 0x41, 0xed, 0xaa, 0xff, 0x55, 0x7f, 0xf0, 0xb2, 0x8f, 0x0a, 0x0c, 0xb8,
	0x3c, 0xb5, 0x9e, 0xf4, 0xba, 0x43, 0xa4, 0xe0, 0x06, 0xd4, 0x9f, 0x0c, 0xfa, 0xd6, 0xa9, 0xd9,
	0x1f, 0xa2, 0x22, 0xae, 0x42, 0xf1, 0xd4, 0x42, 0x25, 0xf6, 0x35, 0xfb, 0xa8, 0xcc, 0xbe, 0x17,
	0x16, 0xaa, 0xb0, 0xef, 0x33, 0x0b, 0x55, 0x39, 0xdc, 0x45, 0x35, 0x0e, 0x77, 0x51, 0x9d, 0x7d,
	0xbb, 0x5f, 0x23, 0x15, 0xd7, 0xa0, 0xd4, 0xef, 0x7e, 0x8d, 0x00, 0xef, 0x02, 0x32, 0xfb, 0x56,
	0xf7, 0x59, 0x97, 0x8c, 0xce, 0xaf, 0xfa, 0x4f, 0x2c, 0x73, 0xd0, 0x47, 0x1a, 0xae, 0x43, 0xf9,
	0xf9, 0xc5, 0xd5, 0x10, 0x35, 0xb0, 0x0a, 0x95, 0x4b, 0xb3, 0x7f, 0x35, 0x44, 0x4d, 0xb6, 0xb4,
	0xcc, 0xcb, 0xee, 0x10, 0xb5, 0x98, 0xf8, 0x53, 0xf3, 0x05, 0x6a, 0xb3, 0xc5, 0xe5, 0xe0, 0x29,
	0x42, 0x6c, 0xf1, 0xeb, 0x01, 0x41, 0x3b, 0xb8, 0x0d, 0xda, 0x99, 0x69, 0xbd, 0x34, 0x87, 0xdd,
	0xd1, 0x69, 0xff, 0x29, 0xc2, 0xb8, 0x05, 0x10, 0x21, 0x06, 0x04, 0xdd, 0x61, 0xf0, 0xb0, 0x67,
	0x9e, 0x5b, 0xa3, 0x8b, 0xee, 0xb9, 0x85, 0x76, 0x99, 0x80, 0x80, 0x89, 0xf9, 0xac, 0x67, 0xa1,
	0xf7, 0x70, 0x13, 0x54, 0x33, 0x3e, 0xe2, 0xfb, 0x9c, 0xdf, 0x3a, 0x25, 0xd6, 0xf0, 0xa5, 0x69,
	0xf5, 0xd0, 0x07, 0x8c, 0xdf, 0x4c, 0x21, 0x74, 0xe6, 0x91, 0x6e, 0xff, 0xa9, 0x80, 0xee, 0x72,
	0xe9, 0x18, 0xdc, 0x33, 0xfe, 0xa2, 0x40, 0xfb, 0x2a, 0x17, 0xe5, 0xcf, 0x37, 0xa2, 0x7c, 0xb7,
	0x73, 0xf5, 0xfd, 0x41, 0xfe, 0x04, 0x80, 0xc6, 0x0c, 0xdb, 0x42, 0x9d, 0x22, 0x1b, 0x8f, 0xdf,
	0x15, 0xcc, 0x36, 0x68, 0x57, 0xfd, 0x53, 0xf2, 0x6a, 0x24, 0xdc, 0xaa, 0xa4, 0x1d, 0xd6, 0x1f,
	0x58, 0xa8, 0x68, 0x98, 0x50, 0x21, 0xb6, 0x3b, 0xa3, 0x2c, 0x69, 0x92, 0x54, 0xce, 0x27, 0x8d,
	0xc8, 0xeb, 0x1f, 0x27, 0x79, 0x9d, 0x63, 0xe0, 0x49, 0xfe, 0x02, 0xda, 0xa6, 0x1b, 0xd2, 0x19,
	0xf5, 0xcf, 0x57, 0xee, 0x75, 0xc8, 0x0e, 0xcf, 0x4b, 0xbe, 0x58, 0xcb, 0x22, 0x15, 0xc3, 0xf8,
	0x23, 0xa8, 0xdb, 0xfe, 0x6c, 0xb5, 0xa0, 0xee, 0xd6, 0x54, 0x8e, 0x89, 0xc6, 0xdf, 0x14, 0x68,
	0x9f, 0x7b, 0xbe, 0xe9, 0x66, 0xbc, 0xda, 0x9a, 0x7a, 0xfe, 0x28, 0xe5, 0xa2, 0xa8, 0x00, 0x9d,
	0x7b, 0x7e, 0x4a, 0x4b, 0x73, 0x9a, 0x06, 0xf1, 0x3e, 0x68, 0xce, 0x84, 0xba, 0x61, 0x5c, 0x1e,
	0x4b, 0x47, 0x2a, 0x49, 0xa3, 0xf0, 0x4f, 0xa1, 0xee, 0x84, 0x32, 0x5c, 0x15, 0xae, 0x52, 0xed,
	0x98, 0x61, 0x14, 0x9e, 0x88, 0x94, 0x0b, 0x4f, 0xf9, 0xbb, 0xc3, 0xb3, 0x82, 0x7a, 0xa4, 0x02,
	0x77, 0x40, 0x73, 0x84, 0x93, 0x46, 0x01, 0x4d, 0x9c, 0x2d, 0x1d, 0x37, 0xa4, 0x61, 0xaf, 0x40,
	0xc0, 0x89, 0x21, 0xfc, 0x08, 0x20, 0x31, 0x2f, 0xf6, 0x93, 0x19, 0xa3, 0x38, 0x7b, 0x0c, 0x9d,
	0x41, 0x62, 0xbe, 0xf1, 0x7b, 0x80, 0x44, 0x2d, 0x3e, 0x87, 0x3b, 0xd1, 0xc6, 0xd4, 0x5d, 0x2d,
	0x18, 0x4f, 0xe2, 0xb6, 0x3b, 0x91, 0x01, 0xdd, 0x84, 0xd4, 0x2b, 0x10, 0xec, 0x6c, 0x60, 0xf1,
	0x3d, 0xa8, 0xf8, 0x2c, 0x61, 0xa4, 0x2d, 0xd5, 0x0e, 0x4f, 0x9f, 0x5e, 0x81, 0x08, 0xf4, 0x59,
	0x05, 0x4a, 0x01, 0x0d, 0x8d, 0xc7, 0x80, 0x37, 0x55, 0xe2, 0x43, 0xa8, 0xf2, 0xa2, 0x1a, 0x95,
	0xe5, 0x8c, 0xcb, 0x24, 0xc9, 0x70, 0xa1, 0x99, 0x09, 0x22, 0xf3, 0xc1, 0x46, 0xa0, 0xd3, 0x92,
	0xcc, 0x07, 0x09, 0x03, 0xfe, 0x08, 0x6a, 0xaf, 0xe9, 0x2d, 0x6f, 0x33, 0x8a, 0xfc, 0xc2, 0x69,
	0x2c, 0x29, 0xbe, 0x12, 0x28, 0xd6, 0x79, 0x49, 0x2a, 0x33, 0x75, 0xea, 0xf9, 0xc6, 0x9f, 0x45,
	0x7e, 0x0d, 0xa6, 0xff, 0x7f, 0x7e, 0x7d, 0x0c, 0x10, 0xf0, 0xa7, 0x96, 0x07, 0xb7, 0x28, 0x7b,
	0x31, 0xf1, 0xfa, 0x0e, 0x69, 0x48, 0xd4, 0x20, 0x5a, 0xe6, 0x32, 0xa8, 0xf4, 0xdd, 0x19, 0xf4,
	0x2d, 0xa8, 0xb1, 0x12, 0xdc, 0x81, 0x9a, 0x50, 0x13, 0x48, 0xa3, 0xb0, 0xdc, 0x21, 0x1b, 0xbc,
	0x88, 0x09, 0x3f, 0xca, 0xfb, 0x63, 0x27, 0xb1, 0x68, 0xbb, 0x57, 0x58, 0x00, 0xff, 0xaa, 0xc0,
	0xce, 0x86, 0x5a, 0xfc, 0x25, 0x54, 0x9c, 0x90, 0x2e, 0xa2, 0xf8, 0x1d, 0x6d, 0xee, 0xbc, 0x89,
	0x31, 0x43, 0xba, 0x20, 0x42, 0x6c, 0x6f, 0x06, 0xef, 0x6d, 0xa5, 0xe3, 0x4f, 0x60, 0x47, 0x7a,
	0x2e, 0x95, 0xee, 0xa2, 0x64, 0x20, 0x41, 0x48, 0x72, 0x1e, 0x1f, 0x40, 0xe3, 0xc6, 0x0e, 0x46,
	0x6f, 0x9d, 0xf9, 0xe4, 0xda, 0x96, 0xc7, 0xaa, 0x13, 0xed, 0xc6, 0x0e, 0x5e, 0x4a, 0x94, 0xf1,
	0xef, 0x1a, 0x40, 0x2a, 0x30, 0xf7, 0x01, 0x58, 0xbf, 0x3d, 0x4a, 0xde, 0x77, 0xd6, 0x83, 0xab,
	0x0c, 0xf7, 0x82, 0xbf, 0xf2, 0xbf, 0x84, 0x9d, 0x31, 0x7f, 0x7b, 0x47, 0x1b, 0x65, 0x77, 0x67,
	0xe3, 0x55, 0xee, 0x15, 0x08, 0x1a, 0xe7, 0x9f, 0xf3, 0x5f, 0x00, 0x5a, 0xe5, 0x15, 0x94, 0x64,
	0xff, 0x75, 0xb5, 0x21, 0xdf, 0x5e, 0xe5, 0xc4, 0x1f, 0x6d, 0x73, 0x40, 0x59, 0xce, 0x17, 0x9b,
	0x2e, 0xf8, 0x12, 0x76, 0x58, 0x82, 0x3a, 0x6e, 0x7a, 0xbb, 0x8a, 0xdc, 0x2e, 0x57, 0x2d, 0xd9,
	0x76, 0xd3, 0x5c, 0x01, 0x95, 0xf2, 0xde, 0x34, 0x2d, 0x5f, 0x4d, 0xe4, 0xd3, 0xb7, 0x41, 0xca,
	0x67, 0x2e, 0xc8, 0x09, 0xb4, 0x5c, 0x2f, 0x4c, 0x0b, 0xd7, 0xb6, 0xdd, 0xcb, 0xa6, 0xeb, 0x85,
	0x29, 0xa9, 0xcf, 0xa0, 0x99, 0xbd, 0x55, 0x75, 0x2e, 0xd4, 0x48, 0x09, 0xb1, 0x81, 0xa5, 0x91,
	0xb9, 0x54, 0x9f, 0x43, 0xcb, 0x76, 0x27, 0x69, 0x29, 0x75, 0xab, 0x54, 0xd3, 0x76, 0x27, 0x29,
	0xb1, 0xb8, 0x50, 0xc1, 0xd6, 0x42, 0x95, 0x1a, 0x88, 0xb4, 0x77, 0x0c, 0x44, 0xf8, 0x27, 0xc9,
	0xcd, 0x69, 0xf0, 0x9b, 0x53, 0xef, 0x6c, 0x5e, 0x18, 0x7c, 0x08, 0x0d, 0x31, 0xe6, 0xc9, 0xec,
	0x6a, 0xca, 0xe1, 0x4f, 0x13, 0x58, 0x91, 0x5f, 0x87, 0xd0, 0x98, 0x78, 0xab, 0xf1, 0x9c, 0x4a,
	0xa6, 0xd6, 0xbe, 0x72, 0xa4, 0x30, 0x26, 0x81, 0x15, 0x4c, 0xd1, 0x58, 0xd9, 0xce, 0x8c, 0x95,
	0x87, 0xd0, 0x90, 0x99, 0x71, 0xed, 0xad, 0xdc, 0x50, 0x47, 0x92, 0xaa, 0x09, 0xec, 0x13, 0x86,
	0xc4, 0x27, 0xd0, 0x94, 0x4c, 0xde, 0x74, 0xca, 0x8a, 0xcf, 0x0e, 0x3f, 0x54, 0x53, 0x5e, 0xc7,
	0x01, 0x47, 0x32, 0xd7, 0x06, 0x29, 0x38, 0x25, 0x35, 0xa7, 0xee, 0x2c, 0xbc, 0xd1, 0x71, 0x46,
	0xea, 0x82, 0x23, 0x13, 0x29, 0x01, 0xe7, 0xde, 0xa4, 0x3b, 0xdf, 0xf3, 0x26, 0xb1, 0x8b, 0x11,
	0xbd, 0x3c, 0x71, 0x33, 0xb0, 0x2b, 0x33, 0x2d, 0xd7, 0x30, 0xb0, 0x4c, 0x73, 0xb2, 0xa8, 0xb3,
	0x46, 0xba, 0x50, 0x1a, 0xbf, 0x85, 0x46, 0xfa, 0x44, 0xff, 0x6b, 0xdd, 0xa8, 0x38, 0xee, 0x84,
	0xae, 0xb7, 0xf5, 0x1b, 0x82, 0x92, 0xe8, 0x97, 0x67, 0xfd, 0xa1, 0xf5, 0xff, 0x43, 0x01, 0x48,
	0x49, 0x7c, 0x9a, 0xad, 0xa7, 0x7b, 0x29, 0x2f, 0xa6, 0x96, 0xe9, 0x0a, 0xfa, 0x47, 0x05, 0x5a,
	0x59, 0x0a, 0xde, 0xcf, 0xc4, 0x43, 0x91, 0xe9, 0x91, 0x0e, 0xc1, 0xe1, 0xbb, 0x0d, 0x63, 0x17,
	0x82, 0xd3, 0xf0, 0x43, 0x50, 0xa3, 0x9e, 0x2b, 0x90, 0x95, 0x2b, 0x7f, 0xc5, 0x12, 0x86, 0xb3,
	0x2a, 0x94, 0x99, 0x41, 0xc6, 0xa7, 0xa0, 0xa5, 0x78, 0x98, 0x0b, 0x42, 0xea, 0x2f, 0xb6, 0x3e,
	0xf0, 0x82, 0x62, 0xfc, 0x53, 0x81, 0x32, 0x59, 0xcd, 0x29, 0xdb, 0x30, 0x19, 0x55, 0xa3, 0xf7,
	0x35, 0xf3, 0xd3, 0x26, 0x35, 0xa8, 0xb2, 0x41, 0x3b, 0xd7, 0x09, 0xa9, 0x99, 0x33, 0xb2, 0x61,
	0xd8, 0x9e, 0x31, 0xcb, 0x4b, 0x7c, 0x18, 0xb6, 0x67, 0x01, 0xbe, 0x0b, 0xe5, 0x05, 0x0d, 0x6d,
	0xbd, 0xcc, 0x8d, 0xa9, 0x74, 0x2e, 0x69, 0x68, 0x13, 0x8e, 0xc2, 0x07, 0xc9, 0x2b, 0x5a, 0xe1,
	0xd4, 0x9a, 0x4c, 0xfa, 0xe4, 0xe1, 0xfc, 0x18, 0xd4, 0x6b, 0xcf, 0x9d, 0x38, 0x61, 0x52, 0x1b,
	0x33, 0xe7, 0x49, 0xa8, 0xc6, 0x6f, 0xa0, 0xc6, 0x0c, 0x67, 0xcf, 0xb3, 0x0e, 0x35, 0x67, 0xb1,
	0xf4, 0xfc, 0x50, 0xf8, 0x40, 0x25, 0x11, 0xc8, 0xba, 0x61, 0xc7, 0xbd, 0x9e, 0xaf, 0x26, 0x34,
	0x6a, 0x3d, 0x63, 0x18, 0x7f, 0x08, 0x15, 0x7f, 0x35, 0xa7, 0xc2, 0x7c, 0x66, 0x2a, 0x53, 0x47,
	0x04, 0xee, 0xc1, 0x09, 0xd4, 0x64, 0xdd, 0x49, 0xb7, 0xf7, 0x0a, 0x9b, 0x56, 0xba, 0x7d, 0x8b,
	0xbc, 0x7a, 0x3e, 0x30, 0xfb, 0x16, 0x2a, 0xb2, 0xe1, 0xe4, 0xdc, 0xbc, 0xe8, 0x0e, 0xcd, 0x6f,
	0xba, 0xa8, 0xf4, 0xe0, 0x1e, 0x40, 0xd2, 0xf7, 0xb0, 0x99, 0xe9, 0xf4, 0xe2, 0x02, 0x29, 0x7c,
	0xd1, 0x7f, 0x85, 0x8a, 0x0f, 0x7e, 0x04, 0x28, 0xdf, 0x07, 0xb0, 0x59, 0xcc, 0xea, 0x75, 0x2f,
	0x91, 0x72, 0x56, 0xfe, 0xa6, 0xb8, 0x1c, 0xff, 0x37, 0x00, 0x00, 0xff, 0xff, 0x85, 0x60, 0xd3,
	0x0f, 0x55, 0x13, 0x00, 0x00,
}
