# ADIOS

Web application framework for PHP.

## What is ADIOS?

A light-weight framework combining different lower-levels libraries to simply web application development:

  * `React` for client-side javascript UI
  * `TailwindCSS` for CSS styling
  * `Twig` as a HTML templating engine
  * `Eloquent ORM` as a database layer
  * `Primereact` for UI components like *tables*, *forms* and *tabs*
  * and others (e.g. `react-select` for autocomplete)

## Screenshots

![Form developed using ADIOS framework](https://hubleto.com/assets/images/screens/customers.jpg)
**Form developed using ADIOS framework (source: https://www.hubleto.com)**

## Features

  * Small footprint
  * Powerful record-management (data-management) features
  * Strong form-templating features
  * Flexible and yet simple to configure routing
  * Full-featured set of in-built UI components (tables, forms, tabs, inputs, charts, dashboard, ...)
  * In-built database relationships (1:N and M:N) management
  * In-built configuration management (DB-based or file-based)
  * Multi-language support
  * Skinnable

## Where is ADIOS used

  * Hubleto opensource CRM/ERP (https://www.hubleto.com).

## Want to contribute?

ADIOS is an open-source MIT licensed framework. You can use it for free for both personal and commercial projects.

We will be happy for any contributions to the project:

  * UI componets
  * Language dictionaries
  * Skins
  * Plugins
  * Prototype builder templates
  * Sample applications
  * Documentation
  * Unit tests
  * And anything else...

Enjoy!
