# Ligthweight MVC framework

**Adios** is a lightweight MVC framework combining PHP, Eloquent, React, Tailwind and Twig to speed up prototyping and development of custom web applications.

## Brief introduction

### About the framework

**Adios** is a MIT-licensed lightweight MVC framework combining:

  * <i class="text-primary fa-brands fa-php"></i> `PHP` + <i class="text-primary fa-brands fa-laravel"></i> `Laravel's Eloquent` for implementing backend; and
  * <i class="text-primary fa-brands fa-react"></i> `React` + `Tailwind` + `Twig` + `Primereact` for rendering the frontend

Adios framework uniquely combines all these libraries and rapidly simplifies prototyping and development of custom web applications.

Full source code is available at <i class="fa-brands fa-github"></i> [GitHub](https://github.com/wai-blue/ADIOS).

### Key features

Backend side:
  * Flexible **folder structure** with consistent PHP namespace conventions.
  * **Built-in user authentication** either using SQL database or OAuth.
  * **Build-in ACL and permissions** management.
  * **Built-in API** for creating, reading, updating and deleting records. Implementing CRUD operations upon custom models is very easy.
  * **Easy routing** definition.
  * **Easy development** of custom data structures, including 1:N and M:N relations.

Frontend side:
  * Fully customizable pre-compiled default views for app's desktop user interface (thanks to [Tailwind CSS](https://tailwindcss.com) and [Twig](https://twig.symfony.com)).
  * Large set of **pre-compiled input components** for various datatypes (including support for uploading images/files or rendering of autocomplete select for 1:N relations), using other well-developed libraries like [React Select](https://react-select.com/async).
  * Fully customizable **tables and forms** (thanks to [PrimeReact Datatable](https://primereact.org/datatable)).
  * **Easy reusability** of developed UI components.
  * Consistent definition of UI features for tables, forms and inputs.
  * Fast learning curve (thanks to using standard MVC principles and well-known libraries like [Laravel's Eloquent](https://laravel.com/docs/11.x/eloquent) or [React](https://react.dev)).

All pre-compiled and built-in functionality can be easily customized.

## Getting started
### Create your app from scratch

It's easy to start developing with Adios. Learn [here](../examples/empty-app.md) how to create your first project.

## References
### Who is using Adios

WAI, eMonitor, DORADO, Miomed, SecurityAgency, AquilaCosting, 3decom, Ceremony
