# mapgl <a href="https://walker-data.com/mapgl"><img src="man/figures/logo.png" align="right" height="120" alt="mapgl website" /></a>

The **mapgl** R package makes the latest versions of [Mapbox GL JS](https://docs.mapbox.com/mapbox-gl-js/api/) and [MapLibre GL JS](https://maplibre.org/maplibre-gl-js/docs/) available to R users. The package interface is designed to make the powerful capabilities of both libraries available in R mapping projects, but also feel similar to users coming from other R mapping packages.

Install the development version from GitHub with the following command: 

```r
remotes::install_github("walkerke/mapgl")
```

A CRAN release is forthcoming shortly.  

Read through these vignettes to learn how to use the package:

-   [Getting started with mapgl](https://walker-data.com/mapgl/articles/getting-started.html)

-   [Using layers: an overview](https://walker-data.com/mapgl/articles/layers-overview.html)

-   [Fundamentals of map design with mapgl](https://walker-data.com/mapgl/articles/map-design.html)

-   [Using mapgl with Shiny](https://walker-data.com/mapgl/articles/shiny.html)

## Recommended training and how to learn more

If you find this project useful in your work and would like to ensure continued development of the package, you can provide support in the following ways: 

* [Chip in some funds to support package development via PayPal](https://paypal.me/walkerdata);
* Set up a consulting engagement or workshop though Walker Data to help you implement __mapgl__ in your project.  Send a note to <kyle@walker-data.com> if you are interested; 
* File an issue - or even better, a pull request - at https://github.com/walkerke/mapgl/issues. 

To stay on top of package updates / new features and to get information about __mapgl__ trainings, [be sure to sign up for the Walker Data mailing list here](https://walker-data.us15.list-manage.com/subscribe?u=1829a68a5eda3d301119fdcd6&id=c4a53d2961).
