% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{add_circle_layer}
\alias{add_circle_layer}
\title{Add a circle layer to a Mapbox GL map}
\usage{
add_circle_layer(
  map,
  id,
  source,
  source_layer = NULL,
  circle_blur = NULL,
  circle_color = NULL,
  circle_opacity = NULL,
  circle_radius = NULL,
  circle_sort_key = NULL,
  circle_stroke_color = NULL,
  circle_stroke_opacity = NULL,
  circle_stroke_width = NULL,
  circle_translate = NULL,
  circle_translate_anchor = "map",
  visibility = "visible",
  slot = NULL,
  min_zoom = NULL,
  max_zoom = NULL,
  popup = NULL,
  tooltip = NULL,
  hover_options = NULL
)
}
\arguments{
\item{map}{A map object created by the \code{mapboxgl} function.}

\item{id}{A unique ID for the layer.}

\item{source}{The ID of the source, alternatively an sf object (which will be converted to a GeoJSON source) or a named list that specifies \code{type} and \code{url} for a remote source.}

\item{source_layer}{The source layer (for vector sources).}

\item{circle_blur}{Amount to blur the circle.}

\item{circle_color}{The color of the circle.}

\item{circle_opacity}{The opacity at which the circle will be drawn.}

\item{circle_radius}{Circle radius.}

\item{circle_sort_key}{Sorts features in ascending order based on this value.}

\item{circle_stroke_color}{The color of the circle's stroke.}

\item{circle_stroke_opacity}{The opacity of the circle's stroke.}

\item{circle_stroke_width}{The width of the circle's stroke.}

\item{circle_translate}{The geometry's offset. Values are \code{c(x, y)} where negatives indicate left and up.}

\item{circle_translate_anchor}{Controls the frame of reference for \code{circle-translate}.}

\item{visibility}{Whether this layer is displayed.}

\item{slot}{An optional slot for layer order.}

\item{min_zoom}{The minimum zoom level for the layer.}

\item{max_zoom}{The maximum zoom level for the layer.}

\item{popup}{A column name containing information to display in a popup on click.  Columns containing HTML will be parsed.}

\item{tooltip}{A column name containing information to display in a tooltip on hover. Columns containing HTML will be parsed.}

\item{hover_options}{A named list of options for highlighting features in the layer on hover.}
}
\value{
The modified map object with the new circle layer added.
}
\description{
Add a circle layer to a Mapbox GL map
}
\examples{
\dontrun{
library(mapgl)
library(sf)
library(dplyr)

# Set seed for reproducibility
set.seed(1234)

# Define the bounding box for Washington DC (approximately)
bbox <- st_bbox(c(
  xmin = -77.119759,
  ymin = 38.791645,
  xmax = -76.909393,
  ymax = 38.995548
),
crs = st_crs(4326))

# Generate 30 random points within the bounding box
random_points <- st_as_sf(
  data.frame(
    id = 1:30,
    lon = runif(30, bbox["xmin"], bbox["xmax"]),
    lat = runif(30, bbox["ymin"], bbox["ymax"])
  ),
  coords = c("lon", "lat"),
  crs = 4326
)

# Assign random categories
categories <- c('music', 'bar', 'theatre', 'bicycle')
random_points <- random_points \%>\%
  mutate(category = sample(categories, n(), replace = TRUE))

# Map with circle layer
mapboxgl(style = mapbox_style("light")) \%>\%
  fit_bounds(random_points, animate = FALSE) \%>\%
  add_circle_layer(
    id = "poi-layer",
    source = random_points,
    circle_color = match_expr(
      "category",
      values = c("music", "bar", "theatre",
                 "bicycle"),
      stops = c("#1f78b4", "#33a02c",
                "#e31a1c", "#ff7f00")
    ),
    circle_radius = 8,
    circle_stroke_color = "#ffffff",
    circle_stroke_width = 2,
    circle_opacity = 0.8,
    tooltip = "category",
    hover_options = list(circle_radius = 12,
                         circle_color = "#ffff99")
  ) \%>\%
  add_categorical_legend(
    legend_title = "Points of Interest",
    values = c("Music", "Bar", "Theatre", "Bicycle"),
    colors = c("#1f78b4", "#33a02c", "#e31a1c", "#ff7f00"),
    circular_patches = TRUE
  )
}
}
