% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapboxgl.R
\name{mapboxgl}
\alias{mapboxgl}
\title{Initialize a Mapbox GL Map}
\usage{
mapboxgl(
  style = NULL,
  center = c(0, 0),
  zoom = 0,
  bearing = 0,
  pitch = 0,
  projection = "globe",
  parallels = NULL,
  access_token = NULL,
  width = "100\%",
  height = NULL,
  ...
)
}
\arguments{
\item{style}{The Mapbox style to use.}

\item{center}{A numeric vector of length 2 specifying the initial center of the map.}

\item{zoom}{The initial zoom level of the map.}

\item{bearing}{The initial bearing (rotation) of the map, in degrees.}

\item{pitch}{The initial pitch (tilt) of the map, in degrees.}

\item{projection}{The map projection to use (e.g., "mercator", "globe").}

\item{parallels}{A vector of two numbers representing the standard parellels of the projection.  Only available when the projection is "albers" or "lambertConformalConic".}

\item{access_token}{Your Mapbox access token.}

\item{width}{The width of the output htmlwidget.}

\item{height}{The height of the output htmlwidget.}

\item{...}{Additional named parameters to be passed to the Mapbox GL map.}
}
\value{
An HTML widget for a Mapbox map.
}
\description{
Initialize a Mapbox GL Map
}
\examples{
\dontrun{
mapboxgl(projection = "globe")
}
}
