package tech.washmore.autocode.model.enums;

import java.sql.Types;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Washmore
 * @version V1.0
 * @summary TODO
 * @Copyright (c) 2018, Lianjia Group All Rights Reserved.
 * @since 2018/6/12
 */
public enum JdbcType {
    ARRAY(Types.ARRAY),

    BIT(Types.BIT),

    TINYINT(Types.TINYINT),

    SMALLINT(Types.SMALLINT),

    INTEGER(Types.INTEGER),

    BIGINT(Types.BIGINT),

    FLOAT(Types.FLOAT),

    REAL(Types.REAL),

    DOUBLE(Types.DOUBLE),

    NUMERIC(Types.NUMERIC),

    DECIMAL(Types.DECIMAL),

    CHAR(Types.CHAR),

    VARCHAR(Types.VARCHAR),

    LONGVARCHAR(Types.LONGVARCHAR),

    DATE(Types.DATE),

    TIME(Types.TIME),

    TIMESTAMP(Types.TIMESTAMP),

    BINARY(Types.BINARY),

    VARBINARY(Types.VARBINARY),

    LONGVARBINARY(Types.LONGVARBINARY),

    NULL(Types.NULL),

    OTHER(Types.OTHER),

    BLOB(Types.BLOB),

    CLOB(Types.CLOB),

    BOOLEAN(Types.BOOLEAN),

    CURSOR(-10), // Oracle

    UNDEFINED(Integer.MIN_VALUE + 1000),

    NVARCHAR(Types.NVARCHAR), // JDK6

    NCHAR(Types.NCHAR), // JDK6

    NCLOB(Types.NCLOB), // JDK6

    STRUCT(Types.STRUCT),

    JAVA_OBJECT(Types.JAVA_OBJECT),

    DISTINCT(Types.DISTINCT),

    REF(Types.REF),

    DATALINK(Types.DATALINK),

    ROWID(Types.ROWID), // JDK6

    LONGNVARCHAR(Types.LONGNVARCHAR), // JDK6

    SQLXML(Types.SQLXML), // JDK6

    DATETIMEOFFSET(-155); // SQL Server 2008

    public final int TYPE_CODE;
    private static Map<Integer, JdbcType> codeLookup = new HashMap<Integer, JdbcType>();

    static {
        for (JdbcType type : JdbcType.values()) {
            codeLookup.put(type.TYPE_CODE, type);
        }
    }

    JdbcType(int code) {
        this.TYPE_CODE = code;
    }

    public static JdbcType forCode(int code) {
        return codeLookup.get(code);
    }

}
