/*
 * 3DS OUTSCALE API
 *
 * Welcome to the 3DS OUTSCALE's API documentation.<br /><br />  The 3DS OUTSCALE API enables you to manage your resources in the 3DS OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the 3DS OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the 3DS OUTSCALE API. You can find a list of the differences [here](https://wiki.outscale.net/display/EN/3DS+OUTSCALE+APIs+Reference).<br /><br />  You can also manage your resources using the [Cockpit](https://wiki.outscale.net/display/EN/About+Cockpit) web interface.
 *
 * API version: 1.2
 * Contact: support@outscale.com
 * Generated by: OpenAPI Generator (https://openapi-generator.tech)
 */

package osc
// FiltersTag One or more filters.
type FiltersTag struct {
	// The keys of the tags that are assigned to the resources. You can use this filter alongside the `Values` filter. In that case, you filter the resources corresponding to each tag, regardless of the other filter.
	Keys []string `json:"Keys,omitempty"`
	// The IDs of the resources with which the tags are associated.
	ResourceIds []string `json:"ResourceIds,omitempty"`
	// The resource type (`vm` \\| `image` \\| `volume` \\| `snapshot` \\| `public-ip` \\| `security-group` \\| `route-table` \\| `nic` \\| `net` \\| `subnet` \\| `net-peering` \\| `net-access-point` \\| `nat-service` \\| `internet-service` \\| `client-gateway` \\| `virtual-gateway` \\| `vpn-connection` \\| `dhcp-options` \\| `task`).
	ResourceTypes []string `json:"ResourceTypes,omitempty"`
	// The values of the tags that are assigned to the resources. You can use this filter alongside the `TagKeys` filter. In that case, you filter the resources corresponding to each tag, regardless of the other filter.
	Values []string `json:"Values,omitempty"`
}
