/*
 * 3DS OUTSCALE API
 *
 * Welcome to the 3DS OUTSCALE's API documentation.<br /><br />  The 3DS OUTSCALE API enables you to manage your resources in the 3DS OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the 3DS OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the 3DS OUTSCALE API. You can find a list of the differences [here](https://wiki.outscale.net/display/EN/3DS+OUTSCALE+APIs+Reference).<br /><br />  You can also manage your resources using the [Cockpit](https://wiki.outscale.net/display/EN/About+Cockpit) web interface.
 *
 * API version: 1.2
 * Contact: support@outscale.com
 * Generated by: OpenAPI Generator (https://openapi-generator.tech)
 */

package osc
// FiltersVolume One or more filters.
type FiltersVolume struct {
	// The dates and times at which the volumes were created.
	CreationDates []string `json:"CreationDates,omitempty"`
	// Indicates whether the volumes are deleted when terminating the VMs.
	LinkVolumeDeleteOnVmDeletion bool `json:"LinkVolumeDeleteOnVmDeletion,omitempty"`
	// The VM device names.
	LinkVolumeDeviceNames []string `json:"LinkVolumeDeviceNames,omitempty"`
	// The dates and times at which the volumes were created.
	LinkVolumeLinkDates []string `json:"LinkVolumeLinkDates,omitempty"`
	// The attachment states of the volumes (`attaching` \\| `detaching` \\| `attached` \\| `detached`).
	LinkVolumeLinkStates []string `json:"LinkVolumeLinkStates,omitempty"`
	// One or more IDs of VMs.
	LinkVolumeVmIds []string `json:"LinkVolumeVmIds,omitempty"`
	// The snapshots from which the volumes were created.
	SnapshotIds []string `json:"SnapshotIds,omitempty"`
	// The names of the Subregions in which the volumes were created.
	SubregionNames []string `json:"SubregionNames,omitempty"`
	// The keys of the tags associated with the volumes.
	TagKeys []string `json:"TagKeys,omitempty"`
	// The values of the tags associated with the volumes.
	TagValues []string `json:"TagValues,omitempty"`
	// The key/value combination of the tags associated with the volumes, in the following format: \"Filters\":{\"Tags\":[\"TAGKEY=TAGVALUE\"]}.
	Tags []string `json:"Tags,omitempty"`
	// The IDs of the volumes.
	VolumeIds []string `json:"VolumeIds,omitempty"`
	// The sizes of the volumes, in gibibytes (GiB).
	VolumeSizes []int32 `json:"VolumeSizes,omitempty"`
	// The states of the volumes (`creating` \\| `available` \\| `in-use` \\| `deleting` \\| `error`).
	VolumeStates []string `json:"VolumeStates,omitempty"`
	// The types of the volumes (`standard` \\| `gp2` \\| `io1`).
	VolumeTypes []string `json:"VolumeTypes,omitempty"`
}
