// Code generated by sdkgen. DO NOT EDIT.

//nolint
package clickhouse

import (
	"context"

	"google.golang.org/grpc"

	clickhouse "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/clickhouse/v1"
)

//revive:disable

// BackupServiceClient is a clickhouse.BackupServiceClient with
// lazy GRPC connection initialization.
type BackupServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Get implements clickhouse.BackupServiceClient
func (c *BackupServiceClient) Get(ctx context.Context, in *clickhouse.GetBackupRequest, opts ...grpc.CallOption) (*clickhouse.Backup, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return clickhouse.NewBackupServiceClient(conn).Get(ctx, in, opts...)
}

// List implements clickhouse.BackupServiceClient
func (c *BackupServiceClient) List(ctx context.Context, in *clickhouse.ListBackupsRequest, opts ...grpc.CallOption) (*clickhouse.ListBackupsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return clickhouse.NewBackupServiceClient(conn).List(ctx, in, opts...)
}

type BackupIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *BackupServiceClient
	request *clickhouse.ListBackupsRequest

	items []*clickhouse.Backup
}

func (c *BackupServiceClient) BackupIterator(ctx context.Context, folderId string, opts ...grpc.CallOption) *BackupIterator {
	return &BackupIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &clickhouse.ListBackupsRequest{
			FolderId: folderId,
			PageSize: 1000,
		},
	}
}

func (it *BackupIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Backups
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *BackupIterator) Value() *clickhouse.Backup {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *BackupIterator) Error() error {
	return it.err
}
