import assert from 'node:assert'
import { test, describe } from 'vitest'
import * as core from '../../../target/esm/core.mjs'
import * as index from '../../../target/esm/index.mjs'

//prettier-ignore
describe('core', () => {
  test('exports', () => {
    assert.equal(typeof core.Address, 'function', 'core.Address')
    assert.equal(typeof core.Address.fromPrefixLen, 'function', 'core.Address.fromPrefixLen')
    assert.equal(typeof core.Address.parseCidr, 'function', 'core.Address.parseCidr')
    assert.equal(typeof core.cidr, 'function', 'core.cidr')
    assert.equal(typeof core.cidrSubnet, 'function', 'core.cidrSubnet')
    assert.equal(typeof core.fromLong, 'function', 'core.fromLong')
    assert.equal(typeof core.fromPrefixLen, 'function', 'core.fromPrefixLen')
    assert.equal(typeof core.isEqual, 'function', 'core.isEqual')
    assert.equal(typeof core.isIP, 'function', 'core.isIP')
    assert.equal(typeof core.isIPv4, 'function', 'core.isIPv4')
    assert.equal(typeof core.isIPv6, 'function', 'core.isIPv6')
    assert.equal(typeof core.isLoopback, 'function', 'core.isLoopback')
    assert.equal(typeof core.isPrivate, 'function', 'core.isPrivate')
    assert.equal(typeof core.isPublic, 'function', 'core.isPublic')
    assert.equal(typeof core.isV4Format, 'function', 'core.isV4Format')
    assert.equal(typeof core.isV6Format, 'function', 'core.isV6Format')
    assert.equal(typeof core.loopback, 'function', 'core.loopback')
    assert.equal(typeof core.mask, 'function', 'core.mask')
    assert.equal(typeof core.normalizeToLong, 'function', 'core.normalizeToLong')
    assert.equal(typeof core.not, 'function', 'core.not')
    assert.equal(typeof core.or, 'function', 'core.or')
    assert.equal(typeof core.subnet, 'function', 'core.subnet')
    assert.equal(typeof core.toBuffer, 'function', 'core.toBuffer')
    assert.equal(typeof core.toLong, 'function', 'core.toLong')
    assert.equal(typeof core.toString, 'function', 'core.toString')
  })
})

//prettier-ignore
describe('index', () => {
  test('exports', () => {
    assert.equal(typeof index.Address, 'function', 'index.Address')
    assert.equal(typeof index.Address.fromPrefixLen, 'function', 'index.Address.fromPrefixLen')
    assert.equal(typeof index.Address.parseCidr, 'function', 'index.Address.parseCidr')
    assert.equal(typeof index.address, 'function', 'index.address')
    assert.equal(typeof index.addresses, 'function', 'index.addresses')
    assert.equal(typeof index.cidr, 'function', 'index.cidr')
    assert.equal(typeof index.cidrSubnet, 'function', 'index.cidrSubnet')
    assert.equal(typeof index.default, 'object', 'index.default')
    assert.equal(typeof index.default.Address, 'function', 'index.default.Address')
    assert.equal(typeof index.default.address, 'function', 'index.default.address')
    assert.equal(typeof index.default.addresses, 'function', 'index.default.addresses')
    assert.equal(typeof index.default.cidr, 'function', 'index.default.cidr')
    assert.equal(typeof index.default.cidrSubnet, 'function', 'index.default.cidrSubnet')
    assert.equal(typeof index.default.fromLong, 'function', 'index.default.fromLong')
    assert.equal(typeof index.default.fromPrefixLen, 'function', 'index.default.fromPrefixLen')
    assert.equal(typeof index.default.isEqual, 'function', 'index.default.isEqual')
    assert.equal(typeof index.default.isIP, 'function', 'index.default.isIP')
    assert.equal(typeof index.default.isIPv4, 'function', 'index.default.isIPv4')
    assert.equal(typeof index.default.isIPv6, 'function', 'index.default.isIPv6')
    assert.equal(typeof index.default.isLoopback, 'function', 'index.default.isLoopback')
    assert.equal(typeof index.default.isPrivate, 'function', 'index.default.isPrivate')
    assert.equal(typeof index.default.isPublic, 'function', 'index.default.isPublic')
    assert.equal(typeof index.default.isV4Format, 'function', 'index.default.isV4Format')
    assert.equal(typeof index.default.isV6Format, 'function', 'index.default.isV6Format')
    assert.equal(typeof index.default.loopback, 'function', 'index.default.loopback')
    assert.equal(typeof index.default.mask, 'function', 'index.default.mask')
    assert.equal(typeof index.default.normalizeToLong, 'function', 'index.default.normalizeToLong')
    assert.equal(typeof index.default.not, 'function', 'index.default.not')
    assert.equal(typeof index.default.or, 'function', 'index.default.or')
    assert.equal(typeof index.default.subnet, 'function', 'index.default.subnet')
    assert.equal(typeof index.default.toBuffer, 'function', 'index.default.toBuffer')
    assert.equal(typeof index.default.toLong, 'function', 'index.default.toLong')
    assert.equal(typeof index.default.toString, 'function', 'index.default.toString')
    assert.equal(typeof index.fromLong, 'function', 'index.fromLong')
    assert.equal(typeof index.fromPrefixLen, 'function', 'index.fromPrefixLen')
    assert.equal(typeof index.ip, 'object', 'index.ip')
    assert.equal(typeof index.ip.Address, 'function', 'index.ip.Address')
    assert.equal(typeof index.ip.address, 'function', 'index.ip.address')
    assert.equal(typeof index.ip.addresses, 'function', 'index.ip.addresses')
    assert.equal(typeof index.ip.cidr, 'function', 'index.ip.cidr')
    assert.equal(typeof index.ip.cidrSubnet, 'function', 'index.ip.cidrSubnet')
    assert.equal(typeof index.ip.fromLong, 'function', 'index.ip.fromLong')
    assert.equal(typeof index.ip.fromPrefixLen, 'function', 'index.ip.fromPrefixLen')
    assert.equal(typeof index.ip.isEqual, 'function', 'index.ip.isEqual')
    assert.equal(typeof index.ip.isIP, 'function', 'index.ip.isIP')
    assert.equal(typeof index.ip.isIPv4, 'function', 'index.ip.isIPv4')
    assert.equal(typeof index.ip.isIPv6, 'function', 'index.ip.isIPv6')
    assert.equal(typeof index.ip.isLoopback, 'function', 'index.ip.isLoopback')
    assert.equal(typeof index.ip.isPrivate, 'function', 'index.ip.isPrivate')
    assert.equal(typeof index.ip.isPublic, 'function', 'index.ip.isPublic')
    assert.equal(typeof index.ip.isV4Format, 'function', 'index.ip.isV4Format')
    assert.equal(typeof index.ip.isV6Format, 'function', 'index.ip.isV6Format')
    assert.equal(typeof index.ip.loopback, 'function', 'index.ip.loopback')
    assert.equal(typeof index.ip.mask, 'function', 'index.ip.mask')
    assert.equal(typeof index.ip.normalizeToLong, 'function', 'index.ip.normalizeToLong')
    assert.equal(typeof index.ip.not, 'function', 'index.ip.not')
    assert.equal(typeof index.ip.or, 'function', 'index.ip.or')
    assert.equal(typeof index.ip.subnet, 'function', 'index.ip.subnet')
    assert.equal(typeof index.ip.toBuffer, 'function', 'index.ip.toBuffer')
    assert.equal(typeof index.ip.toLong, 'function', 'index.ip.toLong')
    assert.equal(typeof index.ip.toString, 'function', 'index.ip.toString')
    assert.equal(typeof index.isEqual, 'function', 'index.isEqual')
    assert.equal(typeof index.isIP, 'function', 'index.isIP')
    assert.equal(typeof index.isIPv4, 'function', 'index.isIPv4')
    assert.equal(typeof index.isIPv6, 'function', 'index.isIPv6')
    assert.equal(typeof index.isLoopback, 'function', 'index.isLoopback')
    assert.equal(typeof index.isPrivate, 'function', 'index.isPrivate')
    assert.equal(typeof index.isPublic, 'function', 'index.isPublic')
    assert.equal(typeof index.isV4Format, 'function', 'index.isV4Format')
    assert.equal(typeof index.isV6Format, 'function', 'index.isV6Format')
    assert.equal(typeof index.loopback, 'function', 'index.loopback')
    assert.equal(typeof index.mask, 'function', 'index.mask')
    assert.equal(typeof index.normalizeToLong, 'function', 'index.normalizeToLong')
    assert.equal(typeof index.not, 'function', 'index.not')
    assert.equal(typeof index.or, 'function', 'index.or')
    assert.equal(typeof index.subnet, 'function', 'index.subnet')
    assert.equal(typeof index.toBuffer, 'function', 'index.toBuffer')
    assert.equal(typeof index.toLong, 'function', 'index.toLong')
    assert.equal(typeof index.toString, 'function', 'index.toString')
  })
})
