import { type BufferLike } from './polyfill.ts';
export type { BufferLike } from './polyfill.ts';
export type Special = 'loopback' | 'private' | 'linklocal' | 'multicast' | 'documentation' | 'reserved' | 'unspecified';
type Family = 4 | 6;
export type FamilyAlias = Family | '4' | '6' | 'ipv4' | 'ipv6' | 'IPV4' | 'IPV6' | 'IpV4' | 'IpV6';
type Raw = string | number | bigint | BufferLike | Array<number> | Address;
type Subnet = {
    family: Family;
    networkAddress: string;
    firstAddress: string;
    lastAddress: string;
    broadcastAddress: string;
    subnetMask: string;
    subnetMaskLength: number;
    numHosts: bigint;
    length: bigint;
    contains(addr: Raw): boolean;
};
export declare class Address {
    raw: Raw;
    family: Family;
    big: bigint;
    toBuffer(buff?: BufferLike, offset?: number): BufferLike;
    toArray(): number[];
    toString(family?: FamilyAlias, mapped?: boolean): string;
    toLong(): number;
    get range(): Special | undefined;
    private static create;
    static from(raw: Raw): Address;
    static mask(addr: Raw, mask: Raw): string;
    static subnet(addr: Raw, smask: Raw): Subnet;
    static cidr(cidrString: string): string;
    static cidrSubnet(cidrString: string): Subnet;
    static not(addr: Raw): string;
    static or(addrA: Raw, addrB: Raw): string;
    static isEqual(addrA: Raw, addrB: Raw): boolean;
    static fromPrefixLen: (prefixlen: number | `${number}` | string, family?: FamilyAlias) => Address;
    private static fromNumber;
    private static fromLong;
    private static fromBuffer;
    private static fromString;
    private static fromIPv6;
    private static fromIPv4;
    private static parseCidr;
    static normalizeFamily(family: string | number): Family;
    static normalizeToLong(addr: string, strict?: boolean): number;
    static isSpecial(addr: Raw, range?: Special | Special[]): boolean;
    static isPrivate(addr: Raw): boolean;
    static isPublic(addr: Raw): boolean;
}
export declare const isPublic: typeof Address['isPublic'];
export declare const isPrivate: typeof Address['isPrivate'];
export declare const isEqual: typeof Address['isEqual'];
export declare const mask: typeof Address['mask'];
export declare const not: typeof Address['not'];
export declare const or: typeof Address['or'];
export declare const cidr: typeof Address['cidr'];
export declare const normalizeToLong: typeof Address['normalizeToLong'];
export declare function fromPrefixLen(prefixlen: number, family?: FamilyAlias): string;
type LegacySubnet = Omit<Subnet, 'numHosts' | 'length'> & {
    numHosts: number | bigint;
    length: number | bigint;
};
type Checker = (addr: string) => boolean;
export declare function subnet(addr: Raw, smask: Raw): LegacySubnet;
export declare function cidrSubnet(cidrString: string): LegacySubnet;
export declare function toBuffer(addr: Raw, buff?: BufferLike, offset?: number): BufferLike;
export declare function toString(buf: BufferLike | number, offset?: number, length?: number): string;
export declare function toLong(addr: Raw): number;
export declare function fromLong(n: number | bigint | `${bigint}`): string;
export declare const isV4Format: Checker;
export declare const isV6Format: Checker;
export declare const isIPv4: Checker;
export declare const isIPv6: Checker;
export declare const isIP: (addr: string) => 0 | Family;
export declare function isLoopback(addr: Raw): boolean;
export declare function loopback(family?: FamilyAlias): string;
