import * as native from './native.ts';
import * as core from './core.ts';
export * from './native.ts';
export { type Special, type BufferLike, Address, isPrivate, isPublic, isEqual, isLoopback, loopback, toLong, toBuffer, toString, fromLong, fromPrefixLen, cidr, cidrSubnet, subnet, mask, not, or, normalizeToLong, } from './core.ts';
export declare const ip: {
    isIP: typeof native.isIP;
    isIPv6: typeof native.isIPv6;
    isIPv4: typeof native.isIPv4;
    isV4Format: typeof native.isIPv4;
    isV6Format: typeof native.isIPv6;
    addresses: (kind?: string, family?: core.FamilyAlias) => string[];
    address: (kind?: string, family?: core.FamilyAlias) => string | undefined;
    fromPrefixLen(prefixlen: number, family?: core.FamilyAlias): string;
    subnet(addr: string | number | bigint | number[] | core.BufferLike | core.Address, smask: string | number | bigint | number[] | core.BufferLike | core.Address): Omit<{
        family: 4 | 6;
        networkAddress: string;
        firstAddress: string;
        lastAddress: string;
        broadcastAddress: string;
        subnetMask: string;
        subnetMaskLength: number;
        numHosts: bigint;
        length: bigint;
        contains(addr: string | number | bigint | number[] | core.BufferLike | core.Address): boolean;
    }, "length" | "numHosts"> & {
        numHosts: number | bigint;
        length: number | bigint;
    };
    cidrSubnet(cidrString: string): Omit<{
        family: 4 | 6;
        networkAddress: string;
        firstAddress: string;
        lastAddress: string;
        broadcastAddress: string;
        subnetMask: string;
        subnetMaskLength: number;
        numHosts: bigint;
        length: bigint;
        contains(addr: string | number | bigint | number[] | core.BufferLike | core.Address): boolean;
    }, "length" | "numHosts"> & {
        numHosts: number | bigint;
        length: number | bigint;
    };
    toBuffer(addr: string | number | bigint | number[] | core.BufferLike | core.Address, buff?: core.BufferLike, offset?: number): core.BufferLike;
    toString(buf: core.BufferLike | number, offset?: number, length?: number): string;
    toLong(addr: string | number | bigint | number[] | core.BufferLike | core.Address): number;
    fromLong(n: number | bigint | `${bigint}`): string;
    isLoopback(addr: string | number | bigint | number[] | core.BufferLike | core.Address): boolean;
    loopback(family?: core.FamilyAlias): string;
    Address: typeof core.Address;
    isPublic: (typeof core.Address)["isPublic"];
    isPrivate: (typeof core.Address)["isPrivate"];
    isEqual: (typeof core.Address)["isEqual"];
    mask: (typeof core.Address)["mask"];
    not: (typeof core.Address)["not"];
    or: (typeof core.Address)["or"];
    cidr: (typeof core.Address)["cidr"];
    normalizeToLong: (typeof core.Address)["normalizeToLong"];
};
export default ip;
