mod common;
mod document;
mod r#enum;
mod errors;
mod field_option;
mod fieldset;
mod include;
mod method;
mod namespace;
mod service;
mod r#struct;
mod r#type;
mod value;

pub use common::Span;
pub use document::{parse_document, Document};
pub use errors::ParseError;
pub use field_option::FieldOption;
pub use fieldset::{Field as FieldsetField, Fieldset};
pub use include::Include;
pub use method::Method;
pub use namespace::{Namespace, NamespacePart};
pub use r#enum::{Enum, EnumVariant};
pub use r#struct::{Field, Struct};
pub use r#type::{Type, TypeRef};
pub use service::Service;
pub use value::Value;
