﻿#region License

/*
    Copyright [2011] [Jeffrey Cameron]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

#endregion

using System;
using System.IO.Abstractions;

namespace PicklesDoc.Pickles.DirectoryCrawler
{
    public enum NodeType
    {
        /// <summary>
        /// Content files like .feature or .md files.
        /// </summary>
        Content = 0,

        /// <summary>
        /// Image files like .png or .jpg
        /// </summary>
        Data = 1,

        /// <summary>
        /// Nodes that represent directories.
        /// </summary>
        Structure = 2
    }

    public interface INode
    {
        NodeType NodeType { get; }

        string Name { get; }

        FileSystemInfoBase OriginalLocation { get; }

        Uri OriginalLocationUrl { get; }

        string RelativePathFromRoot { get; }

        string GetRelativeUriTo(Uri other);

        string GetRelativeUriTo(Uri other, string newExtension);
    }
}