/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.util;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.primitives.Ints;
import com.google.protobuf.Descriptors;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Internal;
import com.google.protobuf.Message;
import com.google.protobuf.util.FieldMaskTree;
import java.util.ArrayList;
import java.util.Arrays;

public class FieldMaskUtil {
    private static final String FIELD_PATH_SEPARATOR = ",";
    private static final String FIELD_PATH_SEPARATOR_REGEX = ",";
    private static final String FIELD_SEPARATOR_REGEX = "\\.";

    private FieldMaskUtil() {
    }

    public static String toString(FieldMask fieldMask) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string : fieldMask.getPathsList()) {
            if (string.isEmpty()) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static FieldMask fromString(String string) {
        return FieldMaskUtil.fromStringList(null, Arrays.asList(string.split(",")));
    }

    public static FieldMask fromString(Class<? extends Message> clazz, String string) {
        return FieldMaskUtil.fromStringList(clazz, Arrays.asList(string.split(",")));
    }

    public static FieldMask fromStringList(Class<? extends Message> clazz, Iterable<String> iterable) {
        FieldMask.Builder builder = FieldMask.newBuilder();
        for (String string : iterable) {
            if (string.isEmpty()) continue;
            if (clazz != null && !FieldMaskUtil.isValid(clazz, string)) {
                throw new IllegalArgumentException(string + " is not a valid path for " + clazz);
            }
            builder.addPaths(string);
        }
        return builder.build();
    }

    public static FieldMask fromFieldNumbers(Class<? extends Message> clazz, int ... nArray) {
        return FieldMaskUtil.fromFieldNumbers(clazz, Ints.asList((int[])nArray));
    }

    public static FieldMask fromFieldNumbers(Class<? extends Message> clazz, Iterable<Integer> iterable) {
        Descriptors.Descriptor descriptor = ((Message)Internal.getDefaultInstance(clazz)).getDescriptorForType();
        FieldMask.Builder builder = FieldMask.newBuilder();
        for (Integer n : iterable) {
            Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByNumber(n.intValue());
            Preconditions.checkArgument((fieldDescriptor != null ? 1 : 0) != 0, (Object)String.format("%s is not a valid field number for %s.", n, clazz));
            builder.addPaths(fieldDescriptor.getName());
        }
        return builder.build();
    }

    public static String toJsonString(FieldMask fieldMask) {
        ArrayList<String> arrayList = new ArrayList<String>(fieldMask.getPathsCount());
        for (String string : fieldMask.getPathsList()) {
            if (string.isEmpty()) continue;
            arrayList.add(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, string));
        }
        return Joiner.on((String)",").join(arrayList);
    }

    public static FieldMask fromJsonString(String string) {
        Iterable iterable = Splitter.on((String)",").split((CharSequence)string);
        FieldMask.Builder builder = FieldMask.newBuilder();
        for (String string2 : iterable) {
            if (string2.isEmpty()) continue;
            builder.addPaths(CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, string2));
        }
        return builder.build();
    }

    public static boolean isValid(Class<? extends Message> clazz, FieldMask fieldMask) {
        Descriptors.Descriptor descriptor = ((Message)Internal.getDefaultInstance(clazz)).getDescriptorForType();
        return FieldMaskUtil.isValid(descriptor, fieldMask);
    }

    public static boolean isValid(Descriptors.Descriptor descriptor, FieldMask fieldMask) {
        for (String string : fieldMask.getPathsList()) {
            if (FieldMaskUtil.isValid(descriptor, string)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValid(Class<? extends Message> clazz, String string) {
        Descriptors.Descriptor descriptor = ((Message)Internal.getDefaultInstance(clazz)).getDescriptorForType();
        return FieldMaskUtil.isValid(descriptor, string);
    }

    public static boolean isValid(Descriptors.Descriptor object, String string) {
        String[] stringArray = string.split(FIELD_SEPARATOR_REGEX);
        if (stringArray.length == 0) {
            return false;
        }
        for (String string2 : stringArray) {
            if (object == null) {
                return false;
            }
            Descriptors.FieldDescriptor fieldDescriptor = object.findFieldByName(string2);
            if (fieldDescriptor == null) {
                return false;
            }
            object = !fieldDescriptor.isRepeated() && fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE ? fieldDescriptor.getMessageType() : null;
        }
        return true;
    }

    public static FieldMask normalize(FieldMask fieldMask) {
        return new FieldMaskTree(fieldMask).toFieldMask();
    }

    public static FieldMask union(FieldMask fieldMask, FieldMask fieldMask2, FieldMask ... fieldMaskArray) {
        FieldMaskTree fieldMaskTree = new FieldMaskTree(fieldMask).mergeFromFieldMask(fieldMask2);
        for (FieldMask fieldMask3 : fieldMaskArray) {
            fieldMaskTree.mergeFromFieldMask(fieldMask3);
        }
        return fieldMaskTree.toFieldMask();
    }

    public static FieldMask intersection(FieldMask fieldMask, FieldMask fieldMask2) {
        FieldMaskTree fieldMaskTree = new FieldMaskTree(fieldMask);
        FieldMaskTree fieldMaskTree2 = new FieldMaskTree();
        for (String string : fieldMask2.getPathsList()) {
            fieldMaskTree.intersectFieldPath(string, fieldMaskTree2);
        }
        return fieldMaskTree2.toFieldMask();
    }

    public static void merge(FieldMask fieldMask, Message message, Message.Builder builder, MergeOptions mergeOptions) {
        new FieldMaskTree(fieldMask).merge(message, builder, mergeOptions);
    }

    public static void merge(FieldMask fieldMask, Message message, Message.Builder builder) {
        FieldMaskUtil.merge(fieldMask, message, builder, new MergeOptions());
    }

    public static final class MergeOptions {
        private boolean replaceMessageFields = false;
        private boolean replaceRepeatedFields = false;
        private boolean replacePrimitiveFields = false;

        public boolean replaceMessageFields() {
            return this.replaceMessageFields;
        }

        public boolean replaceRepeatedFields() {
            return this.replaceRepeatedFields;
        }

        public boolean replacePrimitiveFields() {
            return this.replacePrimitiveFields;
        }

        public MergeOptions setReplaceMessageFields(boolean bl) {
            this.replaceMessageFields = bl;
            return this;
        }

        public MergeOptions setReplaceRepeatedFields(boolean bl) {
            this.replaceRepeatedFields = bl;
            return this;
        }

        public MergeOptions setReplacePrimitiveFields(boolean bl) {
            this.replacePrimitiveFields = bl;
            return this;
        }
    }
}

